// Generated by Construct 3, the game and app creator :: https://www.construct.net
// ../3rdparty/glmatrix.js
/*
 @fileoverview gl-matrix - High performance matrix and vector operations
@author Brandon Jones
@author Colin MacKenzie IV
@version 3.3.0

Copyright (c) 2015-2020, Brandon Jones, Colin MacKenzie IV.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

*/
'use strict';(function(global,factory){typeof exports==="object"&&typeof module!=="undefined"?factory(exports):typeof define==="function"&&define.amd?define(["exports"],factory):(global=global||self,factory(global.glMatrix={}))})(this,function(exports){var EPSILON=1E-6;var ARRAY_TYPE=typeof Float32Array!=="undefined"?Float32Array:Array;var RANDOM=Math.random;function setMatrixArrayType(type){ARRAY_TYPE=type}var degree=Math.PI/180;function toRadian(a){return a*degree}function equals(a,b){return Math.abs(a-
b)<=EPSILON*Math.max(1,Math.abs(a),Math.abs(b))}if(!Math.hypot)Math.hypot=function(){var y=0,i=arguments.length;while(i--)y+=arguments[i]*arguments[i];return Math.sqrt(y)};var common=Object.freeze({__proto__:null,EPSILON:EPSILON,get ARRAY_TYPE(){return ARRAY_TYPE},RANDOM:RANDOM,setMatrixArrayType:setMatrixArrayType,toRadian:toRadian,equals:equals});function create(){var out=new ARRAY_TYPE(4);if(ARRAY_TYPE!=Float32Array){out[1]=0;out[2]=0}out[0]=1;out[3]=1;return out}function clone(a){var out=new ARRAY_TYPE(4);
out[0]=a[0];out[1]=a[1];out[2]=a[2];out[3]=a[3];return out}function copy(out,a){out[0]=a[0];out[1]=a[1];out[2]=a[2];out[3]=a[3];return out}function identity(out){out[0]=1;out[1]=0;out[2]=0;out[3]=1;return out}function fromValues(m00,m01,m10,m11){var out=new ARRAY_TYPE(4);out[0]=m00;out[1]=m01;out[2]=m10;out[3]=m11;return out}function set(out,m00,m01,m10,m11){out[0]=m00;out[1]=m01;out[2]=m10;out[3]=m11;return out}function transpose(out,a){if(out===a){var a1=a[1];out[1]=a[2];out[2]=a1}else{out[0]=a[0];
out[1]=a[2];out[2]=a[1];out[3]=a[3]}return out}function invert(out,a){var a0=a[0],a1=a[1],a2=a[2],a3=a[3];var det=a0*a3-a2*a1;if(!det)return null;det=1/det;out[0]=a3*det;out[1]=-a1*det;out[2]=-a2*det;out[3]=a0*det;return out}function adjoint(out,a){var a0=a[0];out[0]=a[3];out[1]=-a[1];out[2]=-a[2];out[3]=a0;return out}function determinant(a){return a[0]*a[3]-a[2]*a[1]}function multiply(out,a,b){var a0=a[0],a1=a[1],a2=a[2],a3=a[3];var b0=b[0],b1=b[1],b2=b[2],b3=b[3];out[0]=a0*b0+a2*b1;out[1]=a1*b0+
a3*b1;out[2]=a0*b2+a2*b3;out[3]=a1*b2+a3*b3;return out}function rotate(out,a,rad){var a0=a[0],a1=a[1],a2=a[2],a3=a[3];var s=Math.sin(rad);var c=Math.cos(rad);out[0]=a0*c+a2*s;out[1]=a1*c+a3*s;out[2]=a0*-s+a2*c;out[3]=a1*-s+a3*c;return out}function scale(out,a,v){var a0=a[0],a1=a[1],a2=a[2],a3=a[3];var v0=v[0],v1=v[1];out[0]=a0*v0;out[1]=a1*v0;out[2]=a2*v1;out[3]=a3*v1;return out}function fromRotation(out,rad){var s=Math.sin(rad);var c=Math.cos(rad);out[0]=c;out[1]=s;out[2]=-s;out[3]=c;return out}
function fromScaling(out,v){out[0]=v[0];out[1]=0;out[2]=0;out[3]=v[1];return out}function str(a){return"mat2("+a[0]+", "+a[1]+", "+a[2]+", "+a[3]+")"}function frob(a){return Math.hypot(a[0],a[1],a[2],a[3])}function LDU(L,D,U,a){L[2]=a[2]/a[0];U[0]=a[0];U[1]=a[1];U[3]=a[3]-L[2]*U[1];return[L,D,U]}function add(out,a,b){out[0]=a[0]+b[0];out[1]=a[1]+b[1];out[2]=a[2]+b[2];out[3]=a[3]+b[3];return out}function subtract(out,a,b){out[0]=a[0]-b[0];out[1]=a[1]-b[1];out[2]=a[2]-b[2];out[3]=a[3]-b[3];return out}
function exactEquals(a,b){return a[0]===b[0]&&a[1]===b[1]&&a[2]===b[2]&&a[3]===b[3]}function equals$1(a,b){var a0=a[0],a1=a[1],a2=a[2],a3=a[3];var b0=b[0],b1=b[1],b2=b[2],b3=b[3];return Math.abs(a0-b0)<=EPSILON*Math.max(1,Math.abs(a0),Math.abs(b0))&&Math.abs(a1-b1)<=EPSILON*Math.max(1,Math.abs(a1),Math.abs(b1))&&Math.abs(a2-b2)<=EPSILON*Math.max(1,Math.abs(a2),Math.abs(b2))&&Math.abs(a3-b3)<=EPSILON*Math.max(1,Math.abs(a3),Math.abs(b3))}function multiplyScalar(out,a,b){out[0]=a[0]*b;out[1]=a[1]*b;
out[2]=a[2]*b;out[3]=a[3]*b;return out}function multiplyScalarAndAdd(out,a,b,scale){out[0]=a[0]+b[0]*scale;out[1]=a[1]+b[1]*scale;out[2]=a[2]+b[2]*scale;out[3]=a[3]+b[3]*scale;return out}var mul=multiply;var sub=subtract;var mat2=Object.freeze({__proto__:null,create:create,clone:clone,copy:copy,identity:identity,fromValues:fromValues,set:set,transpose:transpose,invert:invert,adjoint:adjoint,determinant:determinant,multiply:multiply,rotate:rotate,scale:scale,fromRotation:fromRotation,fromScaling:fromScaling,
str:str,frob:frob,LDU:LDU,add:add,subtract:subtract,exactEquals:exactEquals,equals:equals$1,multiplyScalar:multiplyScalar,multiplyScalarAndAdd:multiplyScalarAndAdd,mul:mul,sub:sub});function create$1(){var out=new ARRAY_TYPE(6);if(ARRAY_TYPE!=Float32Array){out[1]=0;out[2]=0;out[4]=0;out[5]=0}out[0]=1;out[3]=1;return out}function clone$1(a){var out=new ARRAY_TYPE(6);out[0]=a[0];out[1]=a[1];out[2]=a[2];out[3]=a[3];out[4]=a[4];out[5]=a[5];return out}function copy$1(out,a){out[0]=a[0];out[1]=a[1];out[2]=
a[2];out[3]=a[3];out[4]=a[4];out[5]=a[5];return out}function identity$1(out){out[0]=1;out[1]=0;out[2]=0;out[3]=1;out[4]=0;out[5]=0;return out}function fromValues$1(a,b,c,d,tx,ty){var out=new ARRAY_TYPE(6);out[0]=a;out[1]=b;out[2]=c;out[3]=d;out[4]=tx;out[5]=ty;return out}function set$1(out,a,b,c,d,tx,ty){out[0]=a;out[1]=b;out[2]=c;out[3]=d;out[4]=tx;out[5]=ty;return out}function invert$1(out,a){var aa=a[0],ab=a[1],ac=a[2],ad=a[3];var atx=a[4],aty=a[5];var det=aa*ad-ab*ac;if(!det)return null;det=1/
det;out[0]=ad*det;out[1]=-ab*det;out[2]=-ac*det;out[3]=aa*det;out[4]=(ac*aty-ad*atx)*det;out[5]=(ab*atx-aa*aty)*det;return out}function determinant$1(a){return a[0]*a[3]-a[1]*a[2]}function multiply$1(out,a,b){var a0=a[0],a1=a[1],a2=a[2],a3=a[3],a4=a[4],a5=a[5];var b0=b[0],b1=b[1],b2=b[2],b3=b[3],b4=b[4],b5=b[5];out[0]=a0*b0+a2*b1;out[1]=a1*b0+a3*b1;out[2]=a0*b2+a2*b3;out[3]=a1*b2+a3*b3;out[4]=a0*b4+a2*b5+a4;out[5]=a1*b4+a3*b5+a5;return out}function rotate$1(out,a,rad){var a0=a[0],a1=a[1],a2=a[2],
a3=a[3],a4=a[4],a5=a[5];var s=Math.sin(rad);var c=Math.cos(rad);out[0]=a0*c+a2*s;out[1]=a1*c+a3*s;out[2]=a0*-s+a2*c;out[3]=a1*-s+a3*c;out[4]=a4;out[5]=a5;return out}function scale$1(out,a,v){var a0=a[0],a1=a[1],a2=a[2],a3=a[3],a4=a[4],a5=a[5];var v0=v[0],v1=v[1];out[0]=a0*v0;out[1]=a1*v0;out[2]=a2*v1;out[3]=a3*v1;out[4]=a4;out[5]=a5;return out}function translate(out,a,v){var a0=a[0],a1=a[1],a2=a[2],a3=a[3],a4=a[4],a5=a[5];var v0=v[0],v1=v[1];out[0]=a0;out[1]=a1;out[2]=a2;out[3]=a3;out[4]=a0*v0+a2*
v1+a4;out[5]=a1*v0+a3*v1+a5;return out}function fromRotation$1(out,rad){var s=Math.sin(rad),c=Math.cos(rad);out[0]=c;out[1]=s;out[2]=-s;out[3]=c;out[4]=0;out[5]=0;return out}function fromScaling$1(out,v){out[0]=v[0];out[1]=0;out[2]=0;out[3]=v[1];out[4]=0;out[5]=0;return out}function fromTranslation(out,v){out[0]=1;out[1]=0;out[2]=0;out[3]=1;out[4]=v[0];out[5]=v[1];return out}function str$1(a){return"mat2d("+a[0]+", "+a[1]+", "+a[2]+", "+a[3]+", "+a[4]+", "+a[5]+")"}function frob$1(a){return Math.hypot(a[0],
a[1],a[2],a[3],a[4],a[5],1)}function add$1(out,a,b){out[0]=a[0]+b[0];out[1]=a[1]+b[1];out[2]=a[2]+b[2];out[3]=a[3]+b[3];out[4]=a[4]+b[4];out[5]=a[5]+b[5];return out}function subtract$1(out,a,b){out[0]=a[0]-b[0];out[1]=a[1]-b[1];out[2]=a[2]-b[2];out[3]=a[3]-b[3];out[4]=a[4]-b[4];out[5]=a[5]-b[5];return out}function multiplyScalar$1(out,a,b){out[0]=a[0]*b;out[1]=a[1]*b;out[2]=a[2]*b;out[3]=a[3]*b;out[4]=a[4]*b;out[5]=a[5]*b;return out}function multiplyScalarAndAdd$1(out,a,b,scale){out[0]=a[0]+b[0]*
scale;out[1]=a[1]+b[1]*scale;out[2]=a[2]+b[2]*scale;out[3]=a[3]+b[3]*scale;out[4]=a[4]+b[4]*scale;out[5]=a[5]+b[5]*scale;return out}function exactEquals$1(a,b){return a[0]===b[0]&&a[1]===b[1]&&a[2]===b[2]&&a[3]===b[3]&&a[4]===b[4]&&a[5]===b[5]}function equals$2(a,b){var a0=a[0],a1=a[1],a2=a[2],a3=a[3],a4=a[4],a5=a[5];var b0=b[0],b1=b[1],b2=b[2],b3=b[3],b4=b[4],b5=b[5];return Math.abs(a0-b0)<=EPSILON*Math.max(1,Math.abs(a0),Math.abs(b0))&&Math.abs(a1-b1)<=EPSILON*Math.max(1,Math.abs(a1),Math.abs(b1))&&
Math.abs(a2-b2)<=EPSILON*Math.max(1,Math.abs(a2),Math.abs(b2))&&Math.abs(a3-b3)<=EPSILON*Math.max(1,Math.abs(a3),Math.abs(b3))&&Math.abs(a4-b4)<=EPSILON*Math.max(1,Math.abs(a4),Math.abs(b4))&&Math.abs(a5-b5)<=EPSILON*Math.max(1,Math.abs(a5),Math.abs(b5))}var mul$1=multiply$1;var sub$1=subtract$1;var mat2d=Object.freeze({__proto__:null,create:create$1,clone:clone$1,copy:copy$1,identity:identity$1,fromValues:fromValues$1,set:set$1,invert:invert$1,determinant:determinant$1,multiply:multiply$1,rotate:rotate$1,
scale:scale$1,translate:translate,fromRotation:fromRotation$1,fromScaling:fromScaling$1,fromTranslation:fromTranslation,str:str$1,frob:frob$1,add:add$1,subtract:subtract$1,multiplyScalar:multiplyScalar$1,multiplyScalarAndAdd:multiplyScalarAndAdd$1,exactEquals:exactEquals$1,equals:equals$2,mul:mul$1,sub:sub$1});function create$2(){var out=new ARRAY_TYPE(9);if(ARRAY_TYPE!=Float32Array){out[1]=0;out[2]=0;out[3]=0;out[5]=0;out[6]=0;out[7]=0}out[0]=1;out[4]=1;out[8]=1;return out}function fromMat4(out,
a){out[0]=a[0];out[1]=a[1];out[2]=a[2];out[3]=a[4];out[4]=a[5];out[5]=a[6];out[6]=a[8];out[7]=a[9];out[8]=a[10];return out}function clone$2(a){var out=new ARRAY_TYPE(9);out[0]=a[0];out[1]=a[1];out[2]=a[2];out[3]=a[3];out[4]=a[4];out[5]=a[5];out[6]=a[6];out[7]=a[7];out[8]=a[8];return out}function copy$2(out,a){out[0]=a[0];out[1]=a[1];out[2]=a[2];out[3]=a[3];out[4]=a[4];out[5]=a[5];out[6]=a[6];out[7]=a[7];out[8]=a[8];return out}function fromValues$2(m00,m01,m02,m10,m11,m12,m20,m21,m22){var out=new ARRAY_TYPE(9);
out[0]=m00;out[1]=m01;out[2]=m02;out[3]=m10;out[4]=m11;out[5]=m12;out[6]=m20;out[7]=m21;out[8]=m22;return out}function set$2(out,m00,m01,m02,m10,m11,m12,m20,m21,m22){out[0]=m00;out[1]=m01;out[2]=m02;out[3]=m10;out[4]=m11;out[5]=m12;out[6]=m20;out[7]=m21;out[8]=m22;return out}function identity$2(out){out[0]=1;out[1]=0;out[2]=0;out[3]=0;out[4]=1;out[5]=0;out[6]=0;out[7]=0;out[8]=1;return out}function transpose$1(out,a){if(out===a){var a01=a[1],a02=a[2],a12=a[5];out[1]=a[3];out[2]=a[6];out[3]=a01;out[5]=
a[7];out[6]=a02;out[7]=a12}else{out[0]=a[0];out[1]=a[3];out[2]=a[6];out[3]=a[1];out[4]=a[4];out[5]=a[7];out[6]=a[2];out[7]=a[5];out[8]=a[8]}return out}function invert$2(out,a){var a00=a[0],a01=a[1],a02=a[2];var a10=a[3],a11=a[4],a12=a[5];var a20=a[6],a21=a[7],a22=a[8];var b01=a22*a11-a12*a21;var b11=-a22*a10+a12*a20;var b21=a21*a10-a11*a20;var det=a00*b01+a01*b11+a02*b21;if(!det)return null;det=1/det;out[0]=b01*det;out[1]=(-a22*a01+a02*a21)*det;out[2]=(a12*a01-a02*a11)*det;out[3]=b11*det;out[4]=(a22*
a00-a02*a20)*det;out[5]=(-a12*a00+a02*a10)*det;out[6]=b21*det;out[7]=(-a21*a00+a01*a20)*det;out[8]=(a11*a00-a01*a10)*det;return out}function adjoint$1(out,a){var a00=a[0],a01=a[1],a02=a[2];var a10=a[3],a11=a[4],a12=a[5];var a20=a[6],a21=a[7],a22=a[8];out[0]=a11*a22-a12*a21;out[1]=a02*a21-a01*a22;out[2]=a01*a12-a02*a11;out[3]=a12*a20-a10*a22;out[4]=a00*a22-a02*a20;out[5]=a02*a10-a00*a12;out[6]=a10*a21-a11*a20;out[7]=a01*a20-a00*a21;out[8]=a00*a11-a01*a10;return out}function determinant$2(a){var a00=
a[0],a01=a[1],a02=a[2];var a10=a[3],a11=a[4],a12=a[5];var a20=a[6],a21=a[7],a22=a[8];return a00*(a22*a11-a12*a21)+a01*(-a22*a10+a12*a20)+a02*(a21*a10-a11*a20)}function multiply$2(out,a,b){var a00=a[0],a01=a[1],a02=a[2];var a10=a[3],a11=a[4],a12=a[5];var a20=a[6],a21=a[7],a22=a[8];var b00=b[0],b01=b[1],b02=b[2];var b10=b[3],b11=b[4],b12=b[5];var b20=b[6],b21=b[7],b22=b[8];out[0]=b00*a00+b01*a10+b02*a20;out[1]=b00*a01+b01*a11+b02*a21;out[2]=b00*a02+b01*a12+b02*a22;out[3]=b10*a00+b11*a10+b12*a20;out[4]=
b10*a01+b11*a11+b12*a21;out[5]=b10*a02+b11*a12+b12*a22;out[6]=b20*a00+b21*a10+b22*a20;out[7]=b20*a01+b21*a11+b22*a21;out[8]=b20*a02+b21*a12+b22*a22;return out}function translate$1(out,a,v){var a00=a[0],a01=a[1],a02=a[2],a10=a[3],a11=a[4],a12=a[5],a20=a[6],a21=a[7],a22=a[8],x=v[0],y=v[1];out[0]=a00;out[1]=a01;out[2]=a02;out[3]=a10;out[4]=a11;out[5]=a12;out[6]=x*a00+y*a10+a20;out[7]=x*a01+y*a11+a21;out[8]=x*a02+y*a12+a22;return out}function rotate$2(out,a,rad){var a00=a[0],a01=a[1],a02=a[2],a10=a[3],
a11=a[4],a12=a[5],a20=a[6],a21=a[7],a22=a[8],s=Math.sin(rad),c=Math.cos(rad);out[0]=c*a00+s*a10;out[1]=c*a01+s*a11;out[2]=c*a02+s*a12;out[3]=c*a10-s*a00;out[4]=c*a11-s*a01;out[5]=c*a12-s*a02;out[6]=a20;out[7]=a21;out[8]=a22;return out}function scale$2(out,a,v){var x=v[0],y=v[1];out[0]=x*a[0];out[1]=x*a[1];out[2]=x*a[2];out[3]=y*a[3];out[4]=y*a[4];out[5]=y*a[5];out[6]=a[6];out[7]=a[7];out[8]=a[8];return out}function fromTranslation$1(out,v){out[0]=1;out[1]=0;out[2]=0;out[3]=0;out[4]=1;out[5]=0;out[6]=
v[0];out[7]=v[1];out[8]=1;return out}function fromRotation$2(out,rad){var s=Math.sin(rad),c=Math.cos(rad);out[0]=c;out[1]=s;out[2]=0;out[3]=-s;out[4]=c;out[5]=0;out[6]=0;out[7]=0;out[8]=1;return out}function fromScaling$2(out,v){out[0]=v[0];out[1]=0;out[2]=0;out[3]=0;out[4]=v[1];out[5]=0;out[6]=0;out[7]=0;out[8]=1;return out}function fromMat2d(out,a){out[0]=a[0];out[1]=a[1];out[2]=0;out[3]=a[2];out[4]=a[3];out[5]=0;out[6]=a[4];out[7]=a[5];out[8]=1;return out}function fromQuat(out,q){var x=q[0],y=
q[1],z=q[2],w=q[3];var x2=x+x;var y2=y+y;var z2=z+z;var xx=x*x2;var yx=y*x2;var yy=y*y2;var zx=z*x2;var zy=z*y2;var zz=z*z2;var wx=w*x2;var wy=w*y2;var wz=w*z2;out[0]=1-yy-zz;out[3]=yx-wz;out[6]=zx+wy;out[1]=yx+wz;out[4]=1-xx-zz;out[7]=zy-wx;out[2]=zx-wy;out[5]=zy+wx;out[8]=1-xx-yy;return out}function normalFromMat4(out,a){var a00=a[0],a01=a[1],a02=a[2],a03=a[3];var a10=a[4],a11=a[5],a12=a[6],a13=a[7];var a20=a[8],a21=a[9],a22=a[10],a23=a[11];var a30=a[12],a31=a[13],a32=a[14],a33=a[15];var b00=a00*
a11-a01*a10;var b01=a00*a12-a02*a10;var b02=a00*a13-a03*a10;var b03=a01*a12-a02*a11;var b04=a01*a13-a03*a11;var b05=a02*a13-a03*a12;var b06=a20*a31-a21*a30;var b07=a20*a32-a22*a30;var b08=a20*a33-a23*a30;var b09=a21*a32-a22*a31;var b10=a21*a33-a23*a31;var b11=a22*a33-a23*a32;var det=b00*b11-b01*b10+b02*b09+b03*b08-b04*b07+b05*b06;if(!det)return null;det=1/det;out[0]=(a11*b11-a12*b10+a13*b09)*det;out[1]=(a12*b08-a10*b11-a13*b07)*det;out[2]=(a10*b10-a11*b08+a13*b06)*det;out[3]=(a02*b10-a01*b11-a03*
b09)*det;out[4]=(a00*b11-a02*b08+a03*b07)*det;out[5]=(a01*b08-a00*b10-a03*b06)*det;out[6]=(a31*b05-a32*b04+a33*b03)*det;out[7]=(a32*b02-a30*b05-a33*b01)*det;out[8]=(a30*b04-a31*b02+a33*b00)*det;return out}function projection(out,width,height){out[0]=2/width;out[1]=0;out[2]=0;out[3]=0;out[4]=-2/height;out[5]=0;out[6]=-1;out[7]=1;out[8]=1;return out}function str$2(a){return"mat3("+a[0]+", "+a[1]+", "+a[2]+", "+a[3]+", "+a[4]+", "+a[5]+", "+a[6]+", "+a[7]+", "+a[8]+")"}function frob$2(a){return Math.hypot(a[0],
a[1],a[2],a[3],a[4],a[5],a[6],a[7],a[8])}function add$2(out,a,b){out[0]=a[0]+b[0];out[1]=a[1]+b[1];out[2]=a[2]+b[2];out[3]=a[3]+b[3];out[4]=a[4]+b[4];out[5]=a[5]+b[5];out[6]=a[6]+b[6];out[7]=a[7]+b[7];out[8]=a[8]+b[8];return out}function subtract$2(out,a,b){out[0]=a[0]-b[0];out[1]=a[1]-b[1];out[2]=a[2]-b[2];out[3]=a[3]-b[3];out[4]=a[4]-b[4];out[5]=a[5]-b[5];out[6]=a[6]-b[6];out[7]=a[7]-b[7];out[8]=a[8]-b[8];return out}function multiplyScalar$2(out,a,b){out[0]=a[0]*b;out[1]=a[1]*b;out[2]=a[2]*b;out[3]=
a[3]*b;out[4]=a[4]*b;out[5]=a[5]*b;out[6]=a[6]*b;out[7]=a[7]*b;out[8]=a[8]*b;return out}function multiplyScalarAndAdd$2(out,a,b,scale){out[0]=a[0]+b[0]*scale;out[1]=a[1]+b[1]*scale;out[2]=a[2]+b[2]*scale;out[3]=a[3]+b[3]*scale;out[4]=a[4]+b[4]*scale;out[5]=a[5]+b[5]*scale;out[6]=a[6]+b[6]*scale;out[7]=a[7]+b[7]*scale;out[8]=a[8]+b[8]*scale;return out}function exactEquals$2(a,b){return a[0]===b[0]&&a[1]===b[1]&&a[2]===b[2]&&a[3]===b[3]&&a[4]===b[4]&&a[5]===b[5]&&a[6]===b[6]&&a[7]===b[7]&&a[8]===b[8]}
function equals$3(a,b){var a0=a[0],a1=a[1],a2=a[2],a3=a[3],a4=a[4],a5=a[5],a6=a[6],a7=a[7],a8=a[8];var b0=b[0],b1=b[1],b2=b[2],b3=b[3],b4=b[4],b5=b[5],b6=b[6],b7=b[7],b8=b[8];return Math.abs(a0-b0)<=EPSILON*Math.max(1,Math.abs(a0),Math.abs(b0))&&Math.abs(a1-b1)<=EPSILON*Math.max(1,Math.abs(a1),Math.abs(b1))&&Math.abs(a2-b2)<=EPSILON*Math.max(1,Math.abs(a2),Math.abs(b2))&&Math.abs(a3-b3)<=EPSILON*Math.max(1,Math.abs(a3),Math.abs(b3))&&Math.abs(a4-b4)<=EPSILON*Math.max(1,Math.abs(a4),Math.abs(b4))&&
Math.abs(a5-b5)<=EPSILON*Math.max(1,Math.abs(a5),Math.abs(b5))&&Math.abs(a6-b6)<=EPSILON*Math.max(1,Math.abs(a6),Math.abs(b6))&&Math.abs(a7-b7)<=EPSILON*Math.max(1,Math.abs(a7),Math.abs(b7))&&Math.abs(a8-b8)<=EPSILON*Math.max(1,Math.abs(a8),Math.abs(b8))}var mul$2=multiply$2;var sub$2=subtract$2;var mat3=Object.freeze({__proto__:null,create:create$2,fromMat4:fromMat4,clone:clone$2,copy:copy$2,fromValues:fromValues$2,set:set$2,identity:identity$2,transpose:transpose$1,invert:invert$2,adjoint:adjoint$1,
determinant:determinant$2,multiply:multiply$2,translate:translate$1,rotate:rotate$2,scale:scale$2,fromTranslation:fromTranslation$1,fromRotation:fromRotation$2,fromScaling:fromScaling$2,fromMat2d:fromMat2d,fromQuat:fromQuat,normalFromMat4:normalFromMat4,projection:projection,str:str$2,frob:frob$2,add:add$2,subtract:subtract$2,multiplyScalar:multiplyScalar$2,multiplyScalarAndAdd:multiplyScalarAndAdd$2,exactEquals:exactEquals$2,equals:equals$3,mul:mul$2,sub:sub$2});function create$3(){var out=new ARRAY_TYPE(16);
if(ARRAY_TYPE!=Float32Array){out[1]=0;out[2]=0;out[3]=0;out[4]=0;out[6]=0;out[7]=0;out[8]=0;out[9]=0;out[11]=0;out[12]=0;out[13]=0;out[14]=0}out[0]=1;out[5]=1;out[10]=1;out[15]=1;return out}function clone$3(a){var out=new ARRAY_TYPE(16);out[0]=a[0];out[1]=a[1];out[2]=a[2];out[3]=a[3];out[4]=a[4];out[5]=a[5];out[6]=a[6];out[7]=a[7];out[8]=a[8];out[9]=a[9];out[10]=a[10];out[11]=a[11];out[12]=a[12];out[13]=a[13];out[14]=a[14];out[15]=a[15];return out}function copy$3(out,a){out[0]=a[0];out[1]=a[1];out[2]=
a[2];out[3]=a[3];out[4]=a[4];out[5]=a[5];out[6]=a[6];out[7]=a[7];out[8]=a[8];out[9]=a[9];out[10]=a[10];out[11]=a[11];out[12]=a[12];out[13]=a[13];out[14]=a[14];out[15]=a[15];return out}function fromValues$3(m00,m01,m02,m03,m10,m11,m12,m13,m20,m21,m22,m23,m30,m31,m32,m33){var out=new ARRAY_TYPE(16);out[0]=m00;out[1]=m01;out[2]=m02;out[3]=m03;out[4]=m10;out[5]=m11;out[6]=m12;out[7]=m13;out[8]=m20;out[9]=m21;out[10]=m22;out[11]=m23;out[12]=m30;out[13]=m31;out[14]=m32;out[15]=m33;return out}function set$3(out,
m00,m01,m02,m03,m10,m11,m12,m13,m20,m21,m22,m23,m30,m31,m32,m33){out[0]=m00;out[1]=m01;out[2]=m02;out[3]=m03;out[4]=m10;out[5]=m11;out[6]=m12;out[7]=m13;out[8]=m20;out[9]=m21;out[10]=m22;out[11]=m23;out[12]=m30;out[13]=m31;out[14]=m32;out[15]=m33;return out}function identity$3(out){out[0]=1;out[1]=0;out[2]=0;out[3]=0;out[4]=0;out[5]=1;out[6]=0;out[7]=0;out[8]=0;out[9]=0;out[10]=1;out[11]=0;out[12]=0;out[13]=0;out[14]=0;out[15]=1;return out}function transpose$2(out,a){if(out===a){var a01=a[1],a02=
a[2],a03=a[3];var a12=a[6],a13=a[7];var a23=a[11];out[1]=a[4];out[2]=a[8];out[3]=a[12];out[4]=a01;out[6]=a[9];out[7]=a[13];out[8]=a02;out[9]=a12;out[11]=a[14];out[12]=a03;out[13]=a13;out[14]=a23}else{out[0]=a[0];out[1]=a[4];out[2]=a[8];out[3]=a[12];out[4]=a[1];out[5]=a[5];out[6]=a[9];out[7]=a[13];out[8]=a[2];out[9]=a[6];out[10]=a[10];out[11]=a[14];out[12]=a[3];out[13]=a[7];out[14]=a[11];out[15]=a[15]}return out}function invert$3(out,a){var a00=a[0],a01=a[1],a02=a[2],a03=a[3];var a10=a[4],a11=a[5],
a12=a[6],a13=a[7];var a20=a[8],a21=a[9],a22=a[10],a23=a[11];var a30=a[12],a31=a[13],a32=a[14],a33=a[15];var b00=a00*a11-a01*a10;var b01=a00*a12-a02*a10;var b02=a00*a13-a03*a10;var b03=a01*a12-a02*a11;var b04=a01*a13-a03*a11;var b05=a02*a13-a03*a12;var b06=a20*a31-a21*a30;var b07=a20*a32-a22*a30;var b08=a20*a33-a23*a30;var b09=a21*a32-a22*a31;var b10=a21*a33-a23*a31;var b11=a22*a33-a23*a32;var det=b00*b11-b01*b10+b02*b09+b03*b08-b04*b07+b05*b06;if(!det)return null;det=1/det;out[0]=(a11*b11-a12*b10+
a13*b09)*det;out[1]=(a02*b10-a01*b11-a03*b09)*det;out[2]=(a31*b05-a32*b04+a33*b03)*det;out[3]=(a22*b04-a21*b05-a23*b03)*det;out[4]=(a12*b08-a10*b11-a13*b07)*det;out[5]=(a00*b11-a02*b08+a03*b07)*det;out[6]=(a32*b02-a30*b05-a33*b01)*det;out[7]=(a20*b05-a22*b02+a23*b01)*det;out[8]=(a10*b10-a11*b08+a13*b06)*det;out[9]=(a01*b08-a00*b10-a03*b06)*det;out[10]=(a30*b04-a31*b02+a33*b00)*det;out[11]=(a21*b02-a20*b04-a23*b00)*det;out[12]=(a11*b07-a10*b09-a12*b06)*det;out[13]=(a00*b09-a01*b07+a02*b06)*det;out[14]=
(a31*b01-a30*b03-a32*b00)*det;out[15]=(a20*b03-a21*b01+a22*b00)*det;return out}function adjoint$2(out,a){var a00=a[0],a01=a[1],a02=a[2],a03=a[3];var a10=a[4],a11=a[5],a12=a[6],a13=a[7];var a20=a[8],a21=a[9],a22=a[10],a23=a[11];var a30=a[12],a31=a[13],a32=a[14],a33=a[15];out[0]=a11*(a22*a33-a23*a32)-a21*(a12*a33-a13*a32)+a31*(a12*a23-a13*a22);out[1]=-(a01*(a22*a33-a23*a32)-a21*(a02*a33-a03*a32)+a31*(a02*a23-a03*a22));out[2]=a01*(a12*a33-a13*a32)-a11*(a02*a33-a03*a32)+a31*(a02*a13-a03*a12);out[3]=-(a01*
(a12*a23-a13*a22)-a11*(a02*a23-a03*a22)+a21*(a02*a13-a03*a12));out[4]=-(a10*(a22*a33-a23*a32)-a20*(a12*a33-a13*a32)+a30*(a12*a23-a13*a22));out[5]=a00*(a22*a33-a23*a32)-a20*(a02*a33-a03*a32)+a30*(a02*a23-a03*a22);out[6]=-(a00*(a12*a33-a13*a32)-a10*(a02*a33-a03*a32)+a30*(a02*a13-a03*a12));out[7]=a00*(a12*a23-a13*a22)-a10*(a02*a23-a03*a22)+a20*(a02*a13-a03*a12);out[8]=a10*(a21*a33-a23*a31)-a20*(a11*a33-a13*a31)+a30*(a11*a23-a13*a21);out[9]=-(a00*(a21*a33-a23*a31)-a20*(a01*a33-a03*a31)+a30*(a01*a23-a03*
a21));out[10]=a00*(a11*a33-a13*a31)-a10*(a01*a33-a03*a31)+a30*(a01*a13-a03*a11);out[11]=-(a00*(a11*a23-a13*a21)-a10*(a01*a23-a03*a21)+a20*(a01*a13-a03*a11));out[12]=-(a10*(a21*a32-a22*a31)-a20*(a11*a32-a12*a31)+a30*(a11*a22-a12*a21));out[13]=a00*(a21*a32-a22*a31)-a20*(a01*a32-a02*a31)+a30*(a01*a22-a02*a21);out[14]=-(a00*(a11*a32-a12*a31)-a10*(a01*a32-a02*a31)+a30*(a01*a12-a02*a11));out[15]=a00*(a11*a22-a12*a21)-a10*(a01*a22-a02*a21)+a20*(a01*a12-a02*a11);return out}function determinant$3(a){var a00=
a[0],a01=a[1],a02=a[2],a03=a[3];var a10=a[4],a11=a[5],a12=a[6],a13=a[7];var a20=a[8],a21=a[9],a22=a[10],a23=a[11];var a30=a[12],a31=a[13],a32=a[14],a33=a[15];var b00=a00*a11-a01*a10;var b01=a00*a12-a02*a10;var b02=a00*a13-a03*a10;var b03=a01*a12-a02*a11;var b04=a01*a13-a03*a11;var b05=a02*a13-a03*a12;var b06=a20*a31-a21*a30;var b07=a20*a32-a22*a30;var b08=a20*a33-a23*a30;var b09=a21*a32-a22*a31;var b10=a21*a33-a23*a31;var b11=a22*a33-a23*a32;return b00*b11-b01*b10+b02*b09+b03*b08-b04*b07+b05*b06}
function multiply$3(out,a,b){var a00=a[0],a01=a[1],a02=a[2],a03=a[3];var a10=a[4],a11=a[5],a12=a[6],a13=a[7];var a20=a[8],a21=a[9],a22=a[10],a23=a[11];var a30=a[12],a31=a[13],a32=a[14],a33=a[15];var b0=b[0],b1=b[1],b2=b[2],b3=b[3];out[0]=b0*a00+b1*a10+b2*a20+b3*a30;out[1]=b0*a01+b1*a11+b2*a21+b3*a31;out[2]=b0*a02+b1*a12+b2*a22+b3*a32;out[3]=b0*a03+b1*a13+b2*a23+b3*a33;b0=b[4];b1=b[5];b2=b[6];b3=b[7];out[4]=b0*a00+b1*a10+b2*a20+b3*a30;out[5]=b0*a01+b1*a11+b2*a21+b3*a31;out[6]=b0*a02+b1*a12+b2*a22+
b3*a32;out[7]=b0*a03+b1*a13+b2*a23+b3*a33;b0=b[8];b1=b[9];b2=b[10];b3=b[11];out[8]=b0*a00+b1*a10+b2*a20+b3*a30;out[9]=b0*a01+b1*a11+b2*a21+b3*a31;out[10]=b0*a02+b1*a12+b2*a22+b3*a32;out[11]=b0*a03+b1*a13+b2*a23+b3*a33;b0=b[12];b1=b[13];b2=b[14];b3=b[15];out[12]=b0*a00+b1*a10+b2*a20+b3*a30;out[13]=b0*a01+b1*a11+b2*a21+b3*a31;out[14]=b0*a02+b1*a12+b2*a22+b3*a32;out[15]=b0*a03+b1*a13+b2*a23+b3*a33;return out}function translate$2(out,a,v){var x=v[0],y=v[1],z=v[2];var a00,a01,a02,a03;var a10,a11,a12,a13;
var a20,a21,a22,a23;if(a===out){out[12]=a[0]*x+a[4]*y+a[8]*z+a[12];out[13]=a[1]*x+a[5]*y+a[9]*z+a[13];out[14]=a[2]*x+a[6]*y+a[10]*z+a[14];out[15]=a[3]*x+a[7]*y+a[11]*z+a[15]}else{a00=a[0];a01=a[1];a02=a[2];a03=a[3];a10=a[4];a11=a[5];a12=a[6];a13=a[7];a20=a[8];a21=a[9];a22=a[10];a23=a[11];out[0]=a00;out[1]=a01;out[2]=a02;out[3]=a03;out[4]=a10;out[5]=a11;out[6]=a12;out[7]=a13;out[8]=a20;out[9]=a21;out[10]=a22;out[11]=a23;out[12]=a00*x+a10*y+a20*z+a[12];out[13]=a01*x+a11*y+a21*z+a[13];out[14]=a02*x+
a12*y+a22*z+a[14];out[15]=a03*x+a13*y+a23*z+a[15]}return out}function scale$3(out,a,v){var x=v[0],y=v[1],z=v[2];out[0]=a[0]*x;out[1]=a[1]*x;out[2]=a[2]*x;out[3]=a[3]*x;out[4]=a[4]*y;out[5]=a[5]*y;out[6]=a[6]*y;out[7]=a[7]*y;out[8]=a[8]*z;out[9]=a[9]*z;out[10]=a[10]*z;out[11]=a[11]*z;out[12]=a[12];out[13]=a[13];out[14]=a[14];out[15]=a[15];return out}function rotate$3(out,a,rad,axis){var x=axis[0],y=axis[1],z=axis[2];var len=Math.hypot(x,y,z);var s,c,t;var a00,a01,a02,a03;var a10,a11,a12,a13;var a20,
a21,a22,a23;var b00,b01,b02;var b10,b11,b12;var b20,b21,b22;if(len<EPSILON)return null;len=1/len;x*=len;y*=len;z*=len;s=Math.sin(rad);c=Math.cos(rad);t=1-c;a00=a[0];a01=a[1];a02=a[2];a03=a[3];a10=a[4];a11=a[5];a12=a[6];a13=a[7];a20=a[8];a21=a[9];a22=a[10];a23=a[11];b00=x*x*t+c;b01=y*x*t+z*s;b02=z*x*t-y*s;b10=x*y*t-z*s;b11=y*y*t+c;b12=z*y*t+x*s;b20=x*z*t+y*s;b21=y*z*t-x*s;b22=z*z*t+c;out[0]=a00*b00+a10*b01+a20*b02;out[1]=a01*b00+a11*b01+a21*b02;out[2]=a02*b00+a12*b01+a22*b02;out[3]=a03*b00+a13*b01+
a23*b02;out[4]=a00*b10+a10*b11+a20*b12;out[5]=a01*b10+a11*b11+a21*b12;out[6]=a02*b10+a12*b11+a22*b12;out[7]=a03*b10+a13*b11+a23*b12;out[8]=a00*b20+a10*b21+a20*b22;out[9]=a01*b20+a11*b21+a21*b22;out[10]=a02*b20+a12*b21+a22*b22;out[11]=a03*b20+a13*b21+a23*b22;if(a!==out){out[12]=a[12];out[13]=a[13];out[14]=a[14];out[15]=a[15]}return out}function rotateX(out,a,rad){var s=Math.sin(rad);var c=Math.cos(rad);var a10=a[4];var a11=a[5];var a12=a[6];var a13=a[7];var a20=a[8];var a21=a[9];var a22=a[10];var a23=
a[11];if(a!==out){out[0]=a[0];out[1]=a[1];out[2]=a[2];out[3]=a[3];out[12]=a[12];out[13]=a[13];out[14]=a[14];out[15]=a[15]}out[4]=a10*c+a20*s;out[5]=a11*c+a21*s;out[6]=a12*c+a22*s;out[7]=a13*c+a23*s;out[8]=a20*c-a10*s;out[9]=a21*c-a11*s;out[10]=a22*c-a12*s;out[11]=a23*c-a13*s;return out}function rotateY(out,a,rad){var s=Math.sin(rad);var c=Math.cos(rad);var a00=a[0];var a01=a[1];var a02=a[2];var a03=a[3];var a20=a[8];var a21=a[9];var a22=a[10];var a23=a[11];if(a!==out){out[4]=a[4];out[5]=a[5];out[6]=
a[6];out[7]=a[7];out[12]=a[12];out[13]=a[13];out[14]=a[14];out[15]=a[15]}out[0]=a00*c-a20*s;out[1]=a01*c-a21*s;out[2]=a02*c-a22*s;out[3]=a03*c-a23*s;out[8]=a00*s+a20*c;out[9]=a01*s+a21*c;out[10]=a02*s+a22*c;out[11]=a03*s+a23*c;return out}function rotateZ(out,a,rad){var s=Math.sin(rad);var c=Math.cos(rad);var a00=a[0];var a01=a[1];var a02=a[2];var a03=a[3];var a10=a[4];var a11=a[5];var a12=a[6];var a13=a[7];if(a!==out){out[8]=a[8];out[9]=a[9];out[10]=a[10];out[11]=a[11];out[12]=a[12];out[13]=a[13];
out[14]=a[14];out[15]=a[15]}out[0]=a00*c+a10*s;out[1]=a01*c+a11*s;out[2]=a02*c+a12*s;out[3]=a03*c+a13*s;out[4]=a10*c-a00*s;out[5]=a11*c-a01*s;out[6]=a12*c-a02*s;out[7]=a13*c-a03*s;return out}function fromTranslation$2(out,v){out[0]=1;out[1]=0;out[2]=0;out[3]=0;out[4]=0;out[5]=1;out[6]=0;out[7]=0;out[8]=0;out[9]=0;out[10]=1;out[11]=0;out[12]=v[0];out[13]=v[1];out[14]=v[2];out[15]=1;return out}function fromScaling$3(out,v){out[0]=v[0];out[1]=0;out[2]=0;out[3]=0;out[4]=0;out[5]=v[1];out[6]=0;out[7]=
0;out[8]=0;out[9]=0;out[10]=v[2];out[11]=0;out[12]=0;out[13]=0;out[14]=0;out[15]=1;return out}function fromRotation$3(out,rad,axis){var x=axis[0],y=axis[1],z=axis[2];var len=Math.hypot(x,y,z);var s,c,t;if(len<EPSILON)return null;len=1/len;x*=len;y*=len;z*=len;s=Math.sin(rad);c=Math.cos(rad);t=1-c;out[0]=x*x*t+c;out[1]=y*x*t+z*s;out[2]=z*x*t-y*s;out[3]=0;out[4]=x*y*t-z*s;out[5]=y*y*t+c;out[6]=z*y*t+x*s;out[7]=0;out[8]=x*z*t+y*s;out[9]=y*z*t-x*s;out[10]=z*z*t+c;out[11]=0;out[12]=0;out[13]=0;out[14]=
0;out[15]=1;return out}function fromXRotation(out,rad){var s=Math.sin(rad);var c=Math.cos(rad);out[0]=1;out[1]=0;out[2]=0;out[3]=0;out[4]=0;out[5]=c;out[6]=s;out[7]=0;out[8]=0;out[9]=-s;out[10]=c;out[11]=0;out[12]=0;out[13]=0;out[14]=0;out[15]=1;return out}function fromYRotation(out,rad){var s=Math.sin(rad);var c=Math.cos(rad);out[0]=c;out[1]=0;out[2]=-s;out[3]=0;out[4]=0;out[5]=1;out[6]=0;out[7]=0;out[8]=s;out[9]=0;out[10]=c;out[11]=0;out[12]=0;out[13]=0;out[14]=0;out[15]=1;return out}function fromZRotation(out,
rad){var s=Math.sin(rad);var c=Math.cos(rad);out[0]=c;out[1]=s;out[2]=0;out[3]=0;out[4]=-s;out[5]=c;out[6]=0;out[7]=0;out[8]=0;out[9]=0;out[10]=1;out[11]=0;out[12]=0;out[13]=0;out[14]=0;out[15]=1;return out}function fromRotationTranslation(out,q,v){var x=q[0],y=q[1],z=q[2],w=q[3];var x2=x+x;var y2=y+y;var z2=z+z;var xx=x*x2;var xy=x*y2;var xz=x*z2;var yy=y*y2;var yz=y*z2;var zz=z*z2;var wx=w*x2;var wy=w*y2;var wz=w*z2;out[0]=1-(yy+zz);out[1]=xy+wz;out[2]=xz-wy;out[3]=0;out[4]=xy-wz;out[5]=1-(xx+zz);
out[6]=yz+wx;out[7]=0;out[8]=xz+wy;out[9]=yz-wx;out[10]=1-(xx+yy);out[11]=0;out[12]=v[0];out[13]=v[1];out[14]=v[2];out[15]=1;return out}function fromQuat2(out,a){var translation=new ARRAY_TYPE(3);var bx=-a[0],by=-a[1],bz=-a[2],bw=a[3],ax=a[4],ay=a[5],az=a[6],aw=a[7];var magnitude=bx*bx+by*by+bz*bz+bw*bw;if(magnitude>0){translation[0]=(ax*bw+aw*bx+ay*bz-az*by)*2/magnitude;translation[1]=(ay*bw+aw*by+az*bx-ax*bz)*2/magnitude;translation[2]=(az*bw+aw*bz+ax*by-ay*bx)*2/magnitude}else{translation[0]=(ax*
bw+aw*bx+ay*bz-az*by)*2;translation[1]=(ay*bw+aw*by+az*bx-ax*bz)*2;translation[2]=(az*bw+aw*bz+ax*by-ay*bx)*2}fromRotationTranslation(out,a,translation);return out}function getTranslation(out,mat){out[0]=mat[12];out[1]=mat[13];out[2]=mat[14];return out}function getScaling(out,mat){var m11=mat[0];var m12=mat[1];var m13=mat[2];var m21=mat[4];var m22=mat[5];var m23=mat[6];var m31=mat[8];var m32=mat[9];var m33=mat[10];out[0]=Math.hypot(m11,m12,m13);out[1]=Math.hypot(m21,m22,m23);out[2]=Math.hypot(m31,
m32,m33);return out}function getRotation(out,mat){var scaling=new ARRAY_TYPE(3);getScaling(scaling,mat);var is1=1/scaling[0];var is2=1/scaling[1];var is3=1/scaling[2];var sm11=mat[0]*is1;var sm12=mat[1]*is2;var sm13=mat[2]*is3;var sm21=mat[4]*is1;var sm22=mat[5]*is2;var sm23=mat[6]*is3;var sm31=mat[8]*is1;var sm32=mat[9]*is2;var sm33=mat[10]*is3;var trace=sm11+sm22+sm33;var S=0;if(trace>0){S=Math.sqrt(trace+1)*2;out[3]=.25*S;out[0]=(sm23-sm32)/S;out[1]=(sm31-sm13)/S;out[2]=(sm12-sm21)/S}else if(sm11>
sm22&&sm11>sm33){S=Math.sqrt(1+sm11-sm22-sm33)*2;out[3]=(sm23-sm32)/S;out[0]=.25*S;out[1]=(sm12+sm21)/S;out[2]=(sm31+sm13)/S}else if(sm22>sm33){S=Math.sqrt(1+sm22-sm11-sm33)*2;out[3]=(sm31-sm13)/S;out[0]=(sm12+sm21)/S;out[1]=.25*S;out[2]=(sm23+sm32)/S}else{S=Math.sqrt(1+sm33-sm11-sm22)*2;out[3]=(sm12-sm21)/S;out[0]=(sm31+sm13)/S;out[1]=(sm23+sm32)/S;out[2]=.25*S}return out}function fromRotationTranslationScale(out,q,v,s){var x=q[0],y=q[1],z=q[2],w=q[3];var x2=x+x;var y2=y+y;var z2=z+z;var xx=x*x2;
var xy=x*y2;var xz=x*z2;var yy=y*y2;var yz=y*z2;var zz=z*z2;var wx=w*x2;var wy=w*y2;var wz=w*z2;var sx=s[0];var sy=s[1];var sz=s[2];out[0]=(1-(yy+zz))*sx;out[1]=(xy+wz)*sx;out[2]=(xz-wy)*sx;out[3]=0;out[4]=(xy-wz)*sy;out[5]=(1-(xx+zz))*sy;out[6]=(yz+wx)*sy;out[7]=0;out[8]=(xz+wy)*sz;out[9]=(yz-wx)*sz;out[10]=(1-(xx+yy))*sz;out[11]=0;out[12]=v[0];out[13]=v[1];out[14]=v[2];out[15]=1;return out}function fromRotationTranslationScaleOrigin(out,q,v,s,o){var x=q[0],y=q[1],z=q[2],w=q[3];var x2=x+x;var y2=
y+y;var z2=z+z;var xx=x*x2;var xy=x*y2;var xz=x*z2;var yy=y*y2;var yz=y*z2;var zz=z*z2;var wx=w*x2;var wy=w*y2;var wz=w*z2;var sx=s[0];var sy=s[1];var sz=s[2];var ox=o[0];var oy=o[1];var oz=o[2];var out0=(1-(yy+zz))*sx;var out1=(xy+wz)*sx;var out2=(xz-wy)*sx;var out4=(xy-wz)*sy;var out5=(1-(xx+zz))*sy;var out6=(yz+wx)*sy;var out8=(xz+wy)*sz;var out9=(yz-wx)*sz;var out10=(1-(xx+yy))*sz;out[0]=out0;out[1]=out1;out[2]=out2;out[3]=0;out[4]=out4;out[5]=out5;out[6]=out6;out[7]=0;out[8]=out8;out[9]=out9;
out[10]=out10;out[11]=0;out[12]=v[0]+ox-(out0*ox+out4*oy+out8*oz);out[13]=v[1]+oy-(out1*ox+out5*oy+out9*oz);out[14]=v[2]+oz-(out2*ox+out6*oy+out10*oz);out[15]=1;return out}function fromQuat$1(out,q){var x=q[0],y=q[1],z=q[2],w=q[3];var x2=x+x;var y2=y+y;var z2=z+z;var xx=x*x2;var yx=y*x2;var yy=y*y2;var zx=z*x2;var zy=z*y2;var zz=z*z2;var wx=w*x2;var wy=w*y2;var wz=w*z2;out[0]=1-yy-zz;out[1]=yx+wz;out[2]=zx-wy;out[3]=0;out[4]=yx-wz;out[5]=1-xx-zz;out[6]=zy+wx;out[7]=0;out[8]=zx+wy;out[9]=zy-wx;out[10]=
1-xx-yy;out[11]=0;out[12]=0;out[13]=0;out[14]=0;out[15]=1;return out}function frustum(out,left,right,bottom,top,near,far){var rl=1/(right-left);var tb=1/(top-bottom);var nf=1/(near-far);out[0]=near*2*rl;out[1]=0;out[2]=0;out[3]=0;out[4]=0;out[5]=near*2*tb;out[6]=0;out[7]=0;out[8]=(right+left)*rl;out[9]=(top+bottom)*tb;out[10]=(far+near)*nf;out[11]=-1;out[12]=0;out[13]=0;out[14]=far*near*2*nf;out[15]=0;return out}function perspective(out,fovy,aspect,near,far){var f=1/Math.tan(fovy/2),nf;out[0]=f/aspect;
out[1]=0;out[2]=0;out[3]=0;out[4]=0;out[5]=f;out[6]=0;out[7]=0;out[8]=0;out[9]=0;out[11]=-1;out[12]=0;out[13]=0;out[15]=0;if(far!=null&&far!==Infinity){nf=1/(near-far);out[10]=(far+near)*nf;out[14]=2*far*near*nf}else{out[10]=-1;out[14]=-2*near}return out}function perspectiveFromFieldOfView(out,fov,near,far){var upTan=Math.tan(fov.upDegrees*Math.PI/180);var downTan=Math.tan(fov.downDegrees*Math.PI/180);var leftTan=Math.tan(fov.leftDegrees*Math.PI/180);var rightTan=Math.tan(fov.rightDegrees*Math.PI/
180);var xScale=2/(leftTan+rightTan);var yScale=2/(upTan+downTan);out[0]=xScale;out[1]=0;out[2]=0;out[3]=0;out[4]=0;out[5]=yScale;out[6]=0;out[7]=0;out[8]=-((leftTan-rightTan)*xScale*.5);out[9]=(upTan-downTan)*yScale*.5;out[10]=far/(near-far);out[11]=-1;out[12]=0;out[13]=0;out[14]=far*near/(near-far);out[15]=0;return out}function ortho(out,left,right,bottom,top,near,far){var lr=1/(left-right);var bt=1/(bottom-top);var nf=1/(near-far);out[0]=-2*lr;out[1]=0;out[2]=0;out[3]=0;out[4]=0;out[5]=-2*bt;out[6]=
0;out[7]=0;out[8]=0;out[9]=0;out[10]=2*nf;out[11]=0;out[12]=(left+right)*lr;out[13]=(top+bottom)*bt;out[14]=(far+near)*nf;out[15]=1;return out}function lookAt(out,eye,center,up){var x0,x1,x2,y0,y1,y2,z0,z1,z2,len;var eyex=eye[0];var eyey=eye[1];var eyez=eye[2];var upx=up[0];var upy=up[1];var upz=up[2];var centerx=center[0];var centery=center[1];var centerz=center[2];if(Math.abs(eyex-centerx)<EPSILON&&Math.abs(eyey-centery)<EPSILON&&Math.abs(eyez-centerz)<EPSILON)return identity$3(out);z0=eyex-centerx;
z1=eyey-centery;z2=eyez-centerz;len=1/Math.hypot(z0,z1,z2);z0*=len;z1*=len;z2*=len;x0=upy*z2-upz*z1;x1=upz*z0-upx*z2;x2=upx*z1-upy*z0;len=Math.hypot(x0,x1,x2);if(!len){x0=0;x1=0;x2=0}else{len=1/len;x0*=len;x1*=len;x2*=len}y0=z1*x2-z2*x1;y1=z2*x0-z0*x2;y2=z0*x1-z1*x0;len=Math.hypot(y0,y1,y2);if(!len){y0=0;y1=0;y2=0}else{len=1/len;y0*=len;y1*=len;y2*=len}out[0]=x0;out[1]=y0;out[2]=z0;out[3]=0;out[4]=x1;out[5]=y1;out[6]=z1;out[7]=0;out[8]=x2;out[9]=y2;out[10]=z2;out[11]=0;out[12]=-(x0*eyex+x1*eyey+x2*
eyez);out[13]=-(y0*eyex+y1*eyey+y2*eyez);out[14]=-(z0*eyex+z1*eyey+z2*eyez);out[15]=1;return out}function targetTo(out,eye,target,up){var eyex=eye[0],eyey=eye[1],eyez=eye[2],upx=up[0],upy=up[1],upz=up[2];var z0=eyex-target[0],z1=eyey-target[1],z2=eyez-target[2];var len=z0*z0+z1*z1+z2*z2;if(len>0){len=1/Math.sqrt(len);z0*=len;z1*=len;z2*=len}var x0=upy*z2-upz*z1,x1=upz*z0-upx*z2,x2=upx*z1-upy*z0;len=x0*x0+x1*x1+x2*x2;if(len>0){len=1/Math.sqrt(len);x0*=len;x1*=len;x2*=len}out[0]=x0;out[1]=x1;out[2]=
x2;out[3]=0;out[4]=z1*x2-z2*x1;out[5]=z2*x0-z0*x2;out[6]=z0*x1-z1*x0;out[7]=0;out[8]=z0;out[9]=z1;out[10]=z2;out[11]=0;out[12]=eyex;out[13]=eyey;out[14]=eyez;out[15]=1;return out}function str$3(a){return"mat4("+a[0]+", "+a[1]+", "+a[2]+", "+a[3]+", "+a[4]+", "+a[5]+", "+a[6]+", "+a[7]+", "+a[8]+", "+a[9]+", "+a[10]+", "+a[11]+", "+a[12]+", "+a[13]+", "+a[14]+", "+a[15]+")"}function frob$3(a){return Math.hypot(a[0],a[1],a[2],a[3],a[4],a[5],a[6],a[7],a[8],a[9],a[10],a[11],a[12],a[13],a[14],a[15])}function add$3(out,
a,b){out[0]=a[0]+b[0];out[1]=a[1]+b[1];out[2]=a[2]+b[2];out[3]=a[3]+b[3];out[4]=a[4]+b[4];out[5]=a[5]+b[5];out[6]=a[6]+b[6];out[7]=a[7]+b[7];out[8]=a[8]+b[8];out[9]=a[9]+b[9];out[10]=a[10]+b[10];out[11]=a[11]+b[11];out[12]=a[12]+b[12];out[13]=a[13]+b[13];out[14]=a[14]+b[14];out[15]=a[15]+b[15];return out}function subtract$3(out,a,b){out[0]=a[0]-b[0];out[1]=a[1]-b[1];out[2]=a[2]-b[2];out[3]=a[3]-b[3];out[4]=a[4]-b[4];out[5]=a[5]-b[5];out[6]=a[6]-b[6];out[7]=a[7]-b[7];out[8]=a[8]-b[8];out[9]=a[9]-b[9];
out[10]=a[10]-b[10];out[11]=a[11]-b[11];out[12]=a[12]-b[12];out[13]=a[13]-b[13];out[14]=a[14]-b[14];out[15]=a[15]-b[15];return out}function multiplyScalar$3(out,a,b){out[0]=a[0]*b;out[1]=a[1]*b;out[2]=a[2]*b;out[3]=a[3]*b;out[4]=a[4]*b;out[5]=a[5]*b;out[6]=a[6]*b;out[7]=a[7]*b;out[8]=a[8]*b;out[9]=a[9]*b;out[10]=a[10]*b;out[11]=a[11]*b;out[12]=a[12]*b;out[13]=a[13]*b;out[14]=a[14]*b;out[15]=a[15]*b;return out}function multiplyScalarAndAdd$3(out,a,b,scale){out[0]=a[0]+b[0]*scale;out[1]=a[1]+b[1]*scale;
out[2]=a[2]+b[2]*scale;out[3]=a[3]+b[3]*scale;out[4]=a[4]+b[4]*scale;out[5]=a[5]+b[5]*scale;out[6]=a[6]+b[6]*scale;out[7]=a[7]+b[7]*scale;out[8]=a[8]+b[8]*scale;out[9]=a[9]+b[9]*scale;out[10]=a[10]+b[10]*scale;out[11]=a[11]+b[11]*scale;out[12]=a[12]+b[12]*scale;out[13]=a[13]+b[13]*scale;out[14]=a[14]+b[14]*scale;out[15]=a[15]+b[15]*scale;return out}function exactEquals$3(a,b){return a[0]===b[0]&&a[1]===b[1]&&a[2]===b[2]&&a[3]===b[3]&&a[4]===b[4]&&a[5]===b[5]&&a[6]===b[6]&&a[7]===b[7]&&a[8]===b[8]&&
a[9]===b[9]&&a[10]===b[10]&&a[11]===b[11]&&a[12]===b[12]&&a[13]===b[13]&&a[14]===b[14]&&a[15]===b[15]}function equals$4(a,b){var a0=a[0],a1=a[1],a2=a[2],a3=a[3];var a4=a[4],a5=a[5],a6=a[6],a7=a[7];var a8=a[8],a9=a[9],a10=a[10],a11=a[11];var a12=a[12],a13=a[13],a14=a[14],a15=a[15];var b0=b[0],b1=b[1],b2=b[2],b3=b[3];var b4=b[4],b5=b[5],b6=b[6],b7=b[7];var b8=b[8],b9=b[9],b10=b[10],b11=b[11];var b12=b[12],b13=b[13],b14=b[14],b15=b[15];return Math.abs(a0-b0)<=EPSILON*Math.max(1,Math.abs(a0),Math.abs(b0))&&
Math.abs(a1-b1)<=EPSILON*Math.max(1,Math.abs(a1),Math.abs(b1))&&Math.abs(a2-b2)<=EPSILON*Math.max(1,Math.abs(a2),Math.abs(b2))&&Math.abs(a3-b3)<=EPSILON*Math.max(1,Math.abs(a3),Math.abs(b3))&&Math.abs(a4-b4)<=EPSILON*Math.max(1,Math.abs(a4),Math.abs(b4))&&Math.abs(a5-b5)<=EPSILON*Math.max(1,Math.abs(a5),Math.abs(b5))&&Math.abs(a6-b6)<=EPSILON*Math.max(1,Math.abs(a6),Math.abs(b6))&&Math.abs(a7-b7)<=EPSILON*Math.max(1,Math.abs(a7),Math.abs(b7))&&Math.abs(a8-b8)<=EPSILON*Math.max(1,Math.abs(a8),Math.abs(b8))&&
Math.abs(a9-b9)<=EPSILON*Math.max(1,Math.abs(a9),Math.abs(b9))&&Math.abs(a10-b10)<=EPSILON*Math.max(1,Math.abs(a10),Math.abs(b10))&&Math.abs(a11-b11)<=EPSILON*Math.max(1,Math.abs(a11),Math.abs(b11))&&Math.abs(a12-b12)<=EPSILON*Math.max(1,Math.abs(a12),Math.abs(b12))&&Math.abs(a13-b13)<=EPSILON*Math.max(1,Math.abs(a13),Math.abs(b13))&&Math.abs(a14-b14)<=EPSILON*Math.max(1,Math.abs(a14),Math.abs(b14))&&Math.abs(a15-b15)<=EPSILON*Math.max(1,Math.abs(a15),Math.abs(b15))}var mul$3=multiply$3;var sub$3=
subtract$3;var mat4=Object.freeze({__proto__:null,create:create$3,clone:clone$3,copy:copy$3,fromValues:fromValues$3,set:set$3,identity:identity$3,transpose:transpose$2,invert:invert$3,adjoint:adjoint$2,determinant:determinant$3,multiply:multiply$3,translate:translate$2,scale:scale$3,rotate:rotate$3,rotateX:rotateX,rotateY:rotateY,rotateZ:rotateZ,fromTranslation:fromTranslation$2,fromScaling:fromScaling$3,fromRotation:fromRotation$3,fromXRotation:fromXRotation,fromYRotation:fromYRotation,fromZRotation:fromZRotation,
fromRotationTranslation:fromRotationTranslation,fromQuat2:fromQuat2,getTranslation:getTranslation,getScaling:getScaling,getRotation:getRotation,fromRotationTranslationScale:fromRotationTranslationScale,fromRotationTranslationScaleOrigin:fromRotationTranslationScaleOrigin,fromQuat:fromQuat$1,frustum:frustum,perspective:perspective,perspectiveFromFieldOfView:perspectiveFromFieldOfView,ortho:ortho,lookAt:lookAt,targetTo:targetTo,str:str$3,frob:frob$3,add:add$3,subtract:subtract$3,multiplyScalar:multiplyScalar$3,
multiplyScalarAndAdd:multiplyScalarAndAdd$3,exactEquals:exactEquals$3,equals:equals$4,mul:mul$3,sub:sub$3});function create$4(){var out=new ARRAY_TYPE(3);if(ARRAY_TYPE!=Float32Array){out[0]=0;out[1]=0;out[2]=0}return out}function clone$4(a){var out=new ARRAY_TYPE(3);out[0]=a[0];out[1]=a[1];out[2]=a[2];return out}function length(a){var x=a[0];var y=a[1];var z=a[2];return Math.hypot(x,y,z)}function fromValues$4(x,y,z){var out=new ARRAY_TYPE(3);out[0]=x;out[1]=y;out[2]=z;return out}function copy$4(out,
a){out[0]=a[0];out[1]=a[1];out[2]=a[2];return out}function set$4(out,x,y,z){out[0]=x;out[1]=y;out[2]=z;return out}function add$4(out,a,b){out[0]=a[0]+b[0];out[1]=a[1]+b[1];out[2]=a[2]+b[2];return out}function subtract$4(out,a,b){out[0]=a[0]-b[0];out[1]=a[1]-b[1];out[2]=a[2]-b[2];return out}function multiply$4(out,a,b){out[0]=a[0]*b[0];out[1]=a[1]*b[1];out[2]=a[2]*b[2];return out}function divide(out,a,b){out[0]=a[0]/b[0];out[1]=a[1]/b[1];out[2]=a[2]/b[2];return out}function ceil(out,a){out[0]=Math.ceil(a[0]);
out[1]=Math.ceil(a[1]);out[2]=Math.ceil(a[2]);return out}function floor(out,a){out[0]=Math.floor(a[0]);out[1]=Math.floor(a[1]);out[2]=Math.floor(a[2]);return out}function min(out,a,b){out[0]=Math.min(a[0],b[0]);out[1]=Math.min(a[1],b[1]);out[2]=Math.min(a[2],b[2]);return out}function max(out,a,b){out[0]=Math.max(a[0],b[0]);out[1]=Math.max(a[1],b[1]);out[2]=Math.max(a[2],b[2]);return out}function round(out,a){out[0]=Math.round(a[0]);out[1]=Math.round(a[1]);out[2]=Math.round(a[2]);return out}function scale$4(out,
a,b){out[0]=a[0]*b;out[1]=a[1]*b;out[2]=a[2]*b;return out}function scaleAndAdd(out,a,b,scale){out[0]=a[0]+b[0]*scale;out[1]=a[1]+b[1]*scale;out[2]=a[2]+b[2]*scale;return out}function distance(a,b){var x=b[0]-a[0];var y=b[1]-a[1];var z=b[2]-a[2];return Math.hypot(x,y,z)}function squaredDistance(a,b){var x=b[0]-a[0];var y=b[1]-a[1];var z=b[2]-a[2];return x*x+y*y+z*z}function squaredLength(a){var x=a[0];var y=a[1];var z=a[2];return x*x+y*y+z*z}function negate(out,a){out[0]=-a[0];out[1]=-a[1];out[2]=
-a[2];return out}function inverse(out,a){out[0]=1/a[0];out[1]=1/a[1];out[2]=1/a[2];return out}function normalize(out,a){var x=a[0];var y=a[1];var z=a[2];var len=x*x+y*y+z*z;if(len>0)len=1/Math.sqrt(len);out[0]=a[0]*len;out[1]=a[1]*len;out[2]=a[2]*len;return out}function dot(a,b){return a[0]*b[0]+a[1]*b[1]+a[2]*b[2]}function cross(out,a,b){var ax=a[0],ay=a[1],az=a[2];var bx=b[0],by=b[1],bz=b[2];out[0]=ay*bz-az*by;out[1]=az*bx-ax*bz;out[2]=ax*by-ay*bx;return out}function lerp(out,a,b,t){var ax=a[0];
var ay=a[1];var az=a[2];out[0]=ax+t*(b[0]-ax);out[1]=ay+t*(b[1]-ay);out[2]=az+t*(b[2]-az);return out}function hermite(out,a,b,c,d,t){var factorTimes2=t*t;var factor1=factorTimes2*(2*t-3)+1;var factor2=factorTimes2*(t-2)+t;var factor3=factorTimes2*(t-1);var factor4=factorTimes2*(3-2*t);out[0]=a[0]*factor1+b[0]*factor2+c[0]*factor3+d[0]*factor4;out[1]=a[1]*factor1+b[1]*factor2+c[1]*factor3+d[1]*factor4;out[2]=a[2]*factor1+b[2]*factor2+c[2]*factor3+d[2]*factor4;return out}function bezier(out,a,b,c,d,
t){var inverseFactor=1-t;var inverseFactorTimesTwo=inverseFactor*inverseFactor;var factorTimes2=t*t;var factor1=inverseFactorTimesTwo*inverseFactor;var factor2=3*t*inverseFactorTimesTwo;var factor3=3*factorTimes2*inverseFactor;var factor4=factorTimes2*t;out[0]=a[0]*factor1+b[0]*factor2+c[0]*factor3+d[0]*factor4;out[1]=a[1]*factor1+b[1]*factor2+c[1]*factor3+d[1]*factor4;out[2]=a[2]*factor1+b[2]*factor2+c[2]*factor3+d[2]*factor4;return out}function random(out,scale){scale=scale||1;var r=RANDOM()*2*
Math.PI;var z=RANDOM()*2-1;var zScale=Math.sqrt(1-z*z)*scale;out[0]=Math.cos(r)*zScale;out[1]=Math.sin(r)*zScale;out[2]=z*scale;return out}function transformMat4(out,a,m){var x=a[0],y=a[1],z=a[2];var w=m[3]*x+m[7]*y+m[11]*z+m[15];w=w||1;out[0]=(m[0]*x+m[4]*y+m[8]*z+m[12])/w;out[1]=(m[1]*x+m[5]*y+m[9]*z+m[13])/w;out[2]=(m[2]*x+m[6]*y+m[10]*z+m[14])/w;return out}function transformMat3(out,a,m){var x=a[0],y=a[1],z=a[2];out[0]=x*m[0]+y*m[3]+z*m[6];out[1]=x*m[1]+y*m[4]+z*m[7];out[2]=x*m[2]+y*m[5]+z*m[8];
return out}function transformQuat(out,a,q){var qx=q[0],qy=q[1],qz=q[2],qw=q[3];var x=a[0],y=a[1],z=a[2];var uvx=qy*z-qz*y,uvy=qz*x-qx*z,uvz=qx*y-qy*x;var uuvx=qy*uvz-qz*uvy,uuvy=qz*uvx-qx*uvz,uuvz=qx*uvy-qy*uvx;var w2=qw*2;uvx*=w2;uvy*=w2;uvz*=w2;uuvx*=2;uuvy*=2;uuvz*=2;out[0]=x+uvx+uuvx;out[1]=y+uvy+uuvy;out[2]=z+uvz+uuvz;return out}function rotateX$1(out,a,b,rad){var p=[],r=[];p[0]=a[0]-b[0];p[1]=a[1]-b[1];p[2]=a[2]-b[2];r[0]=p[0];r[1]=p[1]*Math.cos(rad)-p[2]*Math.sin(rad);r[2]=p[1]*Math.sin(rad)+
p[2]*Math.cos(rad);out[0]=r[0]+b[0];out[1]=r[1]+b[1];out[2]=r[2]+b[2];return out}function rotateY$1(out,a,b,rad){var p=[],r=[];p[0]=a[0]-b[0];p[1]=a[1]-b[1];p[2]=a[2]-b[2];r[0]=p[2]*Math.sin(rad)+p[0]*Math.cos(rad);r[1]=p[1];r[2]=p[2]*Math.cos(rad)-p[0]*Math.sin(rad);out[0]=r[0]+b[0];out[1]=r[1]+b[1];out[2]=r[2]+b[2];return out}function rotateZ$1(out,a,b,rad){var p=[],r=[];p[0]=a[0]-b[0];p[1]=a[1]-b[1];p[2]=a[2]-b[2];r[0]=p[0]*Math.cos(rad)-p[1]*Math.sin(rad);r[1]=p[0]*Math.sin(rad)+p[1]*Math.cos(rad);
r[2]=p[2];out[0]=r[0]+b[0];out[1]=r[1]+b[1];out[2]=r[2]+b[2];return out}function angle(a,b){var ax=a[0],ay=a[1],az=a[2],bx=b[0],by=b[1],bz=b[2],mag1=Math.sqrt(ax*ax+ay*ay+az*az),mag2=Math.sqrt(bx*bx+by*by+bz*bz),mag=mag1*mag2,cosine=mag&&dot(a,b)/mag;return Math.acos(Math.min(Math.max(cosine,-1),1))}function zero(out){out[0]=0;out[1]=0;out[2]=0;return out}function str$4(a){return"vec3("+a[0]+", "+a[1]+", "+a[2]+")"}function exactEquals$4(a,b){return a[0]===b[0]&&a[1]===b[1]&&a[2]===b[2]}function equals$5(a,
b){var a0=a[0],a1=a[1],a2=a[2];var b0=b[0],b1=b[1],b2=b[2];return Math.abs(a0-b0)<=EPSILON*Math.max(1,Math.abs(a0),Math.abs(b0))&&Math.abs(a1-b1)<=EPSILON*Math.max(1,Math.abs(a1),Math.abs(b1))&&Math.abs(a2-b2)<=EPSILON*Math.max(1,Math.abs(a2),Math.abs(b2))}var sub$4=subtract$4;var mul$4=multiply$4;var div=divide;var dist=distance;var sqrDist=squaredDistance;var len=length;var sqrLen=squaredLength;var forEach=function(){var vec=create$4();return function(a,stride,offset,count,fn,arg){var i,l;if(!stride)stride=
3;if(!offset)offset=0;if(count)l=Math.min(count*stride+offset,a.length);else l=a.length;for(i=offset;i<l;i+=stride){vec[0]=a[i];vec[1]=a[i+1];vec[2]=a[i+2];fn(vec,vec,arg);a[i]=vec[0];a[i+1]=vec[1];a[i+2]=vec[2]}return a}}();var vec3=Object.freeze({__proto__:null,create:create$4,clone:clone$4,length:length,fromValues:fromValues$4,copy:copy$4,set:set$4,add:add$4,subtract:subtract$4,multiply:multiply$4,divide:divide,ceil:ceil,floor:floor,min:min,max:max,round:round,scale:scale$4,scaleAndAdd:scaleAndAdd,
distance:distance,squaredDistance:squaredDistance,squaredLength:squaredLength,negate:negate,inverse:inverse,normalize:normalize,dot:dot,cross:cross,lerp:lerp,hermite:hermite,bezier:bezier,random:random,transformMat4:transformMat4,transformMat3:transformMat3,transformQuat:transformQuat,rotateX:rotateX$1,rotateY:rotateY$1,rotateZ:rotateZ$1,angle:angle,zero:zero,str:str$4,exactEquals:exactEquals$4,equals:equals$5,sub:sub$4,mul:mul$4,div:div,dist:dist,sqrDist:sqrDist,len:len,sqrLen:sqrLen,forEach:forEach});
function create$5(){var out=new ARRAY_TYPE(4);if(ARRAY_TYPE!=Float32Array){out[0]=0;out[1]=0;out[2]=0;out[3]=0}return out}function clone$5(a){var out=new ARRAY_TYPE(4);out[0]=a[0];out[1]=a[1];out[2]=a[2];out[3]=a[3];return out}function fromValues$5(x,y,z,w){var out=new ARRAY_TYPE(4);out[0]=x;out[1]=y;out[2]=z;out[3]=w;return out}function copy$5(out,a){out[0]=a[0];out[1]=a[1];out[2]=a[2];out[3]=a[3];return out}function set$5(out,x,y,z,w){out[0]=x;out[1]=y;out[2]=z;out[3]=w;return out}function add$5(out,
a,b){out[0]=a[0]+b[0];out[1]=a[1]+b[1];out[2]=a[2]+b[2];out[3]=a[3]+b[3];return out}function subtract$5(out,a,b){out[0]=a[0]-b[0];out[1]=a[1]-b[1];out[2]=a[2]-b[2];out[3]=a[3]-b[3];return out}function multiply$5(out,a,b){out[0]=a[0]*b[0];out[1]=a[1]*b[1];out[2]=a[2]*b[2];out[3]=a[3]*b[3];return out}function divide$1(out,a,b){out[0]=a[0]/b[0];out[1]=a[1]/b[1];out[2]=a[2]/b[2];out[3]=a[3]/b[3];return out}function ceil$1(out,a){out[0]=Math.ceil(a[0]);out[1]=Math.ceil(a[1]);out[2]=Math.ceil(a[2]);out[3]=
Math.ceil(a[3]);return out}function floor$1(out,a){out[0]=Math.floor(a[0]);out[1]=Math.floor(a[1]);out[2]=Math.floor(a[2]);out[3]=Math.floor(a[3]);return out}function min$1(out,a,b){out[0]=Math.min(a[0],b[0]);out[1]=Math.min(a[1],b[1]);out[2]=Math.min(a[2],b[2]);out[3]=Math.min(a[3],b[3]);return out}function max$1(out,a,b){out[0]=Math.max(a[0],b[0]);out[1]=Math.max(a[1],b[1]);out[2]=Math.max(a[2],b[2]);out[3]=Math.max(a[3],b[3]);return out}function round$1(out,a){out[0]=Math.round(a[0]);out[1]=Math.round(a[1]);
out[2]=Math.round(a[2]);out[3]=Math.round(a[3]);return out}function scale$5(out,a,b){out[0]=a[0]*b;out[1]=a[1]*b;out[2]=a[2]*b;out[3]=a[3]*b;return out}function scaleAndAdd$1(out,a,b,scale){out[0]=a[0]+b[0]*scale;out[1]=a[1]+b[1]*scale;out[2]=a[2]+b[2]*scale;out[3]=a[3]+b[3]*scale;return out}function distance$1(a,b){var x=b[0]-a[0];var y=b[1]-a[1];var z=b[2]-a[2];var w=b[3]-a[3];return Math.hypot(x,y,z,w)}function squaredDistance$1(a,b){var x=b[0]-a[0];var y=b[1]-a[1];var z=b[2]-a[2];var w=b[3]-a[3];
return x*x+y*y+z*z+w*w}function length$1(a){var x=a[0];var y=a[1];var z=a[2];var w=a[3];return Math.hypot(x,y,z,w)}function squaredLength$1(a){var x=a[0];var y=a[1];var z=a[2];var w=a[3];return x*x+y*y+z*z+w*w}function negate$1(out,a){out[0]=-a[0];out[1]=-a[1];out[2]=-a[2];out[3]=-a[3];return out}function inverse$1(out,a){out[0]=1/a[0];out[1]=1/a[1];out[2]=1/a[2];out[3]=1/a[3];return out}function normalize$1(out,a){var x=a[0];var y=a[1];var z=a[2];var w=a[3];var len=x*x+y*y+z*z+w*w;if(len>0)len=1/
Math.sqrt(len);out[0]=x*len;out[1]=y*len;out[2]=z*len;out[3]=w*len;return out}function dot$1(a,b){return a[0]*b[0]+a[1]*b[1]+a[2]*b[2]+a[3]*b[3]}function cross$1(out,u,v,w){var A=v[0]*w[1]-v[1]*w[0],B=v[0]*w[2]-v[2]*w[0],C=v[0]*w[3]-v[3]*w[0],D=v[1]*w[2]-v[2]*w[1],E=v[1]*w[3]-v[3]*w[1],F=v[2]*w[3]-v[3]*w[2];var G=u[0];var H=u[1];var I=u[2];var J=u[3];out[0]=H*F-I*E+J*D;out[1]=-(G*F)+I*C-J*B;out[2]=G*E-H*C+J*A;out[3]=-(G*D)+H*B-I*A;return out}function lerp$1(out,a,b,t){var ax=a[0];var ay=a[1];var az=
a[2];var aw=a[3];out[0]=ax+t*(b[0]-ax);out[1]=ay+t*(b[1]-ay);out[2]=az+t*(b[2]-az);out[3]=aw+t*(b[3]-aw);return out}function random$1(out,scale){scale=scale||1;var v1,v2,v3,v4;var s1,s2;do{v1=RANDOM()*2-1;v2=RANDOM()*2-1;s1=v1*v1+v2*v2}while(s1>=1);do{v3=RANDOM()*2-1;v4=RANDOM()*2-1;s2=v3*v3+v4*v4}while(s2>=1);var d=Math.sqrt((1-s1)/s2);out[0]=scale*v1;out[1]=scale*v2;out[2]=scale*v3*d;out[3]=scale*v4*d;return out}function transformMat4$1(out,a,m){var x=a[0],y=a[1],z=a[2],w=a[3];out[0]=m[0]*x+m[4]*
y+m[8]*z+m[12]*w;out[1]=m[1]*x+m[5]*y+m[9]*z+m[13]*w;out[2]=m[2]*x+m[6]*y+m[10]*z+m[14]*w;out[3]=m[3]*x+m[7]*y+m[11]*z+m[15]*w;return out}function transformQuat$1(out,a,q){var x=a[0],y=a[1],z=a[2];var qx=q[0],qy=q[1],qz=q[2],qw=q[3];var ix=qw*x+qy*z-qz*y;var iy=qw*y+qz*x-qx*z;var iz=qw*z+qx*y-qy*x;var iw=-qx*x-qy*y-qz*z;out[0]=ix*qw+iw*-qx+iy*-qz-iz*-qy;out[1]=iy*qw+iw*-qy+iz*-qx-ix*-qz;out[2]=iz*qw+iw*-qz+ix*-qy-iy*-qx;out[3]=a[3];return out}function zero$1(out){out[0]=0;out[1]=0;out[2]=0;out[3]=
0;return out}function str$5(a){return"vec4("+a[0]+", "+a[1]+", "+a[2]+", "+a[3]+")"}function exactEquals$5(a,b){return a[0]===b[0]&&a[1]===b[1]&&a[2]===b[2]&&a[3]===b[3]}function equals$6(a,b){var a0=a[0],a1=a[1],a2=a[2],a3=a[3];var b0=b[0],b1=b[1],b2=b[2],b3=b[3];return Math.abs(a0-b0)<=EPSILON*Math.max(1,Math.abs(a0),Math.abs(b0))&&Math.abs(a1-b1)<=EPSILON*Math.max(1,Math.abs(a1),Math.abs(b1))&&Math.abs(a2-b2)<=EPSILON*Math.max(1,Math.abs(a2),Math.abs(b2))&&Math.abs(a3-b3)<=EPSILON*Math.max(1,Math.abs(a3),
Math.abs(b3))}var sub$5=subtract$5;var mul$5=multiply$5;var div$1=divide$1;var dist$1=distance$1;var sqrDist$1=squaredDistance$1;var len$1=length$1;var sqrLen$1=squaredLength$1;var forEach$1=function(){var vec=create$5();return function(a,stride,offset,count,fn,arg){var i,l;if(!stride)stride=4;if(!offset)offset=0;if(count)l=Math.min(count*stride+offset,a.length);else l=a.length;for(i=offset;i<l;i+=stride){vec[0]=a[i];vec[1]=a[i+1];vec[2]=a[i+2];vec[3]=a[i+3];fn(vec,vec,arg);a[i]=vec[0];a[i+1]=vec[1];
a[i+2]=vec[2];a[i+3]=vec[3]}return a}}();var vec4=Object.freeze({__proto__:null,create:create$5,clone:clone$5,fromValues:fromValues$5,copy:copy$5,set:set$5,add:add$5,subtract:subtract$5,multiply:multiply$5,divide:divide$1,ceil:ceil$1,floor:floor$1,min:min$1,max:max$1,round:round$1,scale:scale$5,scaleAndAdd:scaleAndAdd$1,distance:distance$1,squaredDistance:squaredDistance$1,length:length$1,squaredLength:squaredLength$1,negate:negate$1,inverse:inverse$1,normalize:normalize$1,dot:dot$1,cross:cross$1,
lerp:lerp$1,random:random$1,transformMat4:transformMat4$1,transformQuat:transformQuat$1,zero:zero$1,str:str$5,exactEquals:exactEquals$5,equals:equals$6,sub:sub$5,mul:mul$5,div:div$1,dist:dist$1,sqrDist:sqrDist$1,len:len$1,sqrLen:sqrLen$1,forEach:forEach$1});function create$6(){var out=new ARRAY_TYPE(4);if(ARRAY_TYPE!=Float32Array){out[0]=0;out[1]=0;out[2]=0}out[3]=1;return out}function identity$4(out){out[0]=0;out[1]=0;out[2]=0;out[3]=1;return out}function setAxisAngle(out,axis,rad){rad=rad*.5;var s=
Math.sin(rad);out[0]=s*axis[0];out[1]=s*axis[1];out[2]=s*axis[2];out[3]=Math.cos(rad);return out}function getAxisAngle(out_axis,q){var rad=Math.acos(q[3])*2;var s=Math.sin(rad/2);if(s>EPSILON){out_axis[0]=q[0]/s;out_axis[1]=q[1]/s;out_axis[2]=q[2]/s}else{out_axis[0]=1;out_axis[1]=0;out_axis[2]=0}return rad}function getAngle(a,b){var dotproduct=dot$2(a,b);return Math.acos(2*dotproduct*dotproduct-1)}function multiply$6(out,a,b){var ax=a[0],ay=a[1],az=a[2],aw=a[3];var bx=b[0],by=b[1],bz=b[2],bw=b[3];
out[0]=ax*bw+aw*bx+ay*bz-az*by;out[1]=ay*bw+aw*by+az*bx-ax*bz;out[2]=az*bw+aw*bz+ax*by-ay*bx;out[3]=aw*bw-ax*bx-ay*by-az*bz;return out}function rotateX$2(out,a,rad){rad*=.5;var ax=a[0],ay=a[1],az=a[2],aw=a[3];var bx=Math.sin(rad),bw=Math.cos(rad);out[0]=ax*bw+aw*bx;out[1]=ay*bw+az*bx;out[2]=az*bw-ay*bx;out[3]=aw*bw-ax*bx;return out}function rotateY$2(out,a,rad){rad*=.5;var ax=a[0],ay=a[1],az=a[2],aw=a[3];var by=Math.sin(rad),bw=Math.cos(rad);out[0]=ax*bw-az*by;out[1]=ay*bw+aw*by;out[2]=az*bw+ax*by;
out[3]=aw*bw-ay*by;return out}function rotateZ$2(out,a,rad){rad*=.5;var ax=a[0],ay=a[1],az=a[2],aw=a[3];var bz=Math.sin(rad),bw=Math.cos(rad);out[0]=ax*bw+ay*bz;out[1]=ay*bw-ax*bz;out[2]=az*bw+aw*bz;out[3]=aw*bw-az*bz;return out}function calculateW(out,a){var x=a[0],y=a[1],z=a[2];out[0]=x;out[1]=y;out[2]=z;out[3]=Math.sqrt(Math.abs(1-x*x-y*y-z*z));return out}function exp(out,a){var x=a[0],y=a[1],z=a[2],w=a[3];var r=Math.sqrt(x*x+y*y+z*z);var et=Math.exp(w);var s=r>0?et*Math.sin(r)/r:0;out[0]=x*s;
out[1]=y*s;out[2]=z*s;out[3]=et*Math.cos(r);return out}function ln(out,a){var x=a[0],y=a[1],z=a[2],w=a[3];var r=Math.sqrt(x*x+y*y+z*z);var t=r>0?Math.atan2(r,w)/r:0;out[0]=x*t;out[1]=y*t;out[2]=z*t;out[3]=.5*Math.log(x*x+y*y+z*z+w*w);return out}function pow(out,a,b){ln(out,a);scale$6(out,out,b);exp(out,out);return out}function slerp(out,a,b,t){var ax=a[0],ay=a[1],az=a[2],aw=a[3];var bx=b[0],by=b[1],bz=b[2],bw=b[3];var omega,cosom,sinom,scale0,scale1;cosom=ax*bx+ay*by+az*bz+aw*bw;if(cosom<0){cosom=
-cosom;bx=-bx;by=-by;bz=-bz;bw=-bw}if(1-cosom>EPSILON){omega=Math.acos(cosom);sinom=Math.sin(omega);scale0=Math.sin((1-t)*omega)/sinom;scale1=Math.sin(t*omega)/sinom}else{scale0=1-t;scale1=t}out[0]=scale0*ax+scale1*bx;out[1]=scale0*ay+scale1*by;out[2]=scale0*az+scale1*bz;out[3]=scale0*aw+scale1*bw;return out}function random$2(out){var u1=RANDOM();var u2=RANDOM();var u3=RANDOM();var sqrt1MinusU1=Math.sqrt(1-u1);var sqrtU1=Math.sqrt(u1);out[0]=sqrt1MinusU1*Math.sin(2*Math.PI*u2);out[1]=sqrt1MinusU1*
Math.cos(2*Math.PI*u2);out[2]=sqrtU1*Math.sin(2*Math.PI*u3);out[3]=sqrtU1*Math.cos(2*Math.PI*u3);return out}function invert$4(out,a){var a0=a[0],a1=a[1],a2=a[2],a3=a[3];var dot=a0*a0+a1*a1+a2*a2+a3*a3;var invDot=dot?1/dot:0;out[0]=-a0*invDot;out[1]=-a1*invDot;out[2]=-a2*invDot;out[3]=a3*invDot;return out}function conjugate(out,a){out[0]=-a[0];out[1]=-a[1];out[2]=-a[2];out[3]=a[3];return out}function fromMat3(out,m){var fTrace=m[0]+m[4]+m[8];var fRoot;if(fTrace>0){fRoot=Math.sqrt(fTrace+1);out[3]=
.5*fRoot;fRoot=.5/fRoot;out[0]=(m[5]-m[7])*fRoot;out[1]=(m[6]-m[2])*fRoot;out[2]=(m[1]-m[3])*fRoot}else{var i=0;if(m[4]>m[0])i=1;if(m[8]>m[i*3+i])i=2;var j=(i+1)%3;var k=(i+2)%3;fRoot=Math.sqrt(m[i*3+i]-m[j*3+j]-m[k*3+k]+1);out[i]=.5*fRoot;fRoot=.5/fRoot;out[3]=(m[j*3+k]-m[k*3+j])*fRoot;out[j]=(m[j*3+i]+m[i*3+j])*fRoot;out[k]=(m[k*3+i]+m[i*3+k])*fRoot}return out}function fromEuler(out,x,y,z){var halfToRad=.5*Math.PI/180;x*=halfToRad;y*=halfToRad;z*=halfToRad;var sx=Math.sin(x);var cx=Math.cos(x);
var sy=Math.sin(y);var cy=Math.cos(y);var sz=Math.sin(z);var cz=Math.cos(z);out[0]=sx*cy*cz-cx*sy*sz;out[1]=cx*sy*cz+sx*cy*sz;out[2]=cx*cy*sz-sx*sy*cz;out[3]=cx*cy*cz+sx*sy*sz;return out}function str$6(a){return"quat("+a[0]+", "+a[1]+", "+a[2]+", "+a[3]+")"}var clone$6=clone$5;var fromValues$6=fromValues$5;var copy$6=copy$5;var set$6=set$5;var add$6=add$5;var mul$6=multiply$6;var scale$6=scale$5;var dot$2=dot$1;var lerp$2=lerp$1;var length$2=length$1;var len$2=length$2;var squaredLength$2=squaredLength$1;
var sqrLen$2=squaredLength$2;var normalize$2=normalize$1;var exactEquals$6=exactEquals$5;var equals$7=equals$6;var rotationTo=function(){var tmpvec3=create$4();var xUnitVec3=fromValues$4(1,0,0);var yUnitVec3=fromValues$4(0,1,0);return function(out,a,b){var dot$1=dot(a,b);if(dot$1<-.999999){cross(tmpvec3,xUnitVec3,a);if(len(tmpvec3)<1E-6)cross(tmpvec3,yUnitVec3,a);normalize(tmpvec3,tmpvec3);setAxisAngle(out,tmpvec3,Math.PI);return out}else if(dot$1>.999999){out[0]=0;out[1]=0;out[2]=0;out[3]=1;return out}else{cross(tmpvec3,
a,b);out[0]=tmpvec3[0];out[1]=tmpvec3[1];out[2]=tmpvec3[2];out[3]=1+dot$1;return normalize$2(out,out)}}}();var sqlerp=function(){var temp1=create$6();var temp2=create$6();return function(out,a,b,c,d,t){slerp(temp1,a,d,t);slerp(temp2,b,c,t);slerp(out,temp1,temp2,2*t*(1-t));return out}}();var setAxes=function(){var matr=create$2();return function(out,view,right,up){matr[0]=right[0];matr[3]=right[1];matr[6]=right[2];matr[1]=up[0];matr[4]=up[1];matr[7]=up[2];matr[2]=-view[0];matr[5]=-view[1];matr[8]=
-view[2];return normalize$2(out,fromMat3(out,matr))}}();var quat=Object.freeze({__proto__:null,create:create$6,identity:identity$4,setAxisAngle:setAxisAngle,getAxisAngle:getAxisAngle,getAngle:getAngle,multiply:multiply$6,rotateX:rotateX$2,rotateY:rotateY$2,rotateZ:rotateZ$2,calculateW:calculateW,exp:exp,ln:ln,pow:pow,slerp:slerp,random:random$2,invert:invert$4,conjugate:conjugate,fromMat3:fromMat3,fromEuler:fromEuler,str:str$6,clone:clone$6,fromValues:fromValues$6,copy:copy$6,set:set$6,add:add$6,
mul:mul$6,scale:scale$6,dot:dot$2,lerp:lerp$2,length:length$2,len:len$2,squaredLength:squaredLength$2,sqrLen:sqrLen$2,normalize:normalize$2,exactEquals:exactEquals$6,equals:equals$7,rotationTo:rotationTo,sqlerp:sqlerp,setAxes:setAxes});function create$7(){var dq=new ARRAY_TYPE(8);if(ARRAY_TYPE!=Float32Array){dq[0]=0;dq[1]=0;dq[2]=0;dq[4]=0;dq[5]=0;dq[6]=0;dq[7]=0}dq[3]=1;return dq}function clone$7(a){var dq=new ARRAY_TYPE(8);dq[0]=a[0];dq[1]=a[1];dq[2]=a[2];dq[3]=a[3];dq[4]=a[4];dq[5]=a[5];dq[6]=
a[6];dq[7]=a[7];return dq}function fromValues$7(x1,y1,z1,w1,x2,y2,z2,w2){var dq=new ARRAY_TYPE(8);dq[0]=x1;dq[1]=y1;dq[2]=z1;dq[3]=w1;dq[4]=x2;dq[5]=y2;dq[6]=z2;dq[7]=w2;return dq}function fromRotationTranslationValues(x1,y1,z1,w1,x2,y2,z2){var dq=new ARRAY_TYPE(8);dq[0]=x1;dq[1]=y1;dq[2]=z1;dq[3]=w1;var ax=x2*.5,ay=y2*.5,az=z2*.5;dq[4]=ax*w1+ay*z1-az*y1;dq[5]=ay*w1+az*x1-ax*z1;dq[6]=az*w1+ax*y1-ay*x1;dq[7]=-ax*x1-ay*y1-az*z1;return dq}function fromRotationTranslation$1(out,q,t){var ax=t[0]*.5,ay=
t[1]*.5,az=t[2]*.5,bx=q[0],by=q[1],bz=q[2],bw=q[3];out[0]=bx;out[1]=by;out[2]=bz;out[3]=bw;out[4]=ax*bw+ay*bz-az*by;out[5]=ay*bw+az*bx-ax*bz;out[6]=az*bw+ax*by-ay*bx;out[7]=-ax*bx-ay*by-az*bz;return out}function fromTranslation$3(out,t){out[0]=0;out[1]=0;out[2]=0;out[3]=1;out[4]=t[0]*.5;out[5]=t[1]*.5;out[6]=t[2]*.5;out[7]=0;return out}function fromRotation$4(out,q){out[0]=q[0];out[1]=q[1];out[2]=q[2];out[3]=q[3];out[4]=0;out[5]=0;out[6]=0;out[7]=0;return out}function fromMat4$1(out,a){var outer=
create$6();getRotation(outer,a);var t=new ARRAY_TYPE(3);getTranslation(t,a);fromRotationTranslation$1(out,outer,t);return out}function copy$7(out,a){out[0]=a[0];out[1]=a[1];out[2]=a[2];out[3]=a[3];out[4]=a[4];out[5]=a[5];out[6]=a[6];out[7]=a[7];return out}function identity$5(out){out[0]=0;out[1]=0;out[2]=0;out[3]=1;out[4]=0;out[5]=0;out[6]=0;out[7]=0;return out}function set$7(out,x1,y1,z1,w1,x2,y2,z2,w2){out[0]=x1;out[1]=y1;out[2]=z1;out[3]=w1;out[4]=x2;out[5]=y2;out[6]=z2;out[7]=w2;return out}var getReal=
copy$6;function getDual(out,a){out[0]=a[4];out[1]=a[5];out[2]=a[6];out[3]=a[7];return out}var setReal=copy$6;function setDual(out,q){out[4]=q[0];out[5]=q[1];out[6]=q[2];out[7]=q[3];return out}function getTranslation$1(out,a){var ax=a[4],ay=a[5],az=a[6],aw=a[7],bx=-a[0],by=-a[1],bz=-a[2],bw=a[3];out[0]=(ax*bw+aw*bx+ay*bz-az*by)*2;out[1]=(ay*bw+aw*by+az*bx-ax*bz)*2;out[2]=(az*bw+aw*bz+ax*by-ay*bx)*2;return out}function translate$3(out,a,v){var ax1=a[0],ay1=a[1],az1=a[2],aw1=a[3],bx1=v[0]*.5,by1=v[1]*
.5,bz1=v[2]*.5,ax2=a[4],ay2=a[5],az2=a[6],aw2=a[7];out[0]=ax1;out[1]=ay1;out[2]=az1;out[3]=aw1;out[4]=aw1*bx1+ay1*bz1-az1*by1+ax2;out[5]=aw1*by1+az1*bx1-ax1*bz1+ay2;out[6]=aw1*bz1+ax1*by1-ay1*bx1+az2;out[7]=-ax1*bx1-ay1*by1-az1*bz1+aw2;return out}function rotateX$3(out,a,rad){var bx=-a[0],by=-a[1],bz=-a[2],bw=a[3],ax=a[4],ay=a[5],az=a[6],aw=a[7],ax1=ax*bw+aw*bx+ay*bz-az*by,ay1=ay*bw+aw*by+az*bx-ax*bz,az1=az*bw+aw*bz+ax*by-ay*bx,aw1=aw*bw-ax*bx-ay*by-az*bz;rotateX$2(out,a,rad);bx=out[0];by=out[1];
bz=out[2];bw=out[3];out[4]=ax1*bw+aw1*bx+ay1*bz-az1*by;out[5]=ay1*bw+aw1*by+az1*bx-ax1*bz;out[6]=az1*bw+aw1*bz+ax1*by-ay1*bx;out[7]=aw1*bw-ax1*bx-ay1*by-az1*bz;return out}function rotateY$3(out,a,rad){var bx=-a[0],by=-a[1],bz=-a[2],bw=a[3],ax=a[4],ay=a[5],az=a[6],aw=a[7],ax1=ax*bw+aw*bx+ay*bz-az*by,ay1=ay*bw+aw*by+az*bx-ax*bz,az1=az*bw+aw*bz+ax*by-ay*bx,aw1=aw*bw-ax*bx-ay*by-az*bz;rotateY$2(out,a,rad);bx=out[0];by=out[1];bz=out[2];bw=out[3];out[4]=ax1*bw+aw1*bx+ay1*bz-az1*by;out[5]=ay1*bw+aw1*by+
az1*bx-ax1*bz;out[6]=az1*bw+aw1*bz+ax1*by-ay1*bx;out[7]=aw1*bw-ax1*bx-ay1*by-az1*bz;return out}function rotateZ$3(out,a,rad){var bx=-a[0],by=-a[1],bz=-a[2],bw=a[3],ax=a[4],ay=a[5],az=a[6],aw=a[7],ax1=ax*bw+aw*bx+ay*bz-az*by,ay1=ay*bw+aw*by+az*bx-ax*bz,az1=az*bw+aw*bz+ax*by-ay*bx,aw1=aw*bw-ax*bx-ay*by-az*bz;rotateZ$2(out,a,rad);bx=out[0];by=out[1];bz=out[2];bw=out[3];out[4]=ax1*bw+aw1*bx+ay1*bz-az1*by;out[5]=ay1*bw+aw1*by+az1*bx-ax1*bz;out[6]=az1*bw+aw1*bz+ax1*by-ay1*bx;out[7]=aw1*bw-ax1*bx-ay1*by-
az1*bz;return out}function rotateByQuatAppend(out,a,q){var qx=q[0],qy=q[1],qz=q[2],qw=q[3],ax=a[0],ay=a[1],az=a[2],aw=a[3];out[0]=ax*qw+aw*qx+ay*qz-az*qy;out[1]=ay*qw+aw*qy+az*qx-ax*qz;out[2]=az*qw+aw*qz+ax*qy-ay*qx;out[3]=aw*qw-ax*qx-ay*qy-az*qz;ax=a[4];ay=a[5];az=a[6];aw=a[7];out[4]=ax*qw+aw*qx+ay*qz-az*qy;out[5]=ay*qw+aw*qy+az*qx-ax*qz;out[6]=az*qw+aw*qz+ax*qy-ay*qx;out[7]=aw*qw-ax*qx-ay*qy-az*qz;return out}function rotateByQuatPrepend(out,q,a){var qx=q[0],qy=q[1],qz=q[2],qw=q[3],bx=a[0],by=a[1],
bz=a[2],bw=a[3];out[0]=qx*bw+qw*bx+qy*bz-qz*by;out[1]=qy*bw+qw*by+qz*bx-qx*bz;out[2]=qz*bw+qw*bz+qx*by-qy*bx;out[3]=qw*bw-qx*bx-qy*by-qz*bz;bx=a[4];by=a[5];bz=a[6];bw=a[7];out[4]=qx*bw+qw*bx+qy*bz-qz*by;out[5]=qy*bw+qw*by+qz*bx-qx*bz;out[6]=qz*bw+qw*bz+qx*by-qy*bx;out[7]=qw*bw-qx*bx-qy*by-qz*bz;return out}function rotateAroundAxis(out,a,axis,rad){if(Math.abs(rad)<EPSILON)return copy$7(out,a);var axisLength=Math.hypot(axis[0],axis[1],axis[2]);rad=rad*.5;var s=Math.sin(rad);var bx=s*axis[0]/axisLength;
var by=s*axis[1]/axisLength;var bz=s*axis[2]/axisLength;var bw=Math.cos(rad);var ax1=a[0],ay1=a[1],az1=a[2],aw1=a[3];out[0]=ax1*bw+aw1*bx+ay1*bz-az1*by;out[1]=ay1*bw+aw1*by+az1*bx-ax1*bz;out[2]=az1*bw+aw1*bz+ax1*by-ay1*bx;out[3]=aw1*bw-ax1*bx-ay1*by-az1*bz;var ax=a[4],ay=a[5],az=a[6],aw=a[7];out[4]=ax*bw+aw*bx+ay*bz-az*by;out[5]=ay*bw+aw*by+az*bx-ax*bz;out[6]=az*bw+aw*bz+ax*by-ay*bx;out[7]=aw*bw-ax*bx-ay*by-az*bz;return out}function add$7(out,a,b){out[0]=a[0]+b[0];out[1]=a[1]+b[1];out[2]=a[2]+b[2];
out[3]=a[3]+b[3];out[4]=a[4]+b[4];out[5]=a[5]+b[5];out[6]=a[6]+b[6];out[7]=a[7]+b[7];return out}function multiply$7(out,a,b){var ax0=a[0],ay0=a[1],az0=a[2],aw0=a[3],bx1=b[4],by1=b[5],bz1=b[6],bw1=b[7],ax1=a[4],ay1=a[5],az1=a[6],aw1=a[7],bx0=b[0],by0=b[1],bz0=b[2],bw0=b[3];out[0]=ax0*bw0+aw0*bx0+ay0*bz0-az0*by0;out[1]=ay0*bw0+aw0*by0+az0*bx0-ax0*bz0;out[2]=az0*bw0+aw0*bz0+ax0*by0-ay0*bx0;out[3]=aw0*bw0-ax0*bx0-ay0*by0-az0*bz0;out[4]=ax0*bw1+aw0*bx1+ay0*bz1-az0*by1+ax1*bw0+aw1*bx0+ay1*bz0-az1*by0;out[5]=
ay0*bw1+aw0*by1+az0*bx1-ax0*bz1+ay1*bw0+aw1*by0+az1*bx0-ax1*bz0;out[6]=az0*bw1+aw0*bz1+ax0*by1-ay0*bx1+az1*bw0+aw1*bz0+ax1*by0-ay1*bx0;out[7]=aw0*bw1-ax0*bx1-ay0*by1-az0*bz1+aw1*bw0-ax1*bx0-ay1*by0-az1*bz0;return out}var mul$7=multiply$7;function scale$7(out,a,b){out[0]=a[0]*b;out[1]=a[1]*b;out[2]=a[2]*b;out[3]=a[3]*b;out[4]=a[4]*b;out[5]=a[5]*b;out[6]=a[6]*b;out[7]=a[7]*b;return out}var dot$3=dot$2;function lerp$3(out,a,b,t){var mt=1-t;if(dot$3(a,b)<0)t=-t;out[0]=a[0]*mt+b[0]*t;out[1]=a[1]*mt+b[1]*
t;out[2]=a[2]*mt+b[2]*t;out[3]=a[3]*mt+b[3]*t;out[4]=a[4]*mt+b[4]*t;out[5]=a[5]*mt+b[5]*t;out[6]=a[6]*mt+b[6]*t;out[7]=a[7]*mt+b[7]*t;return out}function invert$5(out,a){var sqlen=squaredLength$3(a);out[0]=-a[0]/sqlen;out[1]=-a[1]/sqlen;out[2]=-a[2]/sqlen;out[3]=a[3]/sqlen;out[4]=-a[4]/sqlen;out[5]=-a[5]/sqlen;out[6]=-a[6]/sqlen;out[7]=a[7]/sqlen;return out}function conjugate$1(out,a){out[0]=-a[0];out[1]=-a[1];out[2]=-a[2];out[3]=a[3];out[4]=-a[4];out[5]=-a[5];out[6]=-a[6];out[7]=a[7];return out}
var length$3=length$2;var len$3=length$3;var squaredLength$3=squaredLength$2;var sqrLen$3=squaredLength$3;function normalize$3(out,a){var magnitude=squaredLength$3(a);if(magnitude>0){magnitude=Math.sqrt(magnitude);var a0=a[0]/magnitude;var a1=a[1]/magnitude;var a2=a[2]/magnitude;var a3=a[3]/magnitude;var b0=a[4];var b1=a[5];var b2=a[6];var b3=a[7];var a_dot_b=a0*b0+a1*b1+a2*b2+a3*b3;out[0]=a0;out[1]=a1;out[2]=a2;out[3]=a3;out[4]=(b0-a0*a_dot_b)/magnitude;out[5]=(b1-a1*a_dot_b)/magnitude;out[6]=(b2-
a2*a_dot_b)/magnitude;out[7]=(b3-a3*a_dot_b)/magnitude}return out}function str$7(a){return"quat2("+a[0]+", "+a[1]+", "+a[2]+", "+a[3]+", "+a[4]+", "+a[5]+", "+a[6]+", "+a[7]+")"}function exactEquals$7(a,b){return a[0]===b[0]&&a[1]===b[1]&&a[2]===b[2]&&a[3]===b[3]&&a[4]===b[4]&&a[5]===b[5]&&a[6]===b[6]&&a[7]===b[7]}function equals$8(a,b){var a0=a[0],a1=a[1],a2=a[2],a3=a[3],a4=a[4],a5=a[5],a6=a[6],a7=a[7];var b0=b[0],b1=b[1],b2=b[2],b3=b[3],b4=b[4],b5=b[5],b6=b[6],b7=b[7];return Math.abs(a0-b0)<=EPSILON*
Math.max(1,Math.abs(a0),Math.abs(b0))&&Math.abs(a1-b1)<=EPSILON*Math.max(1,Math.abs(a1),Math.abs(b1))&&Math.abs(a2-b2)<=EPSILON*Math.max(1,Math.abs(a2),Math.abs(b2))&&Math.abs(a3-b3)<=EPSILON*Math.max(1,Math.abs(a3),Math.abs(b3))&&Math.abs(a4-b4)<=EPSILON*Math.max(1,Math.abs(a4),Math.abs(b4))&&Math.abs(a5-b5)<=EPSILON*Math.max(1,Math.abs(a5),Math.abs(b5))&&Math.abs(a6-b6)<=EPSILON*Math.max(1,Math.abs(a6),Math.abs(b6))&&Math.abs(a7-b7)<=EPSILON*Math.max(1,Math.abs(a7),Math.abs(b7))}var quat2=Object.freeze({__proto__:null,
create:create$7,clone:clone$7,fromValues:fromValues$7,fromRotationTranslationValues:fromRotationTranslationValues,fromRotationTranslation:fromRotationTranslation$1,fromTranslation:fromTranslation$3,fromRotation:fromRotation$4,fromMat4:fromMat4$1,copy:copy$7,identity:identity$5,set:set$7,getReal:getReal,getDual:getDual,setReal:setReal,setDual:setDual,getTranslation:getTranslation$1,translate:translate$3,rotateX:rotateX$3,rotateY:rotateY$3,rotateZ:rotateZ$3,rotateByQuatAppend:rotateByQuatAppend,rotateByQuatPrepend:rotateByQuatPrepend,
rotateAroundAxis:rotateAroundAxis,add:add$7,multiply:multiply$7,mul:mul$7,scale:scale$7,dot:dot$3,lerp:lerp$3,invert:invert$5,conjugate:conjugate$1,length:length$3,len:len$3,squaredLength:squaredLength$3,sqrLen:sqrLen$3,normalize:normalize$3,str:str$7,exactEquals:exactEquals$7,equals:equals$8});function create$8(){var out=new ARRAY_TYPE(2);if(ARRAY_TYPE!=Float32Array){out[0]=0;out[1]=0}return out}function clone$8(a){var out=new ARRAY_TYPE(2);out[0]=a[0];out[1]=a[1];return out}function fromValues$8(x,
y){var out=new ARRAY_TYPE(2);out[0]=x;out[1]=y;return out}function copy$8(out,a){out[0]=a[0];out[1]=a[1];return out}function set$8(out,x,y){out[0]=x;out[1]=y;return out}function add$8(out,a,b){out[0]=a[0]+b[0];out[1]=a[1]+b[1];return out}function subtract$6(out,a,b){out[0]=a[0]-b[0];out[1]=a[1]-b[1];return out}function multiply$8(out,a,b){out[0]=a[0]*b[0];out[1]=a[1]*b[1];return out}function divide$2(out,a,b){out[0]=a[0]/b[0];out[1]=a[1]/b[1];return out}function ceil$2(out,a){out[0]=Math.ceil(a[0]);
out[1]=Math.ceil(a[1]);return out}function floor$2(out,a){out[0]=Math.floor(a[0]);out[1]=Math.floor(a[1]);return out}function min$2(out,a,b){out[0]=Math.min(a[0],b[0]);out[1]=Math.min(a[1],b[1]);return out}function max$2(out,a,b){out[0]=Math.max(a[0],b[0]);out[1]=Math.max(a[1],b[1]);return out}function round$2(out,a){out[0]=Math.round(a[0]);out[1]=Math.round(a[1]);return out}function scale$8(out,a,b){out[0]=a[0]*b;out[1]=a[1]*b;return out}function scaleAndAdd$2(out,a,b,scale){out[0]=a[0]+b[0]*scale;
out[1]=a[1]+b[1]*scale;return out}function distance$2(a,b){var x=b[0]-a[0],y=b[1]-a[1];return Math.hypot(x,y)}function squaredDistance$2(a,b){var x=b[0]-a[0],y=b[1]-a[1];return x*x+y*y}function length$4(a){var x=a[0],y=a[1];return Math.hypot(x,y)}function squaredLength$4(a){var x=a[0],y=a[1];return x*x+y*y}function negate$2(out,a){out[0]=-a[0];out[1]=-a[1];return out}function inverse$2(out,a){out[0]=1/a[0];out[1]=1/a[1];return out}function normalize$4(out,a){var x=a[0],y=a[1];var len=x*x+y*y;if(len>
0)len=1/Math.sqrt(len);out[0]=a[0]*len;out[1]=a[1]*len;return out}function dot$4(a,b){return a[0]*b[0]+a[1]*b[1]}function cross$2(out,a,b){var z=a[0]*b[1]-a[1]*b[0];out[0]=out[1]=0;out[2]=z;return out}function lerp$4(out,a,b,t){var ax=a[0],ay=a[1];out[0]=ax+t*(b[0]-ax);out[1]=ay+t*(b[1]-ay);return out}function random$3(out,scale){scale=scale||1;var r=RANDOM()*2*Math.PI;out[0]=Math.cos(r)*scale;out[1]=Math.sin(r)*scale;return out}function transformMat2(out,a,m){var x=a[0],y=a[1];out[0]=m[0]*x+m[2]*
y;out[1]=m[1]*x+m[3]*y;return out}function transformMat2d(out,a,m){var x=a[0],y=a[1];out[0]=m[0]*x+m[2]*y+m[4];out[1]=m[1]*x+m[3]*y+m[5];return out}function transformMat3$1(out,a,m){var x=a[0],y=a[1];out[0]=m[0]*x+m[3]*y+m[6];out[1]=m[1]*x+m[4]*y+m[7];return out}function transformMat4$2(out,a,m){var x=a[0];var y=a[1];out[0]=m[0]*x+m[4]*y+m[12];out[1]=m[1]*x+m[5]*y+m[13];return out}function rotate$4(out,a,b,rad){var p0=a[0]-b[0],p1=a[1]-b[1],sinC=Math.sin(rad),cosC=Math.cos(rad);out[0]=p0*cosC-p1*
sinC+b[0];out[1]=p0*sinC+p1*cosC+b[1];return out}function angle$1(a,b){var x1=a[0],y1=a[1],x2=b[0],y2=b[1],mag=Math.sqrt(x1*x1+y1*y1)*Math.sqrt(x2*x2+y2*y2),cosine=mag&&(x1*x2+y1*y2)/mag;return Math.acos(Math.min(Math.max(cosine,-1),1))}function zero$2(out){out[0]=0;out[1]=0;return out}function str$8(a){return"vec2("+a[0]+", "+a[1]+")"}function exactEquals$8(a,b){return a[0]===b[0]&&a[1]===b[1]}function equals$9(a,b){var a0=a[0],a1=a[1];var b0=b[0],b1=b[1];return Math.abs(a0-b0)<=EPSILON*Math.max(1,
Math.abs(a0),Math.abs(b0))&&Math.abs(a1-b1)<=EPSILON*Math.max(1,Math.abs(a1),Math.abs(b1))}var len$4=length$4;var sub$6=subtract$6;var mul$8=multiply$8;var div$2=divide$2;var dist$2=distance$2;var sqrDist$2=squaredDistance$2;var sqrLen$4=squaredLength$4;var forEach$2=function(){var vec=create$8();return function(a,stride,offset,count,fn,arg){var i,l;if(!stride)stride=2;if(!offset)offset=0;if(count)l=Math.min(count*stride+offset,a.length);else l=a.length;for(i=offset;i<l;i+=stride){vec[0]=a[i];vec[1]=
a[i+1];fn(vec,vec,arg);a[i]=vec[0];a[i+1]=vec[1]}return a}}();var vec2=Object.freeze({__proto__:null,create:create$8,clone:clone$8,fromValues:fromValues$8,copy:copy$8,set:set$8,add:add$8,subtract:subtract$6,multiply:multiply$8,divide:divide$2,ceil:ceil$2,floor:floor$2,min:min$2,max:max$2,round:round$2,scale:scale$8,scaleAndAdd:scaleAndAdd$2,distance:distance$2,squaredDistance:squaredDistance$2,length:length$4,squaredLength:squaredLength$4,negate:negate$2,inverse:inverse$2,normalize:normalize$4,dot:dot$4,
cross:cross$2,lerp:lerp$4,random:random$3,transformMat2:transformMat2,transformMat2d:transformMat2d,transformMat3:transformMat3$1,transformMat4:transformMat4$2,rotate:rotate$4,angle:angle$1,zero:zero$2,str:str$8,exactEquals:exactEquals$8,equals:equals$9,len:len$4,sub:sub$6,mul:mul$8,div:div$2,dist:dist$2,sqrDist:sqrDist$2,sqrLen:sqrLen$4,forEach:forEach$2});exports.glMatrix=common;exports.mat2=mat2;exports.mat2d=mat2d;exports.mat3=mat3;exports.mat4=mat4;exports.quat=quat;exports.quat2=quat2;exports.vec2=
vec2;exports.vec3=vec3;exports.vec4=vec4;Object.defineProperty(exports,"__esModule",{value:true})});


// c3/3rdparty/poly-decomp.js
'use strict';{function lineInt(l1,l2,precision){precision=precision||0;var i=[0,0];var a1,b1,c1,a2,b2,c2,det;a1=l1[1][1]-l1[0][1];b1=l1[0][0]-l1[1][0];c1=a1*l1[0][0]+b1*l1[0][1];a2=l2[1][1]-l2[0][1];b2=l2[0][0]-l2[1][0];c2=a2*l2[0][0]+b2*l2[0][1];det=a1*b2-a2*b1;if(!scalar_eq(det,0,precision)){i[0]=(b2*c1-b1*c2)/det;i[1]=(a1*c2-a2*c1)/det}return i}function lineSegmentsIntersect(p1,p2,q1,q2){var dx=p2[0]-p1[0];var dy=p2[1]-p1[1];var da=q2[0]-q1[0];var db=q2[1]-q1[1];if(da*dy-db*dx===0)return false;
var s=(dx*(q1[1]-p1[1])+dy*(p1[0]-q1[0]))/(da*dy-db*dx);var t=(da*(p1[1]-q1[1])+db*(q1[0]-p1[0]))/(db*dx-da*dy);return s>=0&&s<=1&&t>=0&&t<=1}function triangleArea(a,b,c){return(b[0]-a[0])*(c[1]-a[1])-(c[0]-a[0])*(b[1]-a[1])}function isLeft(a,b,c){return triangleArea(a,b,c)>0}function isLeftOn(a,b,c){return triangleArea(a,b,c)>=0}function isRight(a,b,c){return triangleArea(a,b,c)<0}function isRightOn(a,b,c){return triangleArea(a,b,c)<=0}var tmpPoint1=[],tmpPoint2=[];function collinear(a,b,c,thresholdAngle){if(!thresholdAngle)return triangleArea(a,
b,c)===0;else{var ab=tmpPoint1,bc=tmpPoint2;ab[0]=b[0]-a[0];ab[1]=b[1]-a[1];bc[0]=c[0]-b[0];bc[1]=c[1]-b[1];var dot=ab[0]*bc[0]+ab[1]*bc[1],magA=Math.sqrt(ab[0]*ab[0]+ab[1]*ab[1]),magB=Math.sqrt(bc[0]*bc[0]+bc[1]*bc[1]),angle=Math.acos(dot/(magA*magB));return angle<thresholdAngle}}function sqdist(a,b){var dx=b[0]-a[0];var dy=b[1]-a[1];return dx*dx+dy*dy}function polygonAt(polygon,i){var s=polygon.length;return polygon[i<0?i%s+s:i%s]}function polygonClear(polygon){polygon.length=0}function polygonAppend(polygon,
poly,from,to){for(var i=from;i<to;i++)polygon.push(poly[i])}function polygonMakeCCW(polygon){var br=0,v=polygon;for(var i=1;i<polygon.length;++i)if(v[i][1]<v[br][1]||v[i][1]===v[br][1]&&v[i][0]>v[br][0])br=i;if(!isLeft(polygonAt(polygon,br-1),polygonAt(polygon,br),polygonAt(polygon,br+1))){polygonReverse(polygon);return true}else return false}function polygonReverse(polygon){var tmp=[];var N=polygon.length;for(var i=0;i!==N;i++)tmp.push(polygon.pop());for(var i=0;i!==N;i++)polygon[i]=tmp[i]}function polygonIsReflex(polygon,
i){return isRight(polygonAt(polygon,i-1),polygonAt(polygon,i),polygonAt(polygon,i+1))}var tmpLine1=[],tmpLine2=[];function polygonCanSee(polygon,a,b){var p,dist,l1=tmpLine1,l2=tmpLine2;if(isLeftOn(polygonAt(polygon,a+1),polygonAt(polygon,a),polygonAt(polygon,b))&&isRightOn(polygonAt(polygon,a-1),polygonAt(polygon,a),polygonAt(polygon,b)))return false;dist=sqdist(polygonAt(polygon,a),polygonAt(polygon,b));for(var i=0;i!==polygon.length;++i){if((i+1)%polygon.length===a||i===a)continue;if(isLeftOn(polygonAt(polygon,
a),polygonAt(polygon,b),polygonAt(polygon,i+1))&&isRightOn(polygonAt(polygon,a),polygonAt(polygon,b),polygonAt(polygon,i))){l1[0]=polygonAt(polygon,a);l1[1]=polygonAt(polygon,b);l2[0]=polygonAt(polygon,i);l2[1]=polygonAt(polygon,i+1);p=lineInt(l1,l2);if(sqdist(polygonAt(polygon,a),p)<dist)return false}}return true}function polygonCanSee2(polygon,a,b){for(var i=0;i!==polygon.length;++i){if(i===a||i===b||(i+1)%polygon.length===a||(i+1)%polygon.length===b)continue;if(lineSegmentsIntersect(polygonAt(polygon,
a),polygonAt(polygon,b),polygonAt(polygon,i),polygonAt(polygon,i+1)))return false}return true}function polygonCopy(polygon,i,j,targetPoly){var p=targetPoly||[];polygonClear(p);if(i<j)for(var k=i;k<=j;k++)p.push(polygon[k]);else{for(var k=0;k<=j;k++)p.push(polygon[k]);for(var k=i;k<polygon.length;k++)p.push(polygon[k])}return p}function polygonGetCutEdges(polygon){var min=[],tmp1=[],tmp2=[],tmpPoly=[];var nDiags=Number.MAX_VALUE;for(var i=0;i<polygon.length;++i)if(polygonIsReflex(polygon,i))for(var j=
0;j<polygon.length;++j)if(polygonCanSee(polygon,i,j)){tmp1=polygonGetCutEdges(polygonCopy(polygon,i,j,tmpPoly));tmp2=polygonGetCutEdges(polygonCopy(polygon,j,i,tmpPoly));for(var k=0;k<tmp2.length;k++)tmp1.push(tmp2[k]);if(tmp1.length<nDiags){min=tmp1;nDiags=tmp1.length;min.push([polygonAt(polygon,i),polygonAt(polygon,j)])}}return min}function polygonDecomp(polygon){var edges=polygonGetCutEdges(polygon);if(edges.length>0)return polygonSlice(polygon,edges);else return[polygon]}function polygonSlice(polygon,
cutEdges){if(cutEdges.length===0)return[polygon];if(cutEdges instanceof Array&&cutEdges.length&&cutEdges[0]instanceof Array&&cutEdges[0].length===2&&cutEdges[0][0]instanceof Array){var polys=[polygon];for(var i=0;i<cutEdges.length;i++){var cutEdge=cutEdges[i];for(var j=0;j<polys.length;j++){var poly=polys[j];var result=polygonSlice(poly,cutEdge);if(result){polys.splice(j,1);polys.push(result[0],result[1]);break}}}return polys}else{var cutEdge=cutEdges;var i=polygon.indexOf(cutEdge[0]);var j=polygon.indexOf(cutEdge[1]);
if(i!==-1&&j!==-1)return[polygonCopy(polygon,i,j),polygonCopy(polygon,j,i)];else return false}}function polygonIsSimple(polygon){var path=polygon,i;for(i=0;i<path.length-1;i++)for(var j=0;j<i-1;j++)if(lineSegmentsIntersect(path[i],path[i+1],path[j],path[j+1]))return false;for(i=1;i<path.length-2;i++)if(lineSegmentsIntersect(path[0],path[path.length-1],path[i],path[i+1]))return false;return true}function getIntersectionPoint(p1,p2,q1,q2,delta){delta=delta||0;var a1=p2[1]-p1[1];var b1=p1[0]-p2[0];var c1=
a1*p1[0]+b1*p1[1];var a2=q2[1]-q1[1];var b2=q1[0]-q2[0];var c2=a2*q1[0]+b2*q1[1];var det=a1*b2-a2*b1;if(!scalar_eq(det,0,delta))return[(b2*c1-b1*c2)/det,(a1*c2-a2*c1)/det];else return[0,0]}function polygonQuickDecomp(polygon,result,reflexVertices,steinerPoints,delta,maxlevel,level){maxlevel=maxlevel||100;level=level||0;delta=delta||25;result=typeof result!=="undefined"?result:[];reflexVertices=reflexVertices||[];steinerPoints=steinerPoints||[];var upperInt=[0,0],lowerInt=[0,0],p=[0,0];var upperDist=
0,lowerDist=0,d=0,closestDist=0;var upperIndex=0,lowerIndex=0,closestIndex=0;var lowerPoly=[],upperPoly=[];var poly=polygon,v=polygon;if(v.length<3)return result;level++;if(level>maxlevel){console.warn("quickDecomp: max level ("+maxlevel+") reached.");return result}for(var i=0;i<polygon.length;++i)if(polygonIsReflex(poly,i)){reflexVertices.push(poly[i]);upperDist=lowerDist=Number.MAX_VALUE;for(var j=0;j<polygon.length;++j){if(isLeft(polygonAt(poly,i-1),polygonAt(poly,i),polygonAt(poly,j))&&isRightOn(polygonAt(poly,
i-1),polygonAt(poly,i),polygonAt(poly,j-1))){p=getIntersectionPoint(polygonAt(poly,i-1),polygonAt(poly,i),polygonAt(poly,j),polygonAt(poly,j-1));if(isRight(polygonAt(poly,i+1),polygonAt(poly,i),p)){d=sqdist(poly[i],p);if(d<lowerDist){lowerDist=d;lowerInt=p;lowerIndex=j}}}if(isLeft(polygonAt(poly,i+1),polygonAt(poly,i),polygonAt(poly,j+1))&&isRightOn(polygonAt(poly,i+1),polygonAt(poly,i),polygonAt(poly,j))){p=getIntersectionPoint(polygonAt(poly,i+1),polygonAt(poly,i),polygonAt(poly,j),polygonAt(poly,
j+1));if(isLeft(polygonAt(poly,i-1),polygonAt(poly,i),p)){d=sqdist(poly[i],p);if(d<upperDist){upperDist=d;upperInt=p;upperIndex=j}}}}if(lowerIndex===(upperIndex+1)%polygon.length){p[0]=(lowerInt[0]+upperInt[0])/2;p[1]=(lowerInt[1]+upperInt[1])/2;steinerPoints.push(p);if(i<upperIndex){polygonAppend(lowerPoly,poly,i,upperIndex+1);lowerPoly.push(p);upperPoly.push(p);if(lowerIndex!==0)polygonAppend(upperPoly,poly,lowerIndex,poly.length);polygonAppend(upperPoly,poly,0,i+1)}else{if(i!==0)polygonAppend(lowerPoly,
poly,i,poly.length);polygonAppend(lowerPoly,poly,0,upperIndex+1);lowerPoly.push(p);upperPoly.push(p);polygonAppend(upperPoly,poly,lowerIndex,i+1)}}else{if(lowerIndex>upperIndex)upperIndex+=polygon.length;closestDist=Number.MAX_VALUE;if(upperIndex<lowerIndex)return result;for(var j=lowerIndex;j<=upperIndex;++j)if(isLeftOn(polygonAt(poly,i-1),polygonAt(poly,i),polygonAt(poly,j))&&isRightOn(polygonAt(poly,i+1),polygonAt(poly,i),polygonAt(poly,j))){d=sqdist(polygonAt(poly,i),polygonAt(poly,j));if(d<closestDist&&
polygonCanSee2(poly,i,j)){closestDist=d;closestIndex=j%polygon.length}}if(i<closestIndex){polygonAppend(lowerPoly,poly,i,closestIndex+1);if(closestIndex!==0)polygonAppend(upperPoly,poly,closestIndex,v.length);polygonAppend(upperPoly,poly,0,i+1)}else{if(i!==0)polygonAppend(lowerPoly,poly,i,v.length);polygonAppend(lowerPoly,poly,0,closestIndex+1);polygonAppend(upperPoly,poly,closestIndex,i+1)}}if(lowerPoly.length<upperPoly.length){polygonQuickDecomp(lowerPoly,result,reflexVertices,steinerPoints,delta,
maxlevel,level);polygonQuickDecomp(upperPoly,result,reflexVertices,steinerPoints,delta,maxlevel,level)}else{polygonQuickDecomp(upperPoly,result,reflexVertices,steinerPoints,delta,maxlevel,level);polygonQuickDecomp(lowerPoly,result,reflexVertices,steinerPoints,delta,maxlevel,level)}return result}result.push(polygon);return result}function polygonRemoveCollinearPoints(polygon,precision){var num=0;for(var i=polygon.length-1;polygon.length>3&&i>=0;--i)if(collinear(polygonAt(polygon,i-1),polygonAt(polygon,
i),polygonAt(polygon,i+1),precision)){polygon.splice(i%polygon.length,1);num++}return num}function polygonRemoveDuplicatePoints(polygon,precision){for(var i=polygon.length-1;i>=1;--i){var pi=polygon[i];for(var j=i-1;j>=0;--j)if(points_eq(pi,polygon[j],precision)){polygon.splice(i,1);continue}}}function scalar_eq(a,b,precision){precision=precision||0;return Math.abs(a-b)<=precision}function points_eq(a,b,precision){return scalar_eq(a[0],b[0],precision)&&scalar_eq(a[1],b[1],precision)}self.polyDecomp=
{decomp:polygonDecomp,quickDecomp:polygonQuickDecomp,isSimple:polygonIsSimple,removeCollinearPoints:polygonRemoveCollinearPoints,removeDuplicatePoints:polygonRemoveDuplicatePoints,makeCCW:polygonMakeCCW}};


// c3/lib/c3.js
'use strict';{let isReady=false;let hasAppStarted=false;let buildMode="dev";const C3=self.C3=class C3{constructor(){throw TypeError("static class can't be instantiated");}static SetReady(){isReady=true}static IsReady(){return isReady}static SetAppStarted(){hasAppStarted=true}static HasAppStarted(){return hasAppStarted}static SetBuildMode(m){buildMode=m}static GetBuildMode(){return buildMode}static IsReleaseBuild(){return buildMode==="final"}};C3.isDebug=false;C3.isDebugDefend=false;C3.hardwareConcurrency=
navigator.hardwareConcurrency||2;self.C3X={}};


// ../lib/queryParser.js
'use strict';{const C3=self.C3;C3.QueryParser=class QueryParser{constructor(queryString){this._queryString=queryString;this._parameters=new Map;this._Parse()}_Parse(){let str=this._queryString;if(str.startsWith("?")||str.startsWith("#"))str=str.substr(1);const arr=str.split("&");for(const p of arr)this._ParseParameter(p)}_ParseParameter(p){if(!p)return;if(!p.includes("=")){this._parameters.set(p,null);return}const i=p.indexOf("=");const parameterName=decodeURIComponent(p.substring(0,i));const parameterValue=
decodeURIComponent(p.substring(i+1));this._parameters.set(parameterName,parameterValue)}LogAll(){for(const e of this._parameters)console.log("[QueryParser] Parameter '"+e[0]+"' = "+(e[1]===null?"null":"'"+e[1]+"'"))}Has(name){return this._parameters.has(name)}Get(name){const ret=this._parameters.get(name);if(typeof ret==="undefined")return null;else return ret}ClearHash(){history.replaceState("",document.title,location.pathname+location.search)}Reparse(str){this._queryString=str;this._parameters.clear();
this._Parse()}};C3.QueryString=new C3.QueryParser(location.search);C3.LocationHashString=new C3.QueryParser(location.hash);if(C3.QueryString.Get("mode")!=="dev")C3.SetBuildMode("final")};


// ../lib/detect/detect.js
'use strict';{const C3=self.C3;const UNKNOWN="(unknown)";const UA=navigator.userAgent;let Flags={linux:/linux|openbsd|freebsd|netbsd/i.test(UA),chromeOS:/CrOS/.test(UA),windowsTizen:/trident|iemobile|msie|tizen/i.test(UA),genericMS:/trident|iemobile|msie|edge\//i.test(UA),opera:/OPR\//.test(UA),blackberry:/bb10/i.test(UA),edge:/edge\//i.test(UA),trident:/trident/i.test(UA),webkit:/webkit/i.test(UA),safari:/safari\//i.test(UA),chrome:/chrome\//i.test(UA),chromium:/chromium\//i.test(UA),crosswalk:/crosswalk|xwalk/i.test(UA),
nwjs:/nwjs/i.test(UA),amazonwebapp:/amazonwebappplatform/i.test(UA),webview:/wv\)/.test(UA),android:/android/i.test(UA),nokia:/nokiabrowser\/[0-9.]+/i.test(UA)};let Versions={windows:/windows\s+nt\s+\d+\.\d+/i.exec(UA),OSX:/mac\s+os\s+x\s+[0-9_]+/i.exec(UA),android:/android\s+[0-9.]+/i.exec(UA),opera:/OPR\/[0-9.]+/.exec(UA),tizen:/tizen\s+[0-9.]+/i.exec(UA),iphone:/iphone\s+os\s+[0-9_]+/i.exec(UA),ipad:/ipad[^)]*os\s+[0-9_]+/i.exec(UA),winPhone:/windows\s+phone\s+[0-9.]+/i.exec(UA),winPhoneOS:/windows\s+phone\s+os\s+[0-9.]+/i.exec(UA),
chrome:/chrome\/[0-9.]+/i.exec(UA),chromium:/chromium\/[0-9.]+/i.exec(UA),nwjs:/nwjs\/[0-9.]+/i.exec(UA),firefox:/firefox\/[0-9.]+/i.exec(UA),ie:/msie\s+[0-9.]+/i.exec(UA),edge:/edge\/[0-9.]+/i.exec(UA),edgeChromium:/edg\/[0-9.]+/i.exec(UA),silk:/silk\/[0-9.]+/i.exec(UA)};let os=UNKNOWN;let os_version=UNKNOWN;let browser=UNKNOWN;let browser_version=UNKNOWN;let engine=UNKNOWN;let context="browser";let is_desktop=false;let is_desktop_app=false;let testResults=new Map;function runTest(name,value,fn){if(value===
true){const result=fn();testResults.set(name,true)}else if(value&&value.length){const result=fn(value[0]);testResults.set(name,true)}else;}runTest("isWindows",Versions.windows,WIN=>{os="Windows";const nt_ver=WIN.split(" ")[2];if(nt_ver)switch(nt_ver){case "5.0":os_version="2000";break;case "5.1":os_version="XP";break;case "5.2":os_version="XP";break;case "6.0":os_version="Vista";break;case "6.1":os_version="7";break;case "6.2":os_version="8";break;case "6.3":os_version="8.1";break;case "10.0":os_version=
"10";break}});runTest("isOSX",Versions.OSX,OSX=>{os="Mac OS X";const osx_ver=OSX.split(" ")[3];if(osx_ver)os_version=osx_ver.replace("_",".")});runTest("isLinux",Flags.linux,()=>{os="Linux"});runTest("isChromeOS",Flags.chromeOS,()=>{os="Chrome OS"});runTest("isAndroid",!Flags.windowsTizen&&Versions.android,AND=>{os="Android";const android_ver=AND.split(" ")[1];if(android_ver)os_version=android_ver});runTest("isTizen",Versions.tizen,TIZ=>{os="Tizen";const tizen_ver=TIZ.split(" ")[1];if(tizen_ver)os_version=
tizen_ver});runTest("isIPhone",!Flags.windowsTizen&&Versions.iphone,IOS=>{os="iOS";const ios_ver=IOS.split(" ")[2];if(ios_ver)os_version=ios_ver.replace("_",".")});runTest("isIPad",!Flags.windowsTizen&&Versions.ipad,IOS=>{os="iOS";const ios_ver=IOS.split(" ")[3];if(ios_ver)os_version=ios_ver.replace("_",".")});runTest("isWindowsPhone",Versions.winPhone,WIN=>{os="Windows Phone";const ver_str=WIN.split(" ")[2];if(ver_str)os_version=ver_str});runTest("isWindowsPhoneOS",Versions.winPhoneOS,WIN=>{os="Windows Phone";
const ver_str=WIN.split(" ")[3];if(ver_str)os_version=ver_str});runTest("isBlackberry",Flags.blackberry,()=>{os="Blackberry";os_version="10";browser="stock";engine="webkit"});runTest("isChrome",!Flags.edge&&!Flags.opera&&Versions.chrome,CHR=>{browser="Chrome";engine="Chromium";const ver_str=CHR.split("/")[1];if(ver_str)browser_version=ver_str});runTest("isOpera",Versions.opera,OPR=>{browser="Opera";engine="Chromium";const ver_str=OPR.split("/")[1];if(ver_str)browser_version=ver_str});runTest("isChromium",
Versions.chromium,CHR=>{browser="Chromium";engine="Chromium";const ver_str=CHR.split("/")[1];if(ver_str)browser_version=ver_str});runTest("isFirefox",Versions.firefox,FIR=>{browser="Firefox";engine="Gecko";const ver_str=FIR.split("/")[1];if(ver_str)browser_version=ver_str});runTest("isInternetExplorer",Versions.ie,IE=>{browser="Internet Explorer";engine="Trident";const ver_str=IE.split(" ")[1];if(ver_str)browser_version=ver_str});runTest("isTrident",browser!=="Internet Explorer"&&Flags.trident,()=>
{engine="Trident";const rRv=/rv:[0-9.]+/i.exec(UA);if(rRv&&rRv.length){browser="Internet Explorer";const ver_str=rRv[0].split(":")[1];if(ver_str)browser_version=ver_str}});runTest("isEdge",Versions.edge,EDGE=>{browser="Edge";engine="Edge";const ver_str=EDGE.split("/")[1];if(ver_str)browser_version=ver_str});runTest("isEdgeChromium",Versions.edgeChromium,EDGECHR=>{browser="Edge";engine="Chromium";const ver_str=EDGECHR.split("/")[1];if(ver_str)browser_version=ver_str});runTest("isSafari",Flags.safari&&
!Flags.nokia&&!Flags.chrome&&!Flags.chromium&&!Flags.genericIE&&!Flags.blackberry,()=>{browser="Safari";engine="WebKit";const rVersion=/version\/[0-9.]+/i.exec(UA);const rChromeiOS=/crios\/[0-9.]+/i.exec(UA);const rFirefoxiOS=/fxios\/[0-9.]+/i.exec(UA);if(rVersion&&rVersion.length){const ver_str=rVersion[0].split("/")[1];if(ver_str)browser_version=ver_str}if(rChromeiOS&&rChromeiOS.length){browser="Chrome for iOS";const ver_str=rChromeiOS[0].split("/")[1];if(ver_str)browser_version=ver_str}if(rFirefoxiOS&&
rFirefoxiOS.length){browser="Firefox for iOS";const ver_str=rFirefoxiOS[0].split("/")[1];if(ver_str)browser_version=ver_str}});runTest("isSilk",Versions.silk,SILK=>{browser="Silk";const ver_str=SILK.split("/")[1];if(ver_str)browser_version=ver_str});runTest("isCrosswalk",Flags.crosswalk,()=>context="crosswalk");runTest("isCordova",self["device"]&&(self["device"]["cordova"]||self["device"]["phonegap"]),()=>context="cordova");runTest("isNWJS",Versions.nwjs,NWJS=>{context="nwjs";browser="NW.js";engine=
"Chromium";const ver_str=NWJS.split("/")[1];if(ver_str)browser_version=ver_str});runTest("isAmazonWebApp",Flags.amazonwebapp,()=>context="webapp");runTest("isHomeScreenWebApp",context!=="nwjs"&&typeof window!=="undefined"&&(window.matchMedia&&window.matchMedia("(display-mode: standalone)").matches||navigator["standalone"]),()=>context="webapp");runTest("isFalseSafari",browser==="Safari"&&(os==="Android"||os==="Tizen"||os==="Blackberry"),()=>browser="stock");runTest("isAndroidWebview",browser==="Chrome"&&
context==="browser"&&Flags.webview,()=>context="webview");runTest("isFirefoxOS",browser==="Firefox"&&os===UNKNOWN,()=>os="Firefox OS");runTest("isAndroidFallback",os===UNKNOWN&&!Flags.windowsTizen&&Flags.android,()=>os="Android");runTest("isTridentFallback",os===UNKNOWN&&Flags.trident,()=>engine="Trident");runTest("isWebkitFallback",os===UNKNOWN&&Flags.webkit,()=>engine="WebKit");runTest("isDesktop",(()=>{return os==="Windows"||os==="Mac OS X"||os==="Linux"||os==="Chrome OS"||context==="nwjs"})(),
()=>is_desktop=true);if(engine==="Edge"&&typeof Windows!=="undefined"&&typeof Windows["System"]!=="undefined")context="windows-store";is_desktop_app=context==="nwjs";const is_ipad_os=os==="Mac OS X"&&navigator["maxTouchPoints"]&&navigator["maxTouchPoints"]>2;if(is_ipad_os){os="iOS";os_version=browser_version;is_desktop=false;is_desktop_app=false}C3.Platform={OS:os,OSVersion:os_version,Browser:browser,BrowserVersion:browser_version,BrowserVersionNumber:parseFloat(browser_version),BrowserEngine:engine,
Context:context,IsDesktop:is_desktop,IsMobile:!is_desktop,IsDesktopApp:is_desktop_app,IsChromeWebStore:!!(self["chrome"]&&self["chrome"]["runtime"]&&self["chrome"]["runtime"]["id"]),IsAppleOS:os==="Mac OS X"||os==="iOS",IsIpadOS:is_ipad_os,IsLinux:os==="Linux"}};


// ../lib/storage/kvStorage.js
'use strict';{const VERSION=2;const STORE_NAME="keyvaluepairs";const DATABASE_PROMISE_MAP=new Map;const SUPPORTS_GETALL=typeof IDBObjectStore!=="undefined"&&typeof IDBObjectStore.prototype.getAll==="function";const SUPPORTS_GETALLKEYS=typeof IDBObjectStore!=="undefined"&&typeof IDBObjectStore.prototype.getAllKeys==="function";function asyncifyRequest(request){return new Promise((res,rej)=>{request.onsuccess=()=>res(request.result);request.onerror=()=>rej(request.error)})}function asyncifyTransaction(tx){return new Promise((res,
rej)=>{tx.oncomplete=()=>res();tx.onerror=()=>rej(tx.error);tx.onabort=()=>rej(tx.error)})}function openReadOnlyTransaction(name,method){return openTransaction(name,method)}function openWriteTransaction(name,method){return openTransaction(name,method,true)}async function openTransaction(name,method,write=false,allowRetry=true){const db=await lazyOpenDatabase(name);try{const tx=db.transaction([STORE_NAME],write?"readwrite":"readonly");return method(tx)}catch(err){if(allowRetry&&err["name"]==="InvalidStateError"){DATABASE_PROMISE_MAP.delete(name);
return openTransaction(name,method,write,false)}else throw err;}}function lazyOpenDatabase(name){RequireString(name);let dbPromise=DATABASE_PROMISE_MAP.get(name);if(!(dbPromise instanceof Promise)){dbPromise=openDatabase(name);DATABASE_PROMISE_MAP.set(name,dbPromise);dbPromise.catch(err=>DATABASE_PROMISE_MAP.delete(name))}return dbPromise}async function openDatabase(name){RequireString(name);const openRequest=indexedDB.open(name,VERSION);openRequest.addEventListener("upgradeneeded",e=>{try{const db=
e.target.result;db.createObjectStore(STORE_NAME)}catch(err){console.error(`Failed to create objectstore for database ${name}`,err)}});return asyncifyRequest(openRequest)}function RequireString(x){if(typeof x!=="string")throw new TypeError("expected string");}function getEntriesFromCursor(tx,type){const request=tx.objectStore(STORE_NAME).openCursor();return new Promise(resolve=>{const results=[];request.onsuccess=event=>{const cursor=event.target.result;if(cursor){switch(type){case "entries":results.push([cursor.key,
cursor.value]);break;case "keys":results.push(cursor.key);break;case "values":results.push(cursor.value);break}cursor.continue()}else resolve(results)}})}class KVStorageContainer{constructor(name){RequireString(name);this.name=name}async ready(){await lazyOpenDatabase(this.name)}set(key,value){RequireString(key);return openWriteTransaction(this.name,async tx=>{const request=tx.objectStore(STORE_NAME).put(value,key);const requestPromise=asyncifyRequest(request);const txPromise=asyncifyTransaction(tx);
await Promise.all([txPromise,requestPromise])})}get(key){RequireString(key);return openReadOnlyTransaction(this.name,async tx=>{const request=tx.objectStore(STORE_NAME).get(key);const requestPromise=asyncifyRequest(request);const txPromise=asyncifyTransaction(tx);const [_,value]=await Promise.all([txPromise,requestPromise]);return value})}delete(key){RequireString(key);return openWriteTransaction(this.name,async tx=>{const request=tx.objectStore(STORE_NAME).delete(key);const requestPromise=asyncifyRequest(request);
const txPromise=asyncifyTransaction(tx);await Promise.all([txPromise,requestPromise])})}clear(){return openWriteTransaction(this.name,async tx=>{const request=tx.objectStore(STORE_NAME).clear();const requestPromise=asyncifyRequest(request);const txPromise=asyncifyTransaction(tx);await Promise.all([txPromise,requestPromise])})}keys(){return openReadOnlyTransaction(this.name,async tx=>{let requestPromise;if(SUPPORTS_GETALLKEYS){const request=tx.objectStore(STORE_NAME).getAllKeys();requestPromise=asyncifyRequest(request)}else requestPromise=
getEntriesFromCursor(tx,"keys");const txPromise=asyncifyTransaction(tx);const [_,value]=await Promise.all([txPromise,requestPromise]);return value})}values(){return openReadOnlyTransaction(this.name,async tx=>{let requestPromise;if(SUPPORTS_GETALL){const request=tx.objectStore(STORE_NAME).getAll();requestPromise=asyncifyRequest(request)}else requestPromise=getEntriesFromCursor(tx,"values");const txPromise=asyncifyTransaction(tx);const [_,value]=await Promise.all([txPromise,requestPromise]);return value})}entries(){return openReadOnlyTransaction(this.name,
async tx=>{const requestPromise=getEntriesFromCursor(tx,"entries");const txPromise=asyncifyTransaction(tx);const [_,value]=await Promise.all([txPromise,requestPromise]);return value})}}self.KVStorageContainer=KVStorageContainer};


// ../lib/storage/localForageAdaptor.js
'use strict';{const KVStorageContainer=self.KVStorageContainer;const CRITICAL_ERRORS=[/no available storage method found/i,/an attempt was made to break through the security policy of the user agent/i,/the user denied permission to access the database/i,/a mutation operation was attempted on a database that did not allow mutations/i,/idbfactory\.open\(\) called in an invalid security context/i];const memoryStorage=new WeakMap;let isInMemory=false;if(typeof indexedDB==="undefined"){isInMemory=true;
console.warn("Unable to use local storage because indexedDB is not defined")}function NOT_IMPLEMENTED(name){throw new Error(`"${name}" is not implemented`);}function DISALLOW_CALLBACK(fn){if(typeof fn==="function")throw new Error(`localforage callback API is not implemented; please use the promise API instead`);}function StructuredClone(value){if(typeof value==="object")return new Promise(resolve=>{const {port1,port2}=new MessageChannel;port2.onmessage=ev=>resolve(ev.data);port1.postMessage(value)});
else return Promise.resolve(value)}class ForageAdaptor{constructor(inst){this._inst=inst;memoryStorage.set(this,new Map)}_MaybeSwitchToMemoryFallback(err){if(isInMemory)return;for(const regex of CRITICAL_ERRORS)if(err&&regex.test(err.message)){console.error("Unable to use local storage, reverting to in-memory store: ",err,err.message);isInMemory=true;break}}async _getItemFallback(name){const value=memoryStorage.get(this).get(name);const ret=await StructuredClone(value);return typeof ret==="undefined"?
null:ret}async _setItemFallback(name,value){value=await StructuredClone(value);memoryStorage.get(this).set(name,value)}_removeItemFallback(name){memoryStorage.get(this).delete(name)}_clearFallback(){memoryStorage.get(this).clear()}_keysFallback(){return Array.from(memoryStorage.get(this).keys())}IsUsingFallback(){return isInMemory}async getItem(key,successCallback){DISALLOW_CALLBACK(successCallback);if(isInMemory)return await this._getItemFallback(key);let result;try{result=await this._inst.get(key)}catch(err){this._MaybeSwitchToMemoryFallback(err);
if(isInMemory)return await this._getItemFallback(key);else{console.error(`Error reading '${key}' from storage, returning null: `,err);return null}}return typeof result==="undefined"?null:result}async setItem(key,value,successCallback){DISALLOW_CALLBACK(successCallback);if(typeof value==="undefined")value=null;if(isInMemory){await this._setItemFallback(key,value);return}try{await this._inst.set(key,value)}catch(err){this._MaybeSwitchToMemoryFallback(err);if(isInMemory)await this._setItemFallback(key,
value);else throw err;}}async removeItem(key,successCallback){DISALLOW_CALLBACK(successCallback);if(isInMemory){this._removeItemFallback(key);return}try{await this._inst.delete(key)}catch(err){this._MaybeSwitchToMemoryFallback(err);if(isInMemory)this._removeItemFallback(key);else console.error(`Error removing '${key}' from storage: `,err)}}async clear(successCallback){DISALLOW_CALLBACK(successCallback);if(isInMemory){this._clearFallback();return}try{await this._inst.clear()}catch(err){this._MaybeSwitchToMemoryFallback(err);
if(isInMemory)this._clearFallback();else console.error(`Error clearing storage: `,err)}}async keys(successCallback){DISALLOW_CALLBACK(successCallback);if(isInMemory)return this._keysFallback();let result=[];try{result=await this._inst.keys()}catch(err){this._MaybeSwitchToMemoryFallback(err);if(isInMemory)return this._keysFallback();else console.error(`Error getting storage keys: `,err)}return result}ready(successCallback){DISALLOW_CALLBACK(successCallback);if(isInMemory)return Promise.resolve(true);
else return this._inst.ready()}createInstance(options){if(typeof options!=="object")throw new TypeError("invalid options object");const name=options["name"];if(typeof name!=="string")throw new TypeError("invalid store name");const inst=new KVStorageContainer(name);return new ForageAdaptor(inst)}length(successCallback){NOT_IMPLEMENTED("localforage.length()")}key(index,successCallback){NOT_IMPLEMENTED("localforage.key()")}iterate(iteratorCallback,successCallback){NOT_IMPLEMENTED("localforage.iterate()")}setDriver(driverName){NOT_IMPLEMENTED("localforage.setDriver()")}config(options){NOT_IMPLEMENTED("localforage.config()")}defineDriver(customDriver){NOT_IMPLEMENTED("localforage.defineDriver()")}driver(){NOT_IMPLEMENTED("localforage.driver()")}supports(driverName){NOT_IMPLEMENTED("localforage.supports()")}dropInstance(){NOT_IMPLEMENTED("localforage.dropInstance()")}disableMemoryMode(){isInMemory=
false}}self["localforage"]=new ForageAdaptor(new KVStorageContainer("localforage"))};


// ../lib/misc/supports.js
'use strict';{const C3=self.C3;C3.Supports={};C3.Supports.WebAnimations=(()=>{try{if(C3.Platform.Browser==="Safari")return false;if(typeof document==="undefined")return false;const e=document.createElement("div");if(typeof e.animate==="undefined")return false;const player=e.animate([{opacity:"0"},{opacity:"1"}],1E3);return typeof player.reverse!=="undefined"}catch(e){return false}})();C3.Supports.DialogElement=typeof HTMLDialogElement!=="undefined";C3.Supports.RequestIdleCallback=!!self.requestIdleCallback;
C3.Supports.ImageBitmap=!!self.createImageBitmap;C3.Supports.ImageBitmapOptions=false;if(C3.Supports.ImageBitmap)try{self.createImageBitmap(new ImageData(32,32),{premultiplyAlpha:"none"}).then(imageBitmap=>{C3.Supports.ImageBitmapOptions=true}).catch(err=>{C3.Supports.ImageBitmapOptions=false})}catch(e){C3.Supports.ImageBitmapOptions=false}C3.Supports.ClipboardReadText=!!(navigator["clipboard"]&&navigator["clipboard"]["readText"]&&C3.Platform.Browser!=="Firefox");C3.Supports.PermissionsQuery=!!(navigator["permissions"]&&
navigator["permissions"]["query"]);C3.Supports.Proxies=typeof Proxy!=="undefined";C3.Supports.DownloadAttribute=(()=>{if(typeof document==="undefined")return false;const a=document.createElement("a");return typeof a.download!=="undefined"})();C3.Supports.CanvasToBlob=(()=>{return typeof HTMLCanvasElement!=="undefined"&&HTMLCanvasElement.prototype.toBlob})();C3.Supports.Fetch=typeof fetch==="function";C3.Supports.PersistentStorage=!!(self.isSecureContext&&C3.Platform.Browser!=="Opera"&&(navigator["storage"]&&
navigator["storage"]["persist"]));C3.Supports.StorageQuotaEstimate=!!(self.isSecureContext&&(navigator["storage"]&&navigator["storage"]["estimate"]));C3.Supports.Fullscreen=(()=>{if(typeof document==="undefined")return false;if(C3.Platform.OS==="iOS")return false;const elem=document.documentElement;return!!(elem.requestFullscreen||elem.msRequestFullscreen||elem.mozRequestFullScreen||elem.webkitRequestFullscreen)})();C3.Supports.ImageDecoder=typeof self["ImageDecoder"]!=="undefined";C3.Supports.NativeFileSystemAPI=
!!self["showOpenFilePicker"];C3.Supports.NavigatorFontsQuery=!!(navigator["fonts"]&&navigator["fonts"]["query"])};


// ../lib/misc/polyfills.js
'use strict';{const C3=self.C3;if(!String.prototype.trimStart){const startWhitespace=/^[\x09\x0A\x0B\x0C\x0D\x20\xA0\u1680\u180E\u2000\u2001\u2002\u2003\u2004\u2005\u2006\u2007\u2008\u2009\u200A\u202F\u205F\u3000\u2028\u2029\uFEFF]*/;String.prototype.trimStart=function trimStart(){return this.replace(startWhitespace,"")}}if(!String.prototype.trimEnd){const endWhitespace=/[\x09\x0A\x0B\x0C\x0D\x20\xA0\u1680\u180E\u2000\u2001\u2002\u2003\u2004\u2005\u2006\u2007\u2008\u2009\u200A\u202F\u205F\u3000\u2028\u2029\uFEFF]*$/;
String.prototype.trimEnd=function trimEnd(){return this.replace(endWhitespace,"")}}if(!String.prototype.replaceAll)String.prototype.replaceAll=function replaceAll(find,replace){return this.replace(new RegExp(C3.EscapeRegex(find),"g"),replace)};if(!Array.prototype.values)Array.prototype.values=function*(){for(const i of this)yield i};if(!Array.prototype.flat){function arrayFlat(arr,depth){return arr.reduce((acc,val)=>{if(depth>0&&Array.isArray(val)){Array.prototype.push.apply(acc,arrayFlat(val,depth-
1));return acc}else{acc.push(val);return acc}},[])}Array.prototype.flat=function(depth=1){return arrayFlat(this,depth)}}if(!RegExp.escape)RegExp.escape=function(s){return String(s).replace(/[\\^$*+?.()|[\]{}]/g,"\\$&")};if(navigator["storage"]&&!navigator["storage"]["estimate"]&&navigator["webkitTemporaryStorage"]&&navigator["webkitTemporaryStorage"]["queryUsageAndQuota"])navigator["storage"]["estimate"]=function(){return new Promise((resolve,reject)=>{return navigator["webkitTemporaryStorage"]["queryUsageAndQuota"]((usage,
quota)=>resolve({"usage":usage,"quota":quota}),reject)})};if(typeof HTMLCollection!=="undefined"&&!HTMLCollection.prototype[Symbol.iterator])HTMLCollection.prototype[Symbol.iterator]=function(){let i=0;return{next:()=>{if(i>=this.length)return{done:true};else return{value:this.item(i++),done:false}}}};if(typeof NodeList!=="undefined"&&!NodeList.prototype[Symbol.iterator])NodeList.prototype[Symbol.iterator]=function(){let i=0;return{next:()=>{if(i>=this.length)return{done:true};else return{value:this.item(i++),
done:false}}}};if(typeof DOMTokenList!=="undefined"&&!DOMTokenList.prototype[Symbol.iterator])DOMTokenList.prototype[Symbol.iterator]=function(){let i=0;return{next:()=>{if(i>=this.length)return{done:true};else return{value:this.item(i++),done:false}}}};if(typeof FileList!=="undefined"&&!FileList.prototype[Symbol.iterator])FileList.prototype[Symbol.iterator]=function(){let i=0;return{next:()=>{if(i>=this.length)return{done:true};else return{value:this.item(i++),done:false}}}};if(typeof TextEncoder===
"undefined"){self.TextEncoder=class TextEncoder{constructor(){Object.defineProperty(this,"encoding",{"value":"utf-8","writable":false})}encode(str){var Len=str.length,resPos=-1;var resArr=new Uint8Array(Len*3);for(var point=0,nextcode=0,i=0;i!==Len;){point=str.charCodeAt(i),i+=1;if(point>=55296&&point<=56319){if(i===Len){resArr[resPos+=1]=239;resArr[resPos+=1]=191;resArr[resPos+=1]=189;break}nextcode=str.charCodeAt(i);if(nextcode>=56320&&nextcode<=57343){point=(point-55296)*1024+nextcode-56320+65536;
i+=1;if(point>65535){resArr[resPos+=1]=30<<3|point>>>18;resArr[resPos+=1]=2<<6|point>>>12&63;resArr[resPos+=1]=2<<6|point>>>6&63;resArr[resPos+=1]=2<<6|point&63;continue}}else{resArr[resPos+=1]=239;resArr[resPos+=1]=191;resArr[resPos+=1]=189;continue}}if(point<=127)resArr[resPos+=1]=0<<7|point;else if(point<=2047){resArr[resPos+=1]=6<<5|point>>>6;resArr[resPos+=1]=2<<6|point&63}else{resArr[resPos+=1]=14<<4|point>>>12;resArr[resPos+=1]=2<<6|point>>>6&63;resArr[resPos+=1]=2<<6|point&63}}return new Uint8Array(resArr.buffer.slice(0,
resPos+1))}toString(){return"[object TextEncoder]"}};TextEncoder[Symbol.toStringTag]="TextEncoder"}if(typeof TextDecoder==="undefined"){function persist(iterable){const itr=iterable[Symbol.iterator]();return{next:_=>itr.next(),[Symbol.iterator](){return this}}}function readNext(bytes){const n=bytes.next();if(n.done)throw new Error("unexpected end of input");if((n.value&192^128)!=0)throw new Error("invalid byte");return n.value&63}const _decoders=new Map;_decoders.set("utf-8",(arr,fatal)=>{let view;
if(arr.buffer)view=new Uint8Array(arr.buffer,arr.byteOffset,arr.byteLength);else if(view instanceof ArrayBuffer)view=new Uint8Array(arr);else throw new Error("Invalid parameter");const bytes=persist(view);const result=[];try{for(const ch of bytes){let val;if(ch<127)val=ch&127;else if(ch<223)val=(ch&31)<<6|readNext(bytes);else if(ch<239)val=(ch&15)<<12|readNext(bytes)<<6|readNext(bytes);else if(ch<247)val=(ch&7)<<18|readNext(bytes)<<12|readNext(bytes)<<6|readNext(bytes);else throw new Error("Invalid character");
result.push(String.fromCodePoint(val))}}catch(e){if(fatal)throw e;result.push("\ufffd")}return result.join("")});_decoders.set("utf8",_decoders.get("utf-8"));_decoders.set("utf-16le",(arr,fatal)=>{throw new Error("utf-16le decoder not implemented");});self.TextDecoder=class TextDecoder{constructor(label="utf-8",options={}){const decoder=_decoders.get(label);if(!decoder)throw new Error(`TextDecoder polyfill does not support "${label}"`);Object.defineProperty(this,"fatal",{"value":options["fatal"]===
true,"writable":false});Object.defineProperty(this,"_decoder",{"value":decoder,"writable":false});Object.defineProperty(this,"encoding",{"value":label,"writable":false})}decode(arr){return this["_decoder"](arr,this["fatal"])}toString(){return"[object TextDecoder]"}};TextDecoder[Symbol.toStringTag]="TextDecoder"}if(typeof self.isSecureContext==="undefined")self.isSecureContext=location.protocol==="https:";if(typeof self["globalThis"]==="undefined")self["globalThis"]=self};


// c3/lib/misc/assert.js
'use strict';{const C3=self.C3;function assertFail(msg_){let stack=C3.GetCallStack();let msg="Assertion failure: "+msg_+"\n\nStack trace:\n"+stack;console.error(msg)}self.assert=function assert(cnd_,msg_){if(!cnd_)assertFail(msg_)}};


// ../lib/misc/typeChecks.js
'use strict';{const C3=self.C3;const C3X=self.C3X;C3.IsNumber=function IsNumber(x){return typeof x==="number"};C3.IsFiniteNumber=function IsFiniteNumber(x){return C3.IsNumber(x)&&isFinite(x)};C3.RequireNumber=function RequireNumber(x){if(!C3.IsNumber(x))throw new TypeError("expected number");};C3.RequireOptionalNumber=function RequireOptionalNumber(x){if(C3.IsNullOrUndefined(x))return};C3.RequireNumberInRange=function RequireNumberInRange(x,low,high){if(!C3.IsNumber(x)||isNaN(x)||low>x||high<x)throw new RangeError("number outside of range");
};C3.RequireAllNumber=function RequireAllNumber(...args){for(let a of args);};C3.RequireFiniteNumber=function RequireFiniteNumber(x){if(!C3.IsFiniteNumber(x))throw new TypeError("expected finite number");};C3.RequireOptionalFiniteNumber=function RequireOptionalFiniteNumber(x){if(C3.IsNullOrUndefined(x))return};C3.RequireAllFiniteNumber=function RequireAllFiniteNumber(...args){for(let a of args);};C3.IsString=function IsString(x){return typeof x==="string"};C3.RequireString=function RequireString(x){if(!C3.IsString(x))throw new TypeError("expected string");
};C3.RequireOptionalString=function RequireOptionalString(x){if(C3.IsNullOrUndefined(x))return};C3.RequireAllString=function RequireAllString(...args){for(let a of args);};C3.IsSimpleObject=function IsSimpleObject(x){if(typeof x!=="object"||x===null)return false;let proto=Object.getPrototypeOf(x);return proto?proto.constructor===Object:proto===null};C3.RequireSimpleObject=function RequireSimpleObject(x){if(!C3.IsSimpleObject(x))throw new TypeError("expected simple object");};C3.RequireOptionalSimpleObject=
function RequireSimpleObject(x){if(C3.IsNullOrUndefined(x))return;if(!C3.IsSimpleObject(x))throw new TypeError("expected simple object");};C3.IsObject=function IsObject(x){return typeof x==="object"&&x!==null&&!Array.isArray(x)};C3.RequireObject=function RequireObject(x){if(!C3.IsObject(x))throw new TypeError("expected object");};C3.RequireOptionalObject=function RequireOptionalObject(x){if(C3.IsNullOrUndefined(x))return};C3.RequireAllObject=function RequireAllObject(...args){for(let a of args);};
C3.IsFileLike=function IsFileLike(x){return C3.IsInstanceOf(x,Blob)&&typeof x["name"]==="string"};C3.RequireFileLike=function RequireFileLike(x){if(!C3.IsFileLike(x))throw new TypeError("expected file");};C3.RequireOptionalFileLike=function RequireOptionalFileLike(x){if(C3.IsNullOrUndefined(x))return};C3.IsArray=function IsArray(x){return Array.isArray(x)};C3.RequireArray=function RequireArray(x){if(!C3.IsArray(x))throw new TypeError("expected array");};C3.RequireOptionalArray=function RequireOptionalArray(x){if(C3.IsNullOrUndefined(x))return};
C3.RequireAllArray=function RequireAllArray(...args){for(let a of args);};C3.Is2DArray=function(x){if(!C3.IsArray(x))return false;if(!x.length)return true;if(!C3.IsArray(x[0]))return false;return true};C3.Require2DArray=function Require2DArray(x){if(!C3.Is2DArray(x))throw new TypeError("expected 2d array");for(let arr of x)if(!C3.IsArray(arr))throw new TypeError("expected 2d array");};C3.RequireOptional2DArray=function Require2DArray(x){if(C3.IsNullOrUndefined(x))return};C3.IsFunction=function IsFunction(x){return typeof x===
"function"};C3.RequireFunction=function RequireFunction(x,f){if(!C3.IsFunction(x))throw new TypeError("expected function");if(!C3.IsNullOrUndefined(f))if(x!==f)throw new TypeError("expected same function reference");};C3.RequireOptionalFunction=function RequireOptionalFunction(x){if(C3.IsNullOrUndefined(x))return};C3.RequireAllFunction=function RequireAllFunction(...args){for(let a of args);};C3.RequireAnyFunction=function RequireAllFunction(x,...args){if(!C3.IsFunction(x))throw new TypeError("expected function");
if(!args.length)throw new Error("missing comparison functions");for(let a of args)if(!C3.IsNullOrUndefined(a))if(x===a)return;throw new TypeError("expected same function reference");};C3.RequireOptionalAllFunction=function RequireAllFunction(...args){if(C3.IsNullOrUndefined(args))return;for(let a of args);};C3.IsInstanceOf=function IsInstanceOf(x,t){return x instanceof t};C3.IsInstanceOfAny=function IsInstanceOfAny(x,...args){for(let t of args)if(C3.IsInstanceOf(x,t))return true;return false};C3.RequireInstanceOf=
function RequireInstanceOf(x,t){if(!C3.IsInstanceOf(x,t))throw new TypeError("unexpected type");};C3.RequireOptionalInstanceOf=function RequireOptionalInstanceOf(x,t){if(C3.IsNullOrUndefined(x))return};C3.RequireAllInstanceOf=function RequireAllInstanceOf(t,...args){for(let a of args);};C3.RequireAnyInstanceOf=function RequireAnyInstanceOf(x,...args){if(!C3.IsInstanceOfAny(x,...args))throw new TypeError("unexpected type");};C3.RequireAnyOptionalInstanceOf=function RequireAnyOptionalInstanceOf(x,...args){if(C3.IsNullOrUndefined(x))return;
if(!C3.IsInstanceOfAny(x,...args))throw new TypeError("unexpected type");};C3.IsArrayOf=function IsArrayOf(x,t){for(let i of x)if(!C3.IsInstanceOf(i,t))return false;return true};C3.IsArrayOfFiniteNumbers=function IsArrayOf(x){for(let i of x)if(!C3.IsFiniteNumber(i))return false;return true};C3.RequireArrayOf=function RequireArrayOf(x,t){for(let i of x);};C3.RequireOptionalArrayOf=function RequireOptionalArrayOf(x,t){if(C3.IsNullOrUndefined(x))return;for(let i of x);};C3.RequireArrayOfAny=function RequireArrayOf(x,
...args){for(let i of x);};C3.RequireOptionalArrayOfAny=function RequireOptionalArrayOfAny(x,...args){if(C3.IsNullOrUndefined(x))return;for(let i of x);};C3.IsDOMNode=function IsDOMNode(d,n){if(C3.IsNullOrUndefined(d)||!C3.IsString(d.nodeName))return false;return!n||C3.equalsNoCase(d.nodeName,n)};C3.RequireDOMNode=function RequireDOMNode(d,n){if(C3.IsNullOrUndefined(d)||!C3.IsString(d.nodeName))throw new TypeError("expected DOM node");if(n&&!C3.equalsNoCase(d.nodeName,n))throw new TypeError(`expected DOM '${n}' node`);
};C3.RequireOptionalDOMNode=function RequireOptionalDOMNode(d,n){if(C3.IsNullOrUndefined(d))return};C3.IsHTMLElement=function IsHTMLElement(e,t){if(C3.IsNullOrUndefined(e)||!C3.IsString(e.tagName))return false;return!t||C3.equalsNoCase(e.tagName,t)};C3.RequireHTMLElement=function RequireHTMLElement(e,t){if(C3.IsNullOrUndefined(e)||!C3.IsString(e.tagName))throw new TypeError("expected HTML element");if(t&&!C3.equalsNoCase(e.tagName,t))throw new TypeError(`expected HTML '${t}' element`);};C3.RequireOptionalHTMLElement=
function RequireOptionalHTMLElement(e,t){if(C3.IsNullOrUndefined(e))return};C3.IsDrawable=function IsDrawable(d){return C3.IsHTMLElement(d,"img")||C3.IsHTMLElement(d,"canvas")||C3.IsHTMLElement(d,"video")||typeof OffscreenCanvas!=="undefined"&&d instanceof OffscreenCanvas||typeof ImageBitmap!=="undefined"&&d instanceof ImageBitmap};C3.RequireDrawable=function RequireDrawable(d){if(!C3.IsDrawable(d))throw new TypeError("expected drawable");};C3.RequireOptionalDrawable=function RequireOptionalDrawable(d){if(C3.IsNullOrUndefined(d))return};
C3.IsDrawableOrImageData=function IsDrawableOrImageData(x){if(x instanceof ImageData)return true;return C3.IsDrawable(x)};C3.RequireDrawableOrImageData=function RequireDrawableOrImageData(d){if(!C3.IsDrawableOrImageData(d))throw new TypeError("expected drawable or image data");};C3.RequireOptionalDrawableOrImageData=function RequireOptionalDrawableOrImageData(d){if(C3.IsNullOrUndefined(d))return;if(!C3.IsDrawableOrImageData(d))throw new TypeError("expected drawable or image data");};C3.IsStringLike=
function IsStringLike(x){return typeof x==="string"||x instanceof C3.HtmlString||x instanceof C3.BBString};C3.RequireStringLike=function RequireStringLike(x){if(!C3.IsStringLike(x))throw new TypeError("expected string-like");};C3.RequireOptionalStringLike=function RequireOptionalStringLike(x){if(C3.IsNullOrUndefined(x))return};C3.RequireAllStringLike=function RequireAllStringLike(...args){for(let a of args);};C3.RequireOverride=function RequireOverride(){throw new Error("must be overridden");};C3.NotYetImplemented=
function NotYetImplemented(){throw new Error("not yet implemented");};C3.IsDefined=function isDefined(obj,...follow){let currentObject=obj;if(typeof currentObject==="undefined")return false;for(let key of follow){if(typeof currentObject[key]==="undefined")return false;currentObject=currentObject[key]}return true};C3.IsNullOrUndefined=function(x){return typeof x==="undefined"||x===null};C3.AreArrayElementsOfSameType=function(arr){let type=arr[0].constructor;for(let x of arr)if(x.constructor!==type)return false;
return type};C3.AreArrayElementsOfType=function(arr,t){for(let x of arr)if(!(x instanceof t))return false;return true};const TypedArray=Object.getPrototypeOf(Uint8Array);C3.IsTypedArray=function(view){return C3.IsInstanceOf(view,TypedArray)};C3.RequireTypedArray=function(view){};C3.WeakRequireTypedArray=function WeakRequireTypedArray(inst){C3.WeakRequireInstanceOf(inst,TypedArray)};C3.WeakRequireAnyInstanceOf=function WeakRequireAnyInstanceOf(inst,...ctors){if(!C3.WeakIsAnyInstanceOf(inst,...ctors))throw new TypeError("unexpected type");
};C3.WeakIsAnyInstanceOf=function WeakIsAnyInstanceOf(inst,...ctors){for(const ctor of ctors)if(C3.WeakIsInstanceOf(inst,ctor))return true;return false};C3.WeakRequireInstanceOf=function WeakRequireInstanceOf(inst,ctor){if(!C3.WeakIsInstanceOf(inst,ctor))throw new TypeError("unexpected type");};C3.WeakIsInstanceOf=function WeakIsInstanceOf(inst,ctor){while(inst=Object.getPrototypeOf(inst))if(inst.constructor.name===ctor.name)return true;return false};C3X.RequireNumber=C3.RequireNumber;C3X.RequireOptionalNumber=
C3.RequireOptionalNumber;C3X.RequireFiniteNumber=C3.RequireFiniteNumber;C3X.RequireOptionalFiniteNumber=C3.RequireOptionalFiniteNumber;C3X.RequireString=C3.RequireString;C3X.RequireOptionalString=C3.RequireOptionalString;C3X.RequireObject=C3.RequireObject;C3X.RequireOptionalObject=C3.RequireOptionalObject;C3X.RequireArray=C3.RequireArray;C3X.RequireOptionalArray=C3.RequireOptionalArray;C3X.RequireFunction=C3.RequireFunction;C3X.RequireOptionalFunction=C3.RequireOptionalFunction;C3X.RequireInstanceOf=
C3.RequireInstanceOf;C3X.RequireOptionalInstanceOf=C3.RequireOptionalInstanceOf;C3X.IsNullOrUndefined=C3.IsNullOrUndefined};


// ../lib/misc/jsutil.js
'use strict';{const C3=self.C3;const logRafIds=new Map;C3.RafLog=function RaFLog(name,...args){if(!logRafIds.has(name))logRafIds.set(name,-1);if(logRafIds.get(name)===-1)logRafIds.set(name,requestAnimationFrame(()=>{console.log(`%c${name}`,"font-weight: bold",...args);logRafIds.set(name,-1)}))};C3.GetCallStack=function GetCallStack(){return(new Error).stack};C3.Debugger=function Debugger(){debugger};C3.cast=function cast(o,T){if(o&&o instanceof T)return o;else return null};C3.getName=function getName(o){if(typeof o===
"undefined")return"undefined";if(o===null)return"null";if(typeof o==="boolean")return"<boolean>";if(C3.IsNumber(o))return"<number>";if(C3.IsString(o))return"<string>";if(C3.IsArray(o))return"<array>";if(typeof o==="symbol")return"<"+o.toString()+">";if(C3.IsFunction(o)){if(o.name&&o.name!=="Function")return o.name;return"<anonymous function>"}if(typeof o==="object"){if(o.constructor&&o.constructor.name&&o.constructor.name!=="Object")return o.constructor.name;return"<anonymous object>"}return"<unknown>"};
C3.getType=function getType(o){if(o===null)return"null";if(Array.isArray(o))return"array";return typeof o};C3.range=function*range(a,b){if(!isFinite(Math.abs(a-b)))throw new Error("Invalid parameters");if(a>b)for(let i=a-1;i>=b;i--)yield i;else for(let i=a;i<b;i++)yield i};function isValidTypeChange(from,to){let fromType=C3.getType(from);let toType=C3.getType(to);if(fromType==="null"||toType==="null")return true;if(fromType==="undefined"||toType==="undefined")return false;return fromType===toType}
let ctorObjectToProxy=new Map;let ctorProxyToObject=new Map;let proxyToObject=new WeakMap;let releasedObjects=new WeakMap;C3.DefendHandler={};const VALID_GET_MISSING_KEYS=new Set(["then","splice"]);function logDefendedObjectWarning(msg){console.warn("[Defence] "+msg+" @",C3.GetCallStack())}C3.DefendHandler.get=function defended_get(target,key){if(!(key in target)&&typeof key!=="symbol"&&!VALID_GET_MISSING_KEYS.has(key))logDefendedObjectWarning(`Accessed missing property '${key}' from defended object '${C3.getName(target)}', returning undefined`);
if(releasedObjects.has(target)&&typeof key!=="symbol"&&!VALID_GET_MISSING_KEYS.has(key))logDefendedObjectWarning(`Accessed property '${key}' on a released object '${C3.getName(target)}'\nObject was originally released at: ${releasedObjects.get(target)})\nCall stack at access: `);return target[key]};C3.DefendHandler.set=function defended_set(target,key,value){if(!(key in target)&&!ctorObjectToProxy.has(target))logDefendedObjectWarning(`Set non-existent property '${key}' to '${value}' on defended object '${C3.getName(target)}'`);
if(!isValidTypeChange(target[key],value)&&!ctorObjectToProxy.has(target))logDefendedObjectWarning(`Set '${C3.getType(target[key])}' property '${key}' to type '${C3.getType(value)}' on defended object '${C3.getName(target)}'`);if(releasedObjects.has(target))logDefendedObjectWarning(`Set property '${key}' on a released object '${C3.getName(target)}'\nObject was originally released at: ${releasedObjects.get(target)})\nCall stack at access: `);target[key]=value;return true};C3.DefendHandler.deleteProperty=
function defended_deleteProperty(target,key){throw new ReferenceError(`Cannot delete property '${key}' from defended object '${C3.getName(target)}'`);};C3.DefendHandler.defineProperty=function defended_defineProperty(target,key,desc){throw new ReferenceError(`Cannot define property '${key}' on defended object '${C3.getName(target)}'`);};C3.DefendHandler.enumerate=function defended_enumerate(target){throw new ReferenceError(`Cannot enumerate defended object '${C3.getName(target)}'`);};let checkRafId=
-1;function CheckDefendedObjectsUsedCorrectly(){checkRafId=-1;if(ctorObjectToProxy.size>0||ctorProxyToObject.size>0){let uniqueNames=new Set([...ctorObjectToProxy.keys()].map(o=>C3.getName(o)));let leftoverNames=[...uniqueNames].join(",");console.warn(`An object derived from DefendedBase was not protected with debugDefend(). This will disable some checks. See the coding guidelines! Possible affected class names: ${leftoverNames}`);ctorObjectToProxy.clear();ctorProxyToObject.clear()}}C3.DefendedBase=
class DefendedBase{constructor(){if(!C3.isDebugDefend||!C3.Supports.Proxies)return;let newTarget=new.target;let realObject=Object.create(newTarget.prototype);let proxy=new Proxy(realObject,C3.DefendHandler);ctorObjectToProxy.set(realObject,proxy);ctorProxyToObject.set(proxy,realObject);proxyToObject.set(proxy,realObject);if(checkRafId===-1)checkRafId=requestAnimationFrame(CheckDefendedObjectsUsedCorrectly);return proxy}};C3.debugDefend=function debugDefend(o){if(C3.isDebugDefend&&C3.Supports.Proxies&&
o instanceof C3.DefendedBase){if(!ctorProxyToObject.has(o))return o;let realObject=ctorProxyToObject.get(o);ctorProxyToObject.delete(o);ctorObjectToProxy.delete(realObject);return o}else if(C3.isDebug)return Object.seal(o);else return o};C3.New=function New(Type,...args){let o;try{o=new Type(...args)}catch(e){ctorProxyToObject.clear();ctorObjectToProxy.clear();throw e;}if(C3.isDebugDefend)VerifyObjectPropertiesConsistent(Type,o);return C3.debugDefend(o)};C3.Release=function Release(o){let realObject=
proxyToObject.get(o);if(realObject)releasedObjects.set(realObject,C3.GetCallStack())};C3.WasReleased=function(o){let realObject=proxyToObject.get(o);if(!realObject)return false;return!!releasedObjects.get(realObject)};let typeProperties=new Map;function getObjectPropertySet(o){let ret=new Set;for(let k in o)ret.add(k);return ret}function VerifyObjectPropertiesConsistent(Type,o){let properties=getObjectPropertySet(o);let existingProperties=typeProperties.get(Type);if(existingProperties){let inconsistentProperties=
[];for(let k of existingProperties.values())if(properties.has(k))properties.delete(k);else inconsistentProperties.push(k);C3.appendArray(inconsistentProperties,[...properties]);if(inconsistentProperties.length)console.warn(`[Defence] '${C3.getName(Type)}' constructor creates inconsistent properties: ${inconsistentProperties.join(", ")}`)}else typeProperties.set(Type,properties)}C3.PerfMark=class PerfMark{constructor(name){this._name="";if(name)this.start(name)}start(name){this._name=name;performance.mark(this._name+
"-Start")}end(){performance.mark(this._name+"-End");performance.measure(this._name,this._name+"-Start",this._name+"-End")}next(name){this.end();this._name=name;performance.mark(this._name+"-Start")}}};


// ../lib/misc/mathutil.js
'use strict';{const C3=self.C3;const TWO_PI=Math.PI*2;const D_TO_R=Math.PI/180;const R_TO_D=180/Math.PI;C3.wrap=function wrap(x,min,max){x=Math.floor(x);min=Math.floor(min);max=Math.floor(max);if(x<min){let r=max-(min-x)%(max-min);return r===max?0:r}else return min+(x-min)%(max-min)};C3.mapToRange=function mapToRange(x,inMin,inMax,outMin,outMax){return(x-inMin)*(outMax-outMin)/(inMax-inMin)+outMin};C3.normalize=function normalize(value,minimum,maximum){return(value-minimum)/(maximum-minimum)};C3.clamp=
function clamp(x,a,b){if(x<a)return a;else if(x>b)return b;else return x};C3.clampAngle=function clampAngle(a){a%=TWO_PI;if(a<0)a+=TWO_PI;return a};C3.toRadians=function toRadians(x){return x*D_TO_R};C3.toDegrees=function toDegrees(x){return x*R_TO_D};C3.distanceTo=function distanceTo(x1,y1,x2,y2){return Math.hypot(x2-x1,y2-y1)};C3.distanceSquared=function distanceSquared(x1,y1,x2,y2){const dx=x2-x1;const dy=y2-y1;return dx*dx+dy*dy};C3.angleTo=function angleTo(x1,y1,x2,y2){return Math.atan2(y2-y1,
x2-x1)};C3.angleDiff=function angleDiff(a1,a2){if(a1===a2)return 0;let s1=Math.sin(a1);let c1=Math.cos(a1);let s2=Math.sin(a2);let c2=Math.cos(a2);let n=s1*s2+c1*c2;if(n>=1)return 0;if(n<=-1)return Math.PI;return Math.acos(n)};C3.angleRotate=function angleRotate(start,end,step){let ss=Math.sin(start);let cs=Math.cos(start);let se=Math.sin(end);let ce=Math.cos(end);if(Math.acos(ss*se+cs*ce)>step)if(cs*se-ss*ce>0)return C3.clampAngle(start+step);else return C3.clampAngle(start-step);else return C3.clampAngle(end)};
C3.angleClockwise=function angleClockwise(a1,a2){let s1=Math.sin(a1);let c1=Math.cos(a1);let s2=Math.sin(a2);let c2=Math.cos(a2);return c1*s2-s1*c2<=0};C3.angleLerp=function angleLerp(a,b,x,r=0){let diff=C3.angleDiff(a,b);const revs=TWO_PI*r;if(C3.angleClockwise(b,a))return C3.clampAngle(a+(diff+revs)*x);else return C3.clampAngle(a-(diff+revs)*x)};C3.angleLerpClockwise=function angleLerpClockwise(a,b,x,r=0){const diff=C3.angleDiff(a,b);const revs=TWO_PI*r;if(C3.angleClockwise(b,a))return C3.clampAngle(a+
(diff+revs)*x);return C3.clampAngle((TWO_PI-diff+revs)*x)};C3.angleLerpAntiClockwise=function angleLerpAntiClockwise(a,b,x,r=0){const diff=C3.angleDiff(a,b);const revs=TWO_PI*r;if(C3.angleClockwise(b,a))return C3.clampAngle((-TWO_PI+diff-revs)*x);return C3.clampAngle(a-(diff+revs)*x)};C3.lerp=function lerp(a,b,x){return a+x*(b-a)};C3.unlerp=function unlerp(a,b,x){if(a===b)return 0;return(x-a)/(b-a)};C3.relerp=function relerp(a,b,x,c,d){return C3.lerp(c,d,C3.unlerp(a,b,x))};C3.qarp=function qarp(a,
b,c,x){return C3.lerp(C3.lerp(a,b,x),C3.lerp(b,c,x),x)};C3.cubic=function cubic(a,b,c,d,x){return C3.lerp(C3.qarp(a,b,c,x),C3.qarp(b,c,d,x),x)};C3.cosp=function cosp(a,b,x){return(a+b+(a-b)*Math.cos(x*Math.PI))/2};C3.isPOT=function isPOT(x){return x>0&&(x-1&x)===0};C3.nextHighestPowerOfTwo=function nextHighestPowerOfTwo(x){--x;for(let i=1;i<32;i<<=1)x=x|x>>i;return x+1};C3.roundToNearestFraction=function roundToNearestFraction(x,n){return Math.round(x*n)/n};C3.floorToNearestFraction=function floorToNearestFraction(x,
n){return Math.floor(x*n)/n};C3.round6dp=function round6dp(x){return Math.round(x*1E6)/1E6};C3.toFixed=function toFixed(n,dp){let ret=n.toFixed(dp);let last=ret.length-1;for(;last>=0&&ret.charAt(last)==="0";--last);if(last>=0&&ret.charAt(last)===".")--last;if(last<0)return ret;return ret.substr(0,last+1)};C3.PackRGB=function PackRGB(red,green,blue){return C3.clamp(red,0,255)|C3.clamp(green,0,255)<<8|C3.clamp(blue,0,255)<<16};const ALPHAEX_SHIFT=1024;const ALPHAEX_MAX=1023;const RGBEX_SHIFT=16384;
const RGBEX_MAX=8191;const RGBEX_MIN=-8192;C3.PackRGBAEx=function PackRGBAEx(red,green,blue,alpha){red=C3.clamp(Math.floor(red*1024),RGBEX_MIN,RGBEX_MAX);green=C3.clamp(Math.floor(green*1024),RGBEX_MIN,RGBEX_MAX);blue=C3.clamp(Math.floor(blue*1024),RGBEX_MIN,RGBEX_MAX);alpha=C3.clamp(Math.floor(alpha*ALPHAEX_MAX),0,ALPHAEX_MAX);if(red<0)red+=RGBEX_SHIFT;if(green<0)green+=RGBEX_SHIFT;if(blue<0)blue+=RGBEX_SHIFT;return-(red*RGBEX_SHIFT*RGBEX_SHIFT*ALPHAEX_SHIFT+green*RGBEX_SHIFT*ALPHAEX_SHIFT+blue*
ALPHAEX_SHIFT+alpha)};C3.PackRGBEx=function PackRGBEx(red,green,blue){return C3.PackRGBAEx(red,green,blue,1)};function isNegativeZero(x){return x===0&&1/x<0}C3.GetRValue=function GetRValue(rgb){if(rgb>=0)return(rgb&255)/255;else{let v=Math.floor(-rgb/(RGBEX_SHIFT*RGBEX_SHIFT*ALPHAEX_SHIFT));if(v>RGBEX_MAX)v-=RGBEX_SHIFT;return v/1024}};C3.GetGValue=function GetGValue(rgb){if(rgb>=0)return((rgb&65280)>>8)/255;else{let v=Math.floor(-rgb%(RGBEX_SHIFT*RGBEX_SHIFT*ALPHAEX_SHIFT)/(RGBEX_SHIFT*ALPHAEX_SHIFT));
if(v>RGBEX_MAX)v-=RGBEX_SHIFT;return v/1024}};C3.GetBValue=function GetBValue(rgb){if(rgb>=0)return((rgb&16711680)>>16)/255;else{let v=Math.floor(-rgb%(RGBEX_SHIFT*ALPHAEX_SHIFT)/ALPHAEX_SHIFT);if(v>RGBEX_MAX)v-=RGBEX_SHIFT;return v/1024}};C3.GetAValue=function GetAValue(rgb){if(isNegativeZero(rgb))return 0;else if(rgb>=0)return 1;else{const v=Math.floor(-rgb%ALPHAEX_SHIFT);return v/ALPHAEX_MAX}};C3.greatestCommonDivisor=function greatestCommonDivisor(a,b){a=Math.floor(a);b=Math.floor(b);while(b!==
0){let t=b;b=a%b;a=t}return a};const COMMON_ASPECT_RATIOS=[[3,2],[4,3],[5,4],[5,3],[6,5],[14,9],[16,9],[16,10],[21,9]];C3.getAspectRatio=function getAspectRatio(w,h){w=Math.floor(w);h=Math.floor(h);if(w===h)return[1,1];for(let aspect of COMMON_ASPECT_RATIOS){let approxH=w/aspect[0]*aspect[1];if(Math.abs(h-approxH)<1)return aspect.slice(0);approxH=w/aspect[1]*aspect[0];if(Math.abs(h-approxH)<1)return[aspect[1],aspect[0]]}let gcd=C3.greatestCommonDivisor(w,h);return[w/gcd,h/gcd]};C3.segmentsIntersect=
function segmentsIntersect(a1x,a1y,a2x,a2y,b1x,b1y,b2x,b2y){const min_ax=Math.min(a1x,a2x);const max_ax=Math.max(a1x,a2x);const min_bx=Math.min(b1x,b2x);const max_bx=Math.max(b1x,b2x);if(max_ax<min_bx||min_ax>max_bx)return false;const min_ay=Math.min(a1y,a2y);const max_ay=Math.max(a1y,a2y);const min_by=Math.min(b1y,b2y);const max_by=Math.max(b1y,b2y);if(max_ay<min_by||min_ay>max_by)return false;const dpx=b1x-a1x+b2x-a2x;const dpy=b1y-a1y+b2y-a2y;const qax=a2x-a1x;const qay=a2y-a1y;const qbx=b2x-b1x;
const qby=b2y-b1y;const d=Math.abs(qay*qbx-qby*qax);const la=qbx*dpy-qby*dpx;if(Math.abs(la)>d)return false;const lb=qax*dpy-qay*dpx;return Math.abs(lb)<=d};C3.segmentsIntersectPreCalc=function segmentsIntersectPreCalc(a1x,a1y,a2x,a2y,min_ax,max_ax,min_ay,max_ay,b1x,b1y,b2x,b2y){const min_bx=Math.min(b1x,b2x);const max_bx=Math.max(b1x,b2x);if(max_ax<min_bx||min_ax>max_bx)return false;const min_by=Math.min(b1y,b2y);const max_by=Math.max(b1y,b2y);if(max_ay<min_by||min_ay>max_by)return false;const dpx=
b1x-a1x+b2x-a2x;const dpy=b1y-a1y+b2y-a2y;const qax=a2x-a1x;const qay=a2y-a1y;const qbx=b2x-b1x;const qby=b2y-b1y;const d=Math.abs(qay*qbx-qby*qax);const la=qbx*dpy-qby*dpx;if(Math.abs(la)>d)return false;const lb=qax*dpy-qay*dpx;return Math.abs(lb)<=d};C3.segmentIntersectsQuad=function segmentIntersectsQuad(x1,y1,x2,y2,q){const min_x=Math.min(x1,x2);const max_x=Math.max(x1,x2);const min_y=Math.min(y1,y2);const max_y=Math.max(y1,y2);const tlx=q.getTlx(),tly=q.getTly(),trx=q.getTrx(),try_=q.getTry(),
brx=q.getBrx(),bry=q.getBry(),blx=q.getBlx(),bly=q.getBly();return C3.segmentsIntersectPreCalc(x1,y1,x2,y2,min_x,max_x,min_y,max_y,tlx,tly,trx,try_)||C3.segmentsIntersectPreCalc(x1,y1,x2,y2,min_x,max_x,min_y,max_y,trx,try_,brx,bry)||C3.segmentsIntersectPreCalc(x1,y1,x2,y2,min_x,max_x,min_y,max_y,brx,bry,blx,bly)||C3.segmentsIntersectPreCalc(x1,y1,x2,y2,min_x,max_x,min_y,max_y,blx,bly,tlx,tly)};C3.segmentIntersectsAnyN=function segmentIntersectsAnyN(x1,y1,x2,y2,points){const min_x=Math.min(x1,x2);
const max_x=Math.max(x1,x2);const min_y=Math.min(y1,y2);const max_y=Math.max(y1,y2);let i=0;for(let last=points.length-4;i<=last;i+=2)if(C3.segmentsIntersectPreCalc(x1,y1,x2,y2,min_x,max_x,min_y,max_y,points[i],points[i+1],points[i+2],points[i+3]))return true;return C3.segmentsIntersectPreCalc(x1,y1,x2,y2,min_x,max_x,min_y,max_y,points[i],points[i+1],points[0],points[1])};const NO_HIT=2;const PADDING=1E-6;C3.rayIntersect=function rayIntersect(rx1,ry1,rx2,ry2,sx1,sy1,sx2,sy2){const rdx=rx2-rx1;const rdy=
ry2-ry1;const sdx=sx2-sx1;const sdy=sy2-sy1;const det=rdx*sdy-rdy*sdx;if(det===0)return NO_HIT;const gamma=((ry1-ry2)*(sx2-rx1)+rdx*(sy2-ry1))/det;if(0<gamma&&gamma<1+PADDING)return(sdy*(sx2-rx1)+(sx1-sx2)*(sy2-ry1))/det;return NO_HIT};C3.rayIntersectExtended=function rayIntersect(rx1,ry1,rx2,ry2,sx1,sy1,sx2,sy2,f){const dx=(sx2-sx1)*f;const dy=(sy2-sy1)*f;return C3.rayIntersect(rx1,ry1,rx2,ry2,sx1-dx,sy1-dy,sx2+dx,sy2+dy)};C3.isPointInTriangleInclusive=function isPointInTriangleInclusive(px,py,tx1,
ty1,tx2,ty2,tx3,ty3){const v0x=tx2-tx1;const v0y=ty2-ty1;const v1x=tx3-tx1;const v1y=ty3-ty1;const v2x=px-tx1;const v2y=py-ty1;const dot00=v0x*v0x+v0y*v0y;const dot01=v0x*v1x+v0y*v1y;const dot02=v0x*v2x+v0y*v2y;const dot11=v1x*v1x+v1y*v1y;const dot12=v1x*v2x+v1y*v2y;const invDenom=1/(dot00*dot11-dot01*dot01);const u=(dot11*dot02-dot01*dot12)*invDenom;const v=(dot00*dot12-dot01*dot02)*invDenom;return u>=0&&v>=0&&u+v<=1};C3.triangleCartesianToBarycentric=function triangleCartesianToBarycentric(px,py,
tx1,ty1,tx2,ty2,tx3,ty3){const v0x=tx2-tx1;const v0y=ty2-ty1;const v1x=tx3-tx1;const v1y=ty3-ty1;const v2x=px-tx1;const v2y=py-ty1;const dot00=v0x*v0x+v0y*v0y;const dot01=v0x*v1x+v0y*v1y;const dot11=v1x*v1x+v1y*v1y;const dot20=v2x*v0x+v2y*v0y;const dot21=v2x*v1x+v2y*v1y;const denom=dot00*dot11-dot01*dot01;const v=(dot11*dot20-dot01*dot21)/denom;const w=(dot00*dot21-dot01*dot20)/denom;const u=1-v-w;return[u,v,w]};C3.triangleBarycentricToCartesian=function triangleBarycentricToCartesian(u,v,w,tx1,ty1,
tx2,ty2,tx3,ty3){return[u*tx1+v*tx2+w*tx3,u*ty1+v*ty2+w*ty3]}};


// ../lib/misc/miscutil.js
'use strict';{const C3=self.C3;let mainDocument=null;let baseHref="";if(typeof document!=="undefined"){mainDocument=document;const baseElem=document.querySelector("base");baseHref=baseElem&&baseElem.hasAttribute("href")?baseElem.getAttribute("href"):"";if(baseHref){if(baseHref.startsWith("/"))baseHref=baseHref.substr(1);if(!baseHref.endsWith("/"))baseHref+="/"}}C3.GetBaseHref=function GetBaseHref(){return baseHref};C3.GetBaseURL=function GetBaseURL(){if(!mainDocument)return"";const loc=mainDocument.location;
return C3.GetPathFromURL(loc.origin+loc.pathname)+baseHref};C3.GetPathFromURL=function GetPathFromURL(url){if(!url.length)return url;if(url.endsWith("/")||url.endsWith("\\"))return url;const lastSlash=Math.max(url.lastIndexOf("/"),url.lastIndexOf("\\"));if(lastSlash===-1)return"";return url.substr(0,lastSlash+1)};C3.GetFilenameFromURL=function GetFilenameFromURL(url){if(!url.length)return url;if(url.endsWith("/")||url.endsWith("\\"))return"";const lastSlash=Math.max(url.lastIndexOf("/"),url.lastIndexOf("\\"));
if(lastSlash===-1)return url;return url.substr(lastSlash+1)};C3.DataTransferHasFiles=function DataTransferHasFiles(dataTransfer){if(dataTransfer.types)for(let i=0;i<dataTransfer.types.length;i++)if(dataTransfer.types[i]==="Files"||dataTransfer.types[i]==="application/x-c3-file")return true;return false};const VALID_DATA_TRANSFER_SORT_MODES=["alphabetical"];const DATA_TRANSFER_FILTER_OPTIONS={filter:null,sort:null};C3.FilterAndCloneFiles=async function FilterAndCloneFiles(files,opts){opts=Object.assign({},
DATA_TRANSFER_FILTER_OPTIONS,opts);if(!C3.IsFunction(opts.filter))throw new Error('"filter" option is not a function');const ret=Array.from(files).filter(file=>{return file.size!==0}).filter(file=>{return opts.filter(file)}).map(async file=>{try{return await C3.CloneFile(file)}catch(err){return null}});const f=await Promise.all(ret);const filteredRet=f.filter(file=>file);if(opts&&opts.sort)switch(opts.sort){case "alphabetical":{filteredRet.sort((a,b)=>a.name.localeCompare(b.name));break}default:{throw new Error(`invalid sort mode "${opts.sort}", valid modes are "${VALID_DATA_TRANSFER_SORT_MODES}"`);
}}return filteredRet};C3.DataTransferFilterFiles=async function DataTransferFilterFiles(dataTransfer,opts){return C3.FilterAndCloneFiles(dataTransfer.files,opts)};C3.IsFileAnImage=function IsFileAnImage(file){if(file.type)return file.type.search(/image\/.*/)!==-1;else{const type=C3.MimeType.GetForFileExtension(C3.GetFileExtension(file.name)).GetString();return type.search(/image\/.*/)!==-1}};C3.IsFileAnSVG=function IsFileAnSVG(file){return file.type==="image/svg+xml"};C3.IsFileAMultiImageContainer=
function IsFileAMultiImageContainer(file){if(file.type)return C3.MimeType.Get(file.type).IsAnimatedImage();else return C3.MimeType.GetForFileExtension(C3.GetFileExtension(file.name)).IsAnimatedImage()};C3.GetFileExtension=function GetFileExtension(filename){let i=filename.lastIndexOf(".");if(i<1)return"";else return filename.substr(i)};C3.GetFileNamePart=function GetFileNamePart(filename){let i=filename.lastIndexOf(".");if(i<1)return filename;else return filename.substr(0,i)};C3.NormalizeFileSeparator=
function NormalizeFileSeparator(path){return path.replace(/\\/g,"/")};C3.ParseFilePath=function ParseFilePath(path){path=C3.NormalizeFileSeparator(path);let root=/^\w:\//.exec(path);if(root){root=root[0];path=path.slice(3);if(path[0]!=="/")path="/"+path}else root="";path=path.replace(/\/{2,}/g,"/");if(path.length>1&&path.slice(-1)==="/")path=path.slice(0,-1);const start=path.lastIndexOf("/")+1;let dir="",base=path,name,ext="";if(start>0){dir=path.slice(0,start);base=path.slice(start)}name=base;const end=
base.lastIndexOf(".");if(end>0){ext=base.slice(end);name=base.slice(0,-ext.length)}const full=root+dir+base;return{dir,base,name,root,ext,full}};C3.Wait=function Wait(delay,argument){return new Promise((resolve,reject)=>{self.setTimeout(resolve,delay,argument)})};C3.swallowException=function swallowException(f){try{f()}catch(e){if(C3.isDebug)console.warn("Swallowed exception: ",e)}};C3.noop=function noop(){};C3.equalsNoCase=function equalsNoCase(a,b){if(typeof a!=="string"||typeof b!=="string")return false;
return a===b||a.normalize().toLowerCase()===b.normalize().toLowerCase()};C3.equalsCase=function equalsCase(a,b){if(typeof a!=="string"||typeof b!=="string")return false;if(a===b)return true;return a.normalize()===b.normalize()};C3.typedArraySet16=function typedArraySet16(dest,src,i){dest[i++]=src[0];dest[i++]=src[1];dest[i++]=src[2];dest[i++]=src[3];dest[i++]=src[4];dest[i++]=src[5];dest[i++]=src[6];dest[i++]=src[7];dest[i++]=src[8];dest[i++]=src[9];dest[i++]=src[10];dest[i++]=src[11];dest[i++]=src[12];
dest[i++]=src[13];dest[i++]=src[14];dest[i]=src[15]};C3.truncateArray=function truncateArray(arr,index){arr.length=index};C3.clearArray=function clearArray(arr){if(!arr)return;if(arr.length===0)return;C3.truncateArray(arr,0)};C3.clear2DArray=function clear2DArray(arr){if(!arr)return;for(let i=0;i<arr.length;i++){let a=arr[i];C3.truncateArray(a,0)}C3.truncateArray(arr,0)};C3.extendArray=function extendArray(arr,len,filler){len=len|0;const arrayLength=arr.length;if(len<=arrayLength)return;for(let i=
arrayLength;i<len;++i)arr.push(filler)};C3.resizeArray=function resizeArray(arr,len,filler){len=len|0;const arrayLength=arr.length;if(len<arrayLength)C3.truncateArray(arr,len);else if(len>arrayLength)C3.extendArray(arr,len,filler)};C3.shallowAssignArray=function shallowAssignArray(dest,src){C3.clearArray(dest);C3.appendArray(dest,src)};C3.appendArray=function appendArray(a,b){if(b.length<1E4)a.push(...b);else for(let i=0,len=b.length;i<len;++i)a.push(b[i])};C3.arrayRemove=function(arr,index){index=
Math.floor(index);if(index<0||index>=arr.length)return;let len=arr.length-1;for(let i=index;i<len;++i)arr[i]=arr[i+1];C3.truncateArray(arr,len)};C3.arrayFindRemove=function arrayFindRemove(a,o){let i=a.indexOf(o);if(i>=0)a.splice(i,1)};C3.arraysEqual=function arraysEqual(a,b){let len=a.length;if(b.length!==len)return false;for(let i=0;i<len;++i)if(a[i]!==b[i])return false;return true};C3.arrayFilterOut=function arrayFilterOut(arr,callback){let ret=[];let j=0;for(let i=0,len=arr.length;i<len;++i){let item=
arr[i];if(callback(item))ret.push(item);else{arr[j]=item;++j}}C3.truncateArray(arr,j);return ret};C3.arrayRemoveAllInSet=function arrayRemoveAllInSet(arr,s){const oldLen=arr.length;let j=0;for(let i=0,len=arr.length;i<len;++i){let item=arr[i];if(!s.has(item))arr[j++]=item}C3.truncateArray(arr,j);return oldLen-j};C3.isArrayIndexInBounds=function isArrayIndexInBounds(index,array){if(index!==Math.floor(index))return false;return index>=0&&index<array.length};C3.validateArrayIndex=function validateArrayIndex(index,
array){if(!C3.isArrayIndexInBounds(index,array))throw new RangeError("array index out of bounds");};C3.cloneArray=function cloneArray(array){return array.slice()};C3.deepCloneArray=function deepCloneArray(array,f){let ret=[];for(let e of array)if(C3.IsObject(e)){let clone=f(e);if(!clone)throw new Error("missing clone");if(clone.constructor!==e.constructor)throw new Error("object is not a clone");ret.push(clone)}else if(C3.IsArray(e))ret.push(C3.deepCloneArray(e,f));else ret.push(e);return ret};C3.clone2DArray=
function cloneArray(array){let ret=[];for(let arr of array)ret.push(arr.slice());return ret};C3.mergeSets=function mergeSets(set1,set2){return new Set([...set1,...set2])};C3.mergeSetsInPlace=function mergeSetsInPlace(set1,set2){for(const item of set2)set1.add(item);return set1};C3.first=function first(iterable){for(let i of iterable)return i;return null};C3.xor=function(x,y){return!x!==!y};C3.compare=function compare(x,cmp,y){switch(cmp){case 0:return x===y;case 1:return x!==y;case 2:return x<y;case 3:return x<=
y;case 4:return x>y;case 5:return x>=y;default:return false}};C3.hasAnyOwnProperty=function hasAnyOwnProperty(o){for(let p in o)if(o.hasOwnProperty(p))return true;return false};C3.PromiseAllWithProgress=function PromiseAllWithProgress(arr,progressCallback){if(!arr.length)return Promise.resolve([]);return new Promise((resolve,reject)=>{const results=[];let numberCompleted=0;let cancelled=false;for(let i=0,len=arr.length;i<len;++i){results.push(void 0);arr[i].then(result=>{if(cancelled)return;results[i]=
result;++numberCompleted;if(numberCompleted===arr.length)resolve(results);else progressCallback(numberCompleted,arr.length)}).catch(err=>{cancelled=true;reject(err)})}})};let memoryCallbacks=[];C3.AddLibraryMemoryCallback=function AddLibraryMemoryCallback(f){memoryCallbacks.push(f)};C3.GetEstimatedLibraryMemoryUsage=function GetEstimatedLibraryMemoryUsage(){let ret=0;for(let f of memoryCallbacks){let m=f();ret+=m}return Math.floor(ret)};let nextTaskId=1;const activeTaskIds=new Map;const taskMessageChannel=
new MessageChannel;taskMessageChannel.port2.onmessage=function OnTask(e){const id=e.data;const callback=activeTaskIds.get(id);activeTaskIds.delete(id);if(callback)callback(e.timeStamp)};C3.RequestUnlimitedAnimationFrame=function RequestUnlimitedAnimationFrame(callback){const id=nextTaskId++;activeTaskIds.set(id,callback);taskMessageChannel.port1.postMessage(id);return id};C3.CancelUnlimitedAnimationFrame=function CancelUnlimitedAnimationFrame(id){activeTaskIds.delete(id)};C3.PostTask=C3.RequestUnlimitedAnimationFrame;
C3.WaitForNextTask=function WaitForNextTask(){return new Promise(resolve=>C3.PostTask(resolve))};const activeRPAFids=new Set;C3.RequestPostAnimationFrame=function RequestPostAnimationFrame(callback){const id=self.requestAnimationFrame(async timestamp=>{await C3.WaitForNextTask();if(!activeRPAFids.has(id))return;activeRPAFids.delete(id);callback(timestamp)});activeRPAFids.add(id);return id};C3.CancelPostAnimationFrame=function CancelPostAnimationFrame(id){if(!activeRPAFids.has(id))return;self.cancelAnimationFrame(id);
activeRPAFids.delete(id)}};


// c3/lib/misc/runtimeutil.js
'use strict';{const C3=self.C3;C3.IsAbsoluteURL=function IsAbsoluteURL(url){return/^(?:[a-z\-]+:)?\/\//.test(url)||url.substr(0,5)==="data:"||url.substr(0,5)==="blob:"};C3.IsRelativeURL=function IsRelativeURL(url){return!C3.IsAbsoluteURL(url)};C3.ThrowIfNotOk=function ThrowIfNotOk(response){if(!response.ok)throw new Error(`fetch '${response.url}' response returned ${response.status} ${response.statusText}`);};C3.FetchOk=function FetchOk(url,init){return fetch(url,init).then(response=>{C3.ThrowIfNotOk(response);
return response})};C3.FetchText=function FetchText(url){return C3.FetchOk(url).then(response=>response.text())};C3.FetchJson=function FetchJson(url){return C3.FetchOk(url).then(response=>response.json())};C3.FetchBlob=function FetchBlob(url){return C3.FetchOk(url).then(response=>response.blob())};C3.FetchArrayBuffer=function FetchArrayBuffer(url){return C3.FetchOk(url).then(response=>response.arrayBuffer())};C3.FetchImage=function FetchImage(url){return new Promise((resolve,reject)=>{const img=new Image;
img.onload=()=>resolve(img);img.onerror=err=>reject(err);img.src=url})};C3.BlobToArrayBuffer=function BlobToArrayBuffer(blob){if(typeof blob["arrayBuffer"]==="function")return blob["arrayBuffer"]();else return new Promise((resolve,reject)=>{const fileReader=new FileReader;fileReader.onload=()=>resolve(fileReader.result);fileReader.onerror=()=>reject(fileReader.error);fileReader.readAsArrayBuffer(blob)})};C3.BlobToString=function BlobToString(blob){if(typeof blob["text"]==="function")return blob["text"]();
else return new Promise((resolve,reject)=>{const fileReader=new FileReader;fileReader.onload=()=>resolve(fileReader.result);fileReader.onerror=()=>reject(fileReader.error);fileReader.readAsText(blob)})};C3.BlobToJson=function BlobToJson(blob){return C3.BlobToString(blob).then(text=>JSON.parse(text))};C3.BlobToImage=async function BlobToImage(blob,decodeImage){let blobUrl=URL.createObjectURL(blob);try{const img=await C3.FetchImage(blobUrl);URL.revokeObjectURL(blobUrl);blobUrl="";if(decodeImage&&typeof img["decode"]===
"function")await img["decode"]();return img}finally{if(blobUrl)URL.revokeObjectURL(blobUrl)}};C3.CreateCanvas=function CreateCanvas(width,height){if(typeof document!=="undefined"&&typeof document.createElement==="function"){const canvas=document.createElement("canvas");canvas.width=width;canvas.height=height;return canvas}else return new OffscreenCanvas(width,height)};C3.CanvasToBlob=function CanvasToBlob(canvas,type,quality){if(typeof quality!=="number")quality=1;type=type||"image/png";quality=C3.clamp(quality,
0,1);if(canvas.toBlob)return new Promise(resolve=>canvas.toBlob(resolve,type,quality));else if(canvas["convertToBlob"])return canvas["convertToBlob"]({"type":type,"quality":quality});else return C3.Asyncify(()=>C3.CanvasToBlobSync(canvas,type,quality))};C3.CanvasToBlobSync=function CanvasToBlobSync(canvas,type,quality){if(typeof quality!=="number")quality=1;type=type||"image/png";quality=C3.clamp(quality,0,1);return C3.DataURIToBinaryBlobSync(canvas.toDataURL(type,quality))};C3.DataURIToBinaryBlobSync=
function DataURIToBinaryBlobSync(datauri){const o=C3.ParseDataURI(datauri);return C3.BinaryStringToBlob(o.data,o.mime_type)};C3.ParseDataURI=function ParseDataURI(datauri){if(datauri.substr(0,5)!=="data:")throw new URIError("expected data: uri");let comma=datauri.indexOf(",");if(comma<0)throw new URIError("expected comma in data: uri");let typepart=datauri.substring(5,comma);let datapart=datauri.substring(comma+1);let typearr=typepart.split(";");let mimetype=typearr[0]||"";let encoding1=typearr[1];
let encoding2=typearr[2];let decodeddata;if(encoding1==="base64"||encoding2==="base64")decodeddata=atob(datapart);else decodeddata=decodeURIComponent(datapart);return{mime_type:mimetype,data:decodeddata}};C3.BinaryStringToBlob=function BinaryStringToBlob(binstr,mime_type){let len=binstr.length;let len32=len>>2;let a8=new Uint8Array(len);let a32=new Uint32Array(a8.buffer,0,len32);let i,j;for(i=0,j=0;i<len32;++i)a32[i]=binstr.charCodeAt(j++)|binstr.charCodeAt(j++)<<8|binstr.charCodeAt(j++)<<16|binstr.charCodeAt(j++)<<
24;let tailLength=len&3;while(tailLength--){a8[j]=binstr.charCodeAt(j);++j}if(mime_type)return new Blob([a8],{"type":mime_type});else return new Blob([a8])};C3.DrawableToBlob=function DrawableToBlob(drawable,type,quality){const canvas=C3.CreateCanvas(drawable.width,drawable.height);const ctx=canvas.getContext("2d");ctx.drawImage(drawable,0,0);return C3.CanvasToBlob(canvas,type,quality)};C3.ImageDataToBlobSync=function ImageDataToBlobSync(imageData,type,quality){const canvas=C3.CreateCanvas(imageData.width,
imageData.height);const ctx=canvas.getContext("2d");ctx.putImageData(imageData,0,0);return C3.CanvasToBlobSync(canvas,type,quality)};C3.ImageDataToBlob=function ImageDataToBlob(imageData,type,quality){if(C3.Supports.ImageBitmapOptions)return createImageBitmap(imageData,{"premultiplyAlpha":"none"}).then(imageBitmap=>C3.DrawableToBlob(imageBitmap,type,quality));else if(C3.Supports.ImageBitmap)return createImageBitmap(imageData).then(imageBitmap=>C3.DrawableToBlob(imageBitmap,type,quality));else{const canvas=
C3.CreateCanvas(imageData.width,imageData.height);const ctx=canvas.getContext("2d");ctx.putImageData(imageData,0,0);return C3.CanvasToBlob(canvas,type,quality)}};C3.CopySet=function CopySet(dest,src){dest.clear();for(const x of src)dest.add(x)};C3.MapToObject=function MapToObject(map){const ret=Object.create(null);for(const [k,v]of map.entries())ret[k]=v;return ret};C3.ObjectToMap=function ObjectToMap(o,map){map.clear();for(const [k,v]of Object.entries(o))map.set(k,v)};C3.ToSuperJSON=function ToSuperJSON(v){if(typeof v===
"object"&&v!==null)if(v instanceof Set)return{"_c3type_":"set","data":[...v].map(o=>ToSuperJSON(o))};else if(v instanceof Map)return{"_c3type_":"map","data":[...v].map(pair=>[pair[0],ToSuperJSON(pair[1])])};else{const ret=Object.create(null);for(const [key,value]of Object.entries(v))ret[key]=ToSuperJSON(value);return ret}return v};C3.FromSuperJSON=function FromSuperJSON(v){if(typeof v==="object"&v!==null)if(v["_c3type_"]==="set")return new Set(v["data"].map(o=>FromSuperJSON(o)));else if(v["_c3type_"]===
"map")return new Map(v["data"].map(pair=>[pair[0],FromSuperJSON(pair[1])]));else{const ret=Object.create(null);for(const [key,value]of Object.entries(v))ret[key]=FromSuperJSON(value);return ret}return v};C3.CSSToCamelCase=function(str){let ret="";let isAfterHyphen=false;for(const ch of str)if(ch==="-")isAfterHyphen=true;else if(isAfterHyphen){ret+=ch.toUpperCase();isAfterHyphen=false}else ret+=ch;return ret};C3.IsIterator=function(o){return typeof o==="object"&&typeof o.next==="function"};C3.MakeFilledArray=
function MakeFilledArray(len,data){const ret=[];if(typeof data==="function")for(let i=0;i<len;++i)ret.push(data());else for(let i=0;i<len;++i)ret.push(data);return ret}};


// ../lib/misc/color.js
'use strict';{const C3=self.C3;const HSL_TEST=/([0-9.]+),([0-9.]+)%?,([0-9.]+)%?/i;const HSLA_TEST=/([0-9.]+),([0-9.]+)%?,([0-9.]+)%?,([0-9.])/i;function padTwoDigits(str){if(str.length===0)return"00";else if(str.length===1)return"0"+str;else return str}function hueToRGB(p,q,t){if(t<0)t+=1;if(t>1)t-=1;if(t<1/6)return p+(q-p)*6*t;if(t<1/2)return q;if(t<2/3)return p+(q-p)*(2/3-t)*6;return p}C3.Color=class Color{constructor(r,g,b,a){this._r=NaN;this._g=NaN;this._b=NaN;this._a=NaN;this._r=0;this._g=0;
this._b=0;this._a=0;if(r instanceof C3.Color)this.set(r);else this.setRgba(r||0,g||0,b||0,a||0)}setRgb(r,g,b){this._r=+r;this._g=+g;this._b=+b;this.clamp();return this}setRgba(r,g,b,a){this._r=+r;this._g=+g;this._b=+b;this._a=+a;this.clamp();return this}set(c){this._r=c._r;this._g=c._g;this._b=c._b;this._a=c._a;return this}copy(c){return this.set(c)}add(c){this._r+=c._r;this._g+=c._g;this._b+=c._b;this._a+=c._a;this.clamp()}addRgb(r,g,b,a=0){this._r+=+r;this._g+=+g;this._b+=+b;this._a+=+a;this.clamp()}diff(c){this.setR(Math.max(this._r,
c._r)-Math.min(this._r,c._r));this.setG(Math.max(this._g,c._g)-Math.min(this._g,c._g));this.setB(Math.max(this._b,c._b)-Math.min(this._b,c._b));this.setA(Math.max(this._a,c._a)-Math.min(this._a,c._a));this.clamp()}copyRgb(c){this._r=c._r;this._g=c._g;this._b=c._b}setR(r){this._r=C3.clamp(+r,0,1)}getR(){return this._r}setG(g){this._g=C3.clamp(+g,0,1)}getG(){return this._g}setB(b){this._b=C3.clamp(+b,0,1)}getB(){return this._b}setA(a){this._a=C3.clamp(+a,0,1)}getA(){return this._a}clone(){return C3.New(C3.Color,
this._r,this._g,this._b,this._a)}toArray(){return[this._r,this._g,this._b,this._a]}toTypedArray(){return new Float64Array(this.toArray())}writeToTypedArray(ta,i){ta[i++]=this._r;ta[i++]=this._g;ta[i++]=this._b;ta[i]=this._a}equals(c){return this._r===c._r&&this._g===c._g&&this._b===c._b&&this._a===c._a}equalsIgnoringAlpha(c){return this._r===c._r&&this._g===c._g&&this._b===c._b}equalsRgb(r,g,b){return this._r===r&&this._g===g&&this._b===b}equalsRgba(r,g,b,a){return this._r===r&&this._g===g&&this._b===
b&&this._a===a}multiply(c){this._r*=c._r;this._g*=c._g;this._b*=c._b;this._a*=c._a}multiplyAlpha(a){this._r*=a;this._g*=a;this._b*=a;this._a*=a}premultiply(){this._r*=this._a;this._g*=this._a;this._b*=this._a;return this}unpremultiply(){this._r/=this._a;this._g/=this._a;this._b/=this._a;return this}clamp(){this._r=C3.clamp(this._r,0,1);this._g=C3.clamp(this._g,0,1);this._b=C3.clamp(this._b,0,1);this._a=C3.clamp(this._a,0,1);return this}setFromRgbValue(rgb){this._r=C3.GetRValue(rgb);this._g=C3.GetGValue(rgb);
this._b=C3.GetBValue(rgb);this._a=C3.GetAValue(rgb)}getCssRgb(_r,_g,_b){const r=C3.IsFiniteNumber(_r)?_r:this.getR();const g=C3.IsFiniteNumber(_g)?_g:this.getG();const b=C3.IsFiniteNumber(_b)?_b:this.getB();return`rgb(${r*100}%, ${g*100}%, ${b*100}%)`}getCssRgba(_r,_g,_b,_a){const r=C3.IsFiniteNumber(_r)?_r:this.getR();const g=C3.IsFiniteNumber(_g)?_g:this.getG();const b=C3.IsFiniteNumber(_b)?_b:this.getB();const a=C3.IsFiniteNumber(_a)?_a:this.getA();return`rgba(${r*100}%, ${g*100}%, ${b*100}%, ${a})`}toHexString(){const rh=
Math.round(this.getR()*255);const gh=Math.round(this.getG()*255);const bh=Math.round(this.getB()*255);return"#"+padTwoDigits(rh.toString(16))+padTwoDigits(gh.toString(16))+padTwoDigits(bh.toString(16))}parseHexString(str){if(typeof str!=="string")return false;str=str.trim();if(str.charAt(0)==="#")str=str.substr(1);let rv;let gv;let bv;if(str.length===3){rv=parseInt(str[0],16)/15;gv=parseInt(str[1],16)/15;bv=parseInt(str[2],16)/15}else if(str.length===6){rv=parseInt(str.substr(0,2),16)/255;gv=parseInt(str.substr(2,
2),16)/255;bv=parseInt(str.substr(4,2),16)/255}else return false;if(isFinite(rv))this.setR(rv);if(isFinite(gv))this.setG(gv);if(isFinite(bv))this.setB(bv);this.setA(1);return true}toCommaSeparatedRgb(){const rv=Math.round(this.getR()*255);const gv=Math.round(this.getG()*255);const bv=Math.round(this.getB()*255);return`${rv}, ${gv}, ${bv}`}toRgbArray(){const rv=Math.round(this.getR()*255);const gv=Math.round(this.getG()*255);const bv=Math.round(this.getB()*255);return[rv,gv,bv]}parseCommaSeparatedRgb(str){if(typeof str!==
"string")return false;str=str.replace(/^rgb\(|\)|%/,"");const arr=str.split(",");if(arr.length<3)return false;const rv=parseInt(arr[0].trim(),10)/255;const gv=parseInt(arr[1].trim(),10)/255;const bv=parseInt(arr[2].trim(),10)/255;if(isFinite(rv))this.setR(rv);if(isFinite(gv))this.setG(gv);if(isFinite(bv))this.setB(bv);this.setA(1);return true}parseCommaSeparatedPercentageRgb(str){if(typeof str!=="string")return false;str=str.replace(/^rgb\(|\)|%/,"");const arr=str.split(",");if(arr.length<3)return false;
const rv=parseInt(arr[0].trim(),10)/100;const gv=parseInt(arr[1].trim(),10)/100;const bv=parseInt(arr[2].trim(),10)/100;if(isFinite(rv))this.setR(rv);if(isFinite(gv))this.setG(gv);if(isFinite(bv))this.setB(bv);this.setA(1);return true}parseCommaSeparatedRgba(str){if(typeof str!=="string")return false;str=str.replace(/^rgba\(|\)|%/,"");const arr=str.split(",");if(arr.length<4)return false;const rv=parseInt(arr[0].trim(),10)/255;const gv=parseInt(arr[1].trim(),10)/255;const bv=parseInt(arr[2].trim(),
10)/255;const av=parseFloat(arr[3].trim());if(isFinite(rv))this.setR(rv);if(isFinite(gv))this.setG(gv);if(isFinite(bv))this.setB(bv);if(isFinite(av))this.setA(av);return true}parseCommaSeparatedPercentageRgba(str){if(typeof str!=="string")return false;str=str.replace(/^rgba\(|\)|%/,"");const arr=str.split(",");if(arr.length<4)return false;const rv=parseInt(arr[0].trim(),10)/100;const gv=parseInt(arr[1].trim(),10)/100;const bv=parseInt(arr[2].trim(),10)/100;const av=parseFloat(arr[3].trim());if(isFinite(rv))this.setR(rv);
if(isFinite(gv))this.setG(gv);if(isFinite(bv))this.setB(bv);if(isFinite(av))this.setA(av);return true}parseString(str){if(typeof str!=="string")return false;str=str.replace(/\s+/,"");if(str.includes(","))if(str.startsWith("rgb("))if(str.includes("%"))return this.parseCommaSeparatedPercentageRgb(str);else return this.parseCommaSeparatedRgb(str);else if(str.startsWith("rgba("))if(str.includes("%"))return this.parseCommaSeparatedPercentageRgba(str);else return this.parseCommaSeparatedRgba(str);else if(str.startsWith("hsl(")||
str.startsWith("hsla("))return this.parseHSLString(str);else{const components=str.split(",");if(str.includes("%")){if(components.length===3)return this.parseCommaSeparatedPercentageRgb(str);else if(components.length===4)return this.parseCommaSeparatedPercentageRgba(str);return false}else{if(components.length===3)return this.parseCommaSeparatedRgb(str);else if(components.length===4)return this.parseCommaSeparatedRgba(str);return false}}else return this.parseHexString(str)}toJSON(){return[this._r,this._g,
this._b,this._a]}setFromHSLA(h,s,l,a){let r;let g;let b;h%=360;s=C3.clamp(s,0,100);l=C3.clamp(l,0,100);a=C3.clamp(a,0,1);h/=360;s/=100;l/=100;if(s===0)r=g=b=l;else{const q=l<.5?l*(1+s):l+s-l*s;const p=2*l-q;r=hueToRGB(p,q,h+1/3);g=hueToRGB(p,q,h);b=hueToRGB(p,q,h-1/3)}this.setR(r);this.setG(g);this.setB(b);this.setA(a);return this}parseHSLString(str){const cleanString=str.replace(/ |hsl|hsla|\(|\)|;/gi,"");const hsl=HSL_TEST.exec(cleanString);const hsla=HSLA_TEST.exec(cleanString);if(hsl&&hsl.length===
4){this.setFromHSLA(+hsl[1],+hsl[2],+hsl[3],1);return true}else if(hsla&&hsla.length===5){this.setFromHSLA(+hsl[1],+hsl[2],+hsl[3],+hsl[4]);return true}return false}toHSLAString(){const r=this._r;const g=this._g;const b=this._b;const a=this._a;const h=C3.Color.GetHue(r,g,b);const s=C3.Color.GetSaturation(r,g,b);const l=C3.Color.GetLuminosity(r,g,b);return`hsla(${h}, ${s}%, ${l}%, ${a})`}toHSLAArray(){const r=this._r;const g=this._g;const b=this._b;return[C3.Color.GetHue(r,g,b),C3.Color.GetSaturation(r,
g,b),C3.Color.GetLuminosity(r,g,b),this._a]}setFromJSON(arr){if(!Array.isArray(arr))return;if(arr.length<3)return;this._r=arr[0];this._g=arr[1];this._b=arr[2];if(arr.length>=4)this._a=arr[3];else this._a=1}set r(r){this.setR(r)}get r(){return this.getR()}set g(g){this.setG(g)}get g(){return this.getG()}set b(b){this.setB(b)}get b(){return this.getB()}set a(a){this.setA(a)}get a(){return this.getA()}setAtIndex(i,v){switch(i){case 0:this.setR(v);break;case 1:this.setG(v);break;case 2:this.setB(v);break;
case 3:this.setA(v);break;default:throw new RangeError("invalid color index");}}getAtIndex(i){switch(i){case 0:return this.getR();case 1:return this.getG();case 2:return this.getB();case 3:return this.getA();default:throw new RangeError("invalid color index");}}static Equals(color_or_json_1,color_or_json_2){let c1;let c2;if(Array.isArray(color_or_json_1)){c1=new C3.Color;c1.setFromJSON(color_or_json_1)}else if(color_or_json_1 instanceof C3.Color)c1=color_or_json_1;else throw new Error("unexpected type");
if(Array.isArray(color_or_json_2)){c2=new C3.Color;c2.setFromJSON(color_or_json_2)}else if(color_or_json_2 instanceof C3.Color)c2=color_or_json_2;else throw new Error("unexpected type");return c1.equals(c2)}static DiffChannel(channel1,channel2){return C3.clamp(Math.max(channel1,channel2)-Math.min(channel1,channel2),0,1)}static Diff(c1,c2){const ret=new C3.Color;ret.setR(Math.max(c1._r,c2._r)-Math.min(c1._r,c2._r));ret.setG(Math.max(c1._g,c2._g)-Math.min(c1._g,c2._g));ret.setB(Math.max(c1._b,c2._b)-
Math.min(c1._b,c2._b));ret.setA(Math.max(c1._a,c2._a)-Math.min(c1._a,c2._a));return ret}static DiffNoAlpha(c1,c2){const ret=new C3.Color(0,0,0,1);ret.setR(Math.max(c1._r,c2._r)-Math.min(c1._r,c2._r));ret.setG(Math.max(c1._g,c2._g)-Math.min(c1._g,c2._g));ret.setB(Math.max(c1._b,c2._b)-Math.min(c1._b,c2._b));return ret}static GetHue(r,g,b){const max=Math.max(r,g,b);const min=Math.min(r,g,b);if(max===min)return 0;let h=0;switch(max){case r:h=(g-b)/(max-min)+(g<b?6:0);break;case g:h=(b-r)/(max-min)+2;
break;case b:h=(r-g)/(max-min)+4;break}return Math.round(h/6*360)}static GetSaturation(r,g,b){const max=Math.max(r,g,b);const min=Math.min(r,g,b);if(max===min)return 0;const l=(max+min)/2;const d=max-min;const s=l>.5?d/(2-max-min):d/(max+min);return Math.round(s*100)}static GetLuminosity(r,g,b){const max=Math.max(r,g,b);const min=Math.min(r,g,b);const l=(max+min)/2;if(!max)return 0;return Math.round(l*100)}};C3.Color.White=Object.freeze(C3.New(C3.Color,1,1,1,1));C3.Color.Black=Object.freeze(C3.New(C3.Color,
0,0,0,1));C3.Color.TransparentBlack=Object.freeze(C3.New(C3.Color,0,0,0,0))};


// ../lib/misc/vector2.js
'use strict';{const C3=self.C3;C3.Vector2=class Vector2{constructor(x,y){this._x=0;this._y=0;if(x instanceof C3.Vector2)this.copy(x);else this.set(x||0,y||0)}set(x,y){this._x=+x;this._y=+y}copy(v){this._x=v._x;this._y=v._y}equals(v){return this._x===v._x&&this._y===v._y}equalsValues(x,y){return this._x===x&&this._y===y}setX(x){this._x=+x}getX(){return this._x}setY(y){this._y=+y}getY(){return this._y}toArray(){return[this._x,this._y]}toTypedArray(){return new Float64Array(this.toArray())}writeToTypedArray(ta,
i){ta[i++]=this._x;ta[i]=this._y}offset(x,y){this._x+=+x;this._y+=+y}scale(x,y){this._x*=x;this._y*=y}divide(x,y){this._x/=x;this._y/=y}round(){this._x=Math.round(this._x);this._y=Math.round(this._y)}floor(){this._x=Math.floor(this._x);this._y=Math.floor(this._y)}ceil(){this._x=Math.ceil(this._x);this._y=Math.ceil(this._y)}angle(){return C3.angleTo(0,0,this._x,this._y)}lengthSquared(){return this._x*this._x+this._y*this._y}length(){return Math.sqrt(this.lengthSquared())}rotatePrecalc(sin_a,cos_a){const temp=
this._x*cos_a-this._y*sin_a;this._y=this._y*cos_a+this._x*sin_a;this._x=temp}rotate(a){if(a===0)return;this.rotatePrecalc(Math.sin(a),Math.cos(a))}rotateAbout(a,x,y){if(a===0||x===this._x&&y===this._y)return;this._x-=x;this._y-=y;this.rotatePrecalc(Math.sin(a),Math.cos(a));this._x+=+x;this._y+=+y}move(a,dist){if(dist===0)return;this._x+=Math.cos(a)*dist;this._y+=Math.sin(a)*dist}normalize(){const m=this.length();if(m!==0&&m!==1){this._x/=m;this._y/=m}}clamp(lower,upper){this._x=C3.clamp(this._x,lower,
upper);this._y=C3.clamp(this._y,lower,upper)}}};


// ../lib/misc/rect.js
'use strict';{const C3=self.C3;C3.Rect=class Rect{constructor(left,top,right,bottom){this._left=NaN;this._top=NaN;this._right=NaN;this._bottom=NaN;this._left=0;this._top=0;this._right=0;this._bottom=0;if(left instanceof C3.Rect)this.copy(left);else this.set(left||0,top||0,right||0,bottom||0)}set(left,top,right,bottom){this._left=+left;this._top=+top;this._right=+right;this._bottom=+bottom}setWH(left,top,width,height){left=+left;top=+top;this._left=left;this._top=top;this._right=left+ +width;this._bottom=
top+ +height}copy(rect){this._left=+rect._left;this._top=+rect._top;this._right=+rect._right;this._bottom=+rect._bottom}clone(){return new C3.Rect(this._left,this._top,this._right,this._bottom)}static Merge(first,second){const ret=new C3.Rect;ret.setLeft(Math.min(first._left,second._left));ret.setTop(Math.min(first._top,second._top));ret.setRight(Math.max(first._right,second._right));ret.setBottom(Math.max(first._bottom,second._bottom));return ret}static FromObject(o){return new C3.Rect(o.left,o.top,
o.right,o.bottom)}equals(rect){return this._left===rect._left&&this._top===rect._top&&this._right===rect._right&&this._bottom===rect._bottom}setLeft(l){this._left=+l}getLeft(){return this._left}setTop(t){this._top=+t}getTop(){return this._top}setRight(r){this._right=+r}getRight(){return this._right}setBottom(b){this._bottom=+b}getBottom(){return this._bottom}toArray(){return[this._left,this._top,this._right,this._bottom]}toTypedArray(){return new Float64Array(this.toArray())}toDOMRect(){return new DOMRect(this._left,
this._top,this.width(),this.height())}writeToTypedArray(ta,i){ta[i++]=this._left;ta[i++]=this._top;ta[i++]=this._right;ta[i]=this._bottom}writeAsQuadToTypedArray(ta,i){ta[i++]=this._left;ta[i++]=this._top;ta[i++]=this._right;ta[i++]=this._top;ta[i++]=this._right;ta[i++]=this._bottom;ta[i++]=this._left;ta[i]=this._bottom}width(){return this._right-this._left}height(){return this._bottom-this._top}midX(){return(this._left+this._right)/2}midY(){return(this._top+this._bottom)/2}offset(x,y){x=+x;y=+y;
this._left+=x;this._top+=y;this._right+=x;this._bottom+=y}offsetLeft(x){this._left+=+x}offsetTop(y){this._top+=+y}offsetRight(x){this._right+=+x}offsetBottom(y){this._bottom+=+y}toSquare(axis){if(axis!=="x")throw new Error("invalid axis, only 'x' supported");if(this._top<this._bottom)if(this._left<this._right)this._bottom=this._top+this.width();else this._bottom=this._top-this.width();else if(this._left<this._right)this._bottom=this._top-this.width();else this._bottom=this._top+this.width()}inflate(x,
y){x=+x;y=+y;this._left-=x;this._top-=y;this._right+=x;this._bottom+=y}deflate(x,y){x=+x;y=+y;this._left+=x;this._top+=y;this._right-=x;this._bottom-=y}multiply(x,y){this._left*=x;this._top*=y;this._right*=x;this._bottom*=y}divide(x,y){this._left/=x;this._top/=y;this._right/=x;this._bottom/=y}mirrorAround(origin){this._left=+origin-this._left;this._right=+origin-this._right}flipAround(origin){this._top=+origin-this._top;this._bottom=+origin-this._bottom}swapLeftRight(){const temp=this._left;this._left=
this._right;this._right=temp}swapTopBottom(){const temp=this._top;this._top=this._bottom;this._bottom=temp}shuntY(h){const top=this._top;this._top=+h-this._bottom;this._bottom=+h-top}round(){this._left=Math.round(this._left);this._top=Math.round(this._top);this._right=Math.round(this._right);this._bottom=Math.round(this._bottom)}roundInner(){this._left=Math.ceil(this._left);this._top=Math.ceil(this._top);this._right=Math.floor(this._right);this._bottom=Math.floor(this._bottom)}roundOuter(){this._left=
Math.floor(this._left);this._top=Math.floor(this._top);this._right=Math.ceil(this._right);this._bottom=Math.ceil(this._bottom)}floor(){this._left=Math.floor(this._left);this._top=Math.floor(this._top);this._right=Math.floor(this._right);this._bottom=Math.floor(this._bottom)}ceil(){this._left=Math.ceil(this._left);this._top=Math.ceil(this._top);this._right=Math.ceil(this._right);this._bottom=Math.ceil(this._bottom)}clamp(l,t,r,b){if(this._left<l)this._left=+l;if(this._top<t)this._top=+t;if(this._right>
r)this._right=+r;if(this._bottom>b)this._bottom=+b}clampFlipped(l,t,r,b){if(this._left<l)this._left=+l;if(this._top>t)this._top=+t;if(this._right>r)this._right=+r;if(this._bottom<b)this._bottom=+b}normalize(){if(this._left>this._right)this.swapLeftRight();if(this._top>this._bottom)this.swapTopBottom()}intersectsRect(rect){return!(rect._right<this._left||rect._bottom<this._top||rect._left>this._right||rect._top>this._bottom)}intersectsRectOffset(rect,x,y){return!(rect._right+x<this._left||rect._bottom+
y<this._top||rect._left+x>this._right||rect._top+y>this._bottom)}containsPoint(x,y){return x>=this._left&&x<=this._right&&y>=this._top&&y<=this._bottom}containsRect(rect){return rect._left>=this._left&&rect._top>=this._top&&rect._right<=this._right&&rect._bottom<=this._bottom}expandToContain(rect){if(rect._left<this._left)this._left=+rect._left;if(rect._top<this._top)this._top=+rect._top;if(rect._right>this._right)this._right=+rect._right;if(rect._bottom>this._bottom)this._bottom=+rect._bottom}lerpInto(rect){this._left=
C3.lerp(rect._left,rect._right,this._left);this._top=C3.lerp(rect._top,rect._bottom,this._top);this._right=C3.lerp(rect._left,rect._right,this._right);this._bottom=C3.lerp(rect._top,rect._bottom,this._bottom)}}};


// ../lib/misc/quad.js
'use strict';{const C3=self.C3;C3.Quad=class Quad{constructor(tlx,tly,trx,try_,brx,bry,blx,bly){this._tlx=NaN;this._tly=NaN;this._trx=NaN;this._try=NaN;this._brx=NaN;this._bry=NaN;this._blx=NaN;this._bly=NaN;this._tlx=0;this._tly=0;this._trx=0;this._try=0;this._brx=0;this._bry=0;this._blx=0;this._bly=0;if(tlx instanceof C3.Quad)this.copy(tlx);else this.set(tlx||0,tly||0,trx||0,try_||0,brx||0,bry||0,blx||0,bly||0)}set(tlx,tly,trx,try_,brx,bry,blx,bly){this._tlx=+tlx;this._tly=+tly;this._trx=+trx;this._try=
+try_;this._brx=+brx;this._bry=+bry;this._blx=+blx;this._bly=+bly}setRect(left,top,right,bottom){this.set(left,top,right,top,right,bottom,left,bottom)}copy(q){this._tlx=q._tlx;this._tly=q._tly;this._trx=q._trx;this._try=q._try;this._brx=q._brx;this._bry=q._bry;this._blx=q._blx;this._bly=q._bly}equals(q){return this._tlx===q._tlx&&this._tly===q._tly&&this._trx===q._trx&&this._try===q._try&&this._brx===q._brx&&this._bry===q._bry&&this._blx===q._blx&&this._bly===q._bly}setTlx(v){this._tlx=+v}getTlx(){return this._tlx}setTly(v){this._tly=
+v}getTly(){return this._tly}setTrx(v){this._trx=+v}getTrx(){return this._trx}setTry(v){this._try=+v}getTry(){return this._try}setBrx(v){this._brx=+v}getBrx(){return this._brx}setBry(v){this._bry=+v}getBry(){return this._bry}setBlx(v){this._blx=+v}getBlx(){return this._blx}setBly(v){this._bly=+v}getBly(){return this._bly}toDOMQuad(){return new DOMQuad(new DOMPoint(this._tlx,this._tly),new DOMPoint(this._trx,this._try),new DOMPoint(this._brx,this._bry),new DOMPoint(this._blx,this._bly))}toArray(){return[this._tlx,
this._tly,this._trx,this._try,this._brx,this._bry,this._blx,this._bly]}toTypedArray(){return new Float64Array(this.toArray())}writeToTypedArray(ta,i){ta[i++]=this._tlx;ta[i++]=this._tly;ta[i++]=this._trx;ta[i++]=this._try;ta[i++]=this._brx;ta[i++]=this._bry;ta[i++]=this._blx;ta[i]=this._bly}writeToTypedArray3D(ta,i,z){ta[i++]=this._tlx;ta[i++]=this._tly;ta[i++]=z;ta[i++]=this._trx;ta[i++]=this._try;ta[i++]=z;ta[i++]=this._brx;ta[i++]=this._bry;ta[i++]=z;ta[i++]=this._blx;ta[i++]=this._bly;ta[i]=z}offset(x,
y){x=+x;y=+y;this._tlx+=x;this._tly+=y;this._trx+=x;this._try+=y;this._brx+=x;this._bry+=y;this._blx+=x;this._bly+=y}round(){this._tlx=Math.round(this._tlx);this._tly=Math.round(this._tly);this._trx=Math.round(this._trx);this._try=Math.round(this._try);this._brx=Math.round(this._brx);this._bry=Math.round(this._bry);this._blx=Math.round(this._blx);this._bly=Math.round(this._bly)}floor(){this._tlx=Math.floor(this._tlx);this._tly=Math.floor(this._tly);this._trx=Math.floor(this._trx);this._try=Math.floor(this._try);
this._brx=Math.floor(this._brx);this._bry=Math.floor(this._bry);this._blx=Math.floor(this._blx);this._bly=Math.floor(this._bly)}ceil(){this._tlx=Math.ceil(this._tlx);this._tly=Math.ceil(this._tly);this._trx=Math.ceil(this._trx);this._try=Math.ceil(this._try);this._brx=Math.ceil(this._brx);this._bry=Math.ceil(this._bry);this._blx=Math.ceil(this._blx);this._bly=Math.ceil(this._bly)}setFromRect(rect){this._tlx=rect._left;this._tly=rect._top;this._trx=rect._right;this._try=rect._top;this._brx=rect._right;
this._bry=rect._bottom;this._blx=rect._left;this._bly=rect._bottom}setFromRotatedRect(rect,a){if(a===0)this.setFromRect(rect);else this.setFromRotatedRectPrecalc(rect,Math.sin(a),Math.cos(a))}setFromRotatedRectPrecalc(rect,sin_a,cos_a){const left_sin_a=rect._left*sin_a;const top_sin_a=rect._top*sin_a;const right_sin_a=rect._right*sin_a;const bottom_sin_a=rect._bottom*sin_a;const left_cos_a=rect._left*cos_a;const top_cos_a=rect._top*cos_a;const right_cos_a=rect._right*cos_a;const bottom_cos_a=rect._bottom*
cos_a;this._tlx=left_cos_a-top_sin_a;this._tly=top_cos_a+left_sin_a;this._trx=right_cos_a-top_sin_a;this._try=top_cos_a+right_sin_a;this._brx=right_cos_a-bottom_sin_a;this._bry=bottom_cos_a+right_sin_a;this._blx=left_cos_a-bottom_sin_a;this._bly=bottom_cos_a+left_sin_a}getBoundingBox(rect){rect.set(Math.min(this._tlx,this._trx,this._brx,this._blx),Math.min(this._tly,this._try,this._bry,this._bly),Math.max(this._tlx,this._trx,this._brx,this._blx),Math.max(this._tly,this._try,this._bry,this._bly))}containsPoint(x,
y){let v0x=this._trx-this._tlx;let v0y=this._try-this._tly;const v1x=this._brx-this._tlx;const v1y=this._bry-this._tly;const v2x=x-this._tlx;const v2y=y-this._tly;let dot00=v0x*v0x+v0y*v0y;let dot01=v0x*v1x+v0y*v1y;let dot02=v0x*v2x+v0y*v2y;const dot11=v1x*v1x+v1y*v1y;const dot12=v1x*v2x+v1y*v2y;let invDenom=1/(dot00*dot11-dot01*dot01);let u=(dot11*dot02-dot01*dot12)*invDenom;let v=(dot00*dot12-dot01*dot02)*invDenom;if(u>=0&&v>0&&u+v<1)return true;v0x=this._blx-this._tlx;v0y=this._bly-this._tly;dot00=
v0x*v0x+v0y*v0y;dot01=v0x*v1x+v0y*v1y;dot02=v0x*v2x+v0y*v2y;invDenom=1/(dot00*dot11-dot01*dot01);u=(dot11*dot02-dot01*dot12)*invDenom;v=(dot00*dot12-dot01*dot02)*invDenom;return u>=0&&v>0&&u+v<1}midX(){return(this._tlx+this._trx+this._brx+this._blx)/4}midY(){return(this._tly+this._try+this._bry+this._bly)/4}intersectsSegment(x1,y1,x2,y2){if(this.containsPoint(x1,y1)||this.containsPoint(x2,y2))return true;return C3.segmentIntersectsQuad(x1,y1,x2,y2,this)}intersectsQuad(rhs){let midX=rhs.midX();let midY=
rhs.midY();if(this.containsPoint(midX,midY))return true;midX=this.midX();midY=this.midY();if(rhs.containsPoint(midX,midY))return true;const tlx=this._tlx,tly=this._tly,trx=this._trx,try_=this._try,brx=this._brx,bry=this._bry,blx=this._blx,bly=this._bly;return C3.segmentIntersectsQuad(tlx,tly,trx,try_,rhs)||C3.segmentIntersectsQuad(trx,try_,brx,bry,rhs)||C3.segmentIntersectsQuad(brx,bry,blx,bly,rhs)||C3.segmentIntersectsQuad(blx,bly,tlx,tly,rhs)}mirror(){this._swap(0,2);this._swap(1,3);this._swap(6,
4);this._swap(7,5)}flip(){this._swap(0,6);this._swap(1,7);this._swap(2,4);this._swap(3,5)}diag(){this._swap(2,6);this._swap(3,7)}_swap(i,j){const tmp=this._getAtIndex(i);this._setAtIndex(i,this._getAtIndex(j));this._setAtIndex(j,tmp)}_getAtIndex(i){switch(i){case 0:return this._tlx;case 1:return this._tly;case 2:return this._trx;case 3:return this._try;case 4:return this._brx;case 5:return this._bry;case 6:return this._blx;case 7:return this._bly;default:throw new RangeError("invalid quad point index");
}}_setAtIndex(i,v){v=+v;switch(i){case 0:this._tlx=v;break;case 1:this._tly=v;break;case 2:this._trx=v;break;case 3:this._try=v;break;case 4:this._brx=v;break;case 5:this._bry=v;break;case 6:this._blx=v;break;case 7:this._bly=v;break;default:throw new RangeError("invalid quad point index");}}}};


// c3/lib/misc/collisionPoly.js
'use strict';{const C3=self.C3;const assert=self.assert;const DEFAULT_POLY_POINTS=[0,0,1,0,1,1,0,1];const tempQuad=C3.New(C3.Quad);C3.CollisionPoly=class CollisionPoly extends C3.DefendedBase{constructor(pointsArr,enabled=true){super();if(!pointsArr)pointsArr=DEFAULT_POLY_POINTS;this._ptsArr=Float64Array.from(pointsArr);this._bbox=new C3.Rect;this._isBboxChanged=true;this._enabled=enabled}Release(){}pointsArr(){return this._ptsArr}pointCount(){return this._ptsArr.length/2}setPoints(pointsArr){if(this._ptsArr.length===
pointsArr.length)this._ptsArr.set(pointsArr);else this._ptsArr=Float64Array.from(pointsArr);this._isBboxChanged=true}setDefaultPoints(){this.setPoints(DEFAULT_POLY_POINTS)}copy(poly){this.setPoints(poly._ptsArr)}setBboxChanged(){this._isBboxChanged=true}_updateBbox(){if(!this._isBboxChanged)return;const ptsArr=this._ptsArr;let left=ptsArr[0];let top=ptsArr[1];let right=left;let bottom=top;for(let i=0,len=ptsArr.length;i<len;i+=2){const x=ptsArr[i];const y=ptsArr[i+1];if(x<left)left=x;if(x>right)right=
x;if(y<top)top=y;if(y>bottom)bottom=y}this._bbox.set(left,top,right,bottom);this._isBboxChanged=false}setFromRect(rc,offX,offY){let ptsArr=this._ptsArr;if(ptsArr.length!==8){ptsArr=new Float64Array(8);this._ptsArr=ptsArr}ptsArr[0]=rc.getLeft()-offX;ptsArr[1]=rc.getTop()-offY;ptsArr[2]=rc.getRight()-offX;ptsArr[3]=rc.getTop()-offY;ptsArr[4]=rc.getRight()-offX;ptsArr[5]=rc.getBottom()-offY;ptsArr[6]=rc.getLeft()-offX;ptsArr[7]=rc.getBottom()-offY;this._bbox.copy(rc);if(offX!==0||offY!==0)this._bbox.offset(-offX,
-offY);this._isBboxChanged=false}setFromQuad(q,offX,offY){tempQuad.copy(q);tempQuad.offset(offX,offY);this.setPoints(tempQuad.toArray());this._isBboxChanged=true}transform(w,h,a){let sina=0;let cosa=1;if(a!==0){sina=Math.sin(a);cosa=Math.cos(a)}this.transformPrecalc(w,h,sina,cosa)}transformPrecalc(w,h,sina,cosa){const ptsArr=this._ptsArr;for(let i=0,len=ptsArr.length;i<len;i+=2){const j=i+1;const x=ptsArr[i]*w;const y=ptsArr[j]*h;ptsArr[i]=x*cosa-y*sina;ptsArr[j]=y*cosa+x*sina}this._isBboxChanged=
true}offset(x,y){const ptsArr=this._ptsArr;for(let i=0,len=ptsArr.length;i<len;i+=2){ptsArr[i]+=x;ptsArr[i+1]+=y}}containsPoint(a2x,a2y){const ptsArr=this._ptsArr;if(a2x===ptsArr[0]&&a2y===ptsArr[1])return true;this._updateBbox();const bbox=this._bbox;const a1x=bbox.getLeft()-110;const a1y=bbox.getTop()-101;const a3x=bbox.getRight()+131;const a3y=bbox.getBottom()+120;let minAx12=0;let minAy12=0;let maxAx12=0;let maxAy12=0;let minAx32=0;let minAy32=0;let maxAx32=0;let maxAy32=0;if(a1x<a2x){minAx12=
a1x;maxAx12=a2x}else{minAx12=a2x;maxAx12=a1x}if(a1y<a2y){minAy12=a1y;maxAy12=a2y}else{minAy12=a2y;maxAy12=a1y}if(a3x<a2x){minAx32=a3x;maxAx32=a2x}else{minAx32=a2x;maxAx32=a3x}if(a3y<a2y){minAy32=a3y;maxAy32=a2y}else{minAy32=a2y;maxAy32=a3y}let count1=0;let count2=0;for(let i=0,len=ptsArr.length;i<len;i+=2){const j=(i+2)%len;const b1x=ptsArr[i];const b1y=ptsArr[i+1];const b2x=ptsArr[j];const b2y=ptsArr[j+1];if(C3.segmentsIntersectPreCalc(a1x,a1y,a2x,a2y,minAx12,maxAx12,minAy12,maxAy12,b1x,b1y,b2x,
b2y))++count1;if(C3.segmentsIntersectPreCalc(a3x,a3y,a2x,a2y,minAx32,maxAx32,minAy32,maxAy32,b1x,b1y,b2x,b2y))++count2}return count1%2===1||count2%2===1}intersectsPoly(poly,offX,offY){const rPts=poly._ptsArr;const lPts=this._ptsArr;if(this.containsPoint(rPts[0]+offX,rPts[1]+offY))return true;if(poly.containsPoint(lPts[0]-offX,lPts[1]-offY))return true;for(let i=0,leni=lPts.length;i<leni;i+=2){const j=(i+2)%leni;const a1x=lPts[i];const a1y=lPts[i+1];const a2x=lPts[j];const a2y=lPts[j+1];let minAx=
0;let minAy=0;let maxAx=0;let maxAy=0;if(a1x<a2x){minAx=a1x;maxAx=a2x}else{minAx=a2x;maxAx=a1x}if(a1y<a2y){minAy=a1y;maxAy=a2y}else{minAy=a2y;maxAy=a1y}for(let k=0,lenk=rPts.length;k<lenk;k+=2){const l=(k+2)%lenk;const b1x=rPts[k]+offX;const b1y=rPts[k+1]+offY;const b2x=rPts[l]+offX;const b2y=rPts[l+1]+offY;if(C3.segmentsIntersectPreCalc(a1x,a1y,a2x,a2y,minAx,maxAx,minAy,maxAy,b1x,b1y,b2x,b2y))return true}}return false}intersectsSegment(offX,offY,a1x,a1y,a2x,a2y){if(this.containsPoint(a1x-offX,a1y-
offY))return true;if(this.containsPoint(a2x-offX,a2y-offY))return true;let minAx=0;let minAy=0;let maxAx=0;let maxAy=0;if(a1x<a2x){minAx=a1x;maxAx=a2x}else{minAx=a2x;maxAx=a1x}if(a1y<a2y){minAy=a1y;maxAy=a2y}else{minAy=a2y;maxAy=a1y}const ptsArr=this._ptsArr;for(let i=0,len=ptsArr.length;i<len;i+=2){const j=(i+2)%len;const b1x=ptsArr[i]+offX;const b1y=ptsArr[i+1]+offY;const b2x=ptsArr[j]+offX;const b2y=ptsArr[j+1]+offY;if(C3.segmentsIntersectPreCalc(a1x,a1y,a2x,a2y,minAx,maxAx,minAy,maxAy,b1x,b1y,
b2x,b2y))return true}return false}mirror(px){const ptsArr=this._ptsArr;for(let i=0,len=ptsArr.length;i<len;i+=2)ptsArr[i]=px*2-ptsArr[i];this._isBboxChanged=true}flip(py){const ptsArr=this._ptsArr;for(let i=0,len=ptsArr.length;i<len;i+=2){const j=i+1;ptsArr[j]=py*2-ptsArr[j]}this._isBboxChanged=true}diag(){const ptsArr=this._ptsArr;for(let i=0,len=ptsArr.length;i<len;i+=2){const j=i+1;const temp=ptsArr[i];ptsArr[i]=ptsArr[j];ptsArr[j]=temp}this._isBboxChanged=true}GetMidX(){const ptsArr=this._ptsArr;
let ret=0;for(let i=0,len=ptsArr.length;i<len;i+=2)ret+=ptsArr[i];return ret/this.pointCount()}GetMidY(){const ptsArr=this._ptsArr;let ret=0;for(let i=0,len=ptsArr.length;i<len;i+=2)ret+=ptsArr[i+1];return ret/this.pointCount()}GetPointsArray(){return this._ptsArr}GetPointCount(){return this.pointCount()}IsEnabled(){return this._enabled}}};


// c3/lib/misc/pairMap.js
'use strict';{const C3=self.C3;C3.PairMap=class PairMap extends C3.DefendedBase{constructor(iterable){super();this._firstMap=new Map;if(iterable)for(const [x,y,value]of iterable)this.Set(x,y,value)}Release(){this.Clear();this._firstMap=null}Clear(){const firstMap=this._firstMap;for(const secondMap of firstMap.values())secondMap.clear();firstMap.clear()}Set(x,y,value){const firstMap=this._firstMap;let secondMap=firstMap.get(x);if(!secondMap){secondMap=new Map;firstMap.set(x,secondMap)}secondMap.set(y,
value)}Get(x,y){const secondMap=this._firstMap.get(x);if(!secondMap)return secondMap;return secondMap.get(y)}Has(x,y){const secondMap=this._firstMap.get(x);if(!secondMap)return false;return secondMap.has(y)}Delete(x,y){const firstMap=this._firstMap;const secondMap=firstMap.get(x);if(!secondMap)return false;const ret=secondMap.delete(y);if(ret&&secondMap.size===0)firstMap.delete(x);return ret}DeleteEither(k){const firstMap=this._firstMap;const secondMap=firstMap.get(k);if(secondMap){secondMap.clear();
firstMap.delete(k)}for(const [x,secondMap]of firstMap.entries())if(secondMap.delete(k)&&secondMap.size===0)firstMap.delete(x)}GetSize(){let ret=0;for(const secondMap of this._firstMap.values())ret+=secondMap.size;return ret}*values(){for(const secondMap of this._firstMap.values())yield*secondMap.values()}*keyPairs(){for(const [x,secondMap]of this._firstMap.entries())for(const y of secondMap.keys())yield[x,y]}*entries(){for(const [x,secondMap]of this._firstMap.entries())for(const [y,value]of secondMap.entries())yield[x,
y,value]}}};


// c3/lib/misc/arraySet.js
'use strict';{const C3=self.C3;C3.ArraySet=class ArraySet extends C3.DefendedBase{constructor(){super();this._set=new Set;this._arr=[];this._needToRebuildArray=false}Release(){this.Clear()}Clear(){this._set.clear();C3.clearArray(this._arr);this._needToRebuildArray=false}Add(v){if(this._set.has(v))return;this._set.add(v);if(!this._needToRebuildArray)this._arr.push(v)}Has(v){return this._set.has(v)}Delete(v){if(this._set.delete(v))this._needToRebuildArray=true}GetSize(){return this._set.size}IsEmpty(){return this._set.size===
0}GetArray(){if(this._needToRebuildArray){this._RebuildArray();this._needToRebuildArray=false}return this._arr}_RebuildArray(){const arr=this._arr;C3.clearArray(arr);for(const v of this._set)arr.push(v)}}};


// ../lib/misc/ease.js
'use strict';{const C3=self.C3;const EASE_MAP=new Map;const PREDEFINED_EASE_MAP=new Map;const CUSTOM_EASE_EDITOR_MAP=new Map;const CUSTOM_EASE_RUNTIME_MAP=new Map;const PRIVATE_EASE_MAP=new Map;const ALIAS_MAP=new Map;ALIAS_MAP.set("linear","noease");ALIAS_MAP.set("default","noease");self.Ease=class Ease{constructor(){}static InheritEase(){return"default"}static DefaultEase(){return"noease"}static GetEditorEaseNames(project,...filter){this._CreateEaseMap();if(!CUSTOM_EASE_EDITOR_MAP.has(project))CUSTOM_EASE_EDITOR_MAP.set(project,
new Map);const customEaseMap=CUSTOM_EASE_EDITOR_MAP.get(project);const sortedCustomEases=[...customEaseMap.keys()];sortedCustomEases.sort();return[...PREDEFINED_EASE_MAP.keys()].concat(sortedCustomEases).filter(ease=>!filter.includes(ease))}static GetRuntimeEaseNames(){this._CreateEaseMap();const sortedCustomEases=[...CUSTOM_EASE_RUNTIME_MAP.keys()];sortedCustomEases.sort();return[...PREDEFINED_EASE_MAP.keys()].concat(sortedCustomEases)}static IsNamePredefined(easeName){this._CreateEaseMap();return[...PREDEFINED_EASE_MAP.keys()].includes(easeName)}static _GetEase(easeName){const realEaseName=
ALIAS_MAP.get(easeName);if(realEaseName)return EASE_MAP.get(realEaseName);if(Ease.IsNamePredefined(easeName))return EASE_MAP.get(easeName);if(PRIVATE_EASE_MAP.has(easeName))return PRIVATE_EASE_MAP.get(easeName)}static GetEditorEase(easeName,project){this._CreateEaseMap();const ease=Ease._GetEase(easeName);if(ease)return ease;return CUSTOM_EASE_EDITOR_MAP.get(project).get(easeName)}static GetRuntimeEase(easeName){this._CreateEaseMap();const ease=Ease._GetEase(easeName);if(ease)return ease;return CUSTOM_EASE_RUNTIME_MAP.get(easeName)}static GetEaseFromIndex(index){this._CreateEaseMap();
const names=this.GetRuntimeEaseNames();return names[index]}static GetIndexForEase(name,project){this._CreateEaseMap();const names=this.GetEditorEaseNames(project);return names.indexOf(name)}static _CreateEaseMap(){if(EASE_MAP.size!==0)return;this._AddPredifinedEase("default",()=>{});this._AddPredifinedEase("noease",this.NoEase);this._AddPredifinedEase("easeinsine",this.EaseInSine);this._AddPredifinedEase("easeoutsine",this.EaseOutSine);this._AddPredifinedEase("easeinoutsine",this.EaseInOutSine);this._AddPredifinedEase("easeinelastic",
this.EaseInElastic);this._AddPredifinedEase("easeoutelastic",this.EaseOutElastic);this._AddPredifinedEase("easeinoutelastic",this.EaseInOutElastic);this._AddPredifinedEase("easeinback",this.EaseInBack);this._AddPredifinedEase("easeoutback",this.EaseOutBack);this._AddPredifinedEase("easeinoutback",this.EaseInOutBack);this._AddPredifinedEase("easeinbounce",this.EaseInBounce);this._AddPredifinedEase("easeoutbounce",this.EaseOutBounce);this._AddPredifinedEase("easeinoutbounce",this.EaseInOutBounce);this._AddPredifinedEase("easeincubic",
this.EaseInCubic);this._AddPredifinedEase("easeoutcubic",this.EaseOutCubic);this._AddPredifinedEase("easeinoutcubic",this.EaseInOutCubic);this._AddPredifinedEase("easeinquad",this.EaseInQuad);this._AddPredifinedEase("easeoutquad",this.EaseOutQuad);this._AddPredifinedEase("easeinoutquad",this.EaseInOutQuad);this._AddPredifinedEase("easeinquart",this.EaseInQuart);this._AddPredifinedEase("easeoutquart",this.EaseOutQuart);this._AddPredifinedEase("easeinoutquart",this.EaseInOutQuart);this._AddPredifinedEase("easeinquint",
this.EaseInQuint);this._AddPredifinedEase("easeoutquint",this.EaseOutQuint);this._AddPredifinedEase("easeinoutquint",this.EaseInOutQuint);this._AddPredifinedEase("easeincirc",this.EaseInCirc);this._AddPredifinedEase("easeoutcirc",this.EaseOutCirc);this._AddPredifinedEase("easeinoutcirc",this.EaseInOutCirc);this._AddPredifinedEase("easeinexpo",this.EaseInExpo);this._AddPredifinedEase("easeoutexpo",this.EaseOutExpo);this._AddPredifinedEase("easeinoutexpo",this.EaseInOutExpo);this._AddPrivateCustomEase("cubicbezier",
this.EaseCubicBezier);this._AddPrivateCustomEase("spline",this.EaseSpline)}static _AddPredifinedEase(name,func){Ease._AddEase(name,func,"predefined")}static _AddPrivateCustomEase(name,func){Ease._AddEase(name,func,"private")}static AddCustomEase(name,func,project){this._CreateEaseMap();Ease._AddEase(name,func,"custom",project)}static RemoveCustomEase(name,project){if(this.IsNamePredefined(name))return;if([...PRIVATE_EASE_MAP.keys()].includes(name))return;const customEaseMap=CUSTOM_EASE_EDITOR_MAP.get(project);
if(customEaseMap)customEaseMap.delete(name)}static _AddEase(name,func,mode,project){switch(mode){case "predefined":EASE_MAP.set(name,func);PREDEFINED_EASE_MAP.set(name,func);break;case "custom":if(project){if(!CUSTOM_EASE_EDITOR_MAP.has(project))CUSTOM_EASE_EDITOR_MAP.set(project,new Map);const customEaseMap=CUSTOM_EASE_EDITOR_MAP.get(project);customEaseMap.set(name,func)}else CUSTOM_EASE_RUNTIME_MAP.set(name,func);break;case "private":EASE_MAP.set(name,func);PRIVATE_EASE_MAP.set(name,func);break;
default:throw new Error("unexpected ease mode");}}static NoEase(t,b,c,d){return c*t/d+b}static EaseInQuad(t,b,c,d){return c*(t/=d)*t+b}static EaseOutQuad(t,b,c,d){return-c*(t/=d)*(t-2)+b}static EaseInOutQuad(t,b,c,d){if((t/=d/2)<1)return c/2*t*t+b;return-c/2*(--t*(t-2)-1)+b}static EaseInCubic(t,b,c,d){return c*(t/=d)*t*t+b}static EaseOutCubic(t,b,c,d){return c*((t=t/d-1)*t*t+1)+b}static EaseInOutCubic(t,b,c,d){if((t/=d/2)<1)return c/2*t*t*t+b;return c/2*((t-=2)*t*t+2)+b}static EaseInQuart(t,b,c,d){return c*
(t/=d)*t*t*t+b}static EaseOutQuart(t,b,c,d){return-c*((t=t/d-1)*t*t*t-1)+b}static EaseInOutQuart(t,b,c,d){if((t/=d/2)<1)return c/2*t*t*t*t+b;return-c/2*((t-=2)*t*t*t-2)+b}static EaseInQuint(t,b,c,d){return c*(t/=d)*t*t*t*t+b}static EaseOutQuint(t,b,c,d){return c*((t=t/d-1)*t*t*t*t+1)+b}static EaseInOutQuint(t,b,c,d){if((t/=d/2)<1)return c/2*t*t*t*t*t+b;return c/2*((t-=2)*t*t*t*t+2)+b}static EaseInSine(t,b,c,d){return-c*Math.cos(t/d*(Math.PI/2))+c+b}static EaseOutSine(t,b,c,d){return c*Math.sin(t/
d*(Math.PI/2))+b}static EaseInOutSine(t,b,c,d){return-c/2*(Math.cos(Math.PI*t/d)-1)+b}static EaseInExpo(t,b,c,d){return t===0?b:c*Math.pow(2,10*(t/d-1))+b}static EaseOutExpo(t,b,c,d){return t===d?b+c:c*(-Math.pow(2,-10*t/d)+1)+b}static EaseInOutExpo(t,b,c,d){if(t===0)return b;if(t===d)return b+c;if((t/=d/2)<1)return c/2*Math.pow(2,10*(t-1))+b;return c/2*(-Math.pow(2,-10*--t)+2)+b}static EaseInCirc(t,b,c,d){return-c*(Math.sqrt(1-(t/=d)*t)-1)+b}static EaseOutCirc(t,b,c,d){return c*Math.sqrt(1-(t=t/
d-1)*t)+b}static EaseInOutCirc(t,b,c,d){if((t/=d/2)<1)return-c/2*(Math.sqrt(1-t*t)-1)+b;return c/2*(Math.sqrt(1-(t-=2)*t)+1)+b}static EaseInElastic(t,b,c,d){let s=1.70158;let p=0;let a=c;if(t===0)return b;if((t/=d)===1)return b+c;if(!p)p=d*.3;if(a<Math.abs(c)){a=c;s=p/4}else s=p/(2*Math.PI)*Math.asin(c/a);return-(a*Math.pow(2,10*(t-=1))*Math.sin((t*d-s)*(2*Math.PI)/p))+b}static EaseOutElastic(t,b,c,d){let s=1.70158;let p=0;let a=c;if(t===0)return b;if((t/=d)===1)return b+c;if(!p)p=d*.3;if(a<Math.abs(c)){a=
c;s=p/4}else s=p/(2*Math.PI)*Math.asin(c/a);return a*Math.pow(2,-10*t)*Math.sin((t*d-s)*(2*Math.PI)/p)+c+b}static EaseInOutElastic(t,b,c,d){let s=1.70158;let p=0;let a=c;if(t===0)return b;if((t/=d/2)===2)return b+c;if(!p)p=d*(.3*1.5);if(a<Math.abs(c)){a=c;s=p/4}else s=p/(2*Math.PI)*Math.asin(c/a);if(t<1)return-.5*(a*Math.pow(2,10*(t-=1))*Math.sin((t*d-s)*(2*Math.PI)/p))+b;return a*Math.pow(2,-10*(t-=1))*Math.sin((t*d-s)*(2*Math.PI)/p)*.5+c+b}static EaseInBack(t,b,c,d,s){if(s===undefined)s=1.70158;
return c*(t/=d)*t*((s+1)*t-s)+b}static EaseOutBack(t,b,c,d,s){if(s===undefined)s=1.70158;return c*((t=t/d-1)*t*((s+1)*t+s)+1)+b}static EaseInOutBack(t,b,c,d,s){if(s===undefined)s=1.70158;if((t/=d/2)<1)return c/2*(t*t*(((s*=1.525)+1)*t-s))+b;return c/2*((t-=2)*t*(((s*=1.525)+1)*t+s)+2)+b}static EaseInBounce(t,b,c,d){return c-Ease.EaseOutBounce(d-t,0,c,d)+b}static EaseOutBounce(t,b,c,d){if((t/=d)<1/2.75)return c*(7.5625*t*t)+b;else if(t<2/2.75)return c*(7.5625*(t-=1.5/2.75)*t+.75)+b;else if(t<2.5/2.75)return c*
(7.5625*(t-=2.25/2.75)*t+.9375)+b;else return c*(7.5625*(t-=2.625/2.75)*t+.984375)+b}static EaseInOutBounce(t,b,c,d){if(t<d/2)return Ease.EaseInBounce(t*2,0,c,d)*.5+b;return Ease.EaseOutBounce(t*2-d,0,c,d)*.5+c*.5+b}static EaseCubicBezier(t,p0,p1,p2,p3){const _0=p0;const _1=3*t*(p1-p0);const _2=3*t**2*(p0+p2-2*p1);const _3=t**3*(p3-p0+3*p1-3*p2);return _0+_1+_2+_3}static EaseSpline(t,sx,sy,x1,y1,x2,y2,ex,ey,samples){if(x1===y1&&x2===y2)return t;const tx=get_t_for_x(t,sx,x1,x2,ex,samples);const va=
a(sy,y1,y2,ey);const vb=b(sy,y1,y2,ey);const vc=c(sy,y1,y2,ey);return calc_bezier(tx,va,vb,vc)}static GetBezierSamples(startx,a1x,a2x,endx){const ret=[];const va=a(startx,a1x,a2x,endx);const vb=b(startx,a1x,a2x,endx);const vc=c(startx,a1x,a2x,endx);for(let i=0;i<SAMPLE_COUNT;++i){const sample=calc_bezier(i*SAMPLE_STEP,va,vb,vc);ret.push(sample)}return ret}};const SAMPLE_COUNT=11;const SAMPLE_STEP=1/(SAMPLE_COUNT-1);const NEWTON_RAPHSON_ITERATIONS=4;const NEWTON_RAPHSON_MIN_SLOPE=.02;const SUBDIVISION_PRECISION=
1E-7;const SUBDIVISION_MAX_ITERATIONS=10;const a=(p0,p1,p2,p3)=>{return p3-3*p2+3*p1-p0};const b=(p0,p1,p2,p3)=>{return 3*p2-6*p1+3*p0};const c=(p0,p1,p2,p3)=>{return 3*(p1-p0)};const calc_bezier=(aT,a,b,c)=>{return((a*aT+b)*aT+c)*aT};const get_slope=(aT,a,b,c)=>{return 3*a*aT*aT+2*b*aT+c};const get_t_for_x=(aX,p0,p1,p2,p3,samples)=>{if(aX==1)return 1;let intervalStart=0;let currentSampleIndex=1;let currentSampleValue=samples[currentSampleIndex];let lastSampleIndex=SAMPLE_COUNT-1;let lastSampleValue=
samples[SAMPLE_COUNT-1];while(currentSampleIndex!=lastSampleIndex&&currentSampleValue<=aX){currentSampleIndex++;currentSampleValue=samples[currentSampleIndex];intervalStart+=SAMPLE_STEP}currentSampleIndex--;currentSampleValue=samples[currentSampleIndex];const dist=(aX-currentSampleValue)/(samples[currentSampleIndex+1]-currentSampleValue);let guess=intervalStart+dist*SAMPLE_STEP;const va=a(p0,p1,p2,p3);const vb=b(p0,p1,p2,p3);const vc=c(p0,p1,p2,p3);const initSlope=get_slope(guess,va,vb,vc);if(initSlope===
0)return guess;else if(initSlope>=NEWTON_RAPHSON_MIN_SLOPE){for(let i=0;i<NEWTON_RAPHSON_ITERATIONS;++i){const x=calc_bezier(guess,va,vb,vc)-aX;const slope=get_slope(guess,va,vb,vc);guess-=x/slope}return guess}else{let aA=intervalStart;let aB=intervalStart+SAMPLE_STEP;let i=0;let precissionLimit;let maxIterations;do{guess=aA+(aB-aA)/2;let x=calc_bezier(guess,va,vb,vc)-aX;if(x>0)aB=guess;else aA=guess;precissionLimit=Math.abs(x)>SUBDIVISION_PRECISION;maxIterations=++i<SUBDIVISION_MAX_ITERATIONS}while(precissionLimit&&
maxIterations);return guess}}};


// ../lib/misc/probability.js
'use strict';{const C3=self.C3;function RequireStringOrNumber(value){if(!C3.IsString(value));}C3.ProbabilityTable=class ProbabilityTable{constructor(){this._items=[];this._totalWeight=0}Release(){this.Clear();this._items=null}Clear(){C3.clear2DArray(this._items);this._totalWeight=0}GetTotalWeight(){return this._totalWeight}Sample(t=Math.random()*this.GetTotalWeight()){let sumWeight=0;for(const [weight,value]of this._items){sumWeight+=weight;if(t<sumWeight)return value}return 0}AddItem(weight,value){RequireStringOrNumber(value);
this._totalWeight+=weight;this._items.push([weight,value])}RemoveItem(weight,value){RequireStringOrNumber(value);const ignoreWeight=weight===0;for(let i=0;i<this._items.length;i++){const item=this._items[i];const doesWeightMatch=ignoreWeight||item[0]===weight;const doesValueMatch=item[1]===value;if(doesWeightMatch&&doesValueMatch){this._items.splice(i,1);this._totalWeight-=item[0];break}}}asJSON(){return JSON.stringify(this._items)}static fromJSON(str){const table=new C3.ProbabilityTable;const items=
JSON.parse(str);for(const item of items){const weight=item[0];const value=item[1];table.AddItem(weight,value)}return table}}};


// ../lib/events/event.js
'use strict';{const C3=self.C3;C3.Event=class Event{constructor(type,cancelable){this.type=type;this.cancelable=!!cancelable;this.defaultPrevented=false;this.propagationStopped=false;this.isAsync=false}preventDefault(){if(!this.cancelable)throw new Error(`event '${this.type}' is not cancelable`);this.defaultPrevented=true}stopPropagation(){if(!this.cancelable)throw new Error(`event '${this.type}' cannot be stopped`);if(this.isAsync)throw new Error(`cannot stop async event '${this.type}' propagation`);
this.propagationStopped=true}}};


// ../lib/events/handler.js
'use strict';{const C3=self.C3;const assert=self.assert;C3.Event.Handler=class EventHandler extends C3.DefendedBase{constructor(type){super();this._type=type;this._captureListeners=[];this._captureListenersSet=new Set;this._listeners=[];this._listenersSet=new Set;this._fireDepth=0;this._queueAddListeners=[];this._queueRemoveCaptureListeners=[];this._queueRemoveListeners=[]}Release(){if(this._fireDepth>0)return;C3.clearArray(this._captureListeners);this._captureListenersSet.clear();C3.clearArray(this._listeners);
this._listenersSet.clear();C3.clearArray(this._queueAddListeners);C3.clearArray(this._queueRemoveCaptureListeners);C3.clearArray(this._queueRemoveListeners);C3.Release(this)}_AddListener(func,capture){if(this._IsFiring()){this._queueAddListeners.push([func,capture]);return}if(capture){if(this._captureListenersSet.has(func))return;this._captureListeners.push(func);this._captureListenersSet.add(func)}else{if(this._listenersSet.has(func))return;this._listeners.push(func);this._listenersSet.add(func)}}_RemoveListener(func,
capture){if(this._IsFiring()){if(capture)this._queueRemoveCaptureListeners.push(func);else this._queueRemoveListeners.push(func);return}if(capture){if(this._captureListenersSet.has(func)){this._captureListenersSet.delete(func);C3.arrayFindRemove(this._captureListeners,func)}}else if(this._listenersSet.has(func)){this._listenersSet.delete(func);C3.arrayFindRemove(this._listeners,func)}}_IsEmpty(){return!this._captureListeners.length&&!this._listeners.length}_IsFiring(){return this._fireDepth>0}_ProcessQueuedListeners(){for(let q of this._queueAddListeners)this._AddListener(...q);
C3.clearArray(this._queueAddListeners);for(const func of this._queueRemoveListeners)this._listenersSet.delete(func);for(const func of this._queueRemoveCaptureListeners)this._captureListenersSet.delete(func);const removeListenersSet=new Set(this._queueRemoveListeners);const removeCaptureListenersSet=new Set(this._queueRemoveCaptureListeners);C3.arrayRemoveAllInSet(this._listeners,removeListenersSet);C3.arrayRemoveAllInSet(this._captureListeners,removeCaptureListenersSet);C3.clearArray(this._queueRemoveCaptureListeners);
C3.clearArray(this._queueRemoveListeners)}_FireCancellable(event){this._IncreaseFireDepth();let isStopped=false;for(let i=0,len=this._captureListeners.length;i<len;++i){this._captureListeners[i](event);if(event.propagationStopped){isStopped=true;break}}if(!isStopped)for(let i=0,len=this._listeners.length;i<len;++i){this._listeners[i](event);if(event.propagationStopped)break}this._DecreaseFireDepth();return!event.defaultPrevented}_FireNonCancellable(event){this._IncreaseFireDepth();for(let i=0,len=
this._captureListeners.length;i<len;++i)this._captureListeners[i](event);for(let i=0,len=this._listeners.length;i<len;++i)this._listeners[i](event);this._DecreaseFireDepth();return true}_IncreaseFireDepth(){this._fireDepth++}_DecreaseFireDepth(){this._fireDepth--;if(this._fireDepth===0&&(this._queueAddListeners.length||this._queueRemoveCaptureListeners.length||this._queueRemoveListeners.length))this._ProcessQueuedListeners()}SetDelayRemoveEventsEnabled(e){if(e)this._IncreaseFireDepth();else this._DecreaseFireDepth()}_FireAsync(event){let callbackPromises=
[];for(let i=0,len=this._captureListeners.length;i<len;++i){let func=this._captureListeners[i];callbackPromises.push(C3.Asyncify(()=>func(event)))}for(let i=0,len=this._listeners.length;i<len;++i){let func=this._listeners[i];callbackPromises.push(C3.Asyncify(()=>func(event)))}return Promise.all(callbackPromises).then(()=>!event.defaultPrevented)}_FireAndWait_AsyncOptional(event){const results=[];this._IncreaseFireDepth();for(let i=0,len=this._captureListeners.length;i<len;++i){const ret=this._captureListeners[i](event);
if(ret instanceof Promise)results.push(ret)}for(let i=0,len=this._listeners.length;i<len;++i){const ret=this._listeners[i](event);if(ret instanceof Promise)results.push(ret)}this._DecreaseFireDepth();if(results.length)return Promise.all(results).then(()=>!event.defaultPrevented);else return!event.defaultPrevented}async _FireAndWaitAsync(event){return await this._FireAndWait_AsyncOptional(event)}async _FireAndWaitAsyncSequential(event){this._IncreaseFireDepth();for(let i=0,len=this._captureListeners.length;i<
len;++i){const ret=this._captureListeners[i](event);if(ret instanceof Promise)await ret}for(let i=0,len=this._listeners.length;i<len;++i){const ret=this._listeners[i](event);if(ret instanceof Promise)await ret}this._DecreaseFireDepth();return!event.defaultPrevented}*_FireAsGenerator(event){this._IncreaseFireDepth();for(let i=0,len=this._captureListeners.length;i<len;++i){const ret=this._captureListeners[i](event);if(C3.IsIterator(ret))yield*ret}for(let i=0,len=this._listeners.length;i<len;++i){const ret=
this._listeners[i](event);if(C3.IsIterator(ret))yield*ret}this._DecreaseFireDepth()}}};


// ../lib/events/dispatcher.js
'use strict';{const C3=self.C3;C3.Event.Dispatcher=class EventDispatcher extends C3.DefendedBase{constructor(){super();this._eventHandlers=new Map;this._dispatcherWasReleased=false}Release(){if(this._dispatcherWasReleased)throw new Error("already released");this.ClearEvents();this._dispatcherWasReleased=true;C3.Release(this)}WasReleased(){return this._dispatcherWasReleased}ClearEvents(){for(let handler of this._eventHandlers.values())handler.Release();this._eventHandlers.clear()}_GetHandlerByType(type,
create_if_missing){let handler=this._eventHandlers.get(type);if(handler)return handler;if(create_if_missing){handler=C3.New(C3.Event.Handler,type);this._eventHandlers.set(type,handler);return handler}return null}HasAnyHandlerFor(type){return this._eventHandlers.has(type)}addEventListener(type,func,capture){let handler=this._GetHandlerByType(type,true);handler._AddListener(func,!!capture)}removeEventListener(type,func,capture){let handler=this._GetHandlerByType(type,false);if(!handler)return;handler._RemoveListener(func,
!!capture);if(handler._IsEmpty())this._eventHandlers.delete(type)}dispatchEvent(event){const handler=this._GetHandlerByType(event.type,false);if(!handler)return true;if(event.cancelable)return handler._FireCancellable(event);else return handler._FireNonCancellable(event)}dispatchEventAsync(event){const handler=this._GetHandlerByType(event.type,false);if(!handler)return Promise.resolve(true);event.isAsync=true;return handler._FireAsync(event)}async dispatchEventAndClearAsync(event){const handler=this._GetHandlerByType(event.type,
false);if(!handler)return true;this._eventHandlers.delete(event.type);event.isAsync=true;const ret=await handler._FireAsync(event);handler.Release();return ret}async dispatchEventAndWaitAsync(event){const handler=this._GetHandlerByType(event.type,false);if(!handler)return true;return await handler._FireAndWaitAsync(event)}dispatchEventAndWait_AsyncOptional(event){const handler=this._GetHandlerByType(event.type,false);if(!handler)return true;return handler._FireAndWait_AsyncOptional(event)}async dispatchEventAndWaitAsyncSequential(event){const handler=
this._GetHandlerByType(event.type,false);if(!handler)return true;return await handler._FireAndWaitAsyncSequential(event)}dispatchGeneratorEvent(event){const handler=this._GetHandlerByType(event.type,false);if(!handler)return null;if(event.cancelable)throw new Error("not supported");else return handler._FireAsGenerator(event)}SetDelayRemoveEventsEnabled(e){for(const handler of this._eventHandlers.values())handler.SetDelayRemoveEventsEnabled(e)}}};


// ../lib/util/asyncify.js
'use strict';{const C3=self.C3;const SETTIMEOUT_WORK_DURATION=12;const SETTIMEOUT_INTERVAL=16;const IDLECALLBACK_TIMEOUT=35;const SUPPORTS_RIC=typeof requestIdleCallback!=="undefined";let workQueue=[];let callbackId=-1;let highThroughputMode=0;function SetNewCallback(timerTimeout){if(SUPPORTS_RIC&&highThroughputMode===0)callbackId=requestIdleCallback(DoAsyncifiedWork,{timeout:IDLECALLBACK_TIMEOUT});else callbackId=setTimeout(DoAsyncifiedWork,highThroughputMode>0?1:timerTimeout)}function DoAsyncifiedWork(deadline){callbackId=
-1;if(!workQueue.length)return;let startTime=performance.now();let curTime=startTime;let jobCount=0;let estimatedNextJobDuration=0;do{DoNextAsyncifiedJob(workQueue.shift());curTime=performance.now();++jobCount;estimatedNextJobDuration=(curTime-startTime)/jobCount*1.1}while(workQueue.length&&(SUPPORTS_RIC&&highThroughputMode===0&&typeof deadline!=="undefined"?estimatedNextJobDuration<deadline["timeRemaining"]():curTime-startTime+estimatedNextJobDuration<SETTIMEOUT_WORK_DURATION));if(callbackId===-1&&
workQueue.length){let workDuration=curTime-startTime;let timeout=Math.max(SETTIMEOUT_INTERVAL-workDuration,4);SetNewCallback(timeout)}}function DoNextAsyncifiedJob(w){let ret;try{ret=w.func()}catch(e){w.reject(e);return}w.resolve(ret)}let asyncifyDisabled=C3.QueryString.Has("disable-asyncify");if(asyncifyDisabled)console.warn("[Asyncify] Asyncify has been disabled due to disable-asyncify in the query string. Some work will now be done synchronously.");C3.Asyncify=function Asyncify(func){let stack=
null;if(C3.isDebug)stack=C3.GetCallStack();return new Promise((resolve,reject)=>{workQueue.push({func:func,resolve:resolve,reject:reject,stack:stack});if(asyncifyDisabled){DoNextAsyncifiedJob(workQueue.pop());return}if(callbackId===-1)SetNewCallback(SETTIMEOUT_INTERVAL)})};C3.Asyncify.SetHighThroughputMode=function SetHighThroughputMode(m){if(m)++highThroughputMode;else{--highThroughputMode;if(highThroughputMode<0)throw new Error("already turned off high throughput mode");}}};


// ../lib/util/idleTimeout.js
'use strict';{const C3=self.C3;const IDLE_CHECK_MIN_INTERVAL=1E3;const IDLE_CHECK_TIMER_OVERSHOOT=100;let cachedNowTime=-1;function ClearTimeCache(){cachedNowTime=-1}C3.FastGetDateNow=function FastGetDateNow(){if(cachedNowTime===-1){cachedNowTime=Date.now();self.setTimeout(ClearTimeCache,16)}return cachedNowTime};let timerId=-1;let nextDeadline=-1;let activeIdleTimeouts=new Set;function CheckActiveIdleTimeouts(){timerId=-1;nextDeadline=-1;let nowTime=Date.now();for(let i of activeIdleTimeouts)if(i._CheckTimeout(nowTime)){let deadline=
i._GetDeadline();if(nextDeadline===-1||deadline<nextDeadline)nextDeadline=deadline}else activeIdleTimeouts.delete(i);if(nextDeadline!==-1){let duration=Math.max(nextDeadline-nowTime+IDLE_CHECK_TIMER_OVERSHOOT,IDLE_CHECK_MIN_INTERVAL);timerId=self.setTimeout(CheckActiveIdleTimeouts,duration)}}C3.IdleTimeout=class IdleTimeout{constructor(callback,timeoutInSeconds){this._callback=callback;this._timeout=timeoutInSeconds*1E3;this._deadline=0;this._isActive=false}Reset(){let nowTime=C3.FastGetDateNow();
this._deadline=nowTime+this._timeout;if(!this._isActive){activeIdleTimeouts.add(this);this._isActive=true}if(timerId===-1){nextDeadline=this._deadline;timerId=self.setTimeout(CheckActiveIdleTimeouts,this._timeout+IDLE_CHECK_TIMER_OVERSHOOT)}else if(this._deadline<nextDeadline&&nextDeadline>nowTime+IDLE_CHECK_MIN_INTERVAL){self.clearTimeout(timerId);nextDeadline=this._deadline;timerId=self.setTimeout(CheckActiveIdleTimeouts,this._timeout+IDLE_CHECK_TIMER_OVERSHOOT)}}_CheckTimeout(nowTime){if(nowTime>=
this._deadline){if(this._callback()){this._deadline=nowTime+this._timeout;return true}this._isActive=false;return false}return true}_GetDeadline(){return this._deadline}Cancel(){if(this._isActive){activeIdleTimeouts.delete(this);this._isActive=false;if(activeIdleTimeouts.size===0&&timerId!==-1){self.clearTimeout(timerId);timerId=-1;nextDeadline=-1}}}Release(){this.Cancel();this._callback=null}}};


// ../lib/util/disposable.js
'use strict';{const C3=self.C3;C3.Disposable=class Disposable{constructor(disposeAction){this._disposed=false;this._disposeAction=disposeAction}Dispose(){if(this._disposed)return;this._disposed=true;if(this._disposeAction){this._disposeAction();this._disposeAction=null}}IsDisposed(){return this._disposed}Release(){this.Dispose()}static Release(instance){return new Disposable(()=>instance.Release())}static From(eventDispatcher,eventNames,eventHandler,opts,scope){if(typeof opts==="undefined"||opts===
null)opts=false;else if(typeof opts!=="boolean"&&typeof opts!=="object")throw new TypeError("invalid event listener options");if(scope)eventHandler=eventHandler.bind(scope);if(eventNames.includes(" ")){eventNames=eventNames.split(" ");const disposable=new C3.CompositeDisposable;for(let eventName of eventNames){eventDispatcher.addEventListener(eventName,eventHandler,opts);disposable.Add(C3.New(C3.Disposable,()=>eventDispatcher.removeEventListener(eventName,eventHandler,opts)))}return disposable}else{eventDispatcher.addEventListener(eventNames,
eventHandler,opts);return C3.New(C3.Disposable,()=>eventDispatcher.removeEventListener(eventNames,eventHandler,opts))}}};C3.StubDisposable=class StubDisposable extends C3.Disposable{SetAction(disposeAction){this._disposeAction=disposeAction}};C3.CompositeDisposable=class CompositeDisposable extends C3.Disposable{constructor(...disposables){super();this._disposables=new Set;for(let disposable of disposables)this.Add(disposable)}Add(...disposables){if(this._disposed)throw new Error("already disposed");
for(let disposable of disposables)this._disposables.add(disposable)}Remove(disposable){if(this._disposed)throw new Error("already disposed");this._disposables.delete(disposable)}RemoveAll(){if(this._disposed)throw new Error("already disposed");if(!this._disposables)return;for(let disposable of this._disposables)disposable.Dispose();this._disposables.clear()}IsDisposed(){return this._disposed}Dispose(){if(this._disposed)throw new Error("already disposed");this._disposed=true;for(let disposable of this._disposables)disposable.Dispose();
this._disposables.clear();this._disposables=null}Release(){this.Dispose()}}};


// c3/lib/util/kahanSum.js
'use strict';{const C3=self.C3;C3.KahanSum=class KahanSum extends C3.DefendedBase{constructor(){super();this._c=0;this._y=0;this._t=0;this._sum=0}Add(v){v=+v;this._y=v-this._c;this._t=this._sum+this._y;this._c=this._t-this._sum-this._y;this._sum=this._t}Subtract(v){this._sum-=+v}Get(){return this._sum}Reset(){this._c=0;this._y=0;this._t=0;this._sum=0}Set(s){this._c=0;this._y=0;this._t=0;this._sum=+s}Release(){}}};


// c3/lib/util/redblackset.js
'use strict';{const C3=self.C3;const js_cols={};const RED=true;const BLACK=false;js_cols.RBnode=function(tree){this.tree=tree;this.right=this.tree.sentinel;this.left=this.tree.sentinel;this.parent=null;this.color=false;this.key=null};js_cols.RedBlackSet=function(compare_func){this.size=0;this.sentinel=new js_cols.RBnode(this);this.sentinel.color=BLACK;this.root=this.sentinel;this.root.parent=this.sentinel;this.compare=compare_func||this.default_compare};js_cols.RedBlackSet.prototype.default_compare=
function(a,b){if(a<b)return-1;else if(b<a)return 1;else return 0};js_cols.RedBlackSet.prototype.clone=function(){var rv=new js_cols.RedBlackSet(this.compare);rv.insertAll(this);return rv};js_cols.RedBlackSet.prototype.clear=function(){this.size=0;this.sentinel=new js_cols.RBnode(this);this.sentinel.color=BLACK;this.root=this.sentinel;this.root.parent=this.sentinel};js_cols.RedBlackSet.prototype.leftRotate=function(x){var y=x.right;x.right=y.left;if(y.left!=this.sentinel)y.left.parent=x;y.parent=x.parent;
if(x.parent==this.sentinel)this.root=y;else if(x==x.parent.left)x.parent.left=y;else x.parent.right=y;y.left=x;x.parent=y};js_cols.RedBlackSet.prototype.rightRotate=function(x){var y=x.left;x.left=y.right;if(y.right!=this.sentinel)y.right.parent=x;y.parent=x.parent;if(x.parent==this.sentinel)this.root=y;else if(x==x.parent.right)x.parent.right=y;else x.parent.left=y;y.right=x;x.parent=y};js_cols.RedBlackSet.prototype.insert=function(key){if(!this.contains(key)){var z=new js_cols.RBnode(this);z.key=
key;var y=this.sentinel;var x=this.root;while(x!=this.sentinel){y=x;if(this.compare(z.key,x.key)<0)x=x.left;else x=x.right}z.parent=y;if(y==this.sentinel)this.root=z;else if(this.compare(z.key,y.key)<0)y.left=z;else y.right=z;z.left=this.sentinel;z.right=this.sentinel;z.color=RED;this.insertFixup(z);this.size++}else{var node=this.get_(key);node.key=key}};js_cols.RedBlackSet.prototype.insertFixup=function(z){while(z!=this.sentinel&&z!=this.root&&z.parent.color==RED)if(z.parent==z.parent.parent.left){var y=
z.parent.parent.right;if(y.color==RED){z.parent.color=BLACK;y.color=BLACK;z.parent.parent.color=RED;z=z.parent.parent}else{if(z==z.parent.right){z=z.parent;this.leftRotate(z)}z.parent.color=BLACK;z.parent.parent.color=RED;if(z.parent.parent!=this.sentinel)this.rightRotate(z.parent.parent)}}else{var y=z.parent.parent.left;if(y.color==RED){z.parent.color=BLACK;y.color=BLACK;z.parent.parent.color=RED;z=z.parent.parent}else{if(z==z.parent.left){z=z.parent;this.rightRotate(z)}z.parent.color=BLACK;z.parent.parent.color=
RED;if(z.parent.parent!=this.sentinel)this.leftRotate(z.parent.parent)}}this.root.color=BLACK};js_cols.RedBlackSet.prototype.delete_=function(z){var y;var x;if(z.left==this.sentinel||z.right==this.sentinel)y=z;else y=this.successor_(z);if(y.left!=this.sentinel)x=y.left;else x=y.right;x.parent=y.parent;if(y.parent==this.sentinel)this.root=x;else if(y==y.parent.left)y.parent.left=x;else y.parent.right=x;if(y!=z)z.key=y.key;if(y.color==BLACK)this.deleteFixup(x);this.size--};js_cols.RedBlackSet.prototype.deleteFixup=
function(x){while(x!=this.root&&x.color==BLACK)if(x==x.parent.left){var w=x.parent.right;if(w.color==RED){w.color=BLACK;x.parent.color=RED;this.leftRotate(x.parent);w=x.parent.right}if(w.left.color==BLACK&&w.right.color==BLACK){w.color=RED;x=x.parent}else{if(w.right.color==BLACK){w.left.color=BLACK;w.color=RED;this.rightRotate(w);w=x.parent.right}w.color=x.parent.color;x.parent.color=BLACK;w.right.color=BLACK;this.leftRotate(x.parent);x=this.root}}else{var w=x.parent.left;if(w.color==RED){w.color=
BLACK;x.parent.color=RED;this.rightRotate(x.parent);w=x.parent.left}if(w.right.color==BLACK&&w.left.color==BLACK){w.color=RED;x=x.parent}else{if(w.left.color==BLACK){w.right.color=BLACK;w.color=RED;this.leftRotate(w);w=x.parent.left}w.color=x.parent.color;x.parent.color=BLACK;w.left.color=BLACK;this.rightRotate(x.parent);x=this.root}}x.color=BLACK};js_cols.RedBlackSet.prototype.remove=function(key){var x=this.get_(key);if(x!=this.sentinel){var retval=x.key;this.delete_(x);return retval}else return null};
js_cols.RedBlackSet.prototype.removeSwapped=function(value,key){this.remove(key)};js_cols.RedBlackSet.prototype.min=function(x){while(x.left!=this.sentinel)x=x.left;return x};js_cols.RedBlackSet.prototype.max=function(x){while(x.right!=this.sentinel)x=x.right;return x};js_cols.RedBlackSet.prototype.successor_=function(x){if(x.right!=this.sentinel)return this.min(x.right);var y=x.parent;while(y!=this.sentinel&&x==y.right){x=y;y=y.parent}return y};js_cols.RedBlackSet.prototype.predeccessor_=function(x){if(x.left!=
this.sentinel)return this.max(x.left);var y=x.parent;while(y!=this.sentinel&&x==y.left){x=y;y=y.parent}return y};js_cols.RedBlackSet.prototype.successor=function(key){if(this.size>0){var x=this.get_(key);if(x==this.sentinel)return null;if(x.right!=this.sentinel)return this.min(x.right).key;var y=x.parent;while(y!=this.sentinel&&x==y.right){x=y;y=y.parent}if(y!=this.sentinel)return y.key;else return null}else return null};js_cols.RedBlackSet.prototype.predecessor=function(key){if(this.size>0){var x=
this.get_(key);if(x==this.sentinel)return null;if(x.left!=this.sentinel)return this.max(x.left).key;var y=x.parent;while(y!=this.sentinel&&x==y.left){x=y;y=y.parent}if(y!=this.sentinel)return y.key;else return null}else return null};js_cols.RedBlackSet.prototype.getMin=function(){return this.min(this.root).key};js_cols.RedBlackSet.prototype.getMax=function(){return this.max(this.root).key};js_cols.RedBlackSet.prototype.get_=function(key){var x=this.root;while(x!=this.sentinel&&this.compare(x.key,
key)!=0)if(this.compare(key,x.key)<0)x=x.left;else x=x.right;return x};js_cols.RedBlackSet.prototype.contains=function(key){return this.get_(key).key!=null};js_cols.RedBlackSet.prototype.getValues=function(){var ret=[];this.forEach(function(x){ret.push(x)});return ret};js_cols.RedBlackSet.prototype.insertAll=function(col){if(js_cols.typeOf(col)=="array")for(var i=0;i<col.length;i++)this.insert(col[i]);else if(js_cols.typeOf(col.forEach)=="function")col.forEach(this.insert,this);else if(js_cols.typeOf(col.getValues)==
"function"){var arr=col.getValues();for(var i=0;i<arr.length;i++)this.insert(arr[i])}else if(js_cols.typeOf(col)=="object")for(var key in col)this.insert(col[key])};js_cols.RedBlackSet.prototype.removeAll=function(col){if(js_cols.typeOf(col)=="array")for(var i=0;i<col.length;i++)this.remove(col[i]);else if(js_cols.typeOf(col.forEach)=="function")col.forEach(this.removeSwapped,this);else if(js_cols.typeOf(col.getValues)=="function"){var arr=col.getValues();for(var i=0;i<arr.length;i++)this.remove(arr[i])}else if(js_cols.typeOf(col)==
"object")for(var key in col)this.remove(col[key])};js_cols.RedBlackSet.prototype.containsAll=function(col){if(js_cols.typeOf(col)=="array"){for(var i=0;i<col.length;i++)if(!this.contains(col[i]))return false;return true}else if(js_cols.typeOf(col.forEach)=="function")return col.every(this.contains,this);else if(js_cols.typeOf(col.getValues)=="function"){var arr=col.getValues();for(var i=0;i<arr.length;i++)if(!this.contains(arr[i]))return false;return true}else if(js_cols.typeOf(col)=="object"){for(var key in col)if(!this.contains(col[key]))return false;
return true}};js_cols.RedBlackSet.prototype.range=function(from,to){var retArray=[];this.traverseFromTo(function(x){retArray.push(x)},from,to);return retArray};js_cols.RedBlackSet.prototype.traverse=function(f,opt_obj){if(this.isEmpty())return;var node=this.min(this.root);while(node!=this.sentinel){if(f.call(opt_obj,node.key,this))return;node=this.successor_(node)}};js_cols.RedBlackSet.prototype.traverseFrom=function(f,fromKey,opt_obj){if(this.isEmpty())return;var node=this.get_(fromKey);while(node!=
this.sentinel){if(f.call(opt_obj,node.key,this))return;node=this.successor_(node)}};js_cols.RedBlackSet.prototype.traverseTo=function(f,toKey,opt_obj){if(this.isEmpty())return;var node=this.min(this.root);var toNode=this.get_(toKey);while(node!=toNode){if(f.call(opt_obj,node.key,this))return;node=this.successor_(node)}};js_cols.RedBlackSet.prototype.traverseFromTo=function(f,fromKey,toKey,opt_obj){if(this.isEmpty())return;var node=this.get_(fromKey);var toNode=this.get_(toKey);while(node!=toNode){if(f.call(opt_obj,
node.key,this))return;node=this.successor_(node)}};js_cols.RedBlackSet.prototype.traverseBackwards=function(f,opt_obj){if(this.isEmpty())return;var node=this.max(this.root);while(node!=this.sentinel){if(f.call(opt_obj,node.key,this))return;node=this.predeccessor_(node)}};js_cols.RedBlackSet.prototype.forEach=function(f,opt_obj){if(this.isEmpty())return;for(var n=this.min(this.root);n!=this.sentinel;n=this.successor_(n))f.call(opt_obj,n.key,n.key,this)};js_cols.RedBlackSet.prototype.some=function(f,
opt_obj){if(this.isEmpty())return false;for(var n=this.min(this.root);n!=this.sentinel;n=this.successor_(n))if(f.call(opt_obj,n.key,n.key,this))return true;return false};js_cols.RedBlackSet.prototype.every=function(f,opt_obj){if(this.isEmpty())return false;for(var n=this.min(this.root);n!=this.sentinel;n=this.successor_(n))if(!f.call(opt_obj,n.key,n.key,this))return false;return true};js_cols.RedBlackSet.prototype.map=function(f,opt_obj){var rv=[];if(this.isEmpty())return rv;for(var n=this.min(this.root);n!=
this.sentinel;n=this.successor_(n))rv.push(f.call(opt_obj,n.key,n.key,this));return rv};js_cols.RedBlackSet.prototype.filter=function(f,opt_obj){var rv=[];if(this.isEmpty())return rv;for(var n=this.min(this.root);n!=this.sentinel;n=this.successor_(n))if(f.call(opt_obj,n.key,n.key,this))rv.push(n.key);return rv};js_cols.RedBlackSet.prototype.getCount=function(){return this.size};js_cols.RedBlackSet.prototype.isEmpty=function(){return this.size==0};js_cols.RedBlackSet.prototype.isSubsetOf=function(col){var colCount=
js_cols.getCount(col);if(this.getCount()>colCount)return false;var i=0;if(this.isEmpty())return true;for(var n=this.min(this.root);n!=this.sentinel;n=this.successor_(n))if(js_cols.contains.call(col,col,n.key))i++;return i==this.getCount()};js_cols.RedBlackSet.prototype.intersection=function(col){var result=new js_cols.RedBlackSet(this.compare);if(this.isEmpty())return result;for(var n=this.min(this.root);n!=this.sentinel;n=this.successor_(n))if(col.contains.call(col,n.key,n.key,this))result.insert(n.key);
return result};C3.RedBlackSet=class RedBlackSet extends C3.DefendedBase{constructor(sortFunc){super();this._rbSet=new js_cols.RedBlackSet(sortFunc);this._enableQueue=false;this._queueInsert=new Set;this._queueRemove=new Set}Add(item){if(this._enableQueue)if(this._rbSet.contains(item))this._queueRemove.delete(item);else this._queueInsert.add(item);else this._rbSet.insert(item)}Remove(item){if(this._enableQueue)if(this._rbSet.contains(item))this._queueRemove.add(item);else this._queueInsert.delete(item);
else this._rbSet.remove(item)}Has(item){if(this._enableQueue){if(this._queueInsert.has(item))return true;return!this._queueRemove.has(item)&&this._rbSet.contains(item)}else return this._rbSet.contains(item)}Clear(){this._rbSet.clear();this._queueInsert.clear();this._queueRemove.clear()}toArray(){if(this._enableQueue)throw new Error("cannot be used in queueing mode");return this._rbSet.getValues()}GetSize(){return this._rbSet.getCount()+this._queueInsert.size-this._queueRemove.size}IsEmpty(){return this.GetSize()===
0}Front(){if(this.IsEmpty())throw new Error("empty set");if(this._enableQueue)throw new Error("cannot be used in queueing mode");const rbSet=this._rbSet;const n=rbSet.min(rbSet.root);return n.key}Shift(){if(this.IsEmpty())throw new Error("empty set");if(this._enableQueue)throw new Error("cannot be used in queueing mode");const item=this.Front();this.Remove(item);return item}SetQueueingEnabled(q){q=!!q;if(this._enableQueue===q)return;this._enableQueue=q;if(!q){for(const item of this._queueRemove)this._rbSet.remove(item);
this._queueRemove.clear();for(const item of this._queueInsert)this._rbSet.insert(item);this._queueInsert.clear()}}ForEach(func){this._rbSet.forEach(func)}*values(){if(this.IsEmpty())return;const rbSet=this._rbSet;for(let n=rbSet.min(rbSet.root);n!=rbSet.sentinel;n=rbSet.successor_(n))yield n.key}[Symbol.iterator](){return this.values()}}};


// ../lib/util/promiseThrottle.js
'use strict';{const C3=self.C3;C3.PromiseThrottle=class PromiseThrottle{constructor(maxParallel=C3.hardwareConcurrency){this._maxParallel=maxParallel;this._queue=[];this._activeCount=0}Add(func){return new Promise((resolve,reject)=>{this._queue.push({func,resolve,reject});this._MaybeStartNext()})}_FindInQueue(func){for(let i=0,len=this._queue.length;i<len;++i)if(this._queue[i].func===func)return i;return-1}RemoveAndResolve(func,value){const i=this._FindInQueue(func);if(i===-1)throw new Error("cannot find promise to resolve");
this._queue[i].resolve(value);this._queue.splice(i,1)}RemoveAndReject(func,value){const i=this._FindInQueue(func);if(i===-1)throw new Error("cannot find promise to reject");this._queue[i].reject(value);this._queue.splice(i,1)}async _MaybeStartNext(){if(!this._queue.length)return;if(this._activeCount>=this._maxParallel)return;this._activeCount++;const job=this._queue.shift();try{const result=await job.func();job.resolve(result)}catch(err){job.reject(err)}this._activeCount--;this._MaybeStartNext()}static async Batch(concurrency,
methods){const results=[];let failed=false;const execute=async _=>{let fn;while(fn=methods.pop()){if(failed)return;try{results.push(await fn())}catch(e){failed=true;throw e;}}};const promises=[];while(concurrency--)promises.push(execute());await Promise.all(promises);return results}}};


// ../lib/util/rateLimiter.js
'use strict';{const C3=self.C3;C3.RateLimiter=class RateLimiter{constructor(callback,interval,intervalOnBattery){this._callback=callback;this._interval=interval;this._intervalOnBattery=intervalOnBattery||interval*2;this._timerId=-1;this._lastCallTime=-Infinity;this._timerCallFunc=()=>this._OnTimer();this._ignoreReset=false;this._canRunImmediate=false;this._callbackArguments=null}SetCanRunImmediate(c){this._canRunImmediate=!!c}_GetInterval(){if(typeof C3.Battery!=="undefined"&&C3.Battery.IsOnBatteryPower())return this._intervalOnBattery;
else return this._interval}Call(...args){if(this._timerId!==-1)return;this._callbackArguments=args;let nowTime=C3.FastGetDateNow();let timeSinceLastCall=nowTime-this._lastCallTime;let interval=this._GetInterval();if(timeSinceLastCall>=interval&&this._canRunImmediate){this._lastCallTime=nowTime;this._RunCallback()}else this._timerId=self.setTimeout(this._timerCallFunc,Math.max(interval-timeSinceLastCall,4))}_RunCallback(){this._ignoreReset=true;const args=this._callbackArguments;this._callbackArguments=
null;if(args)this._callback(...args);else this._callback();this._ignoreReset=false}Reset(){if(this._ignoreReset)return;this._CancelTimer();this._callbackArguments=null;this._lastCallTime=C3.FastGetDateNow()}_OnTimer(){this._timerId=-1;this._lastCallTime=C3.FastGetDateNow();this._RunCallback()}_CancelTimer(){if(this._timerId!==-1){self.clearTimeout(this._timerId);this._timerId=-1}}Release(){this._CancelTimer();this._callback=null;this._callbackArguments=null;this._timerCallFunc=null}}};


// ../lib/util/svgRaster/svgRasterManager.js
'use strict';{const C3=self.C3;C3.SVGRasterManager=class SVGRasterManager{constructor(){this._images=new Map;this._allowNpotSurfaces=false;this._getBaseSizeCallback=null;this._rasterAtSizeCallback=null;this._releaseResultCallback=null;this._redrawCallback=null}SetNpotSurfaceAllowed(a){this._allowNpotSurfaces=!!a}IsNpotSurfaceAllowed(){return this._allowNpotSurfaces}SetGetBaseSizeCallback(f){this._getBaseSizeCallback=f}GetBaseSize(dataSource){if(!this._getBaseSizeCallback)throw new Error("no get base size callback set");
return this._getBaseSizeCallback(dataSource)}SetRasterAtSizeCallback(f){this._rasterAtSizeCallback=f}RasterAtSize(dataSource,context,surfaceWidth,surfaceHeight,imageWidth,imageHeight){if(!this._rasterAtSizeCallback)throw new Error("no raster at size callback set");return this._rasterAtSizeCallback(dataSource,context,surfaceWidth,surfaceHeight,imageWidth,imageHeight)}SetReleaseResultCallback(f){this._releaseResultCallback=f}ReleaseResult(rasterizedResult){if(!this._releaseResultCallback)throw new Error("no release result callback set");
this._releaseResultCallback(rasterizedResult)}SetRedrawCallback(f){this._redrawCallback=f}Redraw(){if(!this._redrawCallback)throw new Error("no redraw callback set");this._redrawCallback()}AddImage(dataSource){let ret=this._images.get(dataSource);if(!ret){ret=C3.New(C3.SVGRasterImage,this,dataSource);this._images.set(dataSource,ret)}ret.IncReference();return ret}_RemoveImage(ri){this._images.delete(ri.GetDataSource())}OnTexturesChanged(){for(const ri of this._images.values()){ri.ReleaseRasterizedResult();
ri.ForceRasterAgain()}}}};


// ../lib/util/svgRaster/svgRasterImage.js
'use strict';{const C3=self.C3;const MAX_SURFACE_SIZE=2048;C3.SVGRasterImage=class SVGRasterImage{constructor(manager,dataSource){this._manager=manager;this._dataSource=dataSource;this._refCount=0;this._baseWidth=0;this._baseHeight=0;this._getBaseSizePromise=this._manager.GetBaseSize(dataSource).then(baseSize=>{this._baseWidth=baseSize[0];this._baseHeight=baseSize[1];this._manager.Redraw()}).catch(err=>{console.error("[SVG] Error loading SVG: ",err);this._hadError=true;this._manager.Redraw()});this._rasterSurfaceWidth=
0;this._rasterSurfaceHeight=0;this._rasterImageWidth=0;this._rasterImageHeight=0;this._isRasterizing=false;this._rasterizedResult=null;this._forceRaster=false;this._hadError=false}Release(){if(this._refCount<=0)throw new Error("already released");this._refCount--;if(this._refCount===0)this._Release()}ReleaseRasterizedResult(){if(this._rasterizedResult){this._manager.ReleaseResult(this._rasterizedResult);this._rasterizedResult=null}}_Release(){this.ReleaseRasterizedResult();this._manager._RemoveImage(this);
this._manager=null}GetDataSource(){return this._dataSource}IncReference(){this._refCount++}HasReferences(){return this._refCount>0}GetRasterizedResult(){return this._rasterizedResult}ForceRasterAgain(){this._forceRaster=true}async StartRasterForSize(context,width,height){if(width===0||height===0||this._hadError)return;if(this._isRasterizing)return;let rasterSurfaceWidth=C3.nextHighestPowerOfTwo(Math.ceil(width));let rasterSurfaceHeight=C3.nextHighestPowerOfTwo(Math.ceil(height));const maxDim=Math.max(rasterSurfaceWidth,
rasterSurfaceHeight);if(maxDim>MAX_SURFACE_SIZE){const scale=MAX_SURFACE_SIZE/maxDim;width*=scale;height*=scale;rasterSurfaceWidth=Math.min(Math.ceil(rasterSurfaceWidth*scale),MAX_SURFACE_SIZE);rasterSurfaceHeight=Math.min(Math.ceil(rasterSurfaceHeight*scale),MAX_SURFACE_SIZE)}if(width<rasterSurfaceWidth&&height<rasterSurfaceHeight){const imageAspectRatio=width/height;const surfaceAspectRatio=rasterSurfaceWidth/rasterSurfaceHeight;if(surfaceAspectRatio>imageAspectRatio){width=rasterSurfaceHeight*
imageAspectRatio;height=rasterSurfaceHeight}else{width=rasterSurfaceWidth;height=rasterSurfaceWidth/imageAspectRatio}}if(this._manager.IsNpotSurfaceAllowed()){rasterSurfaceWidth=Math.ceil(width);rasterSurfaceHeight=Math.ceil(height)}if(rasterSurfaceWidth<=this._rasterSurfaceWidth&&rasterSurfaceHeight<=this._rasterSurfaceHeight&&!this._forceRaster)return;this._isRasterizing=true;this._rasterSurfaceWidth=rasterSurfaceWidth;this._rasterSurfaceHeight=rasterSurfaceHeight;const newRasterizedResult=await this._manager.RasterAtSize(this._dataSource,
context,this._rasterSurfaceWidth,this._rasterSurfaceHeight,width,height);if(!this._manager)return;this.ReleaseRasterizedResult();this._rasterizedResult=newRasterizedResult;this._rasterImageWidth=width;this._rasterImageHeight=height;this._isRasterizing=false;this._forceRaster=false;this._manager.Redraw()}WhenBaseSizeReady(){return this._getBaseSizePromise}GetBaseWidth(){return this._baseWidth}GetBaseHeight(){return this._baseHeight}GetRasterWidth(){return this._rasterImageWidth}GetRasterHeight(){return this._rasterImageHeight}HadError(){return this._hadError}}};


// ../lib/str/str.js
'use strict';{const C3=self.C3;C3.UTF8_BOM="\ufeff";const NUMERIC_CHARS=new Set([..."0123456789"]);C3.IsNumericChar=function IsNumericChar(c){return NUMERIC_CHARS.has(c)};const WHITESPACE_CHARS=new Set([..." \t\n\r\u00a0\u0085\u2000\u2001\u2002\u2003\u2004\u2005\u2006\u2007\u2008\u2009\u200a\u200b\u2028\u2029\u202f\u205f\u3000"]);C3.IsWhitespaceChar=function IsWhitespaceChar(c){return WHITESPACE_CHARS.has(c)};C3.FilterWhitespace=function FilterWhitespace(str){return[...str].filter(ch=>!C3.IsWhitespaceChar(ch)).join("")};
C3.IsStringAllWhitespace=function IsStringAllWhitespace(str){for(const ch of str)if(!C3.IsWhitespaceChar(ch))return false;return true};C3.IsUnprintableChar=function IsUnprintableChar(c){return c.length===1&&c.charCodeAt(0)<32};C3.FilterUnprintableChars=function FilterUnprintableChars(str){return[...str].filter(ch=>!C3.IsUnprintableChar(ch)).join("")};const NUMERIC_STRING_CHARS=new Set([..."0123456789.+-e"]);C3.IsStringNumber=function IsStringNumber(str){str=str.trim();if(!str.length)return false;
let firstChar=str.charAt(0);if(firstChar!=="-"&&!NUMERIC_CHARS.has(firstChar))return false;for(let ch of str)if(!NUMERIC_STRING_CHARS.has(ch))return false;return true};C3.RemoveTrailingDigits=function RemoveTrailingDigits(str){let i=str.length;while(i>0){let prev_ch=str.charAt(i-1);if(!C3.IsNumericChar(prev_ch))break;--i}return str.substr(0,i)};C3.IncrementNumberAtEndOf=function IncrementNumberAtEndOf(str){let baseStr=C3.RemoveTrailingDigits(str);let numberStr=str.substr(baseStr.length);if(numberStr)numberStr=
(parseInt(numberStr,10)+1).toString();else numberStr="2";return baseStr+numberStr};const HTML_ENTITY_MAP=new Map([["&","&amp;"],["<","&lt;"],[">","&gt;"],['"',"&quot;"],["'","&#39;"]]);function lookupHtmlEntity(s){return HTML_ENTITY_MAP.get(s)}const HTML_ENTITY_REGEX=/[&<>"']/g;C3.EscapeHTML=function EscapeHTML(str){return str.replace(HTML_ENTITY_REGEX,lookupHtmlEntity)};C3.EscapeJS=function EscapeJS(str){let ret=C3.ReplaceAll(str,"\\","\\\\");ret=C3.ReplaceAll(ret,'"','\\"');ret=C3.ReplaceAll(ret,
"\t","\\t");ret=C3.ReplaceAll(ret,"\r","");return C3.ReplaceAll(ret,"\n","\\n")};C3.EscapeXML=function EscapeXML(str){let ret=C3.ReplaceAll(str,"&","&amp;");ret=C3.ReplaceAll(ret,"<","&lt;");ret=C3.ReplaceAll(ret,">","&gt;");return C3.ReplaceAll(ret,'"',"&quot;")};const ESCAPE_REGEX=/[-[\]{}()*+?.,\\^$|#\s]/g;C3.EscapeRegex=function EscapeRegex(str){return str.replace(ESCAPE_REGEX,"\\$&")};C3.FindAll=function FindAll(str,find,matchCase=false){if(!find)return[];if(!matchCase){str=str.toLowerCase();
find=find.toLowerCase()}const findLen=find.length;let startIndex=0;let index=0;let ret=[];while((index=str.indexOf(find,startIndex))>-1){ret.push(index);startIndex=index+findLen}return ret};C3.ReplaceAll=function ReplaceAll(str,find,replace){return str.replaceAll(find,()=>replace)};C3.ReplaceAllCaseInsensitive=function ReplaceAll(str,find,replace){return str.replace(new RegExp(C3.EscapeRegex(find),"gi"),()=>replace)};C3.SetElementContent=function SetElementContent(elem,stringlike){if(typeof stringlike===
"string")elem.textContent=stringlike;else if(stringlike.isPlainText())elem.textContent=stringlike.toString();else{elem.innerHTML=stringlike.toHTML();if(stringlike instanceof C3.BBString)stringlike.attachLinkHandlers(elem)}};C3.StringLikeEquals=function StringLikeEquals(a,b){if(a instanceof C3.HtmlString||a instanceof C3.BBString)return a.equals(b);else if(b instanceof C3.HtmlString||b instanceof C3.BBString)return b.equals(a);else return a===b};C3.StringSubstitute=function StringSubstitute(str,...arr){let ret=
str;for(let i=0,len=arr.length;i<len;++i){const sub=`{${i}}`;if(!str.includes(sub))throw new Error(`missing placeholder '${sub}' in string substitution`);ret=ret.replace(sub,arr[i].toString())}return ret};C3.StringSubstituteAllowMissing=function StringSubstituteAllowMissing(str,...arr){let ret=str;let lowestMissingIndex=-1;let highestUsedIndex=-1;for(let i=0,len=arr.length;i<len;++i){const sub=`{${i}}`;if(str.includes(sub)){highestUsedIndex=i;ret=ret.replace(sub,arr[i].toString())}else if(lowestMissingIndex===
-1)lowestMissingIndex=i}if(lowestMissingIndex>=0&&highestUsedIndex>=0&&lowestMissingIndex<highestUsedIndex)throw new Error(`missing placeholder '${lowestMissingIndex}' in string substitution`);return ret};C3.StringSubstituteMap=function StringSubstituteMap(str,o){let ret=str;for(let [placeholder,substitution]of Object.entries(o))ret=ret.replaceAll(placeholder,substitution.toString());return ret};C3.SortAZCaseInsensitive=function SortAZCaseInsensitive(a,b){let lowerA=a.toLowerCase();let lowerB=b.toLowerCase();
if(lowerA>lowerB)return 1;else if(lowerA<lowerB)return-1;else return 0};const KILOBYTE=1024;const MEGABYTE=KILOBYTE*1024;const GIGABYTE=MEGABYTE*1024;const TERABYTE=GIGABYTE*1024;C3.FormatDataSize=function FormatDataSize(sizeInBytes,asRate){let rootKey="common."+(asRate?"dataRates":"dataSizes")+".";const langSub=self.langSub;if(sizeInBytes<KILOBYTE)return langSub(rootKey+"bytes",sizeInBytes);else if(sizeInBytes<MEGABYTE){let kb=sizeInBytes/KILOBYTE;if(kb<10)kb=Math.round(kb*10)/10;else kb=Math.round(kb);
return langSub(rootKey+"kilobytes",kb)}else if(sizeInBytes<GIGABYTE){let mb=sizeInBytes/MEGABYTE;if(mb<10)mb=Math.round(mb*10)/10;else mb=Math.round(mb);return langSub(rootKey+"megabytes",mb)}else if(sizeInBytes<TERABYTE){let gb=sizeInBytes/GIGABYTE;if(gb<10)gb=Math.round(gb*10)/10;else gb=Math.round(gb);return langSub(rootKey+"gigabytes",gb)}else{let tb=sizeInBytes/TERABYTE;if(tb<10)tb=Math.round(tb*10)/10;else tb=Math.round(tb);return langSub(rootKey+"terabytes",tb)}};const DEFAULT_FORMATTIME_OPTS=
{approximate:false,days:true,hours:true,minutes:true,seconds:true};C3.FormatTime=function FormatTime(secondsTotal,opts){opts=Object.assign({},DEFAULT_FORMATTIME_OPTS,opts);C3.Lang.PushContext("common.time");const parts=[];const lang=self.lang;const langPluralSub=self.langPluralSub;if(opts.days){const days=Math.floor(secondsTotal/(24*3600));if(days>0){secondsTotal-=days*24*3600;parts.push(langPluralSub(".days",null,days))}}if(opts.hours){const hours=Math.floor(secondsTotal/3600);if(hours>0||parts.length){secondsTotal-=
hours*3600;parts.push(langPluralSub(".hours",null,hours))}}if(opts.minutes){const minutes=Math.floor(secondsTotal/60);if(minutes>0||parts.length||!opts.seconds){secondsTotal-=minutes*60;parts.push(langPluralSub(".minutes",null,minutes))}}if(opts.seconds){const seconds=Math.floor(secondsTotal%60);parts.push(langPluralSub(".seconds",null,seconds))}const ret=(opts.approximate?lang(".approx-prefix"):"")+parts.join(lang(".separator"));C3.Lang.PopContext();return ret};C3.ZeroPad=function(n,d){let s=n<0?
"-":"";n=Math.abs(n);let nStr=n.toString();let zeroes=d-nStr.length;for(let i=0;i<zeroes;++i)s+="0";return s+nStr};C3.StringToTitleCase=function StringToTitleCase(str){return str.toLowerCase().replace(/\b\w/g,t=>t.toUpperCase())};C3.CompareVersionStrings=function CompareVersionStrings(v1,v2){let a1=v1.split(".").map(s=>s.trim());let a2=v2.split(".").map(s=>s.trim());C3.resizeArray(a1,4,"0");C3.resizeArray(a2,4,"0");a1=a1.map(s=>parseInt(s,10));a2=a2.map(s=>parseInt(s,10));for(let i=0;i<4;++i){const diff=
a1[i]-a2[i];if(diff!==0)return diff<0?-1:1}return 0};C3.CreateGUID=function CreateGUID(){return"xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx".replace(/[xy]/g,c=>{const r=Math.floor(Math.random()*16);const v=c==="x"?r:r&3|8;return v.toString(16)})};C3.StringHammingDistance=function StringHammingDistance(a,b){if(a.length!==b.length)throw new Error("strings must be same length");let ret=0;for(let i=0,len=a.length;i<len;++i)if(a.charAt(i)!==b.charAt(i))++ret;return ret};C3.StringLevenshteinDistance=function StringLevenshteinDistance(a,
b){if(a.length===0)return b.length;if(b.length===0)return a.length;let tmp,i,j,prev,val,row;if(a.length>b.length){tmp=a;a=b;b=tmp}row=Array(a.length+1);for(i=0;i<=a.length;i++)row[i]=i;for(i=1;i<=b.length;i++){prev=i;for(j=1;j<=a.length;j++){if(b[i-1]===a[j-1])val=row[j-1];else val=Math.min(row[j-1]+1,Math.min(prev+1,row[j]+1));row[j-1]=prev;prev=val}row[a.length]=prev}return row[a.length]}};


// ../lib/str/bbstring.js
'use strict';{const C3=self.C3;const assert=self.assert;const BB_CODE_MAP=new Map([["b","strong"],["i","em"],["s","s"],["u","u"],["sub","sub"],["sup","sup"],["small","small"],["mark","mark"],["a1","a"],["a2","a"],["a3","a"],["a4","a"],["a5","a"],["a6","a"],["a7","a"],["a8","a"],["a9","a"],["bad",["span","bbCodeBad"]],["good",["span","bbCodeGood"]],["info",["span","bbCodeInfo"]],["h1",["span","bbCodeH1"]],["h2",["span","bbCodeH2"]],["h3",["span","bbCodeH3"]],["h4",["span","bbCodeH4"]],["item",["span",
"bbCodeItem"]]]);const BBREGEX=/\[(\/?)([a-zA-Z0-9]+)\]/g;const CUSTOM_BBREGEX=/\[(\/?)([^\[]*?)\]/g;let linkActions=null;let classIndex=0;function bbToHtmlReplacerFunc(match,closeSlash,tagName){const entry=BB_CODE_MAP.get(tagName);if(entry)if(typeof entry==="string")if(entry==="a"&&!closeSlash){const index=parseInt(tagName.substring(1),10)-1;if(index<0||index>=linkActions.length)throw new Error("invalid bbcode link substitution");const linkAction=linkActions[index];if(typeof linkAction==="string")return`<a href="${linkActions[index]}">`;
else if(typeof linkAction==="function")return`<a class="bblink${index}">`;else throw new TypeError("invalid bbcode link action");}else return"<"+closeSlash+entry+">";else if(Array.isArray(entry)){let tag=entry[0];let className=entry[1];if(closeSlash)return"</"+tag+">";else return`<${tag} class="${className}">`}else;else if(tagName==="class")if(closeSlash)return"</span>";else return`<span class="bbclass${classIndex++}">`;else return match}const LINEBREAK_REGEX=/\n/g;C3.BBString=class BBString{constructor(str,
opts){this._bbstr=opts&&opts.noEscape?str:C3.EscapeHTML(str);this._htmlstr="";this._convertLineBreaks=false;this._linkActions=[];if(opts){this._convertLineBreaks=!!opts.convertLineBreaks;if(opts.links){if(opts.links.length>9)throw new Error("too many links");this._linkActions=opts.links}}this._hasAnyBBtags=this._bbstr.includes("[");this._needsLineBreakConversion=this._convertLineBreaks&&this._bbstr.includes("\n");this._isPlain=!this._hasAnyBBtags&&!this._needsLineBreakConversion&&!this._bbstr.includes("&");
this._hasParsedFragments=false;this._fragments=[]}toString(){return this._bbstr}valueOf(){return this._bbstr}isPlainText(){return this._isPlain}toPlainText(){if(this._hasAnyBBtags)return this._bbstr.replace(BBREGEX,"");else return this._bbstr}toHTML(){if(this._isPlain)return this._bbstr;if(!this._htmlstr&&this._bbstr){let str=this._bbstr;if(this._hasAnyBBtags){classIndex=0;linkActions=this._linkActions;str=str.replace(BBREGEX,bbToHtmlReplacerFunc);linkActions=null}if(this._needsLineBreakConversion)str=
str.replace(LINEBREAK_REGEX,"<br>");this._htmlstr=str}return this._htmlstr}attachLinkHandlers(parentElem){if(!this._linkActions.length)return;for(let i=0,len=this._linkActions.length;i<len;++i){const linkAction=this._linkActions[i];if(typeof linkAction!=="function")continue;const linkElem=parentElem.querySelector(".bblink"+i);if(!linkElem)throw new Error("unable to attach BBString link handler");linkElem.onclick=linkAction}}equals(s){if(s instanceof C3.HtmlString)return this.toHTML()===s.toHTML();
else if(s instanceof C3.BBString)return this._bbstr===s._bbstr;else return this._bbstr===s}toFragmentList(){if(this._hasParsedFragments)return this._fragments;const bbStr=this._bbstr;const styleStack=[];CUSTOM_BBREGEX.lastIndex=0;let prevIndex=0;let result=null;while((result=CUSTOM_BBREGEX.exec(bbStr))!==null){const index=result.index;if(index>0&&bbStr.charAt(index-1)==="\\")continue;const matchStr=result[0];const closeSlash=result[1];const tagName=result[2];const strFrag=bbStr.substring(prevIndex,
index);prevIndex=index+matchStr.length;if(strFrag)this._fragments.push({text:strFrag,styles:styleStack.slice(0)});if(!tagName)continue;if(closeSlash){const lowerTagName=tagName.toLowerCase();for(let i=styleStack.length-1;i>=0;--i)if(styleStack[i].tag===lowerTagName){styleStack.splice(i,1);break}}else{let tag=tagName;let param=null;const eq=tagName.indexOf("=");if(eq!==-1){tag=tagName.substring(0,eq).toLowerCase();param=tagName.substring(eq+1)}else tag=tag.toLowerCase();styleStack.push({tag,param})}}if(prevIndex<
bbStr.length)this._fragments.push({text:bbStr.substring(prevIndex),styles:styleStack.slice(0)});for(const frag of this._fragments)frag.text=this._ProcessBBCodeEscapeSequences(frag.text);this._hasParsedFragments=true;return this._fragments}_ProcessBBCodeEscapeSequences(text){text=C3.ReplaceAll(text,"\\[","[");return C3.ReplaceAll(text,"\\\\","\\")}static StripTags(str){return C3.New(C3.BBString,str,{noEscape:true}).toPlainText()}static StripAnyTags(str){return str.replace(CUSTOM_BBREGEX,"")}}};


// ../lib/str/wordWrap.js
'use strict';{const C3=self.C3;C3.WordWrap=class WordWrap{constructor(){this._lines=[]}GetLines(){return this._lines}GetLineCount(){return this._lines.length}_MeasureLine(line,measureFunc){let width=0;let height=0;let fbbAscent=0;let fbbDescent=0;let topToAlphabeticDistance=0;for(const frag of line){if(frag.width===-1){const m=measureFunc(frag.text,frag.styles);frag.width=m.width;frag.height=m.height;frag.fontBoundingBoxAscent=m.fontBoundingBoxAscent||0;frag.fontBoundingBoxDescent=m.fontBoundingBoxDescent||
0;frag.topToAlphabeticDistance=m.topToAlphabeticDistance||0}width+=frag.width;height=Math.max(height,frag.height);fbbAscent=Math.max(fbbAscent,frag.fontBoundingBoxAscent);fbbDescent=Math.max(fbbDescent,frag.fontBoundingBoxDescent);topToAlphabeticDistance=Math.max(topToAlphabeticDistance,frag.topToAlphabeticDistance)}return{width,height,fontBoundingBoxAscent:fbbAscent,fontBoundingBoxDescent:fbbDescent,topToAlphabeticDistance}}_AddLine(fragments,width,height,fbbAscent,fbbDescent,topToAlphabeticDistance){this._lines.push({fragments,
width,height,fontBoundingBoxAscent:fbbAscent,fontBoundingBoxDescent:fbbDescent,topToAlphabeticDistance})}WordWrap(fragmentArr,measureFunc,wrapWidth,wrapMode,endOfLineMargin){if(typeof fragmentArr==="string")fragmentArr=[{text:fragmentArr,styles:[]}];C3.clearArray(this._lines);if(!fragmentArr.length||fragmentArr.length===1&&!fragmentArr[0].text.length||wrapWidth<2)return;if(fragmentArr.length===1){const frag=fragmentArr[0];const text=frag.text;const styles=frag.styles;if(text.length<=100&&!text.includes("\n")){let {width,
height,fontBoundingBoxAscent,fontBoundingBoxDescent,topToAlphabeticDistance}=measureFunc(text,styles);width+=endOfLineMargin;fontBoundingBoxAscent=fontBoundingBoxAscent||0;fontBoundingBoxDescent=fontBoundingBoxDescent||0;topToAlphabeticDistance=topToAlphabeticDistance||0;if(width<=wrapWidth){this._AddLine([{text,styles,width,height,fontBoundingBoxAscent,fontBoundingBoxDescent,topToAlphabeticDistance}],width,height,fontBoundingBoxAscent,fontBoundingBoxDescent,topToAlphabeticDistance);return}}}let tokenisedFragments;
if(wrapMode==="word")tokenisedFragments=this._TokeniseWords(fragmentArr);else{tokenisedFragments=[];for(const frag of fragmentArr)C3.appendArray(tokenisedFragments,[...frag.text].map(ch=>[{text:ch,styles:frag.styles}]))}this._WrapText(tokenisedFragments,measureFunc,wrapWidth,endOfLineMargin)}_TokeniseWords(fragmentArr){const ret=[];let curWord=[];let isCurWhitespace=false;for(const frag of fragmentArr){const text=frag.text;const styles=frag.styles;for(const ch of text)if(ch==="\n"){if(curWord.length>
0)ret.push(curWord);ret.push([{text:"\n",styles}]);curWord=[]}else if(curWord.length===0){curWord.push({text:ch,styles});isCurWhitespace=C3.IsWhitespaceChar(ch)}else{const isWhitespace=C3.IsWhitespaceChar(ch);if(isWhitespace===isCurWhitespace){const curFrag=curWord[curWord.length-1];if(curFrag.styles===styles)curFrag.text+=ch;else curWord.push({text:ch,styles})}else{ret.push(curWord);curWord=[];curWord.push({text:ch,styles});isCurWhitespace=isWhitespace}}}if(curWord.length>0)ret.push(curWord);return ret}_CopyLine(line){return line.map(f=>
({text:f.text,styles:f.styles,width:f.width,height:f.height,fontBoundingBoxAscent:f.fontBoundingBoxAscent,fontBoundingBoxDescent:f.fontBoundingBoxDescent,topToAlphabeticDistance:f.topToAlphabeticDistance}))}_AddWordToLine(currentLine,curWord){const lastFrag=currentLine.length?currentLine[currentLine.length-1]:null;let i=0;if(lastFrag&&curWord[0].styles===lastFrag.styles){lastFrag.text+=curWord[0].text;lastFrag.width=-1;lastFrag.height=-1;lastFrag.fontBoundingBoxAscent=-1;lastFrag.fontBoundingBoxDescent=
-1;lastFrag.topToAlphabeticDistance=-1;i=1}for(let len=curWord.length;i<len;++i){const f=curWord[i];currentLine.push({text:f.text,styles:f.styles,width:-1,height:-1,fontBoundingBoxAscent:-1,fontBoundingBoxDescent:-1,topToAlphabeticDistance:-1})}}_WrapText(tokenisedFragments,measureFunc,wrapWidth,endOfLineMargin){let currentLine=[];let currentLineWidth=0;let currentLineHeight=0;let currentLineFbbAscent=0;let currentLineFbbDescent=0;let currentLineTopToAlphabetic=0;for(const curWord of tokenisedFragments){if(curWord.length===
1&&curWord[0].text==="\n"){if(currentLineHeight===0){const m=measureFunc(" ",curWord[0].styles);currentLineHeight=m.height;currentLineFbbAscent=m.fontBoundingBoxAscent||0;currentLineFbbDescent=m.fontBoundingBoxDescent||0;currentLineTopToAlphabetic=m.topToAlphabeticDistance||0}this._AddLine(currentLine,currentLineWidth,currentLineHeight,currentLineFbbAscent,currentLineFbbDescent,currentLineTopToAlphabetic);currentLine=[];currentLineWidth=0;currentLineHeight=0;currentLineFbbAscent=0;currentLineFbbDescent=
0;currentLineTopToAlphabetic=0;continue}const tryLine=this._CopyLine(currentLine);this._AddWordToLine(tryLine,curWord);const tryMetrics=this._MeasureLine(tryLine,measureFunc);const tryLineWidth=tryMetrics.width;if(tryLineWidth>=wrapWidth){if(currentLine.length>0)this._AddLine(currentLine,currentLineWidth,currentLineHeight,currentLineFbbAscent,currentLineFbbDescent,currentLineTopToAlphabetic);currentLine=[];if(C3.IsStringAllWhitespace(curWord[0].text)){currentLineWidth=0;currentLineHeight=0;currentLineFbbAscent=
0;currentLineFbbDescent=0;currentLineTopToAlphabetic=0}else{this._AddWordToLine(currentLine,curWord);const metrics=this._MeasureLine(currentLine,measureFunc);currentLineWidth=metrics.width;currentLineHeight=metrics.height;currentLineFbbAscent=metrics.fontBoundingBoxAscent;currentLineFbbDescent=metrics.fontBoundingBoxDescent;currentLineTopToAlphabetic=metrics.topToAlphabeticDistance}}else{currentLine=tryLine;currentLineWidth=tryLineWidth;currentLineHeight=tryMetrics.height;currentLineFbbAscent=tryMetrics.fontBoundingBoxAscent;
currentLineFbbDescent=tryMetrics.fontBoundingBoxDescent;currentLineTopToAlphabetic=tryMetrics.topToAlphabeticDistance}}if(currentLine.length>0)this._AddLine(currentLine,currentLineWidth,currentLineHeight,currentLineFbbAscent,currentLineFbbDescent,currentLineTopToAlphabetic);this._TrimLinesTrailingWhitespace(measureFunc,endOfLineMargin)}_TrimLinesTrailingWhitespace(measureFunc,endOfLineMargin){for(const line of this._lines){const fragments=line.fragments;if(!fragments.length)continue;let lastFrag=
fragments[fragments.length-1];const text=lastFrag.text;const trimmedText=text.trimEnd();if(!trimmedText){line.width-=lastFrag.width;fragments.pop()}else if(trimmedText.length<text.length){const trimmedWidth=measureFunc(trimmedText,lastFrag.styles).width;const diff=lastFrag.width-trimmedWidth;lastFrag.width=trimmedWidth;lastFrag.text=trimmedText;line.width-=diff}if(endOfLineMargin!==0&&fragments.length>0){lastFrag=fragments[fragments.length-1];lastFrag.width+=endOfLineMargin;line.width+=endOfLineMargin}}}Clear(){C3.clearArray(this._lines)}GetMaxLineWidth(){return this._lines.reduce((a,
v)=>Math.max(a,v.width),0)}GetTotalLineHeight(){return this._lines.reduce((a,v)=>a+v.height,0)}}};


// ../lib/gfx/gfx.js
'use strict';{self.C3.Gfx={AreMat4sEqual(a,b){return a[0]===b[0]&&a[1]===b[1]&&a[2]===b[2]&&a[3]===b[3]&&a[4]===b[4]&&a[5]===b[5]&&a[6]===b[6]&&a[7]===b[7]&&a[8]===b[8]&&a[9]===b[9]&&a[10]===b[10]&&a[11]===b[11]&&a[12]===b[12]&&a[13]===b[13]&&a[14]===b[14]&&a[15]===b[15]}}};


// ../lib/gfx/rendererBase.js
'use strict';{const C3=self.C3;const PERSPECTIVE_NEAR_Z=1;const PERSPECTIVE_FAR_Z=1E4;const fTempo=[0,0,0,0,0,0,0,0];const glMatrix=self.glMatrix;const vec3=glMatrix.vec3;const mat4=glMatrix.mat4;const tmpVec3=vec3.fromValues(0,0,0);const defaultTexCoordsQuad=new C3.Quad(0,0,1,0,1,1,0,1);C3.Gfx.RendererBase=class RendererBase{constructor(){this._width=0;this._height=0;this._cam=vec3.fromValues(0,0,100);this._look=vec3.fromValues(0,0,0);this._up=vec3.fromValues(0,1,0);this._worldScale=vec3.fromValues(1,
1,1);this._matP=mat4.create();this._matMV=mat4.create();this._lastMV=mat4.create();this._allShaderPrograms=[];this._shaderProgramsByName=new Map;this._spTextureFill=null;this._spPoints=null;this._spTilemapFill=null;this._spColorFill=null;this._spLinearGradientFill=null;this._spHardEllipseFill=null;this._spHardEllipseOutline=null;this._spSmoothEllipseFill=null;this._spSmoothEllipseOutline=null;this._spSmoothLineFill=null;this._stateGroups=new Map;this._currentStateGroup=null;this._blendModeTable=[];
this._namedBlendModeMap=new Map;this._baseZ=0;this._currentZ=0;this._frameNumber=0;this._enableMipmaps=true}FillIndexBufferData(indexData){let i=0,len=indexData.length,fv=0;while(i<len){indexData[i++]=fv;indexData[i++]=fv+1;indexData[i++]=fv+2;indexData[i++]=fv;indexData[i++]=fv+2;indexData[i++]=fv+3;fv+=4}}_ClearState(){this._baseZ=0;this._currentZ=0;this._spTextureFill=null;this._spPoints=null;this._spTilemapFill=null;this._spColorFill=null;this._spLinearGradientFill=null;this._spHardEllipseFill=
null;this._spHardEllipseOutline=null;this._spSmoothEllipseFill=null;this._spSmoothEllipseOutline=null;this._spSmoothLineFill=null;this._ClearAllShaderPrograms()}InitState(){this._ClearState();this._currentStateGroup=null}OnDeviceOrContextLost(){for(const s of this._allShaderPrograms)s.Release();this._ClearState()}Project(x,y,w,h,out){const mv=this._matMV;const proj=this._matP;for(let i=0,len=fTempo.length;i<len;++i)fTempo[i]=0;fTempo[0]=mv[0]*x+mv[4]*y+mv[12];fTempo[1]=mv[1]*x+mv[5]*y+mv[13];fTempo[2]=
mv[2]*x+mv[6]*y+mv[14];fTempo[3]=mv[3]*x+mv[7]*y+mv[15];fTempo[4]=proj[0]*fTempo[0]+proj[4]*fTempo[1]+proj[8]*fTempo[2]+proj[12]*fTempo[3];fTempo[5]=proj[1]*fTempo[0]+proj[5]*fTempo[1]+proj[9]*fTempo[2]+proj[13]*fTempo[3];fTempo[6]=proj[2]*fTempo[0]+proj[6]*fTempo[1]+proj[10]*fTempo[2]+proj[14]*fTempo[3];fTempo[7]=-fTempo[2];if(fTempo[7]===0)return;fTempo[7]=1/fTempo[7];fTempo[4]*=fTempo[7];fTempo[5]*=fTempo[7];fTempo[6]*=fTempo[7];out[0]=(fTempo[4]*.5+.5)*w;out[1]=(fTempo[5]*.5+.5)*h}GetWidth(){return this._width}GetHeight(){return this._height}GetNearZ(){return PERSPECTIVE_NEAR_Z}GetFarZ(){return PERSPECTIVE_FAR_Z}SetCameraXYZ(x,
y,z){this._cam[0]=x*this._worldScale[0];this._cam[1]=y*this._worldScale[1];this._cam[2]=z}SetLookXYZ(x,y,z){this._look[0]=x*this._worldScale[0];this._look[1]=y*this._worldScale[1];this._look[2]=z}ResetModelView(alternateUpVector){mat4.lookAt(this._matMV,this._cam,this._look,alternateUpVector||this._up);mat4.scale(this._matMV,this._matMV,this._worldScale)}Translate(x,y){if(x===0&&y===0)return;tmpVec3[0]=x;tmpVec3[1]=y;tmpVec3[2]=0;mat4.translate(this._matMV,this._matMV,tmpVec3)}Scale(x,y){if(x===1&&
y===1)return;tmpVec3[0]=x;tmpVec3[1]=y;tmpVec3[2]=1;mat4.scale(this._matMV,this._matMV,tmpVec3)}RotateZ(a){if(a===0)return;mat4.rotateZ(this._matMV,this._matMV,a)}_AddShaderProgram(sp){this._allShaderPrograms.push(sp);this._shaderProgramsByName.set(sp.GetName(),sp)}_RemoveShaderProgram(sp){const i=this._allShaderPrograms.indexOf(sp);if(i!==-1)this._allShaderPrograms.splice(i,1);this._shaderProgramsByName.delete(sp.GetName())}_ClearAllShaderPrograms(){C3.clearArray(this._allShaderPrograms);this._shaderProgramsByName.clear()}GetShaderProgramByName(name){return this._shaderProgramsByName.get(name)||
null}GetTextureFillShaderProgram(){return this._spTextureFill}SetTextureFillMode(){this.SetProgram(this._spTextureFill)}GetPointsRenderingProgram(){return this._spPoints}SetPointsRenderingProgram(){this.SetProgram(this._spPoints)}SetTilemapFillMode(){this.SetProgram(this._spTilemapFill)}SetColorFillMode(){this.SetProgram(this._spColorFill)}SetLinearGradientFillMode(){this.SetProgram(this._spLinearGradientFill)}SetHardEllipseFillMode(){this.SetProgram(this._spHardEllipseFill)}SetHardEllipseOutlineMode(){this.SetProgram(this._spHardEllipseOutline)}SetSmoothEllipseFillMode(){this.SetProgram(this._spSmoothEllipseFill)}SetSmoothEllipseOutlineMode(){this.SetProgram(this._spSmoothEllipseOutline)}SetSmoothLineFillMode(){this.SetProgram(this._spSmoothLineFill)}_SetCurrentStateGroup(sg){this._currentStateGroup=
sg}GetCurrentStateGroup(){return this._currentStateGroup}AcquireStateGroup(shaderProgram_or_name,blendMode,color,zElevation){const key=C3.Gfx.StateGroup.MakeKey(shaderProgram_or_name,blendMode,color,zElevation);let stateGroup=this._stateGroups.get(key);if(!stateGroup){stateGroup=C3.New(C3.Gfx.StateGroup,this,shaderProgram_or_name,blendMode,color,zElevation);this._stateGroups.set(key,stateGroup)}stateGroup.AddRef();return stateGroup}ReleaseStateGroup(stateGroup){stateGroup.DecRef();if(stateGroup._GetRefCount()===
0){if(this._currentStateGroup===stateGroup)this._currentStateGroup=null;this._stateGroups.delete(stateGroup.GetKey());stateGroup.Release()}}_InitBlendModeData(blendModeData){C3.clearArray(this._blendModeTable);this._namedBlendModeMap.clear();for(const bmd of blendModeData){const name=bmd[0];const srcBlend=bmd[1];const destBlend=bmd[2];this._blendModeTable.push([srcBlend,destBlend]);this._namedBlendModeMap.set(name,{srcBlend,destBlend})}}_GetBlendByIndex(blendIndex){return this._blendModeTable[blendIndex]}GetSrcBlendByIndex(blendIndex){return this._GetBlendByIndex(blendIndex)[0]}GetDestBlendByIndex(blendIndex){return this._GetBlendByIndex(blendIndex)[1]}GetNamedBlend(blendName){const ret=
this._namedBlendModeMap.get(blendName);if(typeof ret==="undefined")throw new Error("invalid blend name");return ret}SetBaseZ(z){this._baseZ=z}GetBaseZ(){return this._baseZ}SetCurrentZ(z){this._currentZ=z;this._currentStateGroup=null}GetCurrentZ(){return this._currentZ}ClearRect(x,y,w,h){this.ClearRect4(x,y,w,h,0,0,0,0)}ClearRect2(rc){this.ClearRect4(rc.getLeft(),rc.getTop(),rc.width(),rc.height(),0,0,0,0)}ClearRect3(rc,c){this.ClearRect4(rc.getLeft(),rc.getTop(),rc.width(),rc.height(),c.getR(),c.getG(),
c.getB(),c.getA())}GetNumVertexComponents(){return 3}Finish(){this.EndBatch(true);this._frameNumber++}GetFrameNumber(){return this._frameNumber}IncrementFrameNumber(){this._frameNumber++}SetMipmapsEnabled(e){this._enableMipmaps=!!e}AreMipmapsEnabled(){return this._enableMipmaps}IsWebGL(){return false}IsWebGPU(){return false}}};


// ../lib/gfx/stateGroup.js
'use strict';{const C3=self.C3;C3.Gfx.StateGroup=class StateGroup{constructor(renderer,shaderProgram_or_name,blendMode,color,zElevation){this._renderer=renderer;this._refCount=0;this._shaderProgram=null;this._shaderProgramName="";this._blendMode=blendMode;this._color=C3.New(C3.Color);this._color.set(color);this._zElevation=zElevation;if(typeof shaderProgram_or_name==="string")this._shaderProgramName=shaderProgram_or_name;else{this._shaderProgram=shaderProgram_or_name;this._shaderProgramName=this._shaderProgram.GetName()}}Release(){if(this._refCount>
0)throw new Error("releasing state group still in use");this._renderer=null;this._shaderProgram=null;this._shaderProgramName=""}Apply(){const renderer=this._renderer;renderer.SetProgram(this._shaderProgram);renderer.SetBlendMode(this._blendMode);renderer.SetColor(this._color);renderer.SetCurrentZ(this._zElevation);renderer._SetCurrentStateGroup(this)}GetKey(){return C3.Gfx.StateGroup.MakeKey(this._shaderProgramName,this._blendMode,this._color,this._zElevation)}AddRef(){++this._refCount}DecRef(){--this._refCount}_GetRefCount(){return this._refCount}OnContextLost(){this._shaderProgram=
null}OnContextRestored(renderer){this._shaderProgram=renderer.GetShaderProgramByName(this._shaderProgramName);if(!this._shaderProgram)throw new Error("failed to restore shader program");}static MakeKey(shaderProgram_or_name,blendMode,c,zElevation){const shaderProgramName=typeof shaderProgram_or_name==="string"?shaderProgram_or_name:shaderProgram_or_name.GetName();return shaderProgramName+","+blendMode+","+c.getR()+","+c.getG()+","+c.getB()+","+c.getA()+","+zElevation}}};


// ../lib/gfx/mesh.js
'use strict';{const C3=self.C3;const tempQuadTex=C3.New(C3.Quad);function interpolateQuad(srcX,srcY,quad){const qtlx=quad.getTlx();const qtly=quad.getTly();const qtrx=quad.getTrx()-qtlx;const qtry=quad.getTry()-qtly;const qblx=quad.getBlx()-qtlx;const qbly=quad.getBly()-qtly;const xix=qtrx*srcX;const xiy=qtry*srcX;const yix=qblx*srcY;const yiy=qbly*srcY;return[qtlx+xix+yix,qtly+xiy+yiy]}C3.Gfx.MeshPoint=class MeshPoint{constructor(mesh,col,row){this._mesh=mesh;this._col=col;this._row=row;this._x=
NaN;this._y=NaN;this._zElevation=NaN;this._u=NaN;this._v=NaN;this._x=0;this._y=0;this._zElevation=0;this._u=0;this._v=0}_Init(x,y,u,v){this._x=x;this._y=y;this._u=u;this._v=v}GetX(){return this._x}SetX(x){if(this._x===x)return;this._x=x;this._mesh._SetPointsChanged()}GetY(){return this._y}SetY(y){if(this._y===y)return;this._y=y;this._mesh._SetPointsChanged()}GetZElevation(){return this._zElevation}SetZElevation(z){if(this._zElevation===z)return;this._zElevation=Math.max(z,0);this._mesh._SetPointsChanged()}GetU(){return this._u}SetU(u){this._u=
u}GetV(){return this._v}SetV(v){this._v=v}_Interpolate_TexRect(srcPoint,quadPos,rcTex){[this._x,this._y]=interpolateQuad(srcPoint._x,srcPoint._y,quadPos);this._zElevation=srcPoint._zElevation;this._u=C3.lerp(rcTex.getLeft(),rcTex.getRight(),srcPoint._u);this._v=C3.lerp(rcTex.getTop(),rcTex.getBottom(),srcPoint._v)}_Interpolate_TexQuad(srcPoint,quadPos,quadTex){[this._x,this._y]=interpolateQuad(srcPoint._x,srcPoint._y,quadPos);this._zElevation=srcPoint._zElevation;[this._u,this._v]=interpolateQuad(srcPoint._u,
srcPoint._v,quadTex)}SaveToJson(){return{"x":this.GetX(),"y":this.GetY(),"z":this.GetZElevation(),"u":this.GetU(),"v":this.GetV()}}LoadFromJson(o){this.SetX(o["x"]);this.SetY(o["y"]);if(o.hasOwnProperty("z"))this.SetZElevation(o["z"]);this.SetU(o["u"]);this.SetV(o["v"])}GetMesh(){return this._mesh}GetColumn(){return this._col}GetRow(){return this._row}};C3.Gfx.Mesh=class Mesh{constructor(hsize,vsize,owner){if(hsize<2||vsize<2)throw new Error("invalid mesh size");this._hsize=hsize;this._vsize=vsize;
this._owner=owner||null;this._pts=[];this._minX=0;this._minY=0;this._maxX=1;this._maxY=1;this._hasAnyZElevation=false;this._pointsChanged=false;const lastX=hsize-1;const lastY=vsize-1;for(let y=0;y<vsize;++y){const row=[];for(let x=0;x<hsize;++x){const meshPoint=C3.New(C3.Gfx.MeshPoint,this,x,y);const xf=x/lastX;const yf=y/lastY;meshPoint._Init(xf,yf,xf,yf);row.push(meshPoint)}this._pts.push(row)}}Release(){C3.clearArray(this._pts)}GetHSize(){return this._hsize}GetVSize(){return this._vsize}GetOwner(){return this._owner}_GetPoints(){return this._pts}_SetPointsChanged(){this._pointsChanged=
true}_MaybeComputeBounds(){if(!this._pointsChanged)return;let minX=Infinity;let minY=Infinity;let maxX=-Infinity;let maxY=-Infinity;this._hasAnyZElevation=false;for(const row of this._pts)for(const meshPoint of row){const x=meshPoint.GetX();const y=meshPoint.GetY();minX=Math.min(minX,x);minY=Math.min(minY,y);maxX=Math.max(maxX,x);maxY=Math.max(maxY,y);if(meshPoint.GetZElevation()>0)this._hasAnyZElevation=true}this._minX=minX;this._minY=minY;this._maxX=maxX;this._maxY=maxY;this._pointsChanged=false}GetMinX(){this._MaybeComputeBounds();
return this._minX}GetMinY(){this._MaybeComputeBounds();return this._minY}GetMaxX(){this._MaybeComputeBounds();return this._maxX}GetMaxY(){this._MaybeComputeBounds();return this._maxY}HasAnyZElevation(){this._MaybeComputeBounds();return this._hasAnyZElevation}GetMeshPointAt(x,y){x=Math.floor(x);y=Math.floor(y);if(x<0||x>=this._hsize||y<0||y>=this._vsize)return null;return this._pts[y][x]}CalculateTransformedMesh(srcMesh,quadPos,rcTex_or_quad){const isTexRect=rcTex_or_quad instanceof C3.Rect;if(srcMesh.GetHSize()!==
this.GetHSize()||srcMesh.GetVSize()!==this.GetVSize())throw new Error("source mesh wrong size");const srcPts=srcMesh._pts;const destPts=this._pts;for(let y=0,lenY=destPts.length;y<lenY;++y){const srcRow=srcPts[y];const destRow=destPts[y];for(let x=0,lenX=destRow.length;x<lenX;++x){const srcPoint=srcRow[x];const destPoint=destRow[x];if(isTexRect)destPoint._Interpolate_TexRect(srcPoint,quadPos,rcTex_or_quad);else destPoint._Interpolate_TexQuad(srcPoint,quadPos,rcTex_or_quad)}}}Draw(renderer){const pts=
this._pts;let prevRow=pts[0];for(let y=1,lenY=pts.length;y<lenY;++y){const row=pts[y];let tl=prevRow[0];let bl=row[0];for(let x=1,lenX=row.length;x<lenX;++x){const tr=prevRow[x];const br=row[x];tempQuadTex.set(tl.GetU(),tl.GetV(),tr.GetU(),tr.GetV(),br.GetU(),br.GetV(),bl.GetU(),bl.GetV());renderer.Quad3D2(tl.GetX(),tl.GetY(),tl.GetZElevation(),tr.GetX(),tr.GetY(),tr.GetZElevation(),br.GetX(),br.GetY(),br.GetZElevation(),bl.GetX(),bl.GetY(),bl.GetZElevation(),tempQuadTex);tl=tr;bl=br}prevRow=row}}Outline(renderer,
transformFunc){if(!transformFunc)transformFunc=(x,y)=>[x,y];const pts=this._pts;let prevRow=pts[0];for(let y=1,lenY=pts.length;y<lenY;++y){const row=pts[y];let tl=prevRow[0];let bl=row[0];for(let x=1,lenX=row.length;x<lenX;++x){const tr=prevRow[x];const br=row[x];const [tlx,tly]=transformFunc(tl.GetX(),tl.GetY());const tlz=tl.GetZElevation();const [trx,try_]=transformFunc(tr.GetX(),tr.GetY());const trz=tr.GetZElevation();const [brx,bry]=transformFunc(br.GetX(),br.GetY());const brz=br.GetZElevation();
const [blx,bly]=transformFunc(bl.GetX(),bl.GetY());const blz=bl.GetZElevation();renderer.Line3D(tlx,tly,tlz,trx,try_,trz);renderer.Line3D(tlx,tly,tlz,brx,bry,brz);renderer.Line3D(tlx,tly,tlz,blx,bly,blz);if(x===lenX-1)renderer.Line3D(trx,try_,trz,brx,bry,brz);if(y===lenY-1)renderer.Line3D(blx,bly,blz,brx,bry,brz);tl=tr;bl=br}prevRow=row}}InsertPolyMeshVertices(srcPoly){const RAY_EXT_DIST=.001;const MIN_RAY_DIST=0;const MAX_RAY_DIST=.99999999;const inPts=srcPoly.pointsArr();const outPts=[];const colCount=
this.GetHSize()-1;const rowCount=this.GetVSize()-1;const colWidthNorm=1/colCount;const rowHeightNorm=1/rowCount;const lastCol=colCount-1;const lastRow=rowCount-1;let curX=inPts[0];let curY=inPts[1];let curCol=C3.clamp(Math.floor(curX*colCount),0,lastCol);let curRow=C3.clamp(Math.floor(curY*rowCount),0,lastRow);let isUpper=true;let nextX=0;let nextY=0;let rayHit=0;const NOTHING_DISABLED=-1;const DISABLE_DIAGONAL=0;const DISABLE_LEFT_EDGE=1;const DISABLE_TOP_EDGE=2;const DISABLE_RIGHT_EDGE=3;const DISABLE_BOTTOM_EDGE=
4;let disableCheck=NOTHING_DISABLED;const addVertexAtRayHit=()=>{curX=C3.clamp(C3.lerp(curX,nextX,rayHit),0,1);curY=C3.clamp(C3.lerp(curY,nextY,rayHit),0,1);outPts.push(curX,curY)};for(let i=0,len=inPts.length;i<len;i+=2){curX=inPts[i];curY=inPts[i+1];outPts.push(curX,curY);curCol=C3.clamp(Math.floor(curX*colCount),0,lastCol);curRow=C3.clamp(Math.floor(curY*rowCount),0,lastRow);const j=(i+2)%len;nextX=inPts[j];nextY=inPts[j+1];disableCheck=NOTHING_DISABLED;while(true){if(outPts.length>1E6)throw new Error("Too many mesh poly points");
const srcTlx=curCol*colWidthNorm;const srcTly=curRow*rowHeightNorm;const srcBrx=(curCol+1)*colWidthNorm;const srcBry=(curRow+1)*rowHeightNorm;isUpper=C3.isPointInTriangleInclusive(curX,curY,srcTlx,srcTly,srcBrx,srcTly,srcBrx,srcBry);if(disableCheck!==DISABLE_DIAGONAL){rayHit=C3.rayIntersectExtended(curX,curY,nextX,nextY,srcTlx,srcTly,srcBrx,srcBry,-RAY_EXT_DIST);if(rayHit>=MIN_RAY_DIST&&rayHit<=MAX_RAY_DIST){addVertexAtRayHit();isUpper=!isUpper;disableCheck=DISABLE_DIAGONAL;continue}}if(curRow>0&&
disableCheck!==DISABLE_TOP_EDGE){rayHit=C3.rayIntersectExtended(curX,curY,nextX,nextY,srcTlx,srcTly,srcBrx,srcTly,RAY_EXT_DIST);if(rayHit>=MIN_RAY_DIST&&rayHit<=MAX_RAY_DIST){addVertexAtRayHit();curRow--;isUpper=false;disableCheck=DISABLE_BOTTOM_EDGE;continue}}if(curCol<lastCol&&disableCheck!==DISABLE_RIGHT_EDGE){rayHit=C3.rayIntersectExtended(curX,curY,nextX,nextY,srcBrx,srcTly,srcBrx,srcBry,RAY_EXT_DIST);if(rayHit>=MIN_RAY_DIST&&rayHit<=MAX_RAY_DIST){addVertexAtRayHit();curCol++;isUpper=false;disableCheck=
DISABLE_LEFT_EDGE;continue}}if(curCol>0&&disableCheck!==DISABLE_LEFT_EDGE){rayHit=C3.rayIntersectExtended(curX,curY,nextX,nextY,srcTlx,srcTly,srcTlx,srcBry,RAY_EXT_DIST);if(rayHit>=MIN_RAY_DIST&&rayHit<=MAX_RAY_DIST){addVertexAtRayHit();curCol--;isUpper=true;disableCheck=DISABLE_RIGHT_EDGE;continue}}if(curRow<lastRow&&disableCheck!==DISABLE_BOTTOM_EDGE){rayHit=C3.rayIntersectExtended(curX,curY,nextX,nextY,srcTlx,srcBry,srcBrx,srcBry,RAY_EXT_DIST);if(rayHit>=MIN_RAY_DIST&&rayHit<=MAX_RAY_DIST){addVertexAtRayHit();
curRow++;isUpper=true;disableCheck=DISABLE_TOP_EDGE;continue}}break}}return C3.New(C3.CollisionPoly,outPts)}TransformCollisionPoly(srcPoly,destPoly){const ptsArr=this._TransformPolyPoints(srcPoly);this._SimplifyPoly(ptsArr);destPoly.setPoints(ptsArr)}_TransformPolyPoints(srcPoly){const outPts=[];const ptsArr=srcPoly.pointsArr();for(let i=0,len=ptsArr.length;i<len;i+=2){const srcX=ptsArr[i];const srcY=ptsArr[i+1];const [destX,destY]=this.TransformPoint(srcX,srcY);outPts.push(destX,destY)}return outPts}TransformPoint(srcX,
srcY){const lastCol=this.GetHSize()-1;const lastRow=this.GetVSize()-1;const colWidthNorm=1/lastCol;const rowHeightNorm=1/lastRow;const srcCol=C3.clamp(Math.floor(srcX*lastCol),0,lastCol-1);const srcRow=C3.clamp(Math.floor(srcY*lastRow),0,lastRow-1);const srcTlx=srcCol*colWidthNorm;const srcTly=srcRow*rowHeightNorm;const srcBrx=(srcCol+1)*colWidthNorm;const srcBry=(srcRow+1)*rowHeightNorm;const destTl=this.GetMeshPointAt(srcCol,srcRow);const destBr=this.GetMeshPointAt(srcCol+1,srcRow+1);const isUpper=
C3.isPointInTriangleInclusive(srcX,srcY,srcTlx,srcTly,srcBrx,srcTly,srcBrx,srcBry);const srcAltX=isUpper?srcTlx+colWidthNorm:srcTlx;const srcAltY=isUpper?srcTly:srcTly+rowHeightNorm;const destAlt=this.GetMeshPointAt(srcCol+(isUpper?1:0),srcRow+(isUpper?0:1));const [u,v,w]=C3.triangleCartesianToBarycentric(srcX,srcY,srcTlx,srcTly,srcAltX,srcAltY,srcBrx,srcBry);return C3.triangleBarycentricToCartesian(u,v,w,destTl.GetX(),destTl.GetY(),destAlt.GetX(),destAlt.GetY(),destBr.GetX(),destBr.GetY())}_SimplifyPoly(ptsArr){const outPts=
[];const EPSILON=1E-7;let curX=ptsArr[0];let curY=ptsArr[1];let lastDx=curX-ptsArr[ptsArr.length-2];let lastDy=curY-ptsArr[ptsArr.length-1];for(let i=0,len=ptsArr.length;i<len;i+=2){const j=(i+2)%len;const nextX=ptsArr[j];const nextY=ptsArr[j+1];const dx=nextX-curX;const dy=nextY-curY;const bothXNearZero=Math.abs(dx)<EPSILON&&Math.abs(lastDx)<EPSILON&&Math.sign(dy)===Math.sign(lastDy);const bothYNearZero=Math.abs(dy)<EPSILON&&Math.abs(lastDy)<EPSILON&&Math.sign(dx)===Math.sign(lastDx);if(!bothXNearZero&&
!bothYNearZero&&Math.abs(dx/lastDx-dy/lastDy)>EPSILON||dx==0&&dy===0)outPts.push(curX,curY);curX=nextX;curY=nextY;lastDx=dx;lastDy=dy}if(outPts.length>=6&&outPts.length<ptsArr.length)C3.shallowAssignArray(ptsArr,outPts)}SaveToJson(){return{"cols":this.GetHSize(),"rows":this.GetVSize(),"points":this._pts.map(row=>row.map(pt=>pt.SaveToJson()))}}LoadFromJson(o){const cols=this.GetHSize();const rows=this.GetVSize();if(o["cols"]!==cols||o["rows"]!==rows)throw new Error("mesh data wrong size");const meshRows=
o["points"];for(let y=0;y<rows;++y){const rowData=meshRows[y];for(let x=0;x<cols;++x){const pt=this.GetMeshPointAt(x,y);pt.LoadFromJson(rowData[x])}}}}};


// ../lib/gfx/webgl/texture.js
'use strict';{const C3=self.C3;const VALID_PIXEL_FORMATS=new Set(["rgba8","rgb8","rgba4","rgb5_a1","rgb565"]);const VALID_SAMPLINGS=new Set(["nearest","bilinear","trilinear"]);const VALID_MIPMAP_QUALITIES=new Set(["default","low","high"]);const VALID_WRAP_MODES=new Set(["clamp-to-edge","repeat","mirror-repeat"]);function GetFormatSpecifiers(pixelFormat,gl){let sizedinternalformat;let internalformat;let format;let type;switch(pixelFormat){case "rgba8":sizedinternalformat=gl.RGBA8;internalformat=gl.RGBA;
format=gl.RGBA;type=gl.UNSIGNED_BYTE;break;case "rgb8":sizedinternalformat=gl.RGB8;internalformat=gl.RGB;format=gl.RGB;type=gl.UNSIGNED_BYTE;break;case "rgba4":sizedinternalformat=gl.RGBA4;internalformat=gl.RGBA;format=gl.RGBA;type=gl.UNSIGNED_SHORT_4_4_4_4;break;case "rgb5_a1":sizedinternalformat=gl.RGB5_A1;internalformat=gl.RGBA;format=gl.RGBA;type=gl.UNSIGNED_SHORT_5_5_5_1;break;case "rgb565":sizedinternalformat=gl.RGB565;internalformat=gl.RGB;format=gl.RGB;type=gl.UNSIGNED_SHORT_5_6_5;break;default:throw new Error("invalid pixel format");
}return{sizedinternalformat,internalformat,format,type}}const CREATEFROM_DEFAULT_OPTIONS={wrapX:"clamp-to-edge",wrapY:"clamp-to-edge",sampling:"trilinear",anisotropy:0,pixelFormat:"rgba8",mipMap:true,mipMapQuality:"default",premultiplyAlpha:true,isSvg:false,width:-1,height:-1};const UPDATE_DEFAULT_OPTIONS={premultiplyAlpha:true,flipY:false};const allTextures=new Set;C3.Gfx.WebGLRendererTexture=class WebGLRendererTexture{constructor(renderer){this._renderer=renderer;this._texture=null;this._width=
0;this._height=0;this._isStatic=true;this._wrapX="clamp-to-edge";this._wrapY="clamp-to-edge";this._sampling="trilinear";this._anisotropy=0;this._pixelFormat="rgba8";this._isMipMapped=false;this._mipMapQuality="default";this._refCount=0}_CreateStatic(data,opts){if((typeof HTMLImageElement==="undefined"||!(data instanceof HTMLImageElement))&&(typeof HTMLCanvasElement==="undefined"||!(data instanceof HTMLCanvasElement))&&(typeof ImageBitmap==="undefined"||!(data instanceof ImageBitmap))&&(typeof OffscreenCanvas===
"undefined"||!(data instanceof OffscreenCanvas))&&!(data instanceof ImageData)&&!(data instanceof ArrayBuffer)&&data!==null)throw new Error("invalid texture source");opts=Object.assign({},CREATEFROM_DEFAULT_OPTIONS,opts);if(this._texture)throw new Error("already created texture");this._wrapX=opts.wrapX;this._wrapY=opts.wrapY;this._sampling=opts.sampling;this._anisotropy=opts.anisotropy;this._pixelFormat=opts.pixelFormat;this._isMipMapped=!!opts.mipMap&&this._renderer.AreMipmapsEnabled();this._mipMapQuality=
opts.mipMapQuality;if(!VALID_WRAP_MODES.has(this._wrapX)||!VALID_WRAP_MODES.has(this._wrapY))throw new Error("invalid wrap mode");if(!VALID_SAMPLINGS.has(this._sampling))throw new Error("invalid sampling");if(!VALID_PIXEL_FORMATS.has(this._pixelFormat))throw new Error("invalid pixel format");if(!VALID_MIPMAP_QUALITIES.has(this._mipMapQuality))throw new Error("invalid mipmap quality");this._isStatic=true;if(data instanceof ArrayBuffer||data===null||opts.isSvg){this._width=opts.width;this._height=opts.height;
if(data instanceof ArrayBuffer&&data.byteLength!==this._width*this._height*4)throw new Error("ArrayBuffer wrong size");}else{this._width=data.width;this._height=data.height}if(this._width<=0||this._height<=0)throw new Error("invalid texture data size");if(opts.isSvg){const canvas=C3.CreateCanvas(this._width,this._height);const ctx=canvas.getContext("2d");ctx.drawImage(data,0,0,this._width,this._height);data=canvas}const isPOT=C3.isPOT(this._width)&&C3.isPOT(this._height);const maxTextureSize=this._renderer.GetMaxTextureSize();
if(this._width>maxTextureSize||this._height>maxTextureSize)throw new Error("texture data exceeds maximum texture size");const gl=this._renderer.GetContext();const webglVersion=this._renderer.GetWebGLVersionNumber();this._texture=gl.createTexture();gl.bindTexture(gl.TEXTURE_2D,this._texture);gl.pixelStorei(gl["UNPACK_PREMULTIPLY_ALPHA_WEBGL"],opts.premultiplyAlpha);const formatspec=GetFormatSpecifiers(this._pixelFormat,gl);if(!this._renderer.SupportsNPOTTextures()&&!isPOT&&this._IsTiled()){if(data===
null)throw new Error("cannot pass null data when creating a NPOT tiled texture without NPOT support");if(data instanceof ArrayBuffer)data=new ImageData(new Uint8ClampedArray(data),this._width,this._height);if(data instanceof ImageData){const tmpCanvas=C3.CreateCanvas(this._width,this._height);const tmpCtx=tmpCanvas.getContext("2d");tmpCtx.putImageData(data,0,0);data=tmpCanvas}const canvas=C3.CreateCanvas(C3.nextHighestPowerOfTwo(this._width),C3.nextHighestPowerOfTwo(this._height));const ctx=canvas.getContext("2d");
ctx.imageSmoothingEnabled=this._sampling!=="nearest";ctx.drawImage(data,0,0,this._width,this._height,0,0,canvas.width,canvas.height);gl.texImage2D(gl.TEXTURE_2D,0,formatspec.internalformat,formatspec.format,formatspec.type,canvas)}else if(webglVersion>=2){let levels;if(this._isMipMapped)levels=Math.floor(Math.log2(Math.max(this._width,this._height))+1);else levels=1;gl.texStorage2D(gl.TEXTURE_2D,levels,formatspec.sizedinternalformat,this._width,this._height);if(data instanceof ArrayBuffer)gl.texSubImage2D(gl.TEXTURE_2D,
0,0,0,this._width,this._height,formatspec.format,formatspec.type,new Uint8Array(data));else if(data!==null)gl.texSubImage2D(gl.TEXTURE_2D,0,0,0,formatspec.format,formatspec.type,data)}else if(data instanceof ArrayBuffer)gl.texImage2D(gl.TEXTURE_2D,0,formatspec.internalformat,this._width,this._height,0,formatspec.format,formatspec.type,new Uint8Array(data));else if(data===null)gl.texImage2D(gl.TEXTURE_2D,0,formatspec.internalformat,this._width,this._height,0,formatspec.format,formatspec.type,null);
else gl.texImage2D(gl.TEXTURE_2D,0,formatspec.internalformat,formatspec.format,formatspec.type,data);if(data!==null)this._SetTextureParameters(gl);gl.bindTexture(gl.TEXTURE_2D,null);this._renderer._ResetLastTexture();this._refCount=1;allTextures.add(this)}_CreateDynamic(width,height,opts){opts=Object.assign({},CREATEFROM_DEFAULT_OPTIONS,opts);if(this._texture)throw new Error("already created texture");this._wrapX=opts.wrapX;this._wrapY=opts.wrapY;this._sampling=opts.sampling;this._pixelFormat=opts.pixelFormat;
this._isMipMapped=!!opts.mipMap&&this._renderer.AreMipmapsEnabled();this._mipMapQuality=opts.mipMapQuality;if(!VALID_WRAP_MODES.has(this._wrapX)||!VALID_WRAP_MODES.has(this._wrapY))throw new Error("invalid wrap mode");if(!VALID_SAMPLINGS.has(this._sampling))throw new Error("invalid sampling");if(!VALID_PIXEL_FORMATS.has(this._pixelFormat))throw new Error("invalid pixel format");if(!VALID_MIPMAP_QUALITIES.has(this._mipMapQuality))throw new Error("invalid mipmap quality");this._isStatic=false;this._width=
Math.floor(width);this._height=Math.floor(height);const isPOT=C3.isPOT(this._width)&&C3.isPOT(this._height);const maxTextureSize=this._renderer.GetMaxTextureSize();if(this._width<=0||this._height<=0)throw new Error("invalid texture size");if(this._width>maxTextureSize||this._height>maxTextureSize)throw new Error("texture exceeds maximum texture size");if(!this._renderer.SupportsNPOTTextures()&&this._IsTiled()&&!isPOT)throw new Error("non-power-of-two tiled textures not supported");const gl=this._renderer.GetContext();
const webglVersion=this._renderer.GetWebGLVersionNumber();this._texture=gl.createTexture();gl.bindTexture(gl.TEXTURE_2D,this._texture);gl.pixelStorei(gl["UNPACK_PREMULTIPLY_ALPHA_WEBGL"],opts.premultiplyAlpha);const formatspec=GetFormatSpecifiers(this._pixelFormat,gl);const internalformat=webglVersion>=2?formatspec.sizedinternalformat:formatspec.internalformat;gl.texImage2D(gl.TEXTURE_2D,0,internalformat,this._width,this._height,0,formatspec.format,formatspec.type,null);this._SetTextureParameters(gl);
gl.bindTexture(gl.TEXTURE_2D,null);this._renderer._ResetLastTexture();this._refCount=1;allTextures.add(this)}_GetMipMapHint(gl){if(this._mipMapQuality==="default")return this._isStatic?gl.NICEST:gl.FASTEST;else if(this._mipMapQuality==="low")return gl.FASTEST;else if(this._mipMapQuality==="high")return gl.NICEST;else throw new Error("invalid mipmap quality");}_IsTiled(){return this._wrapX!=="clamp-to-edge"||this._wrapY!=="clamp-to-edge"}_GetTextureWrapMode(gl,wrapMode){if(wrapMode==="clamp-to-edge")return gl.CLAMP_TO_EDGE;
else if(wrapMode==="repeat")return gl.REPEAT;else if(wrapMode==="mirror-repeat")return gl.MIRRORED_REPEAT;else throw new Error("invalid wrap mode");}_SetTextureParameters(gl){const isPOT=C3.isPOT(this._width)&&C3.isPOT(this._height);gl.texParameteri(gl.TEXTURE_2D,gl.TEXTURE_WRAP_S,this._GetTextureWrapMode(gl,this._wrapX));gl.texParameteri(gl.TEXTURE_2D,gl.TEXTURE_WRAP_T,this._GetTextureWrapMode(gl,this._wrapY));if(this._sampling==="nearest"){gl.texParameteri(gl.TEXTURE_2D,gl.TEXTURE_MAG_FILTER,gl.NEAREST);
gl.texParameteri(gl.TEXTURE_2D,gl.TEXTURE_MIN_FILTER,gl.NEAREST);this._isMipMapped=false}else{gl.texParameteri(gl.TEXTURE_2D,gl.TEXTURE_MAG_FILTER,gl.LINEAR);if((isPOT||this._renderer.SupportsNPOTTextures())&&this._isMipMapped){gl.hint(gl.GENERATE_MIPMAP_HINT,this._GetMipMapHint(gl));gl.generateMipmap(gl.TEXTURE_2D);const useTrilinear=this._sampling==="trilinear"&&!this._renderer.HasMajorPerformanceCaveat();gl.texParameteri(gl.TEXTURE_2D,gl.TEXTURE_MIN_FILTER,useTrilinear?gl.LINEAR_MIPMAP_LINEAR:
gl.LINEAR_MIPMAP_NEAREST)}else{gl.texParameteri(gl.TEXTURE_2D,gl.TEXTURE_MIN_FILTER,gl.LINEAR);this._isMipMapped=false}}const anisotropicExt=this._renderer._GetAnisotropicExtension();if(anisotropicExt&&this._anisotropy>0&&this._sampling!=="nearest")gl.texParameterf(gl.TEXTURE_2D,anisotropicExt["TEXTURE_MAX_ANISOTROPY_EXT"],Math.min(this._anisotropy,this._renderer._GetMaxAnisotropy()))}_Update(data,opts){if((typeof HTMLImageElement==="undefined"||!(data instanceof HTMLImageElement))&&(typeof HTMLVideoElement===
"undefined"||!(data instanceof HTMLVideoElement))&&(typeof HTMLCanvasElement==="undefined"||!(data instanceof HTMLCanvasElement))&&(typeof ImageBitmap==="undefined"||!(data instanceof ImageBitmap))&&(typeof OffscreenCanvas==="undefined"||!(data instanceof OffscreenCanvas))&&!(data instanceof ImageData))throw new Error("invalid texture source");if(!this._texture||this._refCount<=0)throw new Error("texture not created");if(this._isStatic)throw new Error("cannot update static texture");opts=Object.assign({},
UPDATE_DEFAULT_OPTIONS,opts);const dataWidth=data.width||data.videoWidth;const dataHeight=data.height||data.videoHeight;const webglVersion=this._renderer.GetWebGLVersionNumber();const gl=this._renderer.GetContext();gl.bindTexture(gl.TEXTURE_2D,this._texture);gl.pixelStorei(gl["UNPACK_PREMULTIPLY_ALPHA_WEBGL"],opts.premultiplyAlpha);gl.pixelStorei(gl["UNPACK_FLIP_Y_WEBGL"],!!opts.flipY);const formatspec=GetFormatSpecifiers(this._pixelFormat,gl);const internalformat=webglVersion>=2?formatspec.sizedinternalformat:
formatspec.internalformat;try{if(this._width===dataWidth&&this._height===dataHeight){const isPOT=C3.isPOT(this._width)&&C3.isPOT(this._height);gl.texSubImage2D(gl.TEXTURE_2D,0,0,0,formatspec.format,formatspec.type,data);if((isPOT||this._renderer.SupportsNPOTTextures())&&this._isMipMapped){gl.hint(gl.GENERATE_MIPMAP_HINT,this._GetMipMapHint(gl));gl.generateMipmap(gl.TEXTURE_2D)}}else{this._width=dataWidth;this._height=dataHeight;const isPOT=C3.isPOT(this._width)&&C3.isPOT(this._height);if(!this._renderer.SupportsNPOTTextures()&&
this._IsTiled()&&!isPOT)throw new Error("non-power-of-two tiled textures not supported");gl.texImage2D(gl.TEXTURE_2D,0,internalformat,formatspec.format,formatspec.type,data);if((isPOT||this._renderer.SupportsNPOTTextures())&&this._isMipMapped){gl.hint(gl.GENERATE_MIPMAP_HINT,this._GetMipMapHint(gl));gl.generateMipmap(gl.TEXTURE_2D)}}}catch(e){console.error("Error updating WebGL texture: ",e)}gl.bindTexture(gl.TEXTURE_2D,null);this._renderer._ResetLastTexture()}_Delete(){if(this._refCount>0)throw new Error("texture still has references");
if(!this._texture)throw new Error("already deleted texture");allTextures.delete(this);const gl=this._renderer.GetContext();gl.deleteTexture(this._texture);this._texture=null}IsValid(){return!!this._texture}_GetTexture(){return this._texture}GetRenderer(){return this._renderer}AddReference(){this._refCount++}SubtractReference(){if(this._refCount<=0)throw new Error("no more references");this._refCount--}GetReferenceCount(){return this._refCount}GetWidth(){return this._width}GetHeight(){return this._height}IsStatic(){return this._isStatic}GetEstimatedMemoryUsage(){let size=
this._width*this._height;switch(this._pixelFormat){case "rgba8":size*=4;break;case "rgb8":size*=3;break;case "rgba4":case "rgb5_a1":case "rgb565":size*=2;break}if(this._isMipMapped)size+=Math.floor(size/3);return size}static OnContextLost(){allTextures.clear()}static allTextures(){return allTextures.values()}}};


// ../lib/gfx/webgl/renderTarget.js
'use strict';{const C3=self.C3;const assert=self.assert;const VALID_SAMPLINGS=new Set(["nearest","bilinear","trilinear"]);const DEFAULT_RENDERTARGET_OPTIONS={sampling:"trilinear",alpha:true,depth:false,readback:true,isDefaultSize:true,multisampling:0};const allRenderTargets=new Set;C3.Gfx.WebGLRenderTarget=class WebGLRenderTarget{constructor(renderer){this._renderer=renderer;this._frameBuffer=null;this._texture=null;this._renderBuffer=null;this._width=0;this._height=0;this._isDefaultSize=true;this._sampling=
"trilinear";this._alpha=true;this._depth=false;this._readback=true;this._multisampling=0}_Create(width,height,opts){opts=Object.assign({},DEFAULT_RENDERTARGET_OPTIONS,opts);const webGLVersion=this._renderer.GetWebGLVersionNumber();if(this._texture||this._renderBuffer)throw new Error("already created render target");this._sampling=opts.sampling;this._alpha=!!opts.alpha;this._depth=!!opts.depth;this._readback=!!opts.readback;this._isDefaultSize=!!opts.isDefaultSize;this._multisampling=opts.multisampling;
if(!VALID_SAMPLINGS.has(this._sampling))throw new Error("invalid sampling");if(this._multisampling>0&&(webGLVersion<2||this._readback))throw new Error("invalid use of multisampling");if(webGLVersion<2)this._readback=true;this._width=width;this._height=height;if(this._width<=0||this._height<=0)throw new Error("invalid render target size");const gl=this._renderer.GetContext();this._frameBuffer=gl.createFramebuffer();gl.bindFramebuffer(gl.FRAMEBUFFER,this._frameBuffer);if(this._readback){this._texture=
this._renderer.CreateDynamicTexture(this._width,this._height,{sampling:this._sampling,pixelFormat:this._alpha?"rgba8":"rgb8",mipMap:false});const tex=this._texture._GetTexture();gl.framebufferTexture2D(gl.FRAMEBUFFER,gl.COLOR_ATTACHMENT0,gl.TEXTURE_2D,tex,0)}else{this._renderBuffer=gl.createRenderbuffer();gl.bindRenderbuffer(gl.RENDERBUFFER,this._renderBuffer);const internalFormat=this._alpha?gl.RGBA8:gl.RGB8;if(this._multisampling>0){const formatSamples=gl.getInternalformatParameter(gl.RENDERBUFFER,
internalFormat,gl.SAMPLES);if(formatSamples&&formatSamples[0]){const maxSamples=formatSamples[0];if(this._multisampling>maxSamples)this._multisampling=maxSamples}else this._multisampling=0}if(this._multisampling===0)gl.renderbufferStorage(gl.RENDERBUFFER,internalFormat,this._width,this._height);else gl.renderbufferStorageMultisample(gl.RENDERBUFFER,this._multisampling,internalFormat,this._width,this._height);gl.framebufferRenderbuffer(gl.FRAMEBUFFER,gl.COLOR_ATTACHMENT0,gl.RENDERBUFFER,this._renderBuffer);
gl.bindRenderbuffer(gl.RENDERBUFFER,null)}const rendererDepthBuffer=this._renderer._GetDepthBuffer();if(this._depth&&rendererDepthBuffer)gl.framebufferRenderbuffer(gl.FRAMEBUFFER,gl.DEPTH_ATTACHMENT,gl.RENDERBUFFER,rendererDepthBuffer);gl.bindFramebuffer(gl.FRAMEBUFFER,null);allRenderTargets.add(this)}_Resize(width,height){if(this._width===width&&this._height===height)return;this._width=width;this._height=height;const gl=this._renderer.GetContext();gl.bindFramebuffer(gl.FRAMEBUFFER,this._frameBuffer);
if(this._texture)this._texture._Update(new ImageData(this._width,this._height));else{gl.bindRenderbuffer(gl.RENDERBUFFER,this._renderBuffer);gl.renderbufferStorage(gl.RENDERBUFFER,this._alpha?gl.RGBA8:gl.RGB8,this._width,this._height);gl.bindRenderbuffer(gl.RENDERBUFFER,null)}const rendererDepthBuffer=this._renderer._GetDepthBuffer();if(this._depth&&rendererDepthBuffer)gl.framebufferRenderbuffer(gl.FRAMEBUFFER,gl.DEPTH_ATTACHMENT,gl.RENDERBUFFER,rendererDepthBuffer);gl.bindFramebuffer(gl.FRAMEBUFFER,
null)}_Delete(){if(!this._texture&&!this._renderBuffer)throw new Error("already deleted render target");allRenderTargets.delete(this);const gl=this._renderer.GetContext();gl.bindFramebuffer(gl.FRAMEBUFFER,this._frameBuffer);if(this._texture){gl.framebufferTexture2D(gl.FRAMEBUFFER,gl.COLOR_ATTACHMENT0,gl.TEXTURE_2D,null,0);this._renderer.DeleteTexture(this._texture);this._texture=null}else if(this._renderBuffer){gl.framebufferRenderbuffer(gl.FRAMEBUFFER,gl.COLOR_ATTACHMENT0,gl.RENDERBUFFER,null);gl.deleteRenderbuffer(this._renderBuffer);
this._renderBuffer=null}gl.bindFramebuffer(gl.FRAMEBUFFER,null);if(this._renderer.GetWebGLVersionNumber()>=2){gl.bindFramebuffer(gl.READ_FRAMEBUFFER,null);gl.bindFramebuffer(gl.DRAW_FRAMEBUFFER,null)}gl.deleteFramebuffer(this._frameBuffer);this._renderer.GetBatchState().currentFramebuffer=null;this._frameBuffer=null}_GetFramebuffer(){return this._frameBuffer}GetWebGLRenderer(){return this._renderer}GetTexture(){return this._texture}IsLinearSampling(){return this._sampling!=="nearest"}HasAlpha(){return this._alpha}IsReadback(){return this._readback}HasDepthBuffer(){return this._depth}GetWidth(){return this._width}GetHeight(){return this._height}IsDefaultSize(){return this._isDefaultSize}GetMultisampling(){return this._multisampling}GetOptions(){const ret=
{sampling:this._sampling,alpha:this._alpha,readback:this._readback};if(!this._isDefaultSize){ret.width=this._width;ret.height=this._height}return ret}IsCompatibleWithOptions(opts){opts=Object.assign({},DEFAULT_RENDERTARGET_OPTIONS,opts);if(opts.sampling!=="nearest"!==this.IsLinearSampling())return false;if(!!opts.alpha!==this.HasAlpha())return false;if(this._renderer.GetWebGLVersionNumber()>=2)if(!!opts.readback!==this.IsReadback())return false;if(typeof opts.width==="number"||typeof opts.height===
"number")return!this.IsDefaultSize()&&this.GetWidth()===opts.width&&this.GetHeight()===opts.height;else return this.IsDefaultSize()}_GetWebGLTexture(){if(!this._texture)return null;return this._texture._GetTexture()}GetEstimatedMemoryUsage(){if(this._texture)return this._texture.GetEstimatedMemoryUsage();return this._width*this._height*(this._alpha?4:3)}static async DebugReadPixelsToBlob(renderer,renderTarget){const imageData=await renderer.ReadBackRenderTargetToImageData(renderTarget,true);return await C3.ImageDataToBlob(imageData)}static OnContextLost(){allRenderTargets.clear()}static allRenderTargets(){return allRenderTargets.values()}static ResizeAll(width,
height){for(const rt of allRenderTargets)if(rt.IsDefaultSize())rt._Resize(width,height)}}};


// ../lib/gfx/webgl/shaderProgram.js
'use strict';{const C3=self.C3;const glMatrix=self.glMatrix;const vec3=glMatrix.vec3;const mat4=glMatrix.mat4;const RESERVED_UNIFORM_NAMES=new Set(["aPos","aTex","aPoints","matP","matMV","samplerFront","samplerBack","destStart","destEnd","srcStart","srcEnd","srcOriginStart","srcOriginEnd","pixelSize","seconds","layerScale","layerAngle","layoutStart","layoutEnd","color","color2_","pointTexStart","pointTexEnd","zElevation","tileSize","tileSpacing","outlineThickness"]);C3.Gfx.WebGLShaderProgram=class WebGLShaderProgram{static async Compile(renderer,
fragSrc,vsSource,name){const gl=renderer.GetContext();const fragmentShader=gl.createShader(gl.FRAGMENT_SHADER);gl.shaderSource(fragmentShader,fragSrc);gl.compileShader(fragmentShader);const vertexShader=gl.createShader(gl.VERTEX_SHADER);gl.shaderSource(vertexShader,vsSource);gl.compileShader(vertexShader);const shaderProgram=gl.createProgram();gl.attachShader(shaderProgram,fragmentShader);gl.attachShader(shaderProgram,vertexShader);gl.bindAttribLocation(shaderProgram,0,"aPos");gl.bindAttribLocation(shaderProgram,
1,"aTex");gl.bindAttribLocation(shaderProgram,2,"aPoints");gl.linkProgram(shaderProgram);const parallelShaderCompileExt=renderer._GetParallelShaderCompileExtension();if(parallelShaderCompileExt)await renderer._WaitForObjectReady(()=>gl.getProgramParameter(shaderProgram,parallelShaderCompileExt["COMPLETION_STATUS_KHR"]));else await C3.Wait(5);if(!gl.getShaderParameter(fragmentShader,gl.COMPILE_STATUS)){const log=gl.getShaderInfoLog(fragmentShader);gl.deleteShader(fragmentShader);gl.deleteShader(vertexShader);
gl.deleteProgram(shaderProgram);throw new Error("Error compiling fragment shader: "+log);}if(!gl.getShaderParameter(vertexShader,gl.COMPILE_STATUS)){const log=gl.getShaderInfoLog(vertexShader);gl.deleteShader(fragmentShader);gl.deleteShader(vertexShader);gl.deleteProgram(shaderProgram);throw new Error("Error compiling vertex shader: "+log);}if(!gl.getProgramParameter(shaderProgram,gl.LINK_STATUS)){const log=gl.getProgramInfoLog(shaderProgram);gl.deleteShader(fragmentShader);gl.deleteShader(vertexShader);
gl.deleteProgram(shaderProgram);throw new Error("Error linking shader program: "+log);}const infoLog=C3.FilterUnprintableChars(gl.getProgramInfoLog(shaderProgram)||"").trim();if(infoLog&&!C3.IsStringAllWhitespace(infoLog))console.info(`[WebGL] Shader program '${name}' compilation log: `,infoLog);gl.deleteShader(fragmentShader);gl.deleteShader(vertexShader);return shaderProgram}static async Create(renderer,shaderInfo,vsSource,name){const shaderProgram=await C3.Gfx.WebGLShaderProgram.Compile(renderer,
shaderInfo.src,vsSource,name);return new C3.Gfx.WebGLShaderProgram(renderer,shaderProgram,shaderInfo,name)}constructor(renderer,shaderProgram,shaderInfo,name){const gl=renderer.GetContext();const batchState=renderer.GetBatchState();renderer.EndBatch();gl.useProgram(shaderProgram);this._gl=gl;this._renderer=renderer;this._name=name;this._shaderProgram=shaderProgram;this._isDeviceTransform=name==="<default-device-transform>";const locAPos=gl.getAttribLocation(shaderProgram,"aPos");const locATex=gl.getAttribLocation(shaderProgram,
"aTex");const locAPoints=gl.getAttribLocation(shaderProgram,"aPoints");if(locAPos!==-1){gl.bindBuffer(gl.ARRAY_BUFFER,renderer._vertexBuffer);gl.vertexAttribPointer(locAPos,renderer.GetNumVertexComponents(),gl.FLOAT,false,0,0);gl.enableVertexAttribArray(locAPos)}if(locATex!==-1){gl.bindBuffer(gl.ARRAY_BUFFER,renderer._texcoordBuffer);gl.vertexAttribPointer(locATex,2,gl.FLOAT,false,0,0);gl.enableVertexAttribArray(locATex)}if(locAPoints!==-1){gl.bindBuffer(gl.ARRAY_BUFFER,renderer._pointBuffer);gl.vertexAttribPointer(locAPoints,
4,gl.FLOAT,false,0,0);gl.enableVertexAttribArray(locAPoints)}gl.bindBuffer(gl.ARRAY_BUFFER,null);this._uMatP=new C3.Gfx.WebGLShaderUniform(this,"matP","mat4");this._uMatMV=new C3.Gfx.WebGLShaderUniform(this,"matMV","mat4");this._uColor=new C3.Gfx.WebGLShaderUniform(this,"color","vec4");this._uSamplerFront=new C3.Gfx.WebGLShaderUniform(this,"samplerFront","sampler");this._uPointTexStart=new C3.Gfx.WebGLShaderUniform(this,"pointTexStart","vec2");this._uPointTexEnd=new C3.Gfx.WebGLShaderUniform(this,
"pointTexEnd","vec2");this._uZElevation=new C3.Gfx.WebGLShaderUniform(this,"zElevation","float");this._uTileSize=new C3.Gfx.WebGLShaderUniform(this,"tileSize","vec2");this._uTileSpacing=new C3.Gfx.WebGLShaderUniform(this,"tileSpacing","vec2");this._uColor2=new C3.Gfx.WebGLShaderUniform(this,"color2_","vec4");this._uOutlineThickness=new C3.Gfx.WebGLShaderUniform(this,"outlineThickness","float");this._uSamplerBack=new C3.Gfx.WebGLShaderUniform(this,"samplerBack","sampler");this._uDestStart=new C3.Gfx.WebGLShaderUniform(this,
"destStart","vec2");this._uDestEnd=new C3.Gfx.WebGLShaderUniform(this,"destEnd","vec2");this._uSrcStart=new C3.Gfx.WebGLShaderUniform(this,"srcStart","vec2");this._uSrcEnd=new C3.Gfx.WebGLShaderUniform(this,"srcEnd","vec2");this._uSrcOriginStart=new C3.Gfx.WebGLShaderUniform(this,"srcOriginStart","vec2");this._uSrcOriginEnd=new C3.Gfx.WebGLShaderUniform(this,"srcOriginEnd","vec2");this._uPixelSize=new C3.Gfx.WebGLShaderUniform(this,"pixelSize","vec2");this._uSeconds=new C3.Gfx.WebGLShaderUniform(this,
"seconds","float");this._uLayerScale=new C3.Gfx.WebGLShaderUniform(this,"layerScale","float");this._uLayerAngle=new C3.Gfx.WebGLShaderUniform(this,"layerAngle","float");this._uLayoutStart=new C3.Gfx.WebGLShaderUniform(this,"layoutStart","vec2");this._uLayoutEnd=new C3.Gfx.WebGLShaderUniform(this,"layoutEnd","vec2");this._hasAnyOptionalUniforms=!!(this._uPixelSize.IsUsed()||this._uSeconds.IsUsed()||this._uSamplerBack.IsUsed()||this._uDestStart.IsUsed()||this._uDestEnd.IsUsed()||this._uSrcStart.IsUsed()||
this._uSrcEnd.IsUsed()||this._uSrcOriginStart.IsUsed()||this._uSrcOriginEnd.IsUsed()||this._uLayerScale.IsUsed()||this._uLayerAngle.IsUsed()||this._uLayoutStart.IsUsed()||this._uLayoutEnd.IsUsed());this._extendBoxHorizontal=shaderInfo.extendBoxHorizontal||0;this._extendBoxVertical=shaderInfo.extendBoxVertical||0;this._crossSampling=!!shaderInfo.crossSampling;this._mustPreDraw=!!shaderInfo.mustPreDraw;this._preservesOpaqueness=!!shaderInfo.preservesOpaqueness;this._animated=!!shaderInfo.animated;const customParameterDefs=
shaderInfo.parameters||[];this._uCustomParameters=[];this._usesDest=this._uDestStart.IsUsed()||this._uDestEnd.IsUsed();this._usesAnySrcRectOrPixelSize=this._uPixelSize.IsUsed()||this._uSrcStart.IsUsed()||this._uSrcEnd.IsUsed()||this._uSrcOriginStart.IsUsed()||this._uSrcOriginEnd.IsUsed();this._needsPostDrawOrExtendBox=this._crossSampling||this._usesDest||this._extendBoxHorizontal!==0||this._extendBoxVertical!==0;this._hasCurrentMatP=false;this._hasCurrentMatMV=false;this._uColor.Init4f(1,1,1,1);this._uColor2.Init4f(1,
1,1,1);this._uSamplerFront.Init1i(0);this._uSamplerBack.Init1i(1);this._uPointTexStart.Init2f(0,0);this._uPointTexEnd.Init2f(1,1);this._uZElevation.Init1f(0);this._uTileSize.Init2f(0,0);this._uTileSpacing.Init2f(0,0);this._uDestStart.Init2f(0,0);this._uDestEnd.Init2f(1,1);this._uSrcStart.Init2f(0,0);this._uSrcEnd.Init2f(0,0);this._uSrcOriginStart.Init2f(0,0);this._uSrcOriginEnd.Init2f(0,0);this._uPixelSize.Init2f(0,0);this._uLayerScale.Init1f(1);this._uLayerAngle.Init1f(0);this._uSeconds.Init1f(0);
this._uLayoutStart.Init2f(0,0);this._uLayoutEnd.Init2f(0,0);this._uOutlineThickness.Init1f(1);for(const p of customParameterDefs){const uniformName=p[0];const paramType=p[2];const shaderUniform=new C3.Gfx.WebGLShaderUniform(this,uniformName,paramType);if(paramType==="color")shaderUniform.Init3f(0,0,0);else shaderUniform.Init1f(0);this._uCustomParameters.push(shaderUniform)}if(this._isDeviceTransform)this._UpdateDeviceTransformUniforms(batchState.currentMatP);else{this.UpdateMatP(batchState.currentMatP,
true);this.UpdateMatMV(batchState.currentMV,true)}const currentShader=batchState.currentShader;gl.useProgram(currentShader?currentShader._shaderProgram:null)}Release(){this._gl.deleteProgram(this._shaderProgram);this._shaderProgram=null;this._renderer._RemoveShaderProgram(this);this._gl=null;this._renderer=null}GetName(){return this._name}GetWebGLContext(){return this._gl}GetShaderProgram(){return this._shaderProgram}UsesDest(){return this._usesDest}UsesCrossSampling(){return this._crossSampling}MustPreDraw(){return this._mustPreDraw}PreservesOpaqueness(){return this._preservesOpaqueness}ExtendsBox(){return this._extendBoxHorizontal!==
0||this._extendBoxVertical!==0}GetBoxExtendHorizontal(){return this._extendBoxHorizontal}GetBoxExtendVertical(){return this._extendBoxVertical}UsesAnySrcRectOrPixelSize(){return this._usesAnySrcRectOrPixelSize}NeedsPostDrawOrExtendsBox(){return this._needsPostDrawOrExtendBox}GetParameterCount(){return this._uCustomParameters.length}GetParameterType(paramIndex){return this._uCustomParameters[paramIndex].GetType()}AreCustomParametersAlreadySetInBatch(params){for(let i=0,len=params.length;i<len;++i)if(!this._uCustomParameters[i].IsSetToCustomInBatch(params[i]))return false;
return true}SetCustomParametersInBatch(params){for(let i=0,len=params.length;i<len;++i)this._uCustomParameters[i].SetBatchValueCustom(params[i])}AreOptionalUniformsAlreadySetInBatch(destRect,srcRect,srcOriginRect,layoutRect,pixelWidth,pixelHeight,layerScale,layerAngle,time){if(this._uSamplerBack.IsUsed())return false;if(this._uPixelSize.IsUsed()&&!this._uPixelSize.IsSetTo2InBatch(pixelWidth,pixelHeight))return false;if(this._uDestStart.IsUsed()&&!this._uDestStart.IsSetTo2InBatch(destRect.getLeft(),
destRect.getTop()))return false;if(this._uDestEnd.IsUsed()&&!this._uDestEnd.IsSetTo2InBatch(destRect.getRight(),destRect.getBottom()))return false;if(this._uLayerScale.IsUsed()&&!this._uLayerScale.IsSetTo1InBatch(layerScale))return false;if(this._uLayerAngle.IsUsed()&&!this._uLayerAngle.IsSetTo1InBatch(layerAngle))return false;if(this._uSrcStart.IsUsed()&&!this._uSrcStart.IsSetTo2InBatch(srcRect.getLeft(),srcRect.getTop()))return false;if(this._uSrcEnd.IsUsed()&&!this._uSrcEnd.IsSetTo2InBatch(srcRect.getRight(),
srcRect.getBottom()))return false;if(this._uSrcOriginStart.IsUsed()&&!this._uSrcOriginStart.IsSetTo2InBatch(srcOriginRect.getLeft(),srcOriginRect.getTop()))return false;if(this._uSrcOriginEnd.IsUsed()&&!this._uSrcOriginEnd.IsSetTo2InBatch(srcOriginRect.getRight(),srcOriginRect.getBottom()))return false;if(this._uLayoutStart.IsUsed()&&!this._uLayoutStart.IsSetTo2InBatch(layoutRect.getLeft(),layoutRect.getTop()))return false;if(this._uLayoutEnd.IsUsed()&&!this._uLayoutEnd.IsSetTo2InBatch(layoutRect.getTop(),
layoutRect.getBottom()))return false;if(this._uSeconds.IsUsed()&&!this._uSeconds.IsSetTo1InBatch(time))return false;return true}SetOptionalUniformsInBatch(destRect,srcRect,srcOriginRect,layoutRect,pixelWidth,pixelHeight,layerScale,layerAngle,time){if(this._uSamplerBack.IsUsed())return;if(this._uPixelSize.IsUsed())this._uPixelSize.SetBatch2(pixelWidth,pixelHeight);if(this._uDestStart.IsUsed())this._uDestStart.SetBatch2(destRect.getLeft(),destRect.getTop());if(this._uDestEnd.IsUsed())this._uDestEnd.SetBatch2(destRect.getRight(),
destRect.getBottom());if(this._uLayerScale.IsUsed())this._uLayerScale.SetBatch1(layerScale);if(this._uLayerAngle.IsUsed())this._uLayerAngle.SetBatch1(layerAngle);if(this._uSrcStart.IsUsed())this._uSrcStart.SetBatch2(srcRect.getLeft(),srcRect.getTop());if(this._uSrcEnd.IsUsed())this._uSrcEnd.SetBatch2(srcRect.getRight(),srcRect.getBottom());if(this._uSrcOriginStart.IsUsed())this._uSrcOriginStart.SetBatch2(srcOriginRect.getLeft(),srcOriginRect.getTop());if(this._uSrcOriginEnd.IsUsed())this._uSrcOriginEnd.SetBatch2(srcOriginRect.getRight(),
srcOriginRect.getBottom());if(this._uLayoutStart.IsUsed())this._uLayoutStart.SetBatch2(layoutRect.getLeft(),layoutRect.getTop());if(this._uLayoutEnd.IsUsed())this._uLayoutEnd.SetBatch2(layoutRect.getTop(),layoutRect.getBottom());if(this._uSeconds.IsUsed())this._uSeconds.SetBatch1(time)}IsAnimated(){return this._animated}UpdateMatP(matP,force){if(this._hasCurrentMatP&&!force)return;if(this._isDeviceTransform)return;if(this._uMatP.IsUsed())this._uMatP.UpdateMatrix4fv(matP);this._hasCurrentMatP=true}SetMatPStale(){this._hasCurrentMatP=
false}UpdateMatMV(matMV,force){if(this._hasCurrentMatMV&&!force)return;if(this._isDeviceTransform)return;if(this._uMatMV.IsUsed())this._uMatMV.UpdateMatrix4fv(matMV);this._hasCurrentMatMV=true}SetMatMVStale(){this._hasCurrentMatMV=false}_UpdateDeviceTransformUniforms(matP){if(!this._isDeviceTransform)throw new Error("not device transform shader");this._uMatP.UpdateMatrix4fv(matP);const renderer=this._renderer;const scrollX=renderer.GetWidth()/2;const scrollY=renderer.GetHeight()/2;const worldScale=
renderer._worldScale;const cam=vec3.fromValues(scrollX*worldScale[0],scrollY*worldScale[1],100*self.devicePixelRatio);const look=vec3.fromValues(scrollX*worldScale[0],scrollY*worldScale[1],0);const mv=mat4.create();mat4.lookAt(mv,cam,look,renderer._up);mat4.scale(mv,mv,worldScale);this._uMatMV.UpdateMatrix4fv(mv)}UpdateColor(c){if(this._uColor.IsUsed())this._uColor.Update4f(c[0],c[1],c[2],c[3])}static GetReservedUniformNames(){return RESERVED_UNIFORM_NAMES}static GetDefaultVertexShaderSource(useHighP){const texPrecision=
useHighP?"highmedp":"mediump";return[`#ifdef GL_FRAGMENT_PRECISION_HIGH`,`#define highmedp highp`,`#else`,`#define highmedp mediump`,`#endif`,`attribute highp vec3 aPos;`,`attribute ${texPrecision} vec2 aTex;`,`varying ${texPrecision} vec2 vTex;`,`uniform highp mat4 matP;`,`uniform highp mat4 matMV;`,`void main(void) {`,`	gl_Position = matP * matMV * vec4(aPos, 1.0);`,`	vTex = aTex;`,`}`].join("\n")}static GetTextureFillFragmentShaderSource(){return["varying mediump vec2 vTex;","uniform lowp vec4 color;",
"uniform lowp sampler2D samplerFront;","void main(void) {","\tgl_FragColor = texture2D(samplerFront, vTex) * color;","}"].join("\n")}static GetTilemapFragmentShaderSource(){return["#ifdef GL_FRAGMENT_PRECISION_HIGH","#define highmedp highp","#else","#define highmedp mediump","#endif","varying highmedp vec2 vTex;","uniform lowp vec4 color;","uniform lowp sampler2D samplerFront;","uniform highmedp vec2 srcStart;","uniform highmedp vec2 pixelSize;","uniform highmedp vec2 tileSize;","uniform highmedp vec2 tileSpacing;",
"void main(void) {","\thighmedp vec2 tile = floor(vTex);","\thighmedp vec2 tex = fract(vTex);","\thighmedp vec2 tileOrigin = srcStart + tile * (tileSize + tileSpacing);","\thighmedp vec2 lowerBound = tileOrigin + pixelSize / 2.0;","\thighmedp vec2 upperBound = tileOrigin + tileSize - pixelSize / 2.0;","\tgl_FragColor = texture2D(samplerFront, clamp(tex, lowerBound, upperBound), -16.0) * color;","}"].join("\n")}static GetPointVertexShaderSource(){return["attribute vec4 aPoints;","varying float pointOpacity;",
"uniform float zElevation;","uniform mat4 matP;","uniform mat4 matMV;","void main(void) {","\tgl_Position = matP * matMV * vec4(aPoints.xy, zElevation, 1.0);","\tgl_PointSize = aPoints.z;","\tpointOpacity = aPoints.w;","}"].join("\n")}static GetPointFragmentShaderSource(){return["uniform lowp sampler2D samplerFront;","varying lowp float pointOpacity;","uniform mediump vec2 pointTexStart;","uniform mediump vec2 pointTexEnd;","uniform lowp vec4 color;","void main(void) {","\tgl_FragColor = texture2D(samplerFront, mix(pointTexStart, pointTexEnd, gl_PointCoord)) * color * pointOpacity;",
"}"].join("\n")}static GetColorFillFragmentShaderSource(){return["uniform lowp vec4 color;","void main(void) {","\tgl_FragColor = color;","}"].join("\n")}static GetLinearGradientFillFragmentShaderSource(){return["precision lowp float;","varying mediump vec2 vTex;","uniform vec4 color;","uniform vec4 color2_;","vec3 fromLinear(vec3 linearRGB)","{","\tbvec3 cutoff = lessThan(linearRGB, vec3(0.0031308));","\tvec3 higher = vec3(1.055) * pow(abs(linearRGB), vec3(1.0/2.4)) - vec3(0.055);","\tvec3 lower = linearRGB * vec3(12.92);",
"\treturn mix(higher, lower, vec3(cutoff));","}","vec3 toLinear(vec3 sRGB)","{","\tbvec3 cutoff = lessThan(sRGB, vec3(0.04045));","\tvec3 higher = pow(abs((sRGB + vec3(0.055))/vec3(1.055)), vec3(2.4));","\tvec3 lower = sRGB/vec3(12.92);","\treturn mix(higher, lower, vec3(cutoff));","}","void main(void) {","\tvec3 linearGrad = mix(toLinear(color.rgb), toLinear(color2_.rgb), vTex.x);","\tfloat a = mix(color.a, color2_.a, vTex.x);","\tgl_FragColor = vec4(fromLinear(linearGrad) * a, a);","}"].join("\n")}static GetSmoothLineFillFragmentShaderSource(){return["varying mediump vec2 vTex;",
"uniform lowp vec4 color;","void main(void) {","\tlowp float f = 1.0 - abs(vTex.y - 0.5) * 2.0;","\tgl_FragColor = color * f;","}"].join("\n")}static GetHardEllipseFillFragmentShaderSource(){return["varying mediump vec2 vTex;","uniform lowp vec4 color;","void main(void) {","\tmediump vec2 diff = vTex - vec2(0.5, 0.5);","\tmediump vec2 diffSq = diff * diff;","\tmediump float f = step(diffSq.x + diffSq.y, 0.25);","\tgl_FragColor = color * f;","}"].join("\n")}static GetHardEllipseOutlineFragmentShaderSource(){return["varying mediump vec2 vTex;",
"uniform lowp vec4 color;","uniform mediump vec2 pixelSize;","uniform mediump float outlineThickness;","void main(void) {","\tmediump vec2 diff = vTex - vec2(0.5, 0.5);","\tmediump vec2 diffSq = diff * diff;","\tmediump float distSq = diffSq.x + diffSq.y;","\tmediump vec2 norm = normalize(diff);","\tmediump vec2 halfNorm = norm * 0.5;","\tmediump float innerF = step(distSq, 0.25);","\tmediump vec2 innerEdge = halfNorm - pixelSize * norm * outlineThickness;","\tmediump vec2 innerEdgeSq = innerEdge * innerEdge;",
"\tmediump float outerF = step(innerEdgeSq.x + innerEdgeSq.y, distSq);","\tgl_FragColor = color * innerF * outerF;","}"].join("\n")}static GetSmoothEllipseFillFragmentShaderSource(){return["varying mediump vec2 vTex;","uniform lowp vec4 color;","uniform mediump vec2 pixelSize;","void main(void) {","\tmediump vec2 diff = vTex - vec2(0.5, 0.5);","\tmediump vec2 diffSq = diff * diff;","\tmediump vec2 norm = normalize(diff);","\tmediump vec2 halfNorm = norm * 0.5;","\tmediump vec2 halfNormSq = halfNorm * halfNorm;",
"\tmediump vec2 innerEdge = halfNorm - pixelSize * norm;","\tmediump vec2 innerEdgeSq = innerEdge * innerEdge;","\tmediump float f = smoothstep(halfNormSq.x + halfNormSq.y, innerEdgeSq.x + innerEdgeSq.y, diffSq.x + diffSq.y);","\tgl_FragColor = color * f;","}"].join("\n")}static GetSmoothEllipseOutlineFragmentShaderSource(){return["varying mediump vec2 vTex;","uniform lowp vec4 color;","uniform mediump vec2 pixelSize;","uniform mediump float outlineThickness;","void main(void) {","\tmediump vec2 diff = vTex - vec2(0.5, 0.5);",
"\tmediump vec2 diffSq = diff * diff;","\tmediump float distSq = diffSq.x + diffSq.y;","\tmediump vec2 norm = normalize(diff);","\tmediump vec2 halfNorm = norm * 0.5;","\tmediump vec2 halfNormSq = halfNorm * halfNorm;","\tmediump vec2 pxNorm = pixelSize * norm;","\tmediump vec2 innerEdge1 = halfNorm - pxNorm;","\tmediump vec2 innerEdge1Sq = innerEdge1 * innerEdge1;","\tmediump float innerF = smoothstep(halfNormSq.x + halfNormSq.y, innerEdge1Sq.x + innerEdge1Sq.y, distSq);","\tmediump vec2 innerEdge2 = halfNorm - pxNorm * outlineThickness;",
"\tmediump vec2 innerEdge2Sq = innerEdge2 * innerEdge2;","\tmediump vec2 innerEdge3 = halfNorm - pxNorm * (outlineThickness + 1.0);","\tmediump vec2 innerEdge3Sq = innerEdge3 * innerEdge3;","\tmediump float outerF = smoothstep(innerEdge3Sq.x + innerEdge3Sq.y, innerEdge2Sq.x + innerEdge2Sq.y, distSq);","\tgl_FragColor = color * innerF * outerF;","}"].join("\n")}}};


// ../lib/gfx/webgl/shaderUniform.js
'use strict';{const C3=self.C3;const TYPE_SIZES=new Map([["float",1],["percent",1],["sampler",1],["vec2",2],["vec3",3],["color",3],["vec4",4],["mat4",16]]);C3.Gfx.WebGLShaderUniform=class WebGLShaderUniform{constructor(owner,name,type){if(!TYPE_SIZES.has(type))throw new Error("invalid uniform type");this._owner=owner;this._gl=this._owner.GetWebGLContext();this._name=name;this._type=type;this._isColorType=this._type==="color";this._location=this._gl.getUniformLocation(this._owner.GetShaderProgram(),
name);this._isUsed=!!this._location;const typeSize=TYPE_SIZES.get(type);this._lastValue=new Float32Array(typeSize);this._lastBatchValue=new Float32Array(typeSize)}Release(){this._owner=null;this._gl=null;this._location=null}IsUsed(){return this._isUsed}GetType(){return this._type}IsColorType(){return this._isColorType}Init1f(v0){if(!this.IsUsed())return;this._lastValue[0]=v0;this._lastBatchValue.set(this._lastValue);this._gl.uniform1f(this._location,v0)}Init1i(v0){if(!this.IsUsed())return;this._lastValue[0]=
v0;this._lastBatchValue.set(this._lastValue);this._gl.uniform1i(this._location,v0)}Init2f(v0,v1){if(!this.IsUsed())return;this._lastValue[0]=v0;this._lastValue[1]=v1;this._lastBatchValue.set(this._lastValue);this._gl.uniform2f(this._location,v0,v1)}Init3f(v0,v1,v2){if(!this.IsUsed())return;this._lastValue[0]=v0;this._lastValue[1]=v1;this._lastValue[2]=v2;this._lastBatchValue.set(this._lastValue);this._gl.uniform3f(this._location,v0,v1,v2)}Init4f(v0,v1,v2,v3){if(!this.IsUsed())return;this._lastValue[0]=
v0;this._lastValue[1]=v1;this._lastValue[2]=v2;this._lastValue[3]=v3;this._lastBatchValue.set(this._lastValue);this._gl.uniform4f(this._location,v0,v1,v2,v3)}Update1f(v0){v0=Math.fround(v0);const lastValue=this._lastValue;if(lastValue[0]===v0)return;lastValue[0]=v0;this._gl.uniform1f(this._location,v0)}Update1i(v0){const lastValue=this._lastValue;if(lastValue[0]===v0)return;lastValue[0]=v0;this._gl.uniform1i(this._location,v0)}Update2f(v0,v1){v0=Math.fround(v0);v1=Math.fround(v1);const lastValue=
this._lastValue;if(lastValue[0]===v0&&lastValue[1]===v1)return;lastValue[0]=v0;lastValue[1]=v1;this._gl.uniform2f(this._location,v0,v1)}Update3f(v0,v1,v2){v0=Math.fround(v0);v1=Math.fround(v1);v2=Math.fround(v2);const lastValue=this._lastValue;if(lastValue[0]===v0&&lastValue[1]===v1&&lastValue[2]===v2)return;lastValue[0]=v0;lastValue[1]=v1;lastValue[2]=v2;this._gl.uniform3f(this._location,v0,v1,v2)}Update4f(v0,v1,v2,v3){v0=Math.fround(v0);v1=Math.fround(v1);v2=Math.fround(v2);v3=Math.fround(v3);const lastValue=
this._lastValue;if(lastValue[0]===v0&&lastValue[1]===v1&&lastValue[2]===v2&&lastValue[3]===v3)return;lastValue[0]=v0;lastValue[1]=v1;lastValue[2]=v2;lastValue[3]=v3;this._gl.uniform4f(this._location,v0,v1,v2,v3)}UpdateMatrix4fv(m){const lastValue=this._lastValue;if(C3.Gfx.AreMat4sEqual(lastValue,m))return;C3.typedArraySet16(lastValue,m,0);this._gl.uniformMatrix4fv(this._location,false,m)}IsSetToCustomInBatch(p){const batchValue=this._lastBatchValue;if(this.IsColorType())return batchValue[0]===Math.fround(p.getR())&&
batchValue[1]===Math.fround(p.getG())&&batchValue[2]===Math.fround(p.getB());else return batchValue[0]===Math.fround(p)}SetBatchValueCustom(p){const batchValue=this._lastBatchValue;if(this.IsColorType()){batchValue[0]=p.getR();batchValue[1]=p.getG();batchValue[2]=p.getB()}else batchValue[0]=p}IsSetTo1InBatch(x){return this._lastBatchValue[0]===Math.fround(x)}IsSetTo2InBatch(x,y){const batchValue=this._lastBatchValue;return batchValue[0]===Math.fround(x)&&batchValue[1]===Math.fround(y)}SetBatch1(x){this._lastBatchValue[0]=
x}SetBatch2(x,y){const batchValue=this._lastBatchValue;batchValue[0]=x;batchValue[1]=y}}};


// ../lib/gfx/webgl/batchJob.js
'use strict';{const C3=self.C3;const glMatrix=self.glMatrix;const vec4=glMatrix.vec4;const mat4=glMatrix.mat4;const BATCH_NULL=0;const BATCH_QUAD=1;const BATCH_SETTEXTURE=2;const BATCH_SETCOLOR=3;const BATCH_SETBLEND=4;const BATCH_UPDATEMODELVIEW=5;const BATCH_SETRENDERTARGET=6;const BATCH_CLEARSURFACE=7;const BATCH_CLEARRECT=8;const BATCH_POINTS=9;const BATCH_SETPROGRAM=10;const BATCH_SETPROGRAMPARAMETERS=11;const BATCH_INVALIDATEFRAMEBUFFER=12;const BATCH_SETPOINTTEXCOORDS=13;const BATCH_SETTILEMAPINFO=
14;const BATCH_BLITFRAMEBUFFER=15;const BATCH_STARTQUERY=16;const BATCH_ENDQUERY=17;const BATCH_SETELLIPSEPARAMS=18;const BATCH_SETGRADIENTCOLOR=19;const BATCH_CLEARDEPTH=20;const BATCH_SETDEPTHENABLED=21;C3.Gfx.BatchState=class BatchState{constructor(renderer){this.renderer=renderer;this.currentMV=mat4.create();this.currentMatP=mat4.create();this.currentFramebuffer=null;this.currentColor=vec4.fromValues(1,1,1,1);this.currentShader=null;this.pointTexCoords=new C3.Rect;this.clearColor=C3.New(C3.Color,
0,0,0,0)}};C3.Gfx.WebGLBatchJob=class WebGLBatchJob{constructor(batchState){const arrayBuffer=new ArrayBuffer(96);this._type=0;this._batchState=batchState;this._gl=batchState.renderer.GetContext();this._startIndex=0;this._indexCount=0;this._texParam=null;this._mat4param=new Float32Array(arrayBuffer,0,16);this._colorParam=new Float32Array(arrayBuffer,64,4);this._srcOriginRect=new Float32Array(arrayBuffer,80,4);this._shaderParams=[]}InitQuad(startIndex,indexCount){this._type=BATCH_QUAD;this._startIndex=
startIndex;this._indexCount=indexCount}DoQuad(){const gl=this._gl;gl.drawElements(gl.TRIANGLES,this._indexCount,gl.UNSIGNED_SHORT,this._startIndex)}InitSetTexture(rendererTex){this._type=BATCH_SETTEXTURE;this._texParam=rendererTex}DoSetTexture(){const gl=this._gl;const texParam=this._texParam;gl.bindTexture(gl.TEXTURE_2D,texParam?texParam._GetTexture():null)}InitSetColor(c){this._type=BATCH_SETCOLOR;c.writeToTypedArray(this._colorParam,0)}DoSetColor(){const c=this._colorParam;const batchState=this._batchState;
vec4.copy(batchState.currentColor,c);batchState.currentShader.UpdateColor(c)}InitSetGradientColor(c){this._type=BATCH_SETGRADIENTCOLOR;c.writeToTypedArray(this._colorParam,0)}DoSetGradientColor(){const c=this._colorParam;const s=this._batchState.currentShader;if(s._uColor2.IsUsed())s._uColor2.Update4f(c[0],c[1],c[2],c[3])}InitSetBlend(s,d){this._type=BATCH_SETBLEND;this._startIndex=s;this._indexCount=d}DoSetBlend(){this._gl.blendFunc(this._startIndex,this._indexCount)}InitUpdateModelView(m){this._type=
BATCH_UPDATEMODELVIEW;mat4.copy(this._mat4param,m)}DoUpdateModelView(){const batchState=this._batchState;const allShaderPrograms=batchState.renderer._allShaderPrograms;const currentShader=batchState.currentShader;const mat4param=this._mat4param;for(let i=0,len=allShaderPrograms.length;i<len;++i){const s=allShaderPrograms[i];if(s===currentShader)s.UpdateMatMV(mat4param,true);else s.SetMatMVStale()}mat4.copy(batchState.currentMV,mat4param)}InitSetRenderTarget(renderTarget,didSurfaceSizeChange,matP){this._type=
BATCH_SETRENDERTARGET;this._texParam=renderTarget;this._startIndex=didSurfaceSizeChange?1:0;if(didSurfaceSizeChange)mat4.copy(this._mat4param,matP)}DoSetRenderTarget(){const gl=this._gl;const renderTarget=this._texParam;const didSurfaceSizeChange=this._startIndex!==0;const matP=this._mat4param;const batchState=this._batchState;const renderer=batchState.renderer;let newViewportWidth,newViewportHeight;if(renderTarget){const fbo=renderTarget._GetFramebuffer();batchState.currentFramebuffer=fbo;gl.bindFramebuffer(gl.FRAMEBUFFER,
fbo);newViewportWidth=renderTarget.GetWidth();newViewportHeight=renderTarget.GetHeight()}else{batchState.currentFramebuffer=null;gl.bindFramebuffer(gl.FRAMEBUFFER,null);newViewportWidth=renderer.GetScissoredViewportWidth();newViewportHeight=renderer.GetScissoredViewportHeight()}if(didSurfaceSizeChange)renderer._UpdateViewportBatch(newViewportWidth,newViewportHeight,matP)}InitClearSurface(c){this._type=BATCH_CLEARSURFACE;c.writeToTypedArray(this._mat4param,0)}InitClearSurface2(r,g,b,a){this._type=
BATCH_CLEARSURFACE;const c=this._mat4param;c[0]=r;c[1]=g;c[2]=b;c[3]=a}DoClearSurface(){const gl=this._gl;const mat4param=this._mat4param;const batchState=this._batchState;const renderer=batchState.renderer;const lastClearColor=batchState.clearColor;const debugSkipScissor=renderer._isScissorViewport&&C3.isDebug;if(debugSkipScissor)gl.disable(gl.SCISSOR_TEST);const r=mat4param[0];const g=mat4param[1];const b=mat4param[2];const a=mat4param[3];if(!lastClearColor.equalsRgba(r,g,b,a)){gl.clearColor(r,
g,b,a);lastClearColor.setRgba(r,g,b,a)}gl.clear(gl.COLOR_BUFFER_BIT);if(debugSkipScissor)gl.enable(gl.SCISSOR_TEST)}InitClearRect(x,y,w,h,r,g,b,a){this._type=BATCH_CLEARRECT;const m=this._mat4param;m[0]=x;m[1]=y;m[2]=w;m[3]=h;m[4]=r;m[5]=g;m[6]=b;m[7]=a}DoClearRectangle(){const gl=this._gl;const mat4param=this._mat4param;const batchState=this._batchState;const renderer=batchState.renderer;const lastClearColor=batchState.clearColor;if(!renderer._isScissorViewport)gl.enable(gl.SCISSOR_TEST);gl.scissor(mat4param[0],
mat4param[1],mat4param[2],mat4param[3]);const r=mat4param[4];const g=mat4param[5];const b=mat4param[6];const a=mat4param[7];if(!lastClearColor.equalsRgba(r,g,b,a)){gl.clearColor(r,g,b,a);lastClearColor.setRgba(r,g,b,a)}gl.clear(gl.COLOR_BUFFER_BIT);if(!renderer._isScissorViewport)gl.disable(gl.SCISSOR_TEST);else gl.scissor(0,0,renderer._viewportScissorWidth,renderer._viewportScissorHeight)}InitSetPointTexCoords(rect){this._type=BATCH_SETPOINTTEXCOORDS;rect.writeToTypedArray(this._mat4param,0)}DoSetPointTextureCoords(){const mat4param=
this._mat4param;this._batchState.pointTexCoords.set(mat4param[0],mat4param[1],mat4param[2],mat4param[3])}InitPoints(startIndex,z){this._type=BATCH_POINTS;this._startIndex=startIndex;this._indexCount=1;this._mat4param[0]=z}DoPoints(){const gl=this._gl;const batchState=this._batchState;const renderer=batchState.renderer;const s=renderer._spPoints;gl.useProgram(s._shaderProgram);s.UpdateMatP(batchState.currentMatP,false);s.UpdateMatMV(batchState.currentMV,false);const ptc=batchState.pointTexCoords;if(s._uPointTexStart.IsUsed())s._uPointTexStart.Update2f(ptc.getLeft(),
ptc.getTop());if(s._uPointTexEnd.IsUsed())s._uPointTexEnd.Update2f(ptc.getRight(),ptc.getBottom());const z=this._mat4param[0];if(s._uZElevation.IsUsed())s._uZElevation.Update1f(z);if(s._uColor.IsUsed()){const c=batchState.currentColor;s._uColor.Update4f(c[0],c[1],c[2],c[3])}gl.drawArrays(gl.POINTS,this._startIndex/4,this._indexCount);gl.useProgram(batchState.currentShader._shaderProgram)}InitSetProgram(program){this._type=BATCH_SETPROGRAM;this._texParam=program}DoSetProgram(){const gl=this._gl;const batchState=
this._batchState;const s=this._texParam;batchState.currentShader=s;gl.useProgram(s._shaderProgram);s.UpdateMatP(batchState.currentMatP,false);s.UpdateMatMV(batchState.currentMV,false);if(s._uColor.IsUsed()){const c=batchState.currentColor;s._uColor.Update4f(c[0],c[1],c[2],c[3])}}InitSetProgramParameters(){this._type=BATCH_SETPROGRAMPARAMETERS}DoSetProgramParameters(){const s=this._batchState.currentShader;if(s._hasAnyOptionalUniforms)this._DoSetOptionalUniformProgramParameters(s);if(s._uCustomParameters.length)this._DoUpdateCustomProgramParameters(s)}_DoSetOptionalUniformProgramParameters(s){const gl=
this._gl;const mat4param=this._mat4param;const colorParam=this._colorParam;const srcOriginRect=this._srcOriginRect;if(s._uSamplerBack.IsUsed()){const renderer=this._batchState.renderer;const texParam=this._texParam;if(renderer._lastTexture1!==texParam){gl.activeTexture(gl.TEXTURE1);gl.bindTexture(gl.TEXTURE_2D,texParam?texParam._GetTexture():null);renderer._lastTexture1=texParam;gl.activeTexture(gl.TEXTURE0)}}if(s._uPixelSize.IsUsed())s._uPixelSize.Update2f(mat4param[0],mat4param[1]);if(s._uDestStart.IsUsed())s._uDestStart.Update2f(mat4param[2],
mat4param[3]);if(s._uDestEnd.IsUsed())s._uDestEnd.Update2f(mat4param[4],mat4param[5]);if(s._uLayerScale.IsUsed())s._uLayerScale.Update1f(mat4param[6]);if(s._uLayerAngle.IsUsed())s._uLayerAngle.Update1f(mat4param[7]);if(s._uSrcStart.IsUsed())s._uSrcStart.Update2f(mat4param[12],mat4param[13]);if(s._uSrcEnd.IsUsed())s._uSrcEnd.Update2f(mat4param[14],mat4param[15]);if(s._uSrcOriginStart.IsUsed())s._uSrcOriginStart.Update2f(srcOriginRect[0],srcOriginRect[1]);if(s._uSrcOriginEnd.IsUsed())s._uSrcOriginEnd.Update2f(srcOriginRect[2],
srcOriginRect[3]);if(s._uLayoutStart.IsUsed())s._uLayoutStart.Update2f(colorParam[0],colorParam[1]);if(s._uLayoutEnd.IsUsed())s._uLayoutEnd.Update2f(colorParam[2],colorParam[3]);if(s._uSeconds.IsUsed())s._uSeconds.Update1f(this._startIndex)}_DoUpdateCustomProgramParameters(s){const uCustomParameters=s._uCustomParameters;const shaderParams=this._shaderParams;for(let i=0,len=uCustomParameters.length;i<len;++i){const shaderUniform=uCustomParameters[i];const paramValue=shaderParams[i];if(shaderUniform.IsColorType())shaderUniform.Update3f(paramValue.getR(),
paramValue.getG(),paramValue.getB());else shaderUniform.Update1f(paramValue)}}InitInvalidateFramebuffer(fbo){this._type=BATCH_INVALIDATEFRAMEBUFFER;this._texParam=fbo}DoInvalidateFramebuffer(){const gl=this._gl;const fbo=this._texParam;const lastBoundFbo=this._batchState.currentFramebuffer;if(fbo!==lastBoundFbo)gl.bindFramebuffer(gl.FRAMEBUFFER,fbo);gl.invalidateFramebuffer(gl.FRAMEBUFFER,[gl.COLOR_ATTACHMENT0]);if(fbo!==lastBoundFbo)gl.bindFramebuffer(gl.FRAMEBUFFER,lastBoundFbo)}InitBlitFramebuffer(sourceRenderTarget,
destRenderTarget,mode){this._type=BATCH_BLITFRAMEBUFFER;const mat4param=this._mat4param;const renderer=this._batchState.renderer;mat4param[0]=sourceRenderTarget.GetWidth();mat4param[1]=sourceRenderTarget.GetHeight();mat4param[2]=destRenderTarget?destRenderTarget.GetWidth():renderer.GetWidth();mat4param[3]=destRenderTarget?destRenderTarget.GetHeight():renderer.GetHeight();mat4param[4]=sourceRenderTarget.IsLinearSampling()?1:0;mat4param[5]=mode==="stretch";const shaderParams=this._shaderParams;C3.clearArray(shaderParams);
shaderParams.push(sourceRenderTarget._GetFramebuffer());shaderParams.push(destRenderTarget?destRenderTarget._GetFramebuffer():null)}DoBlitFramebuffer(){const mat4param=this._mat4param;const shaderParams=this._shaderParams;const gl=this._gl;const srcWidth=mat4param[0];const srcHeight=mat4param[1];const destWidth=mat4param[2];const destHeight=mat4param[3];const isLinearSampling=mat4param[4]!==0;const isStretch=mat4param[5]!==0;const srcFbo=shaderParams[0];const destFbo=shaderParams[1];gl.bindFramebuffer(gl.READ_FRAMEBUFFER,
srcFbo);gl.bindFramebuffer(gl.DRAW_FRAMEBUFFER,destFbo);if(isStretch)gl.blitFramebuffer(0,0,srcWidth,srcHeight,0,0,destWidth,destHeight,gl.COLOR_BUFFER_BIT,isLinearSampling?gl.LINEAR:gl.NEAREST);else{const w=Math.min(srcWidth,destWidth);const h=Math.min(srcHeight,destHeight);const srcOffY=Math.max(srcHeight-destHeight,0);const destOffY=Math.max(destHeight-srcHeight,0);gl.blitFramebuffer(0,srcOffY,w,h+srcOffY,0,destOffY,w,h+destOffY,gl.COLOR_BUFFER_BIT,gl.NEAREST)}}InitStartQuery(query){this._type=
BATCH_STARTQUERY;this._texParam=query}DoStartQuery(){this._texParam.BeginTimeElapsed();this._texParam=null}InitEndQuery(query){this._type=BATCH_ENDQUERY;this._texParam=query}DoEndQuery(){this._texParam.EndTimeElapsed();this._texParam=null}InitSetEllipseParams(pixelW,pixelH,outlineThickness){this._type=BATCH_SETELLIPSEPARAMS;const mat4param=this._mat4param;mat4param[0]=pixelW;mat4param[1]=pixelH;mat4param[2]=outlineThickness}DoSetEllipseParams(){const s=this._batchState.currentShader;const mat4param=
this._mat4param;if(s._uPixelSize.IsUsed())s._uPixelSize.Update2f(mat4param[0],mat4param[1]);if(s._uOutlineThickness.IsUsed())s._uOutlineThickness.Update1f(mat4param[2])}InitSetTilemapInfo(srcRect,textureWidth,textureHeight,tileWidth,tileHeight,tileSpacingX,tileSpacingY){this._type=BATCH_SETTILEMAPINFO;const mat4param=this._mat4param;srcRect.writeToTypedArray(mat4param,0);mat4param[4]=1/textureWidth;mat4param[5]=1/textureHeight;mat4param[6]=tileWidth/textureWidth;mat4param[7]=tileHeight/textureHeight;
mat4param[8]=tileSpacingX/textureWidth;mat4param[9]=tileSpacingY/textureHeight}DoSetTilemapInfo(){const s=this._batchState.currentShader;const mat4param=this._mat4param;if(s._uSrcStart.IsUsed())s._uSrcStart.Update2f(mat4param[0],mat4param[1]);if(s._uPixelSize.IsUsed())s._uPixelSize.Update2f(mat4param[4],mat4param[5]);if(s._uTileSize.IsUsed())s._uTileSize.Update2f(mat4param[6],mat4param[7]);if(s._uTileSpacing.IsUsed())s._uTileSpacing.Update2f(mat4param[8],mat4param[9])}InitClearDepth(){this._type=
BATCH_CLEARDEPTH}DoClearDepth(){const gl=this._gl;gl.clear(gl.DEPTH_BUFFER_BIT)}InitSetDepthEnabled(e){this._type=BATCH_SETDEPTHENABLED;this._startIndex=e?1:0}DoSetDepthEnabled(){const gl=this._gl;if(this._startIndex===0){gl.disable(gl.DEPTH_TEST);gl.depthMask(false)}else{gl.enable(gl.DEPTH_TEST);gl.depthMask(true)}}Run(){switch(this._type){case 1:this.DoQuad();return;case 2:this.DoSetTexture();return;case 3:this.DoSetColor();return;case 4:this.DoSetBlend();return;case 5:this.DoUpdateModelView();
return;case 6:this.DoSetRenderTarget();return;case 7:this.DoClearSurface();return;case 8:this.DoClearRectangle();return;case 9:this.DoPoints();return;case 10:this.DoSetProgram();return;case 11:this.DoSetProgramParameters();return;case 12:this.DoInvalidateFramebuffer();return;case 13:this.DoSetPointTextureCoords();return;case 14:this.DoSetTilemapInfo();return;case 15:this.DoBlitFramebuffer();return;case 16:this.DoStartQuery();return;case 17:this.DoEndQuery();return;case 18:this.DoSetEllipseParams();
return;case 19:this.DoSetGradientColor();return;case 20:this.DoClearDepth();return;case 21:this.DoSetDepthEnabled();return}}}};


// ../lib/gfx/text.js
'use strict';{const C3=self.C3;const MAX_TEXTURE_SIZE=2048;const EXTRA_LINE_HEIGHT=4;const DEFAULT_OPTS={timeout:60};const tempColor=new C3.Color(0,0,0,1);const VALID_HORIZ_ALIGNMENTS=new Set(["left","center","right"]);const VALID_VERT_ALIGNMENTS=new Set(["top","center","bottom"]);const VALID_WORD_WRAP_MODES=new Set(["word","character"]);const allRendererTexts=new Set;if(C3.FontManager)C3.FontManager.addEventListener("fontload",e=>{const fontName=e.font.GetName();for(const f of allRendererTexts)if(f.IsBBCodeEnabled()||
C3.equalsNoCase(f.GetFontName(),fontName))f._SetTextChanged()});function fillOrStrokeText(ctx,isStroke,text,x,y,maxWidth){if(isStroke)if(C3.Platform.BrowserEngine==="Gecko")ctx.strokeText(text,x,y,maxWidth);else ctx.strokeText(text,x,y);else if(C3.Platform.BrowserEngine==="Gecko")ctx.fillText(text,x,y,maxWidth);else ctx.fillText(text,x,y)}function fillOrStrokeRect(ctx,isStroke,x,y,w,h){if(isStroke)ctx.strokeRect(x,y,w,h);else ctx.fillRect(x,y,w,h)}function ptToPx(pt){return pt*(4/3)}let didCheckFoundBoundingBoxSupport=
false;let supportsFontBoundingBoxMeasurements=false;C3.Gfx.RendererText=class RendererText{constructor(renderer,opts){opts=Object.assign({},DEFAULT_OPTS,opts);this._renderer=renderer;this._fontName="Arial";this._fontSize=16;this._lineHeight=0;this._isBold=false;this._isItalic=false;this._colorStr="black";this._isBBcodeEnabled=false;this.onloadfont=null;this._alreadyLoadedFonts=new Set;this._horizontalAlign="left";this._verticalAlign="top";this._text="";this._bbString=null;this._wrappedText=C3.New(C3.WordWrap);
this._wrapMode="word";this._textChanged=false;this._isUpdating=false;this._isAsync=true;this._drawMaxCharCount=-1;this._drawCharCount=0;this._cssWidth=0;this._cssHeight=0;this._width=0;this._height=0;this._zoom=1;this._changed=false;this._textCanvas=null;this._textContext=null;this._measureContext=null;this._measureContextTop=null;this._lastCanvasWidth=-1;this._lastCanvasHeight=-1;this._lastTextCanvasFont="";this._lastMeasureCanvasFont="";this._lastTextCanvasFillStyle="";this._lastTextCanvasOpacity=
1;this._lastTextCanvasLineWidth=1;this._measureTextCallback=(text,styles)=>this._MeasureText(text,styles);this._texture=null;this._textureWidth=0;this._textureHeight=0;this._rcTex=new C3.Rect;this._scaleFactor=1;this._needToRecreateTexture=false;this._textureTimeout=new C3.IdleTimeout(()=>{this.ReleaseTexture();this._SetTextCanvasSize(8,8)},opts.timeout);this.ontextureupdate=null;this._wasReleased=false;allRendererTexts.add(this)}Release(){this.onloadfont=null;this._alreadyLoadedFonts.clear();this._bbString=
null;this._textCanvas=null;this._textContext=null;this._measureContext=null;this._measureContextTop=null;this._measureTextCallback=null;this._textureTimeout.Release();this.ontextureupdate=null;this.ReleaseTexture();this._wrappedText.Clear();this._wrappedText=null;this._renderer=null;this._wasReleased=true;allRendererTexts.delete(this)}_SetChanged(){this._changed=true}_SetTextChanged(){this._SetChanged();this._wrappedText.Clear();this._textChanged=true}SetIsAsync(a){this._isAsync=!!a}IsAsync(){return this._isAsync}SetBBCodeEnabled(e){e=
!!e;if(this._isBBcodeEnabled===e)return;this._isBBcodeEnabled=e;const textBaseline=this._isBBcodeEnabled?"alphabetic":"top";if(this._textContext)this._textContext.textBaseline=textBaseline;if(this._measureContext)this._measureContext.textBaseline=textBaseline;this._SetTextChanged()}IsBBCodeEnabled(){return this._isBBcodeEnabled}SetFontName(fontName){if(!fontName)fontName="serif";if(this._fontName===fontName)return;this._fontName=fontName;this._SetTextChanged()}GetFontName(){return this._fontName}SetFontSize(fontSize){if(fontSize<
.1)fontSize=.1;if(this._fontSize===fontSize)return;this._fontSize=fontSize;this._SetTextChanged()}SetLineHeight(h){if(this._lineHeight===h)return;this._lineHeight=h;this._SetChanged()}SetBold(bold){bold=!!bold;if(this._isBold===bold)return;this._isBold=bold;this._SetTextChanged()}SetItalic(italic){italic=!!italic;if(this._isItalic===italic)return;this._isItalic=italic;this._SetTextChanged()}SetDrawMaxCharacterCount(n){n=Math.floor(n);if(this._drawMaxCharCount===n)return;this._drawMaxCharCount=n;this._SetChanged()}GetDrawMaxCharacterCount(){return this._drawMaxCharCount}_GetStyleTag(styles,
tag){for(let i=styles.length-1;i>=0;--i){const s=styles[i];if(s.tag===tag)return s}return null}_HasStyleTag(styles,tag){return!!this._GetStyleTag(styles,tag)}_GetFontString(useCssUnits,styles){let ret=[];if(this._isBold||this._HasStyleTag(styles,"b"))ret.push("bold");if(this._isItalic||this._HasStyleTag(styles,"i"))ret.push("italic");const sizeStyle=this._GetStyleTag(styles,"size");const fontSize=sizeStyle?parseFloat(sizeStyle.param):this._fontSize;if(useCssUnits)ret.push(fontSize+"pt");else ret.push(fontSize*
this._scaleFactor*this._zoom*self.devicePixelRatio+"pt");let fontName=this._fontName;const fontStyle=this._GetStyleTag(styles,"font");if(fontStyle&&fontStyle.param){fontName=fontStyle.param;if(this.onloadfont&&!this._alreadyLoadedFonts.has(fontName)){this.onloadfont(fontName);this._alreadyLoadedFonts.add(fontName)}}if(fontName)ret.push('"'+fontName+'"');return ret.join(" ")}SetColor(c){if(c instanceof C3.Color)c=c.getCssRgb();if(this._colorStr===c)return;this._colorStr=c;this._SetChanged()}SetColorRgb(r,
g,b){tempColor.setRgb(r,g,b);this.SetColor(tempColor)}SetHorizontalAlignment(h){if(!VALID_HORIZ_ALIGNMENTS.has(h))throw new Error("invalid horizontal alignment");if(this._horizontalAlign===h)return;this._horizontalAlign=h;this._SetChanged()}SetVerticalAlignment(v){if(!VALID_VERT_ALIGNMENTS.has(v))throw new Error("invalid vertical alignment");if(this._verticalAlign===v)return;this._verticalAlign=v;this._SetChanged()}SetWordWrapMode(m){if(!VALID_WORD_WRAP_MODES.has(m))throw new Error("invalid word wrap mode");
if(this._wrapMode===m)return;this._wrapMode=m;this._SetTextChanged()}SetText(text){if(this._text===text)return;this._text=text;this._SetTextChanged()}SetSize(cssWidth,cssHeight,zoom){if(typeof zoom==="undefined")zoom=1;if(cssWidth<=0||cssWidth<=0)return;if(this._cssWidth===cssWidth&&this._cssHeight===cssHeight&&this._zoom===zoom)return;if(this._zoom===1!==(zoom===1))this._needToRecreateTexture=true;const oldCssWidth=this._cssWidth;const oldZoom=this._zoom;this._cssWidth=cssWidth;this._cssHeight=cssHeight;
this._zoom=zoom;const dpr=self.devicePixelRatio;this._width=this._cssWidth*this._zoom*dpr;this._height=this._cssHeight*this._zoom*dpr;const maxDim=Math.max(this._width,this._height);const maxTextureSize=Math.min(this._renderer.GetMaxTextureSize(),MAX_TEXTURE_SIZE);let scale=1;if(maxDim>maxTextureSize){scale=maxTextureSize/maxDim;this._width=Math.min(this._width*scale,maxTextureSize);this._height=Math.min(this._height*scale,maxTextureSize)}this._scaleFactor=scale;if(this._textureWidth>0&&this._textureHeight>
0&&this._zoom===oldZoom)this._rcTex.set(0,0,this._width/this._textureWidth,this._height/this._textureHeight);if(this._cssWidth!==oldCssWidth)this._SetTextChanged();else this._SetChanged()}GetWidth(){return this._width}GetHeight(){return this._height}GetTextWidth(){this._MaybeWrapText();return this._wrappedText.GetMaxLineWidth()}GetTextHeight(){this._MaybeWrapText();return this._wrappedText.GetTotalLineHeight()+this._wrappedText.GetLineCount()*(this._lineHeight+EXTRA_LINE_HEIGHT)-this._lineHeight}GetTexture(){this._textureTimeout.Reset();
this._MaybeUpdate();return this._texture}_MaybeUpdate(){if(this._texture&&!this._changed&&!this._textChanged)return;if(this._isUpdating)return;if(this._width<=0||this._height<=0)return;this._changed=false;this._isUpdating=true;if(this._isAsync)C3.Asyncify(()=>this._DoUpdate());else this._DoUpdate()}_DoUpdate(){if(this._wasReleased)return;this._SetTextCanvasSize(Math.ceil(this._width),Math.ceil(this._height));this._MaybeWrapText();this._DrawTextToCanvas();this._UpdateTexture();this._textureTimeout.Reset();
this._isUpdating=false}_SetTextCanvasSize(w,h){if(!this._textCanvas)this._textCanvas=C3.CreateCanvas(16,16);let wasReset=false;if(this._lastCanvasWidth!==w||this._lastCanvasHeight!==h){this._lastCanvasWidth=w;this._lastCanvasHeight=h;this._textCanvas.width=w;this._textCanvas.height=h;wasReset=true}if(!this._textContext){this._textContext=this._textCanvas.getContext("2d");wasReset=true}if(wasReset){this._textContext.textBaseline=this._isBBcodeEnabled?"alphabetic":"top";this._textContext.font=this._lastTextCanvasFont;
this._textContext.fillStyle=this._lastTextCanvasFillStyle;this._textContext.strokeStyle=this._lastTextCanvasFillStyle;this._textContext.globalAlpha=this._lastTextCanvasOpacity;this._textContext.lineWidth=this._lastTextCanvasLineWidth}else this._textContext.clearRect(0,0,w,h)}_MaybeCreateMeasureContext(){if(this._measureContext)return;this._measureContext=C3.CreateCanvas(16,16).getContext("2d");this._measureContextTop=C3.CreateCanvas(16,16).getContext("2d");this._measureContext.textBaseline=this._isBBcodeEnabled?
"alphabetic":"top";this._measureContextTop.textBaseline="top"}_SetMeasureFontString(fontString){if(this._lastMeasureCanvasFont===fontString)return;this._lastMeasureCanvasFont=fontString;this._measureContext.font=fontString;this._measureContextTop.font=fontString}_SupportsFontBoundingBoxMeasurements(){if(!didCheckFoundBoundingBoxSupport){didCheckFoundBoundingBoxSupport=true;this._MaybeCreateMeasureContext();const textMetrics=this._measureContext.measureText("test");supportsFontBoundingBoxMeasurements=
typeof textMetrics["fontBoundingBoxAscent"]==="number"&&typeof textMetrics["fontBoundingBoxDescent"]==="number"}return supportsFontBoundingBoxMeasurements}_MaybeWrapText(){if(!this._textChanged)return;this._MaybeCreateMeasureContext();if(this._isBBcodeEnabled&&(!this._bbString||this._bbString.toString()!==this._text))this._bbString=new C3.BBString(this._text,{noEscape:true});this._wrappedText.WordWrap(this._isBBcodeEnabled?this._bbString.toFragmentList():this._text,this._measureTextCallback,this._cssWidth,
this._wrapMode,0);this._textChanged=false}_MeasureText(text,styles){this._SetMeasureFontString(this._GetFontString(true,styles));const sizeStyle=this._GetStyleTag(styles,"size");const fontSize=sizeStyle?parseFloat(sizeStyle.param):this._fontSize;const textMetrics=this._measureContext.measureText(text);let topToAlphabeticDistance=0;if(this._isBBcodeEnabled&&this._SupportsFontBoundingBoxMeasurements()){const textMetricsTop=this._measureContextTop.measureText(text);topToAlphabeticDistance=textMetrics["fontBoundingBoxAscent"]-
textMetricsTop["fontBoundingBoxAscent"]}return{width:textMetrics.width,height:ptToPx(fontSize),fontBoundingBoxAscent:textMetrics["fontBoundingBoxAscent"]||0,fontBoundingBoxDescent:textMetrics["fontBoundingBoxDescent"]||0,topToAlphabeticDistance}}_SetDrawFontString(fontString){if(this._lastTextCanvasFont===fontString)return;this._lastTextCanvasFont=fontString;this._textContext.font=fontString}_SetDrawCanvasColor(styleStr){if(this._lastTextCanvasFillStyle===styleStr)return;this._lastTextCanvasFillStyle=
styleStr;this._textContext.fillStyle=styleStr;this._textContext.strokeStyle=styleStr}_SetDrawCanvasOpacity(o){if(this._lastTextCanvasOpacity===o)return;this._lastTextCanvasOpacity=o;this._textContext.globalAlpha=o}_SetDrawCanvasLineWith(w){if(this._lastTextCanvasLineWidth===w)return;this._lastTextCanvasLineWidth=w;this._textContext.lineWidth=w}_DrawTextToCanvas(){this._drawCharCount=0;const scale=this._scaleFactor*this._zoom*self.devicePixelRatio;const lineSpaceHeight=(EXTRA_LINE_HEIGHT+this._lineHeight)*
scale;let penY=0;const lines=this._wrappedText.GetLines();if(lines.length===0)return;const useFontBoundingBoxMeasurements=this._isBBcodeEnabled&&this._SupportsFontBoundingBoxMeasurements();let firstLineTextHeight=lines[0].height*scale;if(this._verticalAlign==="center"){const linesTotalHeight=lines.reduce((a,v)=>a+v.height*scale+lineSpaceHeight,0)-lineSpaceHeight;penY=Math.max(this._height/2-linesTotalHeight/2,0);if(useFontBoundingBoxMeasurements)firstLineTextHeight=lines[0].topToAlphabeticDistance*
scale}else if(this._verticalAlign==="bottom"){const linesTotalHeight=lines.reduce((a,v)=>a+v.height*scale+lineSpaceHeight,0)-this._lineHeight*scale;const lastLineDescentHeight=useFontBoundingBoxMeasurements?lines[lines.length-1].fontBoundingBoxDescent*scale:0;penY=this._height-linesTotalHeight-lastLineDescentHeight-2}for(let i=0,len=lines.length;i<len;++i){const line=lines[i];const curLineTextHeight=line.height*scale;const startPenY=penY;if(this._isBBcodeEnabled){penY+=i===0?firstLineTextHeight:curLineTextHeight;
if(i>0&&penY>this._height-EXTRA_LINE_HEIGHT*scale)break}else if(i>0&&penY>=this._height-curLineTextHeight)break;if(startPenY>=0)this._DrawTextLine(line,penY,scale);if(!this._isBBcodeEnabled)penY+=curLineTextHeight;penY+=lineSpaceHeight}}_DrawTextLine(line,penY,scale){let penX=0;if(this._horizontalAlign==="center")penX=(this._width-line.width*scale)/2;else if(this._horizontalAlign==="right")penX=this._width-line.width*scale;for(const frag of line.fragments){this._DrawTextFragment(frag,penX,penY,scale,
line.height);penX+=frag.width*scale}}_DrawTextFragment(frag,penX,penY,scale,lineHeight){const textContext=this._textContext;const lineFontScale=lineHeight/16;let fragWidth=frag.width*scale;const fragHeight=frag.height*scale;const fragFontScale=frag.height/16;const lineSpaceHeight=(EXTRA_LINE_HEIGHT+this._lineHeight)*scale;const styles=frag.styles;let text=frag.text;if(this._drawMaxCharCount!==-1){if(this._drawCharCount>=this._drawMaxCharCount)return;if(this._drawCharCount+text.length>this._drawMaxCharCount){text=
text.substr(0,this._drawMaxCharCount-this._drawCharCount);fragWidth=this._MeasureText(text,styles).width*scale}this._drawCharCount+=text.length}const backgroundStyle=this._GetStyleTag(styles,"background");const hasUnderline=this._HasStyleTag(styles,"u");const hasStrikethrough=this._HasStyleTag(styles,"s");if(C3.IsStringAllWhitespace(text)&&!backgroundStyle&&!hasUnderline&&!hasStrikethrough||this._HasStyleTag(styles,"hide"))return;const offsetXStyle=this._GetStyleTag(styles,"offsetx");penX+=offsetXStyle?
parseFloat(offsetXStyle.param)*scale:0;const offsetYStyle=this._GetStyleTag(styles,"offsety");penY+=offsetYStyle?parseFloat(offsetYStyle.param)*scale:0;if(backgroundStyle){this._SetDrawCanvasColor(backgroundStyle.param);textContext.fillRect(penX,penY-fragHeight,fragWidth,fragHeight+lineSpaceHeight)}const colorStyle=this._GetStyleTag(styles,"color");this._SetDrawCanvasColor(colorStyle?colorStyle.param:this._colorStr);const opacityStyle=this._GetStyleTag(styles,"opacity");this._SetDrawCanvasOpacity(opacityStyle?
parseFloat(opacityStyle.param)/100:1);const isStroke=this._HasStyleTag(styles,"stroke");if(isStroke)this._SetDrawCanvasLineWith(fragFontScale*this._scaleFactor*this._zoom);if(hasUnderline)fillOrStrokeRect(textContext,isStroke,penX,penY+scale*lineFontScale,fragWidth,scale*lineFontScale);if(hasStrikethrough)fillOrStrokeRect(textContext,isStroke,penX,penY-fragHeight/4,fragWidth,scale*fragFontScale);this._SetDrawFontString(this._GetFontString(false,styles));fillOrStrokeText(textContext,isStroke,text,
penX,penY,fragWidth);if(!isStroke){this._SetDrawCanvasLineWith(fragFontScale*this._scaleFactor*this._zoom);const outlineStyle=this._GetStyleTag(styles,"outline");if(outlineStyle){this._SetDrawCanvasColor(outlineStyle.param);fillOrStrokeText(textContext,true,text,penX,penY,fragWidth)}}}_UpdateTexture(){if(this._renderer.IsContextLost())return;this._textureWidth=Math.ceil(this._width);this._textureHeight=Math.ceil(this._height);this._rcTex.set(0,0,this._width/this._textureWidth,this._height/this._textureHeight);
if(this._needToRecreateTexture){this.ReleaseTexture();this._needToRecreateTexture=false}if(!this._texture)this._texture=this._renderer.CreateDynamicTexture(this._textureWidth,this._textureHeight,{mipMap:this._zoom===1,mipMapQuality:"high"});this._renderer.UpdateTexture(this._textCanvas,this._texture);if(this.ontextureupdate)this.ontextureupdate()}GetTexRect(){return this._rcTex}ReleaseTexture(){if(this._texture){if(!this._renderer.IsContextLost())this._renderer.DeleteTexture(this._texture);this._texture=
null}}static OnContextLost(){for(const rendererText of allRendererTexts)rendererText.ReleaseTexture()}static GetAll(){return allRendererTexts.values()}}};


// ../lib/gfx/webgl/query.js
'use strict';{const C3=self.C3;class WebGLRealTimeElapsedQuery{constructor(renderer){this._gl=renderer.GetContext();this._version=renderer.GetWebGLVersionNumber();this._timerExt=renderer._GetDisjointTimerQueryExtension();this._query=null;this._isActive=false;this._hasResult=false;this._result=0;if(this._version===1)this._query=this._timerExt["createQueryEXT"]();else this._query=this._gl["createQuery"]()}Release(){this._DeleteQueryObject();this._gl=null;this._timerExt=null;this._hasResult=false}_DeleteQueryObject(){if(!this._query)return;
if(this._version===1)this._timerExt["deleteQueryEXT"](this._query);else this._gl["deleteQuery"](this._query);this._query=null}BeginTimeElapsed(){if(this._isActive)throw new Error("query already active");if(this._version===1)this._timerExt["beginQueryEXT"](this._timerExt["TIME_ELAPSED_EXT"],this._query);else this._gl["beginQuery"](this._timerExt["TIME_ELAPSED_EXT"],this._query);this._isActive=true}EndTimeElapsed(){if(!this._isActive)throw new Error("query not active");if(this._version===1)this._timerExt["endQueryEXT"](this._timerExt["TIME_ELAPSED_EXT"]);
else this._gl["endQuery"](this._timerExt["TIME_ELAPSED_EXT"]);this._isActive=false}CheckForResult(){if(!this._query||this._hasResult||this._isActive)return;let available=false;if(this._version===1)available=this._timerExt["getQueryObjectEXT"](this._query,this._timerExt["QUERY_RESULT_AVAILABLE_EXT"]);else available=this._gl["getQueryParameter"](this._query,this._gl["QUERY_RESULT_AVAILABLE"]);const disjoint=this._gl.getParameter(this._timerExt["GPU_DISJOINT_EXT"]);if(available&&!disjoint){if(this._version===
1)this._result=this._timerExt["getQueryObjectEXT"](this._query,this._timerExt["QUERY_RESULT_EXT"]);else this._result=this._gl["getQueryParameter"](this._query,this._gl["QUERY_RESULT"]);this._result/=1E9;this._hasResult=true}if(available||disjoint)this._DeleteQueryObject()}HasResult(){return this._hasResult}GetResult(){if(!this._hasResult)throw new Error("no result available");return this._result}}C3.Gfx.WebGLTimeElapsedQuery=class WebGLTimeElapsedQuery{constructor(renderer){this._renderer=renderer;
this._frameNumber=renderer.GetFrameNumber();this._isActive=false;this._parentQuery=null;this._isNested=false;this._realQuery=null;this._queries=[]}Release(){for(const q of this._queries)if(q instanceof WebGLRealTimeElapsedQuery)q.Release();C3.clearArray(this._queries);this._parentQuery=null;this._realQuery=null;this._renderer=null}BeginTimeElapsed(){if(this._isActive)throw new Error("query already active");const stack=this._renderer._GetTimeQueryStack();if(stack.length>0){this._isNested=true;this._parentQuery=
stack[stack.length-1];this._parentQuery._EndReal();this._parentQuery._queries.push(this)}else{this._isNested=false;this._parentQuery=null}this._isActive=true;stack.push(this);this._StartReal()}EndTimeElapsed(){if(!this._isActive)throw new Error("query not active");const top=this._renderer._GetTimeQueryStack().pop();if(top!==this)throw new Error("can only end most nested query");this._isActive=false;this._EndReal();if(this._parentQuery){this._parentQuery._StartReal();this._parentQuery=null}}_StartReal(){this._realQuery=
C3.New(WebGLRealTimeElapsedQuery,this._renderer);this._queries.push(this._realQuery);this._realQuery.BeginTimeElapsed()}_EndReal(){this._realQuery.EndTimeElapsed();this._realQuery=null}CheckForResult(){for(const q of this._queries)q.CheckForResult()}IsNested(){return this._isNested}HasResult(){return this._queries.every(q=>q.HasResult())}GetResult(){return this._queries.reduce((a,v)=>a+v.GetResult(),0)}GetFrameNumber(){return this._frameNumber}}};


// ../lib/gfx/webgl/queryResultBuffer.js
'use strict';{const C3=self.C3;C3.Gfx.WebGLQueryResultBuffer=class WebGLQueryResultBuffer{constructor(renderer,maxQueries=1E3){this._renderer=renderer;this._maxQueries=maxQueries;this._buffer=[];this._renderer._AddQueryResultBuffer(this)}Release(){this.Clear();this._renderer._RemoveQueryResultBuffer(this);this._renderer=null}Clear(){for(const q of this._buffer)q.Release();C3.clearArray(this._buffer)}AddTimeElapsedQuery(){const ret=new C3.Gfx.WebGLTimeElapsedQuery(this._renderer);this._buffer.push(ret);
if(this._buffer.length>this._maxQueries){const oldest=this._buffer.shift();oldest.Release()}return ret}CheckForResults(toFrameNumber){for(const q of this._buffer){if(q.GetFrameNumber()>=toFrameNumber)return;if(q.IsNested())return;q.CheckForResult()}}GetFrameRangeResultSum(startFrame,endFrame){if(endFrame<=startFrame)return NaN;let sum=0;for(const q of this._buffer){if(q.GetFrameNumber()>=endFrame)break;if(q.GetFrameNumber()<startFrame)continue;if(q.HasResult())sum+=q.GetResult();else return NaN}return sum}DeleteAllBeforeFrameNumber(frameNumber){for(let i=
0,len=this._buffer.length;i<len;++i){const q=this._buffer[i];if(q.GetFrameNumber()<frameNumber)q.Release();else{if(i>0)this._buffer.splice(0,i);return}}}}};


// ../lib/gfx/webgl/webglRenderer.js
'use strict';{const C3=self.C3;const assert=self.assert;const glMatrix=self.glMatrix;const vec3=glMatrix.vec3;const vec4=glMatrix.vec4;const mat4=glMatrix.mat4;const DEFAULT_WEBGLRENDERER_OPTS={powerPreference:"default",enableGpuProfiling:true,alpha:false,lowLatency:false,depth:false,maxWebGLVersion:2};const VALID_POWER_PREFERENCES=new Set(["default","low-power","high-performance"]);const MAX_VERTICES=8E3;const MAX_INDICES=MAX_VERTICES/2*3;const MAX_POINTS=8E3;const LAST_POINT=MAX_POINTS-4;const PARTIAL_TEXTURE_UPLOAD_CHUNK_SIZE=
256*1024;const defaultTexCoordsQuad=new C3.Quad(0,0,1,0,1,1,0,1);const tmpVec3=vec3.fromValues(0,0,0);const tmpVec3b=vec3.fromValues(0,0,0);const tmpMat4=mat4.create();const tmpQuad=new C3.Quad;const tmpRect=new C3.Rect;let loseContextExtension=null;if(C3.isDebug){self.debug_lose_context=function(){if(!loseContextExtension){console.warn("WEBGL_lose_context not supported");return}loseContextExtension.loseContext()};self.debug_restore_context=function(){if(!loseContextExtension){console.warn("WEBGL_lose_context not supported");
return}loseContextExtension.restoreContext()}}const pendingPolls=new Set;let pollRafId=-1;function CheckPendingPolls(){pollRafId=-1;for(const info of pendingPolls)if(info.checkFunc()){info.resolve();pendingPolls.delete(info)}if(pendingPolls.size>0)pollRafId=self.requestAnimationFrame(CheckPendingPolls)}function GetWebGLContext(canvas,attribs,maxWebGLVersion){let gl=null;if(maxWebGLVersion>=2){gl=canvas.getContext("webgl2",attribs);if(gl)return{gl,version:2}}gl=canvas.getContext("webgl",attribs);if(!gl)try{gl=
canvas.getContext("experimental-webgl",attribs)}catch(err){console.warn("Error requesting 'experimental-webgl' context: ",err)}return{gl,version:1}}C3.Gfx.WebGLRenderer=class WebGLRenderer extends C3.Gfx.RendererBase{constructor(canvas,opts){super();opts=Object.assign({},DEFAULT_WEBGLRENDERER_OPTS,opts);if(!VALID_POWER_PREFERENCES.has(opts.powerPreference))throw new Error("invalid power preference");let hasMajorPerformanceCaveat=false;const attribs={"alpha":!!opts.alpha,"depth":false,"antialias":false,
"powerPreference":opts.powerPreference,"failIfMajorPerformanceCaveat":true};if(opts.lowLatency){attribs["desynchronized"]=true;attribs["preserveDrawingBuffer"]=true}let ctxInfo=GetWebGLContext(canvas,attribs,opts.maxWebGLVersion);if(!ctxInfo.gl){hasMajorPerformanceCaveat=true;attribs["failIfMajorPerformanceCaveat"]=false;ctxInfo=GetWebGLContext(canvas,attribs,opts.maxWebGLVersion)}if(!ctxInfo.gl)throw new Error("failed to initialise WebGL context");const gl=ctxInfo.gl;this._gl=gl;this._attribs=gl.getContextAttributes();
if(opts.lowLatency&&!this._attribs["desynchronized"])console.info("[WebGLRenderer] Low-latency mode specified but is not supported here");this._versionString=gl.getParameter(gl.VERSION);this._version=ctxInfo.version;this._lastBackbufferWidth=0;this._lastBackbufferHeight=0;this._usesDepthBuffer=!!opts.depth;this._isDepthEnabled=this._usesDepthBuffer;this._depthBuffer=null;this._isAutoSizeDepthBuffer=true;this._depthBufferWidth=0;this._depthBufferHeight=0;this._vertexBuffer=null;this._texcoordBuffer=
null;this._indexBuffer=null;this._pointBuffer=null;this._vertexData=new Float32Array(MAX_VERTICES*this.GetNumVertexComponents());this._indexData=new Uint16Array(MAX_INDICES);this._texcoordData=new Float32Array(MAX_VERTICES*2);this._pointData=new Float32Array(MAX_POINTS*4);this._vertexPtr=0;this._texPtr=0;this._pointPtr=0;this._lastVertexPtr=0;this._lastProgram=null;this._spDeviceTransformTextureFill=null;this._batch=[];this._batchPtr=0;this._topOfBatch=0;this._currentRenderTarget=null;this._lastPointZ=
0;this._batchState=C3.New(C3.Gfx.BatchState,this);this._lastColor=C3.New(C3.Color,1,1,1,1);this._lastTexture0=null;this._lastTexture1=null;this._lastSrcBlend=0;this._lastDestBlend=0;this._lineWidth=1;this._lineWidthStack=[this._lineWidth];this._lineCap=1;this._lineCapStack=[this._lineCap];this._lineOffset=.5;this._lineOffsetStack=[this._lineOffset];this._isScissorViewport=false;this._viewportScissorWidth=-1;this._viewportScissorHeight=-1;this._lastPointTexCoords=new C3.Rect;this._maxTextureSize=-1;
this._minPointSize=0;this._maxPointSize=0;this._highpPrecision=0;this._unmaskedVendor="(unavailable)";this._unmaskedRenderer="(unavailable)";this._extensions=[];this._hasMajorPerformanceCaveat=hasMajorPerformanceCaveat;this._isInitialisingAfterContextRestored=false;this._parallelShaderCompileExt=null;this._anisotropicExt=null;this._maxAnisotropy=0;this._isGpuProfilingEnabled=!!opts.enableGpuProfiling;this._timerExt=null;this._allQueryResultBuffers=new Set;this._timeQueryStack=[];this.FillIndexBufferData(this._indexData)}IsWebGL(){return true}async InitState(){super.InitState();
const gl=this._gl;const numVertexComponents=this.GetNumVertexComponents();this._lastColor.setRgba(1,1,1,1);this._lastTexture0=null;this._lastTexture1=null;this._vertexPtr=0;this._pointPtr=0;this._lastVertexPtr=MAX_VERTICES*numVertexComponents-4*numVertexComponents;C3.clearArray(this._batch);this._batchPtr=0;this._topOfBatch=0;this._lastProgram=null;this._currentRenderTarget=null;this._lastPointTexCoords.set(0,0,1,1);this._lastPointZ=0;const batchState=this._batchState;batchState.currentShader=null;
batchState.currentFramebuffer=null;vec4.set(batchState.currentColor,1,1,1,1);batchState.clearColor.setRgba(0,0,0,0);batchState.pointTexCoords.set(0,0,1,1);gl.clearColor(0,0,0,0);gl.clear(gl.COLOR_BUFFER_BIT);gl.enable(gl.BLEND);gl.blendFunc(gl.ONE,gl.ONE_MINUS_SRC_ALPHA);this._lastSrcBlend=gl.ONE;this._lastDestBlend=gl.ONE_MINUS_SRC_ALPHA;this._InitBlendModes(gl);gl.disable(gl.CULL_FACE);gl.disable(gl.STENCIL_TEST);gl.disable(gl.DITHER);if(this._usesDepthBuffer){gl.enable(gl.DEPTH_TEST);gl.depthMask(true);
gl.depthFunc(gl.LEQUAL)}else{gl.disable(gl.DEPTH_TEST);gl.depthMask(false)}this._isDepthEnabled=this._usesDepthBuffer;this._pointBuffer=gl.createBuffer();gl.bindBuffer(gl.ARRAY_BUFFER,this._pointBuffer);gl.bufferData(gl.ARRAY_BUFFER,this._pointData.byteLength,gl.DYNAMIC_DRAW);this._vertexBuffer=gl.createBuffer();gl.bindBuffer(gl.ARRAY_BUFFER,this._vertexBuffer);gl.bufferData(gl.ARRAY_BUFFER,this._vertexData.byteLength,gl.DYNAMIC_DRAW);this._texcoordBuffer=gl.createBuffer();gl.bindBuffer(gl.ARRAY_BUFFER,
this._texcoordBuffer);gl.bufferData(gl.ARRAY_BUFFER,this._texcoordData.byteLength,gl.DYNAMIC_DRAW);this._indexBuffer=gl.createBuffer();gl.bindBuffer(gl.ELEMENT_ARRAY_BUFFER,this._indexBuffer);gl.bufferData(gl.ELEMENT_ARRAY_BUFFER,this._indexData,gl.STATIC_DRAW);gl.activeTexture(gl.TEXTURE0);gl.bindTexture(gl.TEXTURE_2D,null);this._maxTextureSize=gl.getParameter(gl.MAX_TEXTURE_SIZE);const pointsizes=gl.getParameter(gl.ALIASED_POINT_SIZE_RANGE);this._minPointSize=pointsizes[0];this._maxPointSize=pointsizes[1];
const highpVertex=gl.getShaderPrecisionFormat(gl.VERTEX_SHADER,gl.HIGH_FLOAT);const highpFrag=gl.getShaderPrecisionFormat(gl.FRAGMENT_SHADER,gl.HIGH_FLOAT);if(highpVertex&&highpFrag)this._highpPrecision=Math.min(highpVertex["precision"],highpFrag["precision"]);else this._highpPrecision=0;if(this._maxPointSize>2048)this._maxPointSize=2048;this._extensions=gl.getSupportedExtensions();const debug_ext=gl.getExtension("WEBGL_debug_renderer_info");if(debug_ext){this._unmaskedVendor=gl.getParameter(debug_ext["UNMASKED_VENDOR_WEBGL"]);
this._unmaskedRenderer=gl.getParameter(debug_ext["UNMASKED_RENDERER_WEBGL"])}this._parallelShaderCompileExt=gl.getExtension("KHR_parallel_shader_compile");if(C3.isDebug)loseContextExtension=gl.getExtension("WEBGL_lose_context");if(this._isGpuProfilingEnabled)if(this.GetWebGLVersionNumber()===1){if(C3.Platform.BrowserEngine!=="Chromium"||C3.Platform.BrowserVersionNumber>=81||typeof document!=="undefined")this._timerExt=gl.getExtension("EXT_disjoint_timer_query")}else this._timerExt=gl.getExtension("EXT_disjoint_timer_query_webgl2")||
gl.getExtension("EXT_disjoint_timer_query");this._anisotropicExt=gl.getExtension("EXT_texture_filter_anisotropic");if(this._anisotropicExt)this._maxAnisotropy=gl.getParameter(this._anisotropicExt["MAX_TEXTURE_MAX_ANISOTROPY_EXT"]);else this._maxAnisotropy=0;const WebGLShaderProgram=C3.Gfx.WebGLShaderProgram;const vsSource=WebGLShaderProgram.GetDefaultVertexShaderSource(false);const DEFAULT_SHADER_PROGRAMS=[[WebGLShaderProgram.GetTextureFillFragmentShaderSource(),vsSource,"<default>"],[WebGLShaderProgram.GetTextureFillFragmentShaderSource(),
vsSource,"<default-device-transform>"],[WebGLShaderProgram.GetPointFragmentShaderSource(),WebGLShaderProgram.GetPointVertexShaderSource(),"<point>"],[WebGLShaderProgram.GetColorFillFragmentShaderSource(),vsSource,"<fill>"],[WebGLShaderProgram.GetLinearGradientFillFragmentShaderSource(),vsSource,"<lineargradient>"],[WebGLShaderProgram.GetHardEllipseFillFragmentShaderSource(),vsSource,"<hardellipse>"],[WebGLShaderProgram.GetHardEllipseOutlineFragmentShaderSource(),vsSource,"<hardellipseoutline>"],[WebGLShaderProgram.GetSmoothEllipseFillFragmentShaderSource(),
vsSource,"<smoothellipse>"],[WebGLShaderProgram.GetSmoothEllipseOutlineFragmentShaderSource(),vsSource,"<smoothellipseoutline>"],[WebGLShaderProgram.GetSmoothLineFillFragmentShaderSource(),vsSource,"<smoothline>"],[WebGLShaderProgram.GetTilemapFragmentShaderSource(),WebGLShaderProgram.GetDefaultVertexShaderSource(true),"<tilemap>"]];const defaultShaders=await Promise.all(DEFAULT_SHADER_PROGRAMS.map(i=>this.CreateShaderProgram({src:i[0]},i[1],i[2])));this._spTextureFill=defaultShaders[0];this._spDeviceTransformTextureFill=
defaultShaders[1];this._spPoints=defaultShaders[2];this._spColorFill=defaultShaders[3];this._spLinearGradientFill=defaultShaders[4];this._spHardEllipseFill=defaultShaders[5];this._spHardEllipseOutline=defaultShaders[6];this._spSmoothEllipseFill=defaultShaders[7];this._spSmoothEllipseOutline=defaultShaders[8];this._spSmoothLineFill=defaultShaders[9];this._spTilemapFill=defaultShaders[10];this.SetTextureFillMode()}async CreateShaderProgram(shaderInfo,vsSource,name){const ret=await C3.Gfx.WebGLShaderProgram.Create(this,
shaderInfo,vsSource,name);this._AddShaderProgram(ret);return ret}ResetLastProgram(){this._lastProgram=null}SetSize(w,h,force){if(this._width===w&&this._height===h&&!force)return;this.EndBatch();const gl=this._gl;const batchState=this._batchState;this._width=w;this._height=h;const viewW=this.GetScissoredViewportWidth();const viewH=this.GetScissoredViewportHeight();this._UpdateViewportRenderer(viewW,viewH,this._width,this._height);this._UpdateViewportBatch(viewW,viewH,this._matP);if(this._spDeviceTransformTextureFill){gl.useProgram(this._spDeviceTransformTextureFill.GetShaderProgram());
this._spDeviceTransformTextureFill._UpdateDeviceTransformUniforms(this._matP);this._lastProgram=this._spDeviceTransformTextureFill;this._batchState.currentShader=this._spDeviceTransformTextureFill}gl.bindTexture(gl.TEXTURE_2D,null);gl.activeTexture(gl.TEXTURE1);gl.bindTexture(gl.TEXTURE_2D,null);gl.activeTexture(gl.TEXTURE0);this._lastTexture0=null;this._lastTexture1=null;if(this._usesDepthBuffer&&this._isAutoSizeDepthBuffer)this._SetDepthBufferSize(this._width,this._height);if(this._currentRenderTarget)this._currentRenderTarget._Resize(this._width,
this._height);gl.bindFramebuffer(gl.FRAMEBUFFER,null);this._currentRenderTarget=null;batchState.currentFramebuffer=null}_SetDepthBufferSize(width,height){const gl=this._gl;if(this._depthBuffer){if(this._depthBufferWidth===width&&this._depthBufferHeight===height)return;gl.deleteRenderbuffer(this._depthBuffer)}this._depthBuffer=gl.createRenderbuffer();gl.bindRenderbuffer(gl.RENDERBUFFER,this._depthBuffer);gl.renderbufferStorage(gl.RENDERBUFFER,this._version>=2?gl.DEPTH_COMPONENT24:gl.DEPTH_COMPONENT16,
width,height);gl.bindRenderbuffer(gl.RENDERBUFFER,null);this._depthBufferWidth=width;this._depthBufferHeight=height}SetFixedSizeDepthBuffer(width,height){if(!this._usesDepthBuffer)return;this._isAutoSizeDepthBuffer=false;this._SetDepthBufferSize(width,height)}SetAutoSizeDepthBuffer(){if(!this._usesDepthBuffer)return;this._isAutoSizeDepthBuffer=true;this._SetDepthBufferSize(this._width,this._height)}_UpdateViewportRenderer(viewW,viewH,surfaceW,surfaceH){this._cam[2]=100;mat4.lookAt(this._matMV,this._cam,
this._look,this._up);const fovY=45;const aspect=viewW/viewH;const zNear=this.GetNearZ();mat4.perspective(this._matP,fovY,aspect,zNear,this.GetFarZ());const tl=[0,0];const br=[0,0];const dpr=self.devicePixelRatio;this.Project(0,0,viewW,viewH,tl);this.Project(1,1,viewW,viewH,br);this._worldScale[0]=dpr/(br[0]-tl[0]);this._worldScale[1]=-dpr/(br[1]-tl[1]);this._lastBackbufferWidth=surfaceW;this._lastBackbufferHeight=surfaceH}_UpdateViewportBatch(viewW,viewH,matP){const gl=this._gl;const batchState=this._batchState;
gl.viewport(0,0,viewW,viewH);const allShaderPrograms=this._allShaderPrograms;const currentShader=batchState.currentShader;for(let i=0,len=allShaderPrograms.length;i<len;++i){const s=allShaderPrograms[i];if(s===currentShader)s.UpdateMatP(matP,true);else s.SetMatPStale()}mat4.copy(batchState.currentMatP,matP)}SetViewportScissor(w,h){const gl=this._gl;if(this._width===w&&this._height===h){if(this._isScissorViewport){this.EndBatch();gl.disable(gl.SCISSOR_TEST);this._isScissorViewport=false;this._viewportScissorWidth=
-1;this._viewportScissorHeight=-1;this.SetSize(this._width,this._height,true)}return}if(!this._isScissorViewport){this.EndBatch();gl.enable(gl.SCISSOR_TEST);this._isScissorViewport=true}if(this._viewportScissorWidth!==w||this._viewportScissorHeight!==h){this.EndBatch();gl.scissor(0,0,w,h);this._viewportScissorWidth=w;this._viewportScissorHeight=h;this.SetSize(this._width,this._height,true)}}RemoveViewportScissor(){const gl=this._gl;if(this._isScissorViewport){this.EndBatch();gl.disable(gl.SCISSOR_TEST);
this._isScissorViewport=false}this._viewportScissorWidth=-1;this._viewportScissorHeight=-1}GetScissoredViewportWidth(){if(this._isScissorViewport)return this._viewportScissorWidth;else return this.GetWidth()}GetScissoredViewportHeight(){if(this._isScissorViewport)return this._viewportScissorHeight;else return this.GetHeight()}UpdateModelView(){if(C3.Gfx.AreMat4sEqual(this._lastMV,this._matMV))return;const b=this.PushBatch();b.InitUpdateModelView(this._matMV);mat4.copy(this._lastMV,this._matMV);this._topOfBatch=
0}GetBatchState(){return this._batchState}PushBatch(){const batch=this._batch;if(this._batchPtr===batch.length)batch.push(new C3.Gfx.WebGLBatchJob(this._batchState));return batch[this._batchPtr++]}EndBatch(){if(this._batchPtr===0)return;if(this.IsContextLost())return;this._WriteBuffers();this._ExecuteBatch();this._batchPtr=0;this._vertexPtr=0;this._texPtr=0;this._pointPtr=0;this._topOfBatch=0}_WriteBuffers(){const gl=this._gl;if(this._pointPtr>0){gl.bindBuffer(gl.ARRAY_BUFFER,this._pointBuffer);gl.bufferSubData(gl.ARRAY_BUFFER,
0,this._pointData.subarray(0,this._pointPtr))}if(this._vertexPtr>0){gl.bindBuffer(gl.ARRAY_BUFFER,this._vertexBuffer);gl.bufferSubData(gl.ARRAY_BUFFER,0,this._vertexData.subarray(0,this._vertexPtr));gl.bindBuffer(gl.ARRAY_BUFFER,this._texcoordBuffer);gl.bufferSubData(gl.ARRAY_BUFFER,0,this._texcoordData.subarray(0,this._texPtr))}}_ExecuteBatch(){const batch=this._batch;for(let i=0,len=this._batchPtr;i<len;++i)batch[i].Run()}GetOpacity(){return this._lastColor.getA()}SetColorRgba(r,g,b,a){const lastColor=
this._lastColor;if(lastColor.equalsRgba(r,g,b,a))return;lastColor.setRgba(r,g,b,a);const batch=this.PushBatch();batch.InitSetColor(lastColor);this._topOfBatch=0;this._currentStateGroup=null}SetOpacity(a){const lastColor=this._lastColor;if(lastColor.getA()===a)return;lastColor.setA(a);const batch=this.PushBatch();batch.InitSetColor(lastColor);this._topOfBatch=0;this._currentStateGroup=null}SetColor(c){const lastColor=this._lastColor;if(lastColor.equals(c))return;lastColor.set(c);const batch=this.PushBatch();
batch.InitSetColor(lastColor);this._topOfBatch=0;this._currentStateGroup=null}ResetColor(){this.SetColorRgba(1,1,1,1)}GetColor(){return this._lastColor}SetTexture(rendererTex){if(rendererTex===this._lastTexture0)return;const b=this.PushBatch();b.InitSetTexture(rendererTex);this._lastTexture0=rendererTex;this._topOfBatch=0}_ResetLastTexture(){this._lastTexture0=null}SetBlendMode(bm){const arr=this._GetBlendByIndex(bm);this._SetBlend(arr[0],arr[1])}SetNamedBlendMode(bm){const o=this.GetNamedBlend(bm);
this._SetBlend(o.srcBlend,o.destBlend)}_SetBlend(s,d){if(s===this._lastSrcBlend&&d===this._lastDestBlend)return;const b=this.PushBatch();b.InitSetBlend(s,d);this._lastSrcBlend=s;this._lastDestBlend=d;this._topOfBatch=0;this._currentStateGroup=null}IsPremultipliedAlphaBlend(){return this._lastSrcBlend===this._gl.ONE&&this._lastDestBlend===this._gl.ONE_MINUS_SRC_ALPHA}SetAlphaBlend(){this._SetBlend(this._gl.ONE,this._gl.ONE_MINUS_SRC_ALPHA)}SetNoPremultiplyAlphaBlend(){this._SetBlend(this._gl.SRC_ALPHA,
this._gl.ONE_MINUS_SRC_ALPHA)}SetCopyBlend(){this._SetBlend(this._gl.ONE,this._gl.ZERO)}Rect(r){this.Rect2(r.getLeft(),r.getTop(),r.getRight(),r.getBottom())}Rect2(left,top,right,bottom){this.Quad2(left,top,right,top,right,bottom,left,bottom)}_ExtendQuadBatch(){let v=this._vertexPtr;if(v>=this._lastVertexPtr){this.EndBatch();v=0}if(this._topOfBatch===1)this._batch[this._batchPtr-1]._indexCount+=6;else{const b=this.PushBatch();b.InitQuad(v,6);this._topOfBatch=1}}_WriteQuadToVertexBuffer(quad){quad.writeToTypedArray3D(this._vertexData,
this._vertexPtr,this._baseZ+this._currentZ);this._vertexPtr+=12}Quad(quad){this._ExtendQuadBatch();this._WriteQuadToVertexBuffer(quad);defaultTexCoordsQuad.writeToTypedArray(this._texcoordData,this._texPtr);this._texPtr+=8}Quad2(tlx,tly,trx,try_,brx,bry,blx,bly){this._ExtendQuadBatch();const vd=this._vertexData;let v=this._vertexPtr;const z=this._baseZ+this._currentZ;vd[v++]=tlx;vd[v++]=tly;vd[v++]=z;vd[v++]=trx;vd[v++]=try_;vd[v++]=z;vd[v++]=brx;vd[v++]=bry;vd[v++]=z;vd[v++]=blx;vd[v++]=bly;vd[v++]=
z;this._vertexPtr=v;defaultTexCoordsQuad.writeToTypedArray(this._texcoordData,this._texPtr);this._texPtr+=8}Quad3(quad,rcTex){this._ExtendQuadBatch();this._WriteQuadToVertexBuffer(quad);rcTex.writeAsQuadToTypedArray(this._texcoordData,this._texPtr);this._texPtr+=8}Quad4(quad,uv){this._ExtendQuadBatch();this._WriteQuadToVertexBuffer(quad);uv.writeToTypedArray(this._texcoordData,this._texPtr);this._texPtr+=8}Quad3D(tlx,tly,tlz,trx,try_,trz,brx,bry,brz,blx,bly,blz,rcTex){this._ExtendQuadBatch();const vd=
this._vertexData;let v=this._vertexPtr;const z=this._baseZ+this._currentZ;vd[v++]=tlx;vd[v++]=tly;vd[v++]=z+tlz;vd[v++]=trx;vd[v++]=try_;vd[v++]=z+trz;vd[v++]=brx;vd[v++]=bry;vd[v++]=z+brz;vd[v++]=blx;vd[v++]=bly;vd[v++]=z+blz;this._vertexPtr=v;rcTex.writeAsQuadToTypedArray(this._texcoordData,this._texPtr);this._texPtr+=8}Quad3D2(tlx,tly,tlz,trx,try_,trz,brx,bry,brz,blx,bly,blz,uv){this._ExtendQuadBatch();const vd=this._vertexData;let v=this._vertexPtr;const z=this._baseZ+this._currentZ;vd[v++]=tlx;
vd[v++]=tly;vd[v++]=z+tlz;vd[v++]=trx;vd[v++]=try_;vd[v++]=z+trz;vd[v++]=brx;vd[v++]=bry;vd[v++]=z+brz;vd[v++]=blx;vd[v++]=bly;vd[v++]=z+blz;this._vertexPtr=v;uv.writeToTypedArray(this._texcoordData,this._texPtr);this._texPtr+=8}FullscreenQuad(mode,curTex){mat4.copy(tmpMat4,this._lastMV);vec3.copy(tmpVec3,this._cam);vec3.copy(tmpVec3b,this._look);this._cam[0]=0;this._cam[1]=0;this._cam[2]=100*self.devicePixelRatio;this._look[0]=0;this._look[1]=0;this._look[2]=0;this.ResetModelView();this.UpdateModelView();
if(this._isScissorViewport){const left=this._viewportScissorWidth/2;const top=this._viewportScissorHeight/2;tmpRect.set(-left,top,-left+this._viewportScissorWidth,top-this._viewportScissorHeight);tmpQuad.setFromRect(tmpRect);tmpRect.set(0,0,this._viewportScissorWidth/this._width,this._viewportScissorHeight/this._height);this.Quad3(tmpQuad,tmpRect)}else if(mode==="crop"&&this._currentRenderTarget&&curTex){const left=this._width/2;const top=this._height/2;const srcW=curTex.GetWidth();const srcH=curTex.GetHeight();
const destW=this._currentRenderTarget.GetWidth();const destH=this._currentRenderTarget.GetHeight();const copyW=Math.min(destW,srcW);const copyH=Math.min(destH,srcH);const srcOffY=Math.max(srcH-destH,0);const destOffY=Math.max(destH-srcH,0);tmpRect.set(-left,top-destOffY,-left+copyW,top-copyH-destOffY);tmpQuad.setFromRect(tmpRect);tmpRect.set(0,srcOffY,copyW,copyH+srcOffY);tmpRect.divide(srcW,srcH);this.Quad3(tmpQuad,tmpRect)}else{let [width,height]=this.GetRenderTargetSize(this._currentRenderTarget);
const halfW=width/2;const halfH=height/2;this.Rect2(-halfW,halfH,halfW,-halfH)}mat4.copy(this._matMV,tmpMat4);vec3.copy(this._cam,tmpVec3);vec3.copy(this._look,tmpVec3b);this.UpdateModelView()}ConvexPoly(pts){const pts_count=pts.length/2;if(pts_count<3)throw new Error("need at least 3 points");const tris=pts_count-2;const last_tri=tris-1;const p0x=pts[0];const p0y=pts[1];for(let i=0;i<tris;i+=2){const i2=i*2;const p1x=pts[i2+2];const p1y=pts[i2+3];const p2x=pts[i2+4];const p2y=pts[i2+5];if(i===last_tri)this.Quad2(p0x,
p0y,p1x,p1y,p2x,p2y,p2x,p2y);else{const p3x=pts[i2+6];const p3y=pts[i2+7];this.Quad2(p0x,p0y,p1x,p1y,p2x,p2y,p3x,p3y)}}}Line(x1,y1,x2,y2){const a=C3.angleTo(x1,y1,x2,y2);const sin_a=Math.sin(a);const cos_a=Math.cos(a);const halfLineWidth=this._lineWidth*.5;const sin_a_hlw=sin_a*halfLineWidth;const cos_a_hlw=cos_a*halfLineWidth;const lineCap=this._lineCap;if(lineCap===2)this.LinePreCalc_LineCap2(x1,y1,0,x2,y2,0,sin_a_hlw,cos_a_hlw);else if(lineCap===1)this.LinePreCalc_LineCap1(x1,y1,0,x2,y2,0,sin_a_hlw,
cos_a_hlw);else this.LinePreCalc_LineCap0(x1,y1,0,x2,y2,0,sin_a_hlw,cos_a_hlw)}Line3D(x1,y1,z1,x2,y2,z2){const a=C3.angleTo(x1,y1,x2,y2);const sin_a=Math.sin(a);const cos_a=Math.cos(a);const halfLineWidth=this._lineWidth*.5;const sin_a_hlw=sin_a*halfLineWidth;const cos_a_hlw=cos_a*halfLineWidth;const lineCap=this._lineCap;if(lineCap===2)this.LinePreCalc_LineCap2(x1,y1,z1,x2,y2,z2,sin_a_hlw,cos_a_hlw);else if(lineCap===1)this.LinePreCalc_LineCap1(x1,y1,z1,x2,y2,z2,sin_a_hlw,cos_a_hlw);else this.LinePreCalc_LineCap0(x1,
y1,z1,x2,y2,z2,sin_a_hlw,cos_a_hlw)}LinePreCalc_LineCap2(x1,y1,z1,x2,y2,z2,sin_a_hlw,cos_a_hlw){const lineOffset=this._lineOffset;const startX=x1+lineOffset-cos_a_hlw;const startY=y1+lineOffset-sin_a_hlw;const endX=x2+lineOffset+cos_a_hlw;const endY=y2+lineOffset+sin_a_hlw;const cos_a_lw=cos_a_hlw*2;const sin_a_lw=sin_a_hlw*2;const tlx=startX+sin_a_hlw;const tly=startY-cos_a_hlw;const blx=startX-sin_a_hlw+cos_a_lw;const bly=startY+cos_a_hlw+sin_a_lw;const trx=endX+sin_a_hlw;const try_=endY-cos_a_hlw;
const brx=endX-sin_a_hlw-cos_a_lw;const bry=endY+cos_a_hlw-sin_a_lw;this.Quad3D2(tlx,tly,z1,trx,try_,z2,brx,bry,z2,blx,bly,z1,defaultTexCoordsQuad)}LinePreCalc_LineCap1(x1,y1,z1,x2,y2,z2,sin_a_hlw,cos_a_hlw){const lineOffset=this._lineOffset;const startX=x1+lineOffset-cos_a_hlw;const startY=y1+lineOffset-sin_a_hlw;const endX=x2+lineOffset+cos_a_hlw;const endY=y2+lineOffset+sin_a_hlw;const tlx=startX+sin_a_hlw;const tly=startY-cos_a_hlw;const blx=startX-sin_a_hlw;const bly=startY+cos_a_hlw;const trx=
endX+sin_a_hlw;const try_=endY-cos_a_hlw;const brx=endX-sin_a_hlw;const bry=endY+cos_a_hlw;this.Quad3D2(tlx,tly,z1,trx,try_,z2,brx,bry,z2,blx,bly,z1,defaultTexCoordsQuad)}LinePreCalc_LineCap0(x1,y1,z1,x2,y2,z2,sin_a_hlw,cos_a_hlw){const lineOffset=this._lineOffset;const startX=x1+lineOffset;const startY=y1+lineOffset;const endX=x2+lineOffset;const endY=y2+lineOffset;const tlx=startX+sin_a_hlw;const tly=startY-cos_a_hlw;const blx=startX-sin_a_hlw;const bly=startY+cos_a_hlw;const trx=endX+sin_a_hlw;
const try_=endY-cos_a_hlw;const brx=endX-sin_a_hlw;const bry=endY+cos_a_hlw;this.Quad3D2(tlx,tly,z1,trx,try_,z2,brx,bry,z2,blx,bly,z1,defaultTexCoordsQuad)}TexturedLine(x1,y1,x2,y2,u,v){const a=C3.angleTo(x1,y1,x2,y2);const sin_a=Math.sin(a);const cos_a=Math.cos(a);const halfLineWidth=this._lineWidth*.5;const sin_a_hlw=sin_a*halfLineWidth;const cos_a_hlw=cos_a*halfLineWidth;const lineCap=this._lineCap;if(lineCap===2)this.TexturedLinePreCalc_LineCap2(x1,y1,x2,y2,sin_a_hlw,cos_a_hlw,u,v);else if(lineCap===
1)this.TexturedLinePreCalc_LineCap1(x1,y1,x2,y2,sin_a_hlw,cos_a_hlw,u,v);else this.TexturedLinePreCalc_LineCap0(x1,y1,x2,y2,sin_a_hlw,cos_a_hlw,u,v)}TexturedLinePreCalc_LineCap2(x1,y1,x2,y2,sin_a_hlw,cos_a_hlw,u,v){const lineOffset=this._lineOffset;const startX=x1+lineOffset-cos_a_hlw;const startY=y1+lineOffset-sin_a_hlw;const endX=x2+lineOffset+cos_a_hlw;const endY=y2+lineOffset+sin_a_hlw;const cos_a_lw=cos_a_hlw*2;const sin_a_lw=sin_a_hlw*2;const tlx=startX+sin_a_hlw;const tly=startY-cos_a_hlw;
const blx=startX-sin_a_hlw+cos_a_lw;const bly=startY+cos_a_hlw+sin_a_lw;const trx=endX+sin_a_hlw;const try_=endY-cos_a_hlw;const brx=endX-sin_a_hlw-cos_a_lw;const bry=endY+cos_a_hlw-sin_a_lw;tmpQuad.set(tlx,tly,trx,try_,brx,bry,blx,bly);tmpRect.set(u,0,v,0);this.Quad3(tmpQuad,tmpRect)}TexturedLinePreCalc_LineCap1(x1,y1,x2,y2,sin_a_hlw,cos_a_hlw,u,v){const lineOffset=this._lineOffset;const startX=x1+lineOffset-cos_a_hlw;const startY=y1+lineOffset-sin_a_hlw;const endX=x2+lineOffset+cos_a_hlw;const endY=
y2+lineOffset+sin_a_hlw;const tlx=startX+sin_a_hlw;const tly=startY-cos_a_hlw;const blx=startX-sin_a_hlw;const bly=startY+cos_a_hlw;const trx=endX+sin_a_hlw;const try_=endY-cos_a_hlw;const brx=endX-sin_a_hlw;const bry=endY+cos_a_hlw;tmpQuad.set(tlx,tly,trx,try_,brx,bry,blx,bly);tmpRect.set(u,0,v,0);this.Quad3(tmpQuad,tmpRect)}TexturedLinePreCalc_LineCap0(x1,y1,x2,y2,sin_a_hlw,cos_a_hlw,u,v){const lineOffset=this._lineOffset;const startX=x1+lineOffset;const startY=y1+lineOffset;const endX=x2+lineOffset;
const endY=y2+lineOffset;const tlx=startX+sin_a_hlw;const tly=startY-cos_a_hlw;const blx=startX-sin_a_hlw;const bly=startY+cos_a_hlw;const trx=endX+sin_a_hlw;const try_=endY-cos_a_hlw;const brx=endX-sin_a_hlw;const bry=endY+cos_a_hlw;tmpQuad.set(tlx,tly,trx,try_,brx,bry,blx,bly);tmpRect.set(u,0,v,0);this.Quad3(tmpQuad,tmpRect)}LineRect(left,top,right,bottom){const halfLineWidth=this._lineWidth*.5;const lineCap=this._lineCap;if(lineCap===2)this._LineRectPreCalc_LineCap2(left,top,right,bottom,halfLineWidth);
else if(lineCap===1)this._LineRectPreCalc_LineCap1(left,top,right,bottom,halfLineWidth);else this._LineRectPreCalc_LineCap0(left,top,right,bottom,halfLineWidth)}_LineRectPreCalc_LineCap2(left,top,right,bottom,halfLineWidth){this.LinePreCalc_LineCap2(left,top,0,right,top,0,0,halfLineWidth);this.LinePreCalc_LineCap2(right,top,0,right,bottom,0,halfLineWidth,0);this.LinePreCalc_LineCap2(right,bottom,0,left,bottom,0,0,-halfLineWidth);this.LinePreCalc_LineCap2(left,bottom,0,left,top,0,-halfLineWidth,0)}_LineRectPreCalc_LineCap1(left,
top,right,bottom,halfLineWidth){this.LinePreCalc_LineCap1(left,top,0,right,top,0,0,halfLineWidth);this.LinePreCalc_LineCap1(right,top,0,right,bottom,0,halfLineWidth,0);this.LinePreCalc_LineCap1(right,bottom,0,left,bottom,0,0,-halfLineWidth);this.LinePreCalc_LineCap1(left,bottom,0,left,top,0,-halfLineWidth,0)}_LineRectPreCalc_LineCap0(left,top,right,bottom,halfLineWidth){this.LinePreCalc_LineCap0(left,top,0,right,top,0,0,halfLineWidth);this.LinePreCalc_LineCap0(right,top,0,right,bottom,0,halfLineWidth,
0);this.LinePreCalc_LineCap0(right,bottom,0,left,bottom,0,0,-halfLineWidth);this.LinePreCalc_LineCap0(left,bottom,0,left,top,0,-halfLineWidth,0)}LineRect2(r){this.LineRect(r.getLeft(),r.getTop(),r.getRight(),r.getBottom())}LineQuad(q){const a=C3.angleTo(q.getTlx(),q.getTly(),q.getTrx(),q.getTry());const sin_a=Math.sin(a);const cos_a=Math.cos(a);const halfLineWidth=this._lineWidth*.5;const sin_a_hlw=sin_a*halfLineWidth;const cos_a_hlw=cos_a*halfLineWidth;const lineCap=this._lineCap;if(lineCap===2)this._LineQuadPreCalc_LineCap2(q,
sin_a_hlw,cos_a_hlw);else if(lineCap===1)this._LineQuadPreCalc_LineCap1(q,sin_a_hlw,cos_a_hlw);else this._LineQuadPreCalc_LineCap0(q,sin_a_hlw,cos_a_hlw)}_LineQuadPreCalc_LineCap2(q,sin_a_hlw,cos_a_hlw){this.LinePreCalc_LineCap2(q.getTlx(),q.getTly(),0,q.getTrx(),q.getTry(),0,sin_a_hlw,cos_a_hlw);this.LinePreCalc_LineCap2(q.getTrx(),q.getTry(),0,q.getBrx(),q.getBry(),0,cos_a_hlw,-sin_a_hlw);this.LinePreCalc_LineCap2(q.getBrx(),q.getBry(),0,q.getBlx(),q.getBly(),0,-sin_a_hlw,-cos_a_hlw);this.LinePreCalc_LineCap2(q.getBlx(),
q.getBly(),0,q.getTlx(),q.getTly(),0,-cos_a_hlw,sin_a_hlw)}_LineQuadPreCalc_LineCap1(q,sin_a_hlw,cos_a_hlw){this.LinePreCalc_LineCap1(q.getTlx(),q.getTly(),0,q.getTrx(),q.getTry(),0,sin_a_hlw,cos_a_hlw);this.LinePreCalc_LineCap1(q.getTrx(),q.getTry(),0,q.getBrx(),q.getBry(),0,cos_a_hlw,-sin_a_hlw);this.LinePreCalc_LineCap1(q.getBrx(),q.getBry(),0,q.getBlx(),q.getBly(),0,-sin_a_hlw,-cos_a_hlw);this.LinePreCalc_LineCap1(q.getBlx(),q.getBly(),0,q.getTlx(),q.getTly(),0,-cos_a_hlw,sin_a_hlw)}_LineQuadPreCalc_LineCap0(q,
sin_a_hlw,cos_a_hlw){this.LinePreCalc_LineCap0(q.getTlx(),q.getTly(),0,q.getTrx(),q.getTry(),0,sin_a_hlw,cos_a_hlw);this.LinePreCalc_LineCap0(q.getTrx(),q.getTry(),0,q.getBrx(),q.getBry(),0,cos_a_hlw,-sin_a_hlw);this.LinePreCalc_LineCap0(q.getBrx(),q.getBry(),0,q.getBlx(),q.getBly(),0,-sin_a_hlw,-cos_a_hlw);this.LinePreCalc_LineCap0(q.getBlx(),q.getBly(),0,q.getTlx(),q.getTly(),0,-cos_a_hlw,sin_a_hlw)}SetLineWidth(n){this._lineWidth=n;this._lineWidthStack[this._lineWidthStack.length-1]=n}GetLineWidth(){return this._lineWidth}PushLineWidth(n){if(this._lineWidthStack.length>=
100)throw new Error("pushed too many line widths - check push/pop pairs");this._lineWidthStack.push(n);this._lineWidth=n}PopLineWidth(){if(this._lineWidthStack.length<=1)throw new Error("cannot pop last line width - check push/pop pairs");this._lineWidthStack.pop();this._lineWidth=this._lineWidthStack[this._lineWidthStack.length-1]}SetLineCapButt(){this._lineCap=0;this._lineCapStack[this._lineCapStack.length-1]=0}SetLineCapSquare(){this._lineCap=1;this._lineCapStack[this._lineCapStack.length-1]=0}SetLineCapZag(){this._lineCap=
2;this._lineCapStack[this._lineCapStack.length-1]=0}PushLineCap(type){if(type==="butt")this.PushLineCapButt();else if(type==="square")this.PushLineCapSquare();else if(type==="zag")this.PushLineCapZag();else throw new Error("invalid line cap");}PushLineCapButt(){if(this._lineCapStack.length>=100)throw new Error("pushed too many line caps - check push/pop pairs");this._lineCapStack.push(0);this._lineCap=0}PushLineCapSquare(){if(this._lineCapStack.length>=100)throw new Error("pushed too many line caps - check push/pop pairs");
this._lineCapStack.push(1);this._lineCap=1}PushLineCapZag(){if(this._lineCapStack.length>=100)throw new Error("pushed too many line caps - check push/pop pairs");this._lineCapStack.push(2);this._lineCap=2}PopLineCap(){if(this._lineCapStack.length<=1)throw new Error("cannot pop last line cap - check push/pop pairs");this._lineCapStack.pop();this._lineCap=this._lineCapStack[this._lineCapStack.length-1]}SetLineOffset(n){this._lineOffset=n;this._lineOffsetStack[this._lineOffsetStack.length-1]=n}GetLineOffset(){return this._lineOffset}PushLineOffset(n){if(this._lineOffsetStack.length>=
100)throw new Error("pushed too many line offsets - check push/pop pairs");this._lineOffsetStack.push(n);this._lineOffset=n}PopLineOffset(){if(this._lineOffsetStack.length<=1)throw new Error("cannot pop last line offset - check push/pop pairs");this._lineOffsetStack.pop();this._lineOffset=this._lineOffsetStack[this._lineOffsetStack.length-1]}StartRenderingPoints(rect){if(this._lastPointTexCoords.equals(rect))return;this._lastPointTexCoords.copy(rect);const b=this.PushBatch();b.InitSetPointTexCoords(rect);
this._topOfBatch=0}FinishRenderingPoints(){}Point(x_,y_,size_,opacity_){if(this._pointPtr>=LAST_POINT)this.EndBatch();let p=this._pointPtr;const z=this._baseZ+this._currentZ;if(this._topOfBatch===2&&this._lastPointZ===z)this._batch[this._batchPtr-1]._indexCount++;else{const b=this.PushBatch();b.InitPoints(p,z);this._topOfBatch=2;this._lastPointZ=z}const pd=this._pointData;pd[p++]=x_;pd[p++]=y_;pd[p++]=size_;pd[p++]=opacity_;this._pointPtr=p}SetProgram(program){if(this._lastProgram===program)return;
const b=this.PushBatch();b.InitSetProgram(program);this._lastProgram=program;this._topOfBatch=0;this._currentStateGroup=null}SetDeviceTransformTextureFillMode(){this.SetProgram(this._spDeviceTransformTextureFill)}SetGradientColor(c){const b=this.PushBatch();b.InitSetGradientColor(c);this._topOfBatch=0}SetEllipseParams(pixelW,pixelH,outlineThickness=1){const b=this.PushBatch();b.InitSetEllipseParams(pixelW,pixelH,outlineThickness);this._topOfBatch=0}SetTilemapInfo(srcRect,textureWidth,textureHeight,
tileWidth,tileHeight,tileSpacingX,tileSpacingY){if(this._lastProgram!==this._spTilemapFill)throw new Error("must set tilemap fill mode first");const b=this.PushBatch();b.InitSetTilemapInfo(srcRect,textureWidth,textureHeight,tileWidth,tileHeight,tileSpacingX,tileSpacingY);this._topOfBatch=0}SetProgramParameters(backTex,destRect,srcRect,srcOriginRect,layoutRect,pixelWidth,pixelHeight,layerScale,layerAngle,time,params){const s=this._lastProgram;const hasAnyOptionalUniforms=s._hasAnyOptionalUniforms;
const hasAnyCustomParams=!!params.length;if((!hasAnyOptionalUniforms||s.AreOptionalUniformsAlreadySetInBatch(destRect,srcRect,srcOriginRect,layoutRect,pixelWidth,pixelHeight,layerScale,layerAngle,time))&&(!hasAnyCustomParams||s.AreCustomParametersAlreadySetInBatch(params)))return;const b=this.PushBatch();b.InitSetProgramParameters();if(hasAnyOptionalUniforms){s.SetOptionalUniformsInBatch(destRect,srcRect,srcOriginRect,layoutRect,pixelWidth,pixelHeight,layerScale,layerAngle,time);const mat4param=b._mat4param;
mat4param[0]=pixelWidth;mat4param[1]=pixelHeight;destRect.writeToTypedArray(mat4param,2);mat4param[6]=layerScale;mat4param[7]=layerAngle;srcRect.writeToTypedArray(mat4param,12);const colorParam=b._colorParam;layoutRect.writeToTypedArray(colorParam,0);const tmp=colorParam[1];colorParam[1]=colorParam[3];colorParam[3]=tmp;srcOriginRect.writeToTypedArray(b._srcOriginRect,0);b._startIndex=time;if(s._uSamplerBack.IsUsed())b._texParam=backTex?backTex.GetTexture():null;else b._texParam=null}if(hasAnyCustomParams){s.SetCustomParametersInBatch(params);
C3.shallowAssignArray(b._shaderParams,params)}this._topOfBatch=0}ClearRgba(r,g,b_,a){const b=this.PushBatch();b.InitClearSurface2(r,g,b_,a);this._topOfBatch=0}Clear(c){const b=this.PushBatch();b.InitClearSurface(c);this._topOfBatch=0}ClearRect4(x,y,w,h,r,g,b,a){if(w<0||h<0)return;const batch=this.PushBatch();batch.InitClearRect(x,y,w,h,r,g,b,a);this._topOfBatch=0}Start(){}Finish(){super.Finish();this._gl.flush()}ClearDepth(){if(!this._usesDepthBuffer||!this._currentRenderTarget||!this._currentRenderTarget.HasDepthBuffer())return;
const batch=this.PushBatch();batch.InitClearDepth();this._topOfBatch=0}SetDepthEnabled(e){e=!!e;if(this._isDepthEnabled===e)return;if(!this._usesDepthBuffer)return;this._isDepthEnabled=e;const batch=this.PushBatch();batch.InitSetDepthEnabled(e);this._topOfBatch=0}_GetDepthBuffer(){return this._depthBuffer}CheckForQueryResults(){for(const qrb of this._allQueryResultBuffers)qrb.CheckForResults(this._frameNumber)}IsContextLost(){return!this._gl||this._gl.isContextLost()||this._isInitialisingAfterContextRestored}OnContextLost(){super.OnDeviceOrContextLost();
C3.Gfx.WebGLRendererTexture.OnContextLost();C3.Gfx.WebGLRenderTarget.OnContextLost();C3.Gfx.RendererText.OnContextLost();for(const qrb of this._allQueryResultBuffers)qrb.Clear();this._extensions=[];this._timerExt=null;this._parallelShaderCompileExt=null;this._anisotropicExt=null;this._maxAnisotropy=0;this._unmaskedVendor="(unavailable)";this._unmaskedRenderer="(unavailable)";this._lastProgram=null;this._spDeviceTransformTextureFill=null;this._depthBuffer=null;for(const stateGroup of this._stateGroups.values())stateGroup.OnContextLost()}async OnContextRestored(){this._isInitialisingAfterContextRestored=
true;await this.InitState();this._isInitialisingAfterContextRestored=false;for(const stateGroup of this._stateGroups.values())stateGroup.OnContextRestored(this);this.SetSize(this._width,this._height,true)}CreateStaticTexture(data,opts){if(this.IsContextLost())throw new Error("context lost");this.EndBatch();const rendererTex=C3.New(C3.Gfx.WebGLRendererTexture,this);rendererTex._CreateStatic(data,opts);return rendererTex}CreateStaticTextureAsync(data,opts){if(this.IsContextLost())return Promise.reject("context lost");
opts=Object.assign({},opts);const isTiled=opts.wrapX&&opts.wrapX!=="clamp-to-edge"||opts.wrapY&&opts.wrapY!=="clamp-to-edge";if(C3.Supports.ImageBitmapOptions&&(this.SupportsNPOTTextures()||!isTiled)){opts.premultiplyAlpha=false;return createImageBitmap(data,{"premultiplyAlpha":"premultiply"}).then(imageBitmap=>C3.Asyncify(()=>this.CreateStaticTexture(imageBitmap,opts)))}else if(C3.Supports.ImageBitmap)return createImageBitmap(data).then(imageBitmap=>C3.Asyncify(()=>this.CreateStaticTexture(imageBitmap,
opts)));else if(data instanceof Blob)return C3.BlobToImage(data,true).then(img=>this.CreateStaticTextureAsync(img,opts));else if(typeof HTMLImageElement!=="undefined"&&data instanceof HTMLImageElement&&typeof data["decode"]==="function")return data["decode"]().then(()=>C3.Asyncify(()=>this.CreateStaticTexture(data,opts)));else return C3.Asyncify(()=>this.CreateStaticTexture(data,opts))}CreateDynamicTexture(width,height,opts){this.EndBatch();const rendererTex=C3.New(C3.Gfx.WebGLRendererTexture,this);
rendererTex._CreateDynamic(width,height,opts);return rendererTex}UpdateTexture(data,rendererTex,opts){this.EndBatch();rendererTex._Update(data,opts)}DeleteTexture(rendererTex){if(!rendererTex)return;rendererTex.SubtractReference();if(rendererTex.GetReferenceCount()>0)return;this.EndBatch();if(rendererTex===this._lastTexture0){this._gl.bindTexture(this._gl.TEXTURE_2D,null);this._lastTexture0=null}if(rendererTex===this._lastTexture1){this._gl.activeTexture(this._gl.TEXTURE1);this._gl.bindTexture(this._gl.TEXTURE_2D,
null);this._gl.activeTexture(this._gl.TEXTURE0);this._lastTexture1=null}rendererTex._Delete()}CreateRenderTarget(opts){let width=this._width;let height=this._height;let isDefaultSize=true;if(opts){if(typeof opts.width==="number"){width=opts.width;isDefaultSize=false}if(typeof opts.height==="number"){height=opts.height;isDefaultSize=false}}if(width<=0||height<=0)throw new Error("invalid size");this.EndBatch();const renderTarget=C3.New(C3.Gfx.WebGLRenderTarget,this);renderTarget._Create(width,height,
Object.assign({isDefaultSize},opts));this._currentRenderTarget=null;this._batchState.currentFramebuffer=null;return renderTarget}SetRenderTarget(renderTarget){if(renderTarget===this._currentRenderTarget)return;let newViewWidth,newViewHeight,newSurfaceWidth,newSurfaceHeight;if(renderTarget){if(renderTarget.IsDefaultSize())renderTarget._Resize(this._width,this._height);newSurfaceWidth=renderTarget.GetWidth();newSurfaceHeight=renderTarget.GetHeight();newViewWidth=newSurfaceWidth;newViewHeight=newSurfaceHeight}else{newSurfaceWidth=
this._width;newSurfaceHeight=this._height;newViewWidth=this.GetScissoredViewportWidth();newViewHeight=this.GetScissoredViewportHeight()}const didSurfaceSizeChange=this._lastBackbufferWidth!==newSurfaceWidth||this._lastBackbufferHeight!==newSurfaceHeight;if(didSurfaceSizeChange)this._UpdateViewportRenderer(newViewWidth,newViewHeight,newSurfaceWidth,newSurfaceHeight);const b=this.PushBatch();b.InitSetRenderTarget(renderTarget,didSurfaceSizeChange,this._matP);this._currentRenderTarget=renderTarget;this._topOfBatch=
0}GetRenderTarget(){return this._currentRenderTarget}GetRenderTargetSize(renderTarget){if(renderTarget)return[renderTarget.GetWidth(),renderTarget.GetHeight()];else return[this._width,this._height]}CopyRenderTarget(renderTarget,mode="stretch"){if(this._version<2||this._currentRenderTarget&&this._currentRenderTarget.GetMultisampling()>0){this.SetCopyBlend();this.ResetColor();this.DrawRenderTarget(renderTarget,mode)}else{const b=this.PushBatch();b.InitBlitFramebuffer(renderTarget,this._currentRenderTarget,
mode);this._topOfBatch=0}}DrawRenderTarget(renderTarget,mode="stretch"){const tex=renderTarget.GetTexture();if(!tex)throw new Error("not a texture-backed render target");this.SetTexture(tex);this.FullscreenQuad(mode,tex)}InvalidateRenderTarget(renderTarget){if(this._version<2)return;const b=this.PushBatch();b.InitInvalidateFramebuffer(renderTarget._GetFramebuffer());this._topOfBatch=0}DeleteRenderTarget(renderTarget){this.SetRenderTarget(null);this.EndBatch();const renderTex=renderTarget.GetTexture();
if(renderTex===this._lastTexture0){this._gl.bindTexture(this._gl.TEXTURE_2D,null);this._lastTexture0=null}if(renderTex===this._lastTexture1){this._gl.activeTexture(this._gl.TEXTURE1);this._gl.bindTexture(this._gl.TEXTURE_2D,null);this._gl.activeTexture(this._gl.TEXTURE0);this._lastTexture1=null}renderTarget._Delete()}async ReadBackRenderTargetToImageData(renderTarget,forceSynchronous,areaRect){this.EndBatch();const oldRenderTarget=this._currentRenderTarget;let width,height,framebuffer;if(renderTarget){width=
renderTarget.GetWidth();height=renderTarget.GetHeight();framebuffer=renderTarget._GetFramebuffer()}else{width=this.GetWidth();height=this.GetHeight();framebuffer=null}let x=0;let y=0;let areaWidth=width;let areaHeight=height;if(areaRect){x=C3.clamp(Math.floor(areaRect.getLeft()),0,width-1);y=C3.clamp(Math.floor(areaRect.getTop()),0,height-1);let w=areaRect.width();if(w===0)w=width-x;else w=C3.clamp(Math.floor(w),0,width-x);let h=areaRect.height();if(h===0)h=height-y;else h=C3.clamp(Math.floor(h),
0,height-y);areaWidth=w;areaHeight=h;y=height-(y+areaHeight)}const gl=this._gl;gl.bindFramebuffer(gl.FRAMEBUFFER,framebuffer);const restorePreviousRenderTarget=()=>{gl.bindFramebuffer(gl.FRAMEBUFFER,null);this._currentRenderTarget=null;this._batchState.currentFramebuffer=null;this.SetRenderTarget(oldRenderTarget)};let imageData;if(!forceSynchronous&&this.GetWebGLVersionNumber()>=2){gl.bindFramebuffer(gl.READ_FRAMEBUFFER,framebuffer);const pixelBuffer=gl.createBuffer();const bufferSize=areaWidth*areaHeight*
4;const PIXEL_PACK_BUFFER=gl["PIXEL_PACK_BUFFER"];gl.bindBuffer(PIXEL_PACK_BUFFER,pixelBuffer);gl.bufferData(PIXEL_PACK_BUFFER,bufferSize,gl["STREAM_READ"]);gl.readPixels(x,y,areaWidth,areaHeight,gl.RGBA,gl.UNSIGNED_BYTE,0);gl.bindFramebuffer(gl.READ_FRAMEBUFFER,null);gl.bindBuffer(PIXEL_PACK_BUFFER,null);restorePreviousRenderTarget();const sync=gl["fenceSync"](gl["SYNC_GPU_COMMANDS_COMPLETE"],0);await this._WaitForObjectReady(()=>gl["getSyncParameter"](sync,gl["SYNC_STATUS"])===gl["SIGNALED"]);gl["deleteSync"](sync);
imageData=new ImageData(areaWidth,areaHeight);gl.bindBuffer(PIXEL_PACK_BUFFER,pixelBuffer);gl["getBufferSubData"](PIXEL_PACK_BUFFER,0,new Uint8Array(imageData.data.buffer),0,bufferSize);gl.bindBuffer(PIXEL_PACK_BUFFER,null);gl.deleteBuffer(pixelBuffer)}else{imageData=new ImageData(areaWidth,areaHeight);gl.readPixels(x,y,areaWidth,areaHeight,gl.RGBA,gl.UNSIGNED_BYTE,new Uint8Array(imageData.data.buffer));restorePreviousRenderTarget()}return imageData}StartQuery(query){if(!this.SupportsGPUProfiling())return;
const b=this.PushBatch();b.InitStartQuery(query);this._topOfBatch=0}EndQuery(query){if(!this.SupportsGPUProfiling())return;const b=this.PushBatch();b.InitEndQuery(query);this._topOfBatch=0}_WaitForObjectReady(checkFunc){const ret=new Promise(resolve=>pendingPolls.add({resolve,checkFunc}));if(pollRafId===-1)pollRafId=self.requestAnimationFrame(CheckPendingPolls);return ret}IsDesynchronized(){return!!this._attribs["desynchronized"]}GetEstimatedBackBufferMemoryUsage(){return this._width*this._height*
(this._attribs["alpha"]?4:3)}GetEstimatedRenderBufferMemoryUsage(){let ret=0;for(const t of C3.Gfx.WebGLRenderTarget.allRenderTargets()){if(t.GetTexture())continue;ret+=t.GetEstimatedMemoryUsage()}return ret}GetEstimatedTextureMemoryUsage(){let ret=0;for(const t of C3.Gfx.WebGLRendererTexture.allTextures())ret+=t.GetEstimatedMemoryUsage();return ret}GetEstimatedTotalMemoryUsage(){return this.GetEstimatedBackBufferMemoryUsage()+this.GetEstimatedRenderBufferMemoryUsage()+this.GetEstimatedTextureMemoryUsage()}GetWebGLVersionString(){return this._versionString}GetWebGLVersionNumber(){return this._version}GetDisplayName(){return"webgl"+
this.GetWebGLVersionNumber()}SupportsNPOTTextures(){return this.GetWebGLVersionNumber()>=2}GetMaxTextureSize(){return this._maxTextureSize}GetMinPointSize(){return this._minPointSize}GetMaxPointSize(){return this._maxPointSize}SupportsHighP(){return this._highpPrecision!==0}GetHighPPrecision(){return this._highpPrecision}GetUnmaskedVendor(){return this._unmaskedVendor}GetUnmaskedRenderer(){return this._unmaskedRenderer}GetExtensions(){return this._extensions}HasMajorPerformanceCaveat(){return this._hasMajorPerformanceCaveat}SupportsGPUProfiling(){return!!this._timerExt}_GetDisjointTimerQueryExtension(){return this._timerExt}_GetParallelShaderCompileExtension(){return this._parallelShaderCompileExt}_GetAnisotropicExtension(){return this._anisotropicExt}_GetMaxAnisotropy(){return this._maxAnisotropy}_AddQueryResultBuffer(qrb){this._allQueryResultBuffers.add(qrb)}_RemoveQueryResultBuffer(qrb){this._allQueryResultBuffers.delete(qrb)}_GetTimeQueryStack(){return this._timeQueryStack}GetContext(){return this._gl}_InitBlendModes(gl){this._InitBlendModeData([["normal",
gl.ONE,gl.ONE_MINUS_SRC_ALPHA],["additive",gl.ONE,gl.ONE],["xor",gl.ONE,gl.ONE_MINUS_SRC_ALPHA],["copy",gl.ONE,gl.ZERO],["destination-over",gl.ONE_MINUS_DST_ALPHA,gl.ONE],["source-in",gl.DST_ALPHA,gl.ZERO],["destination-in",gl.ZERO,gl.SRC_ALPHA],["source-out",gl.ONE_MINUS_DST_ALPHA,gl.ZERO],["destination-out",gl.ZERO,gl.ONE_MINUS_SRC_ALPHA],["source-atop",gl.DST_ALPHA,gl.ONE_MINUS_SRC_ALPHA],["destination-atop",gl.ONE_MINUS_DST_ALPHA,gl.SRC_ALPHA]])}CreateRendererText(){return C3.New(C3.Gfx.RendererText,
this)}CreateWebGLText(){return this.CreateRendererText()}}};


// c3/interfaces/IRuntime.js
'use strict';{const C3=self.C3;const C3X=self.C3X;let runtime=null;const keysDownByKey=new Set;function SortZOrderList(a,b){const layerA=a[0];const layerB=b[0];const diff=layerA-layerB;if(diff!==0)return diff;const indexA=a[1];const indexB=b[1];return indexA-indexB}const tempZOrderList=[];const tempInstances=[];let didWarnInAlertPolyfill=false;self.IRuntime=class IRuntime{constructor(runtime_,objects){runtime=runtime_;Object.defineProperties(this,{assets:{value:runtime.GetAssetManager().GetIAssetManager(),
writable:false},objects:{value:objects,writable:false},globalVars:{value:{},writable:false},projectName:{value:runtime.GetProjectName(),writable:false},projectVersion:{value:runtime.GetProjectVersion(),writable:false},storage:{value:new self.IStorage(runtime),writable:false},isInWorker:{value:runtime.IsInWorker(),writable:false}});runtime.UserScriptDispatcher().addEventListener("keydown",e=>{if(keysDownByKey.has(e["key"])){e.stopPropagation();return}keysDownByKey.add(e["key"])});runtime.UserScriptDispatcher().addEventListener("keyup",
e=>keysDownByKey.delete(e["key"]));runtime.Dispatcher().addEventListener("window-blur",()=>keysDownByKey.clear());if(runtime.IsInWorker())self["alert"]=message=>{if(!didWarnInAlertPolyfill){didWarnInAlertPolyfill=true;console.warn("[Construct 3] alert() was called from a Web Worker, because the project 'Use worker' setting is enabled. This method is not normally available in a Web Worker. Construct has implemented the alert for you, but note that other features may be missing in worker mode. You may wish to disable 'Use worker', or use a more convenient function like console.log(). For more information please refer to the scripting section of the manual.")}return this.alert(message)}}_InitGlobalVars(globalVarDescriptors){Object.defineProperties(this.globalVars,
globalVarDescriptors)}addEventListener(name,func){runtime.UserScriptDispatcher().addEventListener(name,func)}removeEventListener(name,func){runtime.UserScriptDispatcher().removeEventListener(name,func)}callFunction(name,...params){C3X.RequireString(name);const eventSheetManager=runtime.GetEventSheetManager();const functionBlock=eventSheetManager.GetFunctionBlockByName(name);if(!functionBlock)throw new Error(`cannot find function name '${name}'`);if(!functionBlock.IsEnabled())return functionBlock.GetDefaultReturnValue();
if(params.length<functionBlock.GetFunctionParameterCount())throw new Error(`not enough function parameters passed for '${name}' (${params.length} passed, ${functionBlock.GetFunctionParameterCount()} expected)`);const callEventBlock=functionBlock.GetEventBlock();let solModifiers=null;const currentEvent=eventSheetManager.GetCurrentEvent();if(currentEvent){const sm=currentEvent.GetSolModifiersIncludingParents();if(sm.length>0){solModifiers=sm;eventSheetManager.PushCleanSol(sm)}}const ret=callEventBlock.RunAsExpressionFunctionCall(callEventBlock.GetSolModifiersIncludingParents(),
functionBlock.GetReturnType(),functionBlock.GetDefaultReturnValue(),...params);if(solModifiers)eventSheetManager.PopSol(solModifiers);return ret}setReturnValue(v){const frame=runtime.GetEventStack().GetCurrentExpFuncStackFrame();if(!frame)throw new Error("not in a function which returns a value");switch(frame.GetFunctionReturnType()){case 1:if(typeof v==="number")frame.SetFunctionReturnValue(v);break;case 2:if(typeof v==="string")frame.SetFunctionReturnValue(v);break;case 3:if(typeof v==="number"||
typeof v==="string")frame.SetFunctionReturnValue(v);break}}get dt(){return runtime.GetDt()}get gameTime(){return runtime.GetGameTime()}get wallTime(){return runtime.GetWallTime()}random(){return runtime.Random()}get layout(){return runtime.GetMainRunningLayout().GetILayout()}getLayout(nameOrIndex){const layoutManager=runtime.GetLayoutManager();let layout=null;if(typeof nameOrIndex==="number"||typeof nameOrIndex==="string")layout=layoutManager.GetLayout(nameOrIndex);else throw new TypeError("expected string or number");
if(!layout)throw new Error("invalid layout");return layout.GetILayout()}getAllLayouts(){return runtime.GetLayoutManager().GetAllLayouts().map(layout=>layout.GetILayout())}goToLayout(nameOrIndex){const layoutManager=runtime.GetLayoutManager();let layout=null;if(typeof nameOrIndex==="number"||typeof nameOrIndex==="string")layout=layoutManager.GetLayout(nameOrIndex);else throw new TypeError("expected string or number");if(!layout)throw new Error("invalid layout");if(layoutManager.IsPendingChangeMainLayout())return;
layoutManager.ChangeMainLayout(layout)}get keyboard(){const ret=runtime._GetCommonScriptInterfaces().keyboard;if(!ret)throw new Error("runtime.keyboard used but Keyboard object missing - add it to your project first");return ret}get mouse(){const ret=runtime._GetCommonScriptInterfaces().mouse;if(!ret)throw new Error("runtime.mouse used but Mouse object missing - add it to your project first");return ret}get touch(){const ret=runtime._GetCommonScriptInterfaces().touch;if(!ret)throw new Error("runtime.touch used but Touch object missing - add it to your project first");
return ret}invokeDownload(url,filename){C3X.RequireString(url);C3X.RequireString(filename);runtime.InvokeDownload(url,filename)}getInstanceByUid(uid){C3X.RequireFiniteNumber(uid);const ret=runtime.GetInstanceByUID(uid);return ret?ret.GetInterfaceClass():null}sortZOrder(iterable,callback){C3X.RequireFunction(callback);const layout=runtime.GetCurrentLayout();for(const iinst of iterable){const inst=runtime._UnwrapIWorldInstance(iinst);const wi=inst.GetWorldInfo();tempZOrderList.push([wi.GetLayer().GetIndex(),
wi.GetZIndex()]);tempInstances.push(inst)}if(tempZOrderList.length===0)return;tempZOrderList.sort(SortZOrderList);tempInstances.sort((a,b)=>callback(a.GetInterfaceClass(),b.GetInterfaceClass()));let anyChanged=false;for(let i=0,len=tempZOrderList.length;i<len;++i){const inst=tempInstances[i];const layer=layout.GetLayerByIndex(tempZOrderList[i][0]);const toZ=tempZOrderList[i][1];const layerInstances=layer._GetInstances();if(layerInstances[toZ]!==inst){layerInstances[toZ]=inst;inst.GetWorldInfo()._SetLayer(layer);
layer.SetZIndicesChanged();anyChanged=true}}if(anyChanged)runtime.UpdateRender();C3.clearArray(tempZOrderList);C3.clearArray(tempInstances)}alert(message){return runtime.PostComponentMessageToDOMAsync("runtime","alert",{"message":message+(runtime.IsInWorker()?" [via Web Worker]":"")})}}};


// c3/interfaces/IAssetManager.js
'use strict';{const C3=self.C3;const C3X=self.C3X;let assetManager=null;self.IAssetManager=class IAssetManager{constructor(assetManager_){assetManager=assetManager_;Object.defineProperties(this,{isWebMOpusSupported:{value:assetManager.IsAudioFormatSupported("audio/webm; codecs=opus"),writable:false}})}fetchText(url){return assetManager.FetchText(url)}fetchJson(url){return assetManager.FetchJson(url)}fetchBlob(url){return assetManager.FetchBlob(url)}fetchArrayBuffer(url){return assetManager.FetchArrayBuffer(url)}getProjectFileUrl(url){return assetManager.GetProjectFileUrl(url)}getMediaFileUrl(url){if(C3.IsRelativeURL(url))url=
url.toLowerCase();return assetManager.GetMediaFileUrl(url,assetManager.GetMediaSubfolder())}get mediaFolder(){return assetManager.GetMediaSubfolder()}async decodeWebMOpus(audioContext,arrayBuffer){if(this.isWebMOpusSupported)throw new Error("decodeWebMOpus(): not supported because WebM Opus is supported by the platform");const decodedArrayBuffer=await assetManager.GetRuntime()._WasmDecodeWebMOpus(arrayBuffer);const decodedFloats=new Float32Array(decodedArrayBuffer);const audioBuffer=audioContext["createBuffer"](1,
decodedFloats.length,48E3);const channelBuffer=audioBuffer["getChannelData"](0);channelBuffer.set(decodedFloats);return audioBuffer}loadScripts(...urls){return assetManager.LoadScripts(...urls)}compileWebAssembly(url){return assetManager.CompileWebAssembly(url)}loadStyleSheet(url){return assetManager.LoadStyleSheet(url)}}};


// c3/interfaces/IStorage.js
'use strict';{const C3=self.C3;const C3X=self.C3X;self.IStorage=class IStorage{constructor(runtime){this._storage=runtime._GetProjectStorage()}getItem(key){C3X.RequireString(key);return this._storage.getItem(key)}setItem(key,value){C3X.RequireString(key);return this._storage.setItem(key,value)}removeItem(key){C3X.RequireString(key);return this._storage.removeItem(key)}clear(){return this._storage.clear()}keys(){return this._storage.keys()}}};


// c3/interfaces/IObjectClass.js
'use strict';{const C3=self.C3;const C3X=self.C3X;const map=new WeakMap;self.IObjectClass=class IObjectClass{constructor(objectClass){map.set(this,objectClass);Object.defineProperties(this,{name:{value:objectClass.GetName(),writable:false}});objectClass.GetRuntime()._MapScriptInterface(this,objectClass)}addEventListener(type,func){C3X.RequireString(type);C3X.RequireFunction(func);map.get(this).UserScriptDispatcher().addEventListener(type,func)}removeEventListener(type,func){C3X.RequireString(type);
C3X.RequireFunction(func);map.get(this).UserScriptDispatcher().removeEventListener(type,func)}getAllInstances(){return map.get(this).GetInstances().map(inst=>inst.GetInterfaceClass())}getFirstInstance(){const instances=map.get(this).GetInstances();if(instances.length>0)return instances[0].GetInterfaceClass();else return null}getPickedInstances(){return map.get(this).GetCurrentSol().GetInstances().map(inst=>inst.GetInterfaceClass())}getFirstPickedInstance(){const pickedInstances=map.get(this).GetCurrentSol().GetInstances();
if(pickedInstances.length>0)return pickedInstances[0].GetInterfaceClass();else return null}*instances(){for(const inst of map.get(this).GetInstances())yield inst.GetInterfaceClass()}*pickedInstances(){for(const inst of map.get(this).GetCurrentSol().GetInstances())yield inst.GetInterfaceClass()}setInstanceClass(Class){C3X.RequireFunction(Class);const objectClass=map.get(this);if(objectClass.GetInstanceCount()>0)throw new Error("setInstanceClass() called too late, because instances have already been created - call in runOnStartup");
map.get(this)._SetUserScriptInstanceClass(Class)}createInstance(layerNameOrIndex,x,y,createHierarchy){C3X.RequireNumber(x);C3X.RequireNumber(y);if(typeof layerNameOrIndex!=="number"&&typeof layerNameOrIndex!=="string")throw new TypeError("invalid layer parameter");const objectClass=map.get(this);const runtime=objectClass.GetRuntime();const layer=runtime.GetMainRunningLayout().GetLayer(layerNameOrIndex);if(!layer)throw new Error("invalid layer");const inst=runtime.CreateInstance(objectClass,layer,
x,y,createHierarchy);if(createHierarchy)layer.SortAndAddSceneGraphInstancesByZIndex(inst);const eventSheetManager=runtime.GetEventSheetManager();eventSheetManager.BlockFlushingInstances(true);inst._TriggerOnCreatedOnSelfAndRelated();eventSheetManager.BlockFlushingInstances(false);return inst.GetInterfaceClass()}}};


// c3/interfaces/ILayout.js
'use strict';{const C3=self.C3;const C3X=self.C3X;const map=new WeakMap;self.ILayout=class ILayout{constructor(layout){map.set(this,layout);const effectInstanceArr=[];const effectList=layout.GetEffectList();const effectCount=effectList.GetAllEffectTypes().length;for(let i=0;i<effectCount;++i)effectInstanceArr.push(new self.IEffectInstance(effectList,i));Object.defineProperties(this,{name:{value:layout.GetName(),writable:false},index:{value:layout.GetIndex(),writable:false},effects:{value:effectInstanceArr,
writable:false}})}addEventListener(type,func){C3X.RequireString(type);C3X.RequireFunction(func);map.get(this).UserScriptDispatcher().addEventListener(type,func)}removeEventListener(type,func){C3X.RequireString(type);C3X.RequireFunction(func);map.get(this).UserScriptDispatcher().removeEventListener(type,func)}get width(){return map.get(this).GetWidth()}set width(w){map.get(this).SetWidth(w)}get height(){return map.get(this).GetHeight()}set height(h){map.get(this).SetHeight(h)}scrollTo(x,y){C3X.RequireNumber(x);
C3X.RequireNumber(y);const layout=map.get(this);layout.SetScrollX(x);layout.SetScrollY(y)}getLayer(nameOrIndex){const layout=map.get(this);let layer=null;if(typeof nameOrIndex==="number"||typeof nameOrIndex==="string")layer=layout.GetLayer(nameOrIndex);else throw new TypeError("expected string or number");if(!layer)return null;return layer.GetILayer()}getAllLayers(){return map.get(this).GetLayers().map(layer=>layer.GetILayer())}}};


// c3/interfaces/ILayer.js
'use strict';{const C3=self.C3;const C3X=self.C3X;const map=new WeakMap;self.ILayer=class ILayer{constructor(layer){map.set(this,layer);const effectInstanceArr=[];const effectList=layer.GetEffectList();const effectCount=effectList.GetAllEffectTypes().length;for(let i=0;i<effectCount;++i)effectInstanceArr.push(new self.IEffectInstance(effectList,i));Object.defineProperties(this,{name:{value:layer.GetName(),writable:false},index:{value:layer.GetIndex(),writable:false},layout:{value:layer.GetLayout().GetILayout(),
writable:false},effects:{value:effectInstanceArr,writable:false}})}static _Unwrap(ilayer){return map.get(ilayer)}get isVisible(){return map.get(this).IsVisible()}set isVisible(v){map.get(this).SetVisible(v)}get opacity(){return map.get(this).GetOpacity()}set opacity(o){o=C3.clamp(+o,0,1);if(isNaN(o))return;map.get(this).SetOpacity(o)}getViewport(){return map.get(this).GetViewport().toDOMRect()}cssPxToLayer(clientX,clientY,z=0){C3X.RequireNumber(clientX);C3X.RequireNumber(clientY);C3X.RequireNumber(z);
const layer=map.get(this);const runtime=layer.GetRuntime();return layer.CanvasCssToLayer(clientX-runtime.GetCanvasClientX(),clientY-runtime.GetCanvasClientY(),z)}layerToCssPx(layerX,layerY,z=0){C3X.RequireNumber(layerX);C3X.RequireNumber(layerY);C3X.RequireNumber(z);const layer=map.get(this);const runtime=layer.GetRuntime();const [clientX,clientY]=layer.LayerToCanvasCss(layerX,layerY,z);return[clientX+runtime.GetCanvasClientX(),clientY+runtime.GetCanvasClientY()]}}};


// c3/interfaces/IInstance.js
'use strict';{const C3=self.C3;const C3X=self.C3X;const map=new WeakMap;const dispatchers=new WeakMap;function GetDispatcher(iinst){let dispatcher=dispatchers.get(iinst);if(dispatcher)return dispatcher;dispatcher=C3.New(C3.Event.Dispatcher);dispatchers.set(iinst,dispatcher);return dispatcher}let initInst=null;self.IInstance=class IInstance{constructor(){map.set(this,initInst);const descriptors={runtime:{value:initInst.GetRuntime().GetIRuntime(),writable:false},objectType:{value:initInst.GetObjectClass().GetIObjectClass(),
writable:false},uid:{value:initInst.GetUID(),writable:false}};initInst._GetInstVarsScriptDescriptor(descriptors);initInst._GetBehaviorsScriptDescriptor(descriptors);Object.defineProperties(this,descriptors);initInst.GetRuntime()._MapScriptInterface(this,initInst)}static _Init(inst){initInst=inst}static _GetInitInst(){return initInst}_Release(){const dispatcher=dispatchers.get(this);if(dispatcher){dispatcher.Release();dispatchers.delete(this)}map.delete(this)}addEventListener(type,func,capture){C3X.RequireString(type);
C3X.RequireFunction(func);GetDispatcher(this).addEventListener(type,func,capture)}removeEventListener(type,func,capture){C3X.RequireString(type);C3X.RequireFunction(func);GetDispatcher(this).removeEventListener(type,func,capture)}dispatchEvent(e){GetDispatcher(this).dispatchEvent(e)}destroy(){const inst=map.get(this);inst.GetRuntime().DestroyInstance(inst)}}};


// c3/interfaces/IWorldInstance.js
'use strict';{const C3=self.C3;const C3X=self.C3X;const IInstance=self.IInstance;const ILayer=self.ILayer;const map=new WeakMap;const BLEND_MODE_TO_INDEX=new Map([["normal",0],["additive",1],["copy",3],["destination-over",4],["source-in",5],["destination-in",6],["source-out",7],["destination-out",8],["source-atop",9],["destination-atop",10]]);const INDEX_TO_BLEND_MODE=new Map([...BLEND_MODE_TO_INDEX.entries()].map(a=>[a[1],a[0]]));const tempColor=C3.New(C3.Color);self.IWorldInstance=class IWorldInstance extends IInstance{constructor(){super();
const inst=IInstance._GetInitInst();map.set(this,inst);const effectInstanceArr=[];const wi=inst.GetWorldInfo();const instanceEffectList=wi.GetInstanceEffectList();if(instanceEffectList){const effectCount=wi.GetObjectClass().GetEffectList().GetAllEffectTypes().length;for(let i=0;i<effectCount;++i)effectInstanceArr.push(new self.IEffectInstance(instanceEffectList,i))}const descriptors={effects:{value:effectInstanceArr,writable:false}};Object.defineProperties(this,descriptors)}get layout(){return map.get(this).GetWorldInfo().GetLayout().GetILayout()}get layer(){return map.get(this).GetWorldInfo().GetLayer().GetILayer()}get x(){return map.get(this).GetWorldInfo().GetX()}set x(v){v=
+v;const wi=map.get(this).GetWorldInfo();if(isNaN(v)||wi.GetX()===v)return;wi.SetX(v);wi.SetBboxChanged()}get y(){return map.get(this).GetWorldInfo().GetY()}set y(v){v=+v;const wi=map.get(this).GetWorldInfo();if(isNaN(v)||wi.GetY()===v)return;wi.SetY(v);wi.SetBboxChanged()}get zElevation(){return map.get(this).GetWorldInfo().GetZElevation()}set zElevation(z){z=+z;const inst=map.get(this);const wi=inst.GetWorldInfo();if(isNaN(z)||wi.GetZElevation()===z)return;wi.SetZElevation(z);inst.GetRuntime().UpdateRender()}get totalZElevation(){return map.get(this).GetWorldInfo().GetTotalZElevation()}get width(){return map.get(this).GetWorldInfo().GetWidth()}set width(w){w=
+w;const wi=map.get(this).GetWorldInfo();if(isNaN(w)||wi.GetWidth()===w)return;wi.SetWidth(w);wi.SetBboxChanged()}get height(){return map.get(this).GetWorldInfo().GetHeight()}set height(h){h=+h;const wi=map.get(this).GetWorldInfo();if(isNaN(h)||wi.GetHeight()===h)return;wi.SetHeight(h);wi.SetBboxChanged()}get angle(){return map.get(this).GetWorldInfo().GetAngle()}set angle(a){a=C3.clampAngle(+a);const wi=map.get(this).GetWorldInfo();if(isNaN(a)||wi.GetAngle()===a)return;wi.SetAngle(a);wi.SetBboxChanged()}get angleDegrees(){return C3.toDegrees(this.angle)}set angleDegrees(a){this.angle=
C3.toRadians(a)}getBoundingBox(){return map.get(this).GetWorldInfo().GetBoundingBox().toDOMRect()}getBoundingQuad(){return map.get(this).GetWorldInfo().GetBoundingQuad().toDOMQuad()}get isVisible(){return map.get(this).GetWorldInfo().IsVisible()}set isVisible(v){v=!!v;const inst=map.get(this);const wi=inst.GetWorldInfo();if(wi.IsVisible()===v)return;wi.SetVisible(v);inst.GetRuntime().UpdateRender()}get opacity(){return map.get(this).GetWorldInfo().GetOpacity()}set opacity(o){o=C3.clamp(+o,0,1);const inst=
map.get(this);const wi=inst.GetWorldInfo();if(isNaN(o)||wi.GetOpacity()===o)return;wi.SetOpacity(o);inst.GetRuntime().UpdateRender()}set colorRgb(arr){C3X.RequireArray(arr);if(arr.length<3)throw new Error("expected 3 elements");tempColor.setRgb(arr[0],arr[1],arr[2]);const inst=map.get(this);const wi=inst.GetWorldInfo();if(wi.GetUnpremultipliedColor().equalsIgnoringAlpha(tempColor))return;wi.SetUnpremultipliedColor(tempColor);inst.GetRuntime().UpdateRender()}get colorRgb(){const c=map.get(this).GetWorldInfo().GetUnpremultipliedColor();
return[c.getR(),c.getG(),c.getB()]}set blendMode(bm){C3X.RequireString(bm);const index=BLEND_MODE_TO_INDEX.get(bm);if(typeof index!=="number")throw new Error("invalid blend mode");const inst=map.get(this);const wi=inst.GetWorldInfo();wi.SetBlendMode(index);inst.GetRuntime().UpdateRender()}get blendMode(){return INDEX_TO_BLEND_MODE.get(map.get(this).GetWorldInfo().GetBlendMode())}moveToTop(){map.get(this).GetWorldInfo().ZOrderMoveToTop()}moveToBottom(){map.get(this).GetWorldInfo().ZOrderMoveToBottom()}moveToLayer(ilayer){C3X.RequireInstanceOf(ilayer,
ILayer);const layer=ILayer._Unwrap(ilayer);if(!layer)throw new Error("invalid layer");map.get(this).GetWorldInfo().ZOrderMoveToLayer(layer)}moveAdjacentToInstance(other,isAfter){C3X.RequireInstanceOf(other,IWorldInstance);map.get(this).GetWorldInfo().ZOrderMoveAdjacentToInstance(map.get(other),isAfter)}containsPoint(x,y){C3X.RequireNumber(x);C3X.RequireNumber(y);return map.get(this).GetWorldInfo().ContainsPoint(+x,+y)}testOverlap(worldInstance){C3X.RequireInstanceOf(worldInstance,IWorldInstance);
const a=map.get(this);const b=map.get(worldInstance);return a.GetRuntime().GetCollisionEngine().TestOverlap(a,b)}testOverlapSolid(){const inst=map.get(this);const overlapInst=inst.GetRuntime().GetCollisionEngine().TestOverlapSolid(inst);return overlapInst?overlapInst.GetInterfaceClass():null}getParent(){const parent=map.get(this).GetParent();return parent?parent.GetInterfaceClass():null}getTopParent(){const parent=map.get(this).GetTopParent();return parent?parent.GetInterfaceClass():null}*parents(){for(const parent of map.get(this).parents())yield parent.GetInterfaceClass()}getChildCount(){return map.get(this).GetChildCount()}getChildAt(index){const child=
map.get(this).GetChildAt(index);return child?child.GetInterfaceClass():null}*children(){for(const child of map.get(this).children())yield child.GetInterfaceClass()}*allChildren(){for(const child of map.get(this).allChildren())yield child.GetInterfaceClass()}addChild(ichild,opts){C3X.RequireInstanceOf(ichild,IWorldInstance);C3X.RequireOptionalObject(opts);if(!opts)opts={};const inst=map.get(this);const child=map.get(ichild);inst.AddChild(child,opts)}removeChild(ichild){C3X.RequireInstanceOf(ichild,
IWorldInstance);const inst=map.get(this);const child=map.get(ichild);inst.RemoveChild(child)}removeFromParent(){const inst=map.get(this);if(!inst.HasParent())return;const parent=inst.GetParent();parent.RemoveChild(inst)}createMesh(hsize,vsize){C3X.RequireFiniteNumber(hsize);C3X.RequireFiniteNumber(vsize);map.get(this).GetWorldInfo().CreateMesh(hsize,vsize)}releaseMesh(){const wi=map.get(this).GetWorldInfo();wi.ReleaseMesh();wi.SetBboxChanged()}setMeshPoint(col,row,opts){C3X.RequireFiniteNumber(col);
C3X.RequireFiniteNumber(row);C3X.RequireObject(opts);const wi=map.get(this).GetWorldInfo();if(wi.SetMeshPoint(col,row,opts))wi.SetBboxChanged()}getMeshSize(){const wi=map.get(this).GetWorldInfo();if(!wi.HasMesh())return[0,0];const sourceMesh=wi.GetSourceMesh();return[sourceMesh.GetHSize(),sourceMesh.GetVSize()]}}};


// c3/interfaces/IDOMInstance.js
'use strict';{const C3=self.C3;const C3X=self.C3X;const map=new WeakMap;self.IDOMInstance=class IDOMInstance extends self.IWorldInstance{constructor(){super();map.set(this,self.IInstance._GetInitInst())}getElement(){return map.get(this).GetSdkInstance()._GetElementInDOMMode()}focus(){map.get(this).GetSdkInstance().FocusElement()}blur(){map.get(this).GetSdkInstance().BlurElement()}setCssStyle(prop,val){C3X.RequireString(prop);map.get(this).GetSdkInstance().SetElementCSSStyle(prop,val)}}};


// c3/interfaces/IBehaviorInstance.js
'use strict';{const C3=self.C3;const C3X=self.C3X;const map=new WeakMap;const dispatchers=new WeakMap;function GetDispatcher(ibehinst){let dispatcher=dispatchers.get(ibehinst);if(dispatcher)return dispatcher;dispatcher=C3.New(C3.Event.Dispatcher);dispatchers.set(ibehinst,dispatcher);return dispatcher}let initBehInst=null;self.IBehaviorInstance=class IBehaviorInstance{constructor(){map.set(this,initBehInst);const descriptors={runtime:{value:initBehInst.GetRuntime().GetIRuntime(),writable:false},behavior:{value:initBehInst.GetBehavior().GetIBehavior(),
writable:false}};Object.defineProperties(this,descriptors)}static _Init(behInst){initBehInst=behInst}static _GetInitInst(){return initBehInst}get instance(){return map.get(this).GetObjectInstance().GetInterfaceClass()}_Release(){const dispatcher=dispatchers.get(this);if(dispatcher){dispatcher.Release();dispatchers.delete(this)}map.delete(this)}addEventListener(type,func,capture){C3X.RequireString(type);C3X.RequireFunction(func);GetDispatcher(this).addEventListener(type,func,capture)}removeEventListener(type,
func,capture){C3X.RequireString(type);C3X.RequireFunction(func);GetDispatcher(this).removeEventListener(type,func,capture)}dispatchEvent(e){GetDispatcher(this).dispatchEvent(e)}}};


// c3/interfaces/IBehavior.js
'use strict';{const C3=self.C3;const C3X=self.C3X;const map=new WeakMap;self.IBehavior=class IBehavior{constructor(behavior){map.set(this,behavior);const descriptors={runtime:{value:behavior.GetRuntime().GetIRuntime(),writable:false}};Object.defineProperties(this,descriptors)}getAllInstances(){return map.get(this).GetInstances().map(inst=>inst.GetInterfaceClass())}}};


// c3/interfaces/IEffectInstance.js
'use strict';{const C3=self.C3;const C3X=self.C3X;const map=new WeakMap;self.IEffectInstance=class IEffectInstance{constructor(effectList,index){map.set(this,effectList);const descriptors={index:{value:index,writable:false}};Object.defineProperties(this,descriptors)}get name(){const effectTypes=map.get(this).GetAllEffectTypes();return effectTypes[this.index].GetName()}get isActive(){return map.get(this).IsEffectIndexActive(this.index)}set isActive(a){a=!!a;const fxList=map.get(this);if(fxList.IsEffectIndexActive(this.index)===
a)return;fxList.SetEffectIndexActive(this.index,a);fxList.UpdateActiveEffects();fxList.GetRuntime().UpdateRender()}setParameter(i,v){C3X.RequireFiniteNumber(i);i=Math.floor(+i);const fxList=map.get(this);const paramsArr=fxList.GetEffectParametersForIndex(this.index);if(i<0||i>=paramsArr.length)throw new RangeError("invalid effect parameter index");const oldValue=paramsArr[i];if(oldValue instanceof C3.Color){if(!Array.isArray(v)||v.length<3)throw new TypeError("expected array with 3 elements");const r=
v[0];const g=v[1];const b=v[2];if(oldValue.equalsRgb(r,g,b))return;oldValue.setRgb(r,g,b)}else{if(typeof v!=="number")throw new TypeError("expected number");if(oldValue===v)return;paramsArr[i]=v}if(fxList.IsEffectIndexActive(this.index))fxList.GetRuntime().UpdateRender()}getParameter(i){C3X.RequireFiniteNumber(i);i=Math.floor(+i);const fxList=map.get(this);const paramsArr=fxList.GetEffectParametersForIndex(this.index);if(i<0||i>=paramsArr.length)throw new RangeError("invalid effect parameter index");
const ret=paramsArr[i];if(ret instanceof C3.Color)return[ret.getR(),ret.getG(),ret.getB()];else return ret}}};


// c3/assets/assetManager.js
'use strict';{const C3=self.C3;const VALID_LOAD_POLICIES=new Set(["local","remote"]);const EXT_TO_TYPE=new Map([["mp4","video/mp4"],["webm","video/webm"],["m4a","audio/mp4"],["mp3","audio/mpeg"],["js","application/javascript"],["wasm","application/wasm"],["svg","image/svg+xml"],["html","text/html"]]);function GetTypeFromFileExtension(filename){if(!filename)return"";const parts=filename.split(".");if(parts.length<2)return"";const ext=parts[parts.length-1].toLowerCase();return EXT_TO_TYPE.get(ext)||
""}function AddScript(url){return new Promise((resolve,reject)=>{const elem=document.createElement("script");elem.onload=resolve;elem.onerror=reject;elem.async=false;elem.type="module";elem.src=url;document.head.appendChild(elem)})}C3.AssetManager=class AssetManager extends C3.DefendedBase{constructor(runtime,opts){super();const exportType=opts["exportType"];this._runtime=runtime;this._localUrlBlobs=new Map;this._localBlobUrlCache=new Map;this._localBlobSWUrls=new Map;this._isCordova=exportType===
"cordova";this._isiOSCordova=!!opts["isiOSCordova"];this._isFileProtocol=location.protocol==="file:";this._swClientId=opts["swClientId"];this._supportedAudioFormats=opts["supportedAudioFormats"]||{};this._audioFiles=new Map;this._preloadSounds=false;this._mediaSubfolder="";this._fontsSubfolder="";this._iconsSubfolder="";const isRemoteLoadPolicy=exportType==="html5"||exportType==="scirra-arcade"||exportType==="instant-games";this._defaultLoadPolicy=isRemoteLoadPolicy?"remote":"local";this._allAssets=
[];this._assetsByUrl=new Map;this._webFonts=[];this._loadPromises=[];this._hasFinishedInitialLoad=false;this._totalAssetSizeToLoad=0;this._assetSizeLoaded=0;this._lastLoadProgress=0;this._hasHadErrorLoading=false;this._loadingRateLimiter=C3.New(C3.RateLimiter,()=>this._FireLoadingProgressEvent(),50);this._promiseThrottle=new C3.PromiseThrottle(Math.max(C3.hardwareConcurrency,8));const localUrlBlobs=opts["previewImageBlobs"];if(localUrlBlobs){const projectFileBlobs=opts["previewProjectFileBlobs"];
if(projectFileBlobs)Object.assign(localUrlBlobs,projectFileBlobs);const projectData=opts["projectData"];if(projectData)localUrlBlobs["data.json"]=projectData;for(const [url,blob]of Object.entries(localUrlBlobs))this._localUrlBlobs.set(url.toLowerCase(),blob)}const localSWUrlMap=opts["previewProjectFileSWUrls"];if(localSWUrlMap)for(const [srcUrl,destUrl]of Object.entries(localSWUrlMap))this._localBlobSWUrls.set(srcUrl,destUrl);this._iAssetManager=new self.IAssetManager(this)}Release(){this._localUrlBlobs.clear();
for(const url of this._localBlobUrlCache.values())if(url.startsWith("blob:"))URL.revokeObjectURL(url);this._localBlobUrlCache.clear();for(const asset of this._allAssets)asset.Release();C3.clearArray(this._allAssets);this._assetsByUrl.clear();C3.clearArray(this._loadPromises);this._runtime=null}GetRuntime(){return this._runtime}_SetMediaSubfolder(folder){this._mediaSubfolder=folder}GetMediaSubfolder(){return this._mediaSubfolder}_SetFontsSubfolder(folder){this._fontsSubfolder=folder}GetFontsSubfolder(){return this._fontsSubfolder}_SetIconsSubfolder(folder){this._iconsSubfolder=
folder}GetIconsSubfolder(){return this._iconsSubfolder}_HasLocalUrlBlob(url){return this._localUrlBlobs.has(url.toLowerCase())}_GetLocalUrlBlob(url){return this._localUrlBlobs.get(url.toLowerCase())||null}GetLocalUrlAsBlobUrl(url){if(!this._HasLocalUrlBlob(url))return url;const lowerUrl=url.toLowerCase();let ret=this._localBlobUrlCache.get(lowerUrl);if(!ret){const blob=this._GetLocalUrlBlob(lowerUrl);ret=URL.createObjectURL(blob);this._localBlobUrlCache.set(lowerUrl,ret)}return ret}FetchBlob(url,
loadPolicy){loadPolicy=loadPolicy||this._defaultLoadPolicy;const localBlob=this._GetLocalUrlBlob(url);if(localBlob)return Promise.resolve(localBlob);else if(C3.IsRelativeURL(url)){const lowerUrl=url.toLowerCase();if(this._isCordova&&this._isFileProtocol)return this.CordovaFetchLocalFileAsBlob(lowerUrl);else if(loadPolicy==="local")return this._promiseThrottle.Add(()=>C3.FetchBlob(lowerUrl));else return C3.FetchBlob(lowerUrl)}else return C3.FetchBlob(url)}FetchArrayBuffer(url){const localBlob=this._GetLocalUrlBlob(url);
if(localBlob)return C3.BlobToArrayBuffer(localBlob);else if(C3.IsRelativeURL(url)){const lowerUrl=url.toLowerCase();if(this._isCordova&&this._isFileProtocol)return this.CordovaFetchLocalFileAsArrayBuffer(lowerUrl);else if(this._defaultLoadPolicy==="local")return this._promiseThrottle.Add(()=>C3.FetchArrayBuffer(lowerUrl));else return C3.FetchArrayBuffer(lowerUrl)}else return C3.FetchArrayBuffer(url)}FetchText(url){const localBlob=this._GetLocalUrlBlob(url);if(localBlob)return C3.BlobToString(localBlob);
else if(C3.IsRelativeURL(url)){const lowerUrl=url.toLowerCase();if(this._isCordova&&this._isFileProtocol)return this.CordovaFetchLocalFileAsText(lowerUrl);else if(this._defaultLoadPolicy==="local")return this._promiseThrottle.Add(()=>C3.FetchText(lowerUrl));else return C3.FetchText(lowerUrl)}else return C3.FetchText(url)}async FetchJson(url){const text=await this.FetchText(url);return JSON.parse(text)}_CordovaFetchLocalFileAs(filename,as_){return this._runtime.PostComponentMessageToDOMAsync("runtime",
"cordova-fetch-local-file",{"filename":filename,"as":as_})}CordovaFetchLocalFileAsText(filename){return this._CordovaFetchLocalFileAs(filename,"text")}async CordovaFetchLocalFileAsBlob(filename){const buffer=await this._CordovaFetchLocalFileAs(filename,"buffer");const type=GetTypeFromFileExtension(filename);return new Blob([buffer],{"type":type})}async CordovaFetchLocalFileAsBlobURL(filename){filename=filename.toLowerCase();let blobUrl=this._localBlobUrlCache.get(filename);if(blobUrl)return blobUrl;
const blob=await this.CordovaFetchLocalFileAsBlob(filename);blobUrl=URL.createObjectURL(blob);this._localBlobUrlCache.set(filename,blobUrl);return blobUrl}CordovaFetchLocalFileAsArrayBuffer(filename){return this._CordovaFetchLocalFileAs(filename,"buffer")}GetMediaFileUrl(filename){if(this._HasLocalUrlBlob(filename))return this.GetLocalUrlAsBlobUrl(filename);else return this._mediaSubfolder+filename.toLowerCase()}GetProjectFileUrl(url,subfolder=""){if(C3.IsAbsoluteURL(url)){if(subfolder)throw new Error("cannot specify subfolder with remote URL");
return Promise.resolve(url)}else if(this._HasLocalUrlBlob(url))return Promise.resolve(this.GetLocalUrlAsBlobUrl(url));else if(this._isCordova&&this._isFileProtocol)return this.CordovaFetchLocalFileAsBlobURL(subfolder+url);else return Promise.resolve(subfolder+url.toLowerCase())}GetProjectFileIframeUrl(url){if(C3.IsAbsoluteURL(url))return Promise.resolve(url);else{const queryIndex=url.indexOf("?");const queryStr=queryIndex===-1?"":url.substr(queryIndex);const urlNoSearch=queryIndex===-1?url:url.substr(0,
queryIndex);if(this._HasLocalUrlBlob(urlNoSearch)){let localUrl=this._localBlobSWUrls.get(urlNoSearch)||this.GetLocalUrlAsBlobUrl(urlNoSearch);if(!localUrl.startsWith("blob:")&&this._swClientId){const asUrl=new URL(localUrl);const params=new URLSearchParams(queryStr);params.set("__c3_client_id",this._swClientId);asUrl.search=params.toString();localUrl=asUrl.toString()}return Promise.resolve(localUrl)}else if(this._isCordova&&this._isFileProtocol)return this.CordovaFetchLocalFileAsBlobURL(urlNoSearch);
else return Promise.resolve(url.toLowerCase())}}LoadProjectFileUrl(url){return this.GetProjectFileUrl(url)}LoadImage(opts){if(opts.loadPolicy&&!VALID_LOAD_POLICIES.has(opts.loadPolicy))throw new Error("invalid load policy");let asset=this._assetsByUrl.get(opts.url);if(asset)return asset;asset=C3.New(C3.ImageAsset,this,{url:opts.url,size:opts.size||0,loadPolicy:opts.loadPolicy||this._defaultLoadPolicy});this._allAssets.push(asset);this._assetsByUrl.set(asset.GetURL(),asset);if(!this._hasFinishedInitialLoad){this._totalAssetSizeToLoad+=
asset.GetSize();this._loadPromises.push(asset.Load().then(()=>this._AddLoadedSize(asset.GetSize())))}return asset}async WaitForAllToLoad(){try{await Promise.all(this._loadPromises);this._lastLoadProgress=1}catch(err){console.error("Error loading: ",err);this._hasHadErrorLoading=true;this._FireLoadingProgressEvent()}}SetInitialLoadFinished(){this._hasFinishedInitialLoad=true}HasHadErrorLoading(){return this._hasHadErrorLoading}_AddLoadedSize(s){this._assetSizeLoaded+=s;this._loadingRateLimiter.Call()}_FireLoadingProgressEvent(){const event=
C3.New(C3.Event,"loadingprogress");this._lastLoadProgress=C3.clamp(this._assetSizeLoaded/this._totalAssetSizeToLoad,0,1);event.progress=this._lastLoadProgress;this._runtime.Dispatcher().dispatchEvent(event)}GetLoadProgress(){return this._lastLoadProgress}_SetWebFonts(arr){C3.shallowAssignArray(this._webFonts,arr);if(this._webFonts.length)this._loadPromises.push(this._LoadWebFonts())}_LoadWebFonts(){if(typeof FontFace==="undefined")return Promise.resolve();const promises=[];for(const [name,filename,
size]of this._webFonts){this._totalAssetSizeToLoad+=size;promises.push(this._LoadWebFont(name,filename).then(()=>this._AddLoadedSize(size)))}return Promise.all(promises)}async _LoadWebFont(name,filename){try{const url=await this.GetProjectFileUrl(filename,this._fontsSubfolder);const fontFace=new FontFace(name,`url('${url}')`);if(this._runtime.IsInWorker())self.fonts.add(fontFace);else document.fonts.add(fontFace);await fontFace.load()}catch(err){console.warn(`[C3 runtime] Failed to load web font '${name}': `,
err)}}IsAudioFormatSupported(type){return!!this._supportedAudioFormats[type]}_SetAudioFiles(arr,preloadSounds){this._preloadSounds=!!preloadSounds;for(const [fileName,projectFilesInfo,isMusic]of arr)this._audioFiles.set(fileName,{fileName,formats:projectFilesInfo.map(si=>({type:si[0],fileExtension:si[1],fullName:fileName+si[1],fileSize:si[2]})),isMusic})}GetPreferredAudioFile(namePart){const info=this._audioFiles.get(namePart.toLowerCase());if(!info)return null;let webMOpusFile=null;for(const formatInfo of info.formats){if(!webMOpusFile&&
formatInfo.type==="audio/webm; codecs=opus")webMOpusFile=formatInfo;if(this.IsAudioFormatSupported(formatInfo.type))return formatInfo}return webMOpusFile}GetProjectAudioFileUrl(namePart){const formatInfo=this.GetPreferredAudioFile(namePart);if(!formatInfo)return null;return{url:this.GetMediaFileUrl(formatInfo.fullName),type:formatInfo.type}}GetAudioToPreload(){if(this._preloadSounds){const ret=[];for(const info of this._audioFiles.values()){if(info.isMusic)continue;const formatInfo=this.GetPreferredAudioFile(info.fileName);
if(!formatInfo)continue;ret.push({originalUrl:info.fileName,url:this.GetMediaFileUrl(formatInfo.fullName),type:formatInfo.type,fileSize:formatInfo.fileSize})}return ret}else return[]}GetIAssetManager(){return this._iAssetManager}async LoadScripts(...urls){const scriptUrls=await Promise.all(urls.map(url=>this.GetProjectFileUrl(url)));if(this._runtime.IsInWorker())if(urls.length===1){const url=urls[0];await self.c3_import((C3.IsRelativeURL(url)?"./":"")+url)}else{const scriptStr=urls.map(url=>`import "${C3.IsRelativeURL(url)?
"./":""}${url}";`).join("\n");const blobUrl=URL.createObjectURL(new Blob([scriptStr],{type:"application/javascript"}));await self.c3_import(blobUrl)}else await Promise.all(scriptUrls.map(url=>AddScript(url)))}async CompileWebAssembly(url){if(WebAssembly.compileStreaming){const fetchUrl=await this.GetProjectFileUrl(url);return await WebAssembly.compileStreaming(fetch(fetchUrl))}else{const arrayBuffer=await C3.FetchArrayBuffer(url);return await WebAssembly.compile(arrayBuffer)}}async LoadStyleSheet(url){const fetchUrl=
await this.GetProjectFileUrl(url);return await this._runtime.PostComponentMessageToDOMAsync("runtime","add-stylesheet",{"url":fetchUrl})}}};


// c3/assets/asset.js
'use strict';{const C3=self.C3;C3.Asset=class Asset extends C3.DefendedBase{constructor(assetManager,opts){super();this._assetManager=assetManager;this._runtime=assetManager.GetRuntime();this._url=opts.url;this._size=opts.size;this._loadPolicy=opts.loadPolicy;this._blob=null;this._isLoaded=false;this._loadPromise=null}Release(){this._loadPromise=null;this._assetManager=null;this._runtime=null;this._blob=null}GetURL(){return this._url}GetSize(){return this._size}Load(){if(this._loadPolicy==="local"||
this._blob){this._isLoaded=true;return Promise.resolve()}if(this._loadPromise)return this._loadPromise;this._loadPromise=this._assetManager.FetchBlob(this._url,this._loadPolicy).then(blob=>{this._isLoaded=true;this._loadPromise=null;this._blob=blob;return blob}).catch(err=>console.error("Error loading resource: ",err));return this._loadPromise}IsLoaded(){return this._isLoaded}GetBlob(){if(this._blob)return Promise.resolve(this._blob);if(this._loadPromise)return this._loadPromise;return this._assetManager.FetchBlob(this._url,
this._loadPolicy)}}};


// c3/assets/imageAsset.js
'use strict';{const C3=self.C3;const promiseThrottle=new C3.PromiseThrottle;const allImageAssets=new Set;C3.ImageAsset=class ImageAsset extends C3.Asset{constructor(assetManager,opts){super(assetManager,opts);this._texturePromise=null;this._webglTexture=null;this._refCount=0;this._imageWidth=-1;this._imageHeight=-1;allImageAssets.add(this)}Release(){this.ReleaseTexture();if(this._refCount!==0)throw new Error("released image asset which still has texture references");this._texturePromise=null;allImageAssets.delete(this);
super.Release()}static OnWebGLContextLost(){for(const imageAsset of allImageAssets){imageAsset._texturePromise=null;imageAsset._webglTexture=null;imageAsset._refCount=0}}LoadStaticTexture(renderer,opts){opts=opts||{};this._refCount++;if(this._webglTexture)return Promise.resolve(this._webglTexture);if(this._texturePromise)return this._texturePromise;opts.anisotropy=this._runtime.GetCanvasManager().GetTextureAnisotropy();this._texturePromise=this.GetBlob().then(blob=>promiseThrottle.Add(()=>renderer.CreateStaticTextureAsync(blob,
opts).then(texture=>{this._texturePromise=null;if(this._refCount===0){renderer.DeleteTexture(texture);return null}this._webglTexture=texture;this._imageWidth=texture.GetWidth();this._imageHeight=texture.GetHeight();return this._webglTexture}))).catch(err=>{console.error("Failed to load texture: ",err);throw err;});return this._texturePromise}ReleaseTexture(){if(this._refCount<=0)throw new Error("texture released too many times");this._refCount--;if(this._refCount===0&&this._webglTexture){const renderer=
this._webglTexture.GetRenderer();renderer.DeleteTexture(this._webglTexture);this._webglTexture=null}}GetTexture(){return this._webglTexture}GetWidth(){return this._imageWidth}GetHeight(){return this._imageHeight}async LoadToDrawable(){const blob=await this.GetBlob();if(C3.Supports.ImageBitmapOptions)return await createImageBitmap(blob,{"premultiplyAlpha":"none"});else if(C3.Supports.ImageBitmap)return await createImageBitmap(blob);else return await C3.BlobToImage(blob)}}};


// c3/layouts/renderCell.js
'use strict';{const C3=self.C3;const assert=self.assert;function SortByInstLastCachedZIndex(a,b){return a.GetWorldInfo()._GetLastCachedZIndex()-b.GetWorldInfo()._GetLastCachedZIndex()}C3.RenderCell=class RenderCell extends C3.DefendedBase{constructor(grid,x,y){super();this._grid=grid;this._x=x;this._y=y;this._instances=[];this._isSorted=true;this._pendingRemoval=new Set;this._isAnyPendingRemoval=false}Release(){C3.clearArray(this._instances);this._pendingRemoval.clear();this._grid=null}Reset(){C3.clearArray(this._instances);
this._isSorted=true;this._pendingRemoval.clear();this._isAnyPendingRemoval=false}SetChanged(){this._isSorted=false}IsEmpty(){if(!this._instances.length)return true;if(this._instances.length>this._pendingRemoval.size)return false;this._FlushPending();return true}Insert(inst){if(this._pendingRemoval.has(inst)){this._pendingRemoval.delete(inst);if(this._pendingRemoval.size===0)this._isAnyPendingRemoval=false;return}this._instances.push(inst);this._isSorted=this._instances.length===1}Remove(inst){this._pendingRemoval.add(inst);
this._isAnyPendingRemoval=true;if(this._pendingRemoval.size>=50)this._FlushPending()}_FlushPending(){if(!this._isAnyPendingRemoval)return;if(this._instances.length===this._pendingRemoval.size){this.Reset();return}C3.arrayRemoveAllInSet(this._instances,this._pendingRemoval);this._pendingRemoval.clear();this._isAnyPendingRemoval=false}_EnsureSorted(){if(this._isSorted)return;this._instances.sort(SortByInstLastCachedZIndex);this._isSorted=true}Dump(result){this._FlushPending();this._EnsureSorted();if(this._instances.length)result.push(this._instances)}}};


// c3/layouts/renderGrid.js
'use strict';{const C3=self.C3;C3.RenderGrid=class RenderGrid extends C3.DefendedBase{constructor(cellWidth,cellHeight){super();this._cellWidth=cellWidth;this._cellHeight=cellHeight;this._cells=C3.New(C3.PairMap)}Release(){this._cells.Release();this._cells=null}GetCell(x,y,createIfMissing){let ret=this._cells.Get(x,y);if(ret)return ret;else if(createIfMissing){ret=C3.New(C3.RenderCell,this,x,y);this._cells.Set(x,y,ret);return ret}else return null}XToCell(x){return Math.floor(x/this._cellWidth)}YToCell(y){return Math.floor(y/
this._cellHeight)}Update(inst,oldRange,newRange){if(oldRange)for(let x=oldRange.getLeft(),lenx=oldRange.getRight();x<=lenx;++x)for(let y=oldRange.getTop(),leny=oldRange.getBottom();y<=leny;++y){if(newRange&&newRange.containsPoint(x,y))continue;const cell=this.GetCell(x,y,false);if(!cell)continue;cell.Remove(inst);if(cell.IsEmpty())this._cells.Delete(x,y)}if(newRange)for(let x=newRange.getLeft(),lenx=newRange.getRight();x<=lenx;++x)for(let y=newRange.getTop(),leny=newRange.getBottom();y<=leny;++y){if(oldRange&&
oldRange.containsPoint(x,y))continue;this.GetCell(x,y,true).Insert(inst)}}QueryRange(rc,result){let x=this.XToCell(rc.getLeft());const ystart=this.YToCell(rc.getTop());const lenx=this.XToCell(rc.getRight());const leny=this.YToCell(rc.getBottom());for(;x<=lenx;++x)for(let y=ystart;y<=leny;++y){const cell=this.GetCell(x,y,false);if(!cell)continue;cell.Dump(result)}}MarkRangeChanged(rc){let x=rc.getLeft();const ystart=rc.getTop();const lenx=rc.getRight();const leny=rc.getBottom();for(;x<=lenx;++x)for(let y=
ystart;y<=leny;++y){const cell=this.GetCell(x,y,false);if(!cell)continue;cell.SetChanged()}}}};


// c3/layouts/layer.js
'use strict';{const C3=self.C3;const tmpRect=new C3.Rect;const tmpQuad=new C3.Quad;const renderCellArr=[];const tmpDestRect=new C3.Rect;const tmpSrcRect=new C3.Rect;const glMatrix=self.glMatrix;const vec3=glMatrix.vec3;const tempVec3=vec3.fromValues(0,1,0);function SortByInstLastCachedZIndex(a,b){return a.GetWorldInfo()._GetLastCachedZIndex()-b.GetWorldInfo()._GetLastCachedZIndex()}function SortByInstZElevation(a,b){return a.GetWorldInfo().GetZElevation()-b.GetWorldInfo().GetZElevation()}C3.Layer=
class Layer extends C3.DefendedBase{constructor(layout,index,data){super();this._layout=layout;this._runtime=layout.GetRuntime();this._name=data[0];this._index=index;this._sid=data[2];this._isVisible=!!data[3];this._backgroundColor=C3.New(C3.Color);this._backgroundColor.setFromJSON(data[4].map(x=>x/255));this._isTransparent=!!data[5];this._parallaxX=data[6];this._parallaxY=data[7];this._color=C3.New(C3.Color,1,1,1,data[8]);this._premultipliedColor=C3.New(C3.Color);this._isForceOwnTexture=data[9];
this._renderAs3d=data[17];this._useRenderCells=data[10];this._scaleRate=data[11];this._blendMode=data[12];this._curRenderTarget=null;this._scale=1;this._zElevation=data[16];this._angle=0;this._isAngleEnabled=true;this._viewport=C3.New(C3.Rect);this._viewportZ0=C3.New(C3.Rect);this._startupInitialInstances=[];this._initialInstances=[];this._createdGlobalUids=[];this._initialUIDsToInstanceData=new Map;this._instances=[];this._zIndicesUpToDate=false;this._anyInstanceZElevated=false;this._effectList=
C3.New(C3.EffectList,this,data[15]);this._renderGrid=null;this._lastRenderList=[];this._isRenderListUpToDate=false;this._lastRenderCells=C3.New(C3.Rect,0,0,-1,-1);this._curRenderCells=C3.New(C3.Rect,0,0,-1,-1);this._iLayer=new self.ILayer(this);this._UpdatePremultipliedColor();if(this._useRenderCells)this._renderGrid=C3.New(C3.RenderGrid,this._runtime.GetOriginalViewportWidth(),this._runtime.GetOriginalViewportHeight());for(const instData of data[14]){const objectClass=this._runtime.GetObjectClassByIndex(instData[1]);
this._layout._AddInitialObjectClass(objectClass);if(!objectClass.GetDefaultInstanceData()){objectClass.SetDefaultInstanceData(instData);objectClass._SetDefaultLayerIndex(this._index)}this._initialInstances.push(instData);this._initialUIDsToInstanceData.set(instData[2],instData)}C3.shallowAssignArray(this._startupInitialInstances,this._initialInstances)}static Create(layout,index,data){return C3.New(C3.Layer,layout,index,data)}Release(){this._layout=null;this._runtime=null}GetInitialInstanceData(uid){return this._initialUIDsToInstanceData.get(uid)}CreateInitialInstances(createdInstances){const isFirstVisit=
this._layout.IsFirstVisit();let k=0;const initialInstances=this._initialInstances;for(let i=0,len=initialInstances.length;i<len;++i){const instData=initialInstances[i];const objectClass=this._runtime.GetObjectClassByIndex(instData[1]);let keep=true;if(!objectClass.HasPersistBehavior()||isFirstVisit){const inst=this._runtime.CreateInstanceFromData(instData,this,true);createdInstances.push(inst);if(objectClass.IsGlobal()){keep=false;this._createdGlobalUids.push(inst.GetUID())}}if(keep){initialInstances[k]=
initialInstances[i];++k}}C3.truncateArray(initialInstances,k);this._runtime.FlushPendingInstances();this.SetZIndicesChanged()}_AddInstance(inst,addToGrid){const wi=inst.GetWorldInfo();if(wi.GetLayer()!==this)throw new Error("instance added to wrong layer");this._instances.push(inst);if(wi.GetZElevation()!==0)this._anyInstanceZElevated=true;if(addToGrid&&this._useRenderCells)inst.GetWorldInfo().SetBboxChanged();this.SetZIndicesChanged()}_MaybeAddInstance(inst){if(this._instances.includes(inst))return;
this._instances.push(inst);if(inst.GetWorldInfo().GetZElevation()!==0)this._anyInstanceZElevated=true;this.SetZIndicesChanged()}_PrependInstance(inst,addToGrid){const wi=inst.GetWorldInfo();if(wi.GetLayer()!==this)throw new Error("instance added to wrong layer");this._instances.unshift(inst);if(wi.GetZElevation()!==0)this._anyInstanceZElevated=true;this.SetZIndicesChanged();if(addToGrid&&this._useRenderCells)inst.GetWorldInfo().SetBboxChanged()}_RemoveInstance(inst,removeFromGrid){const index=this._instances.indexOf(inst);
if(index<0)return;if(removeFromGrid&&this._useRenderCells)inst.GetWorldInfo()._RemoveFromRenderCells();this._instances.splice(index,1);this.SetZIndicesChanged();this._MaybeResetAnyInstanceZElevatedFlag()}_SetAnyInstanceZElevated(){this._anyInstanceZElevated=true}_MaybeResetAnyInstanceZElevatedFlag(){if(this._instances.length===0)this._anyInstanceZElevated=false}_SortInstancesByLastCachedZIndex(isPersistMode){if(isPersistMode){const assignedZIndices=new Set;for(const inst of this._instances){const cachedZIndex=
inst.GetWorldInfo()._GetLastCachedZIndex();if(cachedZIndex>=0)assignedZIndices.add(cachedZIndex)}let index=-1;for(const inst of this._instances){const wi=inst.GetWorldInfo();if(wi._GetLastCachedZIndex()>=0)continue;++index;while(assignedZIndices.has(index))++index;wi._SetZIndex(index)}}this._instances.sort(SortByInstLastCachedZIndex)}_Start(){}_End(){for(const inst of this._instances)if(!inst.GetObjectClass().IsGlobal())this._runtime.DestroyInstance(inst);this._runtime.FlushPendingInstances();C3.clearArray(this._instances);
this._anyInstanceZElevated=false;this.SetZIndicesChanged()}RecreateInitialObjects(objectClass,rc,offsetX,offsetY,createHierarchy){const eventSheetManager=this._runtime.GetEventSheetManager();const allObjectClasses=this._runtime.GetAllObjectClasses();const isFamily=objectClass.IsFamily();const ret=[];for(const instData of this._initialInstances){const worldData=instData[0];const x=worldData[0];const y=worldData[1];if(!rc.containsPoint(x,y))continue;const objectType=allObjectClasses[instData[1]];if(objectType!==
objectClass)if(isFamily){if(!objectClass.FamilyHasMember(objectType))continue}else continue;let createOnLayer=this;const runningLayout=this._runtime.GetCurrentLayout();if(this.GetLayout()!==runningLayout){createOnLayer=runningLayout.GetLayerByName(this.GetName());if(!createOnLayer)createOnLayer=runningLayout.GetLayerByIndex(this.GetIndex())}const inst=this._runtime.CreateInstanceFromData(instData,createOnLayer,false,undefined,undefined,false,createHierarchy);createOnLayer.SortAndAddSceneGraphInstancesByZIndex(inst);
const wi=inst.GetWorldInfo();wi.OffsetXY(offsetX,offsetY);wi.SetBboxChanged();eventSheetManager.BlockFlushingInstances(true);inst._TriggerOnCreatedOnSelfAndRelated();eventSheetManager.BlockFlushingInstances(false);ret.push(inst)}return ret}GetInstanceCount(){return this._instances.length}GetLayout(){return this._layout}GetName(){return this._name}GetIndex(){return this._index}GetSID(){return this._sid}GetRuntime(){return this._runtime}GetDevicePixelRatio(){return this._runtime.GetDevicePixelRatio()}GetEffectList(){return this._effectList}UsesRenderCells(){return this._useRenderCells}GetRenderGrid(){return this._renderGrid}SetRenderListStale(){this._isRenderListUpToDate=
false}IsVisible(){return this._isVisible}SetVisible(v){v=!!v;if(this._isVisible===v)return;this._isVisible=v;this._runtime.UpdateRender()}GetViewport(){return this._viewport}GetViewportForZ(z,outRect){const viewportZ0=this._viewportZ0;if(z===0)outRect.copy(viewportZ0);else{const scaleFactor=this.Get2DScaleFactorToZ(z);const midX=viewportZ0.midX();const midY=viewportZ0.midY();const halfW=.5*viewportZ0.width()/scaleFactor;const halfH=.5*viewportZ0.height()/scaleFactor;outRect.set(midX-halfW,midY-halfH,
midX+halfW,midY+halfH)}}GetOpacity(){return this._color.getA()}SetOpacity(o){o=C3.clamp(o,0,1);if(this._color.getA()===o)return;this._color.setA(o);this._UpdatePremultipliedColor();this._runtime.UpdateRender()}_UpdatePremultipliedColor(){this._premultipliedColor.copy(this._color);this._premultipliedColor.premultiply()}GetPremultipliedColor(){return this._premultipliedColor}HasDefaultColor(){return this._color.equalsRgba(1,1,1,1)}GetScaleRate(){return this._scaleRate}SetScaleRate(r){if(this._scaleRate===
r)return;this._scaleRate=r;this._runtime.UpdateRender()}GetParallaxX(){return this._parallaxX}GetParallaxY(){return this._parallaxY}SetParallax(px,py){if(this._parallaxX===px&&this._parallaxY===py)return;this._parallaxX=px;this._parallaxY=py;this._runtime.UpdateRender();if(this._parallaxX!==1||this._parallaxY!==1)for(const inst of this._instances)inst.GetObjectClass()._SetAnyInstanceParallaxed(true)}SetParallaxX(px){this.SetParallax(px,this.GetParallaxY())}SetParallaxY(py){this.SetParallax(this.GetParallaxX(),
py)}SetZElevation(z){z=+z;if(this._zElevation===z)return;this._zElevation=z;this._runtime.UpdateRender()}GetZElevation(){return this._zElevation}SetAngle(a){this._angle=C3.clampAngle(a)}GetAngle(){if(this._isAngleEnabled)return C3.clampAngle(this._layout.GetAngle()+this._angle);else return 0}GetOwnAngle(){return this._angle}HasInstances(){return this._instances.length>0}_GetInstances(){return this._instances}GetBackgroundColor(){return this._backgroundColor}IsTransparent(){return this._isTransparent}SetTransparent(t){this._isTransparent=
!!t}IsForceOwnTexture(){return this._isForceOwnTexture}SetForceOwnTexture(f){this._isForceOwnTexture=!!f}RendersIn2DMode(){return!this.GetRuntime().Uses3DFeatures()||!this._renderAs3d}SetBlendMode(bm){if(this._blendMode===bm)return;this._blendMode=bm;this._runtime.UpdateRender()}GetBlendMode(){return this._blendMode}IsTransformCompatibleWith(otherLayer){return this===otherLayer||this._parallaxX===otherLayer._parallaxX&&this._parallaxY===otherLayer._parallaxY&&this._scale===otherLayer._scale&&this._scaleRate===
otherLayer._scaleRate&&this._angle===otherLayer._angle}_RemoveAllInstancesInSet(s){if(s.size===0)return;const numRemoved=C3.arrayRemoveAllInSet(this._instances,s);if(numRemoved>0){this._MaybeResetAnyInstanceZElevatedFlag();this.SetZIndicesChanged()}}SetZIndicesChanged(){this._zIndicesUpToDate=false;this._isRenderListUpToDate=false}_UpdateZIndices(){if(this._zIndicesUpToDate)return;this._instances.sort(SortByInstZElevation);if(this._useRenderCells)for(let i=0,len=this._instances.length;i<len;++i){const wi=
this._instances[i].GetWorldInfo();wi._SetZIndex(i);this._renderGrid.MarkRangeChanged(wi.GetRenderCellRange())}else for(let i=0,len=this._instances.length;i<len;++i)this._instances[i].GetWorldInfo()._SetZIndex(i);this._zIndicesUpToDate=true}MoveInstanceAdjacent(inst,other,isAfter){const instWi=inst.GetWorldInfo();const otherWi=other.GetWorldInfo();if(instWi.GetLayer()!==this||otherWi.GetLayer()!==this)throw new Error("can't arrange Z order unless both objects on this layer");const myZ=instWi.GetZIndex();
let insertZ=otherWi.GetZIndex();if(myZ===insertZ+(isAfter?1:-1))return false;C3.arrayRemove(this._instances,myZ);if(myZ<insertZ)insertZ--;if(isAfter)insertZ++;if(insertZ===this._instances.length)this._instances.push(inst);else this._instances.splice(insertZ,0,inst);this.SetZIndicesChanged();return true}_MergeSortedZArrays(a,b){const ret=[];let i=0,j=0,lena=a.length,lenb=b.length;while(i<lena&&j<lenb){const ai=a[i];const bj=b[j];if(ai.GetWorldInfo()._GetLastCachedZIndex()<bj.GetWorldInfo()._GetLastCachedZIndex()){ret.push(ai);
++i}else{ret.push(bj);++j}}for(;i<lena;++i)ret.push(a[i]);for(;j<lenb;++j)ret.push(b[j]);return ret}_MergeAllSortedZArrays_pass(arr){const ret=[];const len=arr.length;for(let i=0;i<len-1;i+=2){const arr1=arr[i];const arr2=arr[i+1];ret.push(this._MergeSortedZArrays(arr1,arr2))}if(len%2===1)ret.push(arr[len-1]);return ret}_MergeAllSortedZArrays(arr){while(arr.length>1)arr=this._MergeAllSortedZArrays_pass(arr);return arr[0]}_GetRenderCellInstancesToDraw(){this._UpdateZIndices();C3.clearArray(renderCellArr);
this._renderGrid.QueryRange(this._viewport,renderCellArr);if(!renderCellArr.length)return[];if(renderCellArr.length===1)return renderCellArr[0];return this._MergeAllSortedZArrays(renderCellArr)}_IsOpaque(){return!this.UsesOwnTexture()&&!this.IsTransparent()}ShouldDraw(){return this.IsVisible()&&this.GetOpacity()>0&&(this.HasInstances()||!this.IsTransparent())}UsesOwnTexture(){return this.IsForceOwnTexture()||!this.HasDefaultColor()||this.GetBlendMode()!==0||this._effectList.HasAnyActiveEffect()}GetRenderTarget(){return this._curRenderTarget}_CanFastPathDrawLayer(activeEffectTypes){if(activeEffectTypes.length===
0)return true;if(activeEffectTypes.length>=2)return false;const effectType=activeEffectTypes[0];const shaderProgram=effectType.GetShaderProgram();return!shaderProgram.MustPreDraw()&&!shaderProgram.UsesDest()&&!shaderProgram.UsesCrossSampling()&&this.HasDefaultColor()}Get2DScaleFactorToZ(z){const camZ=this.GetCameraZ();return camZ/(camZ-z)}GetCameraZ(){return 100/this.GetNormalScale()}_SetTransform(renderer,offX=0,offY=0){const renderScale=this._runtime.GetRenderScale();const camX=(this._viewport.midX()+
offX)*renderScale;const camY=(this._viewport.midY()+offY)*renderScale;const camZ=this.GetCameraZ();renderer.SetCameraXYZ(camX,camY,camZ);renderer.SetLookXYZ(camX,camY,camZ-100);const a=this.GetAngle();const upVector=tempVec3;if(a===0)vec3.set(upVector,0,1,0);else vec3.set(upVector,Math.sin(a),Math.cos(a),0);renderer.ResetModelView(upVector);renderer.Scale(renderScale,renderScale);renderer.UpdateModelView()}Draw(renderer,destinationRenderTarget,isFirstDrawnLayer){const canvasManager=this._runtime.GetCanvasManager();
const useOwnTexture=this.UsesOwnTexture();let ownRenderTarget=null;let layerQuery=null;if(this._runtime.IsGPUProfiling()&&renderer.SupportsGPUProfiling()){const timingsBuffer=canvasManager.GetLayerTimingsBuffer(this);if(timingsBuffer){layerQuery=timingsBuffer.AddTimeElapsedQuery();renderer.StartQuery(layerQuery)}}if(useOwnTexture){const rtOpts={sampling:this._runtime.GetSampling()};if(canvasManager.GetCurrentFullscreenScalingQuality()==="low"){rtOpts.width=canvasManager.GetDrawWidth();rtOpts.height=
canvasManager.GetDrawHeight()}ownRenderTarget=this._runtime.GetAdditionalRenderTarget(rtOpts);renderer.SetRenderTarget(ownRenderTarget);if(this.IsTransparent())renderer.ClearRgba(0,0,0,0)}else renderer.SetRenderTarget(destinationRenderTarget);if(!this.IsTransparent())renderer.Clear(this._backgroundColor);this._curRenderTarget=ownRenderTarget||destinationRenderTarget;this._SetTransform(renderer);renderer.SetBaseZ(this.GetZElevation());renderer.SetDepthEnabled(this.GetRuntime().Uses3DFeatures()&&this._renderAs3d);
if(this.GetNormalScale()>Number.EPSILON){this._UpdateZIndices();const useRenderCells=this._useRenderCells&&this.GetZElevation()===0&&!this._anyInstanceZElevated;if(useRenderCells)this._DrawInstances_RenderCells(renderer);else this._DrawInstances(renderer,this._instances)}renderer.SetBaseZ(0);renderer.SetCurrentZ(0);renderer.SetCameraXYZ(0,0,100);renderer.SetLookXYZ(0,0,0);if(useOwnTexture){renderer.SetDepthEnabled(false);this._DrawLayerOwnTextureToRenderTarget(renderer,ownRenderTarget,destinationRenderTarget,
isFirstDrawnLayer)}if(layerQuery)renderer.EndQuery(layerQuery);this._curRenderTarget=null}_DrawInstances(renderer,instances){const viewport=this._viewport;const renderTarget=this._curRenderTarget;let lastInst=null;for(let i=0,len=instances.length;i<len;++i){const inst=instances[i];if(inst===lastInst)continue;lastInst=inst;const wi=inst.GetWorldInfo();if(wi.IsVisible()&&wi.IsInViewport(viewport))if(wi.HasAnyActiveEffect())this._DrawInstanceWithEffectsAndRestore(inst,wi,renderer,renderTarget);else this._DrawInstance(inst,
wi,renderer)}}_DrawInstances_RenderCells(renderer){const renderGrid=this._renderGrid;const curRenderCells=this._curRenderCells;const lastRenderCells=this._lastRenderCells;const viewport=this._viewport;let instancesToDraw;curRenderCells.set(renderGrid.XToCell(viewport.getLeft()),renderGrid.YToCell(viewport.getTop()),renderGrid.XToCell(viewport.getRight()),renderGrid.YToCell(viewport.getBottom()));if(!this._isRenderListUpToDate||!curRenderCells.equals(lastRenderCells)){instancesToDraw=this._GetRenderCellInstancesToDraw();
this._isRenderListUpToDate=true;lastRenderCells.copy(curRenderCells)}else instancesToDraw=this._lastRenderList;this._DrawInstances(renderer,instancesToDraw);if(instancesToDraw!==this._lastRenderList)C3.shallowAssignArray(this._lastRenderList,instancesToDraw)}_DrawInstance(inst,wi,renderer){const wiStateGroup=wi.GetRendererStateGroup();if(renderer.GetCurrentStateGroup()!==wiStateGroup)wiStateGroup.Apply();inst.Draw(renderer)}_DrawInstanceWithEffectsAndRestore(inst,wi,renderer,renderTarget){if(this._DrawInstanceWithEffects(inst,
wi,renderer,renderTarget,null))this._SetTransform(renderer)}_DrawInstanceWithEffects(inst,wi,renderer,renderTarget,opts){const activeEffectTypes=wi.GetInstanceEffectList().GetActiveEffectTypes();if(activeEffectTypes.length===1){const effectType=activeEffectTypes[0];const shaderProgram=effectType.GetShaderProgram();if(!shaderProgram.NeedsPostDrawOrExtendsBox()&&wi.HasDefaultColor()&&!inst.MustPreDraw()){this._DrawInstanceWithEffects_FastPath(inst,wi,effectType,shaderProgram,renderer);return false}}const ret=
C3.RenderEffectChain(renderer,this._runtime,inst,renderTarget,activeEffectTypes,opts);renderer.SetBaseZ(this.GetZElevation());return ret}_DrawInstanceWithEffects_FastPath(inst,wi,effectType,shaderProgram,renderer){renderer.SetProgram(shaderProgram);renderer.SetBlendMode(wi.GetBlendMode());if(shaderProgram.IsAnimated())this._runtime.UpdateRender();let pixelWidth=0,pixelHeight=0;if(shaderProgram.UsesAnySrcRectOrPixelSize()){const [sheetWidth,sheetHeight]=inst.GetCurrentSurfaceSize();pixelWidth=1/sheetWidth;
pixelHeight=1/sheetHeight;const instTexRect=inst.GetCurrentTexRect();if(instTexRect)tmpSrcRect.copy(instTexRect);else tmpSrcRect.set(0,0,0,0)}const paramArr=wi.GetInstanceEffectList().GetEffectParametersForIndex(effectType.GetIndex());renderer.SetCurrentZ(wi.GetZElevation());renderer.SetProgramParameters(null,tmpDestRect,tmpSrcRect,tmpSrcRect,wi.GetBoundingBox(),pixelWidth,pixelHeight,this.GetOwnScale(),this.GetAngle(),this._runtime.GetGameTime(),paramArr);inst.Draw(renderer)}_DrawLayerOwnTextureToRenderTarget(renderer,
ownRenderTarget,destinationRenderTarget,isFirstDrawnLayer){const activeEffectTypes=this._effectList.GetActiveEffectTypes();const runtime=this._runtime;if(this._CanFastPathDrawLayer(activeEffectTypes)){renderer.SetRenderTarget(destinationRenderTarget);if(activeEffectTypes.length===1){const effectType=activeEffectTypes[0];const shaderProgram=effectType.GetShaderProgram();renderer.SetProgram(shaderProgram);tmpSrcRect.set(0,0,1,1);const paramArr=this._effectList.GetEffectParametersForIndex(effectType.GetIndex());
renderer.SetProgramParameters(null,tmpDestRect,tmpSrcRect,tmpSrcRect,this._viewport,1/runtime.GetDrawWidth(),1/runtime.GetDrawHeight(),this.GetNormalScale(),this.GetAngle(),runtime.GetGameTime(),paramArr);if(shaderProgram.IsAnimated())runtime.UpdateRender()}else renderer.SetTextureFillMode();if(isFirstDrawnLayer&&this._blendMode===0&&this.HasDefaultColor()&&activeEffectTypes.length===0)renderer.CopyRenderTarget(ownRenderTarget);else{renderer.SetBlendMode(this._blendMode);renderer.SetColor(this._premultipliedColor);
renderer.DrawRenderTarget(ownRenderTarget)}renderer.InvalidateRenderTarget(ownRenderTarget);runtime.ReleaseAdditionalRenderTarget(ownRenderTarget)}else C3.RenderEffectChain(renderer,runtime,this,destinationRenderTarget,activeEffectTypes)}GetOwnScale(){return this._scale}SetOwnScale(s){if(this._scale===s)return;this._scale=s;this._layout.BoundScrolling();this._runtime.UpdateRender()}GetRenderScale(){return this.GetNormalScale()*this._runtime.GetRenderScale()}GetDisplayScale(){return this.GetNormalScale()*
this._runtime.GetDisplayScale()}GetNormalScale(){return(this._scale*this._layout.GetScale()-1)*this._scaleRate+1}UpdateViewport(){this._isAngleEnabled=false;let [px,py]=this.CanvasCssToLayer(0,0);this._isAngleEnabled=true;if(this._runtime.IsPixelRoundingEnabled()){px=Math.round(px);py=Math.round(py)}const invScale=1/this.GetNormalScale();const viewportZ0=this._viewportZ0;viewportZ0.set(px,py,px+this._runtime.GetViewportWidth()*invScale,py+this._runtime.GetViewportHeight()*invScale);const myAngle=
this.GetAngle();if(myAngle!==0){tmpRect.copy(viewportZ0);tmpRect.offset(-viewportZ0.midX(),-viewportZ0.midY());tmpQuad.setFromRotatedRect(tmpRect,myAngle);tmpQuad.getBoundingBox(tmpRect);tmpRect.offset(viewportZ0.midX(),viewportZ0.midY());viewportZ0.copy(tmpRect)}this.GetViewportForZ(this._zElevation,this._viewport)}CanvasCssToLayer(ptx,pty,z=0){return this._CanvasToLayer(ptx,pty,z,this.GetDisplayScale())}DrawSurfaceToLayer(ptx,pty,z=0){return this._CanvasToLayer(ptx,pty,z,this.GetRenderScale()*this.GetDevicePixelRatio())}_CanvasToLayer(canvasX,
canvasY,zElevation,displayScale){const parallaxOriginX=this._runtime.GetParallaxXOrigin();const parallaxOriginY=this._runtime.GetParallaxYOrigin();const scrollOriginX=(this._layout.GetScrollX()-parallaxOriginX)*this._parallaxX+parallaxOriginX;const scrollOriginY=(this._layout.GetScrollY()-parallaxOriginY)*this._parallaxY+parallaxOriginY;const normalScale=this.GetNormalScale();const scaledViewportWidth=this._runtime.GetViewportWidth()/normalScale;const scaledViewportHeight=this._runtime.GetViewportHeight()/
normalScale;const viewportOriginX=scrollOriginX-scaledViewportWidth/2;const viewportOriginY=scrollOriginY-scaledViewportHeight/2;let layerX=viewportOriginX+canvasX/displayScale;let layerY=viewportOriginY+canvasY/displayScale;const a=this.GetAngle();if(a!==0){layerX-=scrollOriginX;layerY-=scrollOriginY;const cosa=Math.cos(a);const sina=Math.sin(a);const x_temp=layerX*cosa-layerY*sina;layerY=layerY*cosa+layerX*sina;layerX=x_temp;layerX+=scrollOriginX;layerY+=scrollOriginY}if(zElevation!==0){const midX=
this._viewportZ0.midX();const midY=this._viewportZ0.midY();const scaleFactor=this.Get2DScaleFactorToZ(zElevation);layerX=(layerX-midX)/scaleFactor+midX;layerY=(layerY-midY)/scaleFactor+midY}return[layerX,layerY]}CanvasCssToLayer_DefaultTransform(ptx,pty){const scale=this._scale;const scaleRate=this._scaleRate;const parallaxX=this._parallaxX;const parallaxY=this._parallaxY;const angle=this._angle;this._scale=1;this._scaleRate=1;this._parallaxX=1;this._parallaxY=1;this._angle=0;const ret=this.CanvasCssToLayer(ptx,
pty);this._scale=scale;this._scaleRate=scaleRate;this._parallaxX=parallaxX;this._parallaxY=parallaxY;this._angle=angle;return ret}LayerToCanvasCss(ptx,pty,z=0){return this._LayerToCanvas(ptx,pty,z,this.GetDisplayScale())}LayerToDrawSurface(ptx,pty,z=0){return this._LayerToCanvas(ptx,pty,z,this.GetRenderScale()*this.GetDevicePixelRatio())}_LayerToCanvas(layerX,layerY,zElevation,displayScale){const runtime=this._runtime;const layout=this._layout;if(zElevation!==0){const midX=this._viewportZ0.midX();
const midY=this._viewportZ0.midY();const scaleFactor=this.Get2DScaleFactorToZ(zElevation);layerX=(layerX-midX)*scaleFactor+midX;layerY=(layerY-midY)*scaleFactor+midY}const parallaxOriginX=runtime.GetParallaxXOrigin();const parallaxOriginY=runtime.GetParallaxYOrigin();const scrollOriginX=(layout.GetScrollX()-parallaxOriginX)*this._parallaxX+parallaxOriginX;const scrollOriginY=(layout.GetScrollY()-parallaxOriginY)*this._parallaxY+parallaxOriginY;const a=this.GetAngle();if(a!==0){layerX-=scrollOriginX;
layerY-=scrollOriginY;const cosa=Math.cos(-a);const sina=Math.sin(-a);const x_temp=layerX*cosa-layerY*sina;layerY=layerY*cosa+layerX*sina;layerX=x_temp;layerX+=scrollOriginX;layerY+=scrollOriginY}const normalScale=this.GetNormalScale();const scaledViewportWidth=runtime.GetViewportWidth()/normalScale;const scaledViewportHeight=runtime.GetViewportHeight()/normalScale;const viewportOriginX=scrollOriginX-scaledViewportWidth/2;const viewportOriginY=scrollOriginY-scaledViewportHeight/2;const viewportOffX=
layerX-viewportOriginX;const viewportOffY=layerY-viewportOriginY;const canvasX=viewportOffX*displayScale;const canvasY=viewportOffY*displayScale;return[canvasX,canvasY]}_GetLayerToDrawSurfaceScale(size,zElevation){size*=this.GetRenderScale()*this.GetDevicePixelRatio();if(zElevation!==0)size*=this.Get2DScaleFactorToZ(zElevation);return size}_SaveToJson(){const o={"s":this.GetOwnScale(),"a":this.GetOwnAngle(),"vl":this._viewport.getLeft(),"vt":this._viewport.getTop(),"vr":this._viewport.getRight(),
"vb":this._viewport.getBottom(),"v":this.IsVisible(),"bc":this._backgroundColor.toJSON(),"t":this.IsTransparent(),"px":this.GetParallaxX(),"py":this.GetParallaxY(),"c":this._color.toJSON(),"sr":this.GetScaleRate(),"fx":this._effectList.SaveToJson(),"cg":this._createdGlobalUids};return o}_LoadFromJson(o){this._scale=o["s"];this._angle=o["a"];this._viewport.set(o["vl"],o["vt"],o["vr"],o["vb"]);this._isVisible=!!o["v"];this._backgroundColor.setFromJSON(o["bc"]);this._isTransparent=!!o["t"];this._parallaxX=
o["px"];this._parallaxY=o["py"];this._color.setFromJSON(o["c"]);this._scaleRate=o["sr"];C3.shallowAssignArray(this._createdGlobalUids,o["cg"]);C3.shallowAssignArray(this._initialInstances,this._startupInitialInstances);const tempSet=new Set(this._createdGlobalUids);let j=0;for(let i=0,len=this._initialInstances.length;i<len;++i)if(!tempSet.has(this._initialInstances[i][2])){this._initialInstances[j]=this._initialInstances[i];++j}C3.truncateArray(this._initialInstances,j);this._effectList.LoadFromJson(o["fx"]);
this._SortInstancesByLastCachedZIndex(false);this.SetZIndicesChanged()}GetILayer(){return this._iLayer}SortAndAddSceneGraphInstancesByZIndex(inst){if(this._instances.includes(inst))return;if(inst.HasChildren()){const instances=[...inst.allChildren()];instances.push(inst);instances.sort((f,s)=>{const firstZIndex=f.GetWorldInfo().GetSceneGraphZIndex();const secondZIndex=s.GetWorldInfo().GetSceneGraphZIndex();return firstZIndex-secondZIndex});for(const instance of instances)this._AddInstance(instance,
true)}else this._AddInstance(inst,true)}}};


// c3/layouts/layout.js
'use strict';{const C3=self.C3;const C3Debugger=self.C3Debugger;const assert=self.assert;const tempDestRect=C3.New(C3.Rect);const tempSrcRect=C3.New(C3.Rect);const tempLayoutRect=C3.New(C3.Rect);C3.Layout=class Layout extends C3.DefendedBase{constructor(layoutManager,index,data){super();this._layoutManager=layoutManager;this._runtime=layoutManager.GetRuntime();this._name=data[0];this._originalWidth=data[1];this._originalHeight=data[2];this._width=data[1];this._height=data[2];this._isUnboundedScrolling=
!!data[3];this._eventSheetName=data[4];this._eventSheet=null;this._sid=data[5];this._index=index;this._scrollX=0;this._scrollY=0;this._scale=1;this._angle=0;this._initialObjectClasses=new Set;this._textureLoadedTypes=new Set;this._textureLoadPendingPromises=new Set;this._createdInstances=[];this._initialNonWorld=[];this._layers=[];this._layersByName=new Map;this._layersBySid=new Map;this._effectList=C3.New(C3.EffectList,this,data[8]);this._curRenderTarget=null;this._persistData={};this._isFirstVisit=
true;this._iLayout=new self.ILayout(this);this._userScriptDispatcher=C3.New(C3.Event.Dispatcher);for(const layerData of data[6]){const layer=C3.Layer.Create(this,this._layers.length,layerData);this._layers.push(layer);this._layersByName.set(layer.GetName().toLowerCase(),layer);this._layersBySid.set(layer.GetSID(),layer)}for(const instData of data[7]){const objectClass=this._runtime.GetObjectClassByIndex(instData[1]);if(!objectClass)throw new Error("missing nonworld object class");if(!objectClass.GetDefaultInstanceData())objectClass.SetDefaultInstanceData(instData);
this._initialNonWorld.push(instData);this._AddInitialObjectClass(objectClass)}}Release(){for(const l of this._layers)l.Release();C3.clearArray(this._layers);this._textureLoadPendingPromises.clear();this._eventSheet=null;this._layoutManager=null;this._runtime=null}GetRuntime(){return this._runtime}GetName(){return this._name}GetSID(){return this._sid}GetIndex(){return this._index}GetEffectList(){return this._effectList}GetMinLayerScale(){let m=this._layers[0].GetNormalScale();for(let i=1,len=this._layers.length;i<
len;++i){const layer=this._layers[i];if(layer.GetParallaxX()===0&&layer.GetParallaxY()===0)continue;m=Math.min(m,layer.GetNormalScale())}return m}SetScrollX(x){if(!this._isUnboundedScrolling){const widthBoundary=this._runtime.GetViewportWidth()*(1/this.GetMinLayerScale())/2;if(x>this._width-widthBoundary)x=this._width-widthBoundary;if(x<widthBoundary)x=widthBoundary}if(this._scrollX!==x){this._scrollX=x;this._runtime.UpdateRender()}}GetScrollX(){return this._scrollX}SetScrollY(y){if(!this._isUnboundedScrolling){const heightBoundary=
this._runtime.GetViewportHeight()*(1/this.GetMinLayerScale())/2;if(y>this._height-heightBoundary)y=this._height-heightBoundary;if(y<heightBoundary)y=heightBoundary}if(this._scrollY!==y){this._scrollY=y;this._runtime.UpdateRender()}}GetScrollY(){return this._scrollY}BoundScrolling(){this.SetScrollX(this.GetScrollX());this.SetScrollY(this.GetScrollY())}GetScale(){return this._scale}SetScale(s){s=+s;if(this._scale===s)return;this._scale=s;this.BoundScrolling()}SetAngle(a){this._angle=C3.clampAngle(a)}GetAngle(){return this._angle}GetWidth(){return this._width}SetWidth(w){if(!isFinite(w)||
w<1)return;this._width=w}GetHeight(){return this._height}SetHeight(h){if(!isFinite(h)||h<1)return;this._height=h}GetEventSheet(){return this._eventSheet}GetLayers(){return this._layers}GetLayerCount(){return this._layers.length}GetLayer(p){if(typeof p==="number")return this.GetLayerByIndex(p);else return this.GetLayerByName(p.toString())}GetLayerByIndex(i){i=C3.clamp(Math.floor(i),0,this._layers.length-1);return this._layers[i]}GetLayerByName(name){return this._layersByName.get(name.toLowerCase())||
null}GetLayerBySID(sid){return this._layersBySid.get(sid)||null}HasOpaqueBottomLayer(){for(const layer of this._layers)if(layer.ShouldDraw())return layer._IsOpaque();return false}IsFirstVisit(){return this._isFirstVisit}_GetInitialObjectClasses(){return[...this._initialObjectClasses]}_AddInitialObjectClass(objectClass){if(objectClass.IsInContainer())for(const containerType of objectClass.GetContainer().GetObjectTypes())this._initialObjectClasses.add(containerType);else this._initialObjectClasses.add(objectClass)}_GetTextureLoadedObjectTypes(){return[...this._textureLoadedTypes]}_Load(previousLayout,
renderer){if(previousLayout===this||!renderer)return Promise.resolve();if(previousLayout){C3.CopySet(this._textureLoadedTypes,previousLayout._textureLoadedTypes);previousLayout._textureLoadedTypes.clear()}const promises=[];for(const oc of this._initialObjectClasses)if(!this._textureLoadedTypes.has(oc)){promises.push(oc.LoadTextures(renderer));this._textureLoadedTypes.add(oc)}return Promise.all(promises)}async MaybeLoadTexturesFor(objectClass){if(objectClass.IsFamily())throw new Error("cannot load textures for family");
const renderer=this._runtime.GetWebGLRenderer();if(!renderer||renderer.IsContextLost()||this._textureLoadedTypes.has(objectClass))return;this._textureLoadedTypes.add(objectClass);const loadPromise=objectClass.LoadTextures(renderer);this._AddPendingTextureLoadPromise(loadPromise);await loadPromise;objectClass.OnDynamicTextureLoadComplete();this._runtime.UpdateRender()}_AddPendingTextureLoadPromise(promise){this._textureLoadPendingPromises.add(promise);promise.then(()=>this._textureLoadPendingPromises.delete(promise)).catch(()=>
this._textureLoadPendingPromises.delete(promise))}WaitForPendingTextureLoadsToComplete(){return Promise.all([...this._textureLoadPendingPromises])}MaybeUnloadTexturesFor(objectClass){if(objectClass.IsFamily()||objectClass.GetInstanceCount()>0)throw new Error("cannot unload textures");const renderer=this._runtime.GetWebGLRenderer();if(!renderer||!this._textureLoadedTypes.has(objectClass))return;this._textureLoadedTypes.delete(objectClass);objectClass.ReleaseTextures(renderer)}_Unload(nextLayout,renderer){if(nextLayout===
this||!renderer)return;for(const oc of this._textureLoadedTypes)if(!oc.IsGlobal()&&!nextLayout._initialObjectClasses.has(oc)){oc.ReleaseTextures();this._textureLoadedTypes.delete(oc)}}_OnWebGLContextLost(){this._textureLoadedTypes.clear()}async _StartRunning(isFirstLayout){const runtime=this._runtime;const layoutManager=this._layoutManager;const eventSheetManager=runtime.GetEventSheetManager();if(this._eventSheetName){this._eventSheet=eventSheetManager.GetEventSheetByName(this._eventSheetName);this._eventSheet._UpdateDeepIncludes()}layoutManager._SetMainRunningLayout(this);
this._width=this._originalWidth;this._height=this._originalHeight;this._scrollX=runtime.GetOriginalViewportWidth()/2;this._scrollY=runtime.GetOriginalViewportHeight()/2;this.BoundScrolling();this._MoveGlobalObjectsToThisLayout(isFirstLayout);this._runtime.SetUsingCreatePromises(true);this._CreateInitialInstances();if(!this._isFirstVisit)this._CreatePersistedInstances();this._CreateAndLinkContainerInstances(this._createdInstances);this._CreateInitialNonWorldInstances();layoutManager.ClearPendingChangeLayout();
runtime.FlushPendingInstances();this._runtime.SetUsingCreatePromises(false);const createPromises=this._runtime.GetCreatePromises();await Promise.all(createPromises);C3.clearArray(createPromises);if(!runtime.IsLoadingState()){for(const inst of this._createdInstances)inst.SetupInitialSceneGraphConnections();for(const inst of this._createdInstances)inst._TriggerOnCreated()}C3.clearArray(this._createdInstances);await Promise.all([...this._initialObjectClasses].map(oc=>oc.PreloadTexturesWithInstances(this._runtime.GetWebGLRenderer())));
if(isFirstLayout){runtime.Dispatcher().dispatchEvent(new C3.Event("beforefirstlayoutstart"));await runtime.DispatchUserScriptEventAsyncWait(new C3.Event("beforeprojectstart"))}await this.DispatchUserScriptEventAsyncWait(new C3.Event("beforelayoutstart"));if(!runtime.IsLoadingState())await runtime.TriggerAsync(C3.Plugins.System.Cnds.OnLayoutStart,null,null);await this.DispatchUserScriptEventAsyncWait(new C3.Event("afterlayoutstart"));if(isFirstLayout){runtime.Dispatcher().dispatchEvent(new C3.Event("afterfirstlayoutstart"));
await runtime.DispatchUserScriptEventAsyncWait(new C3.Event("afterprojectstart"))}eventSheetManager._RunQueuedTriggers(layoutManager);await this.WaitForPendingTextureLoadsToComplete();this._isFirstVisit=false}_MoveGlobalObjectsToThisLayout(isFirstLayout){for(const objectClass of this._runtime.GetAllObjectClasses()){if(objectClass.IsFamily()||!objectClass.IsWorldType())continue;for(const inst of objectClass.GetInstances()){const wi=inst.GetWorldInfo();const oldLayer=wi.GetLayer();const layerIndex=
C3.clamp(oldLayer.GetIndex(),0,this._layers.length-1);const newLayer=this._layers[layerIndex];wi._SetLayer(newLayer);newLayer._MaybeAddInstance(inst)}}if(!isFirstLayout)for(const layer of this._layers)layer._SortInstancesByLastCachedZIndex(false)}_CreateInitialInstances(){for(const layer of this._layers){layer.CreateInitialInstances(this._createdInstances);layer.UpdateViewport();layer._Start()}}_CreatePersistedInstances(){let uidsChanged=false;for(const [sidStr,typeData]of Object.entries(this._persistData)){const objectClass=
this._runtime.GetObjectClassBySID(parseInt(sidStr,10));if(!objectClass||objectClass.IsFamily()||!objectClass.HasPersistBehavior())continue;for(const instData of typeData){let layer=null;if(objectClass.IsWorldType()){layer=this.GetLayerBySID(instData["w"]["l"]);if(!layer)continue}const inst=this._runtime.CreateInstanceFromData(objectClass,layer,false,0,0,true);inst.LoadFromJson(instData);uidsChanged=true;this._createdInstances.push(inst)}C3.clearArray(typeData)}for(const layer of this._layers){layer._SortInstancesByLastCachedZIndex(true);
layer.SetZIndicesChanged()}if(uidsChanged){this._runtime.FlushPendingInstances();this._runtime._RefreshUidMap()}}_CreateAndLinkContainerInstances(createdInstances){for(const inst of createdInstances){if(!inst.IsInContainer())continue;const wi=inst.GetWorldInfo();const iid=inst.GetIID();for(const containerType of inst.GetObjectClass().GetContainer().objectTypes()){if(containerType===inst.GetObjectClass())continue;const instances=containerType.GetInstances();if(instances.length>iid)inst._AddSibling(instances[iid]);
else{let s;if(wi)s=this._runtime.CreateInstanceFromData(containerType,wi.GetLayer(),true,wi.GetX(),wi.GetY(),true);else s=this._runtime.CreateInstanceFromData(containerType,null,true,0,0,true);this._runtime.FlushPendingInstances();containerType._UpdateIIDs();inst._AddSibling(s);createdInstances.push(s)}}}}_CreateInitialNonWorldInstances(){for(const instData of this._initialNonWorld){const objectClass=this._runtime.GetObjectClassByIndex(instData[1]);if(!objectClass.IsInContainer())this._runtime.CreateInstanceFromData(instData,
null,true)}}_CreateGlobalNonWorlds(){const createdInstances=[];const initialNonWorld=this._initialNonWorld;let k=0;for(let i=0,len=initialNonWorld.length;i<len;++i){const instData=initialNonWorld[i];const objectClass=this._runtime.GetObjectClassByIndex(instData[1]);if(objectClass.IsGlobal()){if(!objectClass.IsInContainer()||!objectClass.GetContainer().HasAnyWorldType())createdInstances.push(this._runtime.CreateInstanceFromData(instData,null,true))}else{initialNonWorld[k]=instData;++k}}C3.truncateArray(initialNonWorld,
k);this._runtime.FlushPendingInstances();this._CreateAndLinkContainerInstances(createdInstances)}RecreateInitialObjects(objectClass,rc,srcLayer,offsetX,offsetY,createHierarchy){if(srcLayer)return srcLayer.RecreateInitialObjects(objectClass,rc,offsetX,offsetY,createHierarchy);else{const ret=[];for(const layer of this._layers)ret.push(layer.RecreateInitialObjects(objectClass,rc,offsetX,offsetY,createHierarchy));return ret.flat()}}async _StopRunning(){const layoutManager=this._layoutManager;if(!this._runtime.IsLoadingState())await this._runtime.TriggerAsync(C3.Plugins.System.Cnds.OnLayoutEnd,
null,null);layoutManager.SetIsEndingLayout(true);this._runtime.GetEventSheetManager().ClearAllScheduledWaits();if(!this._isFirstVisit)this._SavePersistData();for(const layer of this._layers)layer._End();for(const objectClass of this._runtime.GetAllObjectClasses()){if(objectClass.IsGlobal()||objectClass.IsWorldType()||objectClass.GetPlugin().IsSingleGlobal()||objectClass.IsFamily())continue;for(const inst of objectClass.GetInstances())this._runtime.DestroyInstance(inst);this._runtime.FlushPendingInstances()}layoutManager.SetIsEndingLayout(false);
if(layoutManager.GetMainRunningLayout()===this)layoutManager._SetMainRunningLayout(null)}_SaveInstanceToPersist(inst){const sidStr=inst.GetObjectClass().GetSID().toString();if(!this._persistData.hasOwnProperty(sidStr))this._persistData[sidStr]=[];const typePersist=this._persistData[sidStr];typePersist.push(inst.SaveToJson())}_SavePersistData(){for(const layer of this._layers){layer._UpdateZIndices();for(const inst of layer._GetInstances()){const objectClass=inst.GetObjectClass();if(!objectClass.IsGlobal()&&
objectClass.HasPersistBehavior())this._SaveInstanceToPersist(inst)}}}ResetPersistData(){this._persistData={};this._isFirstVisit=true}GetRenderTarget(){return this._curRenderTarget}UsesOwnTexture(){return this._runtime.GetCanvasManager().GetCurrentFullscreenScalingQuality()==="low"||this._runtime.UsesAnyBackgroundBlending()||this._runtime.GetCompositingMode()==="low-latency"||this._effectList.HasAnyActiveEffect()||this._runtime.Uses3DFeatures()}_CanFastPathDrawLayout(activeEffectTypes){if(activeEffectTypes.length===
0)return true;if(activeEffectTypes.length>=2)return false;const effectType=activeEffectTypes[0];const shaderProgram=effectType.GetShaderProgram();return!shaderProgram.MustPreDraw()}Draw(renderer){const canvasManager=this._runtime.GetCanvasManager();const useOwnTexture=this.UsesOwnTexture();let ownRenderTarget=null;if(useOwnTexture){if(this._runtime.GetCompositingMode()!=="low-latency"){renderer.SetRenderTarget(null);renderer.ClearRgba(0,0,0,0)}const rtOpts={sampling:this._runtime.GetSampling(),readback:this._runtime.UsesAnyBackgroundBlending()||
this._effectList.HasAnyActiveEffect()};if(canvasManager.GetCurrentFullscreenScalingQuality()==="low"){rtOpts.width=canvasManager.GetDrawWidth();rtOpts.height=canvasManager.GetDrawHeight()}ownRenderTarget=this._runtime.GetAdditionalRenderTarget(rtOpts);renderer.SetRenderTarget(ownRenderTarget)}else renderer.SetRenderTarget(null);if(!this.HasOpaqueBottomLayer())renderer.ClearRgba(0,0,0,0);if(this._runtime.Uses3DFeatures())renderer.ClearDepth();this._curRenderTarget=ownRenderTarget;let isFirstDrawnLayer=
true;for(const layer of this._layers){layer.UpdateViewport();if(layer.ShouldDraw()){layer.Draw(renderer,ownRenderTarget,isFirstDrawnLayer);isFirstDrawnLayer=false}}if(useOwnTexture){renderer.SetDepthEnabled(false);this._DrawLayoutOwnTextureToRenderTarget(renderer,ownRenderTarget)}this._curRenderTarget=null}_DrawLayoutOwnTextureToRenderTarget(renderer,ownRenderTarget){const activeEffectTypes=this._effectList.GetActiveEffectTypes();const runtime=this._runtime;if(this._CanFastPathDrawLayout(activeEffectTypes)){renderer.SetRenderTarget(null);
if(activeEffectTypes.length===1){const effectType=activeEffectTypes[0];const shaderProgram=effectType.GetShaderProgram();renderer.SetProgram(shaderProgram);tempSrcRect.set(0,0,1,1);tempLayoutRect.set(0,0,runtime.GetViewportWidth(),runtime.GetViewportHeight());const paramArr=this._effectList.GetEffectParametersForIndex(effectType.GetIndex());renderer.SetProgramParameters(null,tempDestRect,tempSrcRect,tempSrcRect,tempLayoutRect,1/runtime.GetDrawWidth(),1/runtime.GetDrawHeight(),this.GetScale(),this.GetAngle(),
runtime.GetGameTime(),paramArr);if(shaderProgram.IsAnimated())runtime.UpdateRender()}else renderer.SetTextureFillMode();if(activeEffectTypes.length===0)renderer.CopyRenderTarget(ownRenderTarget);else{renderer.SetAlphaBlend();renderer.ResetColor();renderer.DrawRenderTarget(ownRenderTarget)}renderer.InvalidateRenderTarget(ownRenderTarget);runtime.ReleaseAdditionalRenderTarget(ownRenderTarget)}else C3.RenderEffectChain(renderer,runtime,this,null,activeEffectTypes)}_SaveToJson(){const o={"sx":this.GetScrollX(),
"sy":this.GetScrollY(),"s":this.GetScale(),"a":this.GetAngle(),"w":this.GetWidth(),"h":this.GetHeight(),"fv":this._isFirstVisit,"persist":this._persistData,"fx":this._effectList.SaveToJson(),"layers":{}};for(const layer of this._layers)o["layers"][layer.GetSID().toString()]=layer._SaveToJson();return o}_LoadFromJson(o){this._scrollX=o["sx"];this._scrollY=o["sy"];this._scale=o["s"];this._angle=o["a"];this._width=o["w"];this._height=o["h"];this._isFirstVisit=!!o["fv"];this._persistData=o["persist"];
this._effectList.LoadFromJson(o["fx"]);for(const [sidStr,data]of Object.entries(o["layers"])){const sid=parseInt(sidStr,10);const layer=this.GetLayerBySID(sid);if(!layer)continue;layer._LoadFromJson(data)}}GetILayout(){return this._iLayout}UserScriptDispatcher(){return this._userScriptDispatcher}DispatchUserScriptEvent(e){e.layout=this.GetILayout();const runtime=this._runtime;const shouldTime=runtime.IsDebug()&&!runtime.GetEventSheetManager().IsInEventEngine();if(shouldTime)C3Debugger.StartMeasuringScriptTime();
this._userScriptDispatcher.dispatchEvent(e);if(shouldTime)C3Debugger.AddScriptTime()}DispatchUserScriptEventAsyncWait(e){e.layout=this.GetILayout();return this._userScriptDispatcher.dispatchEventAndWaitAsync(e)}}};


// c3/layouts/layoutManager.js
'use strict';{const C3=self.C3;C3.LayoutManager=class LayoutManager extends C3.DefendedBase{constructor(runtime){super();this._runtime=runtime;this._allLayouts=[];this._layoutsByName=new Map;this._layoutsBySid=new Map;this._mainRunningLayout=null;this._runningSubLayouts=[];this._firstLayout=null;this._isEndingLayout=0;this._pendingChangeLayout=null}Release(){this._runtime=null;this._mainRunningLayout=null;this._firstLayout=null;this._pendingChangeLayout=null;C3.clearArray(this._allLayouts);this._layoutsByName.clear();
this._layoutsBySid.clear();C3.clearArray(this._runningSubLayouts)}Create(layoutData){const layout=C3.New(C3.Layout,this,this._allLayouts.length,layoutData);this._allLayouts.push(layout);this._layoutsByName.set(layout.GetName().toLowerCase(),layout);this._layoutsBySid.set(layout.GetSID(),layout)}GetRuntime(){return this._runtime}SetFirstLayout(layout){this._firstLayout=layout}GetFirstLayout(){if(this._firstLayout)return this._firstLayout;if(this._allLayouts.length)return this._allLayouts[0];throw new Error("no first layout");
}GetLayoutByName(name){return this._layoutsByName.get(name.toLowerCase())||null}GetLayoutBySID(sid){return this._layoutsBySid.get(sid)||null}GetLayoutByIndex(index){index=C3.clamp(Math.floor(index),0,this._allLayouts.length-1);return this._allLayouts[index]}GetLayout(p){if(typeof p==="number")return this.GetLayoutByIndex(p);else return this.GetLayoutByName(p.toString())}GetAllLayouts(){return this._allLayouts}_SetMainRunningLayout(layout){this._mainRunningLayout=layout}GetMainRunningLayout(){return this._mainRunningLayout}_AddRunningSubLayout(layout){if(this._runningSubLayouts.includes(layout))throw new Error("layout already running");
this._runningSubLayouts.push(layout)}_RemoveRunningSubLayout(layout){const i=this._runningSubLayouts.indexOf(layout);if(i===-1)throw new Error("layout not running");this._runningSubLayouts.splice(i,1)}*runningLayouts(){if(this._mainRunningLayout)yield this._mainRunningLayout;if(this._runningSubLayouts.length)yield*this._runningSubLayouts}IsLayoutRunning(layout){return this._mainRunningLayout===layout||this._runningSubLayouts.includes(layout)}SetIsEndingLayout(e){if(e)this._isEndingLayout++;else{if(this._isEndingLayout<=
0)throw new Error("already unset");this._isEndingLayout--}}IsEndingLayout(){return this._isEndingLayout>0}ChangeMainLayout(layout){this._pendingChangeLayout=layout}ClearPendingChangeLayout(){this._pendingChangeLayout=null}IsPendingChangeMainLayout(){return!!this._pendingChangeLayout}GetPendingChangeMainLayout(){return this._pendingChangeLayout}}};


// c3/layouts/renderEffectChain.js
'use strict';{const C3=self.C3;class RenderEffectChainState{constructor(){this.renderer=null;this.runtime=null;this.drawWidth=0;this.drawHeight=0;this.surfaceWidth=0;this.surfaceHeight=0;this.layoutRect=new C3.Rect;this.rcTexBounce=new C3.Rect;this.rcTexDest=new C3.Rect;this.rcTexOrigin=new C3.Rect;this.screenRect=new C3.Rect;this.clearRect=new C3.Rect;this.srcRect=new C3.Rect;this.fxTex=[null,null];this.fxIndex=0;this.otherFxIndex=1;this.boxExtendHorizontal=0;this.boxExtendVertical=0;this.layerScale=
0;this.layerAngle=0;this.layout=null;this.layer=null;this.inst=null;this.wi=null;this.renderTarget=null;this.preDraw=false;this.postDraw=false;this.didChangeTransform=false;this.opts=null}Clear(){this.renderer=null;this.runtime=null;this.layout=null;this.layer=null;this.inst=null;this.wi=null;this.renderTarget=null;this.opts=null}ShouldPreDraw(firstEffectType){const shaderProgram=firstEffectType.GetShaderProgram();if(shaderProgram.MustPreDraw())return true;if(this.inst)return shaderProgram.UsesDest()&&
(this.wi.GetAngle()!==0||this.wi.GetWidth()<0||this.wi.GetHeight()<0)||this.boxExtendHorizontal!==0||this.boxExtendVertical!==0||!this.wi.HasDefaultColor()||this.inst.MustPreDraw();else if(this.layer)return!this.layer.HasDefaultColor()}ShouldPostDraw(lastEffectType){const shaderProgram=lastEffectType.GetShaderProgram();return shaderProgram.UsesDest()||shaderProgram.UsesCrossSampling()||this.layout&&this.runtime.GetCanvasManager().GetCurrentFullscreenScalingQuality()==="low"}GetEffectRenderTarget(i){if(i!==
0&&i!==1)throw new Error("invalid effect target");const fxTex=this.fxTex;if(!fxTex[i]){const runtime=this.runtime;const canvasManager=runtime.GetCanvasManager();const opts={sampling:runtime.GetSampling()};if(canvasManager.GetCurrentFullscreenScalingQuality()==="low"){opts.width=canvasManager.GetDrawWidth();opts.height=canvasManager.GetDrawHeight()}fxTex[i]=canvasManager.GetAdditionalRenderTarget(opts)}return fxTex[i]}ReleaseEffectRenderTargets(){const fxTex=this.fxTex;const canvasManager=this.runtime.GetCanvasManager();
if(fxTex[0]){canvasManager.ReleaseAdditionalRenderTarget(fxTex[0]);fxTex[0]=null}if(fxTex[1]){canvasManager.ReleaseAdditionalRenderTarget(fxTex[1]);fxTex[1]=null}}}const ctxStack=[];let ctxPtr=0;function AllocRenderEffectChainState(){if(ctxPtr===ctxStack.length)ctxStack.push(new RenderEffectChainState);return ctxStack[ctxPtr++]}function ReleaseRenderEffectChainState(ctx){ctx.ReleaseEffectRenderTargets();ctx.Clear();ctxPtr--}const tempQuad=new C3.Quad;let isDebug=false;let isDebugFrame=false;async function DebugLogRenderTargetContents(msg,
renderer,renderTarget){const blob=await C3.Gfx.WebGLRenderTarget.DebugReadPixelsToBlob(renderer,renderTarget);const blobUrl=URL.createObjectURL(blob);console.log("[FX] "+msg+" "+(renderTarget?"":" [to display]")+": ",blobUrl)}C3.RenderEffectChain=function RenderEffectChain(renderer,runtime,effectsObject,renderTarget_,activeEffectTypes,opts_){const ctx=AllocRenderEffectChainState();ctx.renderer=renderer;ctx.runtime=runtime;if(effectsObject instanceof C3.Instance){ctx.inst=effectsObject;ctx.wi=ctx.inst.GetWorldInfo()}else if(effectsObject instanceof
C3.Layer)ctx.layer=effectsObject;else if(effectsObject instanceof C3.Layout)ctx.layout=effectsObject;else throw new Error("invalid effects object");const canvasManager=runtime.GetCanvasManager();ctx.renderTarget=renderTarget_;ctx.drawWidth=canvasManager.GetDrawWidth();ctx.drawHeight=canvasManager.GetDrawHeight();ctx.surfaceWidth=ctx.drawWidth;ctx.surfaceHeight=ctx.drawHeight;ctx.fxIndex=0;ctx.otherFxIndex=1;ctx.boxExtendHorizontal=0;ctx.boxExtendVertical=0;ctx.screenRect.set(0,0,ctx.drawWidth,ctx.drawHeight);
ctx.clearRect.set(0,0,ctx.drawWidth,ctx.drawHeight);ctx.didChangeTransform=false;ctx.opts=opts_;if(ctx.inst){const wi=ctx.wi;ctx.layerScale=wi.GetLayer().GetRenderScale();ctx.layerAngle=wi.GetLayer().GetAngle();ctx.layoutRect.copy(wi.GetBoundingBox())}else if(ctx.layer){const layer=ctx.layer;ctx.layerScale=layer.GetRenderScale();ctx.layerAngle=layer.GetAngle();ctx.layoutRect.copy(layer.GetViewport())}else{const layout=ctx.layout;ctx.layerScale=layout.GetScale();ctx.layerAngle=layout.GetAngle();ctx.layoutRect.set(0,
0,ctx.drawWidth,ctx.drawHeight)}if(ctx.inst)GetInstanceBox(ctx,activeEffectTypes);else{ctx.rcTexBounce.set(0,0,ctx.drawWidth/ctx.surfaceWidth,ctx.drawHeight/ctx.surfaceHeight);ctx.rcTexDest.copy(ctx.rcTexBounce);ctx.rcTexOrigin.copy(ctx.rcTexBounce);ctx.rcTexBounce.swapTopBottom();ctx.rcTexDest.swapTopBottom();ctx.rcTexOrigin.swapTopBottom()}renderer.SetAlphaBlend();renderer.ResetColor();renderer.SetBaseZ(0);renderer.SetCurrentZ(0);ctx.preDraw=ctx.ShouldPreDraw(activeEffectTypes[0]);if(ctx.preDraw)PreDraw(ctx);
renderer.ResetColor();const lastEffectTypeIndex=activeEffectTypes.length-1;ctx.postDraw=ctx.ShouldPostDraw(activeEffectTypes[lastEffectTypeIndex]);for(let i=0,len=activeEffectTypes.length;i<len;++i){const effectType=activeEffectTypes[i];const shaderProgram=effectType.GetShaderProgram();renderer.SetProgram(shaderProgram);if(shaderProgram.IsAnimated())runtime.UpdateRender();if(i===0&&!ctx.preDraw)RenderFirstBounce(ctx,effectType);else{renderer.SetCopyBlend();const isLast=i===lastEffectTypeIndex&&!ctx.postDraw;
RenderBounce(ctx,effectType,isLast,i)}if(ctx.fxIndex===0){ctx.fxIndex=1;ctx.otherFxIndex=0}else{ctx.fxIndex=0;ctx.otherFxIndex=1}}if(ctx.postDraw)PostDraw(ctx,activeEffectTypes);const ret=ctx.didChangeTransform;ReleaseRenderEffectChainState(ctx);isDebugFrame=false;return ret};function GetInstanceBox(ctx,activeEffectTypes){for(let i=0,len=activeEffectTypes.length;i<len;++i){const shaderProgram=activeEffectTypes[i].GetShaderProgram();ctx.boxExtendHorizontal+=shaderProgram.GetBoxExtendHorizontal();ctx.boxExtendVertical+=
shaderProgram.GetBoxExtendVertical()}const wi=ctx.wi;const layer=wi.GetLayer();const layerAngle=layer.GetAngle();const bbox=wi.GetBoundingBox();const z=wi.GetTotalZElevation();let [sl,st]=layer.LayerToDrawSurface(bbox.getLeft(),bbox.getTop(),z);let [sr,sb]=layer.LayerToDrawSurface(bbox.getRight(),bbox.getBottom(),z);if(layerAngle!==0){const [strx,stry]=layer.LayerToDrawSurface(bbox.getRight(),bbox.getTop(),z);const [sblx,sbly]=layer.LayerToDrawSurface(bbox.getLeft(),bbox.getBottom(),z);let temp=Math.min(sl,
sr,strx,sblx);sr=Math.max(sl,sr,strx,sblx);sl=temp;temp=Math.min(st,sb,stry,sbly);sb=Math.max(st,sb,stry,sbly);st=temp}const screenRect=ctx.screenRect;const rcTexOrigin=ctx.rcTexOrigin;const rcTexDest=ctx.rcTexDest;const clearRect=ctx.clearRect;const rcTexBounce=ctx.rcTexBounce;screenRect.set(sl,st,sr,sb);screenRect.shuntY(ctx.drawHeight);rcTexOrigin.copy(screenRect);rcTexOrigin.divide(ctx.surfaceWidth,ctx.surfaceHeight);rcTexOrigin.swapTopBottom();screenRect.inflate(ctx.boxExtendHorizontal,ctx.boxExtendVertical);
rcTexDest.copy(screenRect);rcTexDest.divide(ctx.surfaceWidth,ctx.surfaceHeight);rcTexDest.swapTopBottom();clearRect.copy(screenRect);clearRect.roundOuter();clearRect.inflate(ctx.boxExtendHorizontal+1,ctx.boxExtendVertical+1);screenRect.clamp(0,0,ctx.drawWidth,ctx.drawHeight);clearRect.clamp(0,0,ctx.drawWidth,ctx.drawHeight);rcTexBounce.copy(screenRect);rcTexBounce.divide(ctx.surfaceWidth,ctx.surfaceHeight);rcTexBounce.swapTopBottom()}function PreDraw(ctx){const renderer=ctx.renderer;renderer.SetTextureFillMode();
const fxTarget=ctx.GetEffectRenderTarget(ctx.fxIndex);renderer.SetRenderTarget(fxTarget);const opts=ctx.opts;if(opts&&opts.preTransform)opts.preTransform();if(isDebug)renderer.ClearRgba(1,0,0,1);renderer.ClearRect2(ctx.clearRect);if(ctx.inst){renderer.SetColor(ctx.wi.GetPremultipliedColor());renderer.SetCurrentZ(ctx.wi.GetTotalZElevation());ctx.inst.Draw(renderer);renderer.SetCurrentZ(0)}else{const renderSurface=(ctx.layer||ctx.layout).GetRenderTarget();if(ctx.layer)renderer.SetColor(ctx.layer.GetPremultipliedColor());
else renderer.ResetColor();renderer.DrawRenderTarget(renderSurface);renderer.InvalidateRenderTarget(renderSurface);ctx.runtime.GetCanvasManager().ReleaseAdditionalRenderTarget(renderSurface)}ctx.rcTexDest.clampFlipped(0,1,1,0);ctx.fxIndex=1;ctx.otherFxIndex=0;if(isDebugFrame)DebugLogRenderTargetContents("Pre-draw",renderer,fxTarget)}function RenderFirstBounce(ctx,effectType){const renderer=ctx.renderer;const runtime=ctx.runtime;const fxTarget=ctx.GetEffectRenderTarget(ctx.fxIndex);renderer.SetRenderTarget(fxTarget);
const opts=ctx.opts;if(opts&&opts.preTransform)opts.preTransform();if(isDebug)renderer.ClearRgba(1,0,0,1);renderer.ClearRect2(ctx.clearRect);if(ctx.inst){const [sheetWidth,sheetHeight]=ctx.inst.GetCurrentSurfaceSize();const instTexRect=ctx.inst.GetCurrentTexRect();if(instTexRect)ctx.srcRect.copy(instTexRect);else ctx.srcRect.set(0,0,0,0);const paramArr=ctx.wi.GetInstanceEffectList().GetEffectParametersForIndex(effectType.GetIndex());renderer.SetProgramParameters(ctx.renderTarget,ctx.rcTexDest,ctx.srcRect,
ctx.srcRect,ctx.layoutRect,1/sheetWidth,1/sheetHeight,ctx.layerScale,ctx.layerAngle,runtime.GetGameTime(),paramArr);renderer.SetCurrentZ(ctx.wi.GetTotalZElevation());ctx.inst.Draw(renderer);renderer.SetCurrentZ(0);ctx.rcTexDest.clampFlipped(0,1,1,0);ctx.screenRect.shuntY(ctx.drawHeight);if(isDebugFrame)DebugLogRenderTargetContents("First bounce",renderer,fxTarget)}else{const paramArr=(ctx.layer||ctx.layout).GetEffectList().GetEffectParametersForIndex(effectType.GetIndex());renderer.SetProgramParameters(ctx.renderTarget,
ctx.rcTexDest,ctx.rcTexBounce,ctx.rcTexOrigin,ctx.layoutRect,1/ctx.drawWidth,1/ctx.drawHeight,ctx.layerScale,ctx.layerAngle,runtime.GetGameTime(),paramArr);const renderSurface=(ctx.layer||ctx.layout).GetRenderTarget();if(isDebugFrame)DebugLogRenderTargetContents("Layer target",renderer,renderSurface);renderer.DrawRenderTarget(renderSurface);renderer.InvalidateRenderTarget(renderSurface);runtime.GetCanvasManager().ReleaseAdditionalRenderTarget(renderSurface);if(isDebugFrame)DebugLogRenderTargetContents("First bounce",
renderer,fxTarget)}}function RenderBounce(ctx,effectType,isLast,i){const renderer=ctx.renderer;const runtime=ctx.runtime;let fxTarget;let paramArr;if(i===0&&ctx.preDraw&&ctx.inst)ctx.screenRect.shuntY(ctx.drawHeight);if(isLast){if(ctx.inst)renderer.SetBlendMode(ctx.wi.GetBlendMode());else if(ctx.layer)renderer.SetBlendMode(ctx.layer.GetBlendMode());fxTarget=ctx.renderTarget;renderer.SetRenderTarget(fxTarget)}else{fxTarget=ctx.GetEffectRenderTarget(ctx.fxIndex);renderer.SetRenderTarget(fxTarget);if(isDebug)renderer.ClearRgba(1,
0,0,1);renderer.ClearRect2(ctx.clearRect)}if(ctx.inst)paramArr=ctx.wi.GetInstanceEffectList().GetEffectParametersForIndex(effectType.GetIndex());else paramArr=(ctx.layer||ctx.layout).GetEffectList().GetEffectParametersForIndex(effectType.GetIndex());renderer.SetProgramParameters(ctx.renderTarget,ctx.rcTexDest,ctx.rcTexBounce,ctx.rcTexOrigin,ctx.layoutRect,1/ctx.surfaceWidth,1/ctx.surfaceHeight,ctx.layerScale,ctx.layerAngle,runtime.GetGameTime(),paramArr);const srcTarget=ctx.GetEffectRenderTarget(ctx.otherFxIndex);
renderer.SetTexture(srcTarget.GetTexture());runtime.GetCanvasManager().SetDeviceTransform(renderer);ctx.didChangeTransform=true;tempQuad.setFromRect(ctx.screenRect);renderer.Quad3(tempQuad,ctx.rcTexBounce);if(!ctx.inst)renderer.InvalidateRenderTarget(srcTarget);if(isDebugFrame)DebugLogRenderTargetContents("Bounce "+i,renderer,fxTarget)}function PostDraw(ctx,activeEffectTypes){const renderer=ctx.renderer;if(ctx.layout){renderer.SetTextureFillMode();renderer.SetRenderTarget(ctx.renderTarget);const srcTarget=
ctx.GetEffectRenderTarget(ctx.otherFxIndex);renderer.CopyRenderTarget(srcTarget);renderer.InvalidateRenderTarget(srcTarget);return}const canvasManager=ctx.runtime.GetCanvasManager();if(canvasManager.GetCurrentFullscreenScalingQuality()==="low"){renderer.SetTextureFillMode();canvasManager.SetDeviceTransform(renderer,canvasManager.GetDrawWidth(),canvasManager.GetDrawHeight());ctx.didChangeTransform=true}else renderer.SetDeviceTransformTextureFillMode();if(ctx.inst)renderer.SetBlendMode(ctx.wi.GetBlendMode());
else if(ctx.layer)renderer.SetBlendMode(ctx.layer.GetBlendMode());renderer.SetRenderTarget(ctx.renderTarget);const srcTarget=ctx.GetEffectRenderTarget(ctx.otherFxIndex);renderer.SetTexture(srcTarget.GetTexture());tempQuad.setFromRect(ctx.screenRect);renderer.Quad3(tempQuad,ctx.rcTexBounce);if(!ctx.inst)renderer.InvalidateRenderTarget(srcTarget);if(isDebugFrame)DebugLogRenderTargetContents("Post-draw",renderer,ctx.renderTarget)}};


// c3/timelines/timelineManager.js
'use strict';{const C3=self.C3;const NAMES_REGEXP=new RegExp("<(.+?)>","g");C3.TimelineManager=class TimelineManager extends C3.DefendedBase{constructor(runtime){super();this._runtime=runtime;this._timelineDataManager=C3.New(C3.TimelineDataManager);this._pluginInstance=null;this._timelines=[];this._timelinesByName=new Map;this._objectClassToTimelineMap=new Map;this._timelinesCreatedByTemplate=new Map;this._scheduledTimelines=[];this._playingTimelines=[];this._hasRuntimeListeners=false;this._changingLayout=
false;this._isTickingTimelines=false;this._tickFunc=()=>this._OnTick();this._tick2Func=()=>this._OnTick2();this._beforeLayoutChange=()=>this._OnBeforeChangeLayout();this._layoutChange=()=>this._OnAfterChangeLayout();this._instanceDestroy=e=>this._OnInstanceDestroy(e.instance);this._afterLoad=e=>this._OnAfterLoad();this._destroyedWhileLoadingState=[]}Release(){this.RemoveRuntimeListeners();this._tickFunc=null;this._tick2Func=null;this._beforeLayoutChange=null;this._layoutChange=null;this._instanceDestroy=
null;this._afterLoad=null;for(const timeline of this._timelines){timeline.Stop();timeline.Release()}C3.clearArray(this._timelines);this._timelines=null;this._timelineDataManager.Release();this._timelineDataManager=null;C3.clearArray(this._scheduledTimelines);this._scheduledTimelines=null;C3.clearArray(this._playingTimelines);this._playingTimelines=null;this._timelinesByName.clear();this._timelinesByName=null;this._objectClassToTimelineMap.clear();this._objectClassToTimelineMap=null;this._timelinesCreatedByTemplate.clear();
this._timelinesCreatedByTemplate=null;C3.clearArray(this._destroyedWhileLoadingState);this._destroyedWhileLoadingState=null;this._runtime=null}AddRuntimeListeners(){const dispatcher=this._runtime.Dispatcher();dispatcher.addEventListener("pretick",this._tickFunc);dispatcher.addEventListener("tick2",this._tick2Func);dispatcher.addEventListener("beforelayoutchange",this._beforeLayoutChange);dispatcher.addEventListener("layoutchange",this._layoutChange);dispatcher.addEventListener("instancedestroy",this._instanceDestroy);
dispatcher.addEventListener("afterload",this._afterLoad)}RemoveRuntimeListeners(){const dispatcher=this._runtime.Dispatcher();dispatcher.removeEventListener("pretick",this._tickFunc);dispatcher.removeEventListener("tick2",this._tick2Func);dispatcher.removeEventListener("beforelayoutchange",this._beforeLayoutChange);dispatcher.removeEventListener("layoutchange",this._layoutChange);dispatcher.removeEventListener("instancedestroy",this._instanceDestroy);dispatcher.removeEventListener("afterload",this._afterLoad)}Create(timelineData){this._timelineDataManager.Add(timelineData);
const timeline=C3.TimelineState.CreateInitial(timelineData,this);this.Add(timeline);this.SetTimelineObjectClassesToMap(timeline);this._timelinesCreatedByTemplate.set(timeline.GetName(),0)}CreateFromTemplate(template){const timelineDataManager=this.GetTimelineDataManager();const templateName=template.GetTemplateName();const timelineDataItem=timelineDataManager.Get(templateName);const timeline=C3.TimelineState.CreateFromTemplate(`${templateName}:${this._timelinesCreatedByTemplate.get(templateName)}`,
timelineDataItem,this);this._IncreaseTemplateTimelinesCount(templateName);this.Add(timeline);return timeline}_IncreaseTemplateTimelinesCount(templateName){this._timelinesCreatedByTemplate.set(templateName,this._timelinesCreatedByTemplate.get(templateName)+1)}_SetCreatedTemplateTimelinesCount(){for(const timeline of this._timelines){if(timeline.IsTemplate())continue;const templateName=timeline.GetTemplateName();this._IncreaseTemplateTimelinesCount(templateName)}}_ClearCreatedTemplateTimelinesCount(){for(const templateName of this._timelinesCreatedByTemplate.keys())this._timelinesCreatedByTemplate.set(templateName,
0)}Add(timeline){this._timelines.push(timeline);this._timelinesByName.set(timeline.GetName().toLowerCase(),timeline)}Remove(timeline){if(timeline.IsTemplate())return;C3.arrayFindRemove(this._timelines,timeline);C3.arrayFindRemove(this._scheduledTimelines,timeline);C3.arrayFindRemove(this._playingTimelines,timeline);this._timelinesByName.delete(timeline.GetName().toLowerCase());this.RemoveTimelineFromObjectClassMap(timeline);if(!timeline.IsReleased())timeline.Release()}Trigger(method){this._runtime.Trigger(method,
this._pluginInstance,null)}GetRuntime(){return this._runtime}GetTimelineDataManager(){return this._timelineDataManager}SetPluginInstance(inst){this._pluginInstance=inst}GetPluginInstance(){return this._pluginInstance}*GetTimelines(){for(const timeline of this._timelines)yield timeline}SetTimelineObjectClassToMap(objectClass,timeline){if(!this._objectClassToTimelineMap.has(objectClass))this._objectClassToTimelineMap.set(objectClass,new Set);this._objectClassToTimelineMap.get(objectClass).add(timeline)}SetTimelineObjectClassesToMap(timeline){for(const objectClass of timeline.GetObjectClasses())this.SetTimelineObjectClassToMap(objectClass,
timeline)}RemoveTimelineFromObjectClassMap(timeline){for(const [objectClass,timelines]of this._objectClassToTimelineMap.entries())if(timelines.has(timeline)){timelines.delete(timeline);if(timelines.size===0)this._objectClassToTimelineMap.delete(objectClass)}}GetTimelinesForObjectClass(objectClass){if(!this._objectClassToTimelineMap.has(objectClass))return;return this._objectClassToTimelineMap.get(objectClass)}GetTimelineOfTemplateForInstances(templateTimeline,instancesObject){if(!instancesObject)return;
for(const timeline of this._timelines){const found=instancesObject.every(io=>{return timeline.HasTrackInstance(io.instance,io.trackId)});if(found)if(timeline.GetName().includes(templateTimeline.GetName()))return timeline}}GetTimelineByName(name){return this._timelinesByName.get(name.toLowerCase())||null}GetScheduledOrPlayingTimelineByName(name){for(const timeline of this._scheduledTimelines)if(timeline.GetName()===name)return timeline;for(const timeline of this._playingTimelines)if(timeline.GetName()===
name)return timeline;return null}*GetTimelinesByName(name){if(NAMES_REGEXP.test(name)){NAMES_REGEXP.lastIndex=0;let match;const uniqueNames=new Set;do{match=NAMES_REGEXP.exec(name);if(match){const names=match[1].split(",");for(const name of names)uniqueNames.add(name)}}while(match);for(const name of uniqueNames.values()){const timeline=this.GetTimelineByName(name);if(timeline)yield timeline}uniqueNames.clear()}else{const timeline=this.GetTimelineByName(name);if(timeline)yield timeline}}*GetTimelinesByTags(tags){for(const timeline of this._timelines)if(timeline.HasTags(tags))yield timeline}AddScheduledTimeline(timeline){if(!this._scheduledTimelines.includes(timeline))this._scheduledTimelines.push(timeline);
this._MaybeEnableRuntimeListeners()}RemovePlayingTimeline(timeline){C3.arrayFindRemove(this._playingTimelines,timeline);this._MaybeDisableRuntimeListeners()}ScheduleTimeline(timeline){if(this._playingTimelines.includes(timeline)){timeline.SetPlaying(true);timeline.SetScheduled(false);timeline.SetMarkedForRemoval(false)}else{timeline.SetPlaying(false);timeline.SetScheduled(true);timeline.SetMarkedForRemoval(false);if(!this._scheduledTimelines.includes(timeline))this._scheduledTimelines.push(timeline)}this._MaybeEnableRuntimeListeners()}DeScheduleTimeline(timeline){timeline.SetPlaying(false);
timeline.SetScheduled(false);timeline.ResolvePlayPromise();C3.arrayFindRemove(this._scheduledTimelines,timeline);this._MaybeDisableRuntimeListeners()}CompleteTimeline(timeline){timeline.SetPlaying(false);timeline.SetScheduled(false);timeline.SetMarkedForRemoval(true)}CompleteTimelineAndResolve(timeline){this.CompleteTimeline(timeline);timeline.ResolvePlayPromise()}_OnTick(){if(this.GetRuntime().IsLoadingState())return;if(!this._hasRuntimeListeners)return;if(this._changingLayout)return;let renderChange=
false;this._isTickingTimelines=true;while(this._scheduledTimelines.length){const timeline=this._scheduledTimelines.pop();timeline.SetInitialState();this._playingTimelines.push(timeline)}const dt=this._runtime.GetDt();const ts=this._runtime.GetTimeScale();for(const t of this._playingTimelines){if(t.IsMarkedForRemoval())continue;const change=t.Tick(dt,ts);if(!renderChange&&change)renderChange=true}this._isTickingTimelines=false;if(renderChange)this.GetRuntime().UpdateRender()}_OnTick2(){if(this.GetRuntime().IsLoadingState())return;
if(!this._hasRuntimeListeners)return;if(this._changingLayout)return;let timelinesToRemove;for(const t of this._playingTimelines){if(!t.IsMarkedForRemoval())continue;if(!timelinesToRemove)timelinesToRemove=new Set;this._MaybeExecuteTimelineFinishTriggers(t);timelinesToRemove.add(t)}if(timelinesToRemove)C3.arrayRemoveAllInSet(this._playingTimelines,timelinesToRemove);this._MaybeDisableRuntimeListeners()}_MaybeExecuteTimelineFinishTriggers(timeline){if(timeline.IsReleased())return;if(!timeline.HasValidTracks())return;
if(timeline.IsComplete()&&timeline.InitialStateSet())timeline.FinishTriggers()}_MaybeEnableRuntimeListeners(){if(this._hasRuntimeListeners)return;this._hasRuntimeListeners=true}_MaybeDisableRuntimeListeners(){if(this._playingTimelines.length)return;if(this._scheduledTimelines.length)return;if(this._isTickingTimelines)return;this._hasRuntimeListeners=false}_OnBeforeChangeLayout(){this._changingLayout=true;while(this._scheduledTimelines.length)this.DeScheduleTimeline(this._scheduledTimelines.pop());
const timelinesToRemove=new Set;for(const t of this._playingTimelines){const remove=t._OnBeforeChangeLayout();if(remove)timelinesToRemove.add(t)}C3.arrayRemoveAllInSet(this._playingTimelines,timelinesToRemove);this._MaybeDisableRuntimeListeners();for(const timeline of this._timelines)timeline.CleanCaches()}_OnAfterChangeLayout(){this._changingLayout=false}_OnInstanceDestroy(instance){const objectClass=instance.GetObjectClass();const timelines=this.GetTimelinesForObjectClass(objectClass);if(!timelines)return;
if(this._runtime.IsLoadingState())this._destroyedWhileLoadingState.push(instance);else for(const timeline of timelines){if(timeline.IsTemplate())continue;if(timeline.IsReleased()){this.Remove(timeline);continue}if(!timeline.HasValidTracks()){this._MaybeExecuteTimelineFinishTriggers(timeline);this.Remove(timeline)}}}_OnAfterLoad(){for(const destroyedInstance of this._destroyedWhileLoadingState)this._OnInstanceDestroy(destroyedInstance);C3.clearArray(this._destroyedWhileLoadingState)}_SaveToJson(){return{"timelinesJson":this._SaveTimelinesToJson(),
"scheduledTimelinesJson":this._SaveScheduledTimelinesToJson(),"playingTimelinesJson":this._SavePlayingTimelinesToJson(),"hasRuntimeListeners":this._hasRuntimeListeners,"changingLayout":this._changingLayout,"isTickingTimelines":this._isTickingTimelines}}_LoadFromJson(o){if(!o)return;this._ClearCreatedTemplateTimelinesCount();this._LoadTimelinesFromJson(o["timelinesJson"]);this._LoadScheduledTimelinesFromJson(o["scheduledTimelinesJson"]);this._LoadPlayingTimelinesFromJson(o["playingTimelinesJson"]);
this._hasRuntimeListeners=!o["hasRuntimeListeners"];this._changingLayout=!!o["changingLayout"];this._isTickingTimelines=!!o["isTickingTimelines"];this._SetCreatedTemplateTimelinesCount();this._MaybeEnableRuntimeListeners();this._MaybeDisableRuntimeListeners()}_SaveTimelinesToJson(){return this._timelines.map(timelineState=>timelineState._SaveToJson())}_LoadTimelinesFromJson(timelinesJson){for(const timelineJson of timelinesJson){let timeline=this.GetTimelineByName(timelineJson["name"]);if(timeline)timeline._LoadFromJson(timelineJson);
else{const templateName=this._GetTemplateNameFromJson(timelineJson);if(!templateName)continue;const templateTimeline=this.GetTimelineByName(templateName);timeline=this.CreateFromTemplate(templateTimeline);timeline._LoadFromJson(timelineJson)}if(!timeline.HasTracks())this.Remove(timeline)}}_GetTemplateNameFromJson(timelineJson){const name=timelineJson["name"];const nameParts=name.split(":");if(!nameParts||nameParts.length!==2)return null;return nameParts[0]}_SaveScheduledTimelinesToJson(){return this._SaveTimelines(this._scheduledTimelines)}_LoadScheduledTimelinesFromJson(scheduledTimelinesJson){this._LoadTimelines(scheduledTimelinesJson,
this._scheduledTimelines)}_SavePlayingTimelinesToJson(){return this._SaveTimelines(this._playingTimelines)}_LoadPlayingTimelinesFromJson(playingTimelinesJson){this._LoadTimelines(playingTimelinesJson,this._playingTimelines)}_IsTimelineInJson(timeline,json){for(const name of json)if(name===timeline.GetName())return true;return false}_SaveTimelines(collection){return collection.map(t=>t.GetName())}_LoadTimelines(timelinesJson,collection){const timelinesToRemove=new Set;for(const timeline of collection)if(!this._IsTimelineInJson(timeline,
timelinesJson))timelinesToRemove.add(timeline);C3.arrayRemoveAllInSet(collection,timelinesToRemove);const ff=tn=>t=>t.GetName()===tn;for(const name of timelinesJson){const timeline=this.GetTimelineByName(name);if(timeline){const t=collection.find(ff(name));if(!t)collection.push(timeline)}}}}};


// c3/timelines/state/timelineState.js
'use strict';{const C3=self.C3;const PING_PONG_BEGIN=0;const PING_PONG_END=1;C3.TimelineState=class Timeline extends C3.DefendedBase{constructor(name,timelineDataItem,timelineManager){super();this._runtime=timelineManager.GetRuntime();this._timelineManager=timelineManager;this._timelineDataItem=timelineDataItem;this._name=name;this._tracks=[];for(const trackDataItem of this._timelineDataItem.GetTrackData().trackDataItems())this._tracks.push(C3.TrackState.Create(this,trackDataItem));this._playPromise=
null;this._playResolve=null;this._playheadTime=C3.New(C3.KahanSum);this._playheadTime.Set(0);this._playbackRate=1;this._pingPongState=PING_PONG_BEGIN;this._currentRepeatCount=1;this._isPlaying=false;this._isScheduled=false;this._initialStateSet=false;this._complete=true;this._released=false;this._markedForRemoval=false;this._completedTick=-1;this._implicitPause=false;this._isTemplate=false;this._finishedTriggers=false;this._firstTick=false;this._lastDelta=NaN;this._tags=[""];this._stringTags="";this._tagsChanged=
false}static CreateInitial(timelineDataJson,timelineManager){const timelineDataManager=timelineManager.GetTimelineDataManager();const nameId=timelineDataManager.GetNameId();const timelineDataItem=timelineDataManager.Get(timelineDataJson[nameId]);const timeline=C3.New(C3.TimelineState,timelineDataJson[nameId],timelineDataItem,timelineManager);timeline.SetIsTemplate(true);return timeline}static CreateFromTemplate(name,timelineDataItem,timelineManager){return C3.New(C3.TimelineState,name,timelineDataItem,
timelineManager)}static get WORLD_INSTANCE_BOX_CHANGE(){return 1}static get LAYOUT_RENDER_CHANGE(){return C3.nextHighestPowerOfTwo(1)}Release(){if(this.IsReleased())return;this._timelineManager.DeScheduleTimeline(this);this._timelineManager.CompleteTimelineAndResolve(this);for(const track of this._tracks)track.Release();C3.clearArray(this._tracks);this._tracks=null;this._playheadTime.Release();this._playheadTime=null;this._runtime=null;this._timelineManager=null;this._timelineDataItem=null;this._released=
true;this._playPromise=null;this._playResolve=null}GetTimelineManager(){return this._timelineManager}GetRuntime(){return this._runtime}GetTracks(){return this._tracks}GetSimilarPropertyTracks(instance,sourceAdapter,propertyName){const ret=[];for(const track of this._tracks){if(instance!==track.GetInstance())continue;const propertyTrack=track.GetPropertyTrack(propertyName);if(!propertyTrack)continue;if(sourceAdapter.constructor!==propertyTrack.GetSourceAdapter().constructor)continue;ret.push(propertyTrack)}return ret}HasTracks(){return!!this._tracks.length}GetTrackById(trackId){for(const track of this._tracks)if(C3.equalsNoCase(track.GetId(),
trackId))return track;return null}SetName(name){this._name=name}GetName(){return this._name}GetTimelineDataItem(){return this._timelineDataItem}GetTemplateName(){return this._timelineDataItem.GetName()}GetTotalTime(){return this._timelineDataItem.GetTotalTime()}SetTotalTime(tt){this._timelineDataItem.SetTotalTime(tt)}GetStep(){return this._timelineDataItem.GetStep()}SetStep(s){this._timelineDataItem.SetStep(s)}GetInterpolationMode(){return this._timelineDataItem.GetInterpolationMode()}SetInterpolationMode(im){this._timelineDataItem.SetInterpolationMode(im)}GetResultMode(){return this._timelineDataItem.GetResultMode()}SetResultMode(rm){this._timelineDataItem.GetResultMode(rm)}SetEase(e){for(const track of this.GetTracks())track.SetEase(e)}GetLoop(){return this._timelineDataItem.GetLoop()}SetLoop(l){return this._timelineDataItem.SetLoop(l)}GetPingPong(){return this._timelineDataItem.GetPingPong()}SetPingPong(p){return this._timelineDataItem.SetPingPong(p)}GetRepeatCount(){return this._timelineDataItem.GetRepeatCount()}SetPlaybackRate(r){return this._playbackRate=
r}GetPlaybackRate(){return this._playbackRate}IsForwardPlayBack(){if(!this.IsPlaying())return true;return this._playbackRate>0}GetPlayPromise(){if(this._playPromise)return this._playPromise;this._playPromise=new Promise(resolve=>{this._playResolve=resolve});return this._playPromise}ResolvePlayPromise(){if(!this._playPromise)return;this._playResolve();this._playPromise=null;this._playResolve=null}SetTags(tags){this._tags=C3.TimelineState._GetTagArray(tags);this._tagsChanged=true}GetTags(){return this._tags}GetStringTags(){if(this._tagsChanged)this._stringTags=
this._tags.join(" ");this._tagsChanged=false;return this._stringTags}HasTags(tags){if(!this._tags)return false;if(!this._tags.length)return false;const t=C3.TimelineState._GetTagArray(tags);if(!t)return false;if(!t.length)return false;return t.every(C3.TimelineState._HasTag,this)}OnStarted(){C3.Plugins.Timeline.Cnds.SetTriggerTimeline(this);this._timelineManager.Trigger(C3.Plugins.Timeline.Cnds.OnTimelineStarted);this._timelineManager.Trigger(C3.Plugins.Timeline.Cnds.OnTimelineStartedByName);this._timelineManager.Trigger(C3.Plugins.Timeline.Cnds.OnTimelineStartedByTags);
this._timelineManager.Trigger(C3.Plugins.Timeline.Cnds.OnAnyTimelineStarted);C3.Plugins.Timeline.Cnds.SetTriggerTimeline(null)}OnCompleted(){this._completedTick=this._runtime.GetTickCount()}FinishTriggers(){if(this._finishedTriggers)return;this._finishedTriggers=true;C3.Plugins.Timeline.Cnds.SetTriggerTimeline(this);this._timelineManager.Trigger(C3.Plugins.Timeline.Cnds.OnTimelineFinished);this._timelineManager.Trigger(C3.Plugins.Timeline.Cnds.OnTimelineFinishedByName);this._timelineManager.Trigger(C3.Plugins.Timeline.Cnds.OnTimelineFinishedByTags);
this._timelineManager.Trigger(C3.Plugins.Timeline.Cnds.OnAnyTimelineFinished);C3.Plugins.Timeline.Cnds.SetTriggerTimeline(null)}SetPlaying(p){this._isPlaying=p}IsCompletedTick(){return this._completedTick===this._runtime.GetTickCount()}IsPlaying(playingOnly=false){if(this.IsCompletedTick())return true;if(this.IsScheduled()&&!playingOnly)return true;return this._isPlaying}_IsPlaying(){return this.IsPlaying(true)}IsPaused(){return this._IsPaused()}_IsPaused(){if(this.IsReleased())return false;if(this.IsScheduled())return false;
if(this._IsPlaying())return false;if(this.IsComplete())return false;return true}SetScheduled(s){this._isScheduled=s}IsScheduled(){return this._isScheduled}SetComplete(c){this._complete=c;const t=this.GetTime();if(t<=0||t>=this.GetTotalTime())this._complete=true}IsComplete(){return this._complete}IsReleased(){return this._released}SetMarkedForRemoval(mfr){this._markedForRemoval=mfr}IsMarkedForRemoval(){return this._markedForRemoval}SetImplicitPause(ip){this._implicitPause=ip}IsImplicitPause(){return this._implicitPause}SetIsTemplate(it){this._isTemplate=
!!it}IsTemplate(){return this._isTemplate}InitialStateSet(){return this._initialStateSet}GetTime(){return this._playheadTime.Get()}SetTime(time){const lastGlobalTime=this.GetTime();this._SetTime(time);this.SetComplete(false);if(!this.IsComplete())this.SetImplicitPause(true);if(!this._IsPlaying()&&!this.IsScheduled()&&this._initialStateSet);else if(!this._IsPlaying()&&!this.IsScheduled()&&!this._initialStateSet)this.SetInitialStateFromSetTime();else if(this._IsPlaying())this.Stop();else if(this.IsScheduled()){this._timelineManager.DeScheduleTimeline(this);
this.SetInitialStateFromSetTime()}const renderChange=this._Interpolate(time,false,true,true,lastGlobalTime);if(renderChange)this.GetRuntime().UpdateRender();this._OnSetTime()}_SetTime(time){if(time<0)this._playheadTime.Set(0);else if(time>=this.GetTotalTime())this._playheadTime.Set(this.GetTotalTime());else this._playheadTime.Set(time)}_OnSetTime(){if(!C3.Plugins.Timeline||this.constructor!==C3.TimelineState)return;C3.Plugins.Timeline.Cnds.SetTriggerTimeline(this);this._timelineManager.Trigger(C3.Plugins.Timeline.Cnds.OnTimeSet);
this._timelineManager.Trigger(C3.Plugins.Timeline.Cnds.OnTimeSetByName);this._timelineManager.Trigger(C3.Plugins.Timeline.Cnds.OnTimeSetByTags);C3.Plugins.Timeline.Cnds.SetTriggerTimeline(null)}_CanResume(){if(this.GetLoop())return true;else if(this.GetPingPong()&&this._pingPongState===PING_PONG_END)if(this.IsForwardPlayBack()){if(this.GetTime()>=this.GetTotalTime())return false}else{if(this.GetTime()<=0)return false}else if(!this.GetLoop()&&!this.GetPingPong())if(this.IsForwardPlayBack()){if(this.GetTime()>=
this.GetTotalTime())return false}else if(this.GetTime()<=0)return false;return true}Resume(){if(this.IsReleased())return;if(this._CanResume())this.Play(true)}Play(resume=false){if(this.IsReleased())return false;if(this.IsScheduled())return false;if(this._IsPlaying()&&this.IsCompletedTick())return this._SchedulePlayingTimeline();if(this._IsPlaying())return false;if(!this.IsComplete()&&!resume&&!this.IsImplicitPause())return false;return this._ScheduleStoppedTimeline()}_SchedulePlayingTimeline(){this.SetImplicitPause(false);
this._timelineManager.RemovePlayingTimeline(this);this._timelineManager.ScheduleTimeline(this);this.GetPlayPromise();return true}_ScheduleStoppedTimeline(){this.SetImplicitPause(false);this._timelineManager.ScheduleTimeline(this);this.GetPlayPromise();return true}Stop(completed=false){if(this.IsReleased())return;this.SetComplete(completed);this._timelineManager.CompleteTimeline(this);if(this.IsComplete())this.ResolvePlayPromise()}Reset(render=true,beforeChangeLayout=false){if(this.IsReleased())return;
if(!this._IsPlaying()&&this.IsScheduled())return this._timelineManager.DeScheduleTimeline(this);if(this.IsComplete())return;this.Stop(true);if(this.IsForwardPlayBack())this._SetTime(0);else this._SetTime(this.GetTotalTime());let renderChange;const time=this.GetTime();if(beforeChangeLayout)renderChange=this._InterpolateBeforeChangeLayout(time);else renderChange=this._Interpolate(time,false,false,true);if(render)this._OnSetTime();if(renderChange&&render)this.GetRuntime().UpdateRender()}ResetBeforeChangeLayout(){this.Reset(false,
true)}_InterpolateBeforeChangeLayout(time){this._Interpolate(time,false,false,true,NaN,false,true)}_OnBeforeChangeLayout(){if(this.IsReleased())return true;if(this.HasValidGlobalTracks())return false;this._timelineManager.CompleteTimeline(this);this.ResetBeforeChangeLayout();return true}SetInitialStateFromSetTime(){this.SetInitialState(true)}SetInitialState(fromSetTime){if(this.IsMarkedForRemoval())return;if(fromSetTime){this._initialStateSet=true;this._firstTick=true;for(const track of this._tracks)track.SetInitialState()}else{this.SetPlaying(true);
this.SetScheduled(false);this.OnStarted();if(this.IsComplete()){this._completedTick=-1;this._pingPongState=PING_PONG_BEGIN;this._currentRepeatCount=1;this._complete=false;this._finishedTriggers=false;this._initialStateSet=true;this._firstTick=true;if(this.IsForwardPlayBack())this._SetTime(0);else this._SetTime(this.GetTotalTime());for(const track of this._tracks)track.SetInitialState()}else{this._firstTick=true;for(const track of this._tracks)track.SetResumeState()}}}Tick(deltaTime,timeScale){if(deltaTime===
0&&this._lastDelta===0)return;this._lastDelta=deltaTime;const lastTime=this.GetTime();const newDeltaTime=deltaTime*timeScale*this._playbackRate;this._SetTime(lastTime+newDeltaTime);let complete;if(!this.GetLoop()&&!this.GetPingPong())complete=this._SimpleCompleteCheck();else if(this.GetLoop()&&!this.GetPingPong())complete=this._LoopCompleteCheck();else if(!this.GetLoop()&&this.GetPingPong())complete=this._PingPongCompleteCheck();else if(this.GetLoop()&&this.GetPingPong())complete=this._LoopPingPongCompleteCheck();
if(complete){for(const track of this._tracks)track.SetEndState();this.Stop(true);this.OnCompleted();return true}else return this._Interpolate(this.GetTime(),true,false,false,lastTime,true)}_Interpolate(time,isTicking=false,setTime=false,ensureValue=false,lastTime=NaN,onTickCall=false,ignoreGlobals=false){let renderChange=false;for(const track of this._tracks)track.BeforeInterpolate();for(const track of this._tracks){let t=time;if(typeof lastTime==="number"){const globalTime=this.GetTime();const localTime=
globalTime-track.GetStartOffset();const lastLocalTime=lastTime-track.GetStartOffset();if(localTime<0&&lastLocalTime>0){t=track.GetStartOffset();this._SetTime(t)}}const change=track.Interpolate(t,isTicking,setTime,ensureValue,this._firstTick,ignoreGlobals);if(!renderChange&&change)renderChange=true}for(const track of this._tracks)track.AfterInterpolate();if(this._firstTick&&onTickCall)this._firstTick=false;return renderChange}_SimpleCompleteCheck(){if(this.IsForwardPlayBack()){if(this.GetTime()>=this.GetTotalTime())if(this._currentRepeatCount<
this.GetRepeatCount()){this._currentRepeatCount++;this._SetTime(0)}else{this._SetTime(this.GetTotalTime());return true}}else if(this.GetTime()<=0)if(this._currentRepeatCount<this.GetRepeatCount()){this._currentRepeatCount++;this._SetTime(this.GetTotalTime())}else{this._SetTime(0);return true}return false}_LoopCompleteCheck(){if(this.IsForwardPlayBack()){if(this.GetTime()>=this.GetTotalTime())this._SetTime(0)}else if(this.GetTime()<=0)this._SetTime(this.GetTotalTime());return false}_PingPongCompleteCheck(){if(this.IsForwardPlayBack()){if(this.GetTime()>=
this.GetTotalTime()){this._SetTime(this.GetTotalTime());this.SetPlaybackRate(this.GetPlaybackRate()*-1);if(this._pingPongState===PING_PONG_END)if(this._currentRepeatCount<this.GetRepeatCount()){this._currentRepeatCount++;this._pingPongState=PING_PONG_BEGIN}else return true;else if(this._pingPongState===PING_PONG_BEGIN)this._pingPongState=PING_PONG_END}}else if(this.GetTime()<=0){this._SetTime(0);this.SetPlaybackRate(this.GetPlaybackRate()*-1);if(this._pingPongState===PING_PONG_END)if(this._currentRepeatCount<
this.GetRepeatCount()){this._currentRepeatCount++;this._pingPongState=PING_PONG_BEGIN}else return true;else if(this._pingPongState===PING_PONG_BEGIN)this._pingPongState=PING_PONG_END}return false}_LoopPingPongCompleteCheck(){if(this.IsForwardPlayBack()){if(this.GetTime()>=this.GetTotalTime()){this._SetTime(this.GetTotalTime());this.SetPlaybackRate(this.GetPlaybackRate()*-1)}}else if(this.GetTime()<=0){this._SetTime(0);this.SetPlaybackRate(this.GetPlaybackRate()*-1)}return false}AddTrack(){const trackDataItem=
this._timelineDataItem.GetTrackData().AddEmptyTrackDataItem();const track=C3.TrackState.Create(this,trackDataItem);this._tracks.push(track);return track}CleanCaches(){for(const track of this._tracks)track.CleanCaches()}ClearTrackInstances(){for(const track of this._tracks)track.ClearInstance()}SetTrackInstance(trackId,instance){if(!instance)return;for(const track of this._tracks)if(trackId){if(track.GetId()!==trackId)continue;track.SetInstance(instance);this._timelineManager.SetTimelineObjectClassToMap(instance.GetObjectClass(),
this);break}else{if(track.HasInstance())continue;track.SetInstance(instance);this._timelineManager.SetTimelineObjectClassToMap(instance.GetObjectClass(),this);break}}HasTrackInstance(instance,trackId){for(const track of this._tracks)if(trackId){if(trackId===track.GetId()&&instance===track.GetInstance())return true}else if(instance===track.GetInstance())return true;return false}GetTrackInstance(instance){for(const track of this._tracks)if(instance===track.GetInstance())return track;return null}HasValidTracks(){return this._tracks.some(t=>
t.CanInstanceBeValid())}HasValidGlobalTracks(){return this._tracks.some(t=>{if(!t.CanInstanceBeValid())return false;const objectClass=t.GetObjectClass();if(!objectClass)return false;return objectClass.IsGlobal()})}GetPropertyTrack(propertyName){for(const track of this.GetTracks())for(const propertyTrack of track.GetPropertyTracks())if(propertyTrack.GetPropertyName()===propertyName)return propertyTrack}GetKeyframeWithTags(tags){let tagsArray=tags?tags.split(" "):[];const tagsSet=new Set(tagsArray.map(t=>
t.toLowerCase().trim()));tagsArray=[...tagsSet.values()];for(const track of this.GetTracks())for(const keyframeDataItem of track.GetKeyframeDataItems()){const hasAllTags=tagsArray.every(t=>keyframeDataItem.HasTag(t));if(hasAllTags)return keyframeDataItem}}GetObjectClasses(){const ret=[];for(const track of this.GetTracks())ret.push(track.GetObjectClass());return ret.filter(oc=>oc)}_SaveToJson(){return{"tracksJson":this._SaveTracksToJson(),"name":this._name,"playheadTime":this.GetTime(),"playbackRate":this._playbackRate,
"pingPongState":this._pingPongState,"currentRepeatCount":this._currentRepeatCount,"isPlaying":this._isPlaying,"isScheduled":this._isScheduled,"initialStateSet":this._initialStateSet,"finishedTriggers":this._finishedTriggers,"complete":this._complete,"released":this._released,"markedForRemoval":this._markedForRemoval,"completedTick":this._completedTick,"implicitPause":this._implicitPause,"isTemplate":this._isTemplate,"tags":this._tags.join(" "),"stringTags":this._stringTags,"tagsChanged":this._tagsChanged,
"firstTick":this._firstTick}}_LoadFromJson(o){if(!o)return;this._LoadTracksFromJson(o["tracksJson"]);this._name=o["name"];this._playheadTime.Set(o["playheadTime"]);this._playbackRate=o["playbackRate"];this._pingPongState=o["pingPongState"];this._currentRepeatCount=o["currentRepeatCount"];this._isPlaying=!!o["isPlaying"];this._isScheduled=!!o["isScheduled"];this._initialStateSet=!!o["initialStateSet"];this._finishedTriggers=o.hasOwnProperty("finishedTriggers")?!!o["finishedTriggers"]:false;this._complete=
!!o["complete"];this._released=!!o["released"];this._markedForRemoval=!!o["markedForRemoval"];this._completedTick=o["completedTick"];this._implicitPause=!!o["implicitPause"];this._isTemplate=!!o["isTemplate"];this._tags=o["tags"].split(" ");this._stringTags=o["stringTags"];this._tagsChanged=!!o["tagsChanged"];this._firstTick=!!o["firstTick"]}_SaveTracksToJson(){return this._tracks.map(trackState=>trackState._SaveToJson())}_LoadTracksFromJson(tracksJson){tracksJson.forEach((trackJson,i)=>{const track=
this._tracks[i];track._LoadFromJson(trackJson)});this._tracks.filter(track=>track.CanInstanceBeValid())}static _HasTag(tag){const tags=this.GetTags();if(tag==="")return tags.length===1&&tags[0]==="";return tags.includes(tag)}static _GetTagArray(tags){if(C3.IsArray(tags))return tags.slice(0);if(C3.IsString(tags))return tags.split(" ")}}};


// c3/timelines/state/trackState.js
'use strict';{const C3=self.C3;C3.TrackState=class Track extends C3.DefendedBase{constructor(timeline,trackDataItem){super();this._timeline=timeline;this._trackDataItem=trackDataItem;this._trackData=trackDataItem.GetTrackData();this._instanceUid=NaN;this._objectClassIndex=NaN;this._instance=null;this._worldInfo=null;this._isNested=trackDataItem.GetStartOffset()>0;this._initialStateOfNestedSet=false;this._endStateOfNestedSet=false;this._lastKeyframeDataItem=null;this._keyframeDataItems=this._trackDataItem.GetKeyframeData().GetKeyframeDataItemArray();
this._propertyTracks=[];for(const propertyTrackDataItem of this._trackDataItem.GetPropertyTrackData().propertyTrackDataItems())this._propertyTracks.push(C3.PropertyTrackState.Create(this,propertyTrackDataItem))}static Create(timeline,trackDataItem){return C3.New(C3.TrackState,timeline,trackDataItem)}Release(){this._keyframeDataItems=null;for(const propertyTrack of this._propertyTracks)propertyTrack.Release();C3.clearArray(this._propertyTracks);this._propertyTracks=null;this._timeline=null;this._instance=
null;this._worldInfo=null;this._trackDataItem=null;this._lastKeyframeDataItem=null}CleanCaches(){for(const propertyTrack of this._propertyTracks)propertyTrack.CleanCaches();this._instance=null;this._worldInfo=null}GetTimeline(){return this._timeline}GetRuntime(){return this._timeline.GetRuntime()}GetKeyframeDataItems(){if(this._keyframeDataItems)return this._keyframeDataItems;this._keyframeDataItems=this._trackDataItem.GetKeyframeData().GetKeyframeDataItemArray();return this._keyframeDataItems}GetPropertyTracks(){return this._propertyTracks}GetPropertyTrack(propertyName){for(const propertyTrack of this._propertyTracks)if(propertyTrack.GetPropertyName()===
propertyName)return propertyTrack}MaybeGetInstance(){if(!this._instance)this.GetInstance()}IsInstanceValid(){if(!this._instance)return false;return!this._instance.IsDestroyed()}CanInstanceBeValid(){const uid=this.GetInstanceUID();const instance=this.GetRuntime().GetInstanceByUID(uid);if(!instance)return false;return!instance.IsDestroyed()}GetObjectClass(){const index=this.GetObjectClassIndex();if(index===-1)return;return this.GetRuntime().GetObjectClassByIndex(index)}ClearInstance(){this._instance=
null;this._instanceUid=-1;this._worldInfo=null;this._objectClassIndex=-1}HasInstance(){return!!this._instance}GetInstance(){if(this._instance&&this.IsInstanceValid())return this._instance;const uid=this.GetInstanceUID();this._instance=this.GetRuntime().GetInstanceByUID(uid);return this._instance}SetInstance(instance){if(this._instance===instance)return;this.CleanCaches();this._instance=instance;this._objectClassIndex=instance.GetObjectClass().GetIndex();this._instanceUid=instance.GetUID();this._worldInfo=
instance.GetWorldInfo();for(const item of this.propertyTrackItems()){const propertyTrack=item.propertyTrack;const sourceAdapter=item.sourceAdapter;const id=propertyTrack.GetSourceAdapterId();switch(id){case "instance-variable":{const index=sourceAdapter.GetEditorIndex();const objectClass=instance.GetObjectClass();const i=objectClass.GetInstanceVariableIndexByName(item.name);const name=objectClass.GetInstanceVariableName(i);const type=objectClass.GetInstanceVariableType(i);if(name===item.name&&type===
item.type)sourceAdapter.UpdateInstanceVariableIndex(i);break}case "behavior":{const timelineBehaviorType=item.behaviorType;const trackObjectClass=this.GetObjectClass();const objectClass=instance.GetObjectClass();const instanceBehaviorType=sourceAdapter.GetBehaviorType(objectClass);if(timelineBehaviorType&&instanceBehaviorType){const name=timelineBehaviorType.GetName();const templateBehaviorIndex=trackObjectClass.GetBehaviorIndexByName(name);const instanceBehaviorIndex=objectClass.GetBehaviorIndexByName(name);
const propertyIndex=sourceAdapter.GetEditorIndex();sourceAdapter.UpdateBehaviorTypeSid(instanceBehaviorType.GetSID())}break}}}}*propertyTrackItems(){for(const propertyTrack of this._propertyTracks){const sourceAdapter=propertyTrack.GetSourceAdapter();const objectClass=this.GetObjectClass();const ret={propertyTrack:propertyTrack,sourceAdapter:sourceAdapter};switch(propertyTrack.GetSourceAdapterId()){case "world-instance":{ret.property=propertyTrack.GetPropertyName();break}case "instance-variable":{const index=
sourceAdapter.GetEditorIndex();ret.name=objectClass.GetInstanceVariableName(index);ret.type=objectClass.GetInstanceVariableType(index);break}case "effect":{const effectList=objectClass.GetEffectList();const effectType=sourceAdapter.GetEffectType(effectList);ret.effectType=effectType;break}case "behavior":{const behaviorType=sourceAdapter.GetBehaviorType(objectClass);ret.behaviorType=behaviorType;break}case "plugin":{ret.plugin=objectClass.GetPlugin();break}}yield ret}}GetWorldInfo(){if(this._worldInfo&&
this.IsInstanceValid())return this._worldInfo;const instance=this.GetInstance();if(instance)this._worldInfo=instance.GetWorldInfo();return this._worldInfo}GetTrackDataItem(){return this._trackDataItem}GetInstanceUID(){if(this._instanceUid)return this._instanceUid;return this._trackDataItem.GetInstanceUID()}SetInstanceUID(uid){this._trackDataItem.SetInstanceUID(uid)}GetInterpolationMode(){return this._trackDataItem.GetInterpolationMode()}SetInterpolationMode(im){this._trackDataItem.SetInterpolationMode(im)}GetResultMode(){return this._trackDataItem.GetResultMode()}GetId(){return this._trackDataItem.GetId()}GetStartOffset(){return this._trackDataItem.GetStartOffset()}GetLocalTotalTime(){return this._trackDataItem.GetLocalTotalTime()}SetLocalTotalTime(t){this._trackDataItem.SetLocalTotalTime(t)}SetResultMode(rm){this._trackDataItem.SetResultMode(rm)}SetEase(e){for(const keyframeDataItem of this.GetKeyframeDataItems())keyframeDataItem.SetEase(e);
for(const propertyTrack of this.GetPropertyTracks())propertyTrack.SetEase(e)}GetEnable(){return this._trackDataItem.GetEnable()}SetEnable(e){this._trackDataItem.SetEnable(e)}GetObjectClassIndex(){if(!isNaN(this._objectClassIndex))return this._objectClassIndex;return this._trackDataItem.GetObjectClassIndex()}SetObjectClassIndex(objectClassIndex){this._trackDataItem.SetObjectClassIndex(objectClassIndex)}SetOriginalWidth(w){this._trackDataItem.SetOriginalWidth(w)}GetOriginalWidth(){const instance=this.GetInstance();
if(instance){const sdkIntance=instance.GetSdkInstance();if(sdkIntance.IsOriginalSizeKnown())return instance.GetSdkInstance().GetOriginalWidth()}return this._trackDataItem.GetOriginalWidth()}SetOriginalHeight(h){this._trackDataItem.SetOriginalHeight(h)}GetOriginalHeight(){const instance=this.GetInstance();if(instance){const sdkIntance=instance.GetSdkInstance();if(sdkIntance.IsOriginalSizeKnown())return instance.GetSdkInstance().GetOriginalHeight()}return this._trackDataItem.GetOriginalHeight()}SetInitialState(){this.MaybeGetInstance();
if(!this.IsInstanceValid())return;for(const propertyTrack of this._propertyTracks)propertyTrack.SetInitialState();const timeline=this.GetTimeline();const isForwardPlayBack=timeline.IsForwardPlayBack();const time=isForwardPlayBack?0:this.GetLocalTotalTime();this._lastKeyframeDataItem=this.GetLastKeyFrameBeforeTime(time);this._initialStateOfNestedSet=false;this._endStateOfNestedSet=false;this.Interpolate(time)}SetResumeState(){this.MaybeGetInstance();if(!this.IsInstanceValid())return;const playbackDirection=
this._timeline.IsForwardPlayBack();const time=this._timeline.GetTime()-this.GetStartOffset();this._lastKeyframeDataItem=this.GetLastKeyFrameBeforeTime(time);for(const propertyTrack of this._propertyTracks)propertyTrack.SetResumeState()}SetEndState(){if(this.GetTimeline().IsComplete())return;this.MaybeGetInstance();if(!this.IsInstanceValid())return;if(!this._isNested){const time=this._timeline.GetTime();const totalTime=this.GetStartOffset()+this.GetLocalTotalTime();if(time>=totalTime)this.Interpolate(this.GetLocalTotalTime(),
true,false,true);else if(time<=0)this.Interpolate(0,true,false,true)}}BeforeInterpolate(){for(const propertyTrack of this._propertyTracks)propertyTrack.BeforeInterpolate()}Interpolate(time,isTicking=false,setTime=false,ensureValue=false,firstTick=false,ignoreGlobals=false){this.MaybeGetInstance();if(!this.IsInstanceValid())return false;if(ignoreGlobals&&this.GetObjectClass().IsGlobal())return false;time=time-this.GetStartOffset();if(time<0)return false;this.MaybeSetInitialStateOfNestedTrack(time,
isTicking);this.MaybeTriggerKeyframeReachedConditions(time,isTicking,firstTick);let boxChange=false;let renderChange=false;for(const propertyTrack of this._propertyTracks){const change=propertyTrack.Interpolate(time,setTime,false,ensureValue);if(!boxChange&&(change&C3.TimelineState.WORLD_INSTANCE_BOX_CHANGE)!==0)boxChange=true;if(!renderChange&&(change&C3.TimelineState.LAYOUT_RENDER_CHANGE)!==0)renderChange=true}this.MaybeSetEndStateOfNestedTrack(time,isTicking);if(boxChange){const worldInfo=this.GetWorldInfo();
if(worldInfo)worldInfo.SetBboxChanged()}return renderChange}AfterInterpolate(){for(const propertyTrack of this._propertyTracks)propertyTrack.AfterInterpolate()}MaybeSetInitialStateOfNestedTrack(time,isTicking){if(!isTicking)return;if(!this._isNested)return;if(this._initialStateOfNestedSet)return;const timeline=this.GetTimeline();if(timeline.IsForwardPlayBack()){if(time<0)return;for(const propertyTrack of this._propertyTracks)propertyTrack.Interpolate(0,false,false,true)}else{if(time>this.GetLocalTotalTime())return;
for(const propertyTrack of this._propertyTracks)propertyTrack.Interpolate(this.GetLocalTotalTime(),false,false,true)}for(const propertyTrack of this._propertyTracks)propertyTrack.SetInitialState();this._initialStateOfNestedSet=true}MaybeSetEndStateOfNestedTrack(time,isTicking){if(!isTicking)return;if(!this._isNested)return;if(this._endStateOfNestedSet)return;const timeline=this.GetTimeline();if(timeline.IsForwardPlayBack()){if(time>=this.GetLocalTotalTime()){for(const propertyTrack of this._propertyTracks)propertyTrack.Interpolate(this.GetLocalTotalTime(),
false,false,true);this._endStateOfNestedSet=true}}else if(time<=0){for(const propertyTrack of this._propertyTracks)propertyTrack.Interpolate(0,false,false,true);this._endStateOfNestedSet=true}}MaybeTriggerKeyframeReachedConditions(time,isTicking,firstTick){if(firstTick)return;if(!isTicking)return;let keyframeDataItem=this.GetLastKeyFrameBeforeTime(time);if(keyframeDataItem!==this._lastKeyframeDataItem)this.OnKeyframeReached(keyframeDataItem);this._lastKeyframeDataItem=keyframeDataItem;return keyframeDataItem}GetLastKeyFrameBeforeTime(time){const timeline=
this.GetTimeline();let keyframeDataItem=this._trackData.GetKeyFrameDataItemAtTime(time,this._trackDataItem);if(keyframeDataItem)return keyframeDataItem;else if(timeline.IsForwardPlayBack())return this._trackData.GetFirstKeyFrameDataItemLowerOrEqualThan(time,this._trackDataItem);else return this._trackData.GetFirstKeyFrameDataItemHigherOrEqualThan(time,this._trackDataItem)}OnKeyframeReached(keyframeDataItem){if(!C3.Plugins.Timeline||this.GetTimeline().constructor!==C3.TimelineState)return;const timeline=
this.GetTimeline();C3.Plugins.Timeline.Cnds.SetTriggerTimeline(timeline);C3.Plugins.Timeline.Cnds.SetTriggerKeyframe(keyframeDataItem);const timelineManager=timeline.GetTimelineManager();timelineManager.Trigger(C3.Plugins.Timeline.Cnds.OnAnyKeyframeReached);timelineManager.Trigger(C3.Plugins.Timeline.Cnds.OnKeyframeReached);C3.Plugins.Timeline.Cnds.SetTriggerTimeline(null);C3.Plugins.Timeline.Cnds.SetTriggerKeyframe(null)}AddKeyframe(){const keyframeData=this._trackDataItem.GetKeyframeData();const keyframeDataItem=
keyframeData.AddEmptyKeyframeDataItem();return keyframeDataItem}AddPropertyTrack(){const propertyTrackData=this._trackDataItem.GetPropertyTrackData();const propertyTrackDataItem=propertyTrackData.AddEmptyPropertyTrackDataItem();const propertyTrack=C3.PropertyTrackState.Create(this,propertyTrackDataItem);this._propertyTracks.push(propertyTrack);return propertyTrack}DeleteKeyframes(match){const keyframeData=this._trackDataItem.GetKeyframeData();keyframeData.DeleteKeyframeDataItems(match)}DeletePropertyKeyframes(match){for(const propertyTrack of this._propertyTracks)propertyTrack.DeletePropertyKeyframes(match)}SaveState(){for(const propertyTrack of this._propertyTracks)propertyTrack.SaveState()}CompareInitialStateWithCurrent(){this.MaybeGetInstance();
if(!this.IsInstanceValid())return;for(const propertyTrack of this._propertyTracks)propertyTrack.CompareInitialStateWithCurrent()}CompareSaveStateWithCurrent(){this.MaybeGetInstance();if(!this.IsInstanceValid())return;let difference=false;for(const propertyTrack of this._propertyTracks){const diff=propertyTrack.CompareSaveStateWithCurrent();if(!difference&&diff)difference=true}if(difference){const keyframeDataItem=this.AddKeyframe();keyframeDataItem.SetTime(this.GetTimeline().GetTime());keyframeDataItem.SetEase("noease");
keyframeDataItem.SetEnable(true);keyframeDataItem.SetTags("")}}_SaveToJson(){const instance=this.GetInstance();const uid=instance?instance.GetUID():this.GetInstanceUID();return{"propertyTracksJson":this._SavePropertyTracksToJson(),"lastKeyframeDataItemJson":this._SaveLastKeyframeDataItemToJson(),"initialStateOfNestedSet":this._initialStateOfNestedSet,"endStateOfNestedSet":this._endStateOfNestedSet,"instanceUid":uid}}_LoadFromJson(o){if(!o)return;this._LoadPropertyTracksFromJson(o["propertyTracksJson"]);
this._LoadLastKeyframeDataItemFromJson(o["lastKeyframeDataItemJson"]);this._LoadInstanceFromJson(o["instanceUid"]);this._initialStateOfNestedSet=false;if(o.hasOwnProperty["initialStateOfNestedSet"])this._initialStateOfNestedSet=o["initialStateOfNestedSet"];this._endStateOfNestedSet=false;if(o.hasOwnProperty["endStateOfNestedSet"])this._endStateOfNestedSet=o["endStateOfNestedSet"]}_SaveLastKeyframeDataItemToJson(){const keyframeData=this._trackDataItem.GetKeyframeData();return keyframeData.GetKeyframeDataItemIndex(this._lastKeyframeDataItem)}_SavePropertyTracksToJson(){return this._propertyTracks.map(propertyTrackState=>
propertyTrackState._SaveToJson())}_LoadPropertyTracksFromJson(propertyTracksJson){propertyTracksJson.forEach((propertyTrackJson,i)=>{const propertyTrack=this._propertyTracks[i];propertyTrack._LoadFromJson(propertyTrackJson)})}_LoadInstanceFromJson(uid){if(!C3.IsFiniteNumber(uid))return;const instance=this.GetRuntime().GetInstanceByUID(uid);if(!instance)return;const timeline=this.GetTimeline();timeline.ClearTrackInstances();timeline.SetTrackInstance(this._trackDataItem.GetId(),instance)}_LoadLastKeyframeDataItemFromJson(lastKeyframeDataItemIndex){const keyframeData=
this._trackDataItem.GetKeyframeData();this._lastKeyframeDataItem=keyframeData.GetKeyframeDataItemFromIndex(lastKeyframeDataItemIndex)}}};


// c3/timelines/state/propertyTrackState.js
'use strict';{const C3=self.C3;C3.PropertyTrackState=class PropertyTrack extends C3.DefendedBase{constructor(track,propertyTrackDataItem){super();this._track=track;this._propertyTrackDataItem=propertyTrackDataItem;this._propertyTrackData=propertyTrackDataItem.GetPropertyTrackData();this._sourceAdapter=this.GetSourceAdapter();this._propertyKeyframeDataItems=this._propertyTrackDataItem.GetPropertyKeyframeData().GetPropertyKeyframeDataItemArray()}static Create(track,propertyTrackDataItem){return C3.New(C3.PropertyTrackState,
track,propertyTrackDataItem)}Release(){this._track=null;if(this._sourceAdapter){this._sourceAdapter.Release();this._sourceAdapter=null}this._propertyKeyframeDataItems=null;this._propertyTrackDataItem=null;this._propertyTrackData=null}GetTrack(){return this._track}GetPropertyTrackDataItem(){return this._propertyTrackDataItem}GetPropertyTrackData(){return this._propertyTrackData}GetTimeline(){return this._track.GetTimeline()}GetRuntime(){return this._track.GetRuntime()}GetInstance(){return this._track.GetInstance()}GetSourceAdapter(){if(this._sourceAdapter)return this._sourceAdapter;
const id=this._propertyTrackDataItem.GetSourceAdapterId();let ret;switch(id){case "behavior":ret=new C3.PropertyTrackState.BehaviorSourceAdapter(this);break;case "effect":ret=new C3.PropertyTrackState.EffectSourceAdapter(this);break;case "instance-variable":ret=new C3.PropertyTrackState.InstanceVariableSourceAdapter(this);break;case "plugin":ret=new C3.PropertyTrackState.PluginSourceAdapter(this);break;case "world-instance":ret=new C3.PropertyTrackState.WorldInstanceSourceAdapter(this);break;case "value":ret=
new C3.PropertyTrackState.ValueSourceAdapter(this);break}this._sourceAdapter=ret;return this._sourceAdapter}GetSourceAdapterId(){return this._propertyTrackDataItem.GetSourceAdapterId()}SetSourceAdapterId(said){this._propertyTrackDataItem.SetSourceAdapterId(said)}GetSourceAdapterArgs(){return this._propertyTrackDataItem.GetSourceAdapterArguments()}SetSourceAdapterArgs(sargs){this._propertyTrackDataItem.SetSourceAdapterArguments(sargs)}GetSourceAdapterValue(){return this.GetSourceAdapter().GetValue()}GetPropertyName(){return this._propertyTrackDataItem.GetProperty()}SetPropertyName(pn){this._propertyTrackDataItem.SetProperty(pn)}GetPropertyType(){return this._propertyTrackDataItem.GetType()}SetPropertyType(pt){this._propertyTrackDataItem.SetType(pt)}GetPropertyKeyframeType(){return this.GetPropertyTrackData().GetFirstPropertyKeyframeDataItem(this._propertyTrackDataItem).GetType()}GetMin(){return this._propertyTrackDataItem.GetMin()}SetMin(min){this._propertyTrackDataItem.SetMin(min)}GetMax(){return this._propertyTrackDataItem.GetMax()}SetMax(max){this._propertyTrackDataItem.SetMax(max)}GetEnable(){return this._propertyTrackDataItem.GetEnable()}SetEnable(e){this._propertyTrackDataItem.SetEnable(e)}GetInterpolationMode(){return this._propertyTrackDataItem.GetInterpolationMode()}SetInterpolationMode(im){this._propertyTrackDataItem.SetInterpolationMode(im)}GetResultMode(){return this._propertyTrackDataItem.GetResultMode()}SetResultMode(rm){this._propertyTrackDataItem.SetResultMode(rm)}SetEase(e){for(const propertyKeyframeDataItem of this.GetPropertyKeyframeDataItems())propertyKeyframeDataItem.SetEase(e)}GetPropertyKeyframeDataItems(){if(this._propertyKeyframeDataItems)return this._propertyKeyframeDataItems;
this._propertyKeyframeDataItems=this._propertyTrackDataItem.GetPropertyKeyframeData().GetPropertyKeyframeDataItemArray();return this._propertyKeyframeDataItems}*GetPropertyKeyframeValues(){for(const propertyKeyframeDataItem of this.GetPropertyKeyframeDataItems())yield propertyKeyframeDataItem.GetValueWithResultMode()}CleanCaches(){this.GetSourceAdapter().CleanCaches()}GetCurrentState(){return this.GetSourceAdapter().GetCurrentState()}SetInitialState(){this.GetSourceAdapter().SetInitialState()}SetResumeState(){this.GetSourceAdapter().SetResumeState()}BeforeInterpolate(){this.GetSourceAdapter().BeforeInterpolate()}Interpolate(time,
setTime=false,noChange=false,ensureValue=false){const propertyTrackDataItem=this._propertyTrackDataItem;let start=this._propertyTrackData.GetPropertyKeyFrameDataItemAtTime(time,propertyTrackDataItem);let end;if(start)end=this._propertyTrackData.GetFirstPropertyKeyFrameDataItemHigherThan(time,propertyTrackDataItem);else{start=this._propertyTrackData.GetFirstPropertyKeyFrameDataItemLowerOrEqualThan(time,propertyTrackDataItem);end=this._propertyTrackData.GetFirstPropertyKeyFrameDataItemHigherOrEqualThan(time,
propertyTrackDataItem)}return this.GetSourceAdapter().Interpolate(time,start,end,setTime,noChange,ensureValue)}AfterInterpolate(){this.GetSourceAdapter().AfterInterpolate()}static GetStartPropertyKeyframeForTime(time,propertyTrack){const propertyTrackDataItem=propertyTrack.GetPropertyTrackDataItem();const propertyTrackData=propertyTrack._propertyTrackData;let start=propertyTrackData.GetPropertyKeyFrameDataItemAtTime(time,propertyTrackDataItem);if(!start)start=propertyTrackData.GetFirstPropertyKeyFrameDataItemLowerOrEqualThan(time,
propertyTrackDataItem);return start}static GetEndPropertyKeyframeForTime(time,propertyTrack){const propertyTrackDataItem=propertyTrack.GetPropertyTrackDataItem();const propertyTrackData=propertyTrack._propertyTrackData;let end=propertyTrackData.GetPropertyKeyFrameDataItemAtTime(time,propertyTrackDataItem);if(end)return propertyTrackData.GetFirstPropertyKeyFrameDataItemHigherThan(time,propertyTrackDataItem);else return propertyTrackData.GetFirstPropertyKeyFrameDataItemHigherOrEqualThan(time,propertyTrackDataItem)}AddPropertyKeyframe(){const propertyKeyframeData=
this._propertyTrackDataItem.GetPropertyKeyframeData();const propertyKeyframeDataItem=propertyKeyframeData.AddEmptyPropertyKeyframeDataItem();return propertyKeyframeDataItem}DeletePropertyKeyframes(match){const propertyKeyframeData=this._propertyTrackDataItem.GetPropertyKeyframeData();propertyKeyframeData.DeletePropertyKeyframeDataItems(match)}SaveState(){this.GetSourceAdapter().SaveState()}CompareInitialStateWithCurrent(){const difference=this.GetSourceAdapter().CompareInitialStateWithCurrent();if(difference){const propertyKeyframeDataItem=
this._propertyTrackData.GetFirstPropertyKeyframeDataItem(this._propertyTrackDataItem);const currentState=this.GetSourceAdapter().GetCurrentState();propertyKeyframeDataItem.SetAbsoluteValue(currentState)}}CompareSaveStateWithCurrent(){const difference=this.GetSourceAdapter().CompareSaveStateWithCurrent();if(difference)this.AddPropertyKeyframeAtCurrentTime();this.GetSourceAdapter().ClearSaveState();return difference}AddPropertyKeyframeAtCurrentTime(){const time=this.GetTimeline().GetTime();const sourceAdapter=
this.GetSourceAdapter();const startPropertyKeyframe=C3.PropertyTrackState.GetStartPropertyKeyframeForTime(time,this);const propertyKeyframeDataItem=this.AddPropertyKeyframe();propertyKeyframeDataItem.SetType(startPropertyKeyframe.GetType());propertyKeyframeDataItem.SetTime(time);propertyKeyframeDataItem.SetEase(startPropertyKeyframe.GetEase());propertyKeyframeDataItem.SetEnable(true);propertyKeyframeDataItem.SetValue(sourceAdapter.GetValueAtTime());propertyKeyframeDataItem.SetAbsoluteValue(sourceAdapter.GetCurrentState())}_SaveToJson(){return{"sourceAdapterJson":this.GetSourceAdapter()._SaveToJson()}}_LoadFromJson(o){if(!o)return;
this.GetSourceAdapter()._LoadFromJson(o["sourceAdapterJson"])}}};


// c3/timelines/state/propertySourceAdapters/propertySourceAdapter.js
'use strict';{const C3=self.C3;const NS=C3.PropertyTrackState;NS.PropertySourceAdapter=class PropertySourceAdapter{constructor(propertyTrack){this._propertyTrack=propertyTrack;this._propertyAdapter=null}Release(){if(this._propertyAdapter){this._propertyAdapter.Release();this._propertyAdapter=null}this._propertyTrack=null}GetPropertyTrack(){return this._propertyTrack}CleanCaches(){if(this._propertyAdapter)this._propertyAdapter.CleanCaches()}GetPropertyAdapter(){if(this._propertyAdapter)return this._propertyAdapter;
this._propertyAdapter=this._CreatePropertyAdapter();return this._propertyAdapter}GetEditorIndex(){}GetIndex(){return this.GetEditorIndex()}GetTarget(){}SetInitialState(){this.GetPropertyAdapter().SetInitialState()}SetResumeState(){this.GetPropertyAdapter().SetResumeState()}BeforeInterpolate(){this.GetPropertyAdapter().BeforeChangeProperty()}Interpolate(time,start,end,setTime,noChange,ensureValue){const interpolateFunc=NS.PropertySourceAdapter.GetInterpolateFunc(this._propertyTrack);const value=interpolateFunc(time,
start,end,this._propertyTrack);if(noChange)return value;return this.GetPropertyAdapter().ChangeProperty(time,value,start,end,setTime,ensureValue)}AfterInterpolate(){this.GetPropertyAdapter().AfterChangeProperty()}SaveState(){this.GetPropertyAdapter().SetSaveState()}ClearSaveState(){this.GetPropertyAdapter().ClearSaveState()}GetCurrentState(){return this.GetPropertyAdapter().GetCurrentState()}CompareInitialStateWithCurrent(){return this.GetPropertyAdapter().CompareInitialStateWithCurrent()}CompareSaveStateWithCurrent(){return this.GetPropertyAdapter().CompareSaveStateWithCurrent()}GetValueAtTime(){return NS.PropertySourceAdapter.GetValueAtTime(this._propertyTrack)}_CreatePropertyAdapter(){const propertyType=
this._propertyTrack.GetPropertyType();const keyframePropertyType=this._propertyTrack.GetPropertyKeyframeType();switch(keyframePropertyType){case "combo":case "boolean":case "text":case "string":{return new NS.PropertyInterpolationAdapter.NoInterpolationAdapter(this)}case "numeric":case "number":case "angle":{if(propertyType==="combo")return new NS.PropertyInterpolationAdapter.NoInterpolationAdapter(this);return new NS.PropertyInterpolationAdapter.NumericInterpolationAdapter(this)}case "color":case "offsetColor":{return new NS.PropertyInterpolationAdapter.ColorInterpolationAdapter(this)}}}_SaveToJson(){return{"propertyAdapterJson":this.GetPropertyAdapter()._SaveToJson()}}_LoadFromJson(o){if(!o)return;
this.GetPropertyAdapter()._LoadFromJson(o["propertyAdapterJson"])}static GetValueAtTime(propertyTrack){const track=propertyTrack.GetTrack();const time=track.GetTimeline().GetTime();const start=NS.GetStartPropertyKeyframeForTime(time,propertyTrack);const end=NS.GetEndPropertyKeyframeForTime(time,propertyTrack);const interpolateFunc=NS.PropertySourceAdapter.GetInterpolateFunc(propertyTrack);return interpolateFunc(time,start,end,propertyTrack)}static GetValue(propertyTrack,initialValue,value){let resultMode=
propertyTrack.GetResultMode();if(propertyTrack.GetPropertyType()==="combo")resultMode="absolute";switch(resultMode){case "relative":return initialValue+value;case "absolute":return value}}static GetInterpolateFunc(propertyTrack){const type=propertyTrack.GetPropertyKeyframeType();switch(type){case "numeric":return NS.NumericTypeAdapter.Interpolate;case "angle":return NS.AngleTypeAdapter.Interpolate;case "boolean":return NS.BooleanTypeAdapter.Interpolate;case "color":return NS.ColorTypeAdapter.Interpolate;
case "text":return NS.TextTypeAdapter.Interpolate}}static GetWillChangeFunc(propertyTrack){const type=propertyTrack.GetPropertyKeyframeType();switch(type){case "numeric":return NS.NumericTypeAdapter.WillChange;case "angle":return NS.AngleTypeAdapter.WillChange;case "boolean":return NS.BooleanTypeAdapter.WillChange;case "color":return NS.ColorTypeAdapter.WillChange;case "text":return NS.TextTypeAdapter.WillChange}}}};


// c3/timelines/state/propertySourceAdapters/worldInstanceSourceAdapter.js
'use strict';{const C3=self.C3;class WorldInstanceSourceAdapter extends C3.PropertyTrackState.PropertySourceAdapter{constructor(propertyTrack){super(propertyTrack)}}C3.PropertyTrackState.WorldInstanceSourceAdapter=WorldInstanceSourceAdapter};


// c3/timelines/state/propertySourceAdapters/instanceVariableSourceAdapter.js
'use strict';{const C3=self.C3;const INDEX=0;class InstanceVariableSourceAdapter extends C3.PropertyTrackState.PropertySourceAdapter{constructor(propertyTrack){super(propertyTrack);this._updatedIndex=NaN}GetEditorIndex(){return this._propertyTrack.GetPropertyTrackDataItem().GetSourceAdapterArguments()[INDEX]}GetIndex(){if(this._updatedIndex)return this._updatedIndex;return super.GetIndex()}GetTarget(){return this._propertyTrack.GetTrack().GetInstance()}UpdateInstanceVariableIndex(index){const i=this._propertyTrack.GetPropertyTrackDataItem().GetSourceAdapterArguments()[INDEX];
if(i===index)return;this._updatedIndex=index}Interpolate(time,start,end,setTime,noChange,ensureValue){if(!this.GetPropertyAdapter().CanChange(start.GetValue()))return;return super.Interpolate(time,start,end,setTime,noChange,ensureValue)}_SaveToJson(){return Object.assign(super._SaveToJson(),{"index":this._updatedIndex})}_LoadFromJson(o){if(!o)return;super._LoadFromJson(o);this._updatedIndex=o["index"]}}C3.PropertyTrackState.InstanceVariableSourceAdapter=InstanceVariableSourceAdapter};


// c3/timelines/state/propertySourceAdapters/behaviorSourceAdapter.js
'use strict';{const C3=self.C3;const SID=0;const INDEX=1;const NAME=2;class BehaviorSourceAdapter extends C3.PropertyTrackState.PropertySourceAdapter{constructor(propertyTrack){super(propertyTrack);this._sid=NaN}GetEditorIndex(){const dataItem=this._propertyTrack.GetPropertyTrackDataItem();return dataItem.GetSourceAdapterArguments()[INDEX]}GetTarget(){const dataItem=this._propertyTrack.GetPropertyTrackDataItem();const track=this._propertyTrack.GetTrack();const sid=this._sid?this._sid:dataItem.GetSourceAdapterArguments()[SID];
const instance=track.GetInstance();const index=instance.GetBehaviorIndexBySID(sid);const behaviorInstance=instance.GetBehaviorInstances()[index];return behaviorInstance.GetSdkInstance()}GetBehaviorType(objectClass){const dataItem=this._propertyTrack.GetPropertyTrackDataItem();const name=dataItem.GetSourceAdapterArguments()[NAME];return objectClass.GetBehaviorTypeByName(name)}UpdateBehaviorTypeSid(sid){const dataItem=this._propertyTrack.GetPropertyTrackDataItem();if(dataItem.GetSourceAdapterArguments()[SID]===
sid)return;this._sid=sid}Interpolate(time,start,end,setTime,noChange,ensureValue){const track=this._propertyTrack.GetTrack();const instance=track.GetInstance();if(!this.GetBehaviorType(instance.GetObjectClass()))return;return super.Interpolate(time,start,end,setTime,noChange,ensureValue)}_SaveToJson(){return Object.assign(super._SaveToJson(),{"sid":this._sid})}_LoadFromJson(o){if(!o)return;super._LoadFromJson(o);this._sid=o["sid"]}}C3.PropertyTrackState.BehaviorSourceAdapter=BehaviorSourceAdapter};


// c3/timelines/state/propertySourceAdapters/effectSourceAdapter.js
'use strict';{const C3=self.C3;const NAME=0;const INDEX=1;class EffectSourceAdapter extends C3.PropertyTrackState.PropertySourceAdapter{constructor(propertyTrack){super(propertyTrack)}GetEditorIndex(){return this._propertyTrack.GetPropertyTrackDataItem().GetSourceAdapterArguments()[INDEX]}GetTarget(){const pTrack=this._propertyTrack;const track=pTrack.GetTrack();const worldInfo=track.GetWorldInfo();const instanceEffectList=worldInfo.GetInstanceEffectList();const effectList=instanceEffectList.GetEffectList();
const effectType=this.GetEffectType(effectList);const effectIndex=effectType.GetIndex();if(instanceEffectList.IsEffectIndexActive(effectIndex))return instanceEffectList.GetEffectParametersForIndex(effectIndex);return null}GetEffectType(effectList){const pTrack=this._propertyTrack;const name=pTrack.GetPropertyTrackDataItem().GetSourceAdapterArguments()[NAME];return effectList.GetEffectTypeByName(name)}Interpolate(time,start,end,setTime,noChange,ensureValue){if(!this._IsEffectActive())return;return super.Interpolate(time,
start,end,setTime,noChange,ensureValue)}_IsEffectActive(){const pTrack=this._propertyTrack;const track=pTrack.GetTrack();const worldInfo=track.GetWorldInfo();const instanceEffectList=worldInfo.GetInstanceEffectList();const effectList=instanceEffectList.GetEffectList();const effectType=this.GetEffectType(effectList);if(!effectType)return;const effectIndex=effectType.GetIndex();return instanceEffectList.IsEffectIndexActive(effectIndex)}}C3.PropertyTrackState.EffectSourceAdapter=EffectSourceAdapter};


// c3/timelines/state/propertySourceAdapters/pluginSourceAdapter.js
'use strict';{const C3=self.C3;const INDEX=0;class PluginSourceAdapter extends C3.PropertyTrackState.PropertySourceAdapter{constructor(propertyTrack){super(propertyTrack)}GetEditorIndex(){return this._propertyTrack.GetPropertyTrackDataItem().GetSourceAdapterArguments()[INDEX]}GetTarget(){return this._propertyTrack.GetTrack().GetInstance().GetSdkInstance()}Interpolate(time,start,end,setTime,noChange,ensureValue){const track=this._propertyTrack.GetTrack();const templatePlugin=track.GetObjectClass().GetPlugin();
const currentPlugin=track.GetInstance().GetObjectClass().GetPlugin();if(templatePlugin!==currentPlugin)return;return super.Interpolate(time,start,end,setTime,noChange,ensureValue)}}C3.PropertyTrackState.PluginSourceAdapter=PluginSourceAdapter};


// c3/timelines/state/propertySourceAdapters/valueSourceAdapter.js
'use strict';{const C3=self.C3;class ValueSourceAdapter extends C3.PropertyTrackState.PropertySourceAdapter{constructor(propertyTrack){super(propertyTrack);this._value=0;this._init=false}SetInitialState(){const propertyTrackData=this._propertyTrack.GetPropertyTrackData();let propertyTrackDataItem=this._propertyTrack.GetPropertyTrackDataItem();propertyTrackDataItem=propertyTrackData.GetFirstPropertyKeyframeDataItem(propertyTrackDataItem);this._value=propertyTrackDataItem.GetValueWithResultMode()}SetResumeState(){}GetValue(){if(!this._init)this._propertyTrack.Interpolate(0);
return this._value}Interpolate(time,start,end,setTime,noChange,ensureValue){const interpolateFunc=C3.PropertyTrackState.NumericTypeAdapter.Interpolate;this._value=interpolateFunc(time,start,end,this._propertyTrack);this._init=true}SaveState(){}ClearSaveState(){}GetCurrentState(){return this._value}CompareInitialStateWithCurrent(){return false}CompareSaveStateWithCurrent(){return false}_SaveToJson(){return{"value":this._value,"init":this._init}}_LoadFromJson(o){if(!o)return;this._value=o["value"];
this._init=o.hasOwnProperty("init")?o["init"]:true}}C3.PropertyTrackState.ValueSourceAdapter=ValueSourceAdapter};


// c3/timelines/state/propertyInterpolationAdapters/propertyInterpolationAdapter.js
'use strict';{const C3=self.C3;C3.PropertyTrackState.PropertyInterpolationAdapter=class PropertyInterpolationAdapter{constructor(sourceAdapter){this._sourceAdapter=sourceAdapter;this._propertyTrack=sourceAdapter.GetPropertyTrack();this._worldInfo=this._propertyTrack.GetTrack().GetWorldInfo();this._property=this._propertyTrack.GetPropertyName();this._firstAbsoluteUpdate=false;this._saveState=null;this._target=null}Release(){this._sourceAdapter=null;this._propertyTrack=null;this._worldInfo=null;this._saveState=
null;this._target=null}CleanCaches(){this._worldInfo=null;this._saveState=null;this._target=null}GetPropertyTrack(){return this._propertyTrack}GetWorldInfo(){if(this._worldInfo)return this._worldInfo;this._worldInfo=this._propertyTrack.GetTrack().GetWorldInfo();return this._worldInfo}SetFirstAbsoluteUpdate(f){this._firstAbsoluteUpdate=!!f}GetFirstAbsoluteUpdate(){return this._firstAbsoluteUpdate}SetInitialState(){}SetResumeState(){}SetSaveState(){this._saveState=this.GetCurrentState()}ClearSaveState(){this._saveState=
null}GetCurrentState(){}CompareInitialStateWithCurrent(){}CompareSaveStateWithCurrent(){}CanChange(value){const targetType=typeof this._Getter();const newType=typeof value;return targetType===newType}BeforeChangeProperty(){}ChangeProperty(time,value,start,end,setTime){}AfterChangeProperty(){}_FirstKeyframeGetter(){const propertyKeyframeDataItem=this._PickTimelinePlaybackMode(()=>{const propertyTrackDataItem=this._propertyTrack.GetPropertyTrackDataItem();const propertyTrackData=this._propertyTrack.GetPropertyTrackData();
return propertyTrackData.GetFirstPropertyKeyframeDataItem(propertyTrackDataItem)},()=>{const propertyTrackDataItem=this._propertyTrack.GetPropertyTrackDataItem();const propertyTrackData=this._propertyTrack.GetPropertyTrackData();return propertyTrackData.GetLastPropertyKeyframeDataItem(propertyTrackDataItem)});return propertyKeyframeDataItem.GetAbsoluteValue()}_CurrentKeyframeGetter(){const timeline=this._propertyTrack.GetTimeline();const time=timeline.GetTime()-this._propertyTrack.GetTrack().GetStartOffset();
const propertyKeyframe=this._PickTimelinePlaybackMode(()=>{const propertyTrackDataItem=this._propertyTrack.GetPropertyTrackDataItem();const propertyTrackData=this._propertyTrack.GetPropertyTrackData();return propertyTrackData.GetFirstPropertyKeyFrameDataItemLowerOrEqualThan(time,propertyTrackDataItem)},()=>{const propertyTrackDataItem=this._propertyTrack.GetPropertyTrackDataItem();const propertyTrackData=this._propertyTrack.GetPropertyTrackData();const ret=propertyTrackData.GetFirstPropertyKeyFrameDataItemHigherOrEqualThan(time,
propertyTrackDataItem);if(!ret)return propertyTrackData.GetLastPropertyKeyframeDataItem(propertyTrackDataItem);return ret});return propertyKeyframe.GetAbsoluteValue()}_PickTimelinePlaybackMode(forwardFunc,backwardFunc){const timeline=this._propertyTrack.GetTimeline();return timeline.IsForwardPlayBack()?forwardFunc():backwardFunc()}_PickResultMode(relativeFunc,absoluteFunc){const resultMode=this._propertyTrack.GetResultMode();return resultMode==="relative"?relativeFunc():absoluteFunc()}_PickFirstAbsoluteUpdate(firstFunc,
otherFunc){if(this.GetFirstAbsoluteUpdate()){this.SetFirstAbsoluteUpdate(false);return firstFunc()}else return otherFunc()}_GetAbsoluteInitialValue(keyframeValue){}_GetIndex(){return this._sourceAdapter.GetIndex()}_GetTarget(){if(this._target)return this._target;this._target=this._sourceAdapter.GetTarget();return this._target}_PickSource(bFunc,eFunc,ivFunc,pFunc,wiFunc){const id=this._propertyTrack.GetSourceAdapterId();switch(id){case "behavior":return bFunc();case "effect":return eFunc();case "instance-variable":return ivFunc();
case "plugin":return pFunc();case "world-instance":return wiFunc()}}_SaveToJson(){return{"firstAbsoluteUpdate":this._firstAbsoluteUpdate,"saveState":this._saveState}}_LoadFromJson(o){if(!o)return;this._firstAbsoluteUpdate=o["firstAbsoluteUpdate"];this._saveState=o["saveState"]}_GetPropertyKeyframeStubs(propertyTracks,firstOnly=false){const ret=[];for(const propertyTrack of propertyTracks){const startOffset=propertyTrack.GetTrack().GetStartOffset();for(const propertyKeyframeDataItem of propertyTrack.GetPropertyKeyframeDataItems())if(firstOnly&&
propertyKeyframeDataItem.GetTime()===0)ret.push({time:startOffset+propertyKeyframeDataItem.GetTime(),value:propertyKeyframeDataItem.GetAbsoluteValue()});else if(!firstOnly)ret.push({time:startOffset+propertyKeyframeDataItem.GetTime(),value:propertyKeyframeDataItem.GetAbsoluteValue()})}return ret.sort((f,s)=>f.time-s.time)}_GetLastPropertyKeyframeStub(timeline,time,propertyKeyframeStubs){return this._GetPropertyKeyframeStubLowerThanPlayhead(time,propertyKeyframeStubs)}_GetPropertyKeyframeStubLowerThanPlayhead(time,
propertyKeyframeStubs){for(let i=propertyKeyframeStubs.length-1;i>=0;i--){const stubTime=propertyKeyframeStubs[i].time;if(stubTime<=time)return propertyKeyframeStubs[i]}return null}}};


// c3/timelines/state/propertyInterpolationAdapters/colorInterpolationAdapter.js
'use strict';{const C3=self.C3;const TMP_COLORS_MAP=new Map;const TMP_COLOR=[0,0,0];class ColorInterpolationAdapter extends C3.PropertyTrackState.PropertyInterpolationAdapter{constructor(sourceAdapter){super(sourceAdapter)}SetInitialState(){}SetResumeState(){}GetCurrentState(){const id=this._propertyTrack.GetSourceAdapterId();const target=this._GetTarget();const index=this._GetIndex();switch(id){case "behavior":return this._ToColorArray(target.GetPropertyValueByIndex(index));case "effect":return this._ToColorArray(target[index]);
case "plugin":return this._ToColorArray(target.GetPropertyValueByIndex(index));case "world-instance":return this._ToColorArray(this._Getter())}}CompareInitialStateWithCurrent(){const firstKeyframeColor=this._FirstKeyframeGetter();return!this._CompareColors(firstKeyframeColor,this._Getter())}CompareSaveStateWithCurrent(){if(C3.IsNullOrUndefined(this._saveState))return false;return!this._CompareColors(this._saveState,this._Getter())}_CompareColors(fColor,sColor){return fColor.equalsIgnoringAlpha(sColor)}_FirstKeyframeGetter(){const color=
super._FirstKeyframeGetter();return this._GetColorFromArray(color)}_CurrentKeyframeGetter(){const color=super._CurrentKeyframeGetter();return this._GetColorFromArray(color)}_GetAbsoluteInitialValue(value){}_ToColorArray(color){if(C3.IsInstanceOf(color,C3.Color))return color.toArray().slice(0,3);return color.slice(0,3)}_GetColorFromArray(color){if(C3.IsInstanceOf(color,C3.Color))return color;return new C3.Color(color[0],color[1],color[2],1)}CanChange(value){return true}BeforeChangeProperty(){const instance=
this._propertyTrack.GetInstance();if(!TMP_COLORS_MAP.has(instance))TMP_COLORS_MAP.set(instance,new Map);const instanceMap=TMP_COLORS_MAP.get(instance);const id=this._propertyTrack.GetSourceAdapterId();if(!instanceMap.has(id))instanceMap.set(id,new Map);const sourceMap=instanceMap.get(id);if(!sourceMap.has(this._property))sourceMap.set(this._property,{used:false,color:new C3.Color(0,0,0,1)})}_GetTmpColor(instance,sourceId,propertyName){const tmpColorObj=TMP_COLORS_MAP.get(instance).get(sourceId).get(propertyName);
tmpColorObj.used=true;return tmpColorObj.color}ChangeProperty(time,value,start,end,setTime){const timeline=this._propertyTrack.GetTimeline();const track=this._propertyTrack.GetTrack();const instance=this._propertyTrack.GetInstance();const sourceAdapter=this._propertyTrack.GetSourceAdapter();const sourceAdapterId=this._propertyTrack.GetSourceAdapterId();const property=this._property;const propertyTracks=timeline.GetSimilarPropertyTracks(instance,sourceAdapter,property);if(propertyTracks.length>1){const propertyKeyframeStubs=
this._GetPropertyKeyframeStubs(propertyTracks,true);const stub=this._GetLastPropertyKeyframeStub(timeline,timeline.GetTime(),propertyKeyframeStubs);if(stub){const startOffset=track.GetStartOffset();const t=stub.time-startOffset;if(t===0)this._GetTmpColor(instance,sourceAdapterId,this._property).addRgb(value[0],value[1],value[2]);else{if(t<0)return;const r=value[0];const g=value[1];const b=value[2];const v=this._propertyTrack.Interpolate(t,false,true);const dr=C3.Color.DiffChannel(r,v[0]);const dg=
C3.Color.DiffChannel(g,v[1]);const db=C3.Color.DiffChannel(b,v[2]);this._GetTmpColor(instance,sourceAdapterId,this._property).addRgb(dr,dg,db)}}}else this._Setter(value[0],value[1],value[2]);return C3.TimelineState.LAYOUT_RENDER_CHANGE}AfterChangeProperty(){const instance=this._propertyTrack.GetInstance();if(!TMP_COLORS_MAP.has(instance))return;const instanceMap=TMP_COLORS_MAP.get(instance);const id=this._propertyTrack.GetSourceAdapterId();if(!instanceMap.has(id))return;const sourceMap=instanceMap.get(id);
if(!sourceMap.has(this._property))return;const tmpColorObj=sourceMap.get(this._property);const used=tmpColorObj.used;const color=tmpColorObj.color;if(used)this._Setter(color.getR(),color.getG(),color.getB());if(sourceMap.size===0)instanceMap.delete(id);if(instanceMap.size===0)TMP_COLORS_MAP.delete(instance)}_Getter(){const id=this._propertyTrack.GetSourceAdapterId();const target=this._GetTarget();const index=this._GetIndex();switch(id){case "behavior":return this._GetColorFromArray(target.GetPropertyValueByIndex(index));
case "effect":return target[index].clone();case "plugin":return this._GetColorFromArray(target.GetPropertyValueByIndex(index));case "world-instance":return this.GetWorldInfo().GetUnpremultipliedColor().clone()}}_Setter(r,g,b){const id=this._propertyTrack.GetSourceAdapterId();const target=this._GetTarget();const index=this._GetIndex();switch(id){case "behavior":TMP_COLOR[0]=r;TMP_COLOR[1]=g;TMP_COLOR[2]=b;target.SetPropertyValueByIndex(index,TMP_COLOR);break;case "effect":target[index].setRgb(r,g,
b);break;case "plugin":TMP_COLOR[0]=r;TMP_COLOR[1]=g;TMP_COLOR[2]=b;target.SetPropertyValueByIndex(index,TMP_COLOR);break;case "world-instance":this.GetWorldInfo().SetUnpremultipliedColorRGB(r,g,b);break}}_SaveToJson(){}_LoadFromJson(o){}}C3.PropertyTrackState.PropertyInterpolationAdapter.ColorInterpolationAdapter=ColorInterpolationAdapter};


// c3/timelines/state/propertyInterpolationAdapters/noInterpolationAdapter.js
'use strict';{const C3=self.C3;class NoInterpolationAdapter extends C3.PropertyTrackState.PropertyInterpolationAdapter{constructor(sourceAdapter){super(sourceAdapter)}SetInitialState(){}SetResumeState(){}GetCurrentState(){return this._Getter()}CompareInitialStateWithCurrent(){const firstKeyframeValue=this._FirstKeyframeGetter();return firstKeyframeValue!==this.GetCurrentState()}CompareSaveStateWithCurrent(){if(C3.IsNullOrUndefined(this._saveState))return false;return this._saveState!==this.GetCurrentState()}ChangeProperty(time,
value,start,end,setTime){const willChangeFunc=C3.PropertyTrackState.PropertySourceAdapter.GetWillChangeFunc(this._propertyTrack);const propertyTrack=this._propertyTrack;const track=propertyTrack.GetTrack();const id=propertyTrack.GetSourceAdapterId();const timeline=propertyTrack.GetTimeline();const instance=track.GetInstance();const sourceAdapter=propertyTrack.GetSourceAdapter();const property=this._property;const propertyTracks=timeline.GetSimilarPropertyTracks(instance,sourceAdapter,property);if(propertyTracks.length>
1){const propertyKeyframeStubs=this._GetPropertyKeyframeStubs(propertyTracks);const t=time+track.GetStartOffset();const stub=this._GetLastPropertyKeyframeStub(timeline,t,propertyKeyframeStubs);if(stub)value=stub.value}const change=willChangeFunc(this._GetIndex(),this._GetTarget(),value,id);if(!change)return;this._Setter(value);switch(id){case "behavior":return;case "effect":return;case "instance-variable":return;case "plugin":return C3.TimelineState.LAYOUT_RENDER_CHANGE}}_Getter(){const id=this._propertyTrack.GetSourceAdapterId();
const target=this._GetTarget();const index=this._GetIndex();switch(id){case "behavior":return target.GetPropertyValueByIndex(index);case "effect":return target[index];case "instance-variable":return target.GetInstanceVariableValue(index);case "plugin":return target.GetPropertyValueByIndex(index)}}_Setter(value){const id=this._propertyTrack.GetSourceAdapterId();const target=this._GetTarget();const index=this._GetIndex();switch(id){case "behavior":target.SetPropertyValueByIndex(index,value);break;case "effect":target[index]=
value;break;case "instance-variable":target.SetInstanceVariableValue(index,value);break;case "plugin":target.SetPropertyValueByIndex(index,value);break}}}C3.PropertyTrackState.PropertyInterpolationAdapter.NoInterpolationAdapter=NoInterpolationAdapter};


// c3/timelines/state/propertyInterpolationAdapters/numericInterpolationAdapter.js
'use strict';{const C3=self.C3;const NS=C3.PropertyTrackState.PropertyInterpolationAdapter;const INSTANCE_FUNC_MAP=new Map;const add=(prop,setter,absolute_setter,getter,round)=>INSTANCE_FUNC_MAP.set(prop,{setter,absolute_setter,getter,round});add("offsetX",(wi,v)=>wi.OffsetX(v),(wi,v)=>wi.SetX(v),wi=>wi.GetX(),true);add("offsetY",(wi,v)=>wi.OffsetY(v),(wi,v)=>wi.SetY(v),wi=>wi.GetY(),true);add("offsetWidth",(wi,v)=>wi.OffsetWidth(v),(wi,v)=>wi.SetWidth(v),wi=>wi.GetWidth(),true);add("offsetHeight",
(wi,v)=>wi.OffsetHeight(v),(wi,v)=>wi.SetHeight(v),wi=>wi.GetHeight(),true);add("offsetAngle",(wi,v)=>wi.OffsetAngle(v),(wi,v)=>wi.SetAngle(v),wi=>wi.GetAngle(),false);add("offsetOpacity",(wi,v,t,a)=>{const o=wi.GetOpacity();const nv=o+v;const min=0;const max=1;if(a._clampAccumulator===0){if(nv>max)a._clampAccumulator+=nv-max;else if(nv<min)a._clampAccumulator+=nv;wi.OffsetOpacity(v)}else{const nv=wi.GetOpacity()+v;if(v>0&&a._clampAccumulator>0){if(nv>max)a._clampAccumulator+=nv-max}else if(v>0&&
a._clampAccumulator<0){a._clampAccumulator+=v;if(a._clampAccumulator>0)a._clampAccumulator=0}else if(v<0&&a._clampAccumulator>0){a._clampAccumulator+=v;if(a._clampAccumulator<0)a._clampAccumulator=0}else if(v<0&&a._clampAccumulator<0)if(nv<min)a._clampAccumulator+=nv}},(wi,v)=>{wi.SetOpacity(v)},wi=>{return wi.GetOpacity()},false);add("offsetOriginX",(wi,v)=>wi.OffsetOriginX(v),(wi,v)=>wi.SetOriginX(v),wi=>wi.GetOriginX(),false);add("offsetOriginY",(wi,v)=>wi.OffsetOriginY(v),(wi,v)=>wi.SetOriginY(v),
wi=>wi.GetOriginY(),false);add("offsetZElevation",(wi,v)=>wi.OffsetZElevation(v),(wi,v)=>wi.SetZElevation(v),wi=>wi.GetZElevation(),true);add("offsetScaleX",(wi,v,t)=>{const mirrorFactor=wi.GetWidth()<0?-1:1;if(wi.GetTransformWithParentWidth()){const parentWi=wi.GetParent();const sgi=wi._GetSceneGraphInfo();wi.OffsetWidth(parentWi.GetWidth()*sgi.GetStartScaleX()*mirrorFactor*v)}else wi.OffsetWidth(t.GetOriginalWidth()*mirrorFactor*v)},(wi,v,t)=>{wi.SetWidth(t.GetOriginalWidth()*v)},(wi,t)=>{const mirrorFactor=
wi.GetWidth()<0?-1:1;if(wi.GetTransformWithParentWidth()){const parentWi=wi.GetParent();const parentTrack=t.GetTimeline().GetTrackInstance(parentWi.GetInstance());let parentScale=NaN;if(parentTrack)parentScale=parentWi.GetWidth()/parentTrack.GetOriginalWidth();else{const sdki=parentWi.GetInstance().GetSdkInstance();if(sdki.IsOriginalSizeKnown())parentScale=parentWi.GetWidth()/sdki.GetOriginalWidth();else parentScale=1}return wi.GetWidth()*mirrorFactor/(t.GetOriginalWidth()*parentScale)}else return wi.GetWidth()*
mirrorFactor/t.GetOriginalWidth()},false);add("offsetScaleY",(wi,v,t)=>{const flipFactor=wi.GetHeight()<0?-1:1;if(wi.GetTransformWithParentHeight()){const parentWi=wi.GetParent();const sgi=wi._GetSceneGraphInfo();wi.OffsetHeight(parentWi.GetHeight()*sgi.GetStartScaleY()*flipFactor*v)}else wi.OffsetHeight(t.GetOriginalHeight()*flipFactor*v)},(wi,v,t)=>{wi.SetHeight(t.GetOriginalHeight()*v)},(wi,t)=>{const flipFactor=wi.GetHeight()<0?-1:1;if(wi.GetTransformWithParentHeight()){const parentWi=wi.GetParent();
const parentTrack=t.GetTimeline().GetTrackInstance(parentWi.GetInstance());let parentScale=NaN;if(parentTrack)parentScale=parentWi.GetHeight()/parentTrack.GetOriginalHeight();else{const sdki=parentWi.GetInstance().GetSdkInstance();if(sdki.IsOriginalSizeKnown())parentScale=parentWi.GetHeight()/sdki.GetOriginalHeight();else parentScale=1}return wi.GetHeight()*flipFactor/(t.GetOriginalHeight()*parentScale)}else return wi.GetHeight()*flipFactor/t.GetOriginalHeight()},false);class NumericInterpolationAdapter extends C3.PropertyTrackState.PropertyInterpolationAdapter{constructor(sourceAdapter){super(sourceAdapter);
this._lastValue=0;this._clampAccumulator=0;this._instance_getter=null;this._instance_setter=null;this._instance_absolute_setter=null;this._round=false;if(C3.IsInstanceOf(this._propertyTrack.GetTimeline(),C3.Tween))this._typeAdapter=new C3.PropertyTrackState.PropertyInterpolationAdapter.NumericInterpolationAdapterForTween(this);else this._typeAdapter=new C3.PropertyTrackState.PropertyInterpolationAdapter.NumericInterpolationAdapterForTimeline(this);const property=this._propertyTrack.GetPropertyName();
if(this._propertyTrack.GetSourceAdapterId()==="world-instance"){const p=INSTANCE_FUNC_MAP.get(property);this._instance_getter=p.getter;this._instance_setter=p.setter;this._instance_absolute_setter=p.absolute_setter;this._round=p.round}}Release(){this._typeAdapter=null;this._instance_getter=null;this._instance_setter=null;this._instance_absolute_setter=null;super.Release()}GetLastValue(){return this._lastValue}SetLastValue(v){this._lastValue=v}SetInitialState(){const initValue=this._typeAdapter.SetInitialState();
if(typeof initValue==="number")this._lastValue=initValue;this._clampAccumulator=0}SetResumeState(){const resumeValue=this._typeAdapter.SetResumeState();if(typeof resumeValue==="number")this._lastValue=resumeValue}GetCurrentState(){return this._Getter()}CompareInitialStateWithCurrent(){const firstKeyframeValue=this._FirstKeyframeGetter();return firstKeyframeValue!==this.GetCurrentState()}CompareSaveStateWithCurrent(){if(C3.IsNullOrUndefined(this._saveState))return false;return this._saveState!==this.GetCurrentState()}BeforeChangeProperty(){this._typeAdapter.BeforeChangeProperty()}ChangeProperty(time,
value,start,end,setTime,ensureValue){return this._typeAdapter.ChangeProperty(time,value,start,end,setTime,ensureValue)}AfterChangeProperty(){this._typeAdapter.AfterChangeProperty()}_Getter(){const target=this._GetTarget();const index=this._GetIndex();const track=this._propertyTrack.GetTrack();const wi=this.GetWorldInfo();return this._PickSource(()=>target.GetPropertyValueByIndex(index),()=>target[index],()=>target.GetInstanceVariableValue(index),()=>target.GetPropertyValueByIndex(index),()=>this._instance_getter(wi,
track))}_Setter(value,start,end){const target=this._GetTarget();const index=this._GetIndex();const track=this._propertyTrack.GetTrack();const wi=this.GetWorldInfo();this._PickSource(()=>target.OffsetPropertyValueByIndex(index,value),()=>target[index]+=value,()=>target.SetInstanceVariableOffset(index,value),()=>target.OffsetPropertyValueByIndex(index,value),()=>this._instance_setter(wi,value,track,this))}_SetterAbsolute(value,start,end){const target=this._GetTarget();const index=this._GetIndex();const track=
this._propertyTrack.GetTrack();const wi=this.GetWorldInfo();this._PickSource(()=>target.SetPropertyValueByIndex(index,value),()=>target[index]=value,()=>target.SetInstanceVariableValue(index,value),()=>target.SetPropertyValueByIndex(index,value),()=>this._instance_absolute_setter(wi,value,track))}_MaybeEnsureValue(time,start,end,setTime,lastValue,currentValue){this._typeAdapter._MaybeEnsureValue(time,start,end,setTime,lastValue,currentValue)}_AddDelta(value,start,end){const stringValue=value.toString();
const decimalsString=stringValue.split(".")[1]||"";const decimalPlaces=decimalsString.length;const v=this._Getter();let rv;if(decimalPlaces===0)rv=this._round?Math.round(v):v;else rv=C3.toFixed(v,decimalPlaces);this._Setter(rv-v,start,end)}_SaveToJson(){return Object.assign(super._SaveToJson(),{"v":this._lastValue,"a":this._clampAccumulator})}_LoadFromJson(o){if(!o)return;super._LoadFromJson(o);this._lastValue=o["v"];this._clampAccumulator=o["a"]}}C3.PropertyTrackState.PropertyInterpolationAdapter.NumericInterpolationAdapter=
NumericInterpolationAdapter};


// c3/timelines/state/propertyInterpolationAdapters/numericInterpolationAdapterForTimeline.js
'use strict';{const C3=self.C3;const TMP_ABSOLUTE_VALUES_MAP=new Map;class NumericInterpolationAdapterForTimeline{constructor(numericInterpolationAdapter){this._numericInterpolationAdapter=numericInterpolationAdapter}Release(){this._numericInterpolationAdapter=null}SetInitialState(){const adapter=this._numericInterpolationAdapter;const propertyTrack=this._numericInterpolationAdapter.GetPropertyTrack();return adapter._PickResultMode(()=>{return adapter._PickTimelinePlaybackMode(()=>0,()=>C3.PropertyTrackState.PropertySourceAdapter.GetValueAtTime(propertyTrack))},
()=>{})}SetResumeState(){}BeforeChangeProperty(){const adapter=this._numericInterpolationAdapter;const propertyTrack=this._numericInterpolationAdapter.GetPropertyTrack();const property=propertyTrack.GetPropertyName();adapter._PickResultMode(()=>{},()=>{const instance=propertyTrack.GetInstance();if(!TMP_ABSOLUTE_VALUES_MAP.has(instance))TMP_ABSOLUTE_VALUES_MAP.set(instance,new Map);const instanceMap=TMP_ABSOLUTE_VALUES_MAP.get(instance);const id=propertyTrack.GetSourceAdapterId();if(!instanceMap.has(id))instanceMap.set(id,
new Map);const sourceMap=instanceMap.get(id);if(!sourceMap.has(property))sourceMap.set(property,{used:false,value:0})})}_GetTmpAbsoluteValueObject(instance,sourceId,propertyName){const tmpAbsoluteValueObj=TMP_ABSOLUTE_VALUES_MAP.get(instance).get(sourceId).get(propertyName);tmpAbsoluteValueObj.used=true;return tmpAbsoluteValueObj}ChangeProperty(time,value,start,end,setTime,ensureValue){const adapter=this._numericInterpolationAdapter;const propertyTrack=this._numericInterpolationAdapter.GetPropertyTrack();
const property=propertyTrack.GetPropertyName();adapter._PickResultMode(()=>{const lastValue=adapter.GetLastValue();adapter._Setter(value-lastValue,start,end);if(ensureValue)this._MaybeEnsureValue(time,start,end,setTime,lastValue,value);adapter.SetLastValue(value)},()=>{const timeline=propertyTrack.GetTimeline();const track=propertyTrack.GetTrack();const instance=propertyTrack.GetInstance();const sourceAdapter=propertyTrack.GetSourceAdapter();const sourceAdapterId=propertyTrack.GetSourceAdapterId();
const propertyTracks=timeline.GetSimilarPropertyTracks(instance,sourceAdapter,property);if(propertyTracks.length>1){const propertyKeyframeStubs=adapter._GetPropertyKeyframeStubs(propertyTracks,true);const stub=adapter._GetLastPropertyKeyframeStub(timeline,timeline.GetTime(),propertyKeyframeStubs);if(stub){const startOffset=track.GetStartOffset();const t=stub.time-startOffset;if(t===0){const valueObj=this._GetTmpAbsoluteValueObject(instance,sourceAdapterId,property);valueObj.value+=value}else{if(t<
0)return;const v=propertyTrack.Interpolate(t,false,true);const valueObj=this._GetTmpAbsoluteValueObject(instance,sourceAdapterId,property);valueObj.value+=value-v}}}else adapter._SetterAbsolute(value)});return adapter._PickSource(()=>{},()=>C3.TimelineState.LAYOUT_RENDER_CHANGE,()=>{},()=>C3.TimelineState.LAYOUT_RENDER_CHANGE,()=>C3.TimelineState.LAYOUT_RENDER_CHANGE)}AfterChangeProperty(){const adapter=this._numericInterpolationAdapter;const propertyTrack=this._numericInterpolationAdapter.GetPropertyTrack();
const property=propertyTrack.GetPropertyName();adapter._PickResultMode(()=>{},()=>{const instance=propertyTrack.GetInstance();if(!TMP_ABSOLUTE_VALUES_MAP.has(instance))return;const instanceMap=TMP_ABSOLUTE_VALUES_MAP.get(instance);const id=propertyTrack.GetSourceAdapterId();if(!instanceMap.has(id))return;const sourceMap=instanceMap.get(id);if(!sourceMap.has(property))return;const tmpValueObj=sourceMap.get(property);const used=tmpValueObj.used;const value=tmpValueObj.value;if(used)adapter._SetterAbsolute(value);
sourceMap.delete(property);if(sourceMap.size===0)instanceMap.delete(id);if(instanceMap.size===0)TMP_ABSOLUTE_VALUES_MAP.delete(instance)})}_MaybeEnsureValue(time,start,end,setTime,lastValue,currentValue){const adapter=this._numericInterpolationAdapter;if(setTime)return;if(start&&time===start.GetTime())adapter._AddDelta(start.GetValueWithResultMode(),start,end);else if(end&&time===end.GetTime())adapter._AddDelta(end.GetValueWithResultMode(),start,end);else if(currentValue-lastValue===0)adapter._AddDelta(start.GetValueWithResultMode(),
start,end)}}C3.PropertyTrackState.PropertyInterpolationAdapter.NumericInterpolationAdapterForTimeline=NumericInterpolationAdapterForTimeline};


// c3/timelines/state/propertyInterpolationAdapters/numericInterpolationAdapterForTween.js
'use strict';{const C3=self.C3;const TMP_ABSOLUTE_VALUES_MAP=new Map;class NumericInterpolationAdapterForTween{constructor(numericInterpolationAdapter){this._numericInterpolationAdapter=numericInterpolationAdapter}Release(){this._numericInterpolationAdapter=null}SetInitialState(){const adapter=this._numericInterpolationAdapter;adapter.SetFirstAbsoluteUpdate(true);return this._GetAbsoluteInitialValue(adapter._FirstKeyframeGetter())}SetResumeState(){const adapter=this._numericInterpolationAdapter;if(adapter._FirstKeyframeGetter()===
adapter._CurrentKeyframeGetter())return;adapter.SetFirstAbsoluteUpdate(true);return this._GetAbsoluteInitialValue(adapter._CurrentKeyframeGetter())}BeforeChangeProperty(){}ChangeProperty(time,value,start,end,setTime,ensureValue){const adapter=this._numericInterpolationAdapter;const lastValue=adapter.GetLastValue();adapter._PickResultMode(()=>{adapter._Setter(value-lastValue,start,end);if(ensureValue)this._MaybeEnsureValue(time,start,end,setTime,lastValue,value)},()=>{adapter._PickFirstAbsoluteUpdate(()=>
{adapter._Setter(lastValue,start,end)},()=>{adapter._Setter(value-lastValue,start,end);if(ensureValue)this._MaybeEnsureValue(time,start,end,setTime,lastValue,value)})});adapter.SetLastValue(value);return adapter._PickSource(()=>{},()=>C3.TimelineState.LAYOUT_RENDER_CHANGE,()=>{},()=>C3.TimelineState.LAYOUT_RENDER_CHANGE,()=>C3.TimelineState.LAYOUT_RENDER_CHANGE)}AfterChangeProperty(){}_GetAbsoluteInitialValue(keyframeValue){const adapter=this._numericInterpolationAdapter;return keyframeValue-adapter.GetCurrentState()}_MaybeEnsureValue(time,
start,end,setTime,lastValue,currentValue){const adapter=this._numericInterpolationAdapter;if(setTime)if(start&&time===start.GetTime())adapter._AddDelta(start.GetValueWithResultMode(),start,end);else if(end&&time===end.GetTime())adapter._AddDelta(end.GetValueWithResultMode(),start,end);else{if(!end)adapter._AddDelta(start.GetValueWithResultMode(),start,end)}else if(start&&time===start.GetTime())adapter._AddDelta(start.GetValueWithResultMode(),start,end);else if(end&&time===end.GetTime())adapter._AddDelta(end.GetValueWithResultMode(),
start,end);else if(currentValue-lastValue===0)adapter._AddDelta(start.GetValueWithResultMode(),start,end)}}C3.PropertyTrackState.PropertyInterpolationAdapter.NumericInterpolationAdapterForTween=NumericInterpolationAdapterForTween};


// c3/timelines/state/propertyTypeAdapters/numericTypeAdapter.js
'use strict';{const C3=self.C3;const Ease=self.Ease;C3.PropertyTrackState.NumericTypeAdapter=class NumericTypeAdapter{constructor(){}static WillChange(index,source,newValue,type){let oldValue;switch(type){case "behavior":oldValue=source.GetPropertyValueByIndex(index);break;case "effect":oldValue=source[index];break;case "instance-variable":oldValue=source.GetInstanceVariableValue(index);break;case "plugin":oldValue=source.GetPropertyValueByIndex(index);break}if(oldValue===newValue)return false;return true}static Interpolate(time,
start,end,propertyTrack){if(!end){let propertyTrackDataItem=propertyTrack.GetPropertyTrackDataItem();const propertyTrackData=propertyTrack.GetPropertyTrackData();propertyTrackDataItem=propertyTrackData.GetLastPropertyKeyframeDataItem(propertyTrackDataItem);return propertyTrackDataItem.GetValueWithResultMode()}let mode=propertyTrack.GetInterpolationMode();if(mode==="default")mode="continuous";if(propertyTrack.GetPropertyType()==="combo")mode="discrete";if(mode==="discrete")return start.GetValueWithResultMode();
else if(mode==="continuous"||mode==="step"){if(mode==="step"){const step=propertyTrack.GetTimeline().GetStep();if(step!==0){const s=1/step;time=Math.floor(time*s)/s}}const st=start.GetTime();const et=end.GetTime();const sv=start.GetValueWithResultMode();const ev=end.GetValueWithResultMode();if(sv===ev)return sv;const n=C3.normalize(time,st,et);const e=start.GetEase();let ret;const startAddon=start.GetAddOn("cubic-bezier");const endAddon=end.GetAddOn("cubic-bezier");if(startAddon&&startAddon.GetStartEnable()&&
endAddon&&endAddon.GetEndEnable()){const dt=et-st;ret=Ease.GetRuntimeEase(e)(dt*n,0,1,dt);ret=Ease.GetRuntimeEase("cubicbezier")(ret,sv,sv+startAddon.GetStartAnchor(),ev+endAddon.GetEndAnchor(),ev)}else ret=Ease.GetRuntimeEase(e)((et-st)*n,sv,ev-sv,et-st);if(propertyTrack.GetPropertyType()==="integer")return Math.floor(ret);return ret}}}};


// c3/timelines/state/propertyTypeAdapters/angleTypeAdapter.js
'use strict';{const C3=self.C3;C3.PropertyTrackState.AngleTypeAdapter=class AngleTypeAdapter{constructor(){}static WillChange(index,source,newValue,type){let oldValue;switch(type){case "behavior":oldValue=source.GetPropertyValueByIndex(index);break;case "effect":oldValue=source[index];break;case "instance-variable":oldValue=source.GetInstanceVariableValue(index);break;case "plugin":oldValue=source.GetPropertyValueByIndex(index);break}if(oldValue===newValue)return false;return true}static Interpolate(time,
start,end,propertyTrack){if(!end){let propertyTrackDataItem=propertyTrack.GetPropertyTrackDataItem();const propertyTrackData=propertyTrack.GetPropertyTrackData();propertyTrackDataItem=propertyTrackData.GetLastPropertyKeyframeDataItem(propertyTrackDataItem);return propertyTrackDataItem.GetValueWithResultMode()}let mode=propertyTrack.GetInterpolationMode();if(mode==="default")mode="continuous";if(propertyTrack.GetPropertyType()==="combo")mode="discrete";if(mode==="discrete")return start.GetValueWithResultMode();
else if(mode==="continuous"||mode==="step"){if(mode==="step"){const step=propertyTrack.GetTimeline().GetStep();if(step!==0){const s=1/step;time=Math.floor(time*s)/s}}const st=start.GetTime();const et=end.GetTime();const sv=start.GetValueWithResultMode();const ev=end.GetValueWithResultMode();const angleAddon=start.GetAddOn("angle");if(angleAddon){const revolutions=angleAddon.GetRevolutions();if(sv===ev&&revolutions===0)return sv;const n=C3.normalize(time,st,et);const easeFunc=self.Ease.GetRuntimeEase(start.GetEase());
const easeRes=easeFunc(n,0,1,1);switch(angleAddon.GetDirection()){case "closest":return C3.angleLerp(sv,ev,easeRes,revolutions);case "clockwise":return C3.angleLerpClockwise(sv,ev,easeRes,revolutions);case "anti-clockwise":return C3.angleLerpAntiClockwise(sv,ev,easeRes,revolutions)}}else{if(sv===ev)return sv;const n=C3.normalize(time,st,et);const easeFunc=self.Ease.GetRuntimeEase(start.GetEase());return C3.angleLerp(sv,ev,easeFunc(n,0,1,1))}}}}};


// c3/timelines/state/propertyTypeAdapters/booleanTypeAdapter.js
'use strict';{const C3=self.C3;C3.PropertyTrackState.BooleanTypeAdapter=class BooleanTypeAdapter{constructor(){}static WillChange(index,source,newValue,type){let oldValue;switch(type){case "behavior":oldValue=source.GetPropertyValueByIndex(index);break;case "effect":oldValue=source[index];break;case "instance-variable":oldValue=source.GetInstanceVariableValue(index);break;case "plugin":oldValue=source.GetPropertyValueByIndex(index);break}if(!!oldValue===!!newValue)return false;return true}static Interpolate(time,
start,end,propertyTrack){if(!end){let propertyTrackDataItem=propertyTrack.GetPropertyTrackDataItem();const propertyTrackData=propertyTrack.GetPropertyTrackData();propertyTrackDataItem=propertyTrackData.GetLastPropertyKeyframeDataItem(propertyTrackDataItem);return propertyTrackDataItem.GetValueWithResultMode()?1:0}return start.GetValueWithResultMode()?1:0}}};


// c3/timelines/state/propertyTypeAdapters/colorTypeAdapter.js
'use strict';{const C3=self.C3;const TEMP_COLOR_ARRAY=[0,0,0];const TEMP_COLOR_ARRAY_2=[0,0,0];const TEMP_COLOR_ARRAY_3=[0,0,0];C3.PropertyTrackState.ColorTypeAdapter=class ColorTypeAdapter{constructor(){}static WillChange(index,source,newValue,type){let oldValue;switch(type){case "behavior":oldValue=source.GetPropertyValueByIndex(index);break;case "effect":oldValue=source[index];break;case "instance-variable":oldValue=source.GetInstanceVariableValue(index);break;case "plugin":oldValue=source.GetPropertyValueByIndex(index);
break}if(Array.isArray(newValue)){TEMP_COLOR_ARRAY[0]=newValue[0];TEMP_COLOR_ARRAY[1]=newValue[1];TEMP_COLOR_ARRAY[2]=newValue[2]}else{TEMP_COLOR_ARRAY_3.parseCommaSeparatedRgb(newValue);TEMP_COLOR_ARRAY[0]=Math.floor(TEMP_COLOR_ARRAY_3.getR()*255);TEMP_COLOR_ARRAY[1]=Math.floor(TEMP_COLOR_ARRAY_3.getG()*255);TEMP_COLOR_ARRAY[2]=Math.floor(TEMP_COLOR_ARRAY_3.getB()*255)}if(Array.isArray(oldValue)){TEMP_COLOR_ARRAY_2[0]=oldValue[0];TEMP_COLOR_ARRAY_2[1]=oldValue[1];TEMP_COLOR_ARRAY_2[2]=oldValue[2]}else{TEMP_COLOR_ARRAY_3.parseCommaSeparatedRgb(oldValue);
TEMP_COLOR_ARRAY_2[0]=Math.floor(TEMP_COLOR_ARRAY_3.getR()*255);TEMP_COLOR_ARRAY_2[1]=Math.floor(TEMP_COLOR_ARRAY_3.getG()*255);TEMP_COLOR_ARRAY_2[2]=Math.floor(TEMP_COLOR_ARRAY_3.getB()*255)}if(TEMP_COLOR_ARRAY[0]!==TEMP_COLOR_ARRAY_2[0])return true;if(TEMP_COLOR_ARRAY[1]!==TEMP_COLOR_ARRAY_2[1])return true;if(TEMP_COLOR_ARRAY[2]!==TEMP_COLOR_ARRAY_2[2])return true;return false}static Interpolate(time,start,end,propertyTrack){if(!end){let propertyTrackDataItem=propertyTrack.GetPropertyTrackDataItem();
const propertyTrackData=propertyTrack.GetPropertyTrackData();propertyTrackDataItem=propertyTrackData.GetLastPropertyKeyframeDataItem(propertyTrackDataItem);const color=propertyTrackDataItem.GetValueWithResultMode();TEMP_COLOR_ARRAY[0]=color[0];TEMP_COLOR_ARRAY[1]=color[1];TEMP_COLOR_ARRAY[2]=color[2];return TEMP_COLOR_ARRAY}let mode=propertyTrack.GetInterpolationMode();if(mode==="default")mode="continuous";if(mode==="discrete"){const color=start.GetValueWithResultMode();TEMP_COLOR_ARRAY[0]=color[0];
TEMP_COLOR_ARRAY[1]=color[1];TEMP_COLOR_ARRAY[2]=color[2];return TEMP_COLOR_ARRAY}else if(mode==="continuous"||mode==="step"){if(mode==="step"){const step=propertyTrack.GetTimeline().GetStep();if(step!==0){const s=1/step;time=Math.floor(time*s)/s}}const st=start.GetTime();const et=end.GetTime();const sv=start.GetValueWithResultMode();const ev=end.GetValueWithResultMode();const n=C3.normalize(time,st,et);const e=start.GetEase();const sr=sv[0];const sg=sv[1];const sb=sv[2];const er=ev[0];const eg=ev[1];
const eb=ev[2];const easeFunc=self.Ease.GetRuntimeEase(e);const d=et-st;const dn=d*n;if(sr===er)TEMP_COLOR_ARRAY[0]=sr;else TEMP_COLOR_ARRAY[0]=easeFunc(dn,sr,er-sr,d);if(sg===eg)TEMP_COLOR_ARRAY[1]=sg;else TEMP_COLOR_ARRAY[1]=easeFunc(dn,sg,eg-sg,d);if(sb===eb)TEMP_COLOR_ARRAY[2]=sb;else TEMP_COLOR_ARRAY[2]=easeFunc(dn,sb,eb-sb,d);return TEMP_COLOR_ARRAY}}}};


// c3/timelines/state/propertyTypeAdapters/textTypeAdapter.js
'use strict';{const C3=self.C3;C3.PropertyTrackState.TextTypeAdapter=class TextTypeAdapter{constructor(){}static WillChange(index,source,newValue,type){let oldValue;switch(type){case "behavior":oldValue=source.GetPropertyValueByIndex(index);break;case "effect":oldValue=source[index];break;case "instance-variable":oldValue=source.GetInstanceVariableValue(index);break;case "plugin":oldValue=source.GetPropertyValueByIndex(index);break}if(oldValue===newValue)return false;return true}static Interpolate(time,
start,end,propertyTrack){if(!end){let propertyTrackDataItem=propertyTrack.GetPropertyTrackDataItem();const propertyTrackData=propertyTrack.GetPropertyTrackData();propertyTrackDataItem=propertyTrackData.GetLastPropertyKeyframeDataItem(propertyTrackDataItem);return propertyTrackDataItem.GetValueWithResultMode()}return start.GetValueWithResultMode()}}};


// c3/timelines/data/timelineDataManager.js
'use strict';{const C3=self.C3;C3.TimelineDataManager=class TimelineDataManager{constructor(){this._timelineDataItems=new Map}Release(){for(const timelineDataItem of this._timelineDataItems.values())timelineDataItem.Release();this._timelineDataItems.clear();this._timelineDataItems=null}Add(data){const timelineDataItem=new C3.TimelineDataItem(data);const name=timelineDataItem.GetName();this._timelineDataItems.set(name,timelineDataItem)}Get(name){return this._timelineDataItems.get(name)}GetNameId(){return 0}static _CreateDataItems(items,
jsonItems,dataItemConstructor,dataContainer){if(!jsonItems)return;for(const jsonItem of jsonItems)C3.TimelineDataManager._CreateDataItem("create",jsonItem,items,dataItemConstructor,dataContainer)}static _LoadDataItemsFromJson(items,jsonItems,dataItemConstructor,dataContainer){if(items.length)jsonItems.forEach((jsonItem,index)=>{items[index]._LoadFromJson(jsonItem)});else jsonItems.forEach(jsonItem=>{C3.TimelineDataManager._CreateDataItem("load",jsonItem,items,dataItemConstructor,dataContainer)})}static _CreateDataItem(mode,
json,items,dataItemConstructor,dataContainer){let dataItem;if(typeof dataItemConstructor==="function")switch(mode){case "load":dataItem=new dataItemConstructor(null,dataContainer);break;case "create":dataItem=new dataItemConstructor(json,dataContainer);break}else if(typeof dataItemConstructor==="object"){const prop=dataItemConstructor.prop;const value=json[prop];const cnstrctr=dataItemConstructor.map.get(value);switch(mode){case "load":dataItem=new cnstrctr(null,dataContainer);break;case "create":dataItem=
new cnstrctr(json,dataContainer);break}}switch(mode){case "load":dataItem._LoadFromJson(json);items.push(dataItem);break;case "create":if(typeof dataItem.GetEnable==="function"&&!dataItem.GetEnable())return dataItem.Release();items.push(dataItem);break}}}};


// c3/timelines/data/timelineData.js
'use strict';{const C3=self.C3;const NAME=0;const TOTAL_TIME=1;const STEP=2;const INTERPOLATION_MODE=3;const RESULT_MODE=4;const TRACKS=5;const LOOP=6;const PING_PONG=7;const REPEAT_COUNT=8;C3.TimelineDataItem=class TimelineDataItem{constructor(timelineDataJson){this._name="";this._totalTime=NaN;this._step=0;this._interpolationMode="default";this._resultMode="default";this._loop=false;this._pingPong=false;this._repeatCount=1;this._trackData=null;if(!timelineDataJson)return;this._name=timelineDataJson[NAME];
this._totalTime=timelineDataJson[TOTAL_TIME];this._step=timelineDataJson[STEP];this._interpolationMode=timelineDataJson[INTERPOLATION_MODE];this._resultMode=timelineDataJson[RESULT_MODE];this._loop=!!timelineDataJson[LOOP];this._pingPong=!!timelineDataJson[PING_PONG];this._repeatCount=timelineDataJson[REPEAT_COUNT];this._trackData=new C3.TrackData(timelineDataJson[TRACKS],this)}Release(){this._trackData.Release();this._trackData=null}GetTrackData(){if(!this._trackData)this._trackData=new C3.TrackData(null,
this);return this._trackData}GetName(){return this._name}SetName(n){this._name=n}GetTotalTime(){return this._totalTime}SetTotalTime(tt){this._totalTime=tt}GetStep(){return this._step}SetStep(s){this._step=s}GetInterpolationMode(){return this._interpolationMode}SetInterpolationMode(im){this._interpolationMode=im}GetResultMode(){return this._resultMode}SetResultMode(rm){this._resultMode=rm}GetLoop(){return this._loop}SetLoop(l){this._loop=l}GetPingPong(){return this._pingPong}SetPingPong(p){this._pingPong=
p}GetRepeatCount(){return this._repeatCount}_SaveToJson(){return{"trackDataJson":this._trackData._SaveToJson(),"name":this._name,"totalTime":this._totalTime,"step":this._step,"interpolationMode":this._interpolationMode,"resultMode":this._resultMode,"loop":this._loop,"pingPong":this._pingPong,"repeatCount":this._repeatCount}}_LoadFromJson(o){if(!o)return;this.GetTrackData()._LoadFromJson(o["trackDataJson"]);this._name=o["name"];this._totalTime=o["totalTime"];this._step=o["step"];this._interpolationMode=
o["interpolationMode"];this._resultMode=o["resultMode"];this._loop=o["loop"];this._pingPong=o["pingPong"];this._repeatCount=o["repeatCount"]}}};


// c3/timelines/data/trackData.js
'use strict';{const C3=self.C3;const WI_DATA=0;const OC_INDEX=1;const WI_UID=2;const INTERPOLATION_MODE=1;const RESULT_MODE=2;const ENABLED=3;const KEYFRAMES=4;const PROPERTY_TRACKS=5;const ID=6;const NESTED_DATA=7;const START_OFFSET=0;const LOCAL_TOTAL_TIME=1;const WI_ADDITIONAL_DATA=8;const ORIGINAL_WIDTH=0;const ORIGINAL_HEIGHT=1;class TrackDataItem{constructor(trackDataJson,trackData){this._trackData=trackData;this._instanceData=null;this._additionalInstanceData=null;this._instanceUid=NaN;this._objectClassIndex=
NaN;this._interpolationMode="default";this._resultMode="default";this._enabled=false;this._keyframeData=null;this._propertyTrackData=null;this._id="";this._nestedData=null;this._startOffset=0;this._localTotalTime=this._trackData.GetTimelineDataItem().GetTotalTime();if(!trackDataJson)return;this._instanceData=trackDataJson[WI_DATA];this._instanceUid=trackDataJson[WI_DATA][WI_UID];this._objectClassIndex=trackDataJson[WI_DATA][OC_INDEX];this._interpolationMode=trackDataJson[INTERPOLATION_MODE];this._resultMode=
trackDataJson[RESULT_MODE];this._enabled=!!trackDataJson[ENABLED];if(trackDataJson[ID])this._id=trackDataJson[ID];if(trackDataJson[NESTED_DATA]){this._nestedData=trackDataJson[NESTED_DATA];this._startOffset=trackDataJson[NESTED_DATA][START_OFFSET];this._localTotalTime=trackDataJson[NESTED_DATA][LOCAL_TOTAL_TIME]}if(trackDataJson[WI_ADDITIONAL_DATA])this._additionalInstanceData=trackDataJson[WI_ADDITIONAL_DATA];this._keyframeData=new C3.KeyframeData(trackDataJson[KEYFRAMES],this);this._propertyTrackData=
new C3.PropertyTrackData(trackDataJson[PROPERTY_TRACKS],this)}Release(){this._instanceData=null;this._trackData=null;if(this._keyframeData){this._keyframeData.Release();this._keyframeData=null}if(this._propertyTrackData){this._propertyTrackData.Release();this._propertyTrackData=null}this._nestedData=null}GetTrackData(){return this._trackData}GetKeyframeData(){if(!this._keyframeData)this._keyframeData=new C3.KeyframeData(null,this);return this._keyframeData}GetPropertyTrackData(){if(!this._propertyTrackData)this._propertyTrackData=
new C3.PropertyTrackData(null,this);return this._propertyTrackData}GetInstanceData(){return this._instanceData}GetObjectClassIndex(){return this._objectClassIndex}SetObjectClassIndex(index){this._objectClassIndex=index}GetInstanceUID(){return this._instanceUid}SetInstanceUID(uid){this._instanceUid=uid}GetInterpolationMode(){return this._interpolationMode}SetInterpolationMode(im){this._interpolationMode=im}GetResultMode(){return this._resultMode}SetResultMode(rm){this._resultMode=rm}GetEnable(){return this._enabled}SetEnable(e){this._enabled=
!!e}GetId(){return this._id}GetStartOffset(){return this._startOffset}GetLocalTotalTime(){return this._localTotalTime}SetLocalTotalTime(t){this._localTotalTime=t}GetOriginalWidth(){return this._additionalInstanceData[ORIGINAL_WIDTH]}SetOriginalWidth(w){if(!this._additionalInstanceData)this._additionalInstanceData=[];this._additionalInstanceData[ORIGINAL_WIDTH]=w}GetOriginalHeight(){if(!this._additionalInstanceData)this._additionalInstanceData=[];return this._additionalInstanceData[ORIGINAL_HEIGHT]}SetOriginalHeight(h){if(!this._additionalInstanceData)this._additionalInstanceData=
[];this._additionalInstanceData[ORIGINAL_HEIGHT]=h}_SaveToJson(){return{"keyframeDataJson":this._keyframeData._SaveToJson(),"propertyTrackDataJson":this._propertyTrackData._SaveToJson(),"instanceData":this._instanceData,"additionalInstanceData":this._additionalInstanceData,"instanceUid":this._instanceUid,"objectClassIndex":this._objectClassIndex,"interpolationMode":this._interpolationMode,"resultMode":this._resultMode,"enabled":this._enabled,"id":this._id,"nestedData":this._nestedData}}_LoadFromJson(o){if(!o)return;
this._instanceData=o["instanceData"];this._instanceUid=o["instanceUid"];this._objectClassIndex=o["objectClassIndex"];this._interpolationMode=o["interpolationMode"];this._resultMode=o["resultMode"];this._enabled=o["enabled"];this._id=o["id"];this._localTotalTime=this._trackData.GetTimelineDataItem().GetTotalTime();if(o["nestedData"]){this._nestedData=o["nestedData"];this._startOffset=this._nestedData[START_OFFSET];this._localTotalTime=this._nestedData[LOCAL_TOTAL_TIME]}if(o["additionalInstanceData"])this._additionalInstanceData=
o["additionalInstanceData"];this.GetKeyframeData()._LoadFromJson(o["keyframeDataJson"]);this.GetPropertyTrackData()._LoadFromJson(o["propertyTrackDataJson"])}}C3.TrackData=class TrackData{constructor(tracksDataJson,timelineDataItem){this._timelineDataItem=timelineDataItem;this._trackDataItems=[];this._keyframeTimeMap=new Map;C3.TimelineDataManager._CreateDataItems(this._trackDataItems,tracksDataJson,TrackDataItem,this)}Release(){this._timelineDataItem=null;for(const trackDataItem of this._trackDataItems)trackDataItem.Release();
C3.clearArray(this._trackDataItems);this._trackDataItems=null;this._keyframeTimeMap.clear();this._keyframeTimeMap=null}GetTimelineDataItem(){return this._timelineDataItem}AddEmptyTrackDataItem(){const trackDataItem=new TrackDataItem(null,this);this._trackDataItems.push(trackDataItem);return trackDataItem}GetFirstKeyframeDataItem(trackDataItem){return trackDataItem.GetKeyframeData().GetKeyframeDataItemArray()[0]}GetLastKeyframeDataItem(trackDataItem){const keyframeDataItems=trackDataItem.GetKeyframeData().GetKeyframeDataItemArray();
return keyframeDataItems[keyframeDataItems.length-1]}GetKeyFrameDataItemAtTime(time,trackDataItem){const keyframeDataItemEntry=this._keyframeTimeMap.get(trackDataItem);if(!!keyframeDataItemEntry&&keyframeDataItemEntry.has(time))return keyframeDataItemEntry.get(time);for(const keyframeDataItem of trackDataItem.GetKeyframeData().keyframeDataItems())if(keyframeDataItem.GetTime()===time){if(!keyframeDataItemEntry)this._keyframeTimeMap.set(trackDataItem,new Map);this._keyframeTimeMap.get(trackDataItem).set(time,
keyframeDataItem);return keyframeDataItem}}GetFirstKeyFrameDataItemHigherThan(time,trackDataItem){for(const keyframeDataItem of trackDataItem.GetKeyframeData().keyframeDataItems())if(keyframeDataItem.GetTime()>time)return keyframeDataItem}GetFirstKeyFrameDataItemHigherOrEqualThan(time,trackDataItem){for(const keyframeDataItem of trackDataItem.GetKeyframeData().keyframeDataItems())if(keyframeDataItem.GetTime()>=time)return keyframeDataItem}GetFirstKeyFrameDataItemLowerOrEqualThan(time,trackDataItem){for(const keyframeDataItem of trackDataItem.GetKeyframeData().keyframeDataItemsReverse())if(keyframeDataItem.GetTime()<=
time)return keyframeDataItem}*trackDataItems(){for(const trackDataItem of this._trackDataItems)yield trackDataItem}_SaveToJson(){return{"trackDataItemsJson":this._trackDataItems.map(trackDataItem=>trackDataItem._SaveToJson())}}_LoadFromJson(o){if(!o)return;C3.TimelineDataManager._LoadDataItemsFromJson(this._trackDataItems,o["trackDataItemsJson"],TrackDataItem,this)}}};


// c3/timelines/data/propertyTrackData.js
'use strict';{const C3=self.C3;const SOURCE_DATA=0;const SOURCE=0;const PROPERTY=1;const TYPE=2;const MIN=3;const MAX=4;const INTERPOLATION_MODE=5;const RESULT_MODE=6;const ENABLED=7;const PROPERTY_KEYFRAMES=8;class PropertyTrackDataItem{constructor(propertyTrackDataJson,propertyTrackData){this._propertyTrackData=propertyTrackData;this._sourceAdapterId="";this._sourceAdapterArguments=null;this._property=null;this._type=null;this._min=NaN;this._max=NaN;this._interpolationMode="default";this._resultMode=
"default";this._enabled=false;this._propertyKeyframeData=null;if(!propertyTrackDataJson)return;this._sourceAdapterId=propertyTrackDataJson[SOURCE_DATA][SOURCE];this._sourceAdapterArguments=propertyTrackDataJson[SOURCE_DATA].slice(1);this._property=propertyTrackDataJson[PROPERTY];this._type=propertyTrackDataJson[TYPE];this._min=propertyTrackDataJson[MIN];this._max=propertyTrackDataJson[MAX];this._interpolationMode=propertyTrackDataJson[INTERPOLATION_MODE];this._resultMode=propertyTrackDataJson[RESULT_MODE];
this._enabled=!!propertyTrackDataJson[ENABLED];this._propertyKeyframeData=new C3.PropertyKeyframeData(propertyTrackDataJson[PROPERTY_KEYFRAMES],this)}Release(){this._propertyKeyframeData.Release();this._propertyKeyframeData=null;this._propertyTrackData=null;this._sourceAdapterArguments=null}GetPropertyTrackData(){return this._propertyTrackData}GetPropertyKeyframeData(){if(!this._propertyKeyframeData)this._propertyKeyframeData=new C3.PropertyKeyframeData(null,this);return this._propertyKeyframeData}GetSourceAdapterId(){return this._sourceAdapterId}SetSourceAdapterId(said){this._sourceAdapterId=
said}GetSourceAdapterArguments(){return this._sourceAdapterArguments}SetSourceAdapterArguments(sargs){this._sourceAdapterArguments=sargs}GetProperty(){return this._property}SetProperty(p){this._property=p}GetType(){return this._type}SetType(t){this._type=t}GetMin(){return this._min}SetMin(min){this._min=min}GetMax(){return this._max}SetMax(max){this._max=max}GetInterpolationMode(){return this._interpolationMode}SetInterpolationMode(im){this._interpolationMode=im}GetResultMode(){return this._resultMode}SetResultMode(rm){this._resultMode=
rm}GetEnable(){return this._enabled}SetEnable(e){this._enabled=!!e}_SaveToJson(){return{"propertyKeyframeDataJson":this._propertyKeyframeData._SaveToJson(),"sourceAdapterId":this._sourceAdapterId,"sourceAdapterArguments":this._sourceAdapterArguments,"property":this._property,"type":this._type,"min":this._min,"max":this._max,"interpolationMode":this._interpolationMode,"resultMode":this._resultMode,"enabled":this._enabled}}_LoadFromJson(o){if(!o)return;this._sourceAdapterId=o["sourceAdapterId"];this._sourceAdapterArguments=
o["sourceAdapterArguments"];this._property=o["property"];this._type=o["type"];this._min=o["min"];this._max=o["max"];this._interpolationMode=o["interpolationMode"];this._resultMode=o["resultMode"];this._enabled=o["enabled"];this.GetPropertyKeyframeData()._LoadFromJson(o["propertyKeyframeDataJson"])}}C3.PropertyTrackData=class PropertyTrackData{constructor(propertyTracksDataJson,trackDataItem){this._trackDataItem=trackDataItem;this._propertyTrackDataItems=[];this._propertyKeyframeTimeMap=new Map;C3.TimelineDataManager._CreateDataItems(this._propertyTrackDataItems,
propertyTracksDataJson,PropertyTrackDataItem,this)}Release(){this._trackDataItem=null;for(const propertyTrackDataItem of this._propertyTrackDataItems)propertyTrackDataItem.Release();C3.clearArray(this._propertyTrackDataItems);this._propertyTrackDataItems=null;this._propertyKeyframeTimeMap.clear();this._propertyKeyframeTimeMap=null}GetTrackDataItem(){return this._trackDataItem}AddEmptyPropertyTrackDataItem(){const propertyTrackDataItem=new PropertyTrackDataItem(null,this);this._propertyTrackDataItems.push(propertyTrackDataItem);
return propertyTrackDataItem}GetFirstPropertyKeyframeDataItem(propertyTrackDataItem){const propertyKeyframeData=propertyTrackDataItem.GetPropertyKeyframeData();return propertyKeyframeData.GetPropertyKeyframeDataItemArray()[0]}GetLastPropertyKeyframeDataItem(propertyTrackDataItem){const propertyKeyframeData=propertyTrackDataItem.GetPropertyKeyframeData();const propertyKeyframeDataItems=propertyKeyframeData.GetPropertyKeyframeDataItemArray();return propertyKeyframeDataItems[propertyKeyframeDataItems.length-
1]}GetPropertyKeyFrameDataItemAtTime(time,propertyTrackDataItem){const propertyKeyframeDataItemEntry=this._propertyKeyframeTimeMap.get(propertyTrackDataItem);if(!!propertyKeyframeDataItemEntry&&propertyKeyframeDataItemEntry.has(time))return propertyKeyframeDataItemEntry.get(time);const propertyKeyframeData=propertyTrackDataItem.GetPropertyKeyframeData();for(const propertyKeyframeDataItem of propertyKeyframeData.propertyKeyframeDataItems())if(propertyKeyframeDataItem.GetTime()===time){if(!propertyKeyframeDataItemEntry)this._propertyKeyframeTimeMap.set(propertyTrackDataItem,
new Map);this._propertyKeyframeTimeMap.get(propertyTrackDataItem).set(time,propertyKeyframeDataItem);return propertyKeyframeDataItem}}GetFirstPropertyKeyFrameDataItemHigherThan(time,propertyTrackDataItem){const propertyKeyframeData=propertyTrackDataItem.GetPropertyKeyframeData();for(const propertyKeyframeDataItem of propertyKeyframeData.propertyKeyframeDataItems())if(propertyKeyframeDataItem.GetTime()>time)return propertyKeyframeDataItem}GetFirstPropertyKeyFrameDataItemHigherOrEqualThan(time,propertyTrackDataItem){const propertyKeyframeData=
propertyTrackDataItem.GetPropertyKeyframeData();for(const propertyKeyframeDataItem of propertyKeyframeData.propertyKeyframeDataItems())if(propertyKeyframeDataItem.GetTime()>=time)return propertyKeyframeDataItem}GetFirstPropertyKeyFrameDataItemLowerOrEqualThan(time,propertyTrackDataItem){const propertyKeyframeData=propertyTrackDataItem.GetPropertyKeyframeData();for(const propertyKeyframeDataItem of propertyKeyframeData.propertyKeyframeDataItemsReverse())if(propertyKeyframeDataItem.GetTime()<=time)return propertyKeyframeDataItem}*propertyTrackDataItems(){for(const propertyTrackDataItem of this._propertyTrackDataItems)yield propertyTrackDataItem}_SaveToJson(){return{"propertyTrackDataItemsJson":this._propertyTrackDataItems.map(propertyTrackDataItem=>
propertyTrackDataItem._SaveToJson())}}_LoadFromJson(o){if(!o)return;C3.TimelineDataManager._LoadDataItemsFromJson(this._propertyTrackDataItems,o["propertyTrackDataItemsJson"],PropertyTrackDataItem,this)}}};


// c3/timelines/data/keyframeData.js
'use strict';{const C3=self.C3;const TIME=0;const EASE=1;const ENABLE=2;const TAGS=3;class KeyframeDataItem{constructor(keyframeDataJson,keyframeData){this._keyframeData=keyframeData;this._time=-1;this._ease="noease";this._enable=false;this._tags=null;this._lowerTags=null;if(!keyframeDataJson)return;this._time=keyframeDataJson[TIME];this._ease=keyframeDataJson[EASE];this._enable=!!keyframeDataJson[ENABLE];const tagStr=keyframeDataJson[TAGS];this._tags=tagStr?tagStr.split(" "):[];this._lowerTags=new Set(this._tags.map(t=>
t.toLowerCase()))}Release(){this._keyframeData=null;C3.clearArray(this._tags);this._tags=null;this._lowerTags.clear();this._lowerTags=null}GetKeyframeData(){return this._keyframeData}GetTime(){return this._time}SetTime(t){this._time=t}GetEase(){return this._ease}SetEase(e){this._ease=e}GetEnable(){return this._enable}SetEnable(e){this._enable=!!e}GetTags(){return this._tags}SetTags(t){this._tags=t?t.split(" "):[];this._lowerTags=new Set(this._tags.map(t=>t.toLowerCase()))}GetLowerTags(){return this._lowerTags}HasTag(tag){return this._lowerTags.has(tag.toLowerCase())}_SaveToJson(){return{"time":this._time,
"ease":this._ease,"enable":this._enable,"tags":this._tags}}_LoadFromJson(o){if(!o)return;this._time=o["time"];this._ease=o["ease"];this._enable=o["enable"];this._tags=o["tags"];this._lowerTags=new Set(this._tags.map(t=>t.toLowerCase()))}}C3.KeyframeData=class KeyframeData{constructor(keyframesDataJson,trackDataItem){this._trackDataItem=trackDataItem;this._keyframeDataItems=[];C3.TimelineDataManager._CreateDataItems(this._keyframeDataItems,keyframesDataJson,KeyframeDataItem,this)}Release(){this._trackDataItem=
null;for(const keyframeDataItem of this._keyframeDataItems)keyframeDataItem.Release();C3.clearArray(this._keyframeDataItems);this._keyframeDataItems=null}GetTrackDataItem(){return this._trackDataItem}GetKeyframeDataItemCount(){return this._keyframeDataItems.length}GetKeyframeDataItemArray(){return this._keyframeDataItems}AddEmptyKeyframeDataItem(){const keyframeDataItem=new KeyframeDataItem(null,this);this._keyframeDataItems.push(keyframeDataItem);return keyframeDataItem}DeleteKeyframeDataItems(match){for(const keyframeDataItem of this._keyframeDataItems){if(!match(keyframeDataItem))continue;
const index=this._keyframeDataItems.indexOf(keyframeDataItem);if(index===-1)continue;keyframeDataItem.Release();this._keyframeDataItems.splice(index,1)}this.SortKeyframeDataItems()}SortKeyframeDataItems(){this._keyframeDataItems.sort((a,b)=>a.GetTime()-b.GetTime())}GetKeyframeDataItemIndex(keyframeDataItem){return this._keyframeDataItems.indexOf(keyframeDataItem)}GetKeyframeDataItemFromIndex(index){return this._keyframeDataItems[index]}*keyframeDataItems(){for(const keyframeDataItem of this._keyframeDataItems)yield keyframeDataItem}*keyframeDataItemsReverse(){for(let i=
this._keyframeDataItems.length-1;i>=0;i--)yield this._keyframeDataItems[i]}_SaveToJson(){return{"keyframeDataItemsJson":this._keyframeDataItems.map(keyframeDataItem=>keyframeDataItem._SaveToJson())}}_LoadFromJson(o){if(!o)return;C3.TimelineDataManager._LoadDataItemsFromJson(this._keyframeDataItems,o["keyframeDataItemsJson"],KeyframeDataItem,this)}}};


// c3/timelines/data/propertyKeyframeData.js
'use strict';{const C3=self.C3;const VALUE_DATA=0;const VALUE_DATA_VALUE=0;const VALUE_DATA_ABSOLUTE_VALUE=1;const VALUE_DATA_TYPE=2;const TIME=1;const EASE=2;const ENABLE=3;const ADDONS=4;class PropertyKeyframeDataItem{constructor(propertyKeyframeDataJson,propertyKeyframeData){this._propertyKeyframeData=propertyKeyframeData;this._value=null;this._aValue=null;this._type="";this._time=NaN;this._ease="noease";this._enable=false;this._addonData=null;if(!propertyKeyframeDataJson)return;this._value=propertyKeyframeDataJson[VALUE_DATA][VALUE_DATA_VALUE];
this._aValue=propertyKeyframeDataJson[VALUE_DATA][VALUE_DATA_ABSOLUTE_VALUE];this._type=propertyKeyframeDataJson[VALUE_DATA][VALUE_DATA_TYPE];this._time=propertyKeyframeDataJson[TIME];this._ease=propertyKeyframeDataJson[EASE];this._enable=!!propertyKeyframeDataJson[ENABLE];this._addonData=null;if(!!propertyKeyframeDataJson[ADDONS])this._addonData=new C3.AddonData(propertyKeyframeDataJson[ADDONS],this)}Release(){this._propertyKeyframeData=null;if(this._addonData){this._addonData.Release();this._addonData=
null}}GetAddonData(){return this._addonData}GetValue(){return this._value}SetValue(value){if(this._type==="color"&&C3.IsFiniteNumber(value)){this._value[0]=C3.GetRValue(value);this._value[1]=C3.GetGValue(value);this._value[2]=C3.GetBValue(value)}else this._value=value}GetAbsoluteValue(){return this._aValue}SetAbsoluteValue(aValue){if(this._type==="color"&&C3.IsFiniteNumber(aValue)){this._aValue[0]=C3.GetRValue(aValue);this._aValue[1]=C3.GetGValue(aValue);this._aValue[2]=C3.GetBValue(aValue)}else this._aValue=
aValue}GetValueWithResultMode(){const rm=this._propertyKeyframeData.GetPropertyTrackDataItem().GetResultMode();if(rm==="relative")return this.GetValue();else if(rm==="absolute")return this.GetAbsoluteValue()}GetType(){return this._type}SetType(t){this._type=t}GetTime(){return this._time}SetTime(t){this._time=t}GetEase(){return this._ease}SetEase(e){this._ease=e}GetEnable(){return this._enable}SetEnable(e){this._enable=!!e}GetAddOn(id){if(!this.GetAddonData())return;for(const addonDataItem of this.GetAddonData().addonDataItems())if(addonDataItem.GetId()===
id)return addonDataItem}_SaveToJson(){const aData=this._addonData;return{"addonDataJson":aData?aData._SaveToJson():aData,"value":this._value,"aValue":this._aValue,"type":this._type,"time":this._time,"ease":this._ease,"enable":this._enable}}_LoadFromJson(o){if(!o)return;if(o["addonDataJson"])this._addonData._SetFromJson(o["addonDataJson"]);this._value=o["value"];this._aValue=o["aValue"];this._type=o["type"];this._time=o["time"];this._ease=o["ease"];this._enable=o["enable"]}}C3.PropertyKeyframeData=
class PropertyKeyframeData{constructor(propertyKeyframesDataJson,propertyTrackDataItem){this._propertyTrackDataItem=propertyTrackDataItem;this._propertyKeyframeDataItems=[];C3.TimelineDataManager._CreateDataItems(this._propertyKeyframeDataItems,propertyKeyframesDataJson,PropertyKeyframeDataItem,this)}Release(){this._propertyTrackDataItem=null;for(const propertyKeyframeDataItem of this._propertyKeyframeDataItems)propertyKeyframeDataItem.Release();C3.clearArray(this._propertyKeyframeDataItems);this._propertyKeyframeDataItems=
null}AddEmptyPropertyKeyframeDataItem(){const propertyKeyframeDataItem=new PropertyKeyframeDataItem(null,this);this._propertyKeyframeDataItems.push(propertyKeyframeDataItem);return propertyKeyframeDataItem}DeletePropertyKeyframeDataItems(match){for(const propertyKeyframeDataItem of this._propertyKeyframeDataItems){if(!match(propertyKeyframeDataItem))continue;const index=this._propertyKeyframeDataItems.indexOf(propertyKeyframeDataItem);if(index===-1)continue;propertyKeyframeDataItem.Release();this._propertyKeyframeDataItems.splice(index,
1)}this.SortPropertyKeyFrameDataItems()}SortPropertyKeyFrameDataItems(){this._propertyKeyframeDataItems.sort((a,b)=>a.GetTime()-b.GetTime())}GetPropertyTrackDataItem(){return this._propertyTrackDataItem}GetPropertyKeyframeDataItemCount(){return this._propertyKeyframeDataItems.length}GetPropertyKeyframeDataItemArray(){return this._propertyKeyframeDataItems}*propertyKeyframeDataItems(){for(const propertyKeyframeDataItem of this._propertyKeyframeDataItems)yield propertyKeyframeDataItem}*propertyKeyframeDataItemsReverse(){for(let i=
this._propertyKeyframeDataItems.length-1;i>=0;i--)yield this._propertyKeyframeDataItems[i]}_SaveToJson(){return{"propertyKeyframeDataItemsJson":this._propertyKeyframeDataItems.map(propertyTrackDataItem=>propertyTrackDataItem._SaveToJson())}}_LoadFromJson(o){if(!o)return;C3.TimelineDataManager._LoadDataItemsFromJson(this._propertyKeyframeDataItems,o["propertyKeyframeDataItemsJson"],PropertyKeyframeDataItem,this)}}};


// c3/timelines/data/propertyKeyframeAddonData.js
'use strict';{const C3=self.C3;const ADDON_ID=0;const ADDON_DATA=1;class AddonDataItem{constructor(addonDataJson,addonData){this._addonData=addonData;this._id=addonDataJson[ADDON_ID];this._data=addonDataJson[ADDON_DATA]}Release(){this._addonData=null;this._data=null}GetAddonData(){return this._addonData}GetId(){return this._id}_SaveToJson(){return{"id":this._id,"data":this._data}}_LoadFromJson(o){if(!o)return;this._id=o["id"];this._data=o["data"]}}const START_ANCHOR=0;const START_ENABLE=1;const END_ANCHOR=
2;const END_ENABLE=3;class AddonDataCubicBezierItem extends AddonDataItem{constructor(addonDataJson,addonData){super(addonDataJson,addonData);this._startAnchor=this._data[START_ANCHOR];this._startEnable=!!this._data[START_ENABLE];this._endAnchor=this._data[END_ANCHOR];this._endEnable=!!this._data[END_ENABLE]}Release(){super.Release()}GetStartAnchor(){return this._startAnchor}GetStartEnable(){return this._startEnable}GetEndAnchor(){return this._endAnchor}GetEndEnable(){return this._endEnable}_SaveToJson(){return Object.assign(super._SaveToJson(),
{"startAnchor":this._startAnchor,"startEnable":!!this._startEnable,"endAnchor":this._endAnchor,"endEnable":!!this._endEnable})}_LoadFromJson(o){if(!o)return;super._LoadFromJson(o);this._startAnchor=o["startAnchor"];this._startEnable=!!o["startEnable"];this._endAnchor=o["endAnchor"];this._endEnable=!!o["endEnable"]}}const DIRECTION=0;const REVOLUTIONS=1;class AddonDataAngleItem extends AddonDataItem{constructor(addonDataJson,addonData){super(addonDataJson,addonData);this._direction=this._data[DIRECTION];
this._revolutions=this._data[REVOLUTIONS]}Release(){super.Release()}GetDirection(){return this._direction}GetRevolutions(){return this._revolutions}_SaveToJson(){return Object.assign(super._SaveToJson(),{"direction":this._direction,"revolutions":this._revolutions})}_LoadFromJson(o){if(!o)return;super._LoadFromJson(o);this._direction=o["direction"];this._revolutions=o["revolutions"]}}C3.AddonData=class AddonData{constructor(addonsDataJson,propertyKeyframeDataItem){this._propertyKeyframeDataItem=propertyKeyframeDataItem;
this._addonDataItems=[];C3.TimelineDataManager._CreateDataItems(this._addonDataItems,addonsDataJson,{prop:0,map:new Map([["cubic-bezier",AddonDataCubicBezierItem],["angle",AddonDataAngleItem]])},this)}Release(){this._propertyKeyframeDataItem=null;for(const addonDataItem of this._addonDataItems)addonDataItem.Release();C3.clearArray(this._addonDataItems);this._addonDataItems=null}GetPropertyKeyframeDataItem(){return this._propertyKeyframeDataItem}*addonDataItems(){for(const addonDataItem of this._addonDataItems)yield addonDataItem}_SaveToJson(){return{"addonDataItemsJson":this._addonDataItems.map(addonDataItem=>
addonDataItem._SaveToJson())}}_LoadFromJson(o){if(!o)return;C3.TimelineDataManager._LoadDataItemsFromJson(this._addonDataItems,o["addonDataItemsJson"],{prop:"id",map:new Map([["cubic-bezier",AddonDataCubicBezierItem],["angle",AddonDataAngleItem]])},this)}}};


// c3/timelines/tweens/tween.js
'use strict';{const C3=self.C3;const INITIAL_VALUE_MODE_START_VALUE="start-value";const INITIAL_VALUE_MODE_CURRENT_STATE="current-state";let createdTweens=0;C3.Tween=class Tween extends C3.TimelineState{constructor(tweenDataItem,timelineManager){super(`tween-${createdTweens++}`,tweenDataItem,timelineManager);this._id="";this._destroyInstanceOnComplete=false;this._initialValueMode=INITIAL_VALUE_MODE_START_VALUE;this._on_completed_callbacks=null;this._on_started_callbacks=null}GetInstance(){const tracks=
this.GetTracks();if(!tracks||!tracks.length)return;const track=tracks[0];if(!track)return;const instance=track.GetInstance();return track.IsInstanceValid()?instance:null}AddStartedCallback(c){if(!this._on_started_callbacks)this._on_started_callbacks=[];this._on_started_callbacks.push(c)}AddCompletedCallback(c){if(!this._on_completed_callbacks)this._on_completed_callbacks=[];this._on_completed_callbacks.push(c)}RemoveStartedCallback(c){if(!this._on_started_callbacks)return;const index=this._on_started_callbacks.indexOf(c);
if(index!==-1)this._on_started_callbacks.splice(index,1)}RemoveCompletedCallback(c){if(!this._on_completed_callbacks)return;const index=this._on_completed_callbacks.indexOf(c);if(index!==-1)this._on_completed_callbacks.splice(index,1)}SetStartValue(startValue,propertyName){for(const track of this._tracks)for(const propertyTrack of track._propertyTracks){if(propertyTrack.GetPropertyName()!==propertyName)continue;const propertyTrackData=propertyTrack.GetPropertyTrackData();const propertyTrackDataItem=
propertyTrack.GetPropertyTrackDataItem();const propertyKeyframeDataItem=propertyTrackData.GetFirstPropertyKeyframeDataItem(propertyTrackDataItem);propertyKeyframeDataItem.SetValue(startValue);propertyKeyframeDataItem.SetAbsoluteValue(startValue)}}_GetPropertyTrackState(propertyName){for(const track of this._tracks)for(const propertyTrack of track._propertyTracks)if(propertyTrack.GetPropertyName()===propertyName)return propertyTrack}BeforeSetEndValues(properties){for(const propertyName of properties){const propertyTrackState=
this._GetPropertyTrackState(propertyName);this.SetStartValue(propertyTrackState.GetCurrentState(),propertyName)}if(this.IsForwardPlayBack()){const newTotalTime=this.GetTotalTime()-this.GetTime();this.SetTotalTime(newTotalTime);for(const track of this._tracks)track.SetLocalTotalTime(newTotalTime);this._SetTime(0)}else{const newTotalTime=this.GetTime();this.SetTotalTime(newTotalTime);for(const track of this._tracks)track.SetLocalTotalTime(newTotalTime);this._SetTime(newTotalTime)}this.SetInitialStateFromSetTime()}SetEndValue(endValue,
propertyName){const propertyTrackState=this._GetPropertyTrackState(propertyName);const propertyTrackData=propertyTrackState.GetPropertyTrackData();const propertyTrackDataItem=propertyTrackState.GetPropertyTrackDataItem();const propertyKeyframeDataItem=propertyTrackData.GetLastPropertyKeyframeDataItem(propertyTrackDataItem);propertyKeyframeDataItem.SetTime(this.GetTotalTime());propertyKeyframeDataItem.SetValue(endValue);propertyKeyframeDataItem.SetAbsoluteValue(endValue)}SetId(id){this._id=id}GetId(){return this._id}SetInitialValueMode(initialValueMode){this._initialValueMode=
initialValueMode}GetInitialValueMode(){return this._initialValueMode}SetDestroyInstanceOnComplete(releaseOnComplete){this._destroyInstanceOnComplete=releaseOnComplete}GetDestroyInstanceOnComplete(){return this._destroyInstanceOnComplete}OnStarted(){if(this._on_started_callbacks)for(const c of this._on_started_callbacks)c(this);if(this.IsComplete())return;for(const track of this._tracks)track.CompareSaveStateWithCurrent()}OnCompleted(){this._completedTick=this._runtime.GetTickCount()}FinishTriggers(){if(this._finishedTriggers)return;
this._finishedTriggers=true;if(this._on_completed_callbacks)for(const c of this._on_completed_callbacks)c(this)}SetTime(time){this._DeleteIntermediateKeyframes();super.SetTime(time)}SetInitialState(fromSetTime){if(!this.InitialStateSet()&&this.GetInitialValueMode()===INITIAL_VALUE_MODE_CURRENT_STATE)for(const track of this._tracks)track.CompareInitialStateWithCurrent();super.SetInitialState(fromSetTime)}Stop(completed=false){super.Stop(completed);if(this.IsComplete())return;for(const track of this._tracks)track.SaveState()}Reset(render=
true,beforeChangeLayout=false){this._DeleteIntermediateKeyframes();super.Reset(render,beforeChangeLayout)}_DeleteIntermediateKeyframes(){for(const track of this._tracks){const del=kf=>{const time=kf.GetTime();const totalTime=this.GetTotalTime();return time!==0&&time!==totalTime};track.DeleteKeyframes(del);track.DeletePropertyKeyframes(del)}}_OnBeforeChangeLayout(){if(this.IsReleased())return true;const instance=this.GetInstance();if(instance&&instance.GetObjectClass().IsGlobal())return false;this._timelineManager.CompleteTimeline(this);
this.ResetBeforeChangeLayout();return true}MaybeTriggerKeyframeReachedConditions(){}Tick(deltaTime,timeScale){const instance=this.GetInstance();const dt=this.GetRuntime().GetDt(instance);super.Tick(dt,1)}_SaveToJson(){const ret=super._SaveToJson();const tweenDataItem=this.GetTimelineDataItem();return Object.assign(ret,{"tweenDataItemJson":tweenDataItem._SaveToJson(),"id":this._id,"destroyInstanceOnComplete":this._destroyInstanceOnComplete,"initialValueMode":this._initialValueMode})}_LoadFromJson(o){if(!o)return;
const tweenDataItem=this.GetTimelineDataItem();tweenDataItem._LoadFromJson(o["tweenDataItemJson"]);super._LoadFromJson(o);this._id=o["id"];this._destroyInstanceOnComplete=o["destroyInstanceOnComplete"];this._initialValueMode=o["initialValueMode"]}static IsPlaying(tween){return tween.IsPlaying()}static IsPaused(tween){return tween.IsPaused()}static Build(config){const timelineManager=config.runtime.GetTimelineManager();const tweenDataItem=new C3.TimelineDataItem;if(config.json){tweenDataItem._LoadFromJson(config.json["tweenDataItemJson"]);
const tween=new C3.Tween(tweenDataItem,timelineManager);tween._LoadFromJson(config.json);return tween}else{const tween=new C3.Tween(tweenDataItem,timelineManager);if(!C3.IsArray(config.propertyTracksConfig))config.propertyTracksConfig=[config.propertyTracksConfig];tween.SetId(config.id);tween.SetTags(config.tags);tween.SetInitialValueMode(config.initialValueMode);tween.SetDestroyInstanceOnComplete(config.releaseOnComplete);tween.SetLoop(config.loop);tween.SetPingPong(config.pingPong);tween.SetTotalTime(config.time);
tween.SetStep(0);tween.SetInterpolationMode("default");tween.SetResultMode(config.propertyTracksConfig[0].resultMode);const track=tween.AddTrack();track.SetInstanceUID(config.instance.GetUID());track.SetInterpolationMode("default");track.SetResultMode(config.propertyTracksConfig[0].resultMode);track.SetEnable(true);track.SetObjectClassIndex(config.instance.GetObjectClass().GetIndex());const sdkIntance=config.instance.GetSdkInstance();const w=sdkIntance.IsOriginalSizeKnown()?sdkIntance.GetOriginalWidth():
config.instance.GetWorldInfo().GetWidth();const h=sdkIntance.IsOriginalSizeKnown()?sdkIntance.GetOriginalHeight():config.instance.GetWorldInfo().GetHeight();track.SetOriginalWidth(w);track.SetOriginalHeight(h);const startKeyframeDataItem=track.AddKeyframe();startKeyframeDataItem.SetTime(0);startKeyframeDataItem.SetEase("noease");startKeyframeDataItem.SetEnable(true);startKeyframeDataItem.SetTags("");const endKeyframeDataItem=track.AddKeyframe();endKeyframeDataItem.SetTime(config.time);endKeyframeDataItem.SetEase("noease");
endKeyframeDataItem.SetEnable(true);endKeyframeDataItem.SetTags("");for(const propertyTrackConfig of config.propertyTracksConfig){const propertyTrack=track.AddPropertyTrack();propertyTrack.SetSourceAdapterId(propertyTrackConfig.sourceId);propertyTrack.SetSourceAdapterArgs(propertyTrackConfig.sourceArgs);propertyTrack.SetPropertyName(propertyTrackConfig.property);propertyTrack.SetPropertyType(propertyTrackConfig.type);propertyTrack.SetMin(NaN);propertyTrack.SetMax(NaN);propertyTrack.SetInterpolationMode("default");
propertyTrack.SetResultMode(propertyTrackConfig.resultMode);propertyTrack.SetEnable(true);const startPropertyKeyframeDataItem=propertyTrack.AddPropertyKeyframe();startPropertyKeyframeDataItem.SetType(propertyTrackConfig.valueType);startPropertyKeyframeDataItem.SetTime(0);startPropertyKeyframeDataItem.SetEase(propertyTrackConfig.ease);startPropertyKeyframeDataItem.SetEnable(true);startPropertyKeyframeDataItem.SetValue(propertyTrackConfig.startValue);startPropertyKeyframeDataItem.SetAbsoluteValue(propertyTrackConfig.startValue);
const endPropertyKeyframeDataItem=propertyTrack.AddPropertyKeyframe();endPropertyKeyframeDataItem.SetType(propertyTrackConfig.valueType);endPropertyKeyframeDataItem.SetTime(config.time);endPropertyKeyframeDataItem.SetEase(propertyTrackConfig.ease);endPropertyKeyframeDataItem.SetEnable(true);endPropertyKeyframeDataItem.SetValue(propertyTrackConfig.endValue);endPropertyKeyframeDataItem.SetAbsoluteValue(propertyTrackConfig.endValue)}return tween}}}};


// c3/timelines/transitions/transition.js
'use strict';{const C3=self.C3;const Ease=self.Ease;const NAME=0;const TRANSITION_KEYFRAMES=1;C3.Transition=class Transition extends C3.DefendedBase{constructor(data){super();this._name=data[NAME];this._transitionKeyframes=[];for(const transitionKeyframeData of data[TRANSITION_KEYFRAMES]){const transitionKeyframe=C3.TransitionKeyframe.Create(this,transitionKeyframeData);this._transitionKeyframes.push(transitionKeyframe)}this._precalculatedSamples=new Map;this._transitionKeyframeCache=new Map;this._PreCalcSamples();
Ease.AddCustomEase(this._name,(t,sv,dv,tt)=>this.Interpolate(t,sv,dv,tt))}static Create(data){return C3.New(C3.Transition,data)}Release(){for(const transitionKeyframe of this._transitionKeyframes)transitionKeyframe.Release();C3.clearArray(this._transitionKeyframes);this._transitionKeyframes=null;this._precalculatedSamples.clear();this._precalculatedSamples=null;this._transitionKeyframeCache.clear();this._transitionKeyframeCache=null}GetTransitionKeyFrameAt(x){const transitionKeyframe=this._transitionKeyframeCache.get(x);
if(transitionKeyframe)return transitionKeyframe;for(const transitionKeyframe of this._transitionKeyframes)if(transitionKeyframe.GetValueX()===x){this._transitionKeyframeCache.set(x,transitionKeyframe);return transitionKeyframe}}GetFirstTransitionKeyFrameHigherThan(x){for(const transitionKeyframe of this._transitionKeyframes)if(transitionKeyframe.GetValueX()>x)return transitionKeyframe}GetFirstTransitionKeyFrameHigherOrEqualThan(x){for(const transitionKeyframe of this._transitionKeyframes)if(transitionKeyframe.GetValueX()>=
x)return transitionKeyframe}GetFirstTransitionKeyFrameLowerOrEqualThan(x){for(let i=this._transitionKeyframes.length-1;i>=0;i--){const transitionKeyframe=this._transitionKeyframes[i];if(transitionKeyframe.GetValueX()<=x)return transitionKeyframe}}Interpolate(time,startValue,deltaValue,totalTime){const n=time/totalTime;let start=this.GetTransitionKeyFrameAt(n);let end=null;if(start)end=this.GetFirstTransitionKeyFrameHigherThan(n);else{start=this.GetFirstTransitionKeyFrameLowerOrEqualThan(n);end=this.GetFirstTransitionKeyFrameHigherOrEqualThan(n)}const delta=
end.GetValueX()-start.GetValueX();const nn=C3.mapToRange(n,start.GetValueX(),end.GetValueX(),0,delta);const startX=start.GetValueX();const startY=start.GetValueY();const anchor1X=start.GetValueX()+start.GetStartAnchorX();const anchor1Y=start.GetValueY()+start.GetStartAnchorY();const anchor2X=end.GetValueX()+end.GetEndAnchorX();const anchor2Y=end.GetValueY()+end.GetEndAnchorY();const endX=end.GetValueX();const endY=end.GetValueY();let ret=Ease.GetRuntimeEase("spline")(nn,startX,startY,anchor1X,anchor1Y,
anchor2X,anchor2Y,endX,endY,this._precalculatedSamples.get(start));ret+=start.GetValueY();return(1-ret)*startValue+ret*(startValue+deltaValue)}_PreCalcSamples(){this._precalculatedSamples.clear();for(let i=0;i<this._transitionKeyframes.length-1;i++){const transitionKeyframe=this._transitionKeyframes[i];if(!transitionKeyframe.GetStartEnable())continue;const start=transitionKeyframe;const end=this._transitionKeyframes[i+1];const startValue=start.GetValueX();const anchor1Value=start.GetValueX()+start.GetStartAnchorX();
const anchor2Value=end.GetValueX()+end.GetEndAnchorX();const endValue=end.GetValueX();this._precalculatedSamples.set(start,Ease.GetBezierSamples(startValue,anchor1Value,anchor2Value,endValue))}}}};


// c3/timelines/transitions/transitionKeyframe.js
'use strict';{const C3=self.C3;const VALUE_X=0;const VALUE_Y=1;const START_ANCHOR_X=2;const START_ANCHOR_Y=3;const END_ANCHOR_X=4;const END_ANCHOR_Y=5;const START_ENABLE=6;const END_ENABLE=7;C3.TransitionKeyframe=class TransitionKeyframe extends C3.DefendedBase{constructor(transition,data){super();this._transition=transition;this._valueX=data[VALUE_X];this._valueY=data[VALUE_Y];this._startAnchorX=data[START_ANCHOR_X];this._startAnchorY=data[START_ANCHOR_Y];this._endAnchorX=data[END_ANCHOR_X];this._endAnchorY=
data[END_ANCHOR_Y];this._startEnable=data[START_ENABLE];this._endEnable=data[END_ENABLE]}Release(){this._transition=null}static Create(transition,data){return C3.New(C3.TransitionKeyframe,transition,data)}GetValueX(){return this._valueX}GetValueY(){return this._valueY}GetStartAnchorX(){return this._startAnchorX}GetStartAnchorY(){return this._startAnchorY}GetEndAnchorX(){return this._endAnchorX}GetEndAnchorY(){return this._endAnchorY}GetStartEnable(){return this._startEnable}GetEndEnable(){return this._endEnable}}};


// c3/timelines/transitions/transitionManager.js
'use strict';{const C3=self.C3;C3.TransitionManager=class TransitionManager extends C3.DefendedBase{constructor(runtime){super();this._runtime=runtime;this._transitions=[]}Release(){for(const transition of this._transitions)transition.Release();C3.clearArray(this._transitions);this._transitions=null}Create(transitionData){this._transitions.push(C3.Transition.Create(transitionData))}}};


// c3/events/stacks/solStack.js
'use strict';{const C3=self.C3;C3.SolStack=class SolStack extends C3.DefendedBase{constructor(objectClass){super();this._objectClass=objectClass;this._stack=[];this._stack.push(C3.New(C3.Sol,this));this._index=0;this._current=this._stack[0]}Release(){for(const s of this._stack)s.Release();C3.clearArray(this._stack);this._current=null;this._objectClass=null}GetObjectClass(){return this._objectClass}GetCurrentSol(){return this._current}Clear(){this.GetCurrentSol().Clear()}PushClean(){const stack=this._stack;
const index=++this._index;if(index===stack.length){const sol=C3.New(C3.Sol,this);stack.push(sol);this._current=sol}else{const sol=stack[index];sol.Reset();this._current=sol}}PushCopy(){const stack=this._stack;const index=++this._index;if(index===stack.length)stack.push(C3.New(C3.Sol,this));const sol=stack[index];sol.Copy(stack[index-1]);this._current=sol}Pop(){this._current=this._stack[--this._index]}RemoveInstances(s){const stack=this._stack;for(let i=0,len=stack.length;i<len;++i)stack[i].RemoveInstances(s)}}};


// c3/events/stacks/sol.js
'use strict';{const C3=self.C3;C3.Sol=class Sol extends C3.DefendedBase{constructor(stack){super();this._stack=stack;this._objectClass=this._stack.GetObjectClass();this._eventStack=this._objectClass.GetRuntime().GetEventStack();this._selectAll=true;this._instances=[];this._elseInstances=[]}Release(){this.ClearArrays();this._stack=null;this._objectClass=null;this._eventStack=null}ClearArrays(){C3.clearArray(this._instances);C3.clearArray(this._elseInstances)}GetObjectClass(){return this._objectClass}IsSelectAll(){return this._selectAll}HasAnyInstances(){if(this._selectAll)return!!this._objectClass.GetInstanceCount();
else return!!this._instances.length}GetInstances(){if(this._selectAll)return this._objectClass.GetInstances();else return this._instances}HasAnyElseInstances(){return!!this._elseInstances.length}GetElseInstances(){return this._elseInstances}GetExpressionInstances(){const ret=this.GetInstances();if(ret.length)return ret;else return this._elseInstances}Reset(){this._selectAll=true;C3.clearArray(this._elseInstances)}Clear(){this._selectAll=true}Copy(sol){if(sol.IsSelectAll())this.Reset();else{this._selectAll=
false;C3.shallowAssignArray(this._instances,sol._instances);C3.clearArray(this._elseInstances)}}_PushInstance(inst){this._instances.push(inst)}_PushElseInstance(inst){this._elseInstances.push(inst)}_SetSelectAll(s){this._selectAll=!!s}_GetOwnInstances(){return this._instances}_GetOwnElseInstances(){return this._elseInstances}SetSinglePicked(inst){this._selectAll=false;C3.clearArray(this._instances);this._instances.push(inst)}SetArrayPicked(arr){this._selectAll=false;C3.shallowAssignArray(this._instances,
arr)}SetSetPicked(set){this._selectAll=false;C3.clearArray(this._instances);for(const item of set)this._instances.push(item)}AddElseInstances(setOfPicked,arrayOfAllPicked){for(const inst of arrayOfAllPicked)if(!setOfPicked.has(inst))this._elseInstances.push(inst)}TransferElseInstancesToOwn(setOfPicked){for(const inst of setOfPicked)this._instances.push(inst);C3.arrayRemoveAllInSet(this._elseInstances,setOfPicked)}PickOne(inst){if(!inst)return;if(this._eventStack.GetCurrentStackFrame().GetCurrentEvent().IsOrBlock()){if(this.IsSelectAll()){C3.clearArray(this._instances);
C3.shallowAssignArray(this._elseInstances,inst.GetObjectClass().GetInstances());this._selectAll=false}const i=this._elseInstances.indexOf(inst);if(i!==-1){this._instances.push(this._elseInstances[i]);this._elseInstances.splice(i,1)}}else this.SetSinglePicked(inst)}RemoveInstances(s){C3.arrayRemoveAllInSet(this._instances,s);C3.arrayRemoveAllInSet(this._elseInstances,s)}}};


// c3/events/stacks/eventStack.js
'use strict';{const C3=self.C3;C3.EventStack=class EventStack extends C3.DefendedBase{constructor(eventSheetManager){super();this._eventSheetManager=eventSheetManager;this._runtime=this._eventSheetManager.GetRuntime();this._stack=[];this._stack.push(C3.New(C3.EventStackFrame,this,null));this._index=0;this._expFuncStack=[]}Release(){for(const e of this._stack)e.Release();C3.clearArray(this._stack);C3.clearArray(this._expFuncStack);this._eventSheetManager=null;this._runtime=null}GetEventSheetManager(){return this._eventSheetManager}GetRuntime(){return this._runtime}GetCurrentStackFrame(){return this._stack[this._index]}Push(currentEvent){const stack=
this._stack;const index=++this._index;if(index===stack.length){const ret=C3.New(C3.EventStackFrame,this,currentEvent);stack.push(ret);return ret}else{const ret=stack[index];ret.Reset(currentEvent);return ret}}Pop(){--this._index}PushExpFunc(frame){this._expFuncStack.push(frame)}PopExpFunc(){this._expFuncStack.pop()}GetCurrentExpFuncStackFrame(){const expFuncStack=this._expFuncStack;if(expFuncStack.length===0)return null;else return expFuncStack[expFuncStack.length-1]}}};


// c3/events/stacks/eventStackFrame.js
'use strict';{const C3=self.C3;C3.EventStackFrame=class EventStackFrame extends C3.DefendedBase{constructor(stack,currentEvent){super();this._stack=stack;this._runtime=this._stack.GetRuntime();this._currentEvent=currentEvent;this._cndIndex=0;this._actIndex=0;this._lastEventTrue=false;this._elseBranchRan=false;this._expressionObjectClass=null;this._functionReturnType=0;this._functionReturnValue=0}Release(){this.Reset(null);this._stack=null;this._runtime=null}Reset(currentEvent){this._currentEvent=
currentEvent;this._cndIndex=0;this._actIndex=0;this._lastEventTrue=false;this._elseBranchRan=false}_Restore(currentEvent,actIndex){this._currentEvent=currentEvent;this._cndIndex=0;this._actIndex=actIndex}ResetQuick(){this._cndIndex=0;this._actIndex=0}GetCurrentEvent(){return this._currentEvent}SetCurrentEvent(currentEvent){this._currentEvent=currentEvent}GetConditionIndex(){return this._cndIndex}SetConditionIndex(i){this._cndIndex=i}GetActionIndex(){return this._actIndex}SetActionIndex(i){this._actIndex=
i}SetLastEventTrue(t){this._lastEventTrue=!!t}GetLastEventTrue(){return this._lastEventTrue}SetElseBranchRan(r){this._elseBranchRan=!!r}GetElseBranchRan(){return this._elseBranchRan}SetExpressionObjectClass(objectClass){this._expressionObjectClass=objectClass}GetExpressionObjectClass(){return this._expressionObjectClass}InitCallFunctionExpression(returnType,defaultReturnValue){this._functionReturnType=returnType;this._functionReturnValue=defaultReturnValue}GetFunctionReturnType(){return this._functionReturnType}SetFunctionReturnValue(v){this._functionReturnValue=
v}GetFunctionReturnValue(){return this._functionReturnValue}IsSolModifierAfterCnds(){const currentEvent=this._currentEvent;if(currentEvent.IsSolWriterAfterCnds())return true;if(this._cndIndex<currentEvent.GetConditionCount()-1)return!!currentEvent.GetSolModifiers().length;return false}}};


// c3/events/stacks/localVarStack.js
'use strict';{const C3=self.C3;C3.LocalVarStack=class LocalVarStack extends C3.DefendedBase{constructor(eventSheetManager){super();this._eventSheetManager=eventSheetManager;this._runtime=this._eventSheetManager.GetRuntime();this._stack=[];this._index=-1;this._current=null;this._initialValues=[]}Release(){C3.clearArray(this._stack);this._eventSheetManager=null;this._runtime=null}_SetInitialValues(initialValues){this._initialValues=initialValues;const arr=this._initialValues.slice(0);this._stack.push(arr);
this._index=0;this._current=arr}GetEventSheetManager(){return this._eventSheetManager}GetRuntime(){return this._runtime}GetCurrent(){return this._current}Push(){const index=++this._index;const stack=this._stack;if(index===stack.length)stack.push(this._initialValues.slice(0));else C3.shallowAssignArray(stack[index],this._initialValues);this._current=stack[index]}Pop(){this._current=this._stack[--this._index]}}};


// c3/events/stacks/loopStack.js
'use strict';{const C3=self.C3;C3.LoopStack=class LoopStack extends C3.DefendedBase{constructor(eventSheetManager){super();this._eventSheetManager=eventSheetManager;this._runtime=this._eventSheetManager.GetRuntime();this._stack=[];this._index=-1}Release(){C3.clearArray(this._stack);this._eventSheetManager=null;this._runtime=null}GetEventSheetManager(){return this._eventSheetManager}GetRuntime(){return this._runtime}IsInLoop(){return this._index>=0}GetCurrent(){return this._stack[this._index]}Push(){++this._index;
if(this._index===this._stack.length){const ret=C3.New(C3.Loop,this);this._stack.push(ret);return ret}else{const ret=this._stack[this._index];ret.Reset();return ret}}Pop(){--this._index}FindByName(name){const stack=this._stack;for(let i=this._index;i>=0;--i){const loop=stack[i];if(loop.GetName()===name)return loop}return null}_GetStack(){return this._stack.slice(0,this._index+1)}}};


// c3/events/stacks/loop.js
'use strict';{const C3=self.C3;C3.Loop=class Loop extends C3.DefendedBase{constructor(loopStack){super();this._loopStack=loopStack;this._name="";this._index=0;this._isStopped=false;this._end=NaN}Reset(){this._name="";this._index=0;this._isStopped=false;this._end=NaN}SetName(name){this._name=name}GetName(){return this._name}SetIndex(i){this._index=i}GetIndex(){return this._index}Stop(){this._isStopped=true}IsStopped(){return this._isStopped}SetEnd(e){this._end=e}GetEnd(){return this._end}}};


// c3/events/stacks/arrayStack.js
'use strict';{const C3=self.C3;C3.ArrayStack=class ArrayStack extends C3.DefendedBase{constructor(){super();this._stack=[];this._index=-1}Release(){C3.clearArray(this._stack)}GetCurrent(){return this._stack[this._index]}Push(){++this._index;if(this._index===this._stack.length){const ret=[];this._stack.push(ret);return ret}else return this._stack[this._index]}Pop(){--this._index}}};


// c3/events/eventSheetManager.js
'use strict';{const C3=self.C3;const assert=self.assert;function SortSolArray(a,b){return a.GetIndex()-b.GetIndex()}function IsSolArrayIdentical(a,b){for(let i=0,len=a.length;i<len;++i)if(a[i]!==b[i])return false;return true}C3.EventSheetManager=class EventSheetManager extends C3.DefendedBase{constructor(runtime){super();this._runtime=runtime;this._allSheets=[];this._sheetsByName=new Map;this._allGroups=[];this._groupsByName=new Map;this._blocksBySid=new Map;this._cndsBySid=new Map;this._actsBySid=
new Map;this._allUniqueSolModifiers=new Map;this._eventVarsBySid=new Map;this._nextLocalVarIndex=0;this._allGlobalVars=[];this._allLocalVars=[];this._localVarInitialValues=[];this._functionBlocksByName=new Map;this._eventStack=C3.New(C3.EventStack,this);this._localVarStack=C3.New(C3.LocalVarStack,this);this._loopStack=C3.New(C3.LoopStack,this);this._triggersToPostInit=[];this._queuedTriggers=[];this._queuedDebugTriggers=[];this._runningEventsDepth=0;this._executingTriggerDepth=0;this._blockFlushingDepth=
0;this._scheduledWaits=[];this._asyncActionPromises=[];self["c3_callFunction"]=(name,params)=>this._InvokeFunctionFromJS(name,params)}Release(){this.ClearAllScheduledWaits();this._eventStack.Release();this._eventStack=null;this._localVarStack.Release();this._localVarStack=null;C3.clearArray(this._queuedTriggers);C3.clearArray(this._queuedDebugTriggers);this._runtime=null;C3.clearArray(this._allSheets);this._sheetsByName.clear()}Create(eventSheetData){const eventSheet=C3.New(C3.EventSheet,this,eventSheetData);
this._allSheets.push(eventSheet);this._sheetsByName.set(eventSheet.GetName().toLowerCase(),eventSheet)}_AddTriggerToPostInit(trig){this._triggersToPostInit.push(trig)}_PostInit(){for(const functionBlock of this._functionBlocksByName.values())functionBlock._PostInit(false);for(const sheet of this._allSheets)sheet._PostInit();for(const sheet of this._allSheets)sheet._UpdateDeepIncludes();for(const trig of this._triggersToPostInit)trig._PostInit(false);C3.clearArray(this._triggersToPostInit);this._localVarStack._SetInitialValues(this._localVarInitialValues)}GetRuntime(){return this._runtime}GetEventSheetByName(name){return this._sheetsByName.get(name.toLowerCase())||
null}_RegisterGroup(group){this._allGroups.push(group);this._groupsByName.set(group.GetGroupName(),group)}_RegisterEventBlock(eventBlock){this._blocksBySid.set(eventBlock.GetSID(),eventBlock)}_RegisterCondition(condition){this._cndsBySid.set(condition.GetSID(),condition)}_RegisterAction(action){this._actsBySid.set(action.GetSID(),action)}_RegisterFunctionBlock(functionBlock){this._functionBlocksByName.set(functionBlock.GetFunctionName().toLowerCase(),functionBlock)}_RegisterEventVariable(ev){this._eventVarsBySid.set(ev.GetSID(),
ev);if(ev.IsGlobal())this._allGlobalVars.push(ev);else this._allLocalVars.push(ev)}_DeduplicateSolModifierList(arr){if(arr.length>=2)arr.sort(SortSolArray);let candidateList=this._allUniqueSolModifiers.get(arr.length);if(!candidateList){candidateList=[];this._allUniqueSolModifiers.set(arr.length,candidateList)}for(let i=0,len=candidateList.length;i<len;++i){const candidate=candidateList[i];if(IsSolArrayIdentical(arr,candidate))return candidate}candidateList.push(arr);return arr}_GetNextLocalVarIndex(eventVar){this._localVarInitialValues.push(eventVar.GetInitialValue());
return this._nextLocalVarIndex++}GetEventStack(){return this._eventStack}GetCurrentEventStackFrame(){return this.GetEventStack().GetCurrentStackFrame()}GetCurrentEvent(){return this.GetCurrentEventStackFrame().GetCurrentEvent()}GetCurrentCondition(){const frame=this.GetCurrentEventStackFrame();const event=frame.GetCurrentEvent();return event.GetConditionAt(frame.GetConditionIndex())}GetCurrentAction(){const frame=this.GetCurrentEventStackFrame();const event=frame.GetCurrentEvent();return event.GetActionAt(frame.GetActionIndex())}GetLocalVarStack(){return this._localVarStack}GetLoopStack(){return this._loopStack}GetAllLocalVariablesInScope(fromRow){const ret=
[];fromRow=fromRow.GetScopeParent();while(fromRow){C3.appendArray(ret,fromRow._GetAllLocalVariablesInScope());fromRow=fromRow.GetScopeParent()}return ret}_GetLocalVariablesScriptInterface(fromRow){const localVarDescriptors={};for(const v of this.GetAllLocalVariablesInScope(fromRow))localVarDescriptors[v.GetJsPropName()]=v._GetScriptInterfaceDescriptor();return Object.create(Object.prototype,localVarDescriptors)}GetEventVariableBySID(sid){return this._eventVarsBySid.get(sid)||null}GetEventBlockBySID(sid){return this._blocksBySid.get(sid)||
null}GetConditionBySID(sid){return this._cndsBySid.get(sid)||null}GetActionBySID(sid){return this._actsBySid.get(sid)||null}GetFunctionBlockByName(name){return this._functionBlocksByName.get(name.toLowerCase())||null}GetAllGlobalVariables(){return this._allGlobalVars}GetAllLocalVariables(){return this._allLocalVars}ResetAllGlobalsToInitialValue(){for(const ev of this._allGlobalVars)ev.ResetToInitialValue()}GetEventGroupByName(name){return this._groupsByName.get(name.toLowerCase())||null}GetEventGroupBySID(sid){const group=
this._blocksBySid.get(sid);if(group&&group.IsGroup())return group;else return null}GetAllGroups(){return this._allGroups}ResetAllGroupsInitialActivation(){for(const group of this._allGroups)group.ResetInitialActivation()}_ResetAllHasRunFlags(){for(const sheet of this._allSheets)sheet._ResetHasRunFlag()}RunEvents(layoutManager){this._ResetAllHasRunFlags();this._runningEventsDepth++;for(const layout of layoutManager.runningLayouts()){const eventSheet=layout.GetEventSheet();if(!eventSheet)continue;this._runtime.PushCurrentLayout(layout);
eventSheet.Run();this._runtime.PopCurrentLayout()}this._runningEventsDepth--}async DebugRunEvents(layoutManager){this._ResetAllHasRunFlags();this._runningEventsDepth++;for(const breakEventObject of this._DebugRunEventsGen(layoutManager))await this._runtime.DebugBreak(breakEventObject);this._runningEventsDepth--}*_DebugRunEventsGen(layoutManager){for(const layout of layoutManager.runningLayouts()){const eventSheet=layout.GetEventSheet();if(!eventSheet)continue;this._runtime.PushCurrentLayout(layout);
yield*eventSheet.DebugRun();this._runtime.PopCurrentLayout()}}_Trigger(layoutManager,method,inst,behaviorType){let ret=false;if(!layoutManager.GetMainRunningLayout())return this.QueueTrigger(method,inst,behaviorType);this._executingTriggerDepth++;for(const layout of layoutManager.runningLayouts()){const eventSheet=layout.GetEventSheet();if(!eventSheet)continue;this._runtime.PushCurrentLayout(layout);for(const includeSheet of eventSheet.deepIncludes()){const result=includeSheet._Trigger(method,inst,
behaviorType);ret=ret||result}const result2=eventSheet._Trigger(method,inst,behaviorType);ret=ret||result2;this._runtime.PopCurrentLayout()}this._executingTriggerDepth--;return ret}*_DebugTrigger(layoutManager,method,inst,behaviorType){let ret=false;if(!layoutManager.GetMainRunningLayout())return this.QueueTrigger(method,inst,behaviorType);this._executingTriggerDepth++;for(const layout of layoutManager.runningLayouts()){const eventSheet=layout.GetEventSheet();if(!eventSheet)continue;this._runtime.PushCurrentLayout(layout);
for(const includeSheet of eventSheet.deepIncludes()){const result=yield*includeSheet._DebugTrigger(method,inst,behaviorType);ret=ret||result}const result2=yield*eventSheet._DebugTrigger(method,inst,behaviorType);ret=ret||result2;this._runtime.PopCurrentLayout()}this._executingTriggerDepth--;return ret}QueueTrigger(method,inst,behaviorType){this._queuedTriggers.push([method,inst,behaviorType]);return false}QueueDebugTrigger(method,inst,behaviorType){let resolve=null;const ret=new Promise(r=>resolve=
r);this._queuedDebugTriggers.push([method,inst,behaviorType,resolve]);return ret}*_RunQueuedDebugTriggersGen(){if(this._runtime.HitBreakpoint())throw new Error("should not be in breakpoint");const layoutManager=this._runtime.GetLayoutManager();while(this._queuedDebugTriggers.length){const [method,inst,behaviorType,resolve]=this._queuedDebugTriggers.shift();const ret=yield*this._DebugTrigger(layoutManager,method,inst,behaviorType);resolve(ret)}}async RunQueuedDebugTriggersAsync(){for(const breakEventObject of this._RunQueuedDebugTriggersGen())await this._runtime.DebugBreak(breakEventObject)}_FastTrigger(layoutManager,
method,inst,value){let ret=false;const layout=layoutManager.GetMainRunningLayout();const eventSheet=layout.GetEventSheet();if(!eventSheet)return;this._executingTriggerDepth++;this._runtime.PushCurrentLayout(layout);const deepIncludes=eventSheet.deepIncludes();for(let i=0,len=deepIncludes.length;i<len;++i){const result=deepIncludes[i]._FastTrigger(method,inst,value);ret=ret||result}const result2=eventSheet._FastTrigger(method,inst,value);ret=ret||result2;this._runtime.PopCurrentLayout();this._executingTriggerDepth--;
return ret}*_DebugFastTrigger(layoutManager,method,inst,value){let ret=false;const layout=layoutManager.GetMainRunningLayout();const eventSheet=layout.GetEventSheet();if(!eventSheet)return;this._executingTriggerDepth++;this._runtime.PushCurrentLayout(layout);const deepIncludes=eventSheet.deepIncludes();for(let i=0,len=deepIncludes.length;i<len;++i){const result=yield*deepIncludes[i]._DebugFastTrigger(method,inst,value);ret=ret||result}const result2=yield*eventSheet._DebugFastTrigger(method,inst,value);
ret=ret||result2;this._runtime.PopCurrentLayout();this._executingTriggerDepth--;return ret}GetTriggerDepth(){return this._executingTriggerDepth}IsInTrigger(){return this.GetTriggerDepth()>0}_IncTriggerDepth(){return++this._executingTriggerDepth}_DecTriggerDepth(){--this._executingTriggerDepth}IsRunningEvents(){return this._runningEventsDepth>0}IsInEventEngine(){return this.IsRunningEvents()||this.IsInTrigger()}_RunQueuedTriggers(layoutManager){for(const [method,inst,behaviorType]of this._queuedTriggers)this._Trigger(layoutManager,
method,inst,behaviorType);C3.clearArray(this._queuedTriggers)}BlockFlushingInstances(e){if(e)this._blockFlushingDepth++;else this._blockFlushingDepth--}IsFlushingBlocked(){return this._blockFlushingDepth>0}ClearSol(solModifiers){for(let i=0,len=solModifiers.length;i<len;++i)solModifiers[i].GetSolStack().Clear()}PushCleanSol(solModifiers){for(let i=0,len=solModifiers.length;i<len;++i)solModifiers[i].GetSolStack().PushClean()}PushCopySol(solModifiers){for(let i=0,len=solModifiers.length;i<len;++i)solModifiers[i].GetSolStack().PushCopy()}PopSol(solModifiers){for(let i=
0,len=solModifiers.length;i<len;++i)solModifiers[i].GetSolStack().Pop()}AddScheduledWait(){const w=C3.New(C3.ScheduledWait,this);this._scheduledWaits.push(w);return w}scheduledWaits(){return this._scheduledWaits}RunScheduledWaits(){if(!this._scheduledWaits.length)return;const frame=this.GetCurrentEventStackFrame();let didAnyRun=false;this._runningEventsDepth++;for(let i=0,len=this._scheduledWaits.length;i<len;++i){const w=this._scheduledWaits[i];if(w._ShouldRun())w._Run(frame);if(w.ShouldRelease())didAnyRun=
true}if(didAnyRun)this._FilterScheduledWaitsToRelease();this._runningEventsDepth--}async DebugRunScheduledWaits(){if(!this._scheduledWaits.length)return;const frame=this.GetCurrentEventStackFrame();let didAnyRun=false;this._runningEventsDepth++;for(let i=0,len=this._scheduledWaits.length;i<len;++i){const w=this._scheduledWaits[i];if(w._ShouldRun())await w._DebugRun(frame);if(w.ShouldRelease())didAnyRun=true}if(didAnyRun)this._FilterScheduledWaitsToRelease();this._runningEventsDepth--}_FilterScheduledWaitsToRelease(){const toRelease=
C3.arrayFilterOut(this._scheduledWaits,w=>w.ShouldRelease());for(const w of toRelease)w.Release()}ClearAllScheduledWaits(){for(const w of this._scheduledWaits)w.Release();C3.clearArray(this._scheduledWaits)}RemoveInstancesFromScheduledWaits(s){for(const w of this._scheduledWaits)w.RemoveInstances(s)}AddAsyncActionPromise(p){this._asyncActionPromises.push(p)}ClearAsyncActionPromises(){C3.clearArray(this._asyncActionPromises)}GetPromiseForAllAsyncActions(){const ret=Promise.all(this._asyncActionPromises);
this._asyncActionPromises=[];return ret}_SaveToJson(){return{"groups":this._SaveGroupsToJson(),"cnds":this._SaveCndsToJson(),"acts":this._SaveActsToJson(),"vars":this._SaveVarsToJson(),"waits":this._SaveScheduledWaitsToJson()}}_LoadFromJson(o){this._LoadGroupsFromJson(o["groups"]);this._LoadCndsFromJson(o["cnds"]);this._LoadActsFromJson(o["acts"]);this._LoadVarsFromJson(o["vars"]);this._LoadScheduledWaitsFromJson(o["waits"])}_SaveGroupsToJson(){const o={};for(const group of this.GetAllGroups())o[group.GetSID().toString()]=
group.IsGroupActive();return o}_LoadGroupsFromJson(o){for(const [sidStr,data]of Object.entries(o)){const sid=parseInt(sidStr,10);const group=this.GetEventGroupBySID(sid);if(group)group.SetGroupActive(data)}}_SaveCndsToJson(){const o={};for(const [sid,cnd]of this._cndsBySid){const data=cnd._SaveToJson();if(data)o[sid.toString()]=data}return o}_LoadCndsFromJson(o){const map=new Map;for(const [sidStr,data]of Object.entries(o))map.set(parseInt(sidStr,10),data);for(const [sid,cnd]of this._cndsBySid)cnd._LoadFromJson(map.get(sid)||
null)}_SaveActsToJson(){const o={};for(const [sid,act]of this._actsBySid){const data=act._SaveToJson();if(data)o[sid.toString()]=data}return o}_LoadActsFromJson(o){const map=new Map;for(const [sidStr,data]of Object.entries(o))map.set(parseInt(sidStr,10),data);for(const [sid,act]of this._actsBySid)act._LoadFromJson(map.get(sid)||null)}_SaveVarsToJson(){const o={};for(const [sid,eventVar]of this._eventVarsBySid)if(!eventVar.IsConstant()&&(eventVar.IsGlobal()||eventVar.IsStatic()))o[sid.toString()]=
eventVar.GetValue();return o}_LoadVarsFromJson(o){for(const [sidStr,data]of Object.entries(o)){const sid=parseInt(sidStr,10);const eventVar=this.GetEventVariableBySID(sid);if(eventVar)eventVar.SetValue(data)}}_SaveScheduledWaitsToJson(){return this._scheduledWaits.filter(w=>!w.IsPromise()).map(w=>w._SaveToJson())}_LoadScheduledWaitsFromJson(arr){this.ClearAllScheduledWaits();for(const data of arr){const sw=C3.ScheduledWait._CreateFromJson(this,data);if(sw)this._scheduledWaits.push(sw)}}_GetPerfRecords(){return[...this._runtime.GetLayoutManager().runningLayouts()].map(l=>
l.GetEventSheet()).filter(eventSheet=>eventSheet).map(e=>e._GetPerfRecord())}FindFirstFunctionBlockParent(parent){while(parent){const scopeParent=parent.GetScopeParent();if(scopeParent instanceof C3.FunctionBlock)return scopeParent;parent=scopeParent}return null}_InvokeFunctionFromJS(name,params){if(!Array.isArray(params))params=[];const functionBlock=this.GetFunctionBlockByName(name.toLowerCase());if(!functionBlock)return null;if(!functionBlock.IsEnabled())return functionBlock.GetDefaultReturnValue();
const functionParameters=functionBlock.GetFunctionParameters();if(params.length<functionParameters.length){params=params.slice(0);do params.push(functionParameters[params.length].GetInitialValue());while(params.length<functionParameters.length)}const callEventBlock=functionBlock.GetEventBlock();return callEventBlock.RunAsExpressionFunctionCall(callEventBlock.GetSolModifiersIncludingParents(),functionBlock.GetReturnType(),functionBlock.GetDefaultReturnValue(),...params)}}};


// c3/events/eventSheet.js
'use strict';{const C3=self.C3;C3.EventSheet=class EventSheet extends C3.DefendedBase{constructor(eventSheetManager,data){super();this._eventSheetManager=eventSheetManager;this._runtime=eventSheetManager.GetRuntime();this._name=data[0];this._events=[];this._triggers=new Map;this._fastTriggers=new Map;this._eventsByDisplayNumber=new Map;this._hasRun=false;this._shallowIncludes=[];this._deepIncludes=[];this._alreadyIncludedSheets=new Set;for(const eventData of data[1])this._CreateEvent(eventData,null,
this._events);this._perfRecord=this._runtime.IsDebug()?{type:"sheet",name:this._name,totalTimeCounter:0,children:[]}:null}Release(){this._eventSheetManager=null;this._runtime=null}_CreateEvent(eventData,parent,nontriggers){switch(eventData[0]){case 0:case 3:this._CreateEventBlock(eventData,parent,nontriggers);break;case 1:this._CreateEventVariable(eventData,parent,nontriggers);break;case 2:this._CreateInclude(eventData,parent,nontriggers);break;case 4:this._CreateFunctionBlock(eventData,parent);break;
case 5:this._CreateScriptBlock(eventData,parent,nontriggers);break;default:throw new Error("invalid event type");}}_CreateEventBlock(data,parent,nontriggers){const eventBlock=C3.EventBlock.Create(this,parent,data);if(eventBlock.IsOrBlock()){nontriggers.push(eventBlock);const conditions=eventBlock.GetConditions();for(let i=0,len=conditions.length;i<len;++i)if(conditions[i].IsTrigger())this._InitTrigger(eventBlock,i)}else if(eventBlock.IsTrigger())this._InitTrigger(eventBlock,0);else nontriggers.push(eventBlock)}_CreateFunctionBlock(data,
parent){const functionBlock=C3.FunctionBlock.Create(this,parent,data);this._eventSheetManager._RegisterFunctionBlock(functionBlock)}_CreateEventVariable(data,parent,nontriggers){const v=C3.EventVariable.Create(this,parent,data);nontriggers.push(v)}_CreateInclude(data,parent,nontriggers){const include=C3.EventInclude.Create(this,parent,data);nontriggers.push(include)}_CreateScriptBlock(data,parent,nontriggers){const scriptBlock=C3.EventScript.Create(this,parent,data);nontriggers.push(scriptBlock)}_InitTrigger(eventBlock,
i){if(!eventBlock.IsOrBlock())this._eventSheetManager._AddTriggerToPostInit(eventBlock);const cnd=eventBlock.GetConditionAt(i);const func=cnd._GetFunc();const objectClass=cnd.GetObjectClass();if(cnd.IsFastTrigger()){let methodMap=this._fastTriggers.get(objectClass);if(!methodMap){methodMap=new Map;this._fastTriggers.set(objectClass,methodMap)}const value=cnd.GetFastTriggerValue().toLowerCase();let valueMap=methodMap.get(func);if(!valueMap){valueMap=new Map;methodMap.set(func,valueMap)}let triggerArr=
valueMap.get(value);if(!triggerArr){triggerArr=[];valueMap.set(value,triggerArr)}triggerArr.push([eventBlock,i])}else{let ocInfo=this._triggers.get(objectClass);if(!ocInfo){ocInfo={methodMap:new Map,behaviors:new Map};this._triggers.set(objectClass,ocInfo)}const behaviorType=cnd.GetBehaviorType();let methodMap;if(behaviorType){methodMap=ocInfo.behaviors.get(behaviorType);if(!methodMap){methodMap=new Map;ocInfo.behaviors.set(behaviorType,methodMap)}}else methodMap=ocInfo.methodMap;let triggerArr=methodMap.get(func);
if(!triggerArr){triggerArr=[];methodMap.set(func,triggerArr)}triggerArr.push([eventBlock,i])}}_PostInit(){const events=this._events;for(let i=0,len=events.length;i<len;++i){const hasElseBlock=i<len-1&&events[i+1]instanceof C3.EventBlock&&events[i+1].IsElseBlock();events[i]._PostInit(hasElseBlock)}}_AddShallowInclude(include){this._shallowIncludes.push(include)}_UpdateDeepIncludes(){C3.clearArray(this._deepIncludes);this._AddDeepIncludes(this);this._alreadyIncludedSheets.clear()}_AddDeepIncludes(rootSheet){const deepIncludes=
rootSheet._deepIncludes;const alreadyIncludedSheets=rootSheet._alreadyIncludedSheets;for(const include of this._shallowIncludes){const sheet=include.GetIncludeSheet();if(!include.IsActive()||rootSheet===sheet||alreadyIncludedSheets.has(sheet))continue;alreadyIncludedSheets.add(sheet);sheet._AddDeepIncludes(rootSheet);deepIncludes.push(sheet)}}deepIncludes(){return this._deepIncludes}GetEventSheetManager(){return this._eventSheetManager}GetRuntime(){return this._runtime}GetName(){return this._name}_RegisterEventByDisplayNumber(eventBlock,
displayNumber){this._eventsByDisplayNumber.set(displayNumber,eventBlock)}_GetEventByDisplayNumber(displayNumber){return this._eventsByDisplayNumber.get(displayNumber)||null}_ResetHasRunFlag(){this._hasRun=false}Run(){if(this._hasRun)return;const runtime=this._runtime;const profile=runtime.IsCPUProfiling();const startTime=profile?performance.now():0;this._hasRun=true;const eventSheetManager=this.GetEventSheetManager();const frame=eventSheetManager.GetCurrentEventStackFrame();for(const e of this._events){e.Run(frame);
eventSheetManager.ClearSol(e.GetSolModifiers());eventSheetManager.ClearAsyncActionPromises();runtime.FlushPendingInstances()}frame.Reset(null);if(profile)this._perfRecord.totalTimeCounter+=performance.now()-startTime}*DebugRun(){if(this._hasRun)return;this._hasRun=true;const runtime=this._runtime;const eventSheetManager=this.GetEventSheetManager();const frame=eventSheetManager.GetCurrentEventStackFrame();for(const e of this._events){yield*e.DebugRun(frame);eventSheetManager.ClearSol(e.GetSolModifiers());
eventSheetManager.ClearAsyncActionPromises();runtime.FlushPendingInstances()}frame.Reset(null)}_Trigger(method,inst,behaviorType){if(inst){const objectClass=inst.GetObjectClass();let ret=false;let r=this._TriggerForClass(method,inst,objectClass,behaviorType);ret=ret||r;for(const family of objectClass.GetFamilies()){r=this._TriggerForClass(method,inst,family,behaviorType);ret=ret||r}}else return this._TriggerForClass(method,inst,null,null)}_TriggerForClass(method,inst,objectClass,behaviorType){const ocInfo=
this._triggers.get(objectClass);if(!ocInfo)return false;const methodMap=behaviorType?ocInfo.behaviors.get(behaviorType):ocInfo.methodMap;if(!methodMap)return false;const triggerList=methodMap.get(method);if(!triggerList)return false;let ret=false;for(const [trigger,index]of triggerList){const r=this._ExecuteTrigger(inst,trigger,index);ret=ret||r}return ret}*_DebugTrigger(method,inst,behaviorType){if(inst){const objectClass=inst.GetObjectClass();let ret=false;let r=yield*this._DebugTriggerForClass(method,
inst,objectClass,behaviorType);ret=ret||r;for(const family of objectClass.GetFamilies()){r=yield*this._DebugTriggerForClass(method,inst,family,behaviorType);ret=ret||r}}else return yield*this._DebugTriggerForClass(method,inst,null,null)}*_DebugTriggerForClass(method,inst,objectClass,behaviorType){const ocInfo=this._triggers.get(objectClass);if(!ocInfo)return false;const methodMap=behaviorType?ocInfo.behaviors.get(behaviorType):ocInfo.methodMap;if(!methodMap)return false;const triggerList=methodMap.get(method);
if(!triggerList)return false;let ret=false;for(const [trigger,index]of triggerList){let r;if(trigger.DebugCanRunFast())r=this._ExecuteTrigger(inst,trigger,index);else r=yield*this._DebugExecuteTrigger(inst,trigger,index);ret=ret||r}return ret}_FastTrigger(method,inst,value){const objectClass=inst.GetObjectClass();const methodMap=this._fastTriggers.get(objectClass);if(!methodMap)return false;const valueMap=methodMap.get(method);if(!valueMap)return false;const triggerList=valueMap.get(value);if(!triggerList)return false;
let ret=false;for(let i=0,len=triggerList.length;i<len;++i){const t=triggerList[i];const r=this._ExecuteTrigger(null,t[0],t[1]);ret=ret||r}return ret}*_DebugFastTrigger(method,inst,value){const objectClass=inst.GetObjectClass();const methodMap=this._fastTriggers.get(objectClass);if(!methodMap)return false;const valueMap=methodMap.get(method);if(!valueMap)return false;const triggerList=valueMap.get(value);if(!triggerList)return false;let ret=false;for(let i=0,len=triggerList.length;i<len;++i){const t=
triggerList[i];const trigger=t[0];const index=t[1];let r;if(trigger.DebugCanRunFast())r=this._ExecuteTrigger(null,trigger,index);else r=yield*this._DebugExecuteTrigger(null,trigger,index);ret=ret||r}return ret}_ExecuteTrigger(inst,trigger,index){const runtime=this._runtime;const eventSheetManager=this._eventSheetManager;const currentEvent=eventSheetManager.GetCurrentEvent();const eventStack=eventSheetManager.GetEventStack();const triggerDepth=eventSheetManager.GetTriggerDepth();let ret=false;if(currentEvent)eventSheetManager.PushCleanSol(currentEvent.GetSolModifiersIncludingParents());
eventSheetManager.PushCleanSol(trigger.GetSolModifiersIncludingParents());const isRecursive=triggerDepth>1;if(isRecursive)eventSheetManager.GetLocalVarStack().Push();const frame=eventStack.Push(trigger);if(inst){const objectClass=trigger.GetConditions()[index].GetObjectClass();const sol=objectClass.GetCurrentSol();sol.SetSinglePicked(inst);if(inst.IsInContainer())inst.SetSiblingsSinglePicked()}let okToRun=true;if(trigger.GetParent()){const parents=trigger.GetTriggerParents();for(let i=0,len=parents.length;i<
len;++i)if(!parents[i].RunPreTrigger(frame)){okToRun=false;break}}if(okToRun){runtime.IncrementExecCount();if(trigger.IsOrBlock())trigger.RunOrBlockTrigger(frame,index);else trigger.Run(frame);ret=frame.GetLastEventTrue()}eventStack.Pop();if(isRecursive)eventSheetManager.GetLocalVarStack().Pop();eventSheetManager.PopSol(trigger.GetSolModifiersIncludingParents());if(currentEvent)eventSheetManager.PopSol(currentEvent.GetSolModifiersIncludingParents());if(!currentEvent&&triggerDepth===1){eventSheetManager.ClearAsyncActionPromises();
if(!eventSheetManager.IsFlushingBlocked())runtime.FlushPendingInstances()}return ret}*_DebugExecuteTrigger(inst,trigger,index){const runtime=this._runtime;const eventSheetManager=this._eventSheetManager;const currentEvent=eventSheetManager.GetCurrentEvent();const eventStack=eventSheetManager.GetEventStack();const triggerDepth=eventSheetManager.GetTriggerDepth();let ret=false;if(currentEvent)eventSheetManager.PushCleanSol(currentEvent.GetSolModifiersIncludingParents());eventSheetManager.PushCleanSol(trigger.GetSolModifiersIncludingParents());
const isRecursive=triggerDepth>1;if(isRecursive)eventSheetManager.GetLocalVarStack().Push();const frame=eventStack.Push(trigger);if(inst){const objectClass=trigger.GetConditions()[index].GetObjectClass();const sol=objectClass.GetCurrentSol();sol.SetSinglePicked(inst);if(inst.IsInContainer())inst.SetSiblingsSinglePicked()}let okToRun=true;if(trigger.GetParent()){const parents=trigger.GetTriggerParents();for(let i=0,len=parents.length;i<len;++i)if(!(yield*parents[i].DebugRunPreTrigger(frame))){okToRun=
false;break}}if(okToRun){runtime.IncrementExecCount();if(trigger.IsOrBlock())yield*trigger.DebugRunOrBlockTrigger(frame,index);else yield*trigger.DebugRun(frame);ret=frame.GetLastEventTrue()}eventStack.Pop();if(isRecursive)eventSheetManager.GetLocalVarStack().Pop();eventSheetManager.PopSol(trigger.GetSolModifiersIncludingParents());if(currentEvent)eventSheetManager.PopSol(currentEvent.GetSolModifiersIncludingParents());if(!currentEvent&&triggerDepth===1){eventSheetManager.ClearAsyncActionPromises();
if(!eventSheetManager.IsFlushingBlocked())runtime.FlushPendingInstances()}return ret}_GetPerfRecord(){return this._perfRecord}}};


// c3/events/eventBlock.js
'use strict';{const C3=self.C3;const EMPTY_ARRAY=[];function NoActions(frame,index){return true}function*DebugNoActions(frame,index){return true}C3.EventBlock=class EventBlock extends C3.DefendedBase{constructor(eventSheet,parent,data){super();this._eventSheet=eventSheet;this._runtime=eventSheet.GetRuntime();this._parent=parent;this._scopeParent=null;this._eventStack=this._runtime.GetEventSheetManager().GetEventStack();this._solModifiers=[];this._solModifiersIncludingParents=[];this._hasGotSolModifiersIncludingParents=
false;this._isSolWriterAfterCnds=false;this._isTopLevelGroup=false;this._hasElseBlock=false;this._isOrBlock=!!data[2];this._isElseBlock=false;this._triggerParents=null;this._conditions=[];this._actions=[];this._subEvents=[];this._RunActions=NoActions;this._DebugRunActions=DebugNoActions;this._isGroup=false;this._isInitiallyActive=false;this._groupName="";this._isGroupActive=false;this._containedIncludes=null;this._perfRecord=null;this._sid=data[4];this._displayNumber=data[5];this._eventSheet._RegisterEventByDisplayNumber(this,
this._displayNumber);this._debugData=this._runtime.IsDebug()?{isBreakpoint:data[3][0],isBreakable:data[3][1],canRunAllConditionsFast:false,canRunAllActionsFast:false,canRunAllSubEventsFast:false,canRunSelfFast:false}:null;this.GetEventSheetManager()._RegisterEventBlock(this);if(data[0]===3)this._InitGroup(data[1]);let index=0;for(const cndData of data[6]){const condition=C3.Condition.Create(this,cndData,index++);this._conditions.push(condition);this._AddSolModifier(condition.GetObjectClass())}index=
0;for(const actData of data[7]){const action=C3.Action.Create(this,actData,index++);this._actions.push(action)}if(data.length===9){const subEventsData=data[8];for(const eventData of subEventsData)this._eventSheet._CreateEvent(eventData,this,this._subEvents)}if(this._conditions.length)this._isElseBlock=this._conditions[0].GetObjectClass()===null&&this._conditions[0]._GetFunc()===C3.Plugins.System.Cnds.Else;if(this._conditions.length===0)this._conditions=EMPTY_ARRAY;if(this._actions.length===0)this._actions=
EMPTY_ARRAY;if(this._subEvents.length===0)this._subEvents=EMPTY_ARRAY}static Create(eventSheet,parent,data){return C3.New(C3.EventBlock,eventSheet,parent,data)}_InitGroup(groupData){this._isGroup=true;this._isInitiallyActive=!!groupData[0];this._isGroupActive=this._isInitiallyActive;this._groupName=groupData[1].toLowerCase();this._containedIncludes=[];this.GetEventSheetManager()._RegisterGroup(this);if(this._runtime.IsDebug())this._perfRecord={type:"group",name:groupData[1],totalTimeCounter:0,children:[]}}_AddContainedInclude(include){this._containedIncludes.push(include)}_AddContainerSolModifierToList(objectClass,
arr){for(const containerType of objectClass.GetContainer().objectTypes())if(!arr.includes(containerType))arr.push(containerType)}_AddSolModifierToList(objectClass,arr){if(!objectClass)return;if(!arr.includes(objectClass))arr.push(objectClass);if(objectClass.IsFamily())for(const familyMember of objectClass.GetFamilyMembers()){if(familyMember.IsInContainer())this._AddContainerSolModifierToList(familyMember,arr)}else if(objectClass.IsInContainer())this._AddContainerSolModifierToList(objectClass,arr)}_AddSolModifier(objectClass){this._AddSolModifierToList(objectClass,
this._solModifiers)}_AddParentSolModifier(objectClass){this._AddSolModifierToList(objectClass,this._solModifiersIncludingParents)}SetAllSolModifiers(){this._solModifiers=this._runtime.GetAllObjectClasses()}_PostInit(hasElse){this._hasElseBlock=!!hasElse;this._IdentifyTopLevelGroup();this._IdentifyTriggerParents();for(const c of this._conditions)c._PostInit();if(this._actions.length>0){let hasAnyActionWithReturnType=false;for(const a of this._actions){a._PostInit();if(a.HasReturnType())hasAnyActionWithReturnType=
true}if(hasAnyActionWithReturnType){this._RunActions=this._RunActions_ReturnValue;this._DebugRunActions=this._DebugRunActions_ReturnValue}else{this._RunActions=this._RunActions_Fast;this._DebugRunActions=this._DebugRunActions_Fast}}const subEvents=this._subEvents;for(let i=0,len=subEvents.length;i<len;++i){const hasElseBlock=i<len-1&&subEvents[i+1]instanceof C3.EventBlock&&subEvents[i+1].IsElseBlock();subEvents[i]._PostInit(hasElseBlock)}if(this._debugData)this._UpdateCanRunFast();if(this._perfRecord)this._GetPerfRecordParent()._GetPerfRecord().children.push(this._perfRecord)}_GetPerfRecord(){return this._perfRecord}_GetPerfRecordParent(){let p=
this.GetParent();while(p){if(p.IsGroup())return p;p=p.GetParent()}return this._eventSheet}_UpdateCanRunFast(){const dd=this._debugData;dd.canRunAllConditionsFast=this._conditions.every(c=>c.DebugCanRunFast());dd.canRunAllActionsFast=this._actions.every(a=>a.DebugCanRunFast());dd.canRunAllSubEventsFast=this._subEvents.every(s=>s.DebugCanRunFast());dd.canRunSelfFast=dd.canRunAllConditionsFast&&dd.canRunAllActionsFast&&dd.canRunAllSubEventsFast}_UpdateCanRunFastRecursive(){let e=this;do{e._UpdateCanRunFast();
e=e.GetParent()}while(e)}_IdentifyTopLevelGroup(){if(!this.IsGroup())return;let p=this.GetParent();this._isTopLevelGroup=true;while(p){if(!p.IsGroup()){this._isTopLevelGroup=false;break}p=p.GetParent()}}_IdentifySolModifiersIncludingParents(){const allObjectClasses=this._runtime.GetAllObjectClasses();if(this._solModifiers===allObjectClasses)this._solModifiersIncludingParents=allObjectClasses;else{this._solModifiersIncludingParents=C3.cloneArray(this._solModifiers);let p=this.GetParent();while(p){for(const o of p._solModifiers)this._AddParentSolModifier(o);
p=p.GetParent()}const eventSheetManager=this.GetEventSheetManager();this._solModifiers=eventSheetManager._DeduplicateSolModifierList(this._solModifiers);this._solModifiersIncludingParents=eventSheetManager._DeduplicateSolModifierList(this._solModifiersIncludingParents)}}_IdentifyTriggerParents(){if(!this.HasAnyTriggeredCondition())return;this._triggerParents=[];let p=this.GetParent();while(p){this._triggerParents.push(p);p=p.GetParent()}this._triggerParents.reverse()}SetSolWriterAfterCnds(){this._isSolWriterAfterCnds=
true;if(this._parent)this._parent.SetSolWriterAfterCnds()}IsSolWriterAfterCnds(){return this._isSolWriterAfterCnds}GetSolModifiers(){return this._solModifiers}GetSolModifiersIncludingParents(){if(!this._hasGotSolModifiersIncludingParents){this._hasGotSolModifiersIncludingParents=true;this._IdentifySolModifiersIncludingParents()}return this._solModifiersIncludingParents}HasSolModifier(objectClass){return this._solModifiers.includes(objectClass)}GetTriggerParents(){return this._triggerParents}GetEventSheet(){return this._eventSheet}GetEventSheetManager(){return this._eventSheet.GetEventSheetManager()}GetRuntime(){return this._runtime}GetParent(){return this._parent}_SetScopeParent(p){this._scopeParent=
p}GetScopeParent(){return this._scopeParent||this._parent}GetDisplayNumber(){return this._displayNumber}IsDebugBreakable(){return this._debugData&&this._debugData.isBreakable}IsDebugBreakpoint(){return this.IsDebugBreakable()&&this._debugData.isBreakpoint}_SetDebugBreakpoint(b){this._debugData.isBreakpoint=!!b;this._UpdateCanRunFastRecursive()}IsGroup(){return this._isGroup}IsTopLevelGroup(){return this._isTopLevelGroup}IsElseBlock(){return this._isElseBlock}HasElseBlock(){return this._hasElseBlock}GetGroupName(){return this._groupName}IsGroupActive(){return this._isGroupActive}ResetInitialActivation(){this.SetGroupActive(this._isInitiallyActive)}SetGroupActive(a){a=
!!a;if(!this._isGroup)throw new Error("not a group");if(this._isGroupActive===a)return;this._isGroupActive=a;for(const include of this._containedIncludes)include.UpdateActive();if(this._containedIncludes.length){const currentLayout=this._runtime.GetCurrentLayout();const mainEventSheet=currentLayout.GetEventSheet();if(mainEventSheet)mainEventSheet._UpdateDeepIncludes()}}GetSID(){return this._sid}IsOrBlock(){return this._isOrBlock}IsTrigger(){return this._conditions.length&&this._conditions[0].IsTrigger()}IsForFunctionBlock(){return this._scopeParent&&
this._scopeParent instanceof C3.FunctionBlock}HasAnyTriggeredCondition(){return this.IsForFunctionBlock()||this._conditions.some(c=>c.IsTrigger())}GetConditions(){return this._conditions}GetConditionCount(){return this._conditions.length}GetConditionAt(i){i=Math.floor(i);if(i<0||i>=this._conditions.length)throw new RangeError("invalid condition index");return this._conditions[i]}GetConditionByDebugIndex(i){return this.GetConditionAt(i)}IsFirstConditionOfType(cnd){let i=cnd.GetIndex();if(i===0)return true;
--i;for(;i>=0;--i)if(this._conditions[i].GetObjectClass()===cnd.GetObjectClass())return false;return true}GetActions(){return this._actions}GetActionCount(){return this._actions.length}GetActionAt(i){i=Math.floor(i);if(i<0||i>=this._actions.length)throw new RangeError("invalid action index");return this._actions[i]}GetActionByDebugIndex(i){i=Math.floor(i);const ret=this._actions.find(a=>a.GetDebugIndex()===i);if(!ret)throw new RangeError("invalid action debug index");return ret}_HasActionIndex(i){i=
Math.floor(i);return i>=0&&i<this._actions.length}GetSubEvents(){return this._subEvents}_GetAllLocalVariablesInScope(){return this._subEvents.filter(e=>e instanceof C3.EventVariable)}RunPreTrigger(frame){frame.SetCurrentEvent(this);let isAnyTrue=false;const conditions=this._conditions;for(let i=0,len=conditions.length;i<len;++i){const c=conditions[i];frame.SetConditionIndex(i);if(c.IsLooping())throw new Error("trigger cannot be used as sub-event to a loop");if(c.Run())isAnyTrue=true;else if(!this._isOrBlock)return false}return this._isOrBlock?
isAnyTrue:true}RunOrBlockTrigger(frame,index){frame.SetCurrentEvent(this);if(this._conditions[index].Run()){if(this._RunActions(frame,0))this._RunSubEvents(frame);frame.SetLastEventTrue(true)}}*DebugRunPreTrigger(frame){frame.SetCurrentEvent(this);let isAnyTrue=false;const conditions=this._conditions;for(let i=0,len=conditions.length;i<len;++i){const c=conditions[i];frame.SetConditionIndex(i);if(c.IsLooping())throw new Error("trigger cannot be used as sub-event to a loop");let ret;if(c.DebugCanRunFast())ret=
c.Run();else ret=yield*c.DebugRun();if(ret)isAnyTrue=true;else if(!this._isOrBlock)return false}return this._isOrBlock?isAnyTrue:true}*DebugRunOrBlockTrigger(frame,index){frame.SetCurrentEvent(this);const c=this._conditions[index];let ret;if(c.DebugCanRunFast())ret=c.Run();else ret=yield*c.DebugRun();if(ret){let actRet;if(this.DebugCanRunActionsFast())actRet=this._RunActions(frame,0);else actRet=yield*this._DebugRunActions(frame,0);if(actRet)if(this.DebugCanRunSubEventsFast())this._RunSubEvents();
else yield*this._DebugRunSubEvents();frame.SetLastEventTrue(true)}}Run(frame){frame.SetCurrentEvent(this);if(!this._isElseBlock)frame.SetElseBranchRan(false);if(this._isOrBlock)this._RunOrBlock(frame);else this._RunAndBlock(frame)}*DebugRun(frame){if(this.IsDebugBreakpoint()||this._runtime.DebugBreakNext())yield this;frame.SetCurrentEvent(this);if(!this._isElseBlock)frame.SetElseBranchRan(false);if(this._isOrBlock)yield*this._DebugRunOrBlock(frame);else yield*this._DebugRunAndBlock(frame)}_RunOrBlock(frame){const conditions=
this._conditions;let isAnyTrue=conditions.length===0;for(let i=0,len=conditions.length;i<len;++i){const c=conditions[i];if(c.IsTrigger())continue;frame.SetConditionIndex(i);const result=c.Run();isAnyTrue=isAnyTrue||result}frame.SetLastEventTrue(isAnyTrue);if(isAnyTrue){if(this._RunActions(frame,0))this._RunSubEvents(frame);if(this._hasElseBlock)frame.SetElseBranchRan(true)}}*_DebugRunOrBlock(frame){const conditions=this._conditions;let isAnyTrue=conditions.length===0;for(let i=0,len=conditions.length;i<
len;++i){const c=conditions[i];if(c.IsTrigger())continue;frame.SetConditionIndex(i);let ret;if(c.DebugCanRunFast())ret=c.Run();else ret=yield*c.DebugRun();isAnyTrue=isAnyTrue||ret}frame.SetLastEventTrue(isAnyTrue);if(isAnyTrue){let actRet;if(this.DebugCanRunActionsFast())actRet=this._RunActions(frame,0);else actRet=yield*this._DebugRunActions(frame,0);if(actRet)if(this.DebugCanRunSubEventsFast())this._RunSubEvents();else yield*this._DebugRunSubEvents();if(this._hasElseBlock)frame.SetElseBranchRan(true)}}_RunAndBlock(frame){const conditions=
this._conditions;for(let i=0,len=conditions.length;i<len;++i){const c=conditions[i];frame.SetConditionIndex(i);const result=c.Run();if(!result){frame.SetLastEventTrue(false);return}}frame.SetLastEventTrue(true);if(this._RunActions(frame,0))this._RunSubEvents(frame);if(frame.GetLastEventTrue()&&this._hasElseBlock)frame.SetElseBranchRan(true)}*_DebugRunAndBlock(frame){const conditions=this._conditions;for(let i=0,len=conditions.length;i<len;++i){const c=conditions[i];frame.SetConditionIndex(i);let ret;
if(c.DebugCanRunFast())ret=c.Run();else ret=yield*c.DebugRun();if(!ret){frame.SetLastEventTrue(false);return}}frame.SetLastEventTrue(true);let actRet;if(this.DebugCanRunActionsFast())actRet=this._RunActions(frame,0);else actRet=yield*this._DebugRunActions(frame,0);if(actRet)if(this.DebugCanRunSubEventsFast())this._RunSubEvents();else yield*this._DebugRunSubEvents();if(frame.GetLastEventTrue()&&this._hasElseBlock)frame.SetElseBranchRan(true)}_RunActions_Fast(frame,startIndex){const actions=this._actions;
for(let i=startIndex,len=actions.length;i<len;++i){const a=actions[i];frame.SetActionIndex(i);a.Run()}return true}*_DebugRunActions_Fast(frame,startIndex){const actions=this._actions;for(let i=startIndex,len=actions.length;i<len;++i){const a=actions[i];frame.SetActionIndex(i);if(a.DebugCanRunFast())a.Run();else yield*a.DebugRun()}return true}_RunActions_ReturnValue(frame,startIndex){const eventSheetManager=this.GetEventSheetManager();const actions=this._actions;for(let i=startIndex,len=actions.length;i<
len;++i){const a=actions[i];frame.SetActionIndex(i);const ret=a.Run();if(a.CanBailOut()&&ret===true)return false;else if(a.IsAsync()&&ret instanceof Promise)eventSheetManager.AddAsyncActionPromise(ret)}return true}*_DebugRunActions_ReturnValue(frame,startIndex){const eventSheetManager=this.GetEventSheetManager();const actions=this._actions;for(let i=startIndex,len=actions.length;i<len;++i){const a=actions[i];frame.SetActionIndex(i);let ret;if(a.DebugCanRunFast())ret=a.Run();else ret=yield*a.DebugRun();
if(a.CanBailOut()&&ret===true)return false;else if(a.IsAsync()&&ret instanceof Promise)eventSheetManager.AddAsyncActionPromise(ret)}return true}_ResumeActionsAndSubEvents(frame){if(this._RunActions(frame,frame.GetActionIndex()))this._RunSubEvents()}*_DebugResumeActionsAndSubEvents(frame){if(yield*this._DebugRunActions(frame,frame.GetActionIndex()))yield*this._DebugRunSubEvents()}_RunSubEvents(){if(!this._subEvents.length)return;const profile=this.IsGroup()&&this._runtime.IsCPUProfiling();const startTime=
profile?performance.now():0;const eventStack=this._eventStack;const frame=eventStack.Push(this);if(this._isSolWriterAfterCnds)this._RunSubEvents_SolWriterAfterCnds(frame);else this._RunSubEvents_Fast(frame);eventStack.Pop();if(profile)this._perfRecord.totalTimeCounter+=performance.now()-startTime}_RunSubEvents_SolWriterAfterCnds(frame){const isGroup=this._isGroup;const isTopLevelGroup=this._isTopLevelGroup;const eventSheetManager=this.GetEventSheetManager();const subEvents=this._subEvents;for(let i=
0,len=subEvents.length,last=len-1;i<len;++i){const e=subEvents[i];const solModifiers=e.GetSolModifiers();const copySol=!isTopLevelGroup||!isGroup&&i<last;if(copySol)eventSheetManager.PushCopySol(solModifiers);e.Run(frame);if(copySol)eventSheetManager.PopSol(solModifiers);else eventSheetManager.ClearSol(solModifiers)}}_RunSubEvents_Fast(frame){const subEvents=this._subEvents;for(let i=0,len=subEvents.length;i<len;++i)subEvents[i].Run(frame)}*_DebugRunSubEvents(){if(!this._subEvents.length)return;const eventStack=
this._eventStack;const frame=eventStack.Push(this);if(this._isSolWriterAfterCnds)yield*this._DebugRunSubEvents_SolWriterAfterCnds(frame);else yield*this._DebugRunSubEvents_Fast(frame);eventStack.Pop()}*_DebugRunSubEvents_SolWriterAfterCnds(frame){const isGroup=this._isGroup;const isTopLevelGroup=this._isTopLevelGroup;const eventSheetManager=this.GetEventSheetManager();const subEvents=this._subEvents;for(let i=0,len=subEvents.length,last=len-1;i<len;++i){const e=subEvents[i];const solModifiers=e.GetSolModifiers();
const copySol=!isTopLevelGroup||!isGroup&&i<last;if(copySol)eventSheetManager.PushCopySol(solModifiers);yield*e.DebugRun(frame);if(copySol)eventSheetManager.PopSol(solModifiers);else eventSheetManager.ClearSol(solModifiers)}}*_DebugRunSubEvents_Fast(frame){const subEvents=this._subEvents;for(let i=0,len=subEvents.length;i<len;++i)yield*subEvents[i].DebugRun(frame)}Retrigger(oldFrame,newFrame){this._runtime.IncrementExecCount();newFrame.ResetQuick();const conditions=this._conditions;if(!this.IsOrBlock())for(let i=
oldFrame.GetConditionIndex()+1,len=conditions.length;i<len;++i){const c=conditions[i];newFrame.SetConditionIndex(i);const result=c.Run();if(!result)return false}if(this._RunActions(newFrame,0))this._RunSubEvents(newFrame);return true}*DebugRetrigger(oldFrame,newFrame){this._runtime.IncrementExecCount();newFrame.ResetQuick();const conditions=this._conditions;if(!this.IsOrBlock())for(let i=oldFrame.GetConditionIndex()+1,len=conditions.length;i<len;++i){const c=conditions[i];newFrame.SetConditionIndex(i);
let ret;if(c.DebugCanRunFast())ret=c.Run();else ret=yield*c.DebugRun();if(!ret)return false}let actRet;if(this.DebugCanRunActionsFast())actRet=this._RunActions(newFrame,0);else actRet=yield*this._DebugRunActions(newFrame,0);if(actRet)if(this.DebugCanRunSubEventsFast())this._RunSubEvents();else yield*this._DebugRunSubEvents();return true}DebugCanRunFast(){return!this.IsDebugBreakpoint()&&!this._runtime.DebugBreakNext()&&this._debugData.canRunSelfFast}DebugCanRunActionsFast(){return!this._runtime.DebugBreakNext()&&
this._debugData.canRunAllActionsFast}DebugCanRunSubEventsFast(){return!this._runtime.DebugBreakNext()&&this._debugData.canRunAllSubEventsFast}_CheckParentsOKToRun(frame){if(this.GetParent()){const parents=this.GetTriggerParents();for(let i=0,len=parents.length;i<len;++i)if(!parents[i].RunPreTrigger(frame))return false}return true}*_DebugCheckParentsOKToRun(frame){if(this.GetParent()){const parents=this.GetTriggerParents();for(let i=0,len=parents.length;i<len;++i)if(!(yield*parents[i].DebugRunPreTrigger(frame)))return false}return true}_EvaluateFunctionCallParameters(eventSheetManager,
parameters,isRecursive){if(parameters.length>0)if(isRecursive){const paramResults=parameters.map(p=>p.Get(0));eventSheetManager.GetLocalVarStack().Push();this._scopeParent.SetFunctionParameters(paramResults)}else this._scopeParent.EvaluateFunctionParameters(parameters);else if(isRecursive)eventSheetManager.GetLocalVarStack().Push()}RunAsFunctionCall(combinedSolModifiers,parameters){let ret;let asyncId;const hasAnySolModifiers=combinedSolModifiers.length>0;const runtime=this._runtime;const eventStack=
this._eventStack;const eventSheetManager=runtime.GetEventSheetManager();const triggerDepth=eventSheetManager._IncTriggerDepth();const isRecursive=triggerDepth>1;this._EvaluateFunctionCallParameters(eventSheetManager,parameters,isRecursive);if(hasAnySolModifiers)eventSheetManager.PushCleanSol(combinedSolModifiers);const frame=eventStack.Push(this);if(this._CheckParentsOKToRun(frame)){runtime.IncrementExecCount();frame.SetCurrentEvent(this);const isAsync=this._scopeParent.IsAsync();if(isAsync)[asyncId,
ret]=this._scopeParent.StartAsyncFunctionCall();this._RunAndBlock(frame);if(isAsync)this._scopeParent.MaybeFinishAsyncFunctionCall(asyncId)}eventStack.Pop();if(isRecursive)eventSheetManager.GetLocalVarStack().Pop();if(hasAnySolModifiers)eventSheetManager.PopSol(combinedSolModifiers);eventSheetManager._DecTriggerDepth();return ret}*DebugRunAsFunctionCall(combinedSolModifiers,parameters){let ret;let asyncId;if(this.IsDebugBreakpoint()||this._runtime.DebugBreakNext())yield this;const hasAnySolModifiers=
combinedSolModifiers.length>0;const runtime=this._runtime;const eventStack=this._eventStack;const eventSheetManager=runtime.GetEventSheetManager();const triggerDepth=eventSheetManager._IncTriggerDepth();const isRecursive=triggerDepth>1;this._EvaluateFunctionCallParameters(eventSheetManager,parameters,isRecursive);if(hasAnySolModifiers)eventSheetManager.PushCleanSol(combinedSolModifiers);const frame=eventStack.Push(this);if(yield*this._DebugCheckParentsOKToRun(frame)){runtime.IncrementExecCount();
frame.SetCurrentEvent(this);const isAsync=this._scopeParent.IsAsync();if(isAsync)[asyncId,ret]=this._scopeParent.StartAsyncFunctionCall();yield*this._DebugRunAndBlock(frame);if(isAsync)this._scopeParent.MaybeFinishAsyncFunctionCall(asyncId)}eventStack.Pop();if(isRecursive)eventSheetManager.GetLocalVarStack().Pop();if(hasAnySolModifiers)eventSheetManager.PopSol(combinedSolModifiers);eventSheetManager._DecTriggerDepth();return ret}RunAsMappedFunctionCall(paramResults){const solModifiers=this.GetSolModifiersIncludingParents();
const hasAnySolModifiers=solModifiers.length>0;const runtime=this._runtime;const eventStack=this._eventStack;const eventSheetManager=runtime.GetEventSheetManager();const triggerDepth=eventSheetManager._IncTriggerDepth();const isRecursive=triggerDepth>1;if(isRecursive)eventSheetManager.GetLocalVarStack().Push();this._scopeParent.SetFunctionParameters(paramResults);if(hasAnySolModifiers)eventSheetManager.PushCleanSol(solModifiers);const frame=eventStack.Push(this);if(this._CheckParentsOKToRun(frame)){runtime.IncrementExecCount();
frame.SetCurrentEvent(this);this._RunAndBlock(frame)}eventStack.Pop();if(isRecursive)eventSheetManager.GetLocalVarStack().Pop();if(hasAnySolModifiers)eventSheetManager.PopSol(solModifiers);eventSheetManager._DecTriggerDepth()}*DebugRunAsMappedFunctionCall(paramResults){if(this.IsDebugBreakpoint()||this._runtime.DebugBreakNext())yield this;const solModifiers=this.GetSolModifiersIncludingParents();const hasAnySolModifiers=solModifiers.length>0;const runtime=this._runtime;const eventStack=this._eventStack;
const eventSheetManager=runtime.GetEventSheetManager();const triggerDepth=eventSheetManager._IncTriggerDepth();const isRecursive=triggerDepth>1;if(isRecursive)eventSheetManager.GetLocalVarStack().Push();this._scopeParent.SetFunctionParameters(paramResults);if(hasAnySolModifiers)eventSheetManager.PushCleanSol(solModifiers);const frame=eventStack.Push(this);if(yield*this._DebugCheckParentsOKToRun(frame)){runtime.IncrementExecCount();frame.SetCurrentEvent(this);yield*this._DebugRunAndBlock(frame)}eventStack.Pop();
if(isRecursive)eventSheetManager.GetLocalVarStack().Pop();if(hasAnySolModifiers)eventSheetManager.PopSol(solModifiers);eventSheetManager._DecTriggerDepth()}RunAsExpressionFunctionCall(combinedSolModifiers,returnType,defaultReturnValue,...paramResults){let ret;let asyncId;const hasAnySolModifiers=combinedSolModifiers.length>0;const runtime=this._runtime;const eventStack=this._eventStack;const eventSheetManager=runtime.GetEventSheetManager();const triggerDepth=eventSheetManager._IncTriggerDepth();const isRecursive=
triggerDepth>1;if(isRecursive)eventSheetManager.GetLocalVarStack().Push();if(paramResults.length>0)this._scopeParent.SetFunctionParameters(paramResults);if(hasAnySolModifiers)eventSheetManager.PushCleanSol(combinedSolModifiers);const frame=eventStack.Push(this);frame.InitCallFunctionExpression(returnType,defaultReturnValue);eventStack.PushExpFunc(frame);runtime.SetDebuggingEnabled(false);if(this._CheckParentsOKToRun(frame)){runtime.IncrementExecCount();frame.SetCurrentEvent(this);const isAsync=this._scopeParent.IsAsync();
if(isAsync)[asyncId,ret]=this._scopeParent.StartAsyncFunctionCall();this._RunAndBlock(frame);if(isAsync)this._scopeParent.MaybeFinishAsyncFunctionCall(asyncId)}runtime.SetDebuggingEnabled(true);eventStack.Pop();eventStack.PopExpFunc();if(isRecursive)eventSheetManager.GetLocalVarStack().Pop();if(hasAnySolModifiers)eventSheetManager.PopSol(combinedSolModifiers);eventSheetManager._DecTriggerDepth();return ret||frame.GetFunctionReturnValue()}}};


// c3/events/eventScript.js
'use strict';{const C3=self.C3;const EMPTY_SOL_MODIFIERS=[];let hadUserScriptException=false;C3.EventScript=class EventScript extends C3.DefendedBase{constructor(eventSheet,parent,data){super();const runtime=eventSheet.GetRuntime();const eventSheetManager=eventSheet.GetEventSheetManager();this._eventSheet=eventSheet;this._eventSheetManager=eventSheetManager;this._runtime=eventSheet.GetRuntime();this._parent=parent;const userMethod=runtime.GetObjectReference(data[1]);this._func=userMethod;this._displayNumber=
data[2];this._eventSheet._RegisterEventByDisplayNumber(this,this._displayNumber);this._debugData=runtime.IsDebug()?{isBreakpoint:data[3][0],isBreakable:data[3][1]}:null}static Create(eventSheet,parent,data){return C3.New(C3.EventScript,eventSheet,parent,data)}_PostInit(){const userMethod=this._func;const localVars=this._runtime.GetEventSheetManager()._GetLocalVariablesScriptInterface(this);this._func=userMethod.bind(null,this._runtime.GetIRuntime(),localVars)}GetParent(){return this._parent}GetScopeParent(){return this._parent}GetEventSheet(){return this._eventSheet}GetDisplayNumber(){return this._displayNumber}IsDebugBreakable(){return this._debugData&&
this._debugData.isBreakable}IsDebugBreakpoint(){return this.IsDebugBreakable()&&this._debugData.isBreakpoint}_SetDebugBreakpoint(b){this._debugData.isBreakpoint=!!b}IsElseBlock(){return false}GetSolModifiers(){return EMPTY_SOL_MODIFIERS}GetSolModifiersIncludingParents(){if(this._parent)return this._parent.GetSolModifiersIncludingParents();else return EMPTY_SOL_MODIFIERS}Run(frame){frame.SetCurrentEvent(this);this._eventSheetManager.AddAsyncActionPromise(this._RunUserScript())}async _RunUserScript(){try{await this._func()}catch(err){console.error(`Unhandled exception running script %c${this.GetEventSheet().GetName()}, event ${this.GetDisplayNumber()}:`,
"font-size: 1.2em; font-weight: bold;",err);if(self.C3Debugger)self.C3Debugger._SetLastErrorScript(this);if(!hadUserScriptException){console.info(`%cTip:%c run this to highlight in Construct the last script that had an error: %cgoToLastErrorScript()`,"font-weight: bold; text-decoration: underline","","font-weight: bold");hadUserScriptException=true}}}*DebugRun(frame){frame.SetCurrentEvent(this);if(this.IsDebugBreakpoint()||this._runtime.DebugBreakNext())yield this;this.Run(frame)}DebugCanRunFast(){return!this.IsDebugBreakpoint()&&
!this._runtime.DebugBreakNext()}static HadUserScriptException(){return hadUserScriptException}static SetHadUserScriptException(){hadUserScriptException=true}}};


// c3/events/functionBlock.js
'use strict';{const C3=self.C3;const assert=self.assert;C3.FunctionBlock=class FunctionBlock extends C3.DefendedBase{constructor(eventSheet,parent,data){super();this._eventSheet=eventSheet;this._runtime=eventSheet.GetRuntime();this._parent=parent;const funcData=data[1];this._functionName=funcData[0];this._returnType=funcData[1];this._functionParameters=funcData[2].map(paramData=>C3.EventVariable.Create(eventSheet,this,paramData));this._isEnabled=funcData[3];this._innerLocalVariables=[];this._isAsync=
funcData[4];this._nextAsyncId=0;this._currentAsyncId=-1;this._asyncMap=new Map;this._eventBlock=C3.EventBlock.Create(eventSheet,parent,data);this._eventBlock._SetScopeParent(this)}static Create(eventSheet,parent,data){return C3.New(C3.FunctionBlock,eventSheet,parent,data)}_PostInit(){for(const fp of this._functionParameters)fp._PostInit();this._eventBlock._PostInit(false)}_GetAllLocalVariablesInScope(){return this._functionParameters}GetFunctionParameters(){return this._functionParameters}GetFunctionParameterCount(){return this._functionParameters.length}_RegisterLocalVariable(localVariable){this._innerLocalVariables.push(localVariable)}_GetAllInnerLocalVariables(){return this._innerLocalVariables}EvaluateFunctionParameters(parameters){const functionParameters=
this._functionParameters;for(let i=0,len=functionParameters.length;i<len;++i)functionParameters[i].SetValue(parameters[i].Get(0))}SetFunctionParameters(paramResults){const functionParameters=this._functionParameters;for(let i=0,len=functionParameters.length;i<len;++i)functionParameters[i].SetValue(paramResults[i])}CaptureFunctionParameters(){return this._functionParameters.map(p=>p.GetValue())}GetParent(){return this._parent}GetScopeParent(){return this._parent}GetFunctionName(){return this._functionName}GetReturnType(){return this._returnType}IsEnabled(){return this._isEnabled}GetDefaultReturnValue(){switch(this._returnType){case 0:return null;
case 2:return"";default:return 0}}GetEventBlock(){return this._eventBlock}IsAsync(){return this._isAsync}StartAsyncFunctionCall(){const asyncId=this._nextAsyncId++;this._currentAsyncId=asyncId;let resolve;const promise=new Promise(r=>resolve=r);this._asyncMap.set(asyncId,{resolve,pauseCount:0});return[asyncId,promise]}MaybeFinishAsyncFunctionCall(asyncId){const info=this._asyncMap.get(asyncId);if(info.pauseCount===0){info.resolve();this._asyncMap.delete(asyncId)}this._currentAsyncId=-1}PauseCurrentAsyncFunction(){const info=
this._asyncMap.get(this._currentAsyncId);info.pauseCount++;return this._currentAsyncId}ResumeAsyncFunction(asyncId){this._currentAsyncId=asyncId;const info=this._asyncMap.get(asyncId);info.pauseCount--}}};


// c3/events/eventVariable.js
'use strict';{const C3=self.C3;const EMPTY_SOL_MODIFIERS=[];C3.EventVariable=class EventVariable extends C3.DefendedBase{constructor(eventSheet,parent,data){super();const eventSheetManager=eventSheet.GetEventSheetManager();this._eventSheet=eventSheet;this._eventSheetManager=eventSheetManager;this._runtime=eventSheet.GetRuntime();this._parent=parent;this._localVarStack=eventSheetManager.GetLocalVarStack();this._name=data[1];this._type=data[2];this._initialValue=data[3];this._isStatic=!!data[4];this._isConstant=
!!data[5];this._isFunctionParameter=parent instanceof C3.FunctionBlock;this._sid=data[6];this._jsPropName=this._runtime.GetJsPropName(data[8]);this._scriptSetter=v=>this.SetValue(v);this._scriptGetter=()=>this.GetValue();this._hasSingleValue=!this._parent||this._isStatic||this._isConstant;this._value=this._initialValue;this._localIndex=-1;if(this.IsBoolean())this._value=this._value?1:0;if(this.IsLocal()&&!this.IsStatic()&&!this.IsConstant())this._localIndex=eventSheetManager._GetNextLocalVarIndex(this);
eventSheetManager._RegisterEventVariable(this)}static Create(eventSheet,parent,data){return C3.New(C3.EventVariable,eventSheet,parent,data)}_PostInit(){if(this.IsLocal()&&!this.IsStatic()&&!this.IsConstant()&&!this.IsFunctionParameter()){const functionBlock=this._eventSheetManager.FindFirstFunctionBlockParent(this);if(functionBlock)functionBlock._RegisterLocalVariable(this)}}GetName(){return this._name}GetJsPropName(){return this._jsPropName}GetParent(){return this._parent}GetScopeParent(){return this.GetParent()}IsGlobal(){return!this.GetParent()}IsLocal(){return!this.IsGlobal()}IsFunctionParameter(){return this._isFunctionParameter}IsStatic(){return this._isStatic}IsConstant(){return this._isConstant}IsNumber(){return this._type===
0}IsString(){return this._type===1}IsBoolean(){return this._type===2}IsElseBlock(){return false}GetSID(){return this._sid}GetInitialValue(){return this._initialValue}GetSolModifiers(){return EMPTY_SOL_MODIFIERS}Run(frame){if(this.IsLocal()&&!this.IsStatic()&&!this.IsConstant())this.SetValue(this.GetInitialValue())}DebugCanRunFast(){return true}*DebugRun(frame){this.Run(frame)}SetValue(v){if(this.IsNumber()){if(typeof v!=="number")v=parseFloat(v)}else if(this.IsString()){if(typeof v!=="string")v=v.toString()}else if(this.IsBoolean())v=
v?1:0;if(this._hasSingleValue)this._value=v;else this._localVarStack.GetCurrent()[this._localIndex]=v}GetValue(){return this._hasSingleValue?this._value:this._localVarStack.GetCurrent()[this._localIndex]}GetTypedValue(){let ret=this.GetValue();if(this.IsBoolean())ret=!!ret;return ret}ResetToInitialValue(){this._value=this._initialValue}_GetScriptInterfaceDescriptor(){return{configurable:false,enumerable:true,get:this._scriptGetter,set:this._scriptSetter}}}};


// c3/events/eventInclude.js
'use strict';{const C3=self.C3;const assert=self.assert;const EMPTY_SOL_MODIFIERS=[];C3.EventInclude=class EventInclude extends C3.DefendedBase{constructor(eventSheet,parent,data){super();const eventSheetManager=eventSheet.GetEventSheetManager();this._eventSheet=eventSheet;this._eventSheetManager=eventSheetManager;this._runtime=eventSheet.GetRuntime();this._parent=parent;this._includeSheet=null;this._includeSheetName=data[1];this._isActive=true}static Create(eventSheet,parent,data){return C3.New(C3.EventInclude,
eventSheet,parent,data)}_PostInit(){this._includeSheet=this._eventSheetManager.GetEventSheetByName(this._includeSheetName);this._eventSheet._AddShallowInclude(this);let p=this.GetParent();while(p){if(p instanceof C3.EventBlock&&p.IsGroup())p._AddContainedInclude(this);p=p.GetParent()}this.UpdateActive();if(this._runtime.IsDebug())this._eventSheet._GetPerfRecord().children.push(this._includeSheet._GetPerfRecord())}GetParent(){return this._parent}GetSolModifiers(){return EMPTY_SOL_MODIFIERS}GetIncludeSheet(){return this._includeSheet}Run(frame){const pushSol=
!!this.GetParent();const allObjectClasses=this._runtime.GetAllObjectClasses();if(pushSol)this._eventSheetManager.PushCleanSol(allObjectClasses);this._includeSheet.Run();if(pushSol)this._eventSheetManager.PopSol(allObjectClasses)}*DebugRun(frame){const pushSol=!!this.GetParent();const allObjectClasses=this._runtime.GetAllObjectClasses();if(pushSol)this._eventSheetManager.PushCleanSol(allObjectClasses);yield*this._includeSheet.DebugRun();if(pushSol)this._eventSheetManager.PopSol(allObjectClasses)}DebugCanRunFast(){return false}IsActive(){return this._isActive}UpdateActive(){let p=
this.GetParent();while(p){if(p instanceof C3.EventBlock&&p.IsGroup()&&!p.IsGroupActive()){this._isActive=false;return}p=p.GetParent()}this._isActive=true}}};


// c3/events/expNode.js
'use strict';{const C3=self.C3;const assert=self.assert;C3.ExpNode=class ExpNode extends C3.DefendedBase{constructor(owner){super();this._owner=owner;this._runtime=owner.GetRuntime()}_PostInit(){}static CreateNode(owner,data){const type=data[0];const Classes=[BehaviorExpressionNode,ObjectExpressionNode,InstVarExpressionNode,EventVarExpNode,SystemExpressionExpNode,CallFunctionExpressionExpNode];return C3.New(Classes[type],owner,data)}};class SystemExpressionExpNode extends C3.ExpNode{constructor(owner,
data){super(owner);this._systemPlugin=this._runtime.GetSystemPlugin();this._func=this._runtime.GetObjectReference(data[1]);if(this._func===C3.Plugins.System.Exps.random||this._func===C3.Plugins.System.Exps.choose)this._owner.SetVariesPerInstance()}GetBoundMethod(){return this._systemPlugin._GetBoundACEMethod(this._func,this._systemPlugin)}}class CallFunctionExpressionExpNode extends C3.ExpNode{constructor(owner,data){super(owner);this._functionBlock=null;this._functionName=data[1];this._owner.SetVariesPerInstance()}_PostInit(){const eventSheetManager=
this._runtime.GetEventSheetManager();this._functionBlock=eventSheetManager.GetFunctionBlockByName(this._functionName);this._functionName=null;const myEventBlock=this._owner.GetEventBlock();const callEventBlock=this._functionBlock.GetEventBlock();this._combinedSolModifiers=[...(new Set([...myEventBlock.GetSolModifiersIncludingParents(),...callEventBlock.GetSolModifiersIncludingParents()]))];this._combinedSolModifiers=eventSheetManager._DeduplicateSolModifierList(this._combinedSolModifiers)}GetBoundMethod(){const functionBlock=
this._functionBlock;if(functionBlock.IsEnabled()){const callEventBlock=functionBlock.GetEventBlock();return C3.EventBlock.prototype.RunAsExpressionFunctionCall.bind(callEventBlock,this._combinedSolModifiers,functionBlock.GetReturnType(),functionBlock.GetDefaultReturnValue())}else{const defaultReturnValue=functionBlock.GetDefaultReturnValue();return()=>defaultReturnValue}}}function WrapIndex(index,len){if(index>=len)return index%len;else if(index<0){if(index<=-len)index%=len;if(index<0)index+=len;
return index}else return index}class ObjectExpressionNode extends C3.ExpNode{constructor(owner,data){super(owner);this._objectClass=this._runtime.GetObjectClassByIndex(data[1]);this._func=this._runtime.GetObjectReference(data[2]);this._returnsString=!!data[3];this._eventStack=this._runtime.GetEventSheetManager().GetEventStack();this._owner._MaybeVaryFor(this._objectClass)}GetBoundMethod(){return this._objectClass.GetPlugin()._GetBoundACEMethod(this._func,this._objectClass.GetSingleGlobalInstance().GetSdkInstance())}ExpObject(...args){const objectClass=
this._objectClass;const instances=objectClass.GetCurrentSol().GetExpressionInstances();const len=instances.length;if(len===0)return this._returnsString?"":0;const index=WrapIndex(this._owner.GetSolIndex(),len);this._eventStack.GetCurrentStackFrame().SetExpressionObjectClass(objectClass);return this._func.apply(instances[index].GetSdkInstance(),args)}ExpObject_InstExpr(instIndex,...args){const objectClass=this._objectClass;const instances=objectClass.GetInstances();const len=instances.length;if(len===
0)return this._returnsString?"":0;const index=WrapIndex(instIndex,len);this._eventStack.GetCurrentStackFrame().SetExpressionObjectClass(objectClass);return this._func.apply(instances[index].GetSdkInstance(),args)}}class InstVarExpressionNode extends C3.ExpNode{constructor(owner,data){super(owner);this._objectClass=this._runtime.GetObjectClassByIndex(data[1]);this._varIndex=data[3];this._returnsString=!!data[2];this._owner._MaybeVaryFor(this._objectClass)}ExpInstVar(){const instances=this._objectClass.GetCurrentSol().GetExpressionInstances();
const len=instances.length;if(len===0)return this._returnsString?"":0;const index=WrapIndex(this._owner.GetSolIndex(),len);return instances[index]._GetInstanceVariableValueUnchecked(this._varIndex)}ExpInstVar_Family(){const objectClass=this._objectClass;const instances=objectClass.GetCurrentSol().GetExpressionInstances();const len=instances.length;if(len===0)return this._returnsString?"":0;const index=WrapIndex(this._owner.GetSolIndex(),len);const inst=instances[index];const offset=inst.GetObjectClass().GetFamilyInstanceVariableOffset(objectClass.GetFamilyIndex());
return inst._GetInstanceVariableValueUnchecked(this._varIndex+offset)}ExpInstVar_InstExpr(instIndex){const objectClass=this._objectClass;const instances=objectClass.GetInstances();const len=instances.length;if(len===0)return this._returnsString?"":0;const index=WrapIndex(instIndex,len);const inst=instances[index];let offset=0;if(objectClass.IsFamily())offset=inst.GetObjectClass().GetFamilyInstanceVariableOffset(objectClass.GetFamilyIndex());return inst._GetInstanceVariableValueUnchecked(this._varIndex+
offset)}}class BehaviorExpressionNode extends C3.ExpNode{constructor(owner,data){super(owner);this._objectClass=this._runtime.GetObjectClassByIndex(data[1]);this._behaviorType=this._objectClass.GetBehaviorTypeByName(data[2]);this._behaviorIndex=this._objectClass.GetBehaviorIndexByName(data[2]);this._func=this._runtime.GetObjectReference(data[3]);this._returnsString=!!data[4];this._eventStack=this._runtime.GetEventSheetManager().GetEventStack();this._owner._MaybeVaryFor(this._objectClass)}ExpBehavior(...args){const objectClass=
this._objectClass;const instances=objectClass.GetCurrentSol().GetExpressionInstances();const len=instances.length;if(len===0)return this._returnsString?"":0;const index=WrapIndex(this._owner.GetSolIndex(),len);this._eventStack.GetCurrentStackFrame().SetExpressionObjectClass(objectClass);const inst=instances[index];let offset=0;if(objectClass.IsFamily())offset=inst.GetObjectClass().GetFamilyBehaviorOffset(objectClass.GetFamilyIndex());return this._func.apply(inst.GetBehaviorInstances()[this._behaviorIndex+
offset].GetSdkInstance(),args)}ExpBehavior_InstExpr(instIndex,...args){const objectClass=this._objectClass;const instances=objectClass.GetInstances();const len=instances.length;if(len===0)return this._returnsString?"":0;const index=WrapIndex(instIndex,len);this._eventStack.GetCurrentStackFrame().SetExpressionObjectClass(objectClass);const inst=instances[index];let offset=0;if(objectClass.IsFamily())offset=inst.GetObjectClass().GetFamilyBehaviorOffset(objectClass.GetFamilyIndex());return this._func.apply(inst.GetBehaviorInstances()[this._behaviorIndex+
offset].GetSdkInstance(),args)}}class EventVarExpNode extends C3.ExpNode{constructor(owner,data){super(owner);this._eventVar=null;this._eventVarSid=data[1]}_PostInit(){this._eventVar=this._runtime.GetEventSheetManager().GetEventVariableBySID(this._eventVarSid)}GetVar(){return this._eventVar}}};


// c3/events/parameter.js
'use strict';{const C3=self.C3;const assert=self.assert;C3.Parameter=class Parameter extends C3.DefendedBase{constructor(owner,type,index){super();this._owner=owner;this._index=index;this._type=type;this.Get=null;this._variesPerInstance=false;this._isConstant=false}static Create(owner,data,index){const type=data[0];const Classes=[ExpressionParameter,StringExpressionParameter,FileParameter,ComboParameter,ObjectParameter,LayerExpressionParameter,LayoutParameter,ExpressionParameter,ComboParameter,ComboParameter,
InstVarParameter,EventVarParameter,FileParameter,VariadicParameter,StringExpressionParameter,TimelineParameter,BooleanParameter,FunctionParameter,EaseParameter];return C3.New(Classes[type],owner,type,index,data)}_PostInit(){}SetVariesPerInstance(){this._variesPerInstance=true}_MaybeVaryFor(objectClass){if(this._variesPerInstance)return;if(!objectClass)return;if(!objectClass.GetPlugin().IsSingleGlobal())this._variesPerInstance=true}VariesPerInstance(){return this._variesPerInstance}GetIndex(){return this._index}GetRuntime(){return this._owner.GetRuntime()}GetEventBlock(){return this._owner.GetEventBlock()}IsConstant(){return this._isConstant}};
function GetExpressionFunc(number){const ret=self.C3_ExpressionFuncs[number];if(!ret)throw new Error("invalid expression number");return ret}class ExpressionParameter extends C3.Parameter{constructor(owner,type,index,data){super(owner,type,index);this._solIndex=0;const expData=data[1];this._expressionNumber=expData[0];this._numberedNodes=[];this._expressionFunc=null;for(let i=1,len=expData.length;i<len;++i)this._numberedNodes.push(C3.ExpNode.CreateNode(this,expData[i]));if(this._numberedNodes.length)this.Get=
this.GetExpression;else{this.Get=GetExpressionFunc(this._expressionNumber);this._isConstant=true}}_GetNode(i){if(i<0||i>=this._numberedNodes.length)throw new RangeError("invalid numbered node");return this._numberedNodes[i]}_PostInit(){for(const node of this._numberedNodes)node._PostInit();const func=GetExpressionFunc(this._expressionNumber);if(this._numberedNodes.length)this._expressionFunc=func(this);else this._expressionFunc=func}GetSolIndex(){return this._solIndex}GetExpression(solIndex){this._solIndex=
solIndex;return this._expressionFunc()}}class StringExpressionParameter extends ExpressionParameter{constructor(owner,type,index,data){super(owner,type,index,data);this.Get=this.GetStringExpression;if(type===14){this.GetEventBlock().SetAllSolModifiers();if(this._owner instanceof C3.Action)this.GetEventBlock().SetSolWriterAfterCnds()}}GetStringExpression(solIndex){this._solIndex=solIndex;const ret=this._expressionFunc();if(typeof ret==="string")return ret;else return""}_GetFastTriggerValue(){return GetExpressionFunc(this._expressionNumber)()}}
class LayerExpressionParameter extends ExpressionParameter{constructor(owner,type,index,data){super(owner,type,index,data);this.Get=this.GetLayer;this._isConstant=false}GetLayer(solIndex){this._solIndex=solIndex;const ret=this._expressionFunc();const layout=this.GetRuntime().GetCurrentLayout();return layout.GetLayer(ret)}}class ComboParameter extends C3.Parameter{constructor(owner,type,index,data){super(owner,type,index);this._combo=data[1];this.Get=this.GetCombo;this._isConstant=true}GetCombo(){return this._combo}}
class BooleanParameter extends C3.Parameter{constructor(owner,type,index,data){super(owner,type,index);this._bool=data[1];this.Get=this.GetBoolean;this._isConstant=true}GetBoolean(){return this._bool}}class ObjectParameter extends C3.Parameter{constructor(owner,type,index,data){super(owner,type,index);this._objectClass=this.GetRuntime().GetObjectClassByIndex(data[1]);this.Get=this.GetObjectClass;const eventBlock=this.GetEventBlock();eventBlock._AddSolModifier(this._objectClass);if(this._owner instanceof
C3.Action)eventBlock.SetSolWriterAfterCnds();else if(eventBlock.GetParent())eventBlock.GetParent().SetSolWriterAfterCnds();this._isConstant=true}GetObjectClass(){return this._objectClass}}class LayoutParameter extends C3.Parameter{constructor(owner,type,index,data){super(owner,type,index);this._layout=this.GetRuntime().GetLayoutManager().GetLayoutByName(data[1]);this.Get=this.GetLayout;this._isConstant=true}GetLayout(){return this._layout}}class TimelineParameter extends C3.Parameter{constructor(owner,
type,index,data){super(owner,type,index);this._timeline=this.GetRuntime().GetTimelineManager().GetTimelineByName(data[1]);this.Get=this.GetTimeline;this._isConstant=true}GetTimeline(){return this._timeline}}class FileParameter extends C3.Parameter{constructor(owner,type,index,data){super(owner,type,index);this._fileInfo=data[1];this.Get=this.GetFile;this._isConstant=true}GetFile(){return this._fileInfo}}class InstVarParameter extends C3.Parameter{constructor(owner,type,index,data){super(owner,type,
index);this._instVarIndex=data[1];const ownerObjectClass=this._owner.GetObjectClass();if(ownerObjectClass&&ownerObjectClass.IsFamily()){this.Get=this.GetFamilyInstanceVariable;this.SetVariesPerInstance()}else{this.Get=this.GetInstanceVariable;this._isConstant=true}}GetInstanceVariable(){return this._instVarIndex}GetFamilyInstanceVariable(solIndex){solIndex=solIndex||0;const familyType=this._owner.GetObjectClass();const sol=familyType.GetCurrentSol();const instances=sol.GetInstances();let realType=
null;if(instances.length)realType=instances[solIndex%instances.length].GetObjectClass();else if(sol.HasAnyElseInstances()){const elseInstances=sol.GetElseInstances();realType=elseInstances[solIndex%elseInstances.length].GetObjectClass()}else if(familyType.GetInstanceCount()>0){const familyInstances=familyType.GetInstances();realType=familyInstances[solIndex%familyInstances.length].GetObjectClass()}else return 0;return this._instVarIndex+realType.GetFamilyInstanceVariableOffset(familyType.GetFamilyIndex())}}
class EventVarParameter extends C3.Parameter{constructor(owner,type,index,data){super(owner,type,index);this._eventVarSid=data[1];this._eventVar=null;this.Get=this.GetEventVariable;this._isConstant=true}_PostInit(){this._eventVar=this.GetRuntime().GetEventSheetManager().GetEventVariableBySID(this._eventVarSid)}GetEventVariable(){return this._eventVar}}class FunctionParameter extends C3.Parameter{constructor(owner,type,index,data){super(owner,type,index);this._functionBlockName=data[1];this._functionBlock=
null;this.Get=this.GetFunction;this._isConstant=true}_PostInit(){this._functionBlock=this.GetRuntime().GetEventSheetManager().GetFunctionBlockByName(this._functionBlockName);this._functionBlockName=null}GetFunction(){return this._functionBlock}}class VariadicParameter extends C3.Parameter{constructor(owner,type,index,data){super(owner,type,index);this._subParams=[];this._variadicRet=[];this._isConstant=true;for(let i=1,len=data.length;i<len;++i){const subParam=C3.Parameter.Create(this._owner,data[i],
0);this._subParams.push(subParam);this._variadicRet.push(0);if(!subParam.IsConstant())this._isConstant=false}this.Get=this.GetVariadic}_PostInit(){for(const subParam of this._subParams)subParam._PostInit()}GetVariadic(){const subParams=this._subParams;const variadicRet=this._variadicRet;for(let i=0,len=subParams.length;i<len;++i)variadicRet[i]=subParams[i].Get(0);return variadicRet}}class EaseParameter extends C3.Parameter{constructor(owner,type,index,data){super(owner,type,index);this._easeIndex=
data[1];this.Get=this.GetEase;this._isConstant=true}GetEase(){return this._easeIndex}}};


// c3/events/condition.js
'use strict';{const C3=self.C3;const assert=self.assert;function EvalParams(parameters,results){for(let i=0,len=parameters.length;i<len;++i)results[i]=parameters[i].Get(0)}const EMPTY_PARAMS_ARRAY=[];const noop=function(){};C3.Condition=class Condition extends C3.DefendedBase{constructor(eventBlock,data,index){super();this._eventBlock=eventBlock;this._runtime=eventBlock.GetRuntime();this._index=index;this._func=this._runtime.GetObjectReference(data[1]);this._isTrigger=data[3]>0;this._isFastTrigger=
data[3]===2;this._isLooping=!!data[4];this._isInverted=!!data[5];this._isStatic=!!data[6];this._sid=data[7];this._isInOrBlock=this._eventBlock.IsOrBlock();this._objectClass=null;this._behaviorType=null;this._behaviorIndex=-1;this._systemPlugin=null;this.Run=noop;this.DebugRun=noop;this._parameters=[];this._results=[];this._anyParamVariesPerInstance=false;this._savedData=null;this._unsavedData=null;this._debugData=this._runtime.IsDebug()?{isBreakpoint:data[8][0],canDebug:data[8][1]}:null;if(data[0]===
-1)this._systemPlugin=this._runtime.GetSystemPlugin();else{this._objectClass=this._runtime.GetObjectClassByIndex(data[0]);if(data[2]){this._behaviorType=this._objectClass.GetBehaviorTypeByName(data[2]);this._behaviorIndex=this._objectClass.GetBehaviorIndexByName(data[2])}if(this._eventBlock.GetParent())this._eventBlock.GetParent().SetSolWriterAfterCnds()}if(data.length===10){let paramData=data[9];for(let data of paramData){this._parameters.push(C3.Parameter.Create(this,data,this._parameters.length));
this._results.push(0)}}if(this._parameters.length===0){this._parameters=EMPTY_PARAMS_ARRAY;this._results=EMPTY_PARAMS_ARRAY}this._eventBlock.GetEventSheetManager()._RegisterCondition(this)}static Create(eventBlock,data,index){return C3.New(C3.Condition,eventBlock,data,index)}_PostInit(){for(const param of this._parameters){param._PostInit();if(param.VariesPerInstance())this._anyParamVariesPerInstance=true}if(this._isFastTrigger){this.Run=this._RunFastTrigger;this.DebugRun=this._DebugRunFastTrigger}else if(this._systemPlugin){this._SetSystemRunMethod();
this.DebugRun=this._DebugRunSystem}else if(this._objectClass.GetPlugin().IsSingleGlobal()){this._SetSingleGlobalRunMethod();this.DebugRun=this._DebugRunSingleGlobal}else if(this._isStatic){this.Run=this._RunStatic;this.DebugRun=this._DebugRunStatic}else{this.Run=this._RunObject;this.DebugRun=this._DebugRunObject}}_SetSystemRunMethod(){const plugin=this._systemPlugin;const bindThis=this._systemPlugin;this._SetRunMethodForBoundFunc(plugin,bindThis,this._RunSystem)}_SetSingleGlobalRunMethod(){const plugin=
this._objectClass.GetPlugin();const bindThis=this._objectClass.GetSingleGlobalInstance().GetSdkInstance();this._SetRunMethodForBoundFunc(plugin,bindThis,this._RunSingleGlobal)}_SetRunMethodForBoundFunc(plugin,bindThis,fallbackMethod){const func=this._func;const isInverted=this._isInverted;const parameters=this._parameters;if(parameters.length===0){const boundFunc=plugin._GetBoundACEMethod(func,bindThis);if(isInverted)this.Run=function RunSingleCnd_0param(){return C3.xor(boundFunc(),isInverted)};else this.Run=
boundFunc}else if(parameters.length===1){const param0=parameters[0];if(!isInverted&&param0.IsConstant())this.Run=plugin._GetBoundACEMethod_1param(func,bindThis,param0.Get(0));else{const boundFunc=plugin._GetBoundACEMethod(func,bindThis);this.Run=function RunSingleCnd_1param(){return C3.xor(boundFunc(param0.Get(0)),isInverted)}}}else if(parameters.length===2){const param0=parameters[0];const param1=parameters[1];if(!isInverted&&param0.IsConstant()&&param1.IsConstant())this.Run=plugin._GetBoundACEMethod_2params(func,
bindThis,param0.Get(0),param1.Get(0));else{const boundFunc=plugin._GetBoundACEMethod(func,bindThis);this.Run=function RunSingleCnd_2params(){return C3.xor(boundFunc(param0.Get(0),param1.Get(0)),isInverted)}}}else if(parameters.length===3){const param0=parameters[0];const param1=parameters[1];const param2=parameters[2];if(!isInverted&&param0.IsConstant()&&param1.IsConstant()&&param2.IsConstant())this.Run=plugin._GetBoundACEMethod_3params(func,bindThis,param0.Get(0),param1.Get(0),param2.Get(0));else{const boundFunc=
plugin._GetBoundACEMethod(func,bindThis);this.Run=function RunSingleCnd_3params(){return C3.xor(boundFunc(param0.Get(0),param1.Get(0),param2.Get(0)),isInverted)}}}else this.Run=fallbackMethod}GetSID(){return this._sid}_GetFunc(){return this._func}GetObjectClass(){return this._objectClass}GetBehaviorType(){return this._behaviorType}GetEventBlock(){return this._eventBlock}GetRuntime(){return this._runtime}GetIndex(){return this._index}GetDebugIndex(){return this.GetIndex()}IsTrigger(){return this._isTrigger}IsFastTrigger(){return this._isFastTrigger}IsInverted(){return this._isInverted}IsLooping(){return this._isLooping}IsBreakpoint(){return this._debugData.isBreakpoint}_SetBreakpoint(b){this._debugData.isBreakpoint=
!!b;this._eventBlock._UpdateCanRunFastRecursive()}_DebugReturnsGenerator(){return this._debugData.canDebug}DebugCanRunFast(){return!this.IsBreakpoint()&&!this._runtime.DebugBreakNext()&&!this._DebugReturnsGenerator()}GetSavedDataMap(){if(!this._savedData)this._savedData=new Map;return this._savedData}GetUnsavedDataMap(){if(!this._unsavedData)this._unsavedData=new Map;return this._unsavedData}_RunSystem(){const results=this._results;EvalParams(this._parameters,results);return C3.xor(this._func.apply(this._systemPlugin,
results),this._isInverted)}*_DebugRunSystem(){if(this.IsBreakpoint()||this._runtime.DebugBreakNext())yield this;if(this._DebugReturnsGenerator()){const results=this._results;EvalParams(this._parameters,results);let ret=this._func.apply(this._systemPlugin,results);if(C3.IsIterator(ret))ret=yield*ret;return C3.xor(ret,this._isInverted)}else return this.Run()}_RunSingleGlobal(){const results=this._results;EvalParams(this._parameters,results);const inst=this._objectClass.GetSingleGlobalInstance().GetSdkInstance();
return C3.xor(this._func.apply(inst,results),this._isInverted)}*_DebugRunSingleGlobal(){if(this.IsBreakpoint()||this._runtime.DebugBreakNext())yield this;if(this._DebugReturnsGenerator()){const results=this._results;EvalParams(this._parameters,results);const inst=this._objectClass.GetSingleGlobalInstance().GetSdkInstance();let ret=this._func.apply(inst,results);if(C3.IsIterator(ret))ret=yield*ret;return C3.xor(ret,this._isInverted)}else return this.Run()}_RunFastTrigger(){return true}*_DebugRunFastTrigger(){if(this.IsBreakpoint()||
this._runtime.DebugBreakNext())yield this;return true}_RunStatic(){const results=this._results;EvalParams(this._parameters,results);const ret=this._func.apply(this._behaviorType||this._objectClass,results);this._objectClass.ApplySolToContainer();return ret}*_DebugRunStatic(){if(this.IsBreakpoint()||this._runtime.DebugBreakNext())yield this;if(this._DebugReturnsGenerator()){const results=this._results;EvalParams(this._parameters,results);let ret=this._func.apply(this._behaviorType||this._objectClass,
results);if(C3.IsIterator(ret))ret=yield*ret;this._objectClass.ApplySolToContainer();return ret}else return this.Run()}_RunObject(){const parameters=this._parameters;const results=this._results;const sol=this._objectClass.GetCurrentSol();for(let i=0,len=parameters.length;i<len;++i){const p=parameters[i];if(!p.VariesPerInstance())results[i]=p.Get(0)}if(sol.IsSelectAll())return this._RunObject_FirstFilter(sol);else return this._RunObject_NextFilter(sol)}*_DebugRunObject(){if(this.IsBreakpoint()||this._runtime.DebugBreakNext())yield this;
return this._RunObject()}_EvaluateVaryingParameters(solIndex){const parameters=this._parameters;const results=this._results;for(let i=0,len=parameters.length;i<len;++i){const p=parameters[i];if(p.VariesPerInstance())results[i]=p.Get(solIndex)}}_RunObject_FirstFilter(sol){const objectClass=this._objectClass;const isFamily=objectClass.IsFamily();const familyIndex=objectClass.GetFamilyIndex();const behaviorIndex=this._behaviorIndex;const isBehavior=behaviorIndex>=0;const allInstances=objectClass.GetInstances();
const paramsVary=this._anyParamVariesPerInstance;const results=this._results;const func=this._func;const isInverted=this._isInverted;const isInOrBlock=this._isInOrBlock&&!this._isTrigger;sol.ClearArrays();for(let i=0,len=allInstances.length;i<len;++i){const inst=allInstances[i];if(paramsVary)this._EvaluateVaryingParameters(i);let ret;if(isBehavior){const offset=isFamily?inst.GetObjectClass().GetFamilyBehaviorOffset(familyIndex):0;ret=func.apply(inst.GetBehaviorInstances()[behaviorIndex+offset].GetSdkInstance(),
results)}else ret=func.apply(inst.GetSdkInstance(),results);if(C3.xor(ret,isInverted))sol._PushInstance(inst);else if(isInOrBlock)sol._PushElseInstance(inst)}objectClass.FinishCondition(true);sol._SetSelectAll(false);objectClass.ApplySolToContainer();return sol.HasAnyInstances()}_RunObject_NextFilter(sol){const objectClass=this._objectClass;const isFamily=objectClass.IsFamily();const familyIndex=objectClass.GetFamilyIndex();const isInContainer=objectClass.IsInContainer();const behaviorIndex=this._behaviorIndex;
const isBehavior=behaviorIndex>=0;const paramsVary=this._anyParamVariesPerInstance;const results=this._results;const func=this._func;const isInverted=this._isInverted;const isInOrBlock=this._isInOrBlock&&!this._isTrigger;const solInstances=sol._GetOwnInstances();const solElseInstances=sol._GetOwnElseInstances();const isUsingElseInstances=isInOrBlock&&!this._eventBlock.IsFirstConditionOfType(this);const arr=isUsingElseInstances?solElseInstances:solInstances;let k=0;let isAnyTrue=false;for(let i=0,
len=arr.length;i<len;++i){const inst=arr[i];if(paramsVary)this._EvaluateVaryingParameters(i);let ret;if(isBehavior){const offset=isFamily?inst.GetObjectClass().GetFamilyBehaviorOffset(familyIndex):0;ret=func.apply(inst.GetBehaviorInstances()[behaviorIndex+offset].GetSdkInstance(),results)}else ret=func.apply(inst.GetSdkInstance(),results);if(C3.xor(ret,isInverted)){isAnyTrue=true;if(isUsingElseInstances){solInstances.push(inst);if(isInContainer)inst._PushSiblingsToSolInstances()}else{arr[k]=inst;
if(isInContainer)inst._SetSiblingsToSolInstancesIndex(k);++k}}else if(isUsingElseInstances){arr[k]=inst;if(isInContainer)inst._SetSiblingsToSolElseInstancesIndex(k);++k}else if(isInOrBlock){solElseInstances.push(inst);if(isInContainer)inst._PushSiblingsToSolElseInstances()}}C3.truncateArray(arr,k);if(isInContainer)objectClass._TruncateContainerSols(isUsingElseInstances,k);const pickInFinish=isAnyTrue;if(isUsingElseInstances&&!isAnyTrue)isAnyTrue=this._OrBlockCheckInstances(solInstances);objectClass.FinishCondition(pickInFinish||
isInOrBlock);return isInOrBlock?isAnyTrue:sol.HasAnyInstances()}_OrBlockCheckInstances(solInstances){const objectClass=this._objectClass;const isFamily=objectClass.IsFamily();const familyIndex=objectClass.GetFamilyIndex();const paramsVary=this._anyParamVariesPerInstance;const behaviorIndex=this._behaviorIndex;const isBehavior=behaviorIndex>=0;const results=this._results;const func=this._func;const isInverted=this._isInverted;for(let i=0,len=solInstances.length;i<len;++i){const inst=solInstances[i];
if(paramsVary)this._EvaluateVaryingParameters(i);let ret;if(isBehavior){const offset=isFamily?inst.GetObjectClass().GetFamilyBehaviorOffset(familyIndex):0;ret=func.apply(inst.GetBehaviorInstances()[behaviorIndex+offset].GetSdkInstance(),results)}else ret=func.apply(inst.GetSdkInstance(),results);if(C3.xor(ret,isInverted))return true}return false}ReevaluateParameter(paramIndex,solIndex){return this._parameters[paramIndex].Get(solIndex)}GetFastTriggerValue(){const parameters=this._parameters;if(!parameters.length)throw new Error("no parameters");
return parameters[0]._GetFastTriggerValue()}_SaveToJson(){if(!this._savedData||!this._savedData.size)return null;const ex={};for(const [k,v]of this._savedData.entries()){let saveVal=v;if(k==="collmemory")saveVal=[...v.entries()].map(arr=>[arr[0].GetUID(),arr[1].GetUID(),arr[2]]);ex[k]=saveVal}return{"ex":ex}}_LoadFromJson(o){if(this._savedData){this._savedData.clear();this._savedData=null}if(!o)return;const runtime=this._runtime;const ex=o["ex"];if(ex){const map=this.GetSavedDataMap();map.clear();
for(const [k,v]of Object.entries(ex)){let loadVal=v;if(k==="collmemory")loadVal=C3.New(C3.PairMap,v.map(arr=>[runtime.GetInstanceByUID(arr[0]),runtime.GetInstanceByUID(arr[1]),arr[2]]).filter(arr=>arr[0]&&arr[1]));map.set(k,loadVal)}}}}};


// c3/events/action.js
'use strict';{const C3=self.C3;const assert=self.assert;function EvalParams(parameters,results){for(let i=0,len=parameters.length;i<len;++i)results[i]=parameters[i].Get(0)}const EMPTY_PARAMS_ARRAY=[];const noop=function(){};const noopGenerator=function*(){};C3.Action=class Action extends C3.DefendedBase{constructor(eventBlock,data,index){super();this._eventBlock=eventBlock;const runtime=eventBlock.GetRuntime();this._runtime=runtime;this._index=index;this._sid=data.length>=4?data[3]:-1;this._actionReturnType=
data.length>=5?data[4]:0;this._func=null;this._objectClass=null;this._behaviorType=null;this._behaviorIndex=-1;this._systemPlugin=null;this._callFunctionName="";this._callEventBlock=null;this._combinedSolModifiers=null;this.Run=noop;this.DebugRun=noop;this._parameters=[];this._results=[];this._anyParamVariesPerInstance=false;this._savedData=null;this._unsavedData=null;const isScript=data[0]===-3;const debugInfo=isScript?data[2]:data[5];this._debugData=runtime.IsDebug()||isScript?{isBreakpoint:debugInfo[0],
canDebug:debugInfo[1],index:debugInfo[2]}:null;if(data[0]===-1){this._systemPlugin=runtime.GetSystemPlugin();this._func=runtime.GetObjectReference(data[1])}else if(data[0]===-2)this._callFunctionName=data[1];else if(isScript){const userMethod=runtime.GetObjectReference(data[1]);this._func=userMethod;this.Run=this.RunUserScript;this.DebugRun=this.DebugRunUserScript;this._actionReturnType=1}else{this._func=runtime.GetObjectReference(data[1]);this._objectClass=runtime.GetObjectClassByIndex(data[0]);
if(data[2]){this._behaviorType=this._objectClass.GetBehaviorTypeByName(data[2]);this._behaviorIndex=this._objectClass.GetBehaviorIndexByName(data[2])}}if(data.length===7){const paramData=data[6];for(const data of paramData){this._parameters.push(C3.Parameter.Create(this,data,this._parameters.length));this._results.push(0)}}if(this._parameters.length===0){this._parameters=EMPTY_PARAMS_ARRAY;this._results=EMPTY_PARAMS_ARRAY}this._eventBlock.GetEventSheetManager()._RegisterAction(this)}static Create(eventBlock,
data,index){return C3.New(C3.Action,eventBlock,data,index)}_PostInit(){for(const param of this._parameters){param._PostInit();if(param.VariesPerInstance())this._anyParamVariesPerInstance=true}if(this._systemPlugin){this._SetSystemRunMethod();this.DebugRun=this._DebugRunSystem}else if(this._callFunctionName){this._SetCallFunctionRunMethod();this._callFunctionName=""}else if(this.Run===this.RunUserScript){const userMethod=this._func;const localVars=this._runtime.GetEventSheetManager()._GetLocalVariablesScriptInterface(this._eventBlock);
this._func=userMethod.bind(null,this._runtime.GetIRuntime(),localVars)}else if(this._behaviorType)if(this.IsAsync()){this.Run=this._RunBehavior_Async;this.DebugRun=this._DebugRunBehavior_Async}else{this.Run=this._RunBehavior;this.DebugRun=this._DebugRunBehavior}else if(this._objectClass.GetPlugin().IsSingleGlobal()){this._SetSingleGlobalRunMethod();this.DebugRun=this._DebugRunSingleGlobal}else if(this.IsAsync()){this.Run=this._RunObject_Async;this.DebugRun=this._DebugRunObject_Async}else if(!this._parameters.length){this.Run=
this._RunObject_ParamsConst;this.DebugRun=this._DebugRunObject_ParamsConst}else if(this._parameters.every(p=>p.VariesPerInstance())){this.Run=this._RunObject_AllParamsVary;this.DebugRun=this._DebugRunObject_AllParamsVary}else if(this._anyParamVariesPerInstance){this.Run=this._RunObject_SomeParamsVary;this.DebugRun=this._DebugRunObject_SomeParamsVary}else if(this._parameters.every(p=>p.IsConstant())){EvalParams(this._parameters,this._results);this.Run=this._RunObject_ParamsConst;this.DebugRun=this._DebugRunObject_ParamsConst}else{this.Run=
this._RunObject_ParamsDontVary;this.DebugRun=this._DebugRunObject_ParamsDontVary}}_SetSystemRunMethod(){const plugin=this._systemPlugin;const bindThis=this._systemPlugin;this._SetRunMethodForBoundFunc(plugin,bindThis,this._RunSystem)}_SetSingleGlobalRunMethod(){const plugin=this._objectClass.GetPlugin();const bindThis=this._objectClass.GetSingleGlobalInstance().GetSdkInstance();this._SetRunMethodForBoundFunc(plugin,bindThis,this._RunSingleGlobal)}_SetCallFunctionRunMethod(){const eventSheetManager=
this._eventBlock.GetEventSheetManager();const functionBlock=eventSheetManager.GetFunctionBlockByName(this._callFunctionName);if(functionBlock.IsEnabled()){this._callEventBlock=functionBlock.GetEventBlock();this._combinedSolModifiers=[...(new Set([...this._eventBlock.GetSolModifiersIncludingParents(),...this._callEventBlock.GetSolModifiersIncludingParents()]))];this._combinedSolModifiers=eventSheetManager._DeduplicateSolModifierList(this._combinedSolModifiers);this.Run=C3.EventBlock.prototype.RunAsFunctionCall.bind(this._callEventBlock,
this._combinedSolModifiers,this._parameters);this.DebugRun=this._DebugRunCallFunction}else{this.Run=noop;this.DebugRun=noopGenerator}}_SetRunMethodForBoundFunc(plugin,bindThis,fallbackMethod){const func=this._func;const parameters=this._parameters;if(parameters.length===0)this.Run=plugin._GetBoundACEMethod(func,bindThis);else if(parameters.length===1){const param0=parameters[0];if(param0.IsConstant())this.Run=plugin._GetBoundACEMethod_1param(func,bindThis,param0.Get(0));else{const boundFunc=plugin._GetBoundACEMethod(func,
bindThis);this.Run=function RunSingleAct_1param(){return boundFunc(param0.Get(0))}}}else if(parameters.length===2){const param0=parameters[0];const param1=parameters[1];if(param0.IsConstant()&&param1.IsConstant())this.Run=plugin._GetBoundACEMethod_2params(func,bindThis,param0.Get(0),param1.Get(0));else{const boundFunc=plugin._GetBoundACEMethod(func,bindThis);this.Run=function RunSingleAct_2params(){return boundFunc(param0.Get(0),param1.Get(0))}}}else if(parameters.length===3){const param0=parameters[0];
const param1=parameters[1];const param2=parameters[2];if(param0.IsConstant()&&param1.IsConstant()&&param2.IsConstant())this.Run=plugin._GetBoundACEMethod_3params(func,bindThis,param0.Get(0),param1.Get(0),param2.Get(0));else{const boundFunc=plugin._GetBoundACEMethod(func,bindThis);this.Run=function RunSingleAct_3params(){return boundFunc(param0.Get(0),param1.Get(0),param2.Get(0))}}}else this.Run=fallbackMethod}GetSID(){return this._sid}IsAsync(){return this._actionReturnType===1}CanBailOut(){return this._actionReturnType===
2}HasReturnType(){return this._actionReturnType!==0}GetObjectClass(){return this._objectClass}GetEventBlock(){return this._eventBlock}GetRuntime(){return this._runtime}GetIndex(){return this._index}GetDebugIndex(){return this._debugData.index}GetCombinedSolModifiers(){return this._combinedSolModifiers}IsBreakpoint(){return this._debugData.isBreakpoint}_SetBreakpoint(b){this._debugData.isBreakpoint=!!b;this._eventBlock._UpdateCanRunFastRecursive()}_DebugReturnsGenerator(){return this._debugData.canDebug}DebugCanRunFast(){return!this.IsBreakpoint()&&
!this._runtime.DebugBreakNext()&&!this._DebugReturnsGenerator()}GetSavedDataMap(){if(!this._savedData)this._savedData=new Map;return this._savedData}GetUnsavedDataMap(){if(!this._unsavedData)this._unsavedData=new Map;return this._unsavedData}_RunSystem(){const results=this._results;EvalParams(this._parameters,results);return this._func.apply(this._systemPlugin,results)}*_DebugRunSystem(){if(this.IsBreakpoint()||this._runtime.DebugBreakNext())yield this;if(this._DebugReturnsGenerator()){const results=
this._results;EvalParams(this._parameters,results);const ret=yield*this._func.apply(this._systemPlugin,results);return ret}else return this.Run()}*_DebugRunCallFunction(){if(this.IsBreakpoint()||this._runtime.DebugBreakNext())yield this;const ret=yield*this._callEventBlock.DebugRunAsFunctionCall(this._combinedSolModifiers,this._parameters);return ret}_RunSingleGlobal(){const results=this._results;EvalParams(this._parameters,results);return this._func.apply(this._objectClass.GetSingleGlobalInstance().GetSdkInstance(),
results)}*_DebugRunSingleGlobal(){if(this.IsBreakpoint()||this._runtime.DebugBreakNext())yield this;if(this._DebugReturnsGenerator()){const results=this._results;EvalParams(this._parameters,results);const ret=yield*this._func.apply(this._objectClass.GetSingleGlobalInstance().GetSdkInstance(),results);return ret}else return this.Run()}_RunObject_ParamsConst(){const results=this._results;const instances=this._objectClass.GetCurrentSol().GetInstances();for(let i=0,len=instances.length;i<len;++i)this._func.apply(instances[i].GetSdkInstance(),
results)}*_DebugRunObject_ParamsConst(){if(this.IsBreakpoint()||this._runtime.DebugBreakNext())yield this;if(this._DebugReturnsGenerator()){const results=this._results;const instances=this._objectClass.GetCurrentSol().GetInstances();for(let i=0,len=instances.length;i<len;++i)yield*this._func.apply(instances[i].GetSdkInstance(),results)}else this._RunObject_ParamsConst()}_RunObject_ParamsDontVary(){const results=this._results;EvalParams(this._parameters,results);const instances=this._objectClass.GetCurrentSol().GetInstances();
for(let i=0,len=instances.length;i<len;++i)this._func.apply(instances[i].GetSdkInstance(),results)}*_DebugRunObject_ParamsDontVary(){if(this.IsBreakpoint()||this._runtime.DebugBreakNext())yield this;if(this._DebugReturnsGenerator()){const results=this._results;EvalParams(this._parameters,results);const instances=this._objectClass.GetCurrentSol().GetInstances();for(let i=0,len=instances.length;i<len;++i)yield*this._func.apply(instances[i].GetSdkInstance(),results)}else this._RunObject_ParamsDontVary()}_RunObject_AllParamsVary(){const parameters=
this._parameters;const results=this._results;const func=this._func;const instances=this._objectClass.GetCurrentSol().GetInstances();for(let i=0,len=instances.length;i<len;++i){const inst=instances[i];for(let j=0,lenj=parameters.length;j<lenj;++j)results[j]=parameters[j].Get(i);func.apply(inst.GetSdkInstance(),results)}}*_DebugRunObject_AllParamsVary(){if(this.IsBreakpoint()||this._runtime.DebugBreakNext())yield this;if(this._DebugReturnsGenerator()){const parameters=this._parameters;const results=
this._results;const func=this._func;const instances=this._objectClass.GetCurrentSol().GetInstances();for(let i=0,len=instances.length;i<len;++i){const inst=instances[i];for(let j=0,lenj=parameters.length;j<lenj;++j)results[j]=parameters[j].Get(i);yield*func.apply(inst.GetSdkInstance(),results)}}else this._RunObject_AllParamsVary()}_RunObject_SomeParamsVary(){const parameters=this._parameters;const results=this._results;const func=this._func;const instances=this._objectClass.GetCurrentSol().GetInstances();
for(let i=0,len=parameters.length;i<len;++i){const p=parameters[i];if(!p.VariesPerInstance())results[i]=p.Get(0)}for(let i=0,len=instances.length;i<len;++i){const inst=instances[i];for(let j=0,lenj=parameters.length;j<lenj;++j){const p=parameters[j];if(p.VariesPerInstance())results[j]=p.Get(i)}func.apply(inst.GetSdkInstance(),results)}}*_DebugRunObject_SomeParamsVary(){if(this.IsBreakpoint()||this._runtime.DebugBreakNext())yield this;if(this._DebugReturnsGenerator()){const parameters=this._parameters;
const results=this._results;const func=this._func;const instances=this._objectClass.GetCurrentSol().GetInstances();for(let i=0,len=parameters.length;i<len;++i){const p=parameters[i];if(!p.VariesPerInstance())results[i]=p.Get(0)}for(let i=0,len=instances.length;i<len;++i){const inst=instances[i];for(let j=0,lenj=parameters.length;j<lenj;++j){const p=parameters[j];if(p.VariesPerInstance())results[j]=p.Get(i)}yield*func.apply(inst.GetSdkInstance(),results)}}else this._RunObject_SomeParamsVary()}_RunBehavior(){const objectClass=
this._objectClass;const isFamily=objectClass.IsFamily();const familyIndex=objectClass.GetFamilyIndex();const parameters=this._parameters;const paramsVary=this._anyParamVariesPerInstance;const results=this._results;const func=this._func;const behaviorIndex=this._behaviorIndex;const instances=objectClass.GetCurrentSol().GetInstances();for(let i=0,len=parameters.length;i<len;++i){const p=parameters[i];if(!p.VariesPerInstance())results[i]=p.Get(0)}for(let i=0,len=instances.length;i<len;++i){const inst=
instances[i];if(paramsVary)for(let j=0,lenj=parameters.length;j<lenj;++j){const p=parameters[j];if(p.VariesPerInstance())results[j]=p.Get(i)}const offset=isFamily?inst.GetObjectClass().GetFamilyBehaviorOffset(familyIndex):0;func.apply(inst.GetBehaviorInstances()[behaviorIndex+offset].GetSdkInstance(),results)}}*_DebugRunBehavior(){if(this.IsBreakpoint()||this._runtime.DebugBreakNext())yield this;if(this._DebugReturnsGenerator()){const objectClass=this._objectClass;const isFamily=objectClass.IsFamily();
const familyIndex=objectClass.GetFamilyIndex();const parameters=this._parameters;const paramsVary=this._anyParamVariesPerInstance;const results=this._results;const func=this._func;const behaviorIndex=this._behaviorIndex;const instances=objectClass.GetCurrentSol().GetInstances();for(let i=0,len=parameters.length;i<len;++i){const p=parameters[i];if(!p.VariesPerInstance())results[i]=p.Get(0)}for(let i=0,len=instances.length;i<len;++i){const inst=instances[i];if(paramsVary)for(let j=0,lenj=parameters.length;j<
lenj;++j){const p=parameters[j];if(p.VariesPerInstance())results[j]=p.Get(i)}const offset=isFamily?inst.GetObjectClass().GetFamilyBehaviorOffset(familyIndex):0;yield*func.apply(inst.GetBehaviorInstances()[behaviorIndex+offset].GetSdkInstance(),results)}}else this._RunBehavior()}_RunObject_Async(){const parameters=this._parameters;const results=this._results;const func=this._func;const instances=this._objectClass.GetCurrentSol().GetInstances();const promises=[];for(let i=0,len=instances.length;i<len;++i){const inst=
instances[i];for(let j=0,lenj=parameters.length;j<lenj;++j)results[j]=parameters[j].Get(i);promises.push(func.apply(inst.GetSdkInstance(),results))}return Promise.all(promises)}*_DebugRunObject_Async(){if(this.IsBreakpoint()||this._runtime.DebugBreakNext())yield this;if(this._DebugReturnsGenerator()){const parameters=this._parameters;const results=this._results;const func=this._func;const instances=this._objectClass.GetCurrentSol().GetInstances();const promises=[];for(let i=0,len=instances.length;i<
len;++i){const inst=instances[i];for(let j=0,lenj=parameters.length;j<lenj;++j)results[j]=parameters[j].Get(i);promises.push(yield*func.apply(inst.GetSdkInstance(),results))}return Promise.all(promises)}else return this._RunObject_Async()}_RunBehavior_Async(){const objectClass=this._objectClass;const isFamily=objectClass.IsFamily();const familyIndex=objectClass.GetFamilyIndex();const parameters=this._parameters;const results=this._results;const func=this._func;const behaviorIndex=this._behaviorIndex;
const instances=objectClass.GetCurrentSol().GetInstances();const promises=[];for(let i=0,len=instances.length;i<len;++i){const inst=instances[i];for(let j=0,lenj=parameters.length;j<lenj;++j)results[j]=parameters[j].Get(i);const offset=isFamily?inst.GetObjectClass().GetFamilyBehaviorOffset(familyIndex):0;promises.push(func.apply(inst.GetBehaviorInstances()[behaviorIndex+offset].GetSdkInstance(),results))}return Promise.all(promises)}*_DebugRunBehavior_Async(){if(this.IsBreakpoint()||this._runtime.DebugBreakNext())yield this;
if(this._DebugReturnsGenerator()){const objectClass=this._objectClass;const isFamily=objectClass.IsFamily();const familyIndex=objectClass.GetFamilyIndex();const parameters=this._parameters;const results=this._results;const func=this._func;const behaviorIndex=this._behaviorIndex;const instances=objectClass.GetCurrentSol().GetInstances();const promises=[];for(let i=0,len=instances.length;i<len;++i){const inst=instances[i];for(let j=0,lenj=parameters.length;j<lenj;++j)results[j]=parameters[j].Get(i);
const offset=isFamily?inst.GetObjectClass().GetFamilyBehaviorOffset(familyIndex):0;promises.push(yield*func.apply(inst.GetBehaviorInstances()[behaviorIndex+offset].GetSdkInstance(),results))}return Promise.all(promises)}else return this._RunBehavior_Async()}async RunUserScript(){try{await this._func()}catch(err){console.error(`Unhandled exception running script %c${this._eventBlock.GetEventSheet().GetName()}, event ${this._eventBlock.GetDisplayNumber()}, action ${this.GetDebugIndex()+1}:`,"font-size: 1.2em; font-weight: bold;",
err);if(self.C3Debugger)self.C3Debugger._SetLastErrorScript(this);if(!C3.EventScript.HadUserScriptException()){console.info(`%cTip:%c run this to highlight in Construct the last script that had an error: %cgoToLastErrorScript()`,"font-weight: bold; text-decoration: underline","","font-weight: bold");C3.EventScript.SetHadUserScriptException()}}}*DebugRunUserScript(){if(this.IsBreakpoint()||this._runtime.DebugBreakNext())yield this;return this.RunUserScript()}_SaveToJson(){if(!this._savedData||!this._savedData.size)return null;
return{"ex":C3.ToSuperJSON(this._savedData)}}_LoadFromJson(o){if(this._savedData){this._savedData.clear();this._savedData=null}if(!o)return;const ex=o["ex"];if(ex)this._savedData=C3.FromSuperJSON(ex)}}};


// c3/events/commonACEs.js
'use strict';{const C3=self.C3;const tempColor=new C3.Color;function CompareX(cmp,x){return C3.compare(this.GetWorldInfo().GetX(),cmp,x)}function CompareY(cmp,y){return C3.compare(this.GetWorldInfo().GetY(),cmp,y)}function IsOnScreen(){const wi=this.GetWorldInfo();return wi.IsInViewport(wi.GetLayer().GetViewport())}function IsOutsideLayout(){const wi=this.GetWorldInfo();const layout=wi.GetLayout();const bbox=wi.GetBoundingBox();return bbox.getRight()<0||bbox.getBottom()<0||bbox.getLeft()>layout.GetWidth()||
bbox.getTop()>layout.GetHeight()}function PickDistance(which,x,y){const sol=this.GetCurrentSol();const instances=sol.GetInstances();if(!instances.length)return false;let inst=instances[0];let wi=inst.GetWorldInfo();let pickme=inst;let dist2=C3.distanceSquared(wi.GetX(),wi.GetY(),x,y);for(let i=1,len=instances.length;i<len;++i){inst=instances[i];wi=inst.GetWorldInfo();const d2=C3.distanceSquared(wi.GetX(),wi.GetY(),x,y);if(which===0&&d2<dist2||which===1&&d2>dist2){dist2=d2;pickme=inst}}sol.PickOne(pickme);
return true}function SetX(x){const wi=this.GetWorldInfo();if(wi.GetX()===x)return;wi.SetX(x);wi.SetBboxChanged()}function SetY(y){const wi=this.GetWorldInfo();if(wi.GetY()===y)return;wi.SetY(y);wi.SetBboxChanged()}function SetPos(x,y){const wi=this.GetWorldInfo();if(wi.EqualsXY(x,y))return;wi.SetXY(x,y);wi.SetBboxChanged()}function SetPosToObject(objectClass,imgPt){if(!objectClass)return;const inst=objectClass.GetPairedInstance(this._inst);if(!inst)return;const [x,y]=inst.GetImagePoint(imgPt);const wi=
this.GetWorldInfo();if(wi.GetX()===x&&wi.GetY()===y)return;wi.SetXY(x,y);wi.SetBboxChanged()}function MoveForward(dist){if(dist===0)return;const wi=this.GetWorldInfo();wi.OffsetXY(wi.GetCosAngle()*dist,wi.GetSinAngle()*dist);wi.SetBboxChanged()}function MoveAtAngle(a,dist){if(dist===0)return;const wi=this.GetWorldInfo();a=C3.toRadians(a);wi.OffsetXY(Math.cos(a)*dist,Math.sin(a)*dist);wi.SetBboxChanged()}function GetX(){return this.GetWorldInfo().GetX()}function GetY(){return this.GetWorldInfo().GetY()}
function GetDt(){return this._runtime.GetDt(this._inst)}function CompareWidth(cmp,w){return C3.compare(this.GetWorldInfo().GetWidth(),cmp,w)}function CompareHeight(cmp,h){return C3.compare(this.GetWorldInfo().GetHeight(),cmp,h)}function SetWidth(w){const wi=this.GetWorldInfo();if(wi.GetWidth()===w)return;wi.SetWidth(w);wi.SetBboxChanged()}function SetHeight(h){const wi=this.GetWorldInfo();if(wi.GetHeight()===h)return;wi.SetHeight(h);wi.SetBboxChanged()}function SetSize(w,h){const wi=this.GetWorldInfo();
if(wi.GetWidth()===w&&wi.GetHeight()===h)return;wi.SetSize(w,h);wi.SetBboxChanged()}function GetWidth(){return this.GetWorldInfo().GetWidth()}function GetHeight(){return this.GetWorldInfo().GetHeight()}function GetBboxLeft(){return this.GetWorldInfo().GetBoundingBox().getLeft()}function GetBboxTop(){return this.GetWorldInfo().GetBoundingBox().getTop()}function GetBboxRight(){return this.GetWorldInfo().GetBoundingBox().getRight()}function GetBboxBottom(){return this.GetWorldInfo().GetBoundingBox().getBottom()}
function IsAngleWithin(within,a){return C3.angleDiff(this.GetWorldInfo().GetAngle(),C3.toRadians(a))<=C3.toRadians(within)}function IsAngleClockwiseFrom(a){return C3.angleClockwise(this.GetWorldInfo().GetAngle(),C3.toRadians(a))}function IsBetweenAngles(a,b){const lower=C3.toRadians(a);const upper=C3.toRadians(b);const angle=this.GetWorldInfo().GetAngle();const obtuse=!C3.angleClockwise(upper,lower);if(obtuse)return!(!C3.angleClockwise(angle,lower)&&C3.angleClockwise(angle,upper));else return C3.angleClockwise(angle,
lower)&&!C3.angleClockwise(angle,upper)}function SetAngle(a){const wi=this.GetWorldInfo();const newAngle=C3.clampAngle(C3.toRadians(a));if(isNaN(newAngle)||wi.GetAngle()===newAngle)return;wi.SetAngle(newAngle);wi.SetBboxChanged()}function RotateClockwise(a){if(isNaN(a)||a===0)return;const wi=this.GetWorldInfo();wi.SetAngle(wi.GetAngle()+C3.toRadians(a));wi.SetBboxChanged()}function RotateCounterclockwise(a){if(isNaN(a)||a===0)return;const wi=this.GetWorldInfo();wi.SetAngle(wi.GetAngle()-C3.toRadians(a));
wi.SetBboxChanged()}function RotateTowardAngle(amt,target){const wi=this.GetWorldInfo();const a=wi.GetAngle();const newAngle=C3.angleRotate(a,C3.toRadians(target),C3.toRadians(amt));if(isNaN(newAngle)||a===newAngle)return;wi.SetAngle(newAngle);wi.SetBboxChanged()}function RotateTowardPosition(amt,x,y){const wi=this.GetWorldInfo();const a=wi.GetAngle();const dx=x-wi.GetX();const dy=y-wi.GetY();const target=Math.atan2(dy,dx);const newAngle=C3.angleRotate(a,target,C3.toRadians(amt));if(isNaN(newAngle)||
a===newAngle)return;wi.SetAngle(newAngle);wi.SetBboxChanged()}function SetTowardPosition(x,y){const wi=this.GetWorldInfo();const a=wi.GetAngle();const dx=x-wi.GetX();const dy=y-wi.GetY();const newAngle=Math.atan2(dy,dx);if(isNaN(newAngle)||a===newAngle)return;wi.SetAngle(newAngle);wi.SetBboxChanged()}function GetAngle(){return C3.toDegrees(this.GetWorldInfo().GetAngle())}function CompareOpacity(cmp,x){return C3.compare(C3.round6dp(this.GetWorldInfo().GetOpacity()*100),cmp,x)}function IsVisible(){return this.GetWorldInfo().IsVisible()}
function SetVisible(v){const wi=this.GetWorldInfo();if(v===2)v=!wi.IsVisible();else v=v!==0;if(wi.IsVisible()===v)return;wi.SetVisible(v);this._runtime.UpdateRender()}function SetOpacity(o){const newOpacity=C3.clamp(o/100,0,1);const wi=this.GetWorldInfo();if(wi.GetOpacity()===newOpacity)return;wi.SetOpacity(newOpacity);this._runtime.UpdateRender()}function SetDefaultColor(rgb){tempColor.setFromRgbValue(rgb);const wi=this.GetWorldInfo();if(wi.GetUnpremultipliedColor().equalsIgnoringAlpha(tempColor))return;
wi.SetUnpremultipliedColor(tempColor);this._runtime.UpdateRender()}function GetColor(){const c=this.GetWorldInfo().GetUnpremultipliedColor();return C3.PackRGBAEx(c.getR(),c.getG(),c.getB(),c.getA())}function GetOpacity(){return C3.round6dp(this.GetWorldInfo().GetOpacity()*100)}function IsOnLayer(layer){if(!layer)return false;return this.GetWorldInfo().GetLayer()===layer}function PickTopBottom(which){const sol=this.GetCurrentSol();const instances=sol.GetInstances();if(!instances.length)return false;
let inst=instances[0];let pickme=inst;for(let i=1,len=instances.length;i<len;++i){const inst=instances[i];const instWi=inst.GetWorldInfo();const pickmeWi=pickme.GetWorldInfo();const instLayerIndex=instWi.GetLayer().GetIndex();const pickmeLayerIndex=pickmeWi.GetLayer().GetIndex();if(which===0){if(instLayerIndex>pickmeLayerIndex||instLayerIndex===pickmeLayerIndex&&instWi.GetZIndex()>pickmeWi.GetZIndex())pickme=inst}else if(instLayerIndex<pickmeLayerIndex||instLayerIndex===pickmeLayerIndex&&instWi.GetZIndex()<
pickmeWi.GetZIndex())pickme=inst}sol.PickOne(pickme);return true}function CompareZElevation(which,cmp,value){const wi=this.GetWorldInfo();const z=which===0?wi.GetZElevation():wi.GetTotalZElevation();return C3.compare(z,cmp,value)}function MoveToTop(){this.GetWorldInfo().ZOrderMoveToTop()}function MoveToBottom(){this.GetWorldInfo().ZOrderMoveToBottom()}function MoveToLayer(layerMove){if(!layerMove)return;this.GetWorldInfo().ZOrderMoveToLayer(layerMove)}function ZMoveToObject(where,objectClass){const isAfter=
where===0;if(!objectClass)return;const otherInst=objectClass.GetFirstPicked(this.GetInstance());if(!otherInst)return;this.GetWorldInfo().ZOrderMoveAdjacentToInstance(otherInst,isAfter)}function SetZElevation(z){const wi=this.GetWorldInfo();if(wi.GetZElevation()===z)return;wi.SetZElevation(z);this._runtime.UpdateRender()}function LayerNumber(){return this.GetWorldInfo().GetLayer().GetIndex()}function LayerName(){return this.GetWorldInfo().GetLayer().GetName()}function ZIndex(){return this.GetWorldInfo().GetZIndex()}
function ZElevation(){return this.GetWorldInfo().GetZElevation()}function TotalZElevation(){return this.GetWorldInfo().GetTotalZElevation()}function SetEffectEnabled(enabled,effectName){const effectType=this.GetObjectClass().GetEffectList().GetEffectTypeByName(effectName);if(!effectType)return;const effectTypeIndex=effectType.GetIndex();const e=enabled===1;const instFxList=this.GetWorldInfo().GetInstanceEffectList();if(instFxList.IsEffectIndexActive(effectTypeIndex)===e)return;instFxList.SetEffectIndexActive(effectTypeIndex,
e);instFxList.UpdateActiveEffects();this._runtime.UpdateRender()}function SetEffectParam(effectName,paramIndex,value){const effectType=this.GetObjectClass().GetEffectList().GetEffectTypeByName(effectName);if(!effectType)return;const effectTypeIndex=effectType.GetIndex();const instFxList=this.GetWorldInfo().GetInstanceEffectList();const paramsArr=instFxList.GetEffectParametersForIndex(effectTypeIndex);paramIndex=Math.floor(paramIndex);if(paramIndex<0||paramIndex>=paramsArr.length)return;const paramType=
effectType.GetShaderProgram().GetParameterType(paramIndex);if(paramType==="color"){tempColor.setFromRgbValue(value);const curColor=paramsArr[paramIndex];if(tempColor.equalsIgnoringAlpha(curColor))return;curColor.copyRgb(tempColor)}else{if(paramType==="percent")value/=100;if(paramsArr[paramIndex]===value)return;paramsArr[paramIndex]=value}if(instFxList.IsEffectIndexActive(effectTypeIndex))this._runtime.UpdateRender()}function HasParent(){return this.GetWorldInfo().HasParent()}function HasChildren(){return this.GetWorldInfo().HasChildren()}
function PickParent(parentObjectClass,which){const mySol=this.GetCurrentSol();const myInstances=mySol.GetInstances();if(myInstances.length===0)return false;const parentSol=parentObjectClass.GetCurrentSol();const parentInstances=parentSol.GetInstances();if(parentInstances.length===0)return false;const parentInstancesSet=new Set(parentInstances);const pickParents=new Set;for(let i=0,len=myInstances.length;i<len;++i){const myInst=myInstances[i];if(which===1)for(const parentInst of myInst.parents()){if(parentInst.BelongsToObjectClass(parentObjectClass)&&
parentInstancesSet.has(parentInst))pickParents.add(parentInst)}else{let parentInst;if(which===0){parentInst=myInst.GetParent();if(parentInst===null)continue}else parentInst=myInst.GetTopParent();if(parentInst.BelongsToObjectClass(parentObjectClass)&&parentInstancesSet.has(parentInst))pickParents.add(parentInst)}}if(pickParents.size===0)return false;parentSol.SetSetPicked(pickParents);parentObjectClass.ApplySolToContainer();return true}function PickChildren(childObjectClass,which){const mySol=this.GetCurrentSol();
const myInstances=mySol.GetInstances();if(myInstances.length===0)return false;const childSol=childObjectClass.GetCurrentSol();const childInstances=childSol.GetInstances();if(childInstances.length===0)return false;const childInstancesSet=new Set(childInstances);const pickChildren=new Set;for(let i=0,len=myInstances.length;i<len;++i){const myInst=myInstances[i];if(which===2&&!myInst.HasChildren()&&myInst.BelongsToObjectClass(childObjectClass)&&childInstancesSet.has(myInst))pickChildren.add(myInst);
for(const childInst of which===0?myInst.children():myInst.allChildren()){if(which===2&&childInst.HasChildren())continue;if(childInst.BelongsToObjectClass(childObjectClass)&&childInstancesSet.has(childInst))pickChildren.add(childInst)}}if(pickChildren.size===0)return false;childSol.SetSetPicked(pickChildren);childObjectClass.ApplySolToContainer();return true}function PickNthChild(childObjectClass,index){const mySol=this.GetCurrentSol();const myInstances=mySol.GetInstances();if(myInstances.length===
0)return false;const childSol=childObjectClass.GetCurrentSol();const childInstances=childSol.GetInstances();if(childInstances.length===0)return false;const childInstancesSet=new Set(childInstances);const pickChildren=[];for(let i=0,len=myInstances.length;i<len;++i){const myInst=myInstances[i];const childInst=myInst.GetChildAt(index);if(childInst!==null&&childInst.BelongsToObjectClass(childObjectClass)&&childInstancesSet.has(childInst))pickChildren.push(childInst)}if(pickChildren.length===0)return false;
childSol.SetArrayPicked(pickChildren);childObjectClass.ApplySolToContainer();return true}function CompareChildCount(cmp,count){return C3.compare(this._inst.GetChildCount(),cmp,count)}function AddChild(childObjectClass,transformX,transformY,transformWidth,transformHeight,transformAngle,transformZElevation,destroyWithParent){const inst=this._inst;const actObjectClass=this._runtime.GetCurrentAction().GetObjectClass();for(const child of childObjectClass.allCorrespondingInstances(inst,actObjectClass)){if(!child.GetPlugin().SupportsSceneGraph())return;
inst.AddChild(child,{transformX,transformY,transformWidth,transformHeight,transformAngle,transformZElevation,destroyWithParent})}}function RemoveChild(childObjectClass){const inst=this._inst;const actObjectClass=this._runtime.GetCurrentAction().GetObjectClass();for(const child of childObjectClass.allCorrespondingInstances(inst,actObjectClass))inst.RemoveChild(child)}function RemoveFromParent(){if(!this._inst.HasParent())return;const parent=this._inst.GetParent();parent.RemoveChild(this._inst)}function ChildCount(){return this._inst.GetChildCount()}
function SetMeshSize(cols,rows){cols=Math.floor(cols);rows=Math.floor(rows);const wi=this.GetWorldInfo();if(cols<2||rows<2||!isFinite(cols)||!isFinite(rows)){wi.ReleaseMesh();wi.SetBboxChanged()}else wi.CreateMesh(cols,rows)}function SetMeshPoint(col,row,mode,posx,posy,zElevation,texu,texv){const wi=this.GetWorldInfo();const didBboxChange=wi.SetMeshPoint(col,row,{mode:mode===0?"absolute":"relative",x:posx,y:posy,zElevation,u:texu,v:texv});if(didBboxChange)wi.SetBboxChanged()}function MeshColumns(){const wi=
this.GetWorldInfo();return wi.HasMesh()?wi.GetSourceMesh().GetHSize():0}function MeshRows(){const wi=this.GetWorldInfo();return wi.HasMesh()?wi.GetSourceMesh().GetVSize():0}function SetElementVisible(v){const wi=this.GetWorldInfo();if(v===2)v=!wi.IsVisible();else v=v!==0;if(wi.IsVisible()===v)return;wi.SetVisible(v)}function SetElementCSSStyle(prop,val){this.SetElementCSSStyle(prop,val)}function SetElementAttribute(attribName,value){this.SetElementAttribute(attribName,""+value)}function RemoveElementAttribute(attribName){this.RemoveElementAttribute(attribName)}
function SetElementFocus(){this.FocusElement()}function SetElementBlur(){this.BlurElement()}function IsElementFocused(){return this.IsElementFocused()}function SetElementEnabled(e){this._SetEnabled(e!==0)}function IsElementEnabled(){return this._IsEnabled()}function CompareInstanceVar(iv,cmp,val){return C3.compare(this.GetInstance().GetInstanceVariableValue(iv),cmp,val)}function IsBoolInstanceVarSet(iv){return!!this.GetInstance().GetInstanceVariableValue(iv)}function PickInstVarHiLow(which,iv){const sol=
this.GetCurrentSol();const instances=sol.GetInstances();if(!instances.length)return false;let inst=instances[0];let pickme=inst;let val=inst.GetInstanceVariableValue(iv);for(let i=1,len=instances.length;i<len;++i){inst=instances[i];const v=inst.GetInstanceVariableValue(iv);if(which===0&&v<val||which===1&&v>val){val=v;pickme=inst}}sol.PickOne(pickme);return true}function PickByUID(uid){if(this._runtime.GetCurrentCondition().IsInverted())return PickByUID_Inverted(this,uid);else return PickByUID_Normal(this,
uid)}function PickByUID_Normal(objectClass,uid){const inst=objectClass.GetRuntime().GetInstanceByUID(uid);if(!inst)return false;const sol=objectClass.GetCurrentSol();if(!sol.IsSelectAll()&&!sol._GetOwnInstances().includes(inst))return false;if(objectClass.IsFamily()){if(inst.GetObjectClass().BelongsToFamily(objectClass)){sol.PickOne(inst);objectClass.ApplySolToContainer();return true}}else if(inst.GetObjectClass()===objectClass){sol.PickOne(inst);objectClass.ApplySolToContainer();return true}return false}
function PickByUID_Inverted(objectClass,uid){const sol=objectClass.GetCurrentSol();if(sol.IsSelectAll()){sol._SetSelectAll(false);sol.ClearArrays();const instances=objectClass.GetInstances();for(let i=0,len=instances.length;i<len;++i){const inst=instances[i];if(inst.GetUID()===uid)sol._PushElseInstance(inst);else sol._PushInstance(inst)}objectClass.ApplySolToContainer();return!!sol._GetOwnInstances().length}else{const instances=sol._GetOwnInstances();let j=0;for(let i=0,len=instances.length;i<len;++i){const inst=
instances[i];instances[j]=inst;if(inst.GetUID()===uid)sol._PushElseInstance(inst);else++j}C3.truncateArray(instances,j);objectClass.ApplySolToContainer();return!!instances.length}}function Destroy(){this._runtime.DestroyInstance(this._inst)}function OnCreated(){return true}function OnDestroyed(){return true}function SetInstanceVar(iv,value){this.GetInstance().SetInstanceVariableValue(iv,value)}function AddInstanceVar(iv,value){const instance=this.GetInstance();const lastValue=instance.GetInstanceVariableValue(iv);
if(typeof lastValue==="number"&&typeof value!=="number")value=parseFloat(value);else if(typeof lastValue==="string"&&typeof value!=="string")value=value.toString();instance.SetInstanceVariableValue(iv,lastValue+value)}function SubInstanceVar(iv,value){const instance=this.GetInstance();const lastValue=instance.GetInstanceVariableValue(iv);if(typeof lastValue!=="number")return;if(typeof value!=="number")value=parseFloat(value);instance.SetInstanceVariableValue(iv,lastValue-value)}function SetBoolInstanceVar(iv,
value){this.GetInstance().SetInstanceVariableValue(iv,value?1:0)}function ToggleBoolInstanceVar(iv){const instance=this.GetInstance();instance.SetInstanceVariableValue(iv,instance.GetInstanceVariableValue(iv)===0?1:0)}function LoadFromJsonString(str){let o;try{o=JSON.parse(str)}catch(err){console.error("Failed to load from JSON string: ",err);return}const inst=this.GetInstance();const mode="state";inst._OnBeforeLoad(mode);inst.LoadFromJson(o,mode)}function AsJSON(){return JSON.stringify(this.GetInstance().SaveToJson("state"))}
function ObjectTypeName(){return this.GetInstance().GetObjectClass().GetName()}function Count(){const expObjectClass=this._runtime.GetCurrentEventStackFrame().GetExpressionObjectClass();let count=expObjectClass.GetInstanceCount();const instancesPendingCreate=this._runtime._GetInstancesPendingCreate();for(const inst of instancesPendingCreate)if(expObjectClass.IsFamily()){if(inst.GetObjectClass().BelongsToFamily(expObjectClass))++count}else if(inst.GetObjectClass()===expObjectClass)++count;return count}
function PickedCount(){return this._runtime.GetCurrentEventStackFrame().GetExpressionObjectClass().GetCurrentSol().GetInstances().length}function GetIID(){return this._inst.GetIID()}function GetUID(){return this._inst.GetUID()}C3.AddCommonACEs=function AddCommonACEs(pluginData,pluginCtor){const isSingleGlobal=pluginData[1];const hasPositionACEs=pluginData[3];const hasSizeACEs=pluginData[4];const hasAngleACEs=pluginData[5];const hasAppearanceACEs=pluginData[6];const hasZOrderACEs=pluginData[7];const hasEffectsACEs=
pluginData[8];const hasElementACEs=pluginData[10];const hasElementFocusACEs=pluginData[11];const hasElementEnabledACEs=pluginData[12];const hasSceneGraphACEs=pluginData[13];const hasMeshACEs=pluginData[14];const Cnds=pluginCtor.Cnds;const Acts=pluginCtor.Acts;const Exps=pluginCtor.Exps;if(hasPositionACEs){Cnds.CompareX=CompareX;Cnds.CompareY=CompareY;Cnds.IsOnScreen=IsOnScreen;Cnds.IsOutsideLayout=IsOutsideLayout;Cnds.PickDistance=PickDistance;Acts.SetX=SetX;Acts.SetY=SetY;Acts.SetPos=SetPos;Acts.SetPosToObject=
SetPosToObject;Acts.MoveForward=MoveForward;Acts.MoveAtAngle=MoveAtAngle;Exps.X=GetX;Exps.Y=GetY;Exps.dt=GetDt}if(hasSizeACEs){Cnds.CompareWidth=CompareWidth;Cnds.CompareHeight=CompareHeight;Acts.SetWidth=SetWidth;Acts.SetHeight=SetHeight;Acts.SetSize=SetSize;Exps.Width=GetWidth;Exps.Height=GetHeight;Exps.BBoxLeft=GetBboxLeft;Exps.BBoxTop=GetBboxTop;Exps.BBoxRight=GetBboxRight;Exps.BBoxBottom=GetBboxBottom}if(hasAngleACEs){Cnds.AngleWithin=IsAngleWithin;Cnds.IsClockwiseFrom=IsAngleClockwiseFrom;Cnds.IsBetweenAngles=
IsBetweenAngles;Acts.SetAngle=SetAngle;Acts.RotateClockwise=RotateClockwise;Acts.RotateCounterclockwise=RotateCounterclockwise;Acts.RotateTowardAngle=RotateTowardAngle;Acts.RotateTowardPosition=RotateTowardPosition;Acts.SetTowardPosition=SetTowardPosition;Exps.Angle=GetAngle}if(hasAppearanceACEs){Cnds.IsVisible=IsVisible;Cnds.CompareOpacity=CompareOpacity;Acts.SetVisible=SetVisible;Acts.SetOpacity=SetOpacity;Acts.SetDefaultColor=SetDefaultColor;Exps.Opacity=GetOpacity;Exps.ColorValue=GetColor}if(hasZOrderACEs){Cnds.IsOnLayer=
IsOnLayer;Cnds.PickTopBottom=PickTopBottom;Cnds.CompareZElevation=CompareZElevation;Acts.MoveToTop=MoveToTop;Acts.MoveToBottom=MoveToBottom;Acts.MoveToLayer=MoveToLayer;Acts.ZMoveToObject=ZMoveToObject;Acts.SetZElevation=SetZElevation;Exps.LayerNumber=LayerNumber;Exps.LayerName=LayerName;Exps.ZIndex=ZIndex;Exps.ZElevation=ZElevation;Exps.TotalZElevation=TotalZElevation}if(hasEffectsACEs){Acts.SetEffectEnabled=SetEffectEnabled;Acts.SetEffectParam=SetEffectParam}if(hasSceneGraphACEs){Cnds.HasParent=
HasParent;Cnds.HasChildren=HasChildren;Cnds.PickParent=PickParent;Cnds.PickChildren=PickChildren;Cnds.PickNthChild=PickNthChild;Cnds.CompareChildCount=CompareChildCount;Acts.AddChild=AddChild;Acts.RemoveChild=RemoveChild;Acts.RemoveFromParent=RemoveFromParent;Exps.ChildCount=ChildCount}if(hasMeshACEs){Acts.SetMeshSize=SetMeshSize;Acts.SetMeshPoint=SetMeshPoint;Exps.MeshColumns=MeshColumns;Exps.MeshRows=MeshRows}if(hasElementACEs){Cnds.IsVisible=IsVisible;Acts.SetVisible=SetElementVisible;Acts.SetCSSStyle=
SetElementCSSStyle;Acts.SetElemAttribute=SetElementAttribute;Acts.RemoveElemAttribute=RemoveElementAttribute}if(hasElementFocusACEs){Cnds.IsFocused=IsElementFocused;Acts.SetFocus=SetElementFocus;Acts.SetBlur=SetElementBlur}if(hasElementEnabledACEs){Cnds.IsEnabled=IsElementEnabled;Acts.SetEnabled=SetElementEnabled}if(!isSingleGlobal){Cnds.CompareInstanceVar=CompareInstanceVar;Cnds.IsBoolInstanceVarSet=IsBoolInstanceVarSet;Cnds.PickInstVarHiLow=PickInstVarHiLow;Cnds.PickByUID=PickByUID;Acts.SetInstanceVar=
SetInstanceVar;Acts.AddInstanceVar=AddInstanceVar;Acts.SubInstanceVar=SubInstanceVar;Acts.SetBoolInstanceVar=SetBoolInstanceVar;Acts.ToggleBoolInstanceVar=ToggleBoolInstanceVar;Cnds.OnCreated=OnCreated;Cnds.OnDestroyed=OnDestroyed;Acts.Destroy=Destroy;if(!Acts.LoadFromJsonString)Acts.LoadFromJsonString=LoadFromJsonString;if(!Exps.AsJSON)Exps.AsJSON=AsJSON;Exps.Count=Count;Exps.PickedCount=PickedCount;Exps.IID=GetIID;Exps.UID=GetUID;Exps.ObjectTypeName=ObjectTypeName}}};


// c3/events/scheduledWait.js
'use strict';{const C3=self.C3;C3.ScheduledWait=class ScheduledWait extends C3.DefendedBase{constructor(eventSheetManager){super();this._eventSheetManager=eventSheetManager;this._type="";this._time=-1;this._signalTag="";this._isSignalled=false;this._event=null;this._actIndex=0;this._solModifiers=[];this._sols=new Map;this._callingFunctionBlock=null;this._asyncId=-1;this._functionParameters=null;this._functionInnerLocalVars=null;this._shouldRelease=false}Release(){this._type="";this._time=-1;this._signalTag=
"";this._event=null;this._callingFunctionBlock=null;this._functionParameters=null;this._functionInnerLocalVars=null;this._asyncId=-1;C3.clearArray(this._solModifiers);for(const s of this._sols.values())s.Release();this._sols.clear()}_Init(){const eventSheetManager=this._eventSheetManager;const allObjectClasses=eventSheetManager.GetRuntime().GetAllObjectClasses();const frame=eventSheetManager.GetCurrentEventStackFrame();this._event=frame.GetCurrentEvent();this._actIndex=frame.GetActionIndex()+1;const functionBlock=
eventSheetManager.FindFirstFunctionBlockParent(this._event);if(functionBlock){this._callingFunctionBlock=functionBlock;this._functionParameters=functionBlock.CaptureFunctionParameters();this._functionInnerLocalVars=functionBlock._GetAllInnerLocalVariables().map(v=>v.GetValue());if(functionBlock.IsAsync())this._asyncId=functionBlock.PauseCurrentAsyncFunction()}for(const objectClass of allObjectClasses){const sol=objectClass.GetCurrentSol();if(sol.IsSelectAll()&&!this._event.HasSolModifier(objectClass))continue;
this._solModifiers.push(objectClass);this._sols.set(objectClass,C3.New(C3.SolState,sol))}}InitTimer(seconds){this._type="timer";this._Init();this._time=this._eventSheetManager.GetRuntime().GetGameTime()+seconds}InitSignal(tag){this._type="signal";this._Init();this._signalTag=tag.toLowerCase()}InitPromise(p){this._type="promise";this._Init();p.then(()=>this.SetSignalled()).catch(err=>{console.warn("[C3 runtime] Promise rejected in 'Wait for previous actions to complete': ",err);this.SetSignalled()})}IsTimer(){return this._type===
"timer"}IsSignal(){return this._type==="signal"}IsPromise(){return this._type==="promise"}GetSignalTag(){return this._signalTag}IsSignalled(){return this._isSignalled}SetSignalled(){this._isSignalled=true}_ShouldRun(){if(this.IsTimer())return this._time<=this._eventSheetManager.GetRuntime().GetGameTime();else return this.IsSignalled()}_RestoreState(frame){frame._Restore(this._event,this._actIndex);for(const [objectClass,solState]of this._sols.entries()){const sol=objectClass.GetCurrentSol();solState._Restore(sol)}const callingFunctionBlock=
this._callingFunctionBlock;if(callingFunctionBlock){callingFunctionBlock.SetFunctionParameters(this._functionParameters);callingFunctionBlock._GetAllInnerLocalVariables().map((v,index)=>v.SetValue(this._functionInnerLocalVars[index]));if(callingFunctionBlock.IsAsync())callingFunctionBlock.ResumeAsyncFunction(this._asyncId)}}_Run(frame){this._RestoreState(frame);this._event._ResumeActionsAndSubEvents(frame);if(this._callingFunctionBlock&&this._callingFunctionBlock.IsAsync())this._callingFunctionBlock.MaybeFinishAsyncFunctionCall(this._asyncId);
this._eventSheetManager.ClearSol(this._solModifiers);this._shouldRelease=true}async _DebugRun(frame){this._RestoreState(frame);for(const breakEventObject of this._event._DebugResumeActionsAndSubEvents(frame))await this._eventSheetManager.GetRuntime().DebugBreak(breakEventObject);if(this._callingFunctionBlock&&this._callingFunctionBlock.IsAsync())this._callingFunctionBlock.MaybeFinishAsyncFunctionCall(this._asyncId);this._eventSheetManager.ClearSol(this._solModifiers);this._shouldRelease=true}ShouldRelease(){return this._shouldRelease}RemoveInstances(s){for(const solState of this._sols.values())solState.RemoveInstances(s)}_SaveToJson(){const sols=
{};const o={"t":this._time,"st":this._signalTag,"s":this._isSignalled,"ev":this._event.GetSID(),"sm":this._solModifiers.map(oc=>oc.GetSID()),"sols":sols};if(this._event._HasActionIndex(this._actIndex))o["act"]=this._event.GetActionAt(this._actIndex).GetSID();for(const [objectClass,solState]of this._sols)sols[objectClass.GetSID().toString()]=solState._SaveToJson();return o}static _CreateFromJson(eventSheetManager,o){const runtime=eventSheetManager.GetRuntime();const event=eventSheetManager.GetEventBlockBySID(o["ev"]);
if(!event)return null;let actIndex=0;if(o.hasOwnProperty("act")){const act=eventSheetManager.GetActionBySID(o["act"]);if(!act)return null;actIndex=act.GetIndex()}const sw=C3.New(C3.ScheduledWait,eventSheetManager);sw._time=o["t"];sw._type=sw._time===-1?"signal":"timer";sw._signalTag=o["st"];sw._isSignalled=o["s"];sw._event=event;sw._actIndex=actIndex;for(const sid of o["sm"]){const objectClass=runtime.GetObjectClassBySID(sid);if(objectClass)sw._solModifiers.push(objectClass)}for(const [sidStr,solData]of Object.entries(o["sols"])){const sid=
parseInt(sidStr,10);const objectClass=runtime.GetObjectClassBySID(sid);if(!objectClass)continue;const solState=C3.New(C3.SolState,null);solState._LoadFromJson(eventSheetManager,solData);sw._sols.set(objectClass,solState)}return sw}}};


// c3/events/solState.js
'use strict';{const C3=self.C3;C3.SolState=class SolState extends C3.DefendedBase{constructor(sol){super();this._objectClass=null;this._isSelectAll=true;this._instances=[];if(sol){this._objectClass=sol.GetObjectClass();this._isSelectAll=sol.IsSelectAll();C3.shallowAssignArray(this._instances,sol._GetOwnInstances())}}Release(){this._objectClass=null;C3.clearArray(this._instances)}_Restore(sol){sol._SetSelectAll(this._isSelectAll);C3.shallowAssignArray(sol._GetOwnInstances(),this._instances)}RemoveInstances(s){C3.arrayRemoveAllInSet(this._instances,
s)}_SaveToJson(){return{"sa":this._isSelectAll,"insts":this._instances.map(inst=>inst.GetUID())}}_LoadFromJson(eventSheetManager,o){const runtime=eventSheetManager.GetRuntime();this._isSelectAll=!!o["sa"];C3.clearArray(this._instances);for(const uid of o["insts"]){const inst=runtime.GetInstanceByUID(uid);if(inst)this._instances.push(inst)}}}};


// c3/sdk/sdkPluginBase.js
'use strict';{const C3=self.C3;function GetNextParamMap(paramMap,param){let nextParamMap=paramMap.get(param);if(!nextParamMap){nextParamMap=new Map;paramMap.set(param,nextParamMap)}return nextParamMap}C3.SDKPluginBase=class SDKPluginBase extends C3.DefendedBase{constructor(opts){super();this._runtime=opts.runtime;this._isSingleGlobal=!!opts.isSingleGlobal;this._isWorldType=!!opts.isWorld;this._isRotatable=!!opts.isRotatable;this._mustPredraw=!!opts.mustPredraw;this._hasEffects=!!opts.hasEffects;this._supportsSceneGraph=
!!opts.supportsSceneGraph;this._supportsMesh=!!opts.supportsMesh;this._singleGlobalObjectClass=null;this._boundACEMethodCache=new Map;this._boundACEMethodCache_1param=new Map;this._boundACEMethodCache_2params=new Map;this._boundACEMethodCache_3params=new Map}Release(){this._runtime=null}GetRuntime(){return this._runtime}OnCreate(){}IsSingleGlobal(){return this._isSingleGlobal}IsWorldType(){return this._isWorldType}IsRotatable(){return this._isRotatable}MustPreDraw(){return this._mustPredraw}HasEffects(){return this._hasEffects}SupportsSceneGraph(){return this._supportsSceneGraph}SupportsMesh(){return this._supportsMesh}_GetBoundACEMethod(func,
bindThis){if(!bindThis)throw new Error("missing 'this' binding");let ret=this._boundACEMethodCache.get(func);if(ret)return ret;ret=func.bind(bindThis);this._boundACEMethodCache.set(func,ret);return ret}_GetBoundACEMethod_1param(func,bindThis,param0){if(!bindThis)throw new Error("missing 'this' binding");const param0map=GetNextParamMap(this._boundACEMethodCache_1param,func);let ret=param0map.get(param0);if(ret)return ret;ret=func.bind(bindThis,param0);param0map.set(param0,ret);return ret}_GetBoundACEMethod_2params(func,
bindThis,param0,param1){if(!bindThis)throw new Error("missing 'this' binding");const param0map=GetNextParamMap(this._boundACEMethodCache_2params,func);const param1map=GetNextParamMap(param0map,param0);let ret=param1map.get(param1);if(ret)return ret;ret=func.bind(bindThis,param0,param1);param1map.set(param1,ret);return ret}_GetBoundACEMethod_3params(func,bindThis,param0,param1,param2){if(!bindThis)throw new Error("missing 'this' binding");const param0map=GetNextParamMap(this._boundACEMethodCache_3params,
func);const param1map=GetNextParamMap(param0map,param0);const param2map=GetNextParamMap(param1map,param1);let ret=param2map.get(param2);if(ret)return ret;ret=func.bind(bindThis,param0,param1,param2);param2map.set(param2,ret);return ret}_SetSingleGlobalObjectClass(objectClass){if(!this.IsSingleGlobal())throw new Error("must be single-global plugin");this._singleGlobalObjectClass=objectClass}GetSingleGlobalObjectClass(){if(!this.IsSingleGlobal())throw new Error("must be single-global plugin");return this._singleGlobalObjectClass}GetSingleGlobalInstance(){if(!this.IsSingleGlobal())throw new Error("must be single-global plugin");
return this._singleGlobalObjectClass.GetSingleGlobalInstance()}}};


// c3/sdk/sdkDOMPluginBase.js
'use strict';{const C3=self.C3;C3.SDKDOMPluginBase=class SDKDOMPluginBase extends C3.SDKPluginBase{constructor(opts,DOM_COMPONENT_ID){super(opts);this._domComponentId=DOM_COMPONENT_ID;this._nextElementId=0;this._instMap=new Map;this.AddElementMessageHandler("elem-focused",sdkInst=>sdkInst._OnElemFocused());this.AddElementMessageHandler("elem-blurred",sdkInst=>{if(sdkInst)sdkInst._OnElemBlurred()})}Release(){super.Release()}_AddElement(sdkInst){const elementId=this._nextElementId++;this._instMap.set(elementId,
sdkInst);return elementId}_RemoveElement(elementId){this._instMap.delete(elementId)}AddElementMessageHandler(handler,func){this._runtime.AddDOMComponentMessageHandler(this._domComponentId,handler,e=>{const sdkInst=this._instMap.get(e["elementId"]);func(sdkInst,e)})}}};


// c3/sdk/sdkTypeBase.js
'use strict';{const C3=self.C3;C3.SDKTypeBase=class SDKTypeBase extends C3.DefendedBase{constructor(objectClass){super();this._objectClass=objectClass;this._runtime=objectClass.GetRuntime();this._plugin=objectClass.GetPlugin()}Release(){this._objectClass=null;this._runtime=null;this._plugin=null}GetObjectClass(){return this._objectClass}GetRuntime(){return this._runtime}GetPlugin(){return this._plugin}GetImageInfo(){return this._objectClass.GetImageInfo()}FinishCondition(f){}LoadTextures(renderer){}ReleaseTextures(){}OnDynamicTextureLoadComplete(){}PreloadTexturesWithInstances(renderer){}LoadTilemapData(){}GetScriptInterfaceClass(){return null}}};


// c3/sdk/sdkInstanceBase.js
'use strict';{const C3=self.C3;C3.SDKInstanceBase=class SDKInstanceBase extends C3.DefendedBase{constructor(inst,domComponentId){super();this._inst=inst;this._domComponentId=domComponentId;this._runtime=inst.GetRuntime();this._objectClass=this._inst.GetObjectClass();this._sdkType=this._objectClass.GetSdkType();this._tickFunc=null;this._tick2Func=null;this._isTicking=false;this._isTicking2=false;this._disposables=null;this._wasReleased=false}Release(){this._wasReleased=true;this._StopTicking();this._StopTicking2();
this._tickFunc=null;this._tick2Func=null;if(this._disposables){this._disposables.Release();this._disposables=null}this._inst=null;this._runtime=null;this._objectClass=null;this._sdkType=null}WasReleased(){return this._wasReleased}GetInstance(){return this._inst}GetRuntime(){return this._runtime}GetObjectClass(){return this._objectClass}GetPlugin(){return this._sdkType.GetPlugin()}GetSdkType(){return this._sdkType}GetScriptInterface(){return this._inst.GetInterfaceClass()}Trigger(method){return this._runtime.Trigger(method,
this._inst,null)}DebugTrigger(method){return this._runtime.DebugTrigger(method,this._inst,null)}TriggerAsync(method){return this._runtime.TriggerAsync(method,this._inst,null)}FastTrigger(method,value){return this._runtime.FastTrigger(method,this._inst,value)}DebugFastTrigger(method,value){return this._runtime.DebugFastTrigger(method,this._inst,value)}ScheduleTriggers(f){return this._runtime.ScheduleTriggers(f)}AddDOMMessageHandler(handler,func){this._runtime.AddDOMComponentMessageHandler(this._domComponentId,
handler,func)}AddDOMMessageHandlers(list){for(const [handler,func]of list)this.AddDOMMessageHandler(handler,func)}PostToDOM(handler,data){this._runtime.PostComponentMessageToDOM(this._domComponentId,handler,data)}PostToDOMAsync(handler,data){return this._runtime.PostComponentMessageToDOMAsync(this._domComponentId,handler,data)}_PostToDOMMaybeSync(handler,data){if(this._runtime.IsInWorker())this.PostToDOM(handler,data);else return window["c3_runtimeInterface"]["_OnMessageFromRuntime"]({"type":"event",
"component":this._domComponentId,"handler":handler,"data":data,"responseId":null})}Tick(){}Tick2(){}_StartTicking(){if(this._isTicking)return;if(!this._tickFunc)this._tickFunc=()=>this.Tick();this._runtime.Dispatcher().addEventListener("tick",this._tickFunc);this._isTicking=true}_StopTicking(){if(!this._isTicking)return;this._runtime.Dispatcher().removeEventListener("tick",this._tickFunc);this._isTicking=false}IsTicking(){return this._isTicking}_StartTicking2(){if(this._isTicking2)return;if(!this._tick2Func)this._tick2Func=
()=>this.Tick2();this._runtime.Dispatcher().addEventListener("tick2",this._tick2Func);this._isTicking2=true}_StopTicking2(){if(!this._isTicking2)return;this._runtime.Dispatcher().removeEventListener("tick2",this._tick2Func);this._isTicking2=false}IsTicking2(){return this._isTicking2}GetDebuggerProperties(){return[]}SaveToJson(){return null}LoadFromJson(o){}GetPropertyValueByIndex(index){}SetPropertyValueByIndex(index,value){}OffsetPropertyValueByIndex(index,offset){if(offset===0)return;const value=
this.GetPropertyValueByIndex(index);if(typeof value!=="number")throw new Error("expected number");this.SetPropertyValueByIndex(index,value+offset)}SetPropertyColorOffsetValueByIndex(offset,r,g,b){}CallAction(actMethod,...args){actMethod.call(this,...args)}CallExpression(expMethod,...args){return expMethod.call(this,...args)}GetScriptInterfaceClass(){return null}}};


// c3/sdk/sdkWorldInstanceBase.js
'use strict';{const C3=self.C3;C3.SDKWorldInstanceBase=class SDKWorldInstanceBase extends C3.SDKInstanceBase{constructor(inst,domComponentId){super(inst,domComponentId);this._worldInfo=inst.GetWorldInfo();this._webglcontextlost_handler=null;this._webglcontextrestored_handler=null}Release(){if(this._webglcontextlost_handler){const dispatcher=this._runtime.Dispatcher();dispatcher.removeEventListener("webglcontextlost",this._webglcontextlost_handler);dispatcher.removeEventListener("webglcontextrestored",
this._webglcontextrestored_handler);this._webglcontextlost_handler=null;this._webglcontextrestored_handler=null}this._worldInfo=null;super.Release()}HandleWebGLContextLoss(){if(this._webglcontextlost_handler)return;this._webglcontextlost_handler=()=>this.OnWebGLContextLost();this._webglcontextrestored_handler=()=>this.OnWebGLContextRestored();const dispatcher=this._runtime.Dispatcher();dispatcher.addEventListener("webglcontextlost",this._webglcontextlost_handler);dispatcher.addEventListener("webglcontextrestored",
this._webglcontextrestored_handler)}OnWebGLContextLost(){}OnWebGLContextRestored(){}GetWorldInfo(){return this._worldInfo}IsOriginalSizeKnown(){return false}GetOriginalWidth(){if(!this.IsOriginalSizeKnown())throw new Error("original size not known");const imageInfo=this.GetCurrentImageInfo();if(imageInfo)return imageInfo.GetWidth();else;}GetOriginalHeight(){if(!this.IsOriginalSizeKnown())throw new Error("original size not known");const imageInfo=this.GetCurrentImageInfo();if(imageInfo)return imageInfo.GetHeight();
else;}GetCurrentImageInfo(){return null}GetCurrentSurfaceSize(){const imageInfo=this.GetCurrentImageInfo();if(imageInfo){const texture=imageInfo.GetTexture();if(texture)return[texture.GetWidth(),texture.GetHeight()]}return[100,100]}GetCurrentTexRect(){const imageInfo=this.GetCurrentImageInfo();return imageInfo?imageInfo.GetTexRect():null}GetImagePoint(nameOrIndex){const wi=this._inst.GetWorldInfo();return[wi.GetX(),wi.GetY()]}LoadTilemapData(data,mapWidth,mapHeight){}TestPointOverlapTile(x,y){}}};


// c3/sdk/sdkDOMInstanceBase.js
'use strict';{const C3=self.C3;const tempRect=C3.New(C3.Rect);C3.SDKDOMInstanceBase=class SDKDOMInstanceBase extends C3.SDKWorldInstanceBase{constructor(inst,domComponentId){super(inst,domComponentId);this._elementId=this.GetPlugin()._AddElement(this);this._isElementShowing=true;this._elemHasFocus=false;this._autoFontSize=false;this._lastRect=C3.New(C3.Rect,0,0,-1,-1);const canvasManager=this._runtime.GetCanvasManager();this._lastWindowWidth=canvasManager.GetLastWidth();this._lastWindowHeight=canvasManager.GetLastHeight();
this._isPendingUpdateState=false;this._StartTicking()}Release(){this.GetPlugin()._RemoveElement(this._elementId);this.PostToDOMElement("destroy");this._elementId=-1;super.Release()}_GetElementInDOMMode(){if(this._runtime.IsInWorker())throw new Error("not valid in worker mode");return this._PostToDOMElementMaybeSync("get-element")}PostToDOMElement(handler,data){if(!data)data={};data["elementId"]=this._elementId;this.PostToDOM(handler,data)}_PostToDOMElementMaybeSync(handler,data){if(!data)data={};
data["elementId"]=this._elementId;return this._PostToDOMMaybeSync(handler,data)}PostToDOMElementAsync(handler,data){if(!data)data={};data["elementId"]=this._elementId;return this.PostToDOMAsync(handler,data)}CreateElement(data){if(!data)data={};const isVisible=this.GetWorldInfo().IsVisible();data["elementId"]=this._elementId;data["isVisible"]=isVisible;Object.assign(data,this.GetElementState());this._isElementShowing=!!data["isVisible"];this._PostToDOMMaybeSync("create",data);this._UpdatePosition(true)}SetElementVisible(v){v=
!!v;if(this._isElementShowing===v)return;this._isElementShowing=v;this.PostToDOMElement("set-visible",{"isVisible":v})}Tick(){this._UpdatePosition(false)}_ShouldPreserveElement(){const fullscreenMode=this._runtime.GetCanvasManager().GetFullscreenMode();return C3.Platform.OS==="Android"&&(fullscreenMode==="scale-inner"||fullscreenMode==="scale-outer"||fullscreenMode==="crop")}_UpdatePosition(first){const wi=this.GetWorldInfo();const layer=wi.GetLayer();const x=wi.GetX();const y=wi.GetY();let [cleft,
ctop]=layer.LayerToCanvasCss(x,y);let [cright,cbottom]=layer.LayerToCanvasCss(x+wi.GetWidth(),y+wi.GetHeight());const canvasManager=this._runtime.GetCanvasManager();const rightEdge=canvasManager.GetCssWidth();const bottomEdge=canvasManager.GetCssHeight();if(!wi.IsVisible()||!layer.IsVisible()){this.SetElementVisible(false);return}if(!this._ShouldPreserveElement()){if(cright<=0||cbottom<=0||cleft>=rightEdge||ctop>=bottomEdge){this.SetElementVisible(false);return}if(cleft<1)cleft=1;if(ctop<1)ctop=1;
if(cright>=rightEdge)cright=rightEdge-1;if(cbottom>=bottomEdge)cbottom=bottomEdge-1}tempRect.set(cleft,ctop,cright,cbottom);const curWinWidth=canvasManager.GetLastWidth();const curWinHeight=canvasManager.GetLastHeight();if(!first&&tempRect.equals(this._lastRect)&&this._lastWindowWidth===curWinWidth&&this._lastWindowHeight===curWinHeight){this.SetElementVisible(true);return}this._lastRect.copy(tempRect);this._lastWindowWidth=curWinWidth;this._lastWindowHeight=curWinHeight;this.SetElementVisible(true);
let fontSize=null;if(this._autoFontSize)fontSize=layer.GetDisplayScale()-.2;this.PostToDOMElement("update-position",{"left":Math.round(this._lastRect.getLeft())+canvasManager.GetCanvasClientX(),"top":Math.round(this._lastRect.getTop())+canvasManager.GetCanvasClientY(),"width":Math.round(this._lastRect.width()),"height":Math.round(this._lastRect.height()),"fontSize":fontSize})}FocusElement(){this._PostToDOMElementMaybeSync("focus",{"focus":true})}BlurElement(){this._PostToDOMElementMaybeSync("focus",
{"focus":false})}_OnElemFocused(){this._elemHasFocus=true}_OnElemBlurred(){this._elemHasFocus=false}IsElementFocused(){return this._elemHasFocus}SetElementCSSStyle(prop,val){this.PostToDOMElement("set-css-style",{"prop":C3.CSSToCamelCase(prop),"val":val})}SetElementAttribute(attribName,value){this.PostToDOMElement("set-attribute",{"name":attribName,"val":value})}RemoveElementAttribute(attribName){this.PostToDOMElement("remove-attribute",{"name":attribName})}UpdateElementState(){if(this._isPendingUpdateState)return;
this._isPendingUpdateState=true;Promise.resolve().then(()=>{this._isPendingUpdateState=false;this.PostToDOMElement("update-state",this.GetElementState())})}GetElementState(){}GetElementId(){return this._elementId}}};


// c3/sdk/sdkBehaviorBase.js
'use strict';{const C3=self.C3;const IBehavior=self.IBehavior;C3.SDKBehaviorBase=class SDKBehaviorBase extends C3.DefendedBase{constructor(opts){super();this._runtime=opts.runtime;this._myObjectClasses=C3.New(C3.ArraySet);this._myInstances=C3.New(C3.ArraySet);this._iBehavior=null;this._scriptInterfaceClass=opts.scriptInterfaceClass||null}Release(){this._myInstances.Release();this._myObjectClasses.Release();this._runtime=null}GetRuntime(){return this._runtime}OnCreate(){}_AddObjectClass(objectClass){this._myObjectClasses.Add(objectClass)}GetObjectClasses(){return this._myObjectClasses.GetArray()}_AddInstance(inst){this._myInstances.Add(inst)}_RemoveInstance(inst){this._myInstances.Delete(inst)}GetInstances(){return this._myInstances.GetArray()}GetIBehavior(){if(this._iBehavior===
null){const CustomScriptClass=this._scriptInterfaceClass;if(CustomScriptClass){this._iBehavior=new CustomScriptClass(this);if(!(this._iBehavior instanceof IBehavior))throw new TypeError("script interface class must derive from IBehavior");}else this._iBehavior=new IBehavior(this)}return this._iBehavior}}};


// c3/sdk/sdkBehaviorTypeBase.js
'use strict';{const C3=self.C3;C3.SDKBehaviorTypeBase=class SDKBehaviorTypeBase extends C3.DefendedBase{constructor(behaviorType){super();this._runtime=behaviorType.GetRuntime();this._behaviorType=behaviorType;this._objectClass=behaviorType.GetObjectClass();this._behavior=behaviorType.GetBehavior();this._behavior._AddObjectClass(this._objectClass)}Release(){this._runtime=null;this._behaviorType=null;this._objectClass=null;this._behavior=null}GetBehaviorType(){return this._behaviorType}GetObjectClass(){return this._objectClass}GetRuntime(){return this._runtime}GetBehavior(){return this._behavior}}};


// c3/sdk/sdkBehaviorInstanceBase.js
'use strict';{const C3=self.C3;C3.SDKBehaviorInstanceBase=class SDKBehaviorInstanceBase extends C3.DefendedBase{constructor(behInst,domComponentId){super();this._behInst=behInst;this._domComponentId=domComponentId;this._inst=behInst.GetObjectInstance();this._runtime=behInst.GetRuntime();this._behaviorType=behInst.GetBehaviorType();this._sdkType=this._behaviorType.GetSdkType();this._isTicking=false;this._isTicking2=false;this._isPostTicking=false;this._disposables=null}Release(){this._StopTicking();
this._StopTicking2();this._StopPostTicking();if(this._disposables){this._disposables.Release();this._disposables=null}this._behInst=null;this._inst=null;this._runtime=null;this._behaviorType=null;this._sdkType=null}GetBehavior(){return this._behaviorType.GetBehavior()}GetBehaviorInstance(){return this._behInst}GetObjectInstance(){return this._inst}GetObjectClass(){return this._inst.GetObjectClass()}GetWorldInfo(){return this._inst.GetWorldInfo()}GetRuntime(){return this._runtime}GetBehaviorType(){return this._behaviorType}GetSdkType(){return this._sdkType}GetScriptInterface(){return this._behInst.GetScriptInterface()}Trigger(method){return this._runtime.Trigger(method,
this._inst,this._behaviorType)}DebugTrigger(method){return this._runtime.DebugTrigger(method,this._inst,this._behaviorType)}TriggerAsync(method){return this._runtime.TriggerAsync(method,this._inst,this._behaviorType)}PostCreate(){}Tick(){}Tick2(){}PostTick(){}_StartTicking(){if(this._isTicking)return;this._runtime._AddBehInstToTick(this);this._isTicking=true}_StopTicking(){if(!this._isTicking)return;this._runtime._RemoveBehInstToTick(this);this._isTicking=false}IsTicking(){return this._isTicking}_StartTicking2(){if(this._isTicking2)return;
this._runtime._AddBehInstToTick2(this);this._isTicking2=true}_StopTicking2(){if(!this._isTicking2)return;this._runtime._RemoveBehInstToTick2(this);this._isTicking2=false}IsTicking2(){return this._isTicking2}_StartPostTicking(){if(this._isPostTicking)return;this._runtime._AddBehInstToPostTick(this);this._isPostTicking=true}_StopPostTicking(){if(!this._isPostTicking)return;this._runtime._RemoveBehInstToPostTick(this);this._isPostTicking=false}IsPostTicking(){return this._isPostTicking}GetDebuggerProperties(){return[]}AddDOMMessageHandler(handler,
func){this._runtime.AddDOMComponentMessageHandler(this._domComponentId,handler,func)}OnSpriteFrameChanged(prevFrame,nextFrame){}SaveToJson(){return null}LoadFromJson(o){}GetPropertyValueByIndex(index){}SetPropertyValueByIndex(index,value){}OffsetPropertyValueByIndex(index,offset){if(offset===0)return;const value=this.GetPropertyValueByIndex(index);if(typeof value!=="number")throw new Error("expected number");this.SetPropertyValueByIndex(index,value+offset)}SetPropertyColorOffsetValueByIndex(index,
offsetR,offsetG,offsetB){}CallAction(actMethod,...args){actMethod.call(this,...args)}CallExpression(expMethod,...args){return expMethod.call(this,...args)}GetScriptInterfaceClass(){return null}}};


// c3/objects/pluginManager.js
'use strict';{const C3=self.C3;C3.Plugins={};C3.Behaviors={};C3.PluginManager=class PluginManager extends C3.DefendedBase{constructor(runtime){super();this._runtime=runtime;this._allPlugins=[];this._pluginsByCtor=new Map;this._systemPlugin=null;this._allBehaviors=[];this._behaviorsByCtor=new Map;this._solidBehavior=null;this._jumpthruBehavior=null}CreatePlugin(pluginData){const Ctor=this._runtime.GetObjectReference(pluginData[0]);if(!Ctor)throw new Error("missing plugin");C3.AddCommonACEs(pluginData,
Ctor);const plugin=C3.New(Ctor,{runtime:this._runtime,isSingleGlobal:pluginData[1],isWorld:pluginData[2],isRotatable:pluginData[5],hasEffects:pluginData[8],mustPredraw:pluginData[9],supportsSceneGraph:pluginData[13],supportsMesh:pluginData[14]});plugin.OnCreate();this._allPlugins.push(plugin);this._pluginsByCtor.set(Ctor,plugin)}CreateSystemPlugin(){this._systemPlugin=C3.New(C3.Plugins.System,{runtime:this._runtime,isSingleGlobal:true});this._systemPlugin.OnCreate()}CreateBehavior(behaviorData){const Ctor=
this._runtime.GetObjectReference(behaviorData[1]);if(!Ctor)throw new Error("missing behavior");const behavior=C3.New(Ctor,{runtime:this._runtime});behavior.OnCreate();this._allBehaviors.push(behavior);this._behaviorsByCtor.set(Ctor,behavior);if(!this._solidBehavior&&C3.Behaviors.solid&&behavior instanceof C3.Behaviors.solid)this._solidBehavior=behavior;else if(!this._jumpthruBehavior&&C3.Behaviors.jumpthru&&behavior instanceof C3.Behaviors.jumpthru)this._jumpthruBehavior=behavior}GetPluginByConstructorFunction(ctor){return this._pluginsByCtor.get(ctor)||
null}HasBehaviorByConstructorFunction(ctor){return this._behaviorsByCtor.has(ctor)}GetBehaviorByConstructorFunction(ctor){return this._behaviorsByCtor.get(ctor)||null}GetSystemPlugin(){return this._systemPlugin}GetSolidBehavior(){return this._solidBehavior}GetJumpthruBehavior(){return this._jumpthruBehavior}}};


// c3/objects/imageInfo.js
'use strict';{const C3=self.C3;const allImageInfos=new Set;C3.ImageInfo=class ImageInfo extends C3.DefendedBase{constructor(){super();this._url="";this._size=0;this._pixelFormat=0;this._offsetX=0;this._offsetY=0;this._width=0;this._height=0;this._hasMetaData=false;this._imageAsset=null;this._textureState="";this._rcTex=C3.New(C3.Rect);allImageInfos.add(this)}Release(){this.ReleaseTexture();this._imageAsset=null;allImageInfos.delete(this)}static OnWebGLContextLost(){for(const imageInfo of allImageInfos){imageInfo._textureState=
"";imageInfo._rcTex.set(0,0,0,0)}}LoadData(imageData){this._url=imageData[0];this._size=imageData[1];this._pixelFormat=imageData[2];this._offsetX=imageData[3];this._offsetY=imageData[4];this._width=imageData[5];this._height=imageData[6];this._hasMetaData=true}LoadAnimationFrameData(frameData){this._url=frameData[0];this._size=frameData[1];this._offsetX=frameData[2];this._offsetY=frameData[3];this._width=frameData[4];this._height=frameData[5];this._pixelFormat=frameData[11];this._hasMetaData=true}LoadDynamicAsset(runtime,
url){if(this._imageAsset)throw new Error("already loaded asset");this._url=url;const opts={};if(C3.IsAbsoluteURL(url))opts.loadPolicy="remote";this.LoadAsset(runtime,opts);return this._imageAsset.Load()}ReplaceWith(otherImageInfo){if(otherImageInfo===this)throw new Error("cannot replace with self");this.ReleaseTexture();this._url=otherImageInfo._url;this._size=otherImageInfo._size;this._pixelFormat=otherImageInfo._pixelFormat;this._offsetX=otherImageInfo._offsetX;this._offsetY=otherImageInfo._offsetY;
this._width=otherImageInfo._width;this._height=otherImageInfo._height;this._hasMetaData=otherImageInfo._hasMetaData;this._imageAsset=otherImageInfo._imageAsset;this._textureState=otherImageInfo._textureState;this._rcTex=otherImageInfo._rcTex}GetURL(){return this._url}GetSize(){return this._size}GetPixelFormat(){return this._pixelFormat}GetOffsetX(){return this._offsetX}GetOffsetY(){return this._offsetY}GetWidth(){return this._width}GetHeight(){return this._height}GetSheetWidth(){return this._imageAsset.GetWidth()}GetSheetHeight(){return this._imageAsset.GetHeight()}LoadAsset(runtime,
opts){if(this._imageAsset)throw new Error("already got asset");opts=Object.assign({},opts,{url:this.GetURL(),size:this.GetSize()});this._imageAsset=runtime.LoadImage(opts)}IsLoaded(){return this._imageAsset&&this._imageAsset.IsLoaded()}async LoadStaticTexture(renderer,opts){if(!this._imageAsset)throw new Error("no asset");if(this._textureState)throw new Error("already loaded texture");this._textureState="loading";const texture=await this._imageAsset.LoadStaticTexture(renderer,opts);if(!texture){this._textureState=
"";return null}this._textureState="loaded";if(!this._hasMetaData){this._width=texture.GetWidth();this._height=texture.GetHeight();this._hasMetaData=true}this._rcTex.set(this._offsetX,this._offsetY,this._offsetX+this._width,this._offsetY+this._height);this._rcTex.divide(texture.GetWidth(),texture.GetHeight());return texture}ReleaseTexture(){if(!this._textureState)return;if(this._imageAsset)this._imageAsset.ReleaseTexture();this._textureState="";this._rcTex.set(0,0,0,0)}GetTexture(){return this._imageAsset?
this._imageAsset.GetTexture():null}GetTexRect(){return this._rcTex}async ExtractImageToCanvas(){const srcDrawable=await this._imageAsset.LoadToDrawable();const canvas=C3.CreateCanvas(this._width,this._height);const ctx=canvas.getContext("2d");ctx.drawImage(srcDrawable,this._offsetX,this._offsetY,this._width,this._height,0,0,this._width,this._height);return canvas}}};


// c3/objects/animationInfo.js
'use strict';{const C3=self.C3;C3.AnimationInfo=class AnimationInfo extends C3.DefendedBase{constructor(animData){super();this._name=animData[0];this._speed=animData[1];this._isLooping=!!animData[2];this._repeatCount=animData[3];this._repeatTo=animData[4];this._isPingPong=!!animData[5];this._sid=animData[6];this._frames=animData[7].map(frameData=>C3.New(C3.AnimationFrameInfo,frameData))}Release(){for(const f of this._frames)f.Release();C3.clearArray(this._frames)}LoadAllAssets(runtime){for(const f of this._frames)f.GetImageInfo().LoadAsset(runtime)}LoadAllTextures(renderer,
opts){return Promise.all(this._frames.map(f=>f.GetImageInfo().LoadStaticTexture(renderer,opts)))}ReleaseAllTextures(){for(const f of this._frames)f.GetImageInfo().ReleaseTexture()}GetName(){return this._name}GetSID(){return this._sid}GetFrameCount(){return this._frames.length}GetFrames(){return this._frames}GetFrameAt(i){i=Math.floor(i);if(i<0||i>=this._frames.length)throw new RangeError("invalid frame");return this._frames[i]}GetSpeed(){return this._speed}IsLooping(){return this._isLooping}GetRepeatCount(){return this._repeatCount}GetRepeatTo(){return this._repeatTo}IsPingPong(){return this._isPingPong}}};


// c3/objects/animationFrameInfo.js
'use strict';{const C3=self.C3;C3.AnimationFrameInfo=class AnimationFrameInfo extends C3.DefendedBase{constructor(frameData){super();this._imageInfo=C3.New(C3.ImageInfo);this._imageInfo.LoadAnimationFrameData(frameData);this._duration=frameData[6];this._origin=C3.New(C3.Vector2,frameData[7],frameData[8]);this._imagePoints=frameData[9].map(data=>C3.New(C3.ImagePoint,this,data));this._imagePointsByName=new Map;for(const ip of this._imagePoints)this._imagePointsByName.set(ip.GetName().toLowerCase(),
ip);this._collisionPoly=null;const polyPoints=frameData[10];if(polyPoints.length>=6)this._collisionPoly=C3.New(C3.CollisionPoly,polyPoints)}Release(){if(this._collisionPoly){this._collisionPoly.Release();this._collisionPoly=null}this._imageInfo.Release();this._imageInfo=null}GetImageInfo(){return this._imageInfo}GetDuration(){return this._duration}GetOriginX(){return this._origin.getX()}GetOriginY(){return this._origin.getY()}GetCollisionPoly(){return this._collisionPoly}GetImagePointByName(name){return this._imagePointsByName.get(name.toLowerCase())||
null}GetImagePointByIndex(index){index=Math.floor(index);if(index<0||index>=this._imagePoints.length)return null;return this._imagePoints[index]}GetImagePointCount(){return this._imagePoints.length}}};


// c3/objects/imagePoint.js
'use strict';{const C3=self.C3;C3.ImagePoint=class ImagePoint extends C3.DefendedBase{constructor(afi,data){super();this._afi=afi;this._name=data[0];this._pos=C3.New(C3.Vector2,data[1],data[2])}Release(){}GetName(){return this._name}GetX(){return this._pos.getX()}GetY(){return this._pos.getY()}GetVec2(){return this._pos}}};


// c3/objects/objectClass.js
'use strict';{const C3=self.C3;const C3Debugger=self.C3Debugger;const IObjectClass=self.IObjectClass;const assert=self.assert;C3.ObjectClass=class ObjectClass extends C3.DefendedBase{constructor(runtime,index,data){super();const PluginCtor=runtime.GetObjectReference(data[1]);this._runtime=runtime;this._plugin=runtime.GetPluginManager().GetPluginByConstructorFunction(PluginCtor);this._sdkType=null;this._instSdkCtor=PluginCtor.Instance;this._index=index;this._sid=data[11];this._name=data[0];this._jsPropName=
this._runtime.GetJsPropName(data[14]);this._isGlobal=!!data[9];this._isFamily=!!data[2];this._isOnLoaderLayout=!!data[10];this._instVars=data[3].map(arr=>({sid:arr[0],type:arr[1],name:arr[2],jsPropName:runtime.GetJsPropName(arr[3])}));this._behaviorsCount=data[4];this._effectsCount=data[5];this._isWorldType=this._plugin.IsWorldType();this._effectList=null;this._collisionGrid=C3.New(C3.SparseGrid,runtime.GetOriginalViewportWidth(),runtime.GetOriginalViewportHeight());this._anyCollisionCellChanged=
true;this._anyInstanceParallaxed=false;this._familyMembers=null;this._familyMembersSet=null;this._familyIndex=-1;this._families=null;this._familiesSet=null;this._familyInstVarMap=null;this._familyBehaviorMap=null;this._familyEffectMap=null;this._isInContainer=false;this._container=null;this._behaviorTypes=data[8].map(behaviorTypeData=>C3.BehaviorType.Create(this,behaviorTypeData));this._behaviorTypesIncludingInherited=[];this._behaviorsByName=new Map;this._behaviorNameToIndex=new Map;this._usedBehaviorCtors=
new Set;this._solStack=C3.New(C3.SolStack,this);this._defaultInstanceData=null;this._defaultLayerIndex=0;this._isContained=false;this._container=null;this._imageInfo=null;this._animations=null;this._animationsByName=null;this._animationsBySid=null;this._textureRefCount=0;this._savedData=new Map;this._unsavedData=new Map;this._instances=[];this._iidsStale=true;if(this._plugin.HasEffects())this._effectList=C3.New(C3.EffectList,this,data[12]);if(data[6]){this._imageInfo=C3.New(C3.ImageInfo);this._imageInfo.LoadData(data[6])}if(data[7]){this._animations=
data[7].map(animData=>C3.New(C3.AnimationInfo,animData));this._animationsByName=new Map;this._animationsBySid=new Map;for(const anim of this._animations){this._animationsByName.set(anim.GetName().toLowerCase(),anim);this._animationsBySid.set(anim.GetSID(),anim)}}if(this._isFamily){this._familyMembers=[];this._familyMembersSet=new Set;this._familyIndex=this._runtime._GetNextFamilyIndex()}else{this._families=[];this._familiesSet=new Set;this._familyInstVarMap=[];this._familyBehaviorMap=[];this._familyEffectMap=
[]}this._sdkType=C3.New(PluginCtor.Type,this,data[15]);this._iObjectClass=null;this._instanceUserScriptClass=null;this._userScriptDispatcher=C3.New(C3.Event.Dispatcher);const CustomScriptClass=this._sdkType.GetScriptInterfaceClass();if(CustomScriptClass){this._iObjectClass=new CustomScriptClass(this);if(!(this._iObjectClass instanceof IObjectClass))throw new TypeError("script interface class must derive from IObjectClass");}else this._iObjectClass=new IObjectClass(this);if(data[13]){const tilemapData=
data[13];if(tilemapData){const tilePolyData=tilemapData[0];const maxTileIndex=tilemapData[1];this._sdkType.LoadTilemapData(tilePolyData,maxTileIndex)}}if(!this._runtime.UsesLoaderLayout()||this._isFamily||this._isOnLoaderLayout||!this._isWorldType)this.OnCreate();if(this._plugin.IsSingleGlobal()){this._plugin._SetSingleGlobalObjectClass(this);this._CreateSingleGlobalInstance(data)}}static Create(runtime,index,objectClassData){return C3.New(C3.ObjectClass,runtime,index,objectClassData)}Release(){if(this._imageInfo){this._imageInfo.Release();
this._imageInfo=null}if(this._animations){for(const a of this._animations)a.Release();C3.clearArray(this._animations);this._animationsByName.clear();this._animationsBySid.clear()}this._solStack.Release();this._solStack=null;this._savedData.clear();this._unsavedData.clear();this._container=null;this._runtime=null}_LoadFamily(familyData){for(let i=1,len=familyData.length;i<len;++i){const memberType=this._runtime.GetObjectClassByIndex(familyData[i]);this._familyMembers.push(memberType);this._familyMembersSet.add(memberType);
memberType._families.push(this);memberType._familiesSet.add(this)}}_SetContainer(container){this._isInContainer=true;this._container=container}IsInContainer(){return this._isInContainer}GetContainer(){return this._container}_OnAfterCreate(){let index=0;if(!this._isFamily)for(const family of this._families)for(const familyBehType of family.GetBehaviorTypes()){const lowerName=familyBehType.GetName().toLowerCase();this._behaviorsByName.set(lowerName,familyBehType);this._behaviorNameToIndex.set(lowerName,
index);this._behaviorTypesIncludingInherited.push(familyBehType);++index}for(const behaviorType of this.GetBehaviorTypes()){const lowerName=behaviorType.GetName().toLowerCase();this._behaviorsByName.set(lowerName,behaviorType);this._behaviorNameToIndex.set(lowerName,index);this._behaviorTypesIncludingInherited.push(behaviorType);++index}for(const behaviorType of this._behaviorTypesIncludingInherited)this._usedBehaviorCtors.add(behaviorType.GetBehavior().constructor);if(!this._isFamily&&this._families.length){const familyCount=
this._runtime.GetFamilyCount();C3.extendArray(this._familyInstVarMap,familyCount,0);C3.extendArray(this._familyBehaviorMap,familyCount,0);C3.extendArray(this._familyEffectMap,familyCount,0);const allFx=[];let ivSum=0;let behSum=0;let fxSum=0;for(const family of this._families){const familyIndex=family.GetFamilyIndex();this._familyInstVarMap[familyIndex]=ivSum;ivSum+=family.GetInstanceVariablesCount();this._familyBehaviorMap[familyIndex]=behSum;behSum+=family.GetBehaviorTypesCount();this._familyEffectMap[familyIndex]=
fxSum;fxSum+=family.GetEffectTypesCount();const familyEffectList=family.GetEffectList();if(familyEffectList&&this._effectList)for(const effectType of familyEffectList.GetAllEffectTypes())allFx.push(effectType.Clone(this._effectList))}if(this._effectList)this._effectList.PrependEffectTypes(allFx)}}_CreateSingleGlobalInstance(data){const uid=this._runtime._GetNewUID();const inst=C3.New(C3.Instance,{runtime:this._runtime,objectType:this,uid:uid});inst._CreateSdkInstance(data[16],[]);this._runtime._MapInstanceByUID(uid,
inst);this._instances.push(inst)}GetSdkType(){return this._sdkType}IsOnLoaderLayout(){return this._isOnLoaderLayout}OnCreate(){if(!this._isFamily)this._sdkType.OnCreate()}HasLoadedTextures(){return this._textureRefCount>0}LoadTextures(renderer){if(this._isFamily)return Promise.resolve();this._textureRefCount++;if(this._textureRefCount===1)return this._sdkType.LoadTextures(renderer)||Promise.resolve();else return Promise.resolve()}ReleaseTextures(){if(this._isFamily)return;this._textureRefCount--;
if(this._textureRefCount<0)throw new Error("released textures too many times");if(this._textureRefCount===0)this._sdkType.ReleaseTextures()}OnDynamicTextureLoadComplete(){if(this._isFamily)throw new Error("not applicable to family");this._sdkType.OnDynamicTextureLoadComplete()}PreloadTexturesWithInstances(renderer){if(this._isFamily)return Promise.resolve();return this._sdkType.PreloadTexturesWithInstances(renderer)}GetRuntime(){return this._runtime}GetPlugin(){return this._plugin}GetInstanceSdkCtor(){return this._instSdkCtor}GetName(){return this._name}GetJsPropName(){return this._jsPropName}GetIndex(){return this._index}GetSID(){return this._sid}IsFamily(){return this._isFamily}IsGlobal(){return this._isGlobal}IsWorldType(){return this._isWorldType}GetFamilyIndex(){return this._familyIndex}GetBehaviorTypes(){return this._behaviorTypes}GetBehaviorTypesCount(){return this._behaviorsCount}UsesBehaviorByCtor(Ctor){return Ctor&&
this._usedBehaviorCtors.has(Ctor)}GetInstanceVariablesCount(){return this._instVars.length}GetInstanceVariableSIDs(){return this._instVars.map(iv=>iv.sid)}GetInstanceVariableIndexBySID(sid){return this._instVars.findIndex(iv=>iv.sid===sid)}GetInstanceVariableIndexByName(name){return this._instVars.findIndex(iv=>iv.name===name)}_GetAllInstanceVariableNames(){return this._instVars.map(iv=>iv.name)}_GetAllInstanceVariableJsPropNames(){return this._instVars.map(iv=>iv.jsPropName)}GetInstanceVariableType(i){i=
Math.floor(i);if(i<0||i>=this._instVars.length)throw new RangeError("invalid instance variable index");return this._instVars[i].type}GetInstanceVariableName(i){i=Math.floor(i);if(i<0||i>=this._instVars.length)throw new RangeError("invalid instance variable index");return this._instVars[i].name}GetEffectTypesCount(){return this._effectsCount}GetBehaviorTypesIncludingInherited(){return this._behaviorTypesIncludingInherited}GetBehaviorTypeByName(name){return this._behaviorsByName.get(name.toLowerCase())||
null}GetBehaviorIndexByName(name){const ret=this._behaviorNameToIndex.get(name.toLowerCase());if(typeof ret==="undefined")return-1;else return ret}GetEffectList(){return this._effectList}HasEffects(){return this._plugin.HasEffects()}UsesEffects(){return this._effectList&&this._effectList.HasAnyEffectType()}GetSolStack(){return this._solStack}GetCurrentSol(){return this._solStack.GetCurrentSol()}GetImageInfo(){return this._imageInfo}SetDefaultInstanceData(d){this._defaultInstanceData=d}GetDefaultInstanceData(){return this._defaultInstanceData}_SetDefaultLayerIndex(i){this._defaultLayerIndex=
i}GetDefaultLayerIndex(){return this._defaultLayerIndex}GetAnimations(){return this._animations}GetAnimationCount(){return this._animations.length}GetFamilies(){return this._families}BelongsToFamily(family){return this._familiesSet.has(family)}GetFamilyMembers(){return this._familyMembers}FamilyHasMember(objectType){return this._familyMembersSet.has(objectType)}GetFamilyBehaviorOffset(familyIndex){return this._familyBehaviorMap[familyIndex]}GetFamilyInstanceVariableOffset(familyIndex){return this._familyInstVarMap[familyIndex]}GetAnimationByName(name){if(!this._animations)throw new Error("no animations");
return this._animationsByName.get(name.toLowerCase())||null}GetAnimationBySID(sid){if(!this._animations)throw new Error("no animations");return this._animationsBySid.get(sid)||null}GetFirstAnimationFrame(){if(!this._animations)throw new Error("no animations");return this._animations[0].GetFrameAt(0)}GetDefaultInstanceSize(){if(this._animations){const firstFrameInfo=this.GetFirstAnimationFrame().GetImageInfo();return[firstFrameInfo.GetWidth(),firstFrameInfo.GetHeight()]}else if(this._imageInfo)return[this._imageInfo.GetWidth(),
this._imageInfo.GetHeight()];else return[100,100]}GetSingleGlobalInstance(){if(!this._plugin.IsSingleGlobal())throw new Error("not a single-global plugin");return this._instances[0]}GetInstances(){return this._instances}*instances(){yield*this._instances}*instancesIncludingPendingCreate(){yield*this._instances;for(const inst of this._runtime._GetInstancesPendingCreate())if(inst.GetObjectClass()===this)yield inst}GetInstanceCount(){return this._instances.length}_AddInstance(inst){this._instances.push(inst)}_SetIIDsStale(){this._iidsStale=
true}_UpdateIIDs(){if(!this._iidsStale||this._isFamily)return;const instances=this._instances;let i=0;for(let len=instances.length;i<len;++i)instances[i]._SetIID(i);const instancesPendingCreate=this._runtime._GetInstancesPendingCreate();for(const inst of instancesPendingCreate)if(inst.GetObjectClass()===this)inst._SetIID(i++);this._iidsStale=false}GetInstanceByIID(i){const instances=this._instances;if(i<instances.length)return instances[i];i-=instances.length;const instancesPendingCreate=this._runtime._GetInstancesPendingCreate();
for(const inst of instancesPendingCreate)if(inst.GetObjectClass()===this){if(i===0)return inst;--i}return null}GetFirstPicked(fromInst){if(fromInst&&fromInst.IsInContainer()&&fromInst.GetObjectClass()!==this)for(const s of fromInst.siblings())if(s.GetObjectClass()===this)return s;const instances=this.GetCurrentSol().GetInstances();if(instances.length)return instances[0];else return null}GetPairedInstance(inst){const instances=this.GetCurrentSol().GetInstances();if(instances.length>0)return instances[inst.GetIID()%
instances.length];else return null}*allCorrespondingInstances(inst,objectClass){const myInstances=this.GetCurrentSol().GetInstances();const myInstanceCount=myInstances.length;const otherSol=objectClass.GetCurrentSol();const otherInstances=objectClass.GetCurrentSol().GetInstances();const otherInstanceCount=otherInstances.length;let index=inst.GetIID();if(objectClass.IsFamily()||!otherSol.IsSelectAll())index=otherInstances.indexOf(inst);const divisor=Math.ceil(myInstanceCount/otherInstanceCount);const remainder=
myInstanceCount%otherInstanceCount;let startIndex=0;let correspondCount=0;if(remainder===0||index<remainder){startIndex=index*divisor;correspondCount=divisor}else{startIndex=remainder*divisor+(index-remainder)*(divisor-1);correspondCount=divisor-1}for(let i=startIndex,end=startIndex+correspondCount;i<end;++i)yield myInstances[i]}FinishCondition(f){this._sdkType.FinishCondition(f)}ApplySolToContainer(){if(!this._isInContainer||this._isFamily)return;this._UpdateIIDs();const sol1=this.GetCurrentSol();
const sol1instances=sol1._GetOwnInstances();const selectAll=sol1.IsSelectAll();const es=this._runtime.GetCurrentEventStackFrame();const isOrBlock=es&&es.GetCurrentEvent()&&es.GetCurrentEvent().IsOrBlock();for(const containerType of this._container.objectTypes()){if(containerType===this)continue;containerType._UpdateIIDs();const sol2=containerType.GetCurrentSol();sol2._SetSelectAll(selectAll);if(!selectAll){const sol2instances=sol2._GetOwnInstances();C3.clearArray(sol2instances);for(const inst of sol1instances)sol2instances.push(containerType.GetInstanceByIID(inst.GetIID()));
if(isOrBlock){const sol1elseInstances=sol1._GetOwnElseInstances();const sol2elseInstances=sol2._GetOwnElseInstances();C3.clearArray(sol2elseInstances);for(const inst of sol1elseInstances)sol2elseInstances.push(containerType.GetInstanceByIID(inst.GetIID()))}}}}_TruncateContainerSols(useElseInstances,i){for(const containerType of this.GetContainer().objectTypes()){const sol=containerType.GetCurrentSol();if(useElseInstances)C3.truncateArray(sol._GetOwnElseInstances(),i);else C3.truncateArray(sol._GetOwnInstances(),
i)}}_GetCollisionCellGrid(){return this._collisionGrid}_SetAnyCollisionCellChanged(c){this._anyCollisionCellChanged=!!c}_SetAnyInstanceParallaxed(p){this._anyInstanceParallaxed=!!p}IsAnyInstanceParallaxed(){return this._anyInstanceParallaxed}_UpdateAllCollisionCells(){if(!this._anyCollisionCellChanged||!this._isWorldType)return;for(const inst of this._instances)inst.GetWorldInfo()._UpdateCollisionCell();for(const inst of this._runtime._GetInstancesPendingCreate())if(inst.GetObjectClass()===this)inst.GetWorldInfo()._UpdateCollisionCell();
this._anyCollisionCellChanged=false}GetSavedDataMap(){if(!this._savedData)this._savedData=new Map;return this._savedData}GetUnsavedDataMap(){if(!this._unsavedData)this._unsavedData=new Map;return this._unsavedData}HasSolidBehavior(){return this.UsesBehaviorByCtor(C3.Behaviors.solid)}HasNoSaveBehavior(){return this.UsesBehaviorByCtor(C3.Behaviors.NoSave)}HasPersistBehavior(){return this.UsesBehaviorByCtor(C3.Behaviors.Persist)}_SaveToJson(){const o={"instances":this._instances.map(inst=>inst.SaveToJson())};
if(this._savedData&&this._savedData.size)o["ex"]=C3.ToSuperJSON(this._savedData);return o}_LoadFromJson(o){if(this._savedData){this._savedData.clear();this._savedData=null}const ex=o["ex"];if(ex)this._savedData=C3.FromSuperJSON(ex);const existingInstances=this._instances;const loadInstances=o["instances"];for(let i=0,len=Math.min(existingInstances.length,loadInstances.length);i<len;++i)existingInstances[i].LoadFromJson(loadInstances[i]);for(let i=loadInstances.length,len=existingInstances.length;i<
len;++i)this._runtime.DestroyInstance(existingInstances[i]);for(let i=existingInstances.length,len=loadInstances.length;i<len;++i){const data=loadInstances[i];let layer=null;if(this.IsWorldType()){layer=this._runtime.GetMainRunningLayout().GetLayerBySID(data["w"]["l"]);if(!layer)continue}const inst=this._runtime.CreateInstanceFromData(this._defaultInstanceData||this,layer,false,0,0,true);inst.LoadFromJson(data)}this._SetIIDsStale()}GetIObjectClass(){return this._iObjectClass}UserScriptDispatcher(){return this._userScriptDispatcher}_GetUserScriptInstanceClass(){return this._instanceUserScriptClass}_SetUserScriptInstanceClass(Class){this._instanceUserScriptClass=
Class}DispatchUserScriptEvent(e){const runtime=this._runtime;const shouldTime=runtime.IsDebug()&&!runtime.GetEventSheetManager().IsInEventEngine();if(shouldTime)C3Debugger.StartMeasuringScriptTime();this._userScriptDispatcher.dispatchEvent(e);if(shouldTime)C3Debugger.AddScriptTime()}}};


// c3/objects/container.js
'use strict';{const C3=self.C3;C3.Container=class Container extends C3.DefendedBase{constructor(runtime,objectTypes){super();this._runtime=runtime;this._objectTypes=objectTypes;for(const objectType of this._objectTypes)objectType._SetContainer(this)}Release(){this._runtime=null}GetRuntime(){return this._runtime}GetObjectTypes(){return this._objectTypes}objectTypes(){return this._objectTypes}HasAnyWorldType(){return this._objectTypes.some(o=>o.IsWorldType())}}};


// c3/objects/instance.js
'use strict';{const C3=self.C3;const C3Debugger=self.C3Debugger;const IInstance=self.IInstance;const EMPTY_ARRAY=[];let nextPuid=0;const savedDataMaps=new WeakMap;const unsavedDataMaps=new WeakMap;const FLAG_DESTROYED=1<<0;const FLAG_TILEMAP=1<<1;const FLAG_MUST_PREDRAW=1<<2;const FLAG_SOLID_ENABLED=1<<3;const FLAG_JUMPTHRU_ENABLED=1<<4;C3.Instance=class Instance extends C3.DefendedBase{constructor(opts){super();this._runtime=opts.runtime;this._objectType=opts.objectType;this._worldInfo=null;this._sdkInst=
null;this._iScriptInterface=null;this._iid=0;this._uid=opts.uid;this._puid=nextPuid++;this._flags=0;this._instVarValues=EMPTY_ARRAY;this._behaviorInstances=EMPTY_ARRAY;const behaviorTypes=this._objectType.GetBehaviorTypesIncludingInherited();if(behaviorTypes.length>0)this._behaviorInstances=behaviorTypes.map((behaviorType,index)=>C3.New(C3.BehaviorInstance,{runtime:this._runtime,behaviorType:behaviorType,instance:this,index}));this._siblings=this._objectType.IsInContainer()?[]:null;this._timeScale=
-1;this._dispatcher=null;const plugin=this.GetPlugin();if(plugin.MustPreDraw())this._flags|=FLAG_MUST_PREDRAW;if(plugin.IsWorldType()){this._worldInfo=C3.New(C3.WorldInfo,this,opts.layer);if(opts.worldData)this._worldInfo.Init(opts.worldData);else{this._worldInfo.InitNoData();const [width,height]=this._objectType.GetDefaultInstanceSize();this._worldInfo.SetSize(width,height);if(this.GetObjectClass().UsesEffects())this._worldInfo.GetInstanceEffectList().LoadDefaultEffectParameters()}}if(opts.instVarData)this._LoadInstanceVariableData(opts.instVarData);
else this._LoadDefaultInstanceVariables()}Release(){if(this._iScriptInterface){this._iScriptInterface._Release();this._iScriptInterface=null}if(this._behaviorInstances.length>0){for(const behInst of this._behaviorInstances)behInst.Release();C3.clearArray(this._behaviorInstances)}this._sdkInst.Release();this._sdkInst=null;const savedData=savedDataMaps.get(this);if(savedData){savedData.clear();savedDataMaps.delete(this)}const unsavedData=unsavedDataMaps.get(this);if(unsavedData){unsavedData.clear();
unsavedDataMaps.delete(this)}if(this._siblings)C3.clearArray(this._siblings);if(this._dispatcher){this._dispatcher.Release();this._dispatcher=null}this._runtime=null;this._objectType=null;if(this._instVarValues.length>0)C3.clearArray(this._instVarValues);if(this._worldInfo){this._worldInfo.Release();this._worldInfo=null}}_LoadInstanceVariableData(instVarData){if(instVarData.length>0){this._instVarValues=[];C3.shallowAssignArray(this._instVarValues,instVarData)}}_LoadDefaultInstanceVariables(){const len=
this._objectType.GetInstanceVariablesCount();if(len===0)return;this._instVarValues=[];const typeToInitValue=[0,0,""];for(let i=0;i<len;++i)this._instVarValues.push(typeToInitValue[this._objectType.GetInstanceVariableType(i)])}_CreateSdkInstance(properties,behInstProperties){if(this._sdkInst)throw new Error("already got sdk instance");for(let i=0,len=this._behaviorInstances.length;i<len;++i){const behInst=this._behaviorInstances[i];behInst._CreateSdkInstance(behInstProperties?behInstProperties[i]:
null)}this._sdkInst=C3.New(this._objectType.GetInstanceSdkCtor(),this,properties);if(!(this._sdkInst instanceof C3.SDKInstanceBase))throw new Error("sdk type must derive from SDKInstanceBase");for(let i=0,len=this._behaviorInstances.length;i<len;++i)this._behaviorInstances[i].PostCreate();if(this._objectType._GetUserScriptInstanceClass())this._InitUserScriptInterface()}GetSdkInstance(){return this._sdkInst}GetWorldInfo(){return this._worldInfo}GetRuntime(){return this._runtime}GetTimeScale(){return this._timeScale}GetActiveTimeScale(){const ts=
this._timeScale;if(ts===-1)return this.GetRuntime().GetTimeScale();else return ts}SetTimeScale(ts){ts=+ts;if(ts<0||!isFinite(ts))ts=0;this._timeScale=ts}RestoreTimeScale(){this._timeScale=-1}Dispatcher(){if(!this._dispatcher)this._dispatcher=C3.New(C3.Event.Dispatcher);return this._dispatcher}Draw(renderer){this._sdkInst.Draw(renderer)}OnCreate(properties){this._sdkInst.OnCreate(properties)}_SetHasTilemap(){this._flags|=FLAG_TILEMAP}HasTilemap(){return(this._flags&FLAG_TILEMAP)!==0}_MarkDestroyed(){this._flags|=
FLAG_DESTROYED}IsDestroyed(){return(this._flags&FLAG_DESTROYED)!==0}MustPreDraw(){return(this._flags&FLAG_MUST_PREDRAW)!==0}_IsSolidEnabled(){return(this._flags&FLAG_SOLID_ENABLED)!==0}_SetSolidEnabled(e){if(e)this._flags|=FLAG_SOLID_ENABLED;else this._flags&=~FLAG_SOLID_ENABLED}_IsJumpthruEnabled(){return(this._flags&FLAG_JUMPTHRU_ENABLED)!==0}_SetJumpthruEnabled(e){if(e)this._flags|=FLAG_JUMPTHRU_ENABLED;else this._flags&=~FLAG_JUMPTHRU_ENABLED}SetFlag(bit,enable){bit<<=16;if(enable)this._flags|=
bit;else this._flags&=~bit}GetFlag(bit){return(this._flags&bit<<16)!==0}GetCurrentImageInfo(){return this._sdkInst.GetCurrentImageInfo()}GetCurrentSurfaceSize(){return this._sdkInst.GetCurrentSurfaceSize()}GetCurrentTexRect(){return this._sdkInst.GetCurrentTexRect()}GetImagePoint(nameOrIndex){return this._sdkInst.GetImagePoint(nameOrIndex)}GetObjectClass(){return this._objectType}BelongsToObjectClass(objectClass){if(objectClass.IsFamily())return objectClass.FamilyHasMember(this.GetObjectClass());
else return this.GetObjectClass()===objectClass}VerifySupportsSceneGraph(){if(!this.GetPlugin().SupportsSceneGraph())throw new Error("object does not support scene graph");}HasParent(){return this.GetParent()!==null}GetParent(){const wi=this.GetWorldInfo();if(!wi)return null;const parentWi=wi.GetParent();return parentWi?parentWi.GetInstance():null}GetTopParent(){const wi=this.GetWorldInfo();if(!wi)return null;const parentWi=wi.GetTopParent();return parentWi?parentWi.GetInstance():null}*parents(){const wi=
this.GetWorldInfo();if(!wi)return;for(const parentWi of wi.parents())yield parentWi.GetInstance()}HasChildren(){const wi=this.GetWorldInfo();return wi?wi.HasChildren():false}GetChildren(){const wi=this.GetWorldInfo();if(!wi)return[];return wi.GetChildren().map(wi=>wi.GetInstance())}*children(){const wi=this.GetWorldInfo();if(!wi)return;for(const childWi of wi.children())yield childWi.GetInstance()}*allChildren(){const wi=this.GetWorldInfo();if(!wi)return;for(const childWi of wi.allChildren())yield childWi.GetInstance()}GetChildCount(){const wi=
this.GetWorldInfo();return wi?wi.GetChildCount():0}GetChildAt(index){const wi=this.GetWorldInfo();if(!wi)return null;const childWi=wi.GetChildAt(index);return childWi?childWi.GetInstance():null}AddChild(childInst,opts){this.VerifySupportsSceneGraph();childInst.VerifySupportsSceneGraph();this.GetWorldInfo().AddChild(childInst.GetWorldInfo(),opts||{})}RemoveChild(childInst){const wi=this.GetWorldInfo();if(!wi)return;wi.RemoveChild(childInst.GetWorldInfo())}GetDestroyWithParent(){const wi=this.GetWorldInfo();
return wi?wi.GetDestroyWithParent():false}SetupInitialSceneGraphConnections(){const wi=this.GetWorldInfo();if(!wi)return;const childrenData=wi.GetSceneGraphChildrenExportData();if(!childrenData)return;for(const childData of childrenData){const child=this._runtime.GetInstanceByUID(childData[2]);if(child){const flags=childData[3];this.AddChild(child,{transformX:!!(flags>>0&1),transformY:!!(flags>>1&1),transformWidth:!!(flags>>2&1),transformHeight:!!(flags>>3&1),transformAngle:!!(flags>>4&1),destroyWithParent:!!(flags>>
5&1),transformZElevation:!!(flags>>6&1)})}}}IsInContainer(){return this._siblings!==null}_AddSibling(inst){this._siblings.push(inst)}GetSiblings(){return this._siblings}HasSibling(objectClass){return!!this.GetSibling(objectClass)}GetSibling(objectClass){const siblings=this.siblings();if(siblings===null||siblings.length===0)return false;for(const s of siblings)if(s.GetObjectClass()===objectClass)return s;return null}siblings(){return this._siblings}SetSiblingsSinglePicked(){for(const s of this.siblings())s.GetObjectClass().GetCurrentSol().SetSinglePicked(s)}_PushSiblingsToSolInstances(){for(const s of this.siblings())s.GetObjectClass().GetCurrentSol()._PushInstance(s)}_SetSiblingsToSolInstancesIndex(i){for(const s of this.siblings())s.GetObjectClass().GetCurrentSol()._GetOwnInstances()[i]=
s}_PushSiblingsToSolElseInstances(){for(const s of this.siblings())s.GetObjectClass().GetCurrentSol()._PushElseInstance(s)}_SetSiblingsToSolElseInstancesIndex(i){for(const s of this.siblings())s.GetObjectClass().GetCurrentSol()._GetOwnElseInstances()[i]=s}GetPlugin(){return this._objectType.GetPlugin()}_SetIID(i){this._iid=i}GetIID(){this._objectType._UpdateIIDs();return this._iid}GetUID(){return this._uid}GetPUID(){return this._puid}GetBehaviorInstances(){return this._behaviorInstances}GetBehaviorInstanceFromCtor(ctor){if(!ctor)return null;
for(const behInst of this._behaviorInstances)if(behInst.GetBehavior()instanceof ctor)return behInst;return null}GetBehaviorSdkInstanceFromCtor(ctor){if(!ctor)return null;const behInst=this.GetBehaviorInstanceFromCtor(ctor);if(behInst)return behInst.GetSdkInstance();else return null}GetBehaviorIndexBySID(sid){const behaviorInstances=this._behaviorInstances;for(let i=0,len=behaviorInstances.length;i<len;++i)if(behaviorInstances[i].GetBehaviorType().GetSID()===sid)return i;return-1}GetAllInstanceVariableValues(){return this._instVarValues}_GetAllInstanceVariableNames(){return this._objectType._GetAllInstanceVariableNames()}GetInstanceVariableCount(){return this._instVarValues.length}GetInstanceVariableValue(index){index=
index|0;const instVarValues=this._instVarValues;if(index<0||index>=instVarValues.length)throw new RangeError("invalid instance variable");return instVarValues[index]}_GetInstanceVariableValueUnchecked(index){return this._instVarValues[index]}_GetInstanceVariableTypedValue(index){const ret=this._instVarValues[index];if(this._objectType.GetInstanceVariableType(index)===0)return!!ret;else return ret}SetInstanceVariableValue(index,value){index=index|0;const instVarValues=this._instVarValues;if(index<
0||index>=instVarValues.length)throw new RangeError("invalid instance variable");const type=this._objectType.GetInstanceVariableType(index);switch(type){case 0:instVarValues[index]=value?1:0;break;case 1:instVarValues[index]=typeof value==="number"?value:parseFloat(value);break;case 2:instVarValues[index]=typeof value==="string"?value:value.toString();break;default:throw new Error("unknown instance variable type");}}SetInstanceVariableOffset(index,offset){if(offset===0)return;index=index|0;const instVarValues=
this._instVarValues;if(index<0||index>=instVarValues.length)throw new RangeError("invalid instance variable");const lastValue=instVarValues[index];if(typeof lastValue==="number")if(typeof offset==="number")instVarValues[index]+=offset;else instVarValues[index]+=parseFloat(offset);else if(typeof lastValue==="boolean")throw new Error("can not set offset of boolean variable");else if(typeof lastValue==="string")throw new Error("can not set offset of string variable");else throw new Error("unknown instance variable type");
}GetSavedDataMap(){let ret=savedDataMaps.get(this);if(ret)return ret;ret=new Map;savedDataMaps.set(this,ret);return ret}GetUnsavedDataMap(){let ret=unsavedDataMaps.get(this);if(ret)return ret;ret=new Map;unsavedDataMaps.set(this,ret);return ret}_HasAnyCreateDestroyHandler(name){const objectType=this.GetObjectClass();if(objectType.UserScriptDispatcher().HasAnyHandlerFor(name))return true;for(const family of objectType.GetFamilies())if(family.UserScriptDispatcher().HasAnyHandlerFor(name))return true;
if(this._runtime.UserScriptDispatcher().HasAnyHandlerFor(name))return true;return false}_TriggerOnCreatedOnSelfAndRelated(){const instancesToTriggerOnCreated=new Set;instancesToTriggerOnCreated.add(this);const wi=this.GetWorldInfo();if(wi&&wi.HasChildren())for(const c of this.allChildren()){instancesToTriggerOnCreated.add(c);if(!c.IsInContainer())continue;for(const s of c.siblings())instancesToTriggerOnCreated.add(s)}if(this.IsInContainer())for(const s of this.siblings())instancesToTriggerOnCreated.add(s);
for(const instance of instancesToTriggerOnCreated.values())instance._TriggerOnCreated()}_TriggerOnCreated(){if(this._HasAnyCreateDestroyHandler("instancecreate")){const objectType=this.GetObjectClass();const instCreateEvent=new C3.Event("instancecreate");instCreateEvent.instance=this.GetInterfaceClass();objectType.DispatchUserScriptEvent(instCreateEvent);for(const family of objectType.GetFamilies())family.DispatchUserScriptEvent(instCreateEvent);this._runtime.DispatchUserScriptEvent(instCreateEvent)}this._runtime.Trigger(this.GetPlugin().constructor.Cnds.OnCreated,
this,null)}_TriggerOnDestroyed(){this._runtime.Trigger(this.GetPlugin().constructor.Cnds.OnDestroyed,this,null)}_FireDestroyedScriptEvents(isEndingLayout){if(this._iScriptInterface){const e=new C3.Event("destroy");e.isEndingLayout=isEndingLayout;this.DispatchUserScriptEvent(e)}if(!this._HasAnyCreateDestroyHandler("instancedestroy"))return;const objectType=this.GetObjectClass();const instDestroyEvent=new C3.Event("instancedestroy");instDestroyEvent.instance=this.GetInterfaceClass();instDestroyEvent.isEndingLayout=
isEndingLayout;objectType.DispatchUserScriptEvent(instDestroyEvent);for(const family of objectType.GetFamilies())family.DispatchUserScriptEvent(instDestroyEvent);this._runtime.DispatchUserScriptEvent(instDestroyEvent)}_GetDebuggerProperties(){return this._sdkInst.GetDebuggerProperties()}SaveToJson(mode="full"){const o={};if(mode==="full")o["uid"]=this.GetUID();else o["c3"]=true;if(mode!=="visual-state"){const savedData=savedDataMaps.get(this);if(savedData&&savedData.size)o["ex"]=C3.ToSuperJSON(savedData);
if(this.GetTimeScale()!==-1)o["mts"]=this.GetTimeScale();if(this._objectType.GetInstanceVariablesCount()>0){const ivs={};const ivSids=this._objectType.GetInstanceVariableSIDs();for(let i=0,len=this._instVarValues.length;i<len;++i)ivs[ivSids[i].toString()]=this._instVarValues[i];o["ivs"]=ivs}if(this._behaviorInstances.length){const behs={};for(const behInst of this._behaviorInstances){const data=behInst.SaveToJson();if(data)behs[behInst.GetBehaviorType().GetSID().toString()]=data}o["behs"]=behs}}if(this._worldInfo)o["w"]=
this._worldInfo._SaveToJson(mode);const ownData=this._sdkInst.SaveToJson();if(ownData)o["data"]=ownData;return o}_OnBeforeLoad(mode="full"){if(this._worldInfo)this._worldInfo._OnBeforeLoad(mode)}LoadFromJson(o,mode="full"){if(mode==="full")this._uid=o["uid"];else if(!o["c3"])return;if(mode!=="visual-state"){let savedData=savedDataMaps.get(this);if(savedData){savedData.clear();savedDataMaps.delete(this)}const ex=o["ex"];if(ex){savedData=C3.FromSuperJSON(ex);savedDataMaps.set(this,savedData)}this._timeScale=
o.hasOwnProperty("mts")?o["mts"]:-1;const ivs=o["ivs"];if(ivs)for(const [sidStr,value]of Object.entries(ivs)){const sid=parseInt(sidStr,10);const index=this._objectType.GetInstanceVariableIndexBySID(sid);if(index<0||index>=this._instVarValues.length)continue;let v=value;if(v===null)v=NaN;this._instVarValues[index]=v}}if(this.GetPlugin().IsWorldType()){const worldData=o["w"];const layerSid=worldData["l"];if(this._worldInfo.GetLayer().GetSID()!==layerSid){const oldLayer=this._worldInfo.GetLayer();const newLayer=
oldLayer.GetLayout().GetLayerBySID(layerSid);if(newLayer){this._worldInfo._SetLayer(newLayer);oldLayer._RemoveInstance(this,true);newLayer._AddInstance(this,true);newLayer.SetZIndicesChanged();this._worldInfo.SetBboxChanged()}else if(mode==="full")this._runtime.DestroyInstance(this)}this._worldInfo._LoadFromJson(worldData,mode)}if(mode!=="visual-state"){const behs=o["behs"];if(behs)for(const [sidStr,data]of Object.entries(behs)){const sid=parseInt(sidStr,10);const index=this.GetBehaviorIndexBySID(sid);
if(index<0||index>=this._behaviorInstances.length)continue;this._behaviorInstances[index].LoadFromJson(data)}}const ownData=o["data"];if(ownData)this._sdkInst.LoadFromJson(ownData)}GetInterfaceClass(){return this._iScriptInterface||this._InitUserScriptInterface()}_InitUserScriptInterface(){const DefaultScriptClass=this._worldInfo?self.IWorldInstance:IInstance;const SdkScriptClass=this._sdkInst.GetScriptInterfaceClass();const UserScriptClass=this._objectType._GetUserScriptInstanceClass();const ScriptInterfaceClass=
UserScriptClass||SdkScriptClass||DefaultScriptClass;IInstance._Init(this);this._iScriptInterface=new ScriptInterfaceClass;IInstance._Init(null);if(SdkScriptClass&&!(this._iScriptInterface instanceof DefaultScriptClass))throw new TypeError(`script interface class '${SdkScriptClass.name}' does not extend the right base class '${DefaultScriptClass.name}'`);if(UserScriptClass){const ExpectedBaseClass=SdkScriptClass||DefaultScriptClass;if(!(this._iScriptInterface instanceof ExpectedBaseClass))throw new TypeError(`setInstanceClass(): class '${UserScriptClass.name}' does not extend the right base class '${ExpectedBaseClass.name}'`);
}return this._iScriptInterface}_GetInstVarsScriptDescriptor(instDescriptors){if(this._instVarValues.length===0)return;const varDescriptors={};const instVarJsPropNames=this._objectType._GetAllInstanceVariableJsPropNames();for(let i=0,len=instVarJsPropNames.length;i<len;++i)varDescriptors[instVarJsPropNames[i]]={configurable:false,enumerable:true,get:C3.Instance.prototype._GetInstanceVariableTypedValue.bind(this,i),set:C3.Instance.prototype.SetInstanceVariableValue.bind(this,i)};const instVarsObj=Object.create(Object.prototype,
varDescriptors);instDescriptors.instVars={value:instVarsObj,writable:false}}_GetBehaviorsScriptDescriptor(instDescriptors){const behaviorInstances=this._behaviorInstances;if(behaviorInstances.length===0)return;const behDescriptors={};for(const behInst of behaviorInstances)behDescriptors[behInst.GetBehaviorType().GetJsPropName()]={value:behInst.GetScriptInterface(),writable:false};const behaviorsObj=Object.create(Object.prototype,behDescriptors);instDescriptors.behaviors={value:behaviorsObj,writable:false}}DispatchUserScriptEvent(e){e.instance=
this.GetInterfaceClass();const runtime=this._runtime;const shouldTime=runtime.IsDebug()&&!runtime.GetEventSheetManager().IsInEventEngine();if(shouldTime)C3Debugger.StartMeasuringScriptTime();this.GetInterfaceClass().dispatchEvent(e);if(shouldTime)C3Debugger.AddScriptTime()}}};


// c3/objects/sceneGraphInfo.js
'use strict';{const C3=self.C3;C3.SceneGraphInfo=class SceneGraphInfo extends C3.DefendedBase{constructor(owner){super();this._owner=owner;this._parent=null;this._children=[];this._startWidth=owner.GetWidth();this._startHeight=owner.GetHeight();this._startScaleX=1;this._startScaleY=1;this._parentStartAngle=0}Release(){this._parent=null;C3.clearArray(this._children)}SetParent(parent){this._parent=parent;this._parentStartAngle=parent?parent.GetAngle():0}GetParent(){return this._parent}HasChildren(){return this._children.length>
0}GetChildren(){return this._children}GetStartScaleX(){return this._startScaleX}SetStartScaleX(sx){this._startScaleX=sx}GetStartScaleY(){return this._startScaleY}SetStartScaleY(sy){this._startScaleY=sy}_GetStartWidth(){return this._startWidth}_GetStartHeight(){return this._startHeight}GetParentScaleX(){if(this._owner.GetTransformWithParentWidth())return this._parent.GetWidth()/this._parent._GetSceneGraphInfo()._GetStartWidth();else return 1}GetParentScaleY(){if(this._owner.GetTransformWithParentHeight())return this._parent.GetHeight()/
this._parent._GetSceneGraphInfo()._GetStartHeight();else return 1}GetParentStartAngle(){return this._parentStartAngle}_SaveToJson(){return{"sw":this._startWidth,"sh":this._startHeight,"sx":this._startScaleX,"sy":this._startScaleY,"psa":this._parentStartAngle,"c":this._children.map(c=>{let flagsStr="";if(c.GetTransformWithParentX())flagsStr+="x";if(c.GetTransformWithParentY())flagsStr+="y";if(c.GetTransformWithParentWidth())flagsStr+="w";if(c.GetTransformWithParentHeight())flagsStr+="h";if(c.GetTransformWithParentAngle())flagsStr+=
"a";if(c.GetTransformWithParentZElevation())flagsStr+="z";if(c.GetDestroyWithParent())flagsStr+="d";return{"uid":c.GetInstance().GetUID(),"f":flagsStr}})}}_LoadFromJson(o){this._startWidth=o["sw"];this._startHeight=o["sh"];this._startScaleX=o["sx"];this._startScaleY=o["sy"];this._parentStartAngle=o["psa"]}_OnAfterLoad(o){const owner=this._owner;const runtime=owner.GetRuntime();for(const childData of o["c"]){const childUid=childData["uid"];const childInst=runtime.GetInstanceByUID(childUid);const childWi=
childInst.GetWorldInfo();const flagsStr=childData["f"];const opts={};opts.transformX=flagsStr.includes("x");opts.transformY=flagsStr.includes("y");opts.transformWidth=flagsStr.includes("w");opts.transformHeight=flagsStr.includes("h");opts.transformAngle=flagsStr.includes("a");opts.transformZElevation=flagsStr.includes("z");opts.destroyWithParent=flagsStr.includes("d");owner.AddChild(childWi,opts)}}}};


// c3/objects/worldInfo.js
'use strict';{const C3=self.C3;const tempRect=C3.New(C3.Rect);const tempQuad=C3.New(C3.Quad);const bboxChangeEvent=C3.New(C3.Event,"bboxchange",false);const tempColor=C3.New(C3.Color,0,0,0,0);const tempCollisionPoly=C3.New(C3.CollisionPoly);const DEFAULT_COLOR=C3.New(C3.Color,1,1,1,1);const DEFAULT_RENDER_CELLS=C3.New(C3.Rect,0,0,-1,-1);const DEFAULT_COLLISION_CELLS=C3.New(C3.Rect,0,0,-1,-1);const VALID_SET_MESH_POINT_MODES=new Set(["absolute","relative"]);const EMPTY_ARRAY=[];let enableUpdateRendererStateGroup=
true;const FLAG_IS_VISIBLE=1<<0;const FLAG_BBOX_CHANGED=1<<1;const FLAG_ENABLE_BBOX_CHANGED_EVENT=1<<2;const FLAG_COLLISION_ENABLED=1<<3;const FLAG_COLLISION_CELL_CHANGED=1<<4;const FLAG_SOLID_FILTER_INCLUSIVE=1<<5;const FLAG_HAS_ANY_ACTIVE_EFFECT=1<<6;const FLAG_IS_ROTATABLE=1<<7;const FLAG_DESTROYED=1<<8;const FLAG_DESTROY_WITH_PARENT=1<<9;const FLAG_TRANSFORM_WITH_PARENT_X=1<<10;const FLAG_TRANSFORM_WITH_PARENT_Y=1<<11;const FLAG_TRANSFORM_WITH_PARENT_W=1<<12;const FLAG_TRANSFORM_WITH_PARENT_H=
1<<13;const FLAG_TRANSFORM_WITH_PARENT_A=1<<14;const FLAG_TRANSFORM_WITH_PARENT_Z_ELEVATION=1<<15;const MASK_ALL_SCENE_GRAPH_FLAGS=FLAG_DESTROY_WITH_PARENT|FLAG_TRANSFORM_WITH_PARENT_X|FLAG_TRANSFORM_WITH_PARENT_Y|FLAG_TRANSFORM_WITH_PARENT_W|FLAG_TRANSFORM_WITH_PARENT_H|FLAG_TRANSFORM_WITH_PARENT_A|FLAG_TRANSFORM_WITH_PARENT_Z_ELEVATION;const FLAG_MESH_CHANGED=1<<16;const FLAG_PHYSICS_BODY_CHANGED=1<<17;const FLAG_SIN_COS_ANGLE_CHANGED=1<<18;const FLAG_BLEND_MODE_BIT_OFFSET=26;const FLAG_BLEND_MODE_MASK=
31<<FLAG_BLEND_MODE_BIT_OFFSET;C3.WorldInfo=class WorldInfo extends C3.DefendedBase{constructor(inst,layer){super();this._inst=inst;this._objectClass=inst.GetObjectClass();this._runtime=inst.GetRuntime();this._layer=layer;this._zIndex=-1;this._flags=FLAG_IS_VISIBLE|FLAG_BBOX_CHANGED|FLAG_COLLISION_ENABLED|FLAG_COLLISION_CELL_CHANGED|FLAG_MESH_CHANGED|FLAG_PHYSICS_BODY_CHANGED;if(this._objectClass.GetPlugin().IsRotatable())this._flags|=FLAG_IS_ROTATABLE;this._x=NaN;this._y=NaN;this._zElevation=NaN;
this._w=NaN;this._h=NaN;this._a=NaN;this._sinA=NaN;this._cosA=NaN;this._ox=NaN;this._oy=NaN;this._boundingBox=C3.New(C3.Rect);this._boundingQuad=C3.New(C3.Quad);this._collisionCells=DEFAULT_COLLISION_CELLS;this._renderCells=DEFAULT_RENDER_CELLS;this._sourceCollisionPoly=null;this._transformedPolyInfo=null;this._solidFilterTags=null;this._color=DEFAULT_COLOR;this._colorPremultiplied=DEFAULT_COLOR;this._stateGroup=null;this._instanceEffectList=null;if(this._inst.GetObjectClass().UsesEffects())this._instanceEffectList=
C3.New(C3.InstanceEffectList,this._inst,this);this._sceneGraphInfo=null;this._sceneGraphFlagsExportData=NaN;this._sceneGraphChildrenExportData=null;this._sceneGraphZIndexExportData=NaN;this._sceneGraphZIndex=NaN;this._meshInfo=null}_MarkDestroyed(){this._flags|=FLAG_DESTROYED}Release(){if(this._stateGroup){this._runtime.GetRenderer().ReleaseStateGroup(this._stateGroup);this._stateGroup=null}this._sourceCollisionPoly=null;if(this._transformedPolyInfo){this._transformedPolyInfo.poly.Release();this._transformedPolyInfo=
null}if(this._solidFilterTags){this._solidFilterTags.clear();this._solidFilterTags=null}this.ReleaseMesh();if(this.HasParent())this.GetParent().RemoveChild(this);if(this.HasChildren()){const childrenToRelease=[...this.GetChildren()];for(const child of childrenToRelease)this.RemoveChild(child)}this._ReleaseSceneGraphInfo();this._inst=null;this._objectClass=null;this._runtime=null;this._layer=null}Init(data){enableUpdateRendererStateGroup=false;this.SetXY(data[0],data[1]);this.SetZElevation(data[2]);
this.SetSize(data[3],data[4]);if(this.IsRotatable())this.SetAngle(data[6]);else this._a=0;tempColor.setFromJSON(data[7]);this._SetColor(tempColor);this.SetOriginX(data[8]);this.SetOriginY(data[9]);this.SetBlendMode(data[10]);if(this._instanceEffectList)this._instanceEffectList._LoadEffectParameters(data[12]);if(data[14]){this._sceneGraphFlagsExportData=data[14][0];this._sceneGraphChildrenExportData=data[14][1];this._sceneGraphZIndexExportData=data[14][2]}if(data[15]){const meshData=data[15];this.CreateMesh(meshData[0],
meshData[1]);const sourceMesh=this.GetSourceMesh();const meshRows=meshData[2];for(let y=0,lenY=meshRows.length;y<lenY;++y){const rowData=meshRows[y];for(let x=0,lenX=rowData.length;x<lenX;++x){const d=rowData[x];const pt=sourceMesh.GetMeshPointAt(x,y);pt.SetX(d[0]);pt.SetY(d[1]);pt.SetZElevation(d[2]);pt.SetU(d[3]);pt.SetV(d[4])}}}enableUpdateRendererStateGroup=true;this._UpdateRendererStateGroup()}InitNoData(){this._x=0;this._y=0;this._zElevation=0;this._w=0;this._h=0;this._a=0;this._sinA=0;this._cosA=
1;this._ox=0;this._oy=0;this._UpdateRendererStateGroup()}GetRuntime(){return this._runtime}GetObjectClass(){return this._objectClass}GetInstance(){return this._inst}_GetParentOffsetAngle(){if(this.GetTransformWithParentAngle())return this.GetParent().GetAngle()-this._sceneGraphInfo.GetParentStartAngle();else return 0}SetX(x){x=+x;if(this.GetTransformWithParentX()){const sgi=this._sceneGraphInfo;const dx=x-this.GetX();const da=-this._GetParentOffsetAngle();if(da===0)this._x+=dx/sgi.GetParentScaleX();
else{this._x+=Math.cos(da)*dx/sgi.GetParentScaleX();if(this.GetTransformWithParentY())this._y+=Math.sin(da)*dx/sgi.GetParentScaleY()}}else this._x=x}OffsetX(x){x=+x;if(this.GetTransformWithParentX())this.SetX(this.GetX()+x);else this._x+=x}GetX(){if(this.GetTransformWithParentX()){let x=this._x;const sgi=this._sceneGraphInfo;const parent=this.GetParent();const da=this._GetParentOffsetAngle();if(da===0)x*=sgi.GetParentScaleX();else{x=x*sgi.GetParentScaleX()*Math.cos(da);if(this.GetTransformWithParentY())x-=
this._y*sgi.GetParentScaleY()*Math.sin(da)}return parent.GetX()+x}else return this._x}SetY(y){y=+y;if(this.GetTransformWithParentY()){const sgi=this._sceneGraphInfo;const dy=y-this.GetY();const da=-this._GetParentOffsetAngle();if(da===0)this._y+=dy/sgi.GetParentScaleY();else{if(this.GetTransformWithParentX())this._x-=Math.sin(da)*dy/sgi.GetParentScaleX();this._y+=Math.cos(da)*dy/sgi.GetParentScaleY()}}else this._y=y}OffsetY(y){y=+y;if(this.GetTransformWithParentY())this.SetY(this.GetY()+y);else this._y+=
y}GetY(){if(this.GetTransformWithParentY()){let y=this._y;const sgi=this._sceneGraphInfo;const parent=this.GetParent();const da=this._GetParentOffsetAngle();if(da===0)y*=sgi.GetParentScaleY();else{y=y*sgi.GetParentScaleY()*Math.cos(da);if(this.GetTransformWithParentX())y+=this._x*sgi.GetParentScaleX()*Math.sin(da)}return parent.GetY()+y}else return this._y}SetXY(x,y){x=+x;y=+y;if(this.GetTransformWithParentXOrY()){const isTransformX=this.GetTransformWithParentX();const isTransformY=this.GetTransformWithParentY();
const sgi=this._sceneGraphInfo;const dx=x-this.GetX();const dy=y-this.GetY();const da=-this._GetParentOffsetAngle();if(da===0){if(isTransformX)this._x+=dx/sgi.GetParentScaleX();else this._x=x;if(isTransformY)this._y+=dy/sgi.GetParentScaleY();else this._y=y}else{const sinDa=Math.sin(da);const cosDa=Math.cos(da);if(isTransformX)if(isTransformY)this._x+=(cosDa*dx-sinDa*dy)/sgi.GetParentScaleX();else this._x+=cosDa*dx/sgi.GetParentScaleX();else this._x=x;if(isTransformY)if(isTransformX)this._y+=(sinDa*
dx+cosDa*dy)/sgi.GetParentScaleY();else this._y+=cosDa*dy/sgi.GetParentScaleY();else this._y=y}}else{this._x=x;this._y=y}}OffsetXY(x,y){x=+x;y=+y;if(this.GetTransformWithParentXOrY())this.SetXY(this.GetX()+x,this.GetY()+y);else{this._x+=x;this._y+=y}}EqualsXY(x,y){return this.GetX()===x&&this.GetY()===y}SetZElevation(z){z=+z;if(this.GetTransformWithParentZElevation())z-=this.GetParent().GetZElevation();if(this._zElevation===z)return;this._zElevation=z;this._UpdateZElevation();const layer=this.GetLayer();
if(this._zElevation!==0)layer._SetAnyInstanceZElevated();layer.SetZIndicesChanged()}_UpdateZElevation(){this._UpdateRendererStateGroup();if(this.HasChildren()){const children=this.GetChildren();for(let i=0,len=children.length;i<len;i++){const child=children[i];if(child.GetTransformWithParentZElevation())child._UpdateZElevation()}}}OffsetZElevation(z){this.SetZElevation(this.GetZElevation()+z)}GetZElevation(){if(this.GetTransformWithParentZElevation())return this.GetParent().GetZElevation()+this._zElevation;
else return this._zElevation}GetTotalZElevation(){return this.GetLayer().GetZElevation()+this.GetZElevation()}SetWidth(w){w=+w;if(this.GetTransformWithParentWidth())this._w*=w/this.GetWidth();else this._w=w}OffsetWidth(w){w=+w;if(this.GetTransformWithParentWidth())this.SetWidth(this.GetWidth()+w);else this._w+=w}GetWidth(){if(this.GetTransformWithParentWidth())return this.GetParent().GetWidth()*this._w;else return this._w}SetHeight(h){h=+h;if(this.GetTransformWithParentHeight())this._h*=h/this.GetHeight();
else this._h=h}OffsetHeight(h){h=+h;if(this.GetTransformWithParentHeight())this.SetHeight(this.GetHeight()+h);else this._h+=h}GetHeight(){if(this.GetTransformWithParentHeight())return this.GetParent().GetHeight()*this._h;else return this._h}SetSize(w,h){w=+w;h=+h;if(this.GetTransformWithParentWidth())this._w*=w/this.GetWidth();else this._w=w;if(this.GetTransformWithParentHeight())this._h*=h/this.GetHeight();else this._h=h}GetSceneGraphScale(){if(this.HasParent()){const sgi=this._sceneGraphInfo;return Math.min(sgi.GetParentScaleX(),
sgi.GetParentScaleY())}else return 1}IsRotatable(){return(this._flags&FLAG_IS_ROTATABLE)!==0}SetAngle(a){a=+a;if(!this.IsRotatable())return;if(this.GetTransformWithParentAngle())a-=this.GetParent().GetAngle();a=C3.clampAngle(a);if(this._a===a)return;this._a=a;this._MarkSinCosAngleChanged()}OffsetAngle(a){a=+a;if(a===0||!this.IsRotatable())return;this._a=C3.clampAngle(this._a+a);this._MarkSinCosAngleChanged()}_MarkSinCosAngleChanged(){this._flags|=FLAG_SIN_COS_ANGLE_CHANGED;if(this.HasChildren()){const children=
this.GetChildren();for(let i=0,len=children.length;i<len;i++)children[i]._MarkSinCosAngleChanged()}}GetAngle(){if(this.GetTransformWithParentAngle())return C3.clampAngle(this.GetParent().GetAngle()+this._a);else return this._a}_MaybeUpdateSinCosAngle(){const flags=this._flags;if((flags&FLAG_SIN_COS_ANGLE_CHANGED)===0)return;const a=this.GetAngle();this._sinA=Math.sin(a);this._cosA=Math.cos(a);this._flags=flags&~FLAG_SIN_COS_ANGLE_CHANGED}GetSinAngle(){this._MaybeUpdateSinCosAngle();return this._sinA}GetCosAngle(){this._MaybeUpdateSinCosAngle();
return this._cosA}SetOriginX(x){this._ox=+x}OffsetOriginX(x){this._ox+=+x}GetOriginX(){return this._ox}SetOriginY(y){this._oy=+y}OffsetOriginY(y){this._oy+=+y}GetOriginY(){return this._oy}_SetColor(c){if(this._color.equals(c))return;if(this._color===DEFAULT_COLOR){this._color=C3.New(C3.Color,c);this._colorPremultiplied=C3.New(C3.Color,c);this._colorPremultiplied.premultiply()}else if(c.equalsRgba(1,1,1,1)){this._color=DEFAULT_COLOR;this._colorPremultiplied=DEFAULT_COLOR}else{this._color.set(c);this._colorPremultiplied.set(c);
this._colorPremultiplied.premultiply()}this._UpdateRendererStateGroup()}SetOpacity(o){o=C3.clamp(+o,0,1);if(this._color.a===o)return;tempColor.copyRgb(this._color);tempColor.a=o;this._SetColor(tempColor)}OffsetOpacity(o){this.SetOpacity(this.GetOpacity()+o)}GetOpacity(){return this._color.a}SetUnpremultipliedColor(c){if(this._color.equalsIgnoringAlpha(c))return;tempColor.copyRgb(c);tempColor.a=this._color.a;this._SetColor(tempColor)}SetUnpremultipliedColorRGB(r,g,b){tempColor.setRgb(r,g,b);this.SetUnpremultipliedColor(tempColor)}OffsetUnpremultipliedColorRGB(r,
g,b){if(r===0&&g===0&&b===0)return;tempColor.copyRgb(this._color);tempColor.r+=r;tempColor.g+=g;tempColor.b+=b;this.SetUnpremultipliedColor(tempColor)}GetUnpremultipliedColor(){return this._color}GetPremultipliedColor(){return this._colorPremultiplied}GetDestroyWithParent(){return(this._flags&FLAG_DESTROY_WITH_PARENT)!==0}SetDestroyWithParent(d){this._SetFlag(FLAG_DESTROY_WITH_PARENT,d)}GetTransformWithParentX(){return(this._flags&FLAG_TRANSFORM_WITH_PARENT_X)!==0}SetTransformWithParentX(tpx){this._SetFlag(FLAG_TRANSFORM_WITH_PARENT_X,
tpx)}GetTransformWithParentY(){return(this._flags&FLAG_TRANSFORM_WITH_PARENT_Y)!==0}GetTransformWithParentXOrY(){return(this._flags&(FLAG_TRANSFORM_WITH_PARENT_X|FLAG_TRANSFORM_WITH_PARENT_Y))!==0}SetTransformWithParentY(tpx){this._SetFlag(FLAG_TRANSFORM_WITH_PARENT_Y,tpx)}GetTransformWithParentWidth(){return(this._flags&FLAG_TRANSFORM_WITH_PARENT_W)!==0}SetTransformWithParentWidth(tpw){this._SetFlag(FLAG_TRANSFORM_WITH_PARENT_W,tpw)}GetTransformWithParentHeight(){return(this._flags&FLAG_TRANSFORM_WITH_PARENT_H)!==
0}SetTransformWithParentHeight(tph){this._SetFlag(FLAG_TRANSFORM_WITH_PARENT_H,tph)}GetTransformWithParentAngle(){return(this._flags&FLAG_TRANSFORM_WITH_PARENT_A)!==0}SetTransformWithParentAngle(tpa){this._SetFlag(FLAG_TRANSFORM_WITH_PARENT_A,tpa)}GetTransformWithParentZElevation(){return(this._flags&FLAG_TRANSFORM_WITH_PARENT_Z_ELEVATION)!==0}SetTransformWithParentZElevation(tpz){this._SetFlag(FLAG_TRANSFORM_WITH_PARENT_Z_ELEVATION,tpz)}_ClearAllSceneGraphFlags(){this._flags&=~MASK_ALL_SCENE_GRAPH_FLAGS}AddChild(child,
opts){if(child===this)return;if(child.HasParent())return;if(this._HasChildRecursive(child))return;if(this._HasAnyParent(child))return;const absX=child.GetX();const absY=child.GetY();const absW=child.GetWidth();const absH=child.GetHeight();const absA=child.GetAngle();const absZElevation=child.GetZElevation();child._SetParent(this);child.SetTransformWithParentX(opts.transformX);child.SetTransformWithParentY(opts.transformY);child.SetTransformWithParentWidth(opts.transformWidth);child.SetTransformWithParentHeight(opts.transformHeight);
child.SetTransformWithParentAngle(opts.transformAngle);child.SetTransformWithParentZElevation(opts.transformZElevation);child.SetDestroyWithParent(opts.destroyWithParent);if(opts.transformX){child._x=absX-this.GetX();if(opts.transformWidth)child._x/=this.GetWidth()/this._sceneGraphInfo._GetStartWidth()}if(opts.transformY){child._y=absY-this.GetY();if(opts.transformHeight)child._y/=this.GetHeight()/this._sceneGraphInfo._GetStartHeight()}if(opts.transformWidth){child._w=absW/this.GetWidth();child._sceneGraphInfo.SetStartScaleX(child._w)}if(opts.transformHeight){child._h=
absH/this.GetHeight();child._sceneGraphInfo.SetStartScaleY(child._h)}if(opts.transformAngle)child._a=absA-this.GetAngle();if(opts.transformZElevation)child._zElevation=absZElevation-this.GetZElevation();this._AddChildToSceneGraphInfo(child);this.SetBboxChanged()}RemoveChild(child){if(child.GetParent()!==this)return;const absX=child.GetX();const absY=child.GetY();const absW=child.GetWidth();const absH=child.GetHeight();const absA=child.GetAngle();const absZElevation=child.GetZElevation();child._SetParent(null);
child._ClearAllSceneGraphFlags();child.SetXY(absX,absY);child.SetSize(absW,absH);child.SetAngle(absA);child.SetZElevation(absZElevation);this._RemoveChildFromSceneGraphInfo(child);this.SetBboxChanged()}_ResetAllSceneGraphState(){for(const c of this.children())this.RemoveChild(c);const parent=this.GetParent();if(parent)parent.RemoveChild(this);this._ClearAllSceneGraphFlags()}HasParent(){return this.GetParent()!==null}GetParent(){const sgi=this._sceneGraphInfo;return sgi!==null?sgi.GetParent():null}GetTopParent(){let p=
this;while(p.HasParent())p=p.GetParent();return p}*parents(){let parent=this.GetParent();while(parent){yield parent;parent=parent.GetParent()}}HasChild(child){return this.GetChildren().includes(child)}HasChildren(){const sgi=this._sceneGraphInfo;return sgi!==null?sgi.HasChildren():false}GetChildren(){const sgi=this._sceneGraphInfo;return sgi!==null?sgi.GetChildren():EMPTY_ARRAY}children(){return this.GetChildren()}*allChildren(){for(const child of this.children()){yield child;yield*child.allChildren()}}GetChildCount(){return this.GetChildren().length}GetChildAt(index){const children=
this.GetChildren();index=Math.floor(+index);if(index<0||index>=children.length)return null;return children[index]}_CreateSceneGraphInfo(parent){if(!this._sceneGraphInfo)this._sceneGraphInfo=C3.New(C3.SceneGraphInfo,this);if(parent)this._sceneGraphInfo.SetParent(parent)}_GetSceneGraphInfo(){return this._sceneGraphInfo}_ReleaseSceneGraphInfo(){if(!this._sceneGraphInfo)return;this._sceneGraphInfo.Release();this._sceneGraphInfo=null}_SetParent(parent){if(parent){parent._CreateSceneGraphInfo(null);this._CreateSceneGraphInfo(parent)}else{if(this._sceneGraphInfo)this._sceneGraphInfo.SetParent(null);
if(!this.HasChildren())this._ReleaseSceneGraphInfo()}}_HasAnyParent(child){if(!this.HasParent())return false;const parent=this.GetParent();if(parent===child)return true;return parent._HasAnyParent(child)}_HasChildRecursive(child){if(this.HasChild(child))return true;for(const c of this.GetChildren())if(c._HasChildRecursive(child))return true;return false}_AddChildToSceneGraphInfo(child){this._sceneGraphInfo.GetChildren().push(child)}_RemoveChildFromSceneGraphInfo(child){const children=this._sceneGraphInfo.GetChildren();
const index=children.indexOf(child);if(index!==-1)children.splice(index,1);if(children.length===0&&!this.HasParent())this._ReleaseSceneGraphInfo();if(!child.HasChildren())child._ReleaseSceneGraphInfo()}GetSceneGraphChildrenExportData(){return this._sceneGraphChildrenExportData}GetSceneGraphZIndexExportData(){return this._sceneGraphZIndexExportData}GetSceneGraphZIndex(){return this._sceneGraphZIndex}SetSceneGraphZIndex(z){this._sceneGraphZIndex=z}_UpdateRendererStateGroup(){if(!enableUpdateRendererStateGroup)return;
const renderer=this._runtime.GetRenderer();if(this._stateGroup)renderer.ReleaseStateGroup(this._stateGroup);this._stateGroup=renderer.AcquireStateGroup(renderer.GetTextureFillShaderProgram()||"<default>",this.GetBlendMode(),this._colorPremultiplied,this.GetZElevation())}GetRendererStateGroup(){return this._stateGroup}HasDefaultColor(){return this._color===DEFAULT_COLOR}SetBlendMode(bm){bm=bm|0;if(bm<0||bm>31)throw new RangeError("invalid blend mode");if(this.GetBlendMode()===bm)return;this._flags=
this._flags&~FLAG_BLEND_MODE_MASK|bm<<FLAG_BLEND_MODE_BIT_OFFSET;this._UpdateRendererStateGroup()}GetBlendMode(){return(this._flags&FLAG_BLEND_MODE_MASK)>>FLAG_BLEND_MODE_BIT_OFFSET}_SetLayer(layer){this._layer=layer;if(this.GetZElevation()!==0)this._layer._SetAnyInstanceZElevated()}GetLayer(){return this._layer}GetLayout(){return this.GetLayer().GetLayout()}_SetZIndex(z){this._zIndex=z|0}GetZIndex(){this._layer._UpdateZIndices();return this._zIndex}_GetLastCachedZIndex(){return this._zIndex}_SetFlag(bit,
enable){if(enable)this._flags|=bit;else this._flags&=~bit}IsVisible(){return(this._flags&FLAG_IS_VISIBLE)!==0}SetVisible(v){this._SetFlag(FLAG_IS_VISIBLE,v)}IsCollisionEnabled(){return(this._flags&FLAG_COLLISION_ENABLED)!==0}SetCollisionEnabled(e){e=!!e;if(this.IsCollisionEnabled()===e)return;this._SetFlag(FLAG_COLLISION_ENABLED,e);if(e)this.SetBboxChanged();else this._RemoveFromCollisionCells()}SetSolidCollisionFilter(isInclusive,tags){this._SetFlag(FLAG_SOLID_FILTER_INCLUSIVE,isInclusive);if(this._solidFilterTags)this._solidFilterTags.clear();
if(!tags.trim()){this._solidFilterTags=null;return}if(!this._solidFilterTags)this._solidFilterTags=new Set;for(const tag of tags.split(" "))if(tag)this._solidFilterTags.add(tag.toLowerCase())}IsSolidCollisionAllowed(solidTagSet){const isInclusive=(this._flags&FLAG_SOLID_FILTER_INCLUSIVE)!==0;const filterTags=this._solidFilterTags;if(!solidTagSet||!filterTags)return!isInclusive;for(const tag of filterTags)if(solidTagSet.has(tag))return isInclusive;return!isInclusive}SetBboxChanged(){this._flags|=FLAG_BBOX_CHANGED|
FLAG_COLLISION_CELL_CHANGED|FLAG_MESH_CHANGED;this._objectClass._SetAnyCollisionCellChanged(true);this._runtime.UpdateRender();if(this._layer.UsesRenderCells()){this.CalculateBbox(this._boundingBox,this._boundingQuad,true);this._flags&=~FLAG_BBOX_CHANGED;this._UpdateRenderCell()}if((this._flags&FLAG_ENABLE_BBOX_CHANGED_EVENT)!==0)this._inst.Dispatcher().dispatchEvent(bboxChangeEvent);if(this._sceneGraphInfo!==null){const children=this._sceneGraphInfo.GetChildren();for(let i=0,len=children.length;i<
len;++i)children[i].SetBboxChanged()}}CalculateBbox(bbox,bquad,includeMesh){const x=this.GetX();const y=this.GetY();const w=this.GetWidth();const h=this.GetHeight();const a=this.GetAngle();bbox.setWH(x-this._ox*w,y-this._oy*h,w,h);if(includeMesh&&this.HasMesh())this._ExpandBboxForMesh(bbox);if(a===0)bquad.setFromRect(bbox);else{bbox.offset(-x,-y);bquad.setFromRotatedRectPrecalc(bbox,this.GetSinAngle(),this.GetCosAngle());bquad.offset(x,y);bquad.getBoundingBox(bbox)}bbox.normalize()}_UpdateBbox(){const flags=
this._flags;if((flags&FLAG_BBOX_CHANGED)!==0){this.CalculateBbox(this._boundingBox,this._boundingQuad,true);this._flags=flags&~FLAG_BBOX_CHANGED}}GetBoundingBox(){this._UpdateBbox();return this._boundingBox}GetBoundingQuad(){this._UpdateBbox();return this._boundingQuad}PixelRoundQuad(quad){const x=this.GetX();const y=this.GetY();const ox=Math.round(x)-x;const oy=Math.round(y)-y;if(ox===0&&oy===0)return quad;else{tempQuad.copy(quad);tempQuad.offset(ox,oy);return tempQuad}}OverwriteBoundingBox(box){this._boundingBox.copy(box);
this._boundingQuad.setFromRect(this._boundingBox);this._flags&=~FLAG_BBOX_CHANGED;this._UpdateCollisionCell();this._UpdateRenderCell()}SetBboxChangeEventEnabled(e){this._SetFlag(FLAG_ENABLE_BBOX_CHANGED_EVENT,e)}IsBboxChangeEventEnabled(){return(this._flags&FLAG_ENABLE_BBOX_CHANGED_EVENT)!==0}IsInViewport(viewport){return this.GetZElevation()===0?viewport.intersectsRect(this.GetBoundingBox()):this._IsInViewport_ZElevated()}_IsInViewport_ZElevated(){const layer=this.GetLayer();const totalZElevation=
this.GetTotalZElevation();if(totalZElevation>=layer.GetCameraZ())return false;layer.GetViewportForZ(totalZElevation,tempRect);return tempRect.intersectsRect(this.GetBoundingBox())}SetSourceCollisionPoly(poly){this._sourceCollisionPoly=poly;this._DiscardTransformedCollisionPoly();if(this.HasMesh())this._meshInfo.meshPoly=null}GetSourceCollisionPoly(){return this._sourceCollisionPoly}HasOwnCollisionPoly(){return this._sourceCollisionPoly!==null||this.HasMesh()}GetTransformedCollisionPoly(){return this._GetCustomTransformedCollisionPolyPrecalc(this.GetWidth(),
this.GetHeight(),this.GetAngle(),this.GetSinAngle(),this.GetCosAngle())}GetCustomTransformedCollisionPoly(w,h,a){let sina=0;let cosa=1;if(a!==0){sina=Math.sin(a);cosa=Math.cos(a)}return this._GetCustomTransformedCollisionPolyPrecalc(w,h,a,sina,cosa)}_GetCustomTransformedCollisionPolyPrecalc(w,h,a,sinA,cosA){let tpi=this._transformedPolyInfo;if(tpi===null){tpi={poly:C3.New(C3.CollisionPoly),width:NaN,height:NaN,angle:NaN};this._transformedPolyInfo=tpi}const transformedPoly=tpi.poly;if(tpi.width===
w&&tpi.height===h&&tpi.angle===a)return transformedPoly;const sourcePoly=this._sourceCollisionPoly;if(this.HasMesh()){const ox=this.GetOriginX();const oy=this.GetOriginY();const sourceMesh=this.GetSourceMesh();let meshPoly=this._meshInfo.meshPoly;if(!meshPoly){if(sourcePoly){tempCollisionPoly.copy(sourcePoly);tempCollisionPoly.offset(ox,oy)}else tempCollisionPoly.setDefaultPoints();meshPoly=sourceMesh.InsertPolyMeshVertices(tempCollisionPoly);this._meshInfo.meshPoly=meshPoly}sourceMesh.TransformCollisionPoly(meshPoly,
transformedPoly);transformedPoly.offset(-ox,-oy);transformedPoly.transformPrecalc(w,h,sinA,cosA)}else if(sourcePoly){transformedPoly.copy(sourcePoly);transformedPoly.transformPrecalc(w,h,sinA,cosA)}else transformedPoly.setFromQuad(this.GetBoundingQuad(),-this.GetX(),-this.GetY());tpi.width=w;tpi.height=h;tpi.angle=a;return transformedPoly}_DiscardTransformedCollisionPoly(){this.SetPhysicsBodyChanged(true);const tpi=this._transformedPolyInfo;if(tpi===null)return;tpi.width=NaN}CreateMesh(hsize,vsize){hsize=
Math.floor(hsize);vsize=Math.floor(vsize);if(!this.GetInstance().GetPlugin().SupportsMesh())throw new Error("object does not support mesh");this.ReleaseMesh();this._meshInfo={sourceMesh:C3.New(C3.Gfx.Mesh,hsize,vsize),transformedMesh:C3.New(C3.Gfx.Mesh,hsize,vsize),meshPoly:null}}HasMesh(){return this._meshInfo!==null}GetSourceMesh(){if(!this.HasMesh())throw new Error("no mesh");return this._meshInfo.sourceMesh}GetTransformedMesh(){if(!this.HasMesh())throw new Error("no mesh");return this._meshInfo.transformedMesh}SetMeshChanged(e){this._SetFlag(FLAG_MESH_CHANGED,
e)}IsMeshChanged(){return(this._flags&FLAG_MESH_CHANGED)!==0}SetPhysicsBodyChanged(e){this._SetFlag(FLAG_PHYSICS_BODY_CHANGED,e)}IsPhysicsBodyChanged(){return(this._flags&FLAG_PHYSICS_BODY_CHANGED)!==0}_ExpandBboxForMesh(bbox){const sourceMesh=this._meshInfo.sourceMesh;const minX=Math.min(sourceMesh.GetMinX(),0);const minY=Math.min(sourceMesh.GetMinY(),0);const maxX=Math.max(sourceMesh.GetMaxX(),1);const maxY=Math.max(sourceMesh.GetMaxY(),1);const w=bbox.width();const h=bbox.height();bbox.offsetLeft(minX*
w);bbox.offsetTop(minY*h);bbox.offsetRight((maxX-1)*w);bbox.offsetBottom((maxY-1)*h)}ReleaseMesh(){if(!this._meshInfo)return;this._meshInfo.sourceMesh.Release();this._meshInfo.transformedMesh.Release();this._meshInfo=null;this._DiscardTransformedCollisionPoly()}SetMeshPoint(col,row,opts){col=Math.floor(col);row=Math.floor(row);const mode=opts.mode||"absolute";if(!VALID_SET_MESH_POINT_MODES.has(mode))throw new Error("invalid mode");const isRelative=mode==="relative";let posx=opts.x;let posy=opts.y;
const zElevation=opts.zElevation;let texu=typeof opts.u==="number"?opts.u:isRelative?0:-1;let texv=typeof opts.v==="number"?opts.v:isRelative?0:-1;if(!this.HasMesh())return false;const sourceMesh=this.GetSourceMesh();const p=sourceMesh.GetMeshPointAt(col,row);if(p===null)return false;let ret=false;if(typeof zElevation==="number"&&p.GetZElevation()!==zElevation){p.SetZElevation(zElevation);ret=true}if(isRelative){posx+=col/(sourceMesh.GetHSize()-1);posy+=row/(sourceMesh.GetVSize()-1)}if(texu===-1&&
!isRelative)texu=p.GetU();else{if(isRelative)texu+=col/(sourceMesh.GetHSize()-1);texu=C3.clamp(texu,0,1)}if(texv===-1&&!isRelative)texv=p.GetV();else{if(isRelative)texv+=row/(sourceMesh.GetVSize()-1);texv=C3.clamp(texv,0,1)}if(p.GetX()===posx&&p.GetY()===posy&&p.GetU()===texu&&p.GetV()===texv)return ret;p.SetX(posx);p.SetY(posy);p.SetU(texu);p.SetV(texv);this._DiscardTransformedCollisionPoly();return true}HasTilemap(){return this._inst.HasTilemap()}ContainsPoint(x,y){if(!this.GetBoundingBox().containsPoint(x,
y))return false;if(!this.GetBoundingQuad().containsPoint(x,y))return false;if(this.HasTilemap())return this._inst.GetSdkInstance().TestPointOverlapTile(x,y);if(!this.HasOwnCollisionPoly())return true;return this.GetTransformedCollisionPoly().containsPoint(x-this.GetX(),y-this.GetY())}_IsCollisionCellChanged(){return(this._flags&FLAG_COLLISION_CELL_CHANGED)!==0}_UpdateCollisionCell(){if(!this._IsCollisionCellChanged()||!this.IsCollisionEnabled()||(this._flags&FLAG_DESTROYED)!==0)return;const bbox=
this.GetBoundingBox();const grid=this._objectClass._GetCollisionCellGrid();const collisionCells=this._collisionCells;tempRect.set(grid.XToCell(bbox.getLeft()),grid.YToCell(bbox.getTop()),grid.XToCell(bbox.getRight()),grid.YToCell(bbox.getBottom()));if(collisionCells.equals(tempRect))return;const inst=this._inst;if(collisionCells===DEFAULT_COLLISION_CELLS){grid.Update(inst,null,tempRect);this._collisionCells=C3.New(C3.Rect,tempRect)}else{grid.Update(inst,collisionCells,tempRect);collisionCells.copy(tempRect)}this._flags&=
~FLAG_COLLISION_CELL_CHANGED}_RemoveFromCollisionCells(){const collisionCells=this._collisionCells;if(collisionCells===DEFAULT_COLLISION_CELLS)return;this._objectClass._GetCollisionCellGrid().Update(this._inst,collisionCells,null);this._collisionCells=DEFAULT_COLLISION_CELLS}_UpdateRenderCell(){const layer=this.GetLayer();if(!layer.UsesRenderCells()||(this._flags&FLAG_DESTROYED)!==0)return;const renderGrid=layer.GetRenderGrid();const bbox=this.GetBoundingBox();const renderCells=this._renderCells;
tempRect.set(renderGrid.XToCell(bbox.getLeft()),renderGrid.YToCell(bbox.getTop()),renderGrid.XToCell(bbox.getRight()),renderGrid.YToCell(bbox.getBottom()));if(renderCells.equals(tempRect))return;const inst=this._inst;if(renderCells===DEFAULT_RENDER_CELLS){renderGrid.Update(inst,null,tempRect);this._renderCells=C3.New(C3.Rect,tempRect)}else{renderGrid.Update(inst,renderCells,tempRect);renderCells.copy(tempRect)}layer.SetRenderListStale()}_RemoveFromRenderCells(){const renderCells=this._renderCells;
if(renderCells===DEFAULT_RENDER_CELLS)return;this.GetLayer().GetRenderGrid().Update(this._inst,renderCells,null);this._renderCells=DEFAULT_RENDER_CELLS}GetRenderCellRange(){return this._renderCells}ZOrderMoveToTop(){const inst=this._inst;const layer=this._layer;const layerInstances=layer._GetInstances();if(layerInstances.length&&layerInstances[layerInstances.length-1]===inst)return;layer._RemoveInstance(inst,false);layer._AddInstance(inst,false);this._runtime.UpdateRender()}ZOrderMoveToBottom(){const inst=
this._inst;const layer=this._layer;const layerInstances=layer._GetInstances();if(layerInstances.length&&layerInstances[0]===inst)return;layer._RemoveInstance(inst,false);layer._PrependInstance(inst,false);this._runtime.UpdateRender()}ZOrderMoveToLayer(layerMove){const inst=this._inst;const curLayer=this._layer;if(curLayer.GetLayout()!==layerMove.GetLayout())throw new Error("layer from different layout");if(layerMove===curLayer)return;curLayer._RemoveInstance(inst,true);this._SetLayer(layerMove);layerMove._AddInstance(inst,
true);this._runtime.UpdateRender()}ZOrderMoveAdjacentToInstance(otherInst,isAfter){const inst=this._inst;const curLayer=this._layer;if(otherInst.GetUID()===inst.GetUID())return;const otherWi=otherInst.GetWorldInfo();if(!otherWi)throw new Error("expected world instance");const otherLayer=otherWi.GetLayer();let didChangeLayer=false;if(curLayer.GetIndex()!==otherLayer.GetIndex()){curLayer._RemoveInstance(inst,true);this._SetLayer(otherLayer);otherLayer._AddInstance(inst,true);didChangeLayer=true}const didChangeZOrder=
otherLayer.MoveInstanceAdjacent(inst,otherInst,!!isAfter);if(didChangeLayer||didChangeZOrder)this._runtime.UpdateRender()}GetInstanceEffectList(){return this._instanceEffectList}_SetHasAnyActiveEffect(e){this._SetFlag(FLAG_HAS_ANY_ACTIVE_EFFECT,e)}HasAnyActiveEffect(){return(this._flags&FLAG_HAS_ANY_ACTIVE_EFFECT)!==0}_SaveToJson(mode){const o={"x":this.GetX(),"y":this.GetY(),"w":this.GetWidth(),"h":this.GetHeight(),"l":this.GetLayer().GetSID(),"zi":this.GetZIndex()};if(this.GetZElevation()!==0)o["ze"]=
this.GetZElevation();if(this.GetAngle()!==0)o["a"]=this.GetAngle();if(!this.HasDefaultColor())o["c"]=this._color.toJSON();if(this.GetOriginX()!==.5)o["oX"]=this.GetOriginX();if(this.GetOriginY()!==.5)o["oY"]=this.GetOriginY();if(this.GetBlendMode()!==0)o["bm"]=this.GetBlendMode();if(!this.IsVisible())o["v"]=this.IsVisible();if(!this.IsCollisionEnabled())o["ce"]=this.IsCollisionEnabled();if(this.IsBboxChangeEventEnabled())o["be"]=this.IsBboxChangeEventEnabled();if(this._instanceEffectList)o["fx"]=
this._instanceEffectList._SaveToJson();const isSolidFilterInclusive=(this._flags&FLAG_SOLID_FILTER_INCLUSIVE)!==0;if(isSolidFilterInclusive)o["sfi"]=isSolidFilterInclusive;if(this._solidFilterTags)o["sft"]=[...this._solidFilterTags].join(" ");if(this._sceneGraphInfo&&mode!=="visual-state")o["sgi"]=this._sceneGraphInfo._SaveToJson();if(this.HasMesh())o["mesh"]=this.GetSourceMesh().SaveToJson();return o}_OnBeforeLoad(mode){if(mode!=="visual-state")this._ResetAllSceneGraphState()}_LoadFromJson(o,mode){enableUpdateRendererStateGroup=
false;this.SetX(o["x"]);this.SetY(o["y"]);this.SetWidth(o["w"]);this.SetHeight(o["h"]);this._SetZIndex(o["zi"]);this.SetZElevation(o.hasOwnProperty("ze")?o["ze"]:0);this.SetAngle(o.hasOwnProperty("a")?o["a"]:0);if(o.hasOwnProperty("c"))tempColor.setFromJSON(o["c"]);else if(o.hasOwnProperty("o")){tempColor.copyRgb(this._color);tempColor.a=o["o"]}else tempColor.setRgba(1,1,1,1);this._SetColor(tempColor);this.SetOriginX(o.hasOwnProperty("oX")?o["oX"]:.5);this.SetOriginY(o.hasOwnProperty("oY")?o["oY"]:
.5);this.SetBlendMode(o.hasOwnProperty("bm")?o["bm"]:0);this.SetVisible(o.hasOwnProperty("v")?o["v"]:true);this.SetCollisionEnabled(o.hasOwnProperty("ce")?o["ce"]:true);this.SetBboxChangeEventEnabled(o.hasOwnProperty("be")?o["be"]:false);this.SetSolidCollisionFilter(o.hasOwnProperty("sfi")?o["sfi"]:false,o.hasOwnProperty("sft")?o["sft"]:"");if(this._instanceEffectList&&o.hasOwnProperty("fx"))this._instanceEffectList._LoadFromJson(o["fx"]);if(o.hasOwnProperty("sgi")&&mode!=="visual-state"){this._CreateSceneGraphInfo(null);
const sgi=this._sceneGraphInfo;const sgiData=o["sgi"];sgi._LoadFromJson(sgiData);const runtimeDispatcher=this.GetRuntime().Dispatcher();const onAfterLoad=()=>{runtimeDispatcher.removeEventListener("afterload",onAfterLoad);if((this._flags&FLAG_DESTROYED)===0)sgi._OnAfterLoad(sgiData)};runtimeDispatcher.addEventListener("afterload",onAfterLoad)}if(o.hasOwnProperty("mesh")){const meshData=o["mesh"];this.CreateMesh(meshData["cols"],meshData["rows"]);this.GetSourceMesh().LoadFromJson(meshData)}else this.ReleaseMesh();
this.SetBboxChanged();enableUpdateRendererStateGroup=true;this._UpdateRendererStateGroup()}}};


// c3/objects/behaviorType.js
'use strict';{const C3=self.C3;C3.BehaviorType=class BehaviorType extends C3.DefendedBase{constructor(objectClass,data){super();const runtime=objectClass.GetRuntime();const pluginManager=runtime.GetPluginManager();const BehaviorCtor=runtime.GetObjectReference(data[1]);if(!pluginManager.HasBehaviorByConstructorFunction(BehaviorCtor))pluginManager.CreateBehavior(data);this._runtime=runtime;this._objectClass=objectClass;this._behavior=pluginManager.GetBehaviorByConstructorFunction(BehaviorCtor);this._sdkType=
null;this._instSdkCtor=BehaviorCtor.Instance;this._sid=data[2];this._name=data[0];this._jsPropName=this._runtime.GetJsPropName(data[3]);this._sdkType=C3.New(BehaviorCtor.Type,this);this.OnCreate()}static Create(objectClass,behaviorTypeData){return C3.New(C3.BehaviorType,objectClass,behaviorTypeData)}Release(){this._runtime=null;this._behavior=null;this._sdkType.Release();this._sdkType=null;this._instSdkCtor=null}GetSdkType(){return this._sdkType}OnCreate(){this._sdkType.OnCreate()}GetRuntime(){return this._runtime}GetObjectClass(){return this._objectClass}GetBehavior(){return this._behavior}GetInstanceSdkCtor(){return this._instSdkCtor}GetName(){return this._name}GetSID(){return this._sid}GetJsPropName(){return this._jsPropName}}};


// c3/objects/behaviorInstance.js
'use strict';{const C3=self.C3;const IBehaviorInstance=self.IBehaviorInstance;C3.BehaviorInstance=class BehaviorInstance extends C3.DefendedBase{constructor(opts){super();this._runtime=opts.runtime;this._behaviorType=opts.behaviorType;this._behavior=this._behaviorType.GetBehavior();this._inst=opts.instance;this._index=opts.index;this._sdkInst=null;this._iScriptInterface=null;this._behavior._AddInstance(this._inst)}Release(){if(this._iScriptInterface){this._iScriptInterface._Release();this._iScriptInterface=
null}this._behavior._RemoveInstance(this._inst);this._sdkInst.Release();this._sdkInst=null;this._iScriptInterface=null;this._runtime=null;this._behaviorType=null;this._behavior=null;this._inst=null}_CreateSdkInstance(properties){if(this._sdkInst)throw new Error("already got sdk instance");this._sdkInst=C3.New(this._behaviorType.GetInstanceSdkCtor(),this,properties);this._InitScriptInterface()}GetSdkInstance(){return this._sdkInst}GetObjectInstance(){return this._inst}GetRuntime(){return this._runtime}GetBehaviorType(){return this._behaviorType}GetBehavior(){return this._behavior}_GetIndex(){return this._index}PostCreate(){this._sdkInst.PostCreate()}OnSpriteFrameChanged(prevFrame,
nextFrame){this._sdkInst.OnSpriteFrameChanged(prevFrame,nextFrame)}_GetDebuggerProperties(){return this._sdkInst.GetDebuggerProperties()}SaveToJson(){return this._sdkInst.SaveToJson()}LoadFromJson(o){return this._sdkInst.LoadFromJson(o)}static SortByTickSequence(a,b){const instA=a.GetObjectInstance();const instB=b.GetObjectInstance();const typeIndexA=instA.GetObjectClass().GetIndex();const typeIndexB=instB.GetObjectClass().GetIndex();if(typeIndexA!==typeIndexB)return typeIndexA-typeIndexB;const seqA=
instA.GetPUID();const seqB=instB.GetPUID();if(seqA!==seqB)return seqA-seqB;return a.GetBehaviorInstance()._GetIndex()-b.GetBehaviorInstance()._GetIndex()}_InitScriptInterface(){const DefaultScriptClass=IBehaviorInstance;const SdkScriptClass=this._sdkInst.GetScriptInterfaceClass();const ScriptInterfaceClass=SdkScriptClass||DefaultScriptClass;IBehaviorInstance._Init(this);this._iScriptInterface=new ScriptInterfaceClass;IBehaviorInstance._Init(null);if(SdkScriptClass&&!(this._iScriptInterface instanceof
DefaultScriptClass))throw new TypeError(`script interface class '${SdkScriptClass.name}' does not extend the right base class '${DefaultScriptClass.name}'`);}GetScriptInterface(){return this._iScriptInterface}}};


// c3/objects/effectList.js
'use strict';{const C3=self.C3;C3.EffectList=class EffectList extends C3.DefendedBase{constructor(owner,data){super();this._owner=owner;this._allEffectTypes=[];this._activeEffectTypes=[];this._effectTypesByName=new Map;this._effectParams=[];this._preservesOpaqueness=true;for(const d of data){const et=C3.New(C3.EffectType,this,d,this._allEffectTypes.length);this._allEffectTypes.push(et);this._effectTypesByName.set(et.GetName().toLowerCase(),et);if(d.length>=3)this._effectParams.push(this._LoadSingleEffectParameters(d[2]))}this.GetRuntime()._AddEffectList(this)}Release(){C3.clearArray(this._allEffectTypes);
C3.clearArray(this._activeEffectTypes);this._effectTypesByName.clear();C3.clearArray(this._effectParams);this._owner=null}PrependEffectTypes(arr){if(!arr.length)return;this._allEffectTypes=arr.concat(this._allEffectTypes);for(const et of arr)this._effectTypesByName.set(et.GetName().toLowerCase(),et);for(let i=0,len=this._allEffectTypes.length;i<len;++i)this._allEffectTypes[i]._SetIndex(i)}_LoadSingleEffectParameters(arr){const ret=arr.slice(0);for(let i=0,len=ret.length;i<len;++i){const p=ret[i];
if(Array.isArray(p)){const c=C3.New(C3.Color);c.setFromJSON(p);ret[i]=c}}return ret}GetOwner(){return this._owner}GetRuntime(){return this._owner.GetRuntime()}UpdateActiveEffects(){C3.clearArray(this._activeEffectTypes);let preservesOpaqueness=true;for(const et of this._allEffectTypes)if(et.IsActive()){this._activeEffectTypes.push(et);if(!et.GetShaderProgram().PreservesOpaqueness())preservesOpaqueness=false}this._preservesOpaqueness=preservesOpaqueness}GetAllEffectTypes(){return this._allEffectTypes}HasAnyEffectType(){return this._allEffectTypes.length>
0}GetEffectTypeByName(name){return this._effectTypesByName.get(name.toLowerCase())||null}GetEffectTypeByIndex(index){index=Math.floor(+index);if(index<0||index>=this._allEffectTypes.length)throw new RangeError("invalid effect type index");return this._allEffectTypes[index]}IsEffectIndexActive(index){return this.GetEffectTypeByIndex(index).IsActive()}SetEffectIndexActive(index,a){this.GetEffectTypeByIndex(index).SetActive(a)}GetActiveEffectTypes(){return this._activeEffectTypes}HasAnyActiveEffect(){return this._activeEffectTypes.length>
0}PreservesOpaqueness(){return this._preservesOpaqueness}GetEffectParametersForIndex(index){return this._effectParams[index]}static SaveFxParamToJson(param){if(param&&param instanceof C3.Color)return{"t":"color","v":param.toJSON()};else return param}static LoadFxParamFromJson(o){if(typeof o==="object"){const type=o["t"];if(type==="color"){const color=C3.New(C3.Color);color.setFromJSON(o["v"]);return color}else throw new Error("invalid effect parameter type");}else return o}static SaveFxParamsToJson(params){return params.map(C3.EffectList.SaveFxParamToJson)}static LoadFxParamsFromJson(arr){return arr.map(C3.EffectList.LoadFxParamFromJson)}SaveToJson(){return this._allEffectTypes.map(et=>
({"name":et.GetName(),"active":et.IsActive(),"params":C3.EffectList.SaveFxParamsToJson(this._effectParams[et.GetIndex()])}))}LoadFromJson(arr){for(const o of arr){const et=this.GetEffectTypeByName(o["name"]);if(!et)continue;et.SetActive(o["active"]);this._effectParams[et.GetIndex()]=C3.EffectList.LoadFxParamsFromJson(o["params"])}this.UpdateActiveEffects()}}};


// c3/objects/effectType.js
'use strict';{const C3=self.C3;C3.EffectType=class EffectType extends C3.DefendedBase{constructor(effectList,data,index){super();this._effectList=effectList;this._id=data[0];this._name=data[1];this._index=index;this._shaderProgram=null;this._isActive=true}Release(){this._effectList=null;this._shaderProgram=null}Clone(effectListOwner){const ret=C3.New(C3.EffectType,effectListOwner,[this._id,this._name],-1);ret._shaderProgram=this._shaderProgram;ret._isActive=this._isActive;return ret}_InitRenderer(renderer){const shaderProgram=
renderer.GetShaderProgramByName(this._id);if(!shaderProgram)throw new Error("failed to find shader program '"+this._id+"'");this._shaderProgram=shaderProgram}GetEffectList(){return this._effectList}GetName(){return this._name}_SetIndex(i){this._index=i}GetIndex(){return this._index}GetOwner(){return this._effectList.GetOwner()}GetRuntime(){return this._effectList.GetRuntime()}SetActive(a){this._isActive=!!a}IsActive(){return this._isActive}GetShaderProgram(){return this._shaderProgram}GetDefaultParameterValues(){const ret=
[];for(let i=0,len=this._shaderProgram.GetParameterCount();i<len;++i){const type=this._shaderProgram.GetParameterType(i);if(type==="float"||type==="percent")ret.push(0);else if(type==="color")ret.push(C3.New(C3.Color,1,1,1,1));else throw new TypeError("unknown effect parameter type");}return ret}}};


// c3/objects/instanceEffectList.js
'use strict';{const C3=self.C3;C3.InstanceEffectList=class InstanceEffectList extends C3.DefendedBase{constructor(inst,wi,data){super();this._inst=inst;this._wi=wi;this._effectList=inst.GetObjectClass().GetEffectList();this._activeEffectFlags=[];this._activeEffectTypes=[];this._preservesOpaqueness=true;this._effectParams=[];for(const et of this._effectList.GetAllEffectTypes())this._activeEffectFlags.push(true);this.UpdateActiveEffects()}Release(){C3.clearArray(this._activeEffectFlags);C3.clearArray(this._activeEffectTypes);
C3.clearArray(this._effectParams);this._inst=null;this._effectList=null}_LoadEffectParameters(data){for(const e of data)this._effectParams.push(this._LoadSingleEffectParameters(e))}_LoadSingleEffectParameters(arr){const ret=arr.slice(0);for(let i=0,len=ret.length;i<len;++i){const p=ret[i];if(Array.isArray(p)){const c=C3.New(C3.Color);c.setFromJSON(p);ret[i]=c}}return ret}LoadDefaultEffectParameters(){for(const effectType of this._effectList.GetAllEffectTypes())this._effectParams.push(effectType.GetDefaultParameterValues())}GetOwner(){return this._owner}GetEffectList(){return this._effectList}GetRuntime(){return this._inst.GetRuntime()}UpdateActiveEffects(){C3.clearArray(this._activeEffectTypes);
const allEffectTypes=this._effectList.GetAllEffectTypes();const activeEffectTypes=this._activeEffectTypes;const activeEffectFlags=this._activeEffectFlags;let preservesOpaqueness=true;for(let i=0,len=allEffectTypes.length;i<len;++i)if(activeEffectFlags[i]){const et=allEffectTypes[i];activeEffectTypes.push(et);if(!et.GetShaderProgram().PreservesOpaqueness())preservesOpaqueness=false}this._preservesOpaqueness=preservesOpaqueness;this._wi._SetHasAnyActiveEffect(!!activeEffectTypes.length)}GetActiveEffectTypes(){return this._activeEffectTypes}GetEffectParametersForIndex(index){return this._effectParams[index]}PreservesOpaqueness(){return this._preservesOpaqueness}HasAnyActiveBackgroundBlendingEffect(){return this._activeEffectTypes.some(et=>
et.GetShaderProgram().UsesDest())}IsEffectIndexActive(i){return this._activeEffectFlags[i]}SetEffectIndexActive(i,e){this._activeEffectFlags[i]=!!e}GetAllEffectTypes(){return this._effectList.GetAllEffectTypes()}_SaveToJson(){return this._effectList.GetAllEffectTypes().map(et=>({"name":et.GetName(),"active":this._activeEffectFlags[et.GetIndex()],"params":C3.EffectList.SaveFxParamsToJson(this._effectParams[et.GetIndex()])}))}_LoadFromJson(arr){for(const o of arr){const et=this._effectList.GetEffectTypeByName(o["name"]);
if(!et)continue;this._activeEffectFlags[et.GetIndex()]=o["active"];this._effectParams[et.GetIndex()]=C3.EffectList.LoadFxParamsFromJson(o["params"])}this.UpdateActiveEffects()}}};


// c3/collisions/collisionEngine.js
'use strict';{const C3=self.C3;const tempCandidates=[];const tileCollRectCandidates=[];const tempJumpthruRet=[];const tempPolyA=C3.New(C3.CollisionPoly);const tempPolyB=C3.New(C3.CollisionPoly);const tempQuad=C3.New(C3.Quad);const tempRect=C3.New(C3.Rect);const tempRect2=C3.New(C3.Rect);C3.CollisionEngine=class CollisionEngine extends C3.DefendedBase{constructor(runtime){super();this._runtime=runtime;this._registeredCollisions=[];this._collisionCheckCount=0;this._collisionCheckSec=0;this._polyCheckCount=
0;this._polyCheckSec=0}Release(){this._runtime=null}_Update1sStats(){this._collisionCheckSec=this._collisionCheckCount;this._collisionCheckCount=0;this._polyCheckSec=this._polyCheckCount;this._polyCheckCount=0}Get1secCollisionChecks(){return this._collisionCheckSec}Get1secPolyChecks(){return this._polyCheckSec}RegisterCollision(a,b){const aw=a.GetWorldInfo();const bw=b.GetWorldInfo();if(!aw||!bw)return;if(!aw.IsCollisionEnabled()||!bw.IsCollisionEnabled())return;this._registeredCollisions.push([a,
b])}AddRegisteredCollisionCandidates(inst,otherType,arr){for(const [a,b]of this._registeredCollisions){let otherInst=null;if(inst===a)otherInst=b;else if(inst===b)otherInst=a;else continue;if(!otherInst.BelongsToObjectClass(otherType))continue;if(!arr.includes(otherInst))arr.push(otherInst)}}CheckRegisteredCollision(a,b){if(!this._registeredCollisions.length)return false;for(const [c,d]of this._registeredCollisions)if(a===c&&b===d||a===d&&b===c)return true;return false}ClearRegisteredCollisions(){C3.clearArray(this._registeredCollisions)}TestOverlap(a,
b){if(!a||!b||a===b)return false;const aw=a.GetWorldInfo();const bw=b.GetWorldInfo();if(!aw.IsCollisionEnabled()||!bw.IsCollisionEnabled())return false;this._collisionCheckCount++;const layerA=aw.GetLayer();const layerB=bw.GetLayer();const areLayerTransformsCompatible=layerA.IsTransformCompatibleWith(layerB);if(areLayerTransformsCompatible)return this._TestOverlap_SameLayers(aw,bw);else return this._TestOverlap_DifferentLayers(aw,bw)}_TestOverlap_SameLayers(aw,bw){if(!aw.GetBoundingBox().intersectsRect(bw.GetBoundingBox()))return false;
this._polyCheckCount++;if(!aw.GetBoundingQuad().intersectsQuad(bw.GetBoundingQuad()))return false;if(aw.HasTilemap()&&bw.HasTilemap())return false;if(aw.HasTilemap())return this.TestTilemapOverlap(aw,bw);else if(bw.HasTilemap())return this.TestTilemapOverlap(bw,aw);if(!aw.HasOwnCollisionPoly()&&!bw.HasOwnCollisionPoly())return true;const polyA=aw.GetTransformedCollisionPoly();const polyB=bw.GetTransformedCollisionPoly();return polyA.intersectsPoly(polyB,bw.GetX()-aw.GetX(),bw.GetY()-aw.GetY())}_TestOverlap_DifferentLayers(aw,
bw){const layerA=aw.GetLayer();const layerB=bw.GetLayer();tempPolyA.copy(aw.GetTransformedCollisionPoly());tempPolyB.copy(bw.GetTransformedCollisionPoly());const ptsArrA=tempPolyA.pointsArr();for(let i=0,len=ptsArrA.length;i<len;i+=2){const j=i+1;const x=ptsArrA[i];const y=ptsArrA[j];const [lx,ly]=layerA.LayerToCanvasCss(x+aw.GetX(),y+aw.GetY());ptsArrA[i]=lx;ptsArrA[j]=ly}const ptsArrB=tempPolyB.pointsArr();for(let i=0,len=ptsArrB.length;i<len;i+=2){const j=i+1;const x=ptsArrB[i];const y=ptsArrB[j];
const [lx,ly]=layerB.LayerToCanvasCss(x+bw.GetX(),y+bw.GetY());ptsArrB[i]=lx;ptsArrB[j]=ly}tempPolyA.setBboxChanged();tempPolyB.setBboxChanged();this._polyCheckCount++;return tempPolyA.intersectsPoly(tempPolyB,0,0)}TestTilemapOverlap(tmWi,wi){const bbox=wi.GetBoundingBox();const tmX=tmWi.GetX();const tmY=tmWi.GetY();const tmSdkInst=tmWi.GetInstance().GetSdkInstance();const instX=wi.GetX();const instY=wi.GetY();const instHasPoly=wi.HasOwnCollisionPoly();const instQuad=wi.GetBoundingQuad();const collRects=
tileCollRectCandidates;tmSdkInst.GetCollisionRectCandidates(bbox,collRects);for(let i=0,len=collRects.length;i<len;++i){const c=collRects[i];const rc=c.GetRect();this._collisionCheckCount++;if(bbox.intersectsRectOffset(rc,tmX,tmY)){tempQuad.setFromRect(rc);tempQuad.offset(tmX,tmY);if(tempQuad.intersectsQuad(instQuad))if(instHasPoly){const instPoly=wi.GetTransformedCollisionPoly();const tilePoly=c.GetPoly();if(tilePoly){this._polyCheckCount++;if(tilePoly.intersectsPoly(instPoly,instX-(tmX+rc.getLeft()),
instY-(tmY+rc.getTop()))){C3.clearArray(collRects);return true}}else{tempPolyA.setFromQuad(tempQuad,0,0);if(tempPolyA.intersectsPoly(instPoly,instX,instY)){C3.clearArray(collRects);return true}}}else{const tilePoly=c.GetPoly();if(tilePoly){tempPolyA.setFromQuad(instQuad,0,0);if(tilePoly.intersectsPoly(tempPolyA,-(tmX+rc.getLeft()),-(tmY+rc.getTop()))){C3.clearArray(collRects);return true}}else{C3.clearArray(collRects);return true}}}}C3.clearArray(collRects);return false}TestAndSelectCanvasPointOverlap(objectClass,
ptx,pty,isInverted){const sol=objectClass.GetCurrentSol();const currentEvent=this._runtime.GetCurrentEvent();if(!currentEvent)throw new Error("cannot call outside event");const isOrBlock=currentEvent.IsOrBlock();if(sol.IsSelectAll()){if(!isInverted){sol._SetSelectAll(false);C3.clearArray(sol._GetOwnInstances())}for(const inst of objectClass.GetInstances()){const wi=inst.GetWorldInfo();const layer=wi.GetLayer();const [lx,ly]=layer.CanvasCssToLayer(ptx,pty,wi.GetTotalZElevation());if(wi.ContainsPoint(lx,
ly))if(isInverted)return false;else sol._PushInstance(inst);else if(isOrBlock)sol._PushElseInstance(inst)}}else{const arr=isOrBlock?sol._GetOwnElseInstances():sol._GetOwnInstances();let j=0;for(let i=0,len=arr.length;i<len;++i){const inst=arr[i];const wi=inst.GetWorldInfo();const layer=wi.GetLayer();const [lx,ly]=layer.CanvasCssToLayer(ptx,pty,wi.GetTotalZElevation());if(wi.ContainsPoint(lx,ly))if(isInverted)return false;else if(isOrBlock)sol._PushInstance(inst);else arr[j++]=inst;else if(isOrBlock)arr[j++]=
inst}if(!isInverted)arr.length=j}objectClass.ApplySolToContainer();if(isInverted)return true;else return sol.HasAnyInstances()}GetCollisionCandidates(layer,rtype,bbox,candidates){const isParallaxed=layer?layer.GetParallaxX()!==1||layer.GetParallaxY()!==1:false;if(rtype.IsFamily())for(const memberType of rtype.GetFamilyMembers())if(isParallaxed||memberType.IsAnyInstanceParallaxed())C3.appendArray(candidates,memberType.GetInstances());else{memberType._UpdateAllCollisionCells();memberType._GetCollisionCellGrid().QueryRange(bbox,
candidates)}else if(isParallaxed||rtype.IsAnyInstanceParallaxed())C3.appendArray(candidates,rtype.GetInstances());else{rtype._UpdateAllCollisionCells();rtype._GetCollisionCellGrid().QueryRange(bbox,candidates)}}GetObjectClassesCollisionCandidates(layer,objectClasses,bbox,candidates){for(const objectClass of objectClasses)this.GetCollisionCandidates(layer,objectClass,bbox,candidates)}GetSolidCollisionCandidates(layer,bbox,candidates){const solidBehavior=this._runtime.GetSolidBehavior();if(!solidBehavior)return;
this.GetObjectClassesCollisionCandidates(layer,solidBehavior.GetObjectClasses(),bbox,candidates)}GetJumpthruCollisionCandidates(layer,bbox,candidates){const jumpthruBehavior=this._runtime.GetJumpthruBehavior();if(!jumpthruBehavior)return;this.GetObjectClassesCollisionCandidates(layer,jumpthruBehavior.GetObjectClasses(),bbox,candidates)}IsSolidCollisionAllowed(solidInst,inst){return solidInst._IsSolidEnabled()&&(!inst||inst.GetWorldInfo().IsSolidCollisionAllowed(solidInst.GetSavedDataMap().get("solidTags")))}TestOverlapSolid(inst){const wi=
inst.GetWorldInfo();this.GetSolidCollisionCandidates(wi.GetLayer(),wi.GetBoundingBox(),tempCandidates);for(const s of tempCandidates){if(!this.IsSolidCollisionAllowed(s,inst))continue;if(this.TestOverlap(inst,s)){C3.clearArray(tempCandidates);return s}}C3.clearArray(tempCandidates);return null}TestRectOverlapSolid(rect,inst){this.GetSolidCollisionCandidates(null,rect,tempCandidates);for(const s of tempCandidates){if(!this.IsSolidCollisionAllowed(s,inst))continue;if(this.TestRectOverlap(rect,s)){C3.clearArray(tempCandidates);
return s}}C3.clearArray(tempCandidates);return null}TestOverlapJumpthru(inst,all){let ret=null;if(all){ret=tempJumpthruRet;C3.clearArray(ret)}const wi=inst.GetWorldInfo();this.GetJumpthruCollisionCandidates(wi.GetLayer(),wi.GetBoundingBox(),tempCandidates);for(const j of tempCandidates){if(!j._IsJumpthruEnabled())continue;if(this.TestOverlap(inst,j))if(all)ret.push(j);else{C3.clearArray(tempCandidates);return j}}C3.clearArray(tempCandidates);return ret}PushOut(inst,xdir,ydir,dist,otherInst){dist=
dist||50;const wi=inst.GetWorldInfo();const oldX=wi.GetX();const oldY=wi.GetY();for(let i=0;i<dist;++i){wi.SetXY(oldX+xdir*i,oldY+ydir*i);wi.SetBboxChanged();if(!this.TestOverlap(inst,otherInst))return true}wi.SetXY(oldX,oldY);wi.SetBboxChanged();return false}PushOutSolid(inst,xdir,ydir,dist,includeJumpthrus,specificJumpthru){dist=dist||50;const wi=inst.GetWorldInfo();const oldX=wi.GetX();const oldY=wi.GetY();let lastOverlapped=null;let secondLastOverlapped=null;for(let i=0;i<dist;++i){wi.SetXY(oldX+
xdir*i,oldY+ydir*i);wi.SetBboxChanged();if(!this.TestOverlap(inst,lastOverlapped)){lastOverlapped=this.TestOverlapSolid(inst);if(lastOverlapped)secondLastOverlapped=lastOverlapped;else{if(includeJumpthrus){if(specificJumpthru)lastOverlapped=this.TestOverlap(inst,specificJumpthru)?specificJumpthru:null;else lastOverlapped=this.TestOverlapJumpthru(inst);if(lastOverlapped)secondLastOverlapped=lastOverlapped}if(!lastOverlapped){if(secondLastOverlapped)this.PushInFractional(inst,xdir,ydir,secondLastOverlapped,
16,true);return true}}}}wi.SetXY(oldX,oldY);wi.SetBboxChanged();return false}PushOutSolidAxis(inst,xdir,ydir,dist){dist=dist||50;const wi=inst.GetWorldInfo();const oldX=wi.GetX();const oldY=wi.GetY();let lastOverlapped=null;let secondLastOverlapped=null;for(let i=0;i<dist;++i)for(let which=0;which<2;++which){const sign=which*2-1;wi.SetXY(oldX+xdir*i*sign,oldY+ydir*i*sign);wi.SetBboxChanged();if(!this.TestOverlap(inst,lastOverlapped)){lastOverlapped=this.TestOverlapSolid(inst);if(lastOverlapped)secondLastOverlapped=
lastOverlapped;else{if(secondLastOverlapped)this.PushInFractional(inst,xdir*sign,ydir*sign,secondLastOverlapped,16,true);return true}}}wi.SetXY(oldX,oldY);wi.SetBboxChanged();return false}PushInFractional(inst,xdir,ydir,otherInst,limit,includeAnySolid){let divisor=2;let forward=false;let overlapping=false;const wi=inst.GetWorldInfo();let bestX=wi.GetX();let bestY=wi.GetY();while(divisor<=limit){const frac=1/divisor;divisor*=2;wi.OffsetXY(xdir*frac*(forward?1:-1),ydir*frac*(forward?1:-1));wi.SetBboxChanged();
if(this.TestOverlap(inst,otherInst)||includeAnySolid&&this.TestOverlapSolid(inst)){forward=true;overlapping=true}else{forward=false;overlapping=false;bestX=wi.GetX();bestY=wi.GetY()}}if(overlapping){wi.SetXY(bestX,bestY);wi.SetBboxChanged()}}PushOutSolidNearest(inst,maxDist=100){let dist=0;const wi=inst.GetWorldInfo();const oldX=wi.GetX();const oldY=wi.GetY();let dir=0;let lastOverlapped=this.TestOverlapSolid(inst);if(!lastOverlapped)return true;while(dist<=maxDist){let dx=0;let dy=0;switch(dir){case 0:dx=
0;dy=-1;dist++;break;case 1:dx=1;dy=-1;break;case 2:dx=1;dy=0;break;case 3:dx=1;dy=1;break;case 4:dx=0;dy=1;break;case 5:dx=-1;dy=1;break;case 6:dx=-1;dy=0;break;case 7:dx=-1;dy=-1;break}dir=(dir+1)%8;wi.SetXY(Math.floor(oldX+dx*dist),Math.floor(oldY+dy*dist));wi.SetBboxChanged();if(!this.TestOverlap(inst,lastOverlapped)){lastOverlapped=this.TestOverlapSolid(inst);if(!lastOverlapped)return true}}wi.SetXY(oldX,oldY);wi.SetBboxChanged();return false}CalculateBounceAngle(inst,startX,startY,otherInst){const wi=
inst.GetWorldInfo();const oldX=wi.GetX();const oldY=wi.GetY();const radius=Math.max(10,C3.distanceTo(startX,startY,oldX,oldY));const startAngle=C3.angleTo(startX,startY,oldX,oldY);const firstInst=otherInst||this.TestOverlapSolid(inst);if(!firstInst)return C3.clampAngle(startAngle+Math.PI);let curInst=firstInst;let anticlockwiseFreeAngle=0;let clockwiseFreeAngle=0;const increment=C3.toRadians(5);let i;for(i=1;i<36;++i){const curAngle=startAngle-i*increment;wi.SetXY(startX+Math.cos(curAngle)*radius,
startY+Math.sin(curAngle)*radius);wi.SetBboxChanged();if(!this.TestOverlap(inst,curInst)){curInst=otherInst?null:this.TestOverlapSolid(inst);if(!curInst){anticlockwiseFreeAngle=curAngle;break}}}if(i===36)anticlockwiseFreeAngle=C3.clampAngle(startAngle+Math.PI);curInst=firstInst;for(i=1;i<36;++i){const curAngle=startAngle+i*increment;wi.SetXY(startX+Math.cos(curAngle)*radius,startY+Math.sin(curAngle)*radius);wi.SetBboxChanged();if(!this.TestOverlap(inst,curInst)){curInst=otherInst?null:this.TestOverlapSolid(inst);
if(!curInst){clockwiseFreeAngle=curAngle;break}}}if(i===36)clockwiseFreeAngle=C3.clampAngle(startAngle+Math.PI);wi.SetXY(oldX,oldY);wi.SetBboxChanged();if(clockwiseFreeAngle===anticlockwiseFreeAngle)return clockwiseFreeAngle;const halfDiff=C3.angleDiff(clockwiseFreeAngle,anticlockwiseFreeAngle)/2;let normal;if(C3.angleClockwise(clockwiseFreeAngle,anticlockwiseFreeAngle))normal=C3.clampAngle(anticlockwiseFreeAngle+halfDiff+Math.PI);else normal=C3.clampAngle(clockwiseFreeAngle+halfDiff);const vx=Math.cos(startAngle);
const vy=Math.sin(startAngle);const nx=Math.cos(normal);const ny=Math.sin(normal);const v_dot_n=vx*nx+vy*ny;const rx=vx-2*v_dot_n*nx;const ry=vy-2*v_dot_n*ny;return C3.angleTo(0,0,rx,ry)}TestSegmentOverlap(x1,y1,x2,y2,inst){if(!inst)return false;const wi=inst.GetWorldInfo();if(!wi.IsCollisionEnabled())return false;this._collisionCheckCount++;tempRect.set(Math.min(x1,x2),Math.min(y1,y2),Math.max(x1,x2),Math.max(y1,y2));if(!wi.GetBoundingBox().intersectsRect(tempRect))return false;if(inst.HasTilemap())return this._TestSegmentOverlapTilemap(x1,
y1,x2,y2,inst,wi);this._polyCheckCount++;if(!wi.GetBoundingQuad().intersectsSegment(x1,y1,x2,y2))return false;if(!wi.HasOwnCollisionPoly())return true;const poly=wi.GetTransformedCollisionPoly();return poly.intersectsSegment(wi.GetX(),wi.GetY(),x1,y1,x2,y2)}_TestSegmentOverlapTilemap(x1,y1,x2,y2,inst,wi){const tmX=wi.GetX();const tmY=wi.GetY();const sdkInst=inst.GetSdkInstance();const collRects=tileCollRectCandidates;tempRect2.set(x1,y1,x2,y2);tempRect2.normalize();sdkInst.GetCollisionRectCandidates(tempRect2,
collRects);for(let i=0,len=collRects.length;i<len;++i){const c=collRects[i];const tileRc=c.GetRect();this._collisionCheckCount++;if(tempRect.intersectsRectOffset(tileRc,tmX,tmY)){tempQuad.setFromRect(tileRc);tempQuad.offset(tmX,tmY);if(tempQuad.intersectsSegment(x1,y1,x2,y2)){const tilePoly=c.GetPoly();if(tilePoly){this._polyCheckCount++;if(tilePoly.intersectsSegment(tmX+tileRc.getLeft(),tmY+tileRc.getTop(),x1,y1,x2,y2)){C3.clearArray(collRects);return true}}else{C3.clearArray(collRects);return true}}}}C3.clearArray(collRects);
return false}TestRectOverlap(rect,inst){if(!inst)return false;const wi=inst.GetWorldInfo();if(!wi.IsCollisionEnabled())return false;this._collisionCheckCount++;if(!wi.GetBoundingBox().intersectsRect(rect))return false;if(inst.HasTilemap())return this._TestRectOverlapTilemap(rect,inst,wi);this._polyCheckCount++;tempQuad.setFromRect(rect);if(!wi.GetBoundingQuad().intersectsQuad(tempQuad))return false;if(!wi.HasOwnCollisionPoly())return true;const polyA=tempPolyA;polyA.setFromRect(rect,wi.GetX(),wi.GetY());
const polyB=wi.GetTransformedCollisionPoly();return polyA.intersectsPoly(polyB,0,0)}_TestRectOverlapTilemap(rect,inst,wi){const tmX=wi.GetX();const tmY=wi.GetY();const sdkInst=inst.GetSdkInstance();const collRects=tileCollRectCandidates;sdkInst.GetCollisionRectCandidates(rect,collRects);for(let i=0,len=collRects.length;i<len;++i){const c=collRects[i];const tileRc=c.GetRect();this._collisionCheckCount++;if(rect.intersectsRectOffset(tileRc,tmX,tmY)){const tilePoly=c.GetPoly();if(tilePoly){this._polyCheckCount++;
tempPolyA.setFromRect(rect,0,0);if(tilePoly.intersectsPoly(tempPolyA,-(tmX+tileRc.getLeft()),-(tmY+tileRc.getTop()))){C3.clearArray(collRects);return true}}else{C3.clearArray(collRects);return true}}}C3.clearArray(collRects);return false}TestRayIntersectsInstance(inst,ray){if(!inst)return;const wi=inst.GetWorldInfo();if(!wi.IsCollisionEnabled())return;this._collisionCheckCount++;if(!wi.GetBoundingBox().intersectsRect(ray.rect))return;if(inst.HasTilemap()){this._TestRayIntersectsTilemap(inst,wi,ray);
return}this._polyCheckCount++;if(wi.HasOwnCollisionPoly())ray.TestInstancePoly(inst,wi.GetX(),wi.GetY(),wi.GetTransformedCollisionPoly());else ray.TestInstanceQuad(inst,wi.GetBoundingQuad())}_TestRayIntersectsTilemap(inst,wi,ray){const xOffset=wi.GetX();const yOffset=wi.GetY();const collRects=tileCollRectCandidates;inst.GetSdkInstance().GetCollisionRectCandidates(ray.rect,collRects);for(let i=0,l=collRects.length;i<l;i++){const c=collRects[i];const tileRc=c.GetRect();this._collisionCheckCount++;if(ray.rect.intersectsRectOffset(tileRc,
xOffset,yOffset)){const tilePoly=c.GetPoly();this._polyCheckCount++;if(tilePoly)ray.TestInstancePoly(inst,xOffset+tileRc.getLeft(),yOffset+tileRc.getTop(),tilePoly);else ray.TestInstanceRect(inst,wi.GetX(),wi.GetY(),tileRc)}}C3.clearArray(collRects)}}};


// c3/collisions/sparseGrid.js
'use strict';{const C3=self.C3;C3.SparseGrid=class SparseGrid extends C3.DefendedBase{constructor(cellWidth,cellHeight){super();this._cellWidth=cellWidth;this._cellHeight=cellHeight;this._cells=C3.New(C3.PairMap)}Release(){this._cells.Release();this._cells=null}GetCell(x,y,createIfMissing){let ret=this._cells.Get(x,y);if(ret)return ret;else if(createIfMissing){ret=C3.New(C3.GridCell,this,x,y);this._cells.Set(x,y,ret);return ret}else return null}XToCell(x){const ret=Math.floor(x/this._cellWidth);return isFinite(ret)?
ret:0}YToCell(y){const ret=Math.floor(y/this._cellHeight);return isFinite(ret)?ret:0}Update(inst,oldRange,newRange){if(oldRange)for(let x=oldRange.getLeft(),lenx=oldRange.getRight();x<=lenx;++x)for(let y=oldRange.getTop(),leny=oldRange.getBottom();y<=leny;++y){if(newRange&&newRange.containsPoint(x,y))continue;const cell=this.GetCell(x,y,false);if(!cell)continue;cell.Remove(inst);if(cell.IsEmpty())this._cells.Delete(x,y)}if(newRange)for(let x=newRange.getLeft(),lenx=newRange.getRight();x<=lenx;++x)for(let y=
newRange.getTop(),leny=newRange.getBottom();y<=leny;++y){if(oldRange&&oldRange.containsPoint(x,y))continue;this.GetCell(x,y,true).Insert(inst)}}QueryRange(rc,result){let x=this.XToCell(rc.getLeft());const ystart=this.YToCell(rc.getTop());const lenx=this.XToCell(rc.getRight());const leny=this.YToCell(rc.getBottom());if(!isFinite(lenx)||!isFinite(leny))return;for(;x<=lenx;++x)for(let y=ystart;y<=leny;++y){const cell=this.GetCell(x,y,false);if(!cell)continue;cell.Dump(result)}}}};


// c3/collisions/gridCell.js
'use strict';{const C3=self.C3;C3.GridCell=class GridCell extends C3.DefendedBase{constructor(grid,x,y){super();this._grid=grid;this._x=x;this._y=y;this._instances=C3.New(C3.ArraySet)}Release(){this._instances.Release();this._instances=null;this._grid=null}IsEmpty(){return this._instances.IsEmpty()}Insert(inst){this._instances.Add(inst)}Remove(inst){this._instances.Delete(inst)}Dump(result){C3.appendArray(result,this._instances.GetArray())}}};


// c3/collisions/ray.js
'use strict';{const C3=self.C3;const PADDING=1E-6;const NO_HIT=2;C3.Ray=class Ray{constructor(){this.x1=0;this.y1=0;this.x2=0;this.y2=0;this.dx=0;this.dy=0;this.rect=new C3.Rect;this.hitFraction=NO_HIT;this.hitUid=null;this.hitNormal=0;this.hitNormalDx=0;this.hitNormalDy=0;this.hitX=0;this.hitY=0;this.distance=0;this.normalX=1;this.normalY=0;this.reflectionX=1;this.reflectionY=0}DidCollide(){return this.hitFraction<1+PADDING}Set(x1,y1,x2,y2){this.x1=x1;this.y1=y1;this.x2=x2;this.y2=y2;this.dx=x2-
x1;this.dy=y2-y1;this.rect.set(x1,y1,x2,y2);this.rect.normalize();this.hitFraction=NO_HIT;this.hitUid=null;this.hitNormal=0;this.hitNormalDx=0;this.hitNormalDy=0;this.hitX=0;this.hitY=0;this.distance=0;this.normalX=1;this.normalY=0;this.reflectionX=1;this.reflectionY=0;return this}Complete(){if(this.DidCollide()===false)return;const dx=this.dx*this.hitFraction;const dy=this.dy*this.hitFraction;const length=Math.sqrt(dx*dx+dy*dy);const dirx=dx/length;const diry=dy/length;this.distance=length-PADDING;
this.hitX=this.x1+dirx*this.distance;this.hitY=this.y1+diry*this.distance;this.hitNormal=Math.atan2(this.hitNormalDy,this.hitNormalDx)+Math.PI/2;this.normalX=Math.cos(this.hitNormal);this.normalY=Math.sin(this.hitNormal);const dot=dirx*this.normalX+diry*this.normalY;this.reflectionX=dirx-2*this.normalX*dot;this.reflectionY=diry-2*this.normalY*dot;if(dot>0){const PI=Math.PI;this.hitNormal=C3.clampAngle(this.hitNormal+PI);this.normalX=-this.normalX;this.normalY=-this.normalY}}TestInstanceSegment(inst,
sx1,sy1,sx2,sy2){const t=C3.rayIntersect(this.x1,this.y1,this.x2,this.y2,sx1,sy1,sx2,sy2);if(t>=0&&t<this.hitFraction){this.hitFraction=t;this.hitUid=inst.GetUID();this.hitNormalDx=sx1-sx2;this.hitNormalDy=sy1-sy2}}TestInstanceRect(inst,offX,offY,rect){const lt=offX+rect.getLeft(),rt=offX+rect.getRight(),tp=offY+rect.getTop(),bm=offY+rect.getBottom();this.TestInstanceSegment(inst,lt,tp,rt,tp);this.TestInstanceSegment(inst,rt,tp,rt,bm);this.TestInstanceSegment(inst,rt,bm,lt,bm);this.TestInstanceSegment(inst,
lt,bm,lt,tp)}TestInstanceQuad(inst,quad){const tlX=quad.getTlx(),tlY=quad.getTly(),trX=quad.getTrx(),trY=quad.getTry(),brX=quad.getBrx(),brY=quad.getBry(),blX=quad.getBlx(),blY=quad.getBly();this.TestInstanceSegment(inst,tlX,tlY,trX,trY);this.TestInstanceSegment(inst,trX,trY,brX,brY);this.TestInstanceSegment(inst,brX,brY,blX,blY);this.TestInstanceSegment(inst,blX,blY,tlX,tlY)}TestInstancePoly(inst,offX,offY,poly){const points=poly.pointsArr();for(let i=0,l=points.length;i<l;i+=2){const ii=(i+2)%l;
const x1=points[i]+offX;const y1=points[i+1]+offY;const x2=points[ii]+offX;const y2=points[ii+1]+offY;this.TestInstanceSegment(inst,x1,y1,x2,y2)}}}};


// c3/canvasManager.js
'use strict';{const C3=self.C3;const VALID_FULLSCREEN_MODES=new Set(["off","crop","scale-inner","scale-outer","letterbox-scale","letterbox-integer-scale"]);const VALID_FULLSCREEN_SCALING_QUALITIES=new Set(["high","low"]);const PERCENTTEXT_WIDTH=300;const PERCENTTEXT_HEIGHT=200;const PROGRESSBAR_WIDTH=120;const PROGRESSBAR_HEIGHT=8;const tempQuad=C3.New(C3.Quad);const tempRect=C3.New(C3.Rect);const SPLASH_MIN_DISPLAY_TIME=3E3;const SPLASH_AFTER_FADEOUT_WAIT_TIME=200;const SPLASH_FADE_DURATION=300;
C3.CanvasManager=class CanvasManager extends C3.DefendedBase{constructor(runtime){super();this._runtime=runtime;this._canvas=null;this._webglRenderer=null;this._gpuPreference="high-performance";this._windowInnerWidth=0;this._windowInnerHeight=0;this._canvasCssWidth=0;this._canvasCssHeight=0;this._canvasDeviceWidth=0;this._canvasDeviceHeight=0;this._canvasCssOffsetX=0;this._canvasCssOffsetY=0;this._enableMipmaps=true;this._textureAnisotropy=0;this._drawWidth=0;this._drawHeight=0;this._fullscreenMode=
"letterbox-scale";this._documentFullscreenMode="letterbox-scale";this._deviceTransformOffX=0;this._deviceTransformOffY=0;this._wantFullscreenScalingQuality="high";this._fullscreenScalingQuality=this._wantFullscreenScalingQuality;this._isDocumentFullscreen=false;this._availableAdditionalRenderTargets=[];this._usedAdditionalRenderTargets=new Set;this._shaderData=null;this._gpuFrameTimingsBuffer=null;this._gpuTimeStartFrame=0;this._gpuTimeEndFrame=0;this._gpuCurUtilisation=NaN;this._gpuLastUtilisation=
0;this._layersGpuProfile=new Map;this._snapshotFormat="";this._snapshotQuality=1;this._snapshotArea=C3.New(C3.Rect);this._snapshotUrl="";this._snapshotPromise=null;this._snapshotResolve=null;this._loaderStartTime=0;this._rafId=-1;this._loadingProgress=0;this._loadingprogress_handler=e=>this._loadingProgress=e.progress;this._percentText=null;this._splashTextures={logo:null,powered:null,website:null};this._splashFrameNumber=0;this._splashFadeInFinishTime=0;this._splashFadeOutStartTime=0;this._splashState=
"fade-in";this._splashDoneResolve=null;this._splashDonePromise=new Promise(resolve=>this._splashDoneResolve=resolve)}_SetGPUPowerPreference(pref){this._gpuPreference=pref}async CreateCanvas(opts){this._canvas=opts["canvas"];this._canvas.addEventListener("webglcontextlost",e=>this._OnWebGLContextLost(e));this._canvas.addEventListener("webglcontextrestored",e=>this._OnWebGLContextRestored(e));const rendererOpts={powerPreference:this._gpuPreference,enableGpuProfiling:true,depth:this._runtime.Uses3DFeatures()};
if(C3.Platform.OS==="Android"&&C3.Platform.BrowserEngine==="Chromium"&&C3.Platform.BrowserVersionNumber<75){console.warn("[Construct 3] Disabling WebGL 2 because this device appears to be affected by crbug.com/934823. Install software updates to avoid this.");rendererOpts.maxWebGLVersion=1}if(this._runtime.GetCompositingMode()==="standard")rendererOpts.alpha=true;else{rendererOpts.alpha=false;rendererOpts.lowLatency=true}this._webglRenderer=C3.New(C3.Gfx.WebGLRenderer,this._canvas,rendererOpts);await this._webglRenderer.InitState();
if(!this._webglRenderer.SupportsGPUProfiling())this._gpuLastUtilisation=NaN;this._runtime.AddDOMComponentMessageHandler("runtime","window-resize",e=>this._OnWindowResize(e));this._runtime.AddDOMComponentMessageHandler("runtime","fullscreenchange",e=>this._OnFullscreenChange(e));this._runtime.AddDOMComponentMessageHandler("runtime","fullscreenerror",e=>this._OnFullscreenError(e));this._isDocumentFullscreen=!!opts["isFullscreen"];this.SetSize(opts["windowInnerWidth"],opts["windowInnerHeight"],true);
this._shaderData=self["C3_Shaders"];await this._LoadShaderPrograms();let hasAnyBackgroundBlending=false;for(const effectList of this._runtime._GetAllEffectLists()){for(const effectType of effectList.GetAllEffectTypes()){effectType._InitRenderer(this._webglRenderer);if(effectType.GetShaderProgram().UsesDest())hasAnyBackgroundBlending=true}effectList.UpdateActiveEffects()}this._runtime._SetUsesAnyBackgroundBlending(hasAnyBackgroundBlending);if(this._webglRenderer.SupportsGPUProfiling())this._gpuFrameTimingsBuffer=
C3.New(C3.Gfx.WebGLQueryResultBuffer,this._webglRenderer);this._webglRenderer.SetMipmapsEnabled(this._enableMipmaps)}async _LoadShaderPrograms(){if(!this._shaderData)return;const promises=[];for(const [id,data]of Object.entries(this._shaderData)){const vertexSrc=C3.Gfx.WebGLShaderProgram.GetDefaultVertexShaderSource();promises.push(this._webglRenderer.CreateShaderProgram(data,vertexSrc,id))}await Promise.all(promises);this._webglRenderer.ResetLastProgram();this._webglRenderer.SetTextureFillMode()}Release(){this._runtime=
null;this._webglRenderer=null;this._canvas=null}_OnWindowResize(e){const dpr=e["devicePixelRatio"];if(this._runtime.IsInWorker())self.devicePixelRatio=dpr;this._runtime._SetDevicePixelRatio(dpr);this._isDocumentFullscreen=!!e["isFullscreen"];this.SetSize(e["innerWidth"],e["innerHeight"]);this._runtime.UpdateRender()}_OnFullscreenChange(e){this._isDocumentFullscreen=!!e["isFullscreen"];this.SetSize(e["innerWidth"],e["innerHeight"],true);this._runtime.UpdateRender()}_OnFullscreenError(e){this._isDocumentFullscreen=
!!e["isFullscreen"];this.SetSize(e["innerWidth"],e["innerHeight"],true);this._runtime.UpdateRender()}SetSize(availableWidth,availableHeight,force=false){availableWidth=Math.floor(availableWidth);availableHeight=Math.floor(availableHeight);if(availableWidth<=0||availableHeight<=0)throw new Error("invalid size");if(this._windowInnerWidth===availableWidth&&this._windowInnerHeight===availableHeight&&!force)return;this._windowInnerWidth=availableWidth;this._windowInnerHeight=availableHeight;const fullscreenMode=
this.GetCurrentFullscreenMode();if(fullscreenMode==="letterbox-scale")this._CalculateLetterboxScale(availableWidth,availableHeight);else if(fullscreenMode==="letterbox-integer-scale")this._CalculateLetterboxIntegerScale(availableWidth,availableHeight);else if(fullscreenMode==="off")this._CalculateFixedSizeCanvas(availableWidth,availableHeight);else this._CalculateFullsizeCanvas(availableWidth,availableHeight);this._UpdateFullscreenScalingQuality(fullscreenMode);this._canvas.width=this._canvasDeviceWidth;
this._canvas.height=this._canvasDeviceHeight;this._runtime.PostComponentMessageToDOM("canvas","update-size",{"marginLeft":this._canvasCssOffsetX,"marginTop":this._canvasCssOffsetY,"styleWidth":this._canvasCssWidth,"styleHeight":this._canvasCssHeight});this._webglRenderer.SetSize(this._canvasDeviceWidth,this._canvasDeviceHeight,true);for(const rt of this._availableAdditionalRenderTargets)this._webglRenderer.DeleteRenderTarget(rt);C3.clearArray(this._availableAdditionalRenderTargets)}_CalculateLetterboxScale(availableWidth,
availableHeight){const dpr=this._runtime.GetDevicePixelRatio();const originalViewportWidth=this._runtime.GetOriginalViewportWidth();const originalViewportHeight=this._runtime.GetOriginalViewportHeight();const originalAspectRatio=originalViewportWidth/originalViewportHeight;const availableAspectRatio=availableWidth/availableHeight;if(availableAspectRatio>originalAspectRatio){const letterboxedWidth=availableHeight*originalAspectRatio;this._canvasCssWidth=Math.round(letterboxedWidth);this._canvasCssHeight=
availableHeight;this._canvasCssOffsetX=Math.floor((availableWidth-this._canvasCssWidth)/2);this._canvasCssOffsetY=0}else{const letterboxedHeight=availableWidth/originalAspectRatio;this._canvasCssWidth=availableWidth;this._canvasCssHeight=Math.round(letterboxedHeight);this._canvasCssOffsetX=0;this._canvasCssOffsetY=Math.floor((availableHeight-this._canvasCssHeight)/2)}this._canvasDeviceWidth=Math.round(this._canvasCssWidth*dpr);this._canvasDeviceHeight=Math.round(this._canvasCssHeight*dpr);this._runtime.SetViewportSize(originalViewportWidth,
originalViewportHeight)}_CalculateLetterboxIntegerScale(availableWidth,availableHeight){const dpr=this._runtime.GetDevicePixelRatio();if(dpr!==1){availableWidth+=1;availableHeight+=1}const originalViewportWidth=this._runtime.GetOriginalViewportWidth();const originalViewportHeight=this._runtime.GetOriginalViewportHeight();const originalAspectRatio=originalViewportWidth/originalViewportHeight;const availableAspectRatio=availableWidth/availableHeight;let intScale;if(availableAspectRatio>originalAspectRatio){const letterboxedWidth=
availableHeight*originalAspectRatio;intScale=letterboxedWidth*dpr/originalViewportWidth}else{const letterboxedHeight=availableWidth/originalAspectRatio;intScale=letterboxedHeight*dpr/originalViewportHeight}if(intScale>1)intScale=Math.floor(intScale);else if(intScale<1)intScale=1/Math.ceil(1/intScale);this._canvasDeviceWidth=Math.round(originalViewportWidth*intScale);this._canvasDeviceHeight=Math.round(originalViewportHeight*intScale);this._canvasCssWidth=this._canvasDeviceWidth/dpr;this._canvasCssHeight=
this._canvasDeviceHeight/dpr;this._canvasCssOffsetX=Math.max(Math.floor((availableWidth-this._canvasCssWidth)/2),0);this._canvasCssOffsetY=Math.max(Math.floor((availableHeight-this._canvasCssHeight)/2),0);this._runtime.SetViewportSize(originalViewportWidth,originalViewportHeight)}_CalculateFullsizeCanvas(availableWidth,availableHeight){const dpr=this._runtime.GetDevicePixelRatio();this._canvasCssWidth=availableWidth;this._canvasCssHeight=availableHeight;this._canvasDeviceWidth=Math.round(this._canvasCssWidth*
dpr);this._canvasDeviceHeight=Math.round(this._canvasCssHeight*dpr);this._canvasCssOffsetX=0;this._canvasCssOffsetY=0;const displayScale=this.GetDisplayScale();this._runtime.SetViewportSize(this._canvasCssWidth/displayScale,this._canvasCssHeight/displayScale)}_CalculateFixedSizeCanvas(availableWidth,availableHeight){const dpr=this._runtime.GetDevicePixelRatio();this._canvasCssWidth=this._runtime.GetViewportWidth();this._canvasCssHeight=this._runtime.GetViewportHeight();this._canvasDeviceWidth=Math.round(this._canvasCssWidth*
dpr);this._canvasDeviceHeight=Math.round(this._canvasCssHeight*dpr);if(this.IsDocumentFullscreen()){this._canvasCssOffsetX=Math.floor((availableWidth-this._canvasCssWidth)/2);this._canvasCssOffsetY=Math.floor((availableHeight-this._canvasCssHeight)/2)}else{this._canvasCssOffsetX=0;this._canvasCssOffsetY=0}this._runtime.SetViewportSize(this._runtime.GetViewportWidth(),this._runtime.GetViewportHeight())}_UpdateFullscreenScalingQuality(fullscreenMode){if(this._wantFullscreenScalingQuality==="high"){this._drawWidth=
this._canvasDeviceWidth;this._drawHeight=this._canvasDeviceHeight;this._fullscreenScalingQuality="high"}else{let viewportWidth,viewportHeight;if(this.GetCurrentFullscreenMode()==="off"){viewportWidth=this._runtime.GetViewportWidth();viewportHeight=this._runtime.GetViewportHeight()}else{viewportWidth=this._runtime.GetOriginalViewportWidth();viewportHeight=this._runtime.GetOriginalViewportHeight()}if(this._canvasDeviceWidth<viewportWidth&&this._canvasDeviceHeight<viewportHeight){this._drawWidth=this._canvasDeviceWidth;
this._drawHeight=this._canvasDeviceHeight;this._fullscreenScalingQuality="high"}else{this._drawWidth=viewportWidth;this._drawHeight=viewportHeight;this._fullscreenScalingQuality="low";if(fullscreenMode==="scale-inner"){const originalAspectRatio=viewportWidth/viewportHeight;const currentAspectRatio=this._windowInnerWidth/this._windowInnerHeight;if(currentAspectRatio<originalAspectRatio)this._drawWidth=this._drawHeight*currentAspectRatio;else if(currentAspectRatio>originalAspectRatio)this._drawHeight=
this._drawWidth/currentAspectRatio}else if(fullscreenMode==="scale-outer"){const originalAspectRatio=viewportWidth/viewportHeight;const currentAspectRatio=this._windowInnerWidth/this._windowInnerHeight;if(currentAspectRatio>originalAspectRatio)this._drawWidth=this._drawHeight*currentAspectRatio;else if(currentAspectRatio<originalAspectRatio)this._drawHeight=this._drawWidth/currentAspectRatio}}}}IsDocumentFullscreen(){return this._isDocumentFullscreen}SetFullscreenMode(m){if(!VALID_FULLSCREEN_MODES.has(m))throw new Error("invalid fullscreen mode");
this._fullscreenMode=m}GetFullscreenMode(){return this._fullscreenMode}SetDocumentFullscreenMode(m){if(!VALID_FULLSCREEN_MODES.has(m))throw new Error("invalid fullscreen mode");this._documentFullscreenMode=m}GetDocumentFullscreenMode(){return this._documentFullscreenMode}GetCurrentFullscreenMode(){if(this.IsDocumentFullscreen())return this.GetDocumentFullscreenMode();else return this.GetFullscreenMode()}SetFullscreenScalingQuality(q){if(!VALID_FULLSCREEN_SCALING_QUALITIES.has(q))throw new Error("invalid fullscreen scaling quality");
this._wantFullscreenScalingQuality=q}GetSetFullscreenScalingQuality(){return this._wantFullscreenScalingQuality}GetCurrentFullscreenScalingQuality(){return this._fullscreenScalingQuality}static _FullscreenModeNumberToString(n){switch(n){case 0:return"off";case 1:return"crop";case 2:return"scale-inner";case 3:return"scale-outer";case 4:return"letterbox-scale";case 5:return"letterbox-integer-scale";default:throw new Error("invalid fullscreen mode");}}GetLastWidth(){return this._windowInnerWidth}GetLastHeight(){return this._windowInnerHeight}GetDrawWidth(){return this._drawWidth}GetDrawHeight(){return this._drawHeight}SetMipmapsEnabled(e){this._enableMipmaps=
!!e}_SetTextureAnisotropy(a){this._textureAnisotropy=a}GetTextureAnisotropy(){return this._textureAnisotropy}IsWebGLContextLost(){return this._webglRenderer.IsContextLost()}_OnWebGLContextLost(e){console.log("[Construct 3] WebGL context lost");e.preventDefault();this._availableAdditionalRenderTargets=[];this._usedAdditionalRenderTargets.clear();this._webglRenderer.OnContextLost();this._runtime._OnWebGLContextLost()}async _OnWebGLContextRestored(e){await this._webglRenderer.OnContextRestored();await this._LoadShaderPrograms();
for(const effectList of this._runtime._GetAllEffectLists())for(const effectType of effectList.GetAllEffectTypes())effectType._InitRenderer(this._webglRenderer);await this._runtime._OnWebGLContextRestored();console.log("[Construct 3] WebGL context restored")}GetWebGLRenderer(){return this._webglRenderer}GetRenderScale(){if(this._fullscreenScalingQuality==="low")return 1/this._runtime.GetDevicePixelRatio();return this.GetDisplayScale()}GetDisplayScale(){const fullscreenMode=this.GetCurrentFullscreenMode();
if(fullscreenMode==="off"||fullscreenMode==="crop")return 1;const originalViewportWidth=this._runtime.GetOriginalViewportWidth();const originalViewportHeight=this._runtime.GetOriginalViewportHeight();const originalAspectRatio=originalViewportWidth/originalViewportHeight;const currentAspectRatio=this._canvasDeviceWidth/this._canvasDeviceHeight;if(fullscreenMode!=="scale-inner"&&currentAspectRatio>originalAspectRatio||fullscreenMode==="scale-inner"&&currentAspectRatio<originalAspectRatio)return this._canvasCssHeight/
originalViewportHeight;else return this._canvasCssWidth/originalViewportWidth}SetDeviceTransformOffset(x,y){this._deviceTransformOffX=x;this._deviceTransformOffY=y}SetDeviceTransform(renderer,w,h){const scrollX=(w||this._drawWidth)/2+this._deviceTransformOffX;const scrollY=(h||this._drawHeight)/2+this._deviceTransformOffY;renderer.SetCameraXYZ(scrollX,scrollY,100*this._runtime.GetDevicePixelRatio());renderer.SetLookXYZ(scrollX,scrollY,0);renderer.ResetModelView();renderer.UpdateModelView()}SetCssTransform(renderer){const scrollX=
this._canvasCssWidth/2;const scrollY=this._canvasCssHeight/2;renderer.SetCameraXYZ(scrollX,scrollY,100);renderer.SetLookXYZ(scrollX,scrollY,0);renderer.ResetModelView();renderer.UpdateModelView()}GetDeviceWidth(){return this._canvasDeviceWidth}GetDeviceHeight(){return this._canvasDeviceHeight}GetCssWidth(){return this._canvasCssWidth}GetCssHeight(){return this._canvasCssHeight}GetCanvasClientX(){return this._canvasCssOffsetX}GetCanvasClientY(){return this._canvasCssOffsetY}GetAdditionalRenderTarget(opts){opts.depth=
this._runtime.Uses3DFeatures();const arr=this._availableAdditionalRenderTargets;const useIndex=arr.findIndex(rt=>rt.IsCompatibleWithOptions(opts));let ret;if(useIndex!==-1){ret=arr[useIndex];arr.splice(useIndex,1)}else ret=this._webglRenderer.CreateRenderTarget(opts);this._usedAdditionalRenderTargets.add(ret);return ret}ReleaseAdditionalRenderTarget(renderTarget){if(!this._usedAdditionalRenderTargets.has(renderTarget))throw new Error("render target not in use");this._usedAdditionalRenderTargets.delete(renderTarget);
this._availableAdditionalRenderTargets.push(renderTarget)}*activeLayersGpuProfiles(){for(const layout of this._runtime.GetLayoutManager().runningLayouts())for(const layer of layout.GetLayers()){const p=this._layersGpuProfile.get(layer);if(p)yield p}}GetLayerTimingsBuffer(layer){if(!this._webglRenderer.SupportsGPUProfiling())return null;let p=this._layersGpuProfile.get(layer);if(!p){p={name:layer.GetName(),timingsBuffer:C3.New(C3.Gfx.WebGLQueryResultBuffer,this._webglRenderer),curUtilisation:0,lastUtilisation:0};
this._layersGpuProfile.set(layer,p)}return p.timingsBuffer}_Update1sFrameRange(){if(!this._webglRenderer.SupportsGPUProfiling())return;if(this._gpuTimeEndFrame===0){this._gpuTimeEndFrame=this._webglRenderer.GetFrameNumber();this._gpuCurUtilisation=NaN;for(const p of this.activeLayersGpuProfiles())p.curUtilisation=NaN}}_UpdateTick(){if(!this._webglRenderer.SupportsGPUProfiling()||!isNaN(this._gpuCurUtilisation))return;this._gpuCurUtilisation=this._gpuFrameTimingsBuffer.GetFrameRangeResultSum(this._gpuTimeStartFrame,
this._gpuTimeEndFrame);if(isNaN(this._gpuCurUtilisation))return;if(this._runtime.IsDebug())for(const p of this.activeLayersGpuProfiles()){p.curUtilisation=p.timingsBuffer.GetFrameRangeResultSum(this._gpuTimeStartFrame,this._gpuTimeEndFrame);if(isNaN(p.curUtilisation))return}this._gpuFrameTimingsBuffer.DeleteAllBeforeFrameNumber(this._gpuTimeEndFrame);this._gpuLastUtilisation=Math.min(this._gpuCurUtilisation,1);if(this._runtime.IsDebug()){for(const p of this.activeLayersGpuProfiles()){p.timingsBuffer.DeleteAllBeforeFrameNumber(this._gpuTimeEndFrame);
p.lastUtilisation=Math.min(p.curUtilisation,1)}self.C3Debugger.UpdateGPUProfile(this._gpuLastUtilisation,[...this.activeLayersGpuProfiles()])}this._gpuTimeStartFrame=this._gpuTimeEndFrame;this._gpuTimeEndFrame=0}GetGPUFrameTimingsBuffer(){return this._gpuFrameTimingsBuffer}GetGPUUtilisation(){return this._gpuLastUtilisation}SnapshotCanvas(format,quality,x,y,width,height){this._snapshotFormat=format;this._snapshotQuality=quality;this._snapshotArea.setWH(x,y,width,height);if(this._snapshotPromise)return this._snapshotPromise;
this._snapshotPromise=new Promise(resolve=>{this._snapshotResolve=resolve});return this._snapshotPromise}_MaybeTakeSnapshot(){if(!this._snapshotFormat)return;let canvas=this._canvas;const snapArea=this._snapshotArea;const x=C3.clamp(Math.floor(snapArea.getLeft()),0,canvas.width);const y=C3.clamp(Math.floor(snapArea.getTop()),0,canvas.height);let w=snapArea.width();if(w===0)w=canvas.width-x;else w=C3.clamp(Math.floor(w),0,canvas.width-x);let h=snapArea.height();if(h===0)h=canvas.height-y;else h=C3.clamp(Math.floor(h),
0,canvas.height-y);if((x!==0||y!==0||w!==canvas.width||h!==canvas.height)&&(w>0&&h>0)){canvas=C3.CreateCanvas(w,h);const ctx=canvas.getContext("2d");ctx.drawImage(this._canvas,x,y,w,h,0,0,w,h)}C3.CanvasToBlob(canvas,this._snapshotFormat,this._snapshotQuality).then(blob=>{this._snapshotUrl=URL.createObjectURL(blob);this._snapshotPromise=null;this._snapshotResolve(this._snapshotUrl)});this._snapshotFormat="";this._snapshotQuality=1}GetCanvasSnapshotUrl(){return this._snapshotUrl}InitLoadingScreen(loaderStyle){if(loaderStyle===
2){this._percentText=C3.New(C3.Gfx.RendererText,this._webglRenderer);this._percentText.SetIsAsync(false);this._percentText.SetFontName("Arial");this._percentText.SetFontSize(16);this._percentText.SetHorizontalAlignment("center");this._percentText.SetVerticalAlignment("center");this._percentText.SetSize(PERCENTTEXT_WIDTH,PERCENTTEXT_HEIGHT)}else if(loaderStyle===0){const loadingLogoAsset=this._runtime.GetLoadingLogoAsset();if(loadingLogoAsset)loadingLogoAsset.LoadStaticTexture(this._webglRenderer).catch(err=>
console.warn(`[C3 runtime] Failed to create texture for loading logo: `,err))}else if(loaderStyle===4){this._LoadSvgSplashImage("splash-images/splash-logo.svg").then(tex=>{if(this._splashState==="done")this._webglRenderer.DeleteTexture(tex);else this._splashTextures.logo=tex}).catch(err=>console.warn("Failed to load splash image: ",err));this._LoadBitmapSplashImage("splash-images/splash-poweredby-512.png").then(tex=>{if(this._splashState==="done")this._webglRenderer.DeleteTexture(tex);else this._splashTextures.powered=
tex}).catch(err=>console.warn("Failed to load splash image: ",err));this._LoadBitmapSplashImage("splash-images/splash-website-512.png").then(tex=>{if(this._splashState==="done")this._webglRenderer.DeleteTexture(tex);else this._splashTextures.website=tex}).catch(err=>console.warn("Failed to load splash image: ",err))}}async _LoadSvgSplashImage(url){url=(new URL(url,this._runtime.GetBaseURL())).toString();const blob=await C3.FetchBlob(url);const drawable=await this._runtime.RasterSvgImage(blob,2048,
2048);return await this._webglRenderer.CreateStaticTextureAsync(drawable,{mipMapQuality:"high"})}async _LoadBitmapSplashImage(url){url=(new URL(url,this._runtime.GetBaseURL())).toString();const blob=await C3.FetchBlob(url);return await this._webglRenderer.CreateStaticTextureAsync(blob,{mipMapQuality:"high"})}HideCordovaSplashScreen(){this._runtime.PostComponentMessageToDOM("runtime","hide-cordova-splash")}StartLoadingScreen(){this._loaderStartTime=Date.now();this._runtime.Dispatcher().addEventListener("loadingprogress",
this._loadingprogress_handler);this._rafId=requestAnimationFrame(()=>this._DrawLoadingScreen());const loaderStyle=this._runtime.GetLoaderStyle();if(loaderStyle!==3)this.HideCordovaSplashScreen()}async EndLoadingScreen(){this._loadingProgress=1;const loaderStyle=this._runtime.GetLoaderStyle();if(loaderStyle===4)await this._splashDonePromise;this._splashDoneResolve=null;this._splashDonePromise=null;if(this._rafId!==-1){cancelAnimationFrame(this._rafId);this._rafId=-1}this._runtime.Dispatcher().removeEventListener("loadingprogress",
this._loadingprogress_handler);this._loadingprogress_handler=null;if(this._percentText){this._percentText.Release();this._percentText=null}this._runtime.ReleaseLoadingLogoAsset();this._webglRenderer.Start();if(this._splashTextures.logo){this._webglRenderer.DeleteTexture(this._splashTextures.logo);this._splashTextures.logo=null}if(this._splashTextures.powered){this._webglRenderer.DeleteTexture(this._splashTextures.powered);this._splashTextures.powered=null}if(this._splashTextures.website){this._webglRenderer.DeleteTexture(this._splashTextures.website);
this._splashTextures.website=null}this._webglRenderer.ClearRgba(0,0,0,0);this._webglRenderer.Finish();this._splashState="done";this._gpuTimeStartFrame=this._webglRenderer.GetFrameNumber();if(loaderStyle===3)this.HideCordovaSplashScreen()}_DrawLoadingScreen(){if(this._rafId===-1)return;const renderer=this._webglRenderer;renderer.Start();this._rafId=-1;const hasHadError=this._runtime.GetAssetManager().HasHadErrorLoading();const loaderStyle=this._runtime.GetLoaderStyle();if(loaderStyle!==3){this.SetCssTransform(renderer);
renderer.ClearRgba(0,0,0,0);renderer.ResetColor();renderer.SetTextureFillMode();renderer.SetTexture(null)}if(loaderStyle===0)this._DrawProgressBarAndLogoLoadingScreen(hasHadError);else if(loaderStyle===1)this._DrawProgressBarLoadingScreen(hasHadError,PROGRESSBAR_WIDTH,0);else if(loaderStyle===2)this._DrawPercentTextLoadingScreen(hasHadError);else if(loaderStyle===3)C3.noop();else if(loaderStyle===4)this._DrawSplashLoadingScreen(hasHadError);else throw new Error("invalid loader style");renderer.Finish();
this._rafId=requestAnimationFrame(()=>this._DrawLoadingScreen())}_DrawPercentTextLoadingScreen(hasHadError){if(hasHadError)this._percentText.SetColorRgb(1,0,0);else this._percentText.SetColorRgb(.6,.6,.6);this._percentText.SetText(Math.round(this._loadingProgress*100)+"%");const midX=this._canvasCssWidth/2;const midY=this._canvasCssHeight/2;const hw=PERCENTTEXT_WIDTH/2;const hh=PERCENTTEXT_HEIGHT/2;tempQuad.setRect(midX-hw,midY-hh,midX+hw,midY+hh);this._webglRenderer.SetTexture(this._percentText.GetTexture());
this._webglRenderer.Quad3(tempQuad,this._percentText.GetTexRect())}_DrawProgressBarLoadingScreen(hasHadError,width,yOff){const renderer=this._webglRenderer;const height=PROGRESSBAR_HEIGHT;renderer.SetColorFillMode();if(hasHadError)renderer.SetColorRgba(1,0,0,1);else renderer.SetColorRgba(.118,.565,1,1);const midX=this._canvasCssWidth/2;const midY=this._canvasCssHeight/2;const hw=width/2;const hh=height/2;tempRect.setWH(midX-hw,midY-hh+yOff,Math.floor(width*this._loadingProgress),height);renderer.Rect(tempRect);
tempRect.setWH(midX-hw,midY-hh+yOff,width,height);tempRect.offset(-.5,-.5);tempRect.inflate(.5,.5);renderer.SetColorRgba(0,0,0,1);renderer.LineRect2(tempRect);tempRect.inflate(1,1);renderer.SetColorRgba(1,1,1,1);renderer.LineRect2(tempRect)}_DrawProgressBarAndLogoLoadingScreen(hasHadError){const loadingLogoAsset=this._runtime.GetLoadingLogoAsset();if(!loadingLogoAsset){this._DrawProgressBarLoadingScreen(hasHadError,PROGRESSBAR_WIDTH,0);return}const logoTexture=loadingLogoAsset.GetTexture();if(!logoTexture){this._DrawProgressBarLoadingScreen(hasHadError,
PROGRESSBAR_WIDTH,0);return}const logoW=logoTexture.GetWidth();const logoH=logoTexture.GetHeight();const midX=this._canvasCssWidth/2;const midY=this._canvasCssHeight/2;const hw=logoW/2;const hh=logoH/2;tempQuad.setRect(midX-hw,midY-hh,midX+hw,midY+hh);this._webglRenderer.SetTexture(logoTexture);this._webglRenderer.Quad(tempQuad);this._DrawProgressBarLoadingScreen(hasHadError,logoW,hh+16)}_DrawSplashLoadingScreen(hasHadError){const renderer=this._webglRenderer;const logoTex=this._splashTextures.logo;
const poweredTex=this._splashTextures.powered;const websiteTex=this._splashTextures.website;const nowTime=Date.now();if(this._splashFrameNumber===0)this._loaderStartTime=nowTime;const allowQuickSplash=this._runtime.IsPreview()||this._runtime.IsFBInstantAvailable()&&!this._runtime.IsCordova();const splashAfterFadeOutWait=allowQuickSplash?0:SPLASH_AFTER_FADEOUT_WAIT_TIME;const splashMinDisplayTime=allowQuickSplash?0:SPLASH_MIN_DISPLAY_TIME;let a=1;if(this._splashState==="fade-in")a=Math.min((nowTime-
this._loaderStartTime)/SPLASH_FADE_DURATION,1);else if(this._splashState==="fade-out")a=Math.max(1-(nowTime-this._splashFadeOutStartTime)/SPLASH_FADE_DURATION,0);renderer.SetColorFillMode();renderer.SetColorRgba(.231*a,.251*a,.271*a,a);tempRect.set(0,0,this._canvasCssWidth,this._canvasCssHeight);renderer.Rect(tempRect);const w=Math.ceil(this._canvasCssWidth);const h=Math.ceil(this._canvasCssHeight);let drawW,drawH;if(this._canvasCssHeight>256){renderer.SetColorRgba(.302*a,.334*a,.365*a,a);drawW=w;
drawH=Math.max(h*.005,2);tempRect.setWH(0,h*.8-drawH/2,drawW,drawH);renderer.Rect(tempRect);if(hasHadError)renderer.SetColorRgba(a,0,0,a);else renderer.SetColorRgba(.161*a,.953*a,.816*a,a);drawW=w*this._loadingProgress;tempRect.setWH(w*.5-drawW/2,h*.8-drawH/2,drawW,drawH);renderer.Rect(tempRect);renderer.SetColorRgba(a,a,a,a);renderer.SetTextureFillMode();if(poweredTex){drawW=C3.clamp(h*.22,105,w*.6)*1.5;drawH=drawW/8;tempRect.setWH(w*.5-drawW/2,h*.2-drawH/2,drawW,drawH);renderer.SetTexture(poweredTex);
renderer.Rect(tempRect)}if(logoTex){drawW=Math.min(h*.395,w*.95);drawH=drawW;tempRect.setWH(w*.5-drawW/2,h*.485-drawH/2,drawW,drawH);renderer.SetTexture(logoTex);renderer.Rect(tempRect)}if(websiteTex){drawW=C3.clamp(h*.22,105,w*.6)*1.5;drawH=drawW/8;tempRect.setWH(w*.5-drawW/2,h*.868-drawH/2,drawW,drawH);renderer.SetTexture(websiteTex);renderer.Rect(tempRect)}}else{renderer.SetColorRgba(.302*a,.334*a,.365*a,a);drawW=w;drawH=Math.max(h*.005,2);tempRect.setWH(0,h*.85-drawH/2,drawW,drawH);renderer.Rect(tempRect);
if(hasHadError)renderer.SetColorRgba(a,0,0,a);else renderer.SetColorRgba(.161*a,.953*a,.816*a,a);drawW=w*this._loadingProgress;tempRect.setWH(w*.5-drawW/2,h*.85-drawH/2,drawW,drawH);renderer.Rect(tempRect);renderer.SetColorRgba(a,a,a,a);renderer.SetTextureFillMode();if(logoTex){drawW=h*.55;drawH=drawW;tempRect.setWH(w*.5-drawW/2,h*.45-drawH/2,drawW,drawH);renderer.SetTexture(logoTex);renderer.Rect(tempRect)}}this._splashFrameNumber++;if(this._splashState==="fade-in"&&nowTime-this._loaderStartTime>=
SPLASH_FADE_DURATION&&this._splashFrameNumber>=2){this._splashState="wait";this._splashFadeInFinishTime=nowTime}if(this._splashState==="wait"&&nowTime-this._splashFadeInFinishTime>=splashMinDisplayTime&&this._loadingProgress>=1){this._splashState="fade-out";this._splashFadeOutStartTime=nowTime}if(this._splashState==="fade-out"&&nowTime-this._splashFadeOutStartTime>=SPLASH_FADE_DURATION+splashAfterFadeOutWait||allowQuickSplash&&this._loadingProgress>=1&&nowTime-this._loaderStartTime<500)this._splashDoneResolve()}}};


// c3/runtime.js
'use strict';{const C3=self.C3;const C3Debugger=self.C3Debugger;const assert=self.assert;const DEFAULT_RUNTIME_OPTS={"messagePort":null,"baseUrl":"","headless":false,"hasDom":true,"isInWorker":false,"useAudio":true,"projectData":"","exportType":""};let ife=true;C3.Runtime=class C3Runtime extends C3.DefendedBase{constructor(opts){opts=Object.assign({},DEFAULT_RUNTIME_OPTS,opts);super();this._messagePort=opts["messagePort"];this._baseUrl=opts["baseUrl"];this._isHeadless=!!opts["headless"];this._hasDom=
!!opts["hasDom"];this._isInWorker=!!opts["isInWorker"];ife=opts["ife"];this._useAudio=!!opts["useAudio"];this._exportType=opts["exportType"];this._isiOSCordova=!!opts["isiOSCordova"];this._isiOSWebView=!!opts["isiOSWebView"];this._isFBInstantAvailable=!!opts["isFBInstantAvailable"];this._opusWasmScriptUrl=opts["opusWasmScriptUrl"];this._opusWasmBinaryUrl=opts["opusWasmBinaryUrl"];this._isDebug=!!(this._exportType==="preview"&&opts["isDebug"]);this._breakpointsEnabled=this._isDebug;this._isDebugging=
this._isDebug;this._debuggingDisabled=0;this._additionalLoadPromises=[];this._additionalCreatePromises=[];this._isUsingCreatePromises=false;this._projectName="";this._projectVersion="";this._projectUniqueId="";this._appId="";this._originalViewportWidth=0;this._originalViewportHeight=0;this._devicePixelRatio=self.devicePixelRatio;this._parallaxXorigin=0;this._parallaxYorigin=0;this._viewportWidth=0;this._viewportHeight=0;this._loaderStyle=0;this._usesLoaderLayout=false;this._isLoading=true;this._usesAnyBackgroundBlending=
false;this._loadingLogoAsset=null;this._assetManager=C3.New(C3.AssetManager,this,opts);this._layoutManager=C3.New(C3.LayoutManager,this);this._eventSheetManager=C3.New(C3.EventSheetManager,this);this._pluginManager=C3.New(C3.PluginManager,this);this._collisionEngine=C3.New(C3.CollisionEngine,this);this._timelineManager=C3.New(C3.TimelineManager,this);this._transitionManager=C3.New(C3.TransitionManager,this);this._allObjectClasses=[];this._objectClassesByName=new Map;this._objectClassesBySid=new Map;
this._familyCount=0;this._allContainers=[];this._allEffectLists=[];this._currentLayoutStack=[];this._instancesPendingCreate=[];this._instancesPendingDestroy=new Map;this._hasPendingInstances=false;this._isFlushingPendingInstances=false;this._objectCount=0;this._nextUid=0;this._instancesByUid=new Map;this._instancesToReleaseAtEndOfTick=new Set;this._instancesToReleaseAffectedObjectClasses=new Set;this._objectReferenceTable=[];this._jsPropNameTable=[];this._canvasManager=null;this._uses3dFeatures=false;
this._framerateMode="vsync";this._compositingMode="standard";this._sampling="trilinear";this._isPixelRoundingEnabled=false;this._needRender=true;this._pauseOnBlur=false;this._isPausedOnBlur=false;this._tickCallbacks={normal:timestamp=>{this._rafId=-1;this._ruafId=-1;this.Tick(timestamp)},tickOnly:timestamp=>{this._ruafId=-1;this.Tick(timestamp,false,"skip-render")},renderOnly:()=>{this._rafId=-1;this.Render()}};this._rafId=-1;this._ruafId=-1;this._tickCount=0;this._tickCountNoSave=0;this._execCount=
0;this._hasStarted=false;this._isInTick=false;this._hasStartedTicking=false;this._isLayoutFirstTick=true;this._suspendCount=0;this._scheduleTriggersThrottle=new C3.PromiseThrottle(1);this._randomNumberCallback=()=>Math.random();this._startTime=0;this._lastTickTime=0;this._dt1=0;this._dt=0;this._timeScale=1;this._minimumFramerate=30;this._gameTime=C3.New(C3.KahanSum);this._wallTime=C3.New(C3.KahanSum);this._fpsFrameCount=-1;this._fpsLastTime=0;this._fps=0;this._mainThreadTimeCounter=0;this._mainThreadTime=
0;this._isLoadingState=false;this._saveToSlotName="";this._loadFromSlotName="";this._loadFromJson=null;this._lastSaveJson="";this._projectStorage=null;this._savegamesStorage=null;this._dispatcher=C3.New(C3.Event.Dispatcher);this._domEventHandlers=new Map;this._pendingResponsePromises=new Map;this._nextDomResponseId=0;this._didRequestDeviceOrientationEvent=false;this._didRequestDeviceMotionEvent=false;this._isReadyToHandleEvents=false;this._waitingToHandleEvents=[];this._eventObjects={"pretick":C3.New(C3.Event,
"pretick",false),"tick":C3.New(C3.Event,"tick",false),"tick2":C3.New(C3.Event,"tick2",false),"instancedestroy":C3.New(C3.Event,"instancedestroy",false),"beforelayoutchange":C3.New(C3.Event,"beforelayoutchange",false),"layoutchange":C3.New(C3.Event,"layoutchange",false)};this._eventObjects["instancedestroy"].instance=null;this._userScriptDispatcher=C3.New(C3.Event.Dispatcher);this._userScriptEventObjects=null;this._behInstsToTick=C3.New(C3.RedBlackSet,C3.BehaviorInstance.SortByTickSequence);this._behInstsToPostTick=
C3.New(C3.RedBlackSet,C3.BehaviorInstance.SortByTickSequence);this._behInstsToTick2=C3.New(C3.RedBlackSet,C3.BehaviorInstance.SortByTickSequence);this._jobScheduler=C3.New(C3.JobSchedulerRuntime,this,opts["jobScheduler"]);if(opts["canvas"])this._canvasManager=C3.New(C3.CanvasManager,this);this._messagePort.onmessage=e=>this["_OnMessageFromDOM"](e.data);this.AddDOMComponentMessageHandler("runtime","visibilitychange",e=>this._OnVisibilityChange(e));this.AddDOMComponentMessageHandler("runtime","opus-decode",
e=>this._WasmDecodeWebMOpus(e["arrayBuffer"]));this.AddDOMComponentMessageHandler("runtime","get-remote-preview-status-info",()=>this._GetRemotePreviewStatusInfo());this.AddDOMComponentMessageHandler("runtime","js-invoke-function",e=>this._InvokeFunctionFromJS(e));this.AddDOMComponentMessageHandler("runtime","go-to-last-error-script",self["goToLastErrorScript"]);this._dispatcher.addEventListener("window-blur",e=>this._OnWindowBlur(e));this._dispatcher.addEventListener("window-focus",()=>this._OnWindowFocus());
this._timelineManager.AddRuntimeListeners();this._iRuntime=null;this._interfaceMap=new WeakMap;this._commonScriptInterfaces={keyboard:null,mouse:null,touch:null}}static Create(opts){return C3.New(C3.Runtime,opts)}Release(){C3.clearArray(this._allObjectClasses);this._objectClassesByName.clear();this._objectClassesBySid.clear();this._layoutManager.Release();this._layoutManager=null;this._eventSheetManager.Release();this._eventSheetManager=null;this._pluginManager.Release();this._pluginManager=null;
this._assetManager.Release();this._assetManager=null;this._collisionEngine.Release();this._collisionEngine=null;this._timelineManager.Release();this._timelineManager=null;this._transitionManager.Release();this._transitionManager=null;if(this._canvasManager){this._canvasManager.Release();this._canvasManager=null}this._dispatcher.Release();this._dispatcher=null;this._tickEvent=null}["_OnMessageFromDOM"](data){const type=data["type"];if(type==="event")this._OnEventFromDOM(data);else if(type==="result")this._OnResultFromDOM(data);
else throw new Error(`unknown message '${type}'`);}_OnEventFromDOM(e){if(!this._isReadyToHandleEvents){this._waitingToHandleEvents.push(e);return}const component=e["component"];const handler=e["handler"];const data=e["data"];const dispatchOpts=e["dispatchOpts"];const dispatchRuntimeEvent=!!(dispatchOpts&&dispatchOpts["dispatchRuntimeEvent"]);const dispatchUserScriptEvent=!!(dispatchOpts&&dispatchOpts["dispatchUserScriptEvent"]);const responseId=e["responseId"];if(component==="runtime"){if(dispatchRuntimeEvent){const event=
new C3.Event(handler);event.data=data;this._dispatcher.dispatchEventAndWaitAsyncSequential(event)}if(dispatchUserScriptEvent){const event=new C3.Event(handler,true);for(const [key,value]of Object.entries(data))event[key]=value;this.DispatchUserScriptEvent(event)}}const handlerMap=this._domEventHandlers.get(component);if(!handlerMap){if(!dispatchRuntimeEvent&&!dispatchUserScriptEvent)console.warn(`[Runtime] No DOM event handlers for component '${component}'`);return}const func=handlerMap.get(handler);
if(!func){if(!dispatchRuntimeEvent&&!dispatchUserScriptEvent)console.warn(`[Runtime] No DOM handler '${handler}' for component '${component}'`);return}let ret=null;try{ret=func(data)}catch(err){console.error(`Exception in '${component}' handler '${handler}':`,err);if(responseId!==null)this._PostResultToDOM(responseId,false,""+err);return}if(responseId!==null)if(ret&&ret.then)ret.then(result=>this._PostResultToDOM(responseId,true,result)).catch(err=>{console.error(`Rejection from '${component}' handler '${handler}':`,
err);this._PostResultToDOM(responseId,false,""+err)});else this._PostResultToDOM(responseId,true,ret)}_PostResultToDOM(responseId,isOk,result){this._messagePort.postMessage({"type":"result","responseId":responseId,"isOk":isOk,"result":result})}_OnResultFromDOM(data){const responseId=data["responseId"];const isOk=data["isOk"];const result=data["result"];const pendingPromise=this._pendingResponsePromises.get(responseId);if(isOk)pendingPromise.resolve(result);else pendingPromise.reject(result);this._pendingResponsePromises.delete(responseId)}AddDOMComponentMessageHandler(component,
handler,func){let handlerMap=this._domEventHandlers.get(component);if(!handlerMap){handlerMap=new Map;this._domEventHandlers.set(component,handlerMap)}if(handlerMap.has(handler))throw new Error(`[Runtime] Component '${component}' already has handler '${handler}'`);handlerMap.set(handler,func)}PostComponentMessageToDOM(component,handler,data){this._messagePort.postMessage({"type":"event","component":component,"handler":handler,"data":data,"responseId":null})}PostComponentMessageToDOMAsync(component,
handler,data){const responseId=this._nextDomResponseId++;const ret=new Promise((resolve,reject)=>{this._pendingResponsePromises.set(responseId,{resolve,reject})});this._messagePort.postMessage({"type":"event","component":component,"handler":handler,"data":data,"responseId":responseId});return ret}PostToDebugger(data){if(!this.IsDebug())throw new Error("not in debug mode");this.PostComponentMessageToDOM("runtime","post-to-debugger",data)}async Init(opts){if(this.IsDebug())await C3Debugger.Init(this);
else if(self.C3Debugger)self.C3Debugger.InitPreview(this);const [o]=await Promise.all([this._assetManager.FetchJson("data.json"),this._MaybeLoadOpusDecoder(),this._jobScheduler.Init()]);this._LoadDataJson(o);await this._InitialiseCanvas(opts);if(!this.IsPreview())console.info("Made with Construct 3, the game and app creator :: https://www.construct.net");const webglRenderer=this.GetWebGLRenderer();console.info(`[C3 runtime] Hosted in ${this.IsInWorker()?"worker":"DOM"}, rendering with WebGL ${webglRenderer.GetWebGLVersionNumber()} [${webglRenderer.GetUnmaskedRenderer()}] (${webglRenderer.IsDesynchronized()?
"desynchronized":"standard"} compositing)`);if(webglRenderer.HasMajorPerformanceCaveat())console.warn("[C3 runtime] WebGL indicates a major performance caveat. Software rendering may be in use. This can result in significantly degraded performance.");this._isReadyToHandleEvents=true;for(const e of this._waitingToHandleEvents)this._OnEventFromDOM(e);C3.clearArray(this._waitingToHandleEvents);if(this._canvasManager)this._canvasManager.StartLoadingScreen();for(const f of opts["runOnStartupFunctions"])this._additionalLoadPromises.push(this._RunOnStartupFunction(f));
await Promise.all([this._assetManager.WaitForAllToLoad(),...this._additionalLoadPromises]);C3.clearArray(this._additionalLoadPromises);if(this._assetManager.HasHadErrorLoading()){if(this._canvasManager)this._canvasManager.HideCordovaSplashScreen();return}if(this._canvasManager)await this._canvasManager.EndLoadingScreen();await this._dispatcher.dispatchEventAndWaitAsync(new C3.Event("beforeruntimestart"));await this.Start();this._messagePort.postMessage({"type":"runtime-ready"});return this}async _RunOnStartupFunction(f){try{await f(this._iRuntime)}catch(err){console.error("[C3 runtime] Error in runOnStartup function: ",
err)}}_LoadDataJson(o){const projectData=o["project"];this._projectName=projectData[0];this._projectVersion=projectData[16];this._projectUniqueId=projectData[31];this._appId=projectData[38];const loadingLogoFilename=projectData[39]||"loading-logo.png";this._isPixelRoundingEnabled=!!projectData[9];this._originalViewportWidth=this._viewportWidth=projectData[10];this._originalViewportHeight=this._viewportHeight=projectData[11];this._parallaxXorigin=this._originalViewportWidth/2;this._parallaxYorigin=
this._originalViewportHeight/2;this._compositingMode=projectData[36];this._framerateMode=projectData[37];if(this._compositingMode==="low-latency"&&this.IsAndroidWebView()&&C3.Platform.BrowserVersionNumber<=77){console.warn("[C3 runtime] Desynchronized (low-latency) compositing is enabled, but is disabled in the Android WebView <=77 due to crbug.com/1008842. Reverting to synchronized (standard) compositing.");this._compositingMode="standard"}this._uses3dFeatures=!!projectData[40];this._sampling=projectData[14];
this._usesLoaderLayout=!!projectData[18];this._loaderStyle=projectData[19];this._nextUid=projectData[21];this._pauseOnBlur=projectData[22];const assetManager=this._assetManager;assetManager._SetAudioFiles(projectData[7],projectData[25]);assetManager._SetMediaSubfolder(projectData[8]);assetManager._SetFontsSubfolder(projectData[32]);assetManager._SetIconsSubfolder(projectData[28]);assetManager._SetWebFonts(projectData[29]);if(this._loaderStyle===0){let url="";if(this.IsPreview()){if(assetManager._HasLocalUrlBlob(loadingLogoFilename))url=
assetManager.GetLocalUrlAsBlobUrl(loadingLogoFilename)}else url=assetManager.GetIconsSubfolder()+loadingLogoFilename;if(url)this._loadingLogoAsset=assetManager.LoadImage({url})}if(this._canvasManager){this._canvasManager.SetFullscreenMode(C3.CanvasManager._FullscreenModeNumberToString(projectData[12]));this._canvasManager.SetFullscreenScalingQuality(projectData[23]?"high":"low");this._canvasManager.SetMipmapsEnabled(projectData[24]!==0);this._canvasManager._SetGPUPowerPreference(projectData[34]);
this._canvasManager._SetTextureAnisotropy(projectData[41])}this._pluginManager.CreateSystemPlugin();this._objectReferenceTable=self.C3_GetObjectRefTable();for(const pluginData of projectData[2])this._pluginManager.CreatePlugin(pluginData);this._objectReferenceTable=self.C3_GetObjectRefTable();this._LoadJsPropNameTable();for(const objectClassData of projectData[3]){const objectClass=C3.ObjectClass.Create(this,this._allObjectClasses.length,objectClassData);this._allObjectClasses.push(objectClass);this._objectClassesByName.set(objectClass.GetName().toLowerCase(),
objectClass);this._objectClassesBySid.set(objectClass.GetSID(),objectClass)}for(const familyData of projectData[4]){const familyType=this._allObjectClasses[familyData[0]];familyType._LoadFamily(familyData)}for(const containerData of projectData[27]){const containerTypes=containerData.map(index=>this._allObjectClasses[index]);this._allContainers.push(C3.New(C3.Container,this,containerTypes))}for(const objectClass of this._allObjectClasses)objectClass._OnAfterCreate();for(const layoutData of projectData[5])this._layoutManager.Create(layoutData);
const firstLayoutName=projectData[1];if(firstLayoutName){const firstLayout=this._layoutManager.GetLayoutByName(firstLayoutName);if(firstLayout)this._layoutManager.SetFirstLayout(firstLayout)}for(const timelineData of projectData[33])this._timelineManager.Create(timelineData);for(const transitionData of projectData[35])this._transitionManager.Create(transitionData);this._InitScriptInterfaces();for(const eventSheetData of projectData[6])this._eventSheetManager.Create(eventSheetData);this._eventSheetManager._PostInit();
this._InitGlobalVariableScriptInterface();C3.clearArray(this._objectReferenceTable);this.FlushPendingInstances();let targetOrientation="any";const orientations=projectData[20];if(orientations===1)targetOrientation="portrait";else if(orientations===2)targetOrientation="landscape";this.PostComponentMessageToDOM("runtime","set-target-orientation",{"targetOrientation":targetOrientation})}GetLoaderStyle(){return this._loaderStyle}IsFBInstantAvailable(){return this._isFBInstantAvailable}IsLoading(){return this._isLoading}AddLoadPromise(promise){this._additionalLoadPromises.push(promise)}SetUsingCreatePromises(e){this._isUsingCreatePromises=
!!e}AddCreatePromise(promise){if(!this._isUsingCreatePromises)return;this._additionalCreatePromises.push(promise)}GetCreatePromises(){return this._additionalCreatePromises}_GetNextFamilyIndex(){return this._familyCount++}GetFamilyCount(){return this._familyCount}_AddEffectList(el){this._allEffectLists.push(el)}_GetAllEffectLists(){return this._allEffectLists}async _InitialiseCanvas(opts){if(!this._canvasManager)return;await this._canvasManager.CreateCanvas(opts);this._canvasManager.InitLoadingScreen(this._loaderStyle)}async _MaybeLoadOpusDecoder(){if(this._assetManager.IsAudioFormatSupported("audio/webm; codecs=opus"))return;
let wasmBlob=null;let wasmBuffer=null;try{if(this.IsiOSCordova()&&location.protocol==="file:")wasmBuffer=await this._assetManager.CordovaFetchLocalFileAsArrayBuffer(this._opusWasmBinaryUrl);else wasmBuffer=await this._assetManager.FetchArrayBuffer(this._opusWasmBinaryUrl)}catch(err){console.info("Failed to fetch Opus decoder WASM; assuming project has no Opus audio.",err);return}if(wasmBuffer)this.AddJobWorkerBuffer(wasmBuffer,"opus-decoder-wasm");else this.AddJobWorkerBlob(wasmBlob,"opus-decoder-wasm");
await this.AddJobWorkerScripts([this._opusWasmScriptUrl])}async _WasmDecodeWebMOpus(arrayBuffer){const result=await this.AddJob("OpusDecode",{"arrayBuffer":arrayBuffer},[arrayBuffer]);return result}async Start(){this._hasStarted=true;this._startTime=Date.now();if(this._usesLoaderLayout){for(const objectClass of this._allObjectClasses)if(!objectClass.IsFamily()&&!objectClass.IsOnLoaderLayout()&&objectClass.IsWorldType())objectClass.OnCreate();this._assetManager.WaitForAllToLoad().then(()=>{this._isLoading=
false;this._OnLoadFinished()})}else this._isLoading=false;this._assetManager.SetInitialLoadFinished();if(this.IsDebug())C3Debugger.RuntimeInit(ife);for(const layout of this._layoutManager.GetAllLayouts())layout._CreateGlobalNonWorlds();const firstLayout=this._layoutManager.GetFirstLayout();await firstLayout._Load(null,this.GetWebGLRenderer());await firstLayout._StartRunning(true);this._fpsLastTime=performance.now();if(!this._usesLoaderLayout)this._OnLoadFinished();const state=await this.PostComponentMessageToDOMAsync("runtime",
"before-start-ticking");if(state["isSuspended"])this._suspendCount++;else this.Tick()}_OnLoadFinished(){this.Trigger(C3.Plugins.System.Cnds.OnLoadFinished,null,null);this.PostComponentMessageToDOM("runtime","register-sw")}GetObjectReference(index){index=Math.floor(index);const objRefTable=this._objectReferenceTable;if(index<0||index>=objRefTable.length)throw new Error("invalid object reference");return objRefTable[index]}_LoadJsPropNameTable(){for(const entry of self.C3_JsPropNameTable){const propName=
C3.first(Object.keys(entry));this._jsPropNameTable.push(propName)}}GetJsPropName(index){index=Math.floor(index);const jsPropNameTable=this._jsPropNameTable;if(index<0||index>=jsPropNameTable.length)throw new Error("invalid prop reference");return jsPropNameTable[index]}HasDOM(){return this._hasDom}IsHeadless(){return this._isHeadless}IsInWorker(){return this._isInWorker}GetBaseURL(){return this._baseUrl}GetEventSheetManager(){return this._eventSheetManager}GetEventStack(){return this._eventSheetManager.GetEventStack()}GetCurrentEventStackFrame(){return this._eventSheetManager.GetCurrentEventStackFrame()}GetCurrentEvent(){return this._eventSheetManager.GetCurrentEvent()}GetCurrentCondition(){return this._eventSheetManager.GetCurrentCondition()}IsCurrentConditionFirst(){return this.GetCurrentEventStackFrame().GetConditionIndex()===
0}GetCurrentAction(){return this._eventSheetManager.GetCurrentAction()}GetPluginManager(){return this._pluginManager}GetSystemPlugin(){return this._pluginManager.GetSystemPlugin()}GetObjectClassByIndex(i){i=Math.floor(i);if(i<0||i>=this._allObjectClasses.length)throw new RangeError("invalid index");return this._allObjectClasses[i]}GetObjectClassByName(name){return this._objectClassesByName.get(name.toLowerCase())||null}GetObjectClassBySID(sid){return this._objectClassesBySid.get(sid)||null}GetSingleGlobalObjectClassByCtor(ctor){const plugin=
this._pluginManager.GetPluginByConstructorFunction(ctor);if(!plugin)return null;return plugin.GetSingleGlobalObjectClass()}GetAllObjectClasses(){return this._allObjectClasses}*allInstances(){for(const objectClass of this._allObjectClasses){if(objectClass.IsFamily())continue;yield*objectClass.instances()}}Dispatcher(){return this._dispatcher}UserScriptDispatcher(){return this._userScriptDispatcher}DispatchUserScriptEvent(e){e.runtime=this.GetIRuntime();const shouldTime=this.IsDebug()&&!this._eventSheetManager.IsInEventEngine();
if(shouldTime)C3Debugger.StartMeasuringScriptTime();this._userScriptDispatcher.dispatchEvent(e);if(shouldTime)C3Debugger.AddScriptTime()}DispatchUserScriptEventAsyncWait(e){e.runtime=this.GetIRuntime();return this._userScriptDispatcher.dispatchEventAndWaitAsync(e)}GetOriginalViewportWidth(){return this._originalViewportWidth}GetOriginalViewportHeight(){return this._originalViewportHeight}SetOriginalViewportSize(w,h){this._originalViewportWidth=w;this._originalViewportHeight=h}GetViewportWidth(){return this._viewportWidth}GetViewportHeight(){return this._viewportHeight}SetViewportSize(w,
h){this._viewportWidth=w;this._viewportHeight=h}_SetDevicePixelRatio(r){this._devicePixelRatio=r}GetDevicePixelRatio(){return this._devicePixelRatio}GetParallaxXOrigin(){return this._parallaxXorigin}GetParallaxYOrigin(){return this._parallaxYorigin}GetCanvasManager(){return this._canvasManager}GetDrawWidth(){if(!this._canvasManager)return this._viewportWidth;return this._canvasManager.GetDrawWidth()}GetDrawHeight(){if(!this._canvasManager)return this._viewportHeight;return this._canvasManager.GetDrawHeight()}GetRenderScale(){if(!this._canvasManager)return 1;
return this._canvasManager.GetRenderScale()}GetDisplayScale(){if(!this._canvasManager)return 1;return this._canvasManager.GetDisplayScale()}GetCanvasClientX(){if(!this._canvasManager)return 0;return this._canvasManager.GetCanvasClientX()}GetCanvasClientY(){if(!this._canvasManager)return 0;return this._canvasManager.GetCanvasClientY()}GetCanvasCssWidth(){if(!this._canvasManager)return 0;return this._canvasManager.GetCssWidth()}GetCanvasCssHeight(){if(!this._canvasManager)return 0;return this._canvasManager.GetCssHeight()}GetFullscreenMode(){if(!this._canvasManager)return"off";
return this._canvasManager.GetFullscreenMode()}GetAdditionalRenderTarget(opts){if(!this._canvasManager)return null;return this._canvasManager.GetAdditionalRenderTarget(opts)}ReleaseAdditionalRenderTarget(renderTarget){if(!this._canvasManager)return;this._canvasManager.ReleaseAdditionalRenderTarget(renderTarget)}_SetUsesAnyBackgroundBlending(u){this._usesAnyBackgroundBlending=!!u}UsesAnyBackgroundBlending(){return this._usesAnyBackgroundBlending}GetGPUUtilisation(){if(!this._canvasManager)return NaN;
return this._canvasManager.GetGPUUtilisation()}IsLinearSampling(){return this.GetSampling()!=="nearest"}GetFramerateMode(){return this._framerateMode}GetCompositingMode(){return this._compositingMode}GetSampling(){return this._sampling}UsesLoaderLayout(){return this._usesLoaderLayout}GetLoadingLogoAsset(){return this._loadingLogoAsset}ReleaseLoadingLogoAsset(){if(this._loadingLogoAsset){this._loadingLogoAsset.Release();this._loadingLogoAsset=null}}GetLayoutManager(){return this._layoutManager}GetMainRunningLayout(){return this._layoutManager.GetMainRunningLayout()}GetTimelineManager(){return this._timelineManager}GetTransitionManager(){return this._transitionManager}GetAssetManager(){return this._assetManager}LoadImage(opts){return this._assetManager.LoadImage(opts)}CreateInstance(objectClass,
layer,x,y,createHierarchy){return this.CreateInstanceFromData(objectClass,layer,false,x,y,false,createHierarchy)}CreateInstanceFromData(instData_or_objectClass,layer,isStartupInstance,x,y,skipSiblings,createHierarchy){let instData=null;let objectClass=null;if(instData_or_objectClass instanceof C3.ObjectClass){objectClass=instData_or_objectClass;if(objectClass.IsFamily()){const members=objectClass.GetFamilyMembers();const i=Math.floor(this.Random()*members.length);objectClass=members[i]}instData=objectClass.GetDefaultInstanceData()}else{instData=
instData_or_objectClass;objectClass=this.GetObjectClassByIndex(instData[1])}const isWorld=objectClass.GetPlugin().IsWorldType();if(this._isLoading&&isWorld&&!objectClass.IsOnLoaderLayout())return null;const originalLayer=layer;if(!isWorld)layer=null;let uid;if(isStartupInstance&&!skipSiblings&&instData&&!this._instancesByUid.has(instData[2]))uid=instData[2];else uid=this._nextUid++;const worldData=instData?instData[0]:null;const inst=C3.New(C3.Instance,{runtime:this,objectType:objectClass,layer:layer,
worldData,instVarData:instData?instData[3]:null,uid:uid});this._instancesByUid.set(uid,inst);let wi=null;if(isWorld){wi=inst.GetWorldInfo();if(typeof x!=="undefined"&&typeof y!=="undefined"){wi.SetX(x);wi.SetY(y)}objectClass._SetAnyCollisionCellChanged(true)}if(layer){if(!createHierarchy)layer._AddInstance(inst,true);if(layer.GetParallaxX()!==1||layer.GetParallaxY()!==1)objectClass._SetAnyInstanceParallaxed(true);layer.GetLayout().MaybeLoadTexturesFor(objectClass)}this._objectCount++;if(objectClass.IsInContainer()&&
!isStartupInstance&&!skipSiblings){for(const containerType of objectClass.GetContainer().objectTypes()){if(containerType===objectClass)continue;const siblingInst=this.CreateInstanceFromData(containerType,originalLayer,false,wi?wi.GetX():x,wi?wi.GetY():y,true,false);inst._AddSibling(siblingInst)}for(const s of inst.siblings()){s._AddSibling(inst);for(const s2 of inst.siblings())if(s!==s2)s._AddSibling(s2)}}if(isWorld&&!isStartupInstance&&!!createHierarchy)this._CreateChildInstancesFromData(inst,worldData,
wi,layer,x,y);if(objectClass.IsInContainer()&&!isStartupInstance&&!skipSiblings&&!!createHierarchy)for(const sibling of inst.siblings()){const swi=sibling.GetWorldInfo();const sWorldData=sibling.GetObjectClass().GetDefaultInstanceData()[0];this._CreateChildInstancesFromData(sibling,sWorldData,swi,layer,swi.GetX(),swi.GetY())}if(!skipSiblings&&!!createHierarchy){if(typeof x==="undefined")x=worldData[0];if(typeof y==="undefined")y=worldData[1];const pwi=wi.GetTopParent();const newX=x-wi.GetX()+pwi.GetX();
const newY=y-wi.GetY()+pwi.GetY();pwi.SetXY(newX,newY)}objectClass._SetIIDsStale();const instPropertyData=instData?C3.cloneArray(instData[5]):null;const behPropertyData=instData?instData[4].map(bp=>C3.cloneArray(bp)):null;const hasTilemap=isWorld&&worldData&&worldData[13];if(hasTilemap)inst._SetHasTilemap();inst._CreateSdkInstance(instPropertyData,behPropertyData);if(hasTilemap){const tilemapData=worldData[13];inst.GetSdkInstance().LoadTilemapData(tilemapData[2],tilemapData[0],tilemapData[1])}this._instancesPendingCreate.push(inst);
this._hasPendingInstances=true;if(this.IsDebug())C3Debugger.InstanceCreated(inst);return inst}_CreateChildInstancesFromData(parentInstance,parentWorldData,parentWorldInfo,layer,x,y){const parentZIndex=parentWorldInfo.GetSceneGraphZIndexExportData();const childrenData=parentWorldInfo.GetSceneGraphChildrenExportData();parentInstance.GetWorldInfo().SetSceneGraphZIndex(parentZIndex);if(!childrenData)return;if(typeof x==="undefined")x=parentWorldData[0];if(typeof y==="undefined")y=parentWorldData[1];const sceneGraphSiblings=
new Set;const parentX=parentWorldData[0];const parentY=parentWorldData[1];for(const childData of childrenData){const childLayoutSID=childData[0];const childLayerIndex=childData[1];const childUID=childData[2];const childFlags=childData[3];const childIsInContainer=!!childData[4];const childZIndex=childData[5];const layout=this._layoutManager.GetLayoutBySID(childLayoutSID);const l=layout.GetLayer(childLayerIndex);const childInstData=l.GetInitialInstanceData(childUID);const childObjectClass=this.GetObjectClassByIndex(childInstData[1]);
const hasSibling=parentInstance.HasSibling(childObjectClass);const siblingProcessed=sceneGraphSiblings.has(childObjectClass);if(hasSibling&&!siblingProcessed&&childIsInContainer){const childInst=parentInstance.GetSibling(childObjectClass);const childX=x+childInstData[0][0]-parentX;const childY=y+childInstData[0][1]-parentY;childInst.GetWorldInfo().SetXY(childX,childY);childInst.GetWorldInfo().SetSceneGraphZIndex(childZIndex);parentInstance.AddChild(childInst,{transformX:!!(childFlags>>0&1),transformY:!!(childFlags>>
1&1),transformWidth:!!(childFlags>>2&1),transformHeight:!!(childFlags>>3&1),transformAngle:!!(childFlags>>4&1),destroyWithParent:!!(childFlags>>5&1),transformZElevation:!!(childFlags>>6&1)});sceneGraphSiblings.add(childObjectClass)}else{const childX=x+childInstData[0][0]-parentX;const childY=y+childInstData[0][1]-parentY;const childInst=this.CreateInstanceFromData(childInstData,layer,false,childX,childY,false,true);childInst.GetWorldInfo().SetSceneGraphZIndex(childZIndex);parentInstance.AddChild(childInst,
{transformX:!!(childFlags>>0&1),transformY:!!(childFlags>>1&1),transformWidth:!!(childFlags>>2&1),transformHeight:!!(childFlags>>3&1),transformAngle:!!(childFlags>>4&1),destroyWithParent:!!(childFlags>>5&1),transformZElevation:!!(childFlags>>6&1)})}}}DestroyInstance(inst){if(this._instancesToReleaseAtEndOfTick.has(inst))return;const objectClass=inst.GetObjectClass();let s=this._instancesPendingDestroy.get(objectClass);if(s){if(s.has(inst))return;s.add(inst)}else{s=new Set;s.add(inst);this._instancesPendingDestroy.set(objectClass,
s)}if(this.IsDebug())C3Debugger.InstanceDestroyed(inst);inst._MarkDestroyed();this._hasPendingInstances=true;if(inst.IsInContainer())for(const s of inst.siblings())this.DestroyInstance(s);for(const c of inst.children())if(c.GetDestroyWithParent())this.DestroyInstance(c);if(!this._layoutManager.IsEndingLayout()&&!this._isLoadingState){const eventSheetManager=this.GetEventSheetManager();eventSheetManager.BlockFlushingInstances(true);inst._TriggerOnDestroyed();eventSheetManager.BlockFlushingInstances(false)}inst._FireDestroyedScriptEvents(this._layoutManager.IsEndingLayout())}FlushPendingInstances(){if(!this._hasPendingInstances)return;
this._isFlushingPendingInstances=true;this._FlushInstancesPendingCreate();this._FlushInstancesPendingDestroy();this._isFlushingPendingInstances=false;this._hasPendingInstances=false;this.UpdateRender()}_FlushInstancesPendingCreate(){for(const inst of this._instancesPendingCreate){const objectType=inst.GetObjectClass();objectType._AddInstance(inst);for(const family of objectType.GetFamilies()){family._AddInstance(inst);family._SetIIDsStale()}}C3.clearArray(this._instancesPendingCreate)}_FlushInstancesPendingDestroy(){this._dispatcher.SetDelayRemoveEventsEnabled(true);
for(const [objectClass,s]of this._instancesPendingDestroy.entries()){this._FlushInstancesPendingDestroyForObjectClass(objectClass,s);s.clear()}this._instancesPendingDestroy.clear();this._dispatcher.SetDelayRemoveEventsEnabled(false)}_FlushInstancesPendingDestroyForObjectClass(objectClass,s){for(const inst of s){const instanceDestroyEvent=this._eventObjects["instancedestroy"];instanceDestroyEvent.instance=inst;this._dispatcher.dispatchEvent(instanceDestroyEvent);this._instancesByUid.delete(inst.GetUID());
const wi=inst.GetWorldInfo();if(wi){wi._RemoveFromCollisionCells();wi._RemoveFromRenderCells();wi._MarkDestroyed()}this._instancesToReleaseAtEndOfTick.add(inst);this._objectCount--}C3.arrayRemoveAllInSet(objectClass.GetInstances(),s);objectClass._SetIIDsStale();this._instancesToReleaseAffectedObjectClasses.add(objectClass);if(objectClass.GetInstances().length===0)objectClass._SetAnyInstanceParallaxed(false);for(const family of objectClass.GetFamilies()){C3.arrayRemoveAllInSet(family.GetInstances(),
s);family._SetIIDsStale();this._instancesToReleaseAffectedObjectClasses.add(family)}if(objectClass.GetPlugin().IsWorldType()){const layers=new Set([...s].map(i=>i.GetWorldInfo().GetLayer()));for(const layer of layers)layer._RemoveAllInstancesInSet(s)}}_GetInstancesPendingCreate(){return this._instancesPendingCreate}_GetNewUID(){return this._nextUid++}_MapInstanceByUID(uid,inst){this._instancesByUid.set(uid,inst)}_OnWebGLContextLost(){this._dispatcher.dispatchEvent(C3.New(C3.Event,"webglcontextlost"));
this.SetSuspended(true);for(const objectClass of this._allObjectClasses)if(!objectClass.IsFamily()&&objectClass.HasLoadedTextures())objectClass.ReleaseTextures();const runningLayout=this.GetMainRunningLayout();if(runningLayout)runningLayout._OnWebGLContextLost();C3.ImageInfo.OnWebGLContextLost();C3.ImageAsset.OnWebGLContextLost()}async _OnWebGLContextRestored(){await this.GetMainRunningLayout()._Load(null,this.GetWebGLRenderer());this._dispatcher.dispatchEvent(C3.New(C3.Event,"webglcontextrestored"));
this.SetSuspended(false);this.UpdateRender()}_OnVisibilityChange(e){this.SetSuspended(e["hidden"])}_OnWindowBlur(e){if(!this.IsPreview()||!this._pauseOnBlur||C3.Platform.IsMobile)return;if(!e.data["parentHasFocus"]){this.SetSuspended(true);this._isPausedOnBlur=true}}_OnWindowFocus(){if(!this._isPausedOnBlur)return;this.SetSuspended(false);this._isPausedOnBlur=false}_RequestAnimationFrame(){const tickCallbacks=this._tickCallbacks;if(this._framerateMode==="vsync"){if(this._rafId===-1)this._rafId=self.requestAnimationFrame(tickCallbacks.normal)}else if(this._framerateMode===
"unlimited-tick"){if(this._ruafId===-1)this._ruafId=C3.RequestUnlimitedAnimationFrame(tickCallbacks.tickOnly);if(this._rafId===-1)this._rafId=self.requestAnimationFrame(tickCallbacks.renderOnly)}else if(this._ruafId===-1)this._ruafId=C3.RequestUnlimitedAnimationFrame(tickCallbacks.normal)}_CancelAnimationFrame(){if(this._rafId!==-1){self.cancelAnimationFrame(this._rafId);this._rafId=-1}if(this._ruafId!==-1){C3.CancelUnlimitedAnimationFrame(this._ruafId);this._ruafId=-1}}IsSuspended(){return this._suspendCount>
0}SetSuspended(s){const wasSuspended=this.IsSuspended();this._suspendCount+=s?1:-1;if(this._suspendCount<0)this._suspendCount=0;const isSuspended=this.IsSuspended();if(!wasSuspended&&isSuspended){console.log("[Construct 3] Suspending");this._CancelAnimationFrame();this._dispatcher.dispatchEvent(C3.New(C3.Event,"suspend"));this.Trigger(C3.Plugins.System.Cnds.OnSuspend,null,null)}else if(wasSuspended&&!isSuspended){console.log("[Construct 3] Resuming");const now=performance.now();this._lastTickTime=
now;this._fpsLastTime=now;this._fpsFrameCount=0;this._fps=0;this._mainThreadTime=0;this._mainThreadTimeCounter=0;this._dispatcher.dispatchEvent(C3.New(C3.Event,"resume"));this.Trigger(C3.Plugins.System.Cnds.OnResume,null,null);if(!this.HitBreakpoint())this.Tick(now)}}_AddBehInstToTick(behSdkInst){this._behInstsToTick.Add(behSdkInst)}_AddBehInstToPostTick(behSdkInst){this._behInstsToPostTick.Add(behSdkInst)}_AddBehInstToTick2(behSdkInst){this._behInstsToTick2.Add(behSdkInst)}_RemoveBehInstToTick(behSdkInst){this._behInstsToTick.Remove(behSdkInst)}_RemoveBehInstToPostTick(behSdkInst){this._behInstsToPostTick.Remove(behSdkInst)}_RemoveBehInstToTick2(behSdkInst){this._behInstsToTick2.Remove(behSdkInst)}_BehaviorTick(){this._behInstsToTick.SetQueueingEnabled(true);
for(const bi of this._behInstsToTick)bi.Tick();this._behInstsToTick.SetQueueingEnabled(false)}_BehaviorPostTick(){this._behInstsToPostTick.SetQueueingEnabled(true);for(const bi of this._behInstsToPostTick)bi.PostTick();this._behInstsToPostTick.SetQueueingEnabled(false)}_BehaviorTick2(){this._behInstsToTick2.SetQueueingEnabled(true);for(const bi of this._behInstsToTick2)bi.Tick2();this._behInstsToTick2.SetQueueingEnabled(false)}*_DebugBehaviorTick(){this._behInstsToTick.SetQueueingEnabled(true);for(const bi of this._behInstsToTick){const ret=
bi.Tick();if(C3.IsIterator(ret))yield*ret}this._behInstsToTick.SetQueueingEnabled(false)}*_DebugBehaviorPostTick(){this._behInstsToPostTick.SetQueueingEnabled(true);for(const bi of this._behInstsToPostTick){const ret=bi.PostTick();if(C3.IsIterator(ret))yield*ret}this._behInstsToPostTick.SetQueueingEnabled(false)}*_DebugBehaviorTick2(){this._behInstsToTick2.SetQueueingEnabled(true);for(const bi of this._behInstsToTick2){const ret=bi.Tick2();if(C3.IsIterator(ret))yield*ret}this._behInstsToTick2.SetQueueingEnabled(false)}async Tick(timestamp,
isDebugStep,mode){this._hasStartedTicking=true;const isBackgroundWake=mode==="background-wake";const shouldRender=mode!=="background-wake"&&mode!=="skip-render";if(!this._hasStarted||this.IsSuspended()&&!isDebugStep&&!isBackgroundWake)return;const startTime=performance.now();this._isInTick=true;if(!timestamp)timestamp=startTime;this._MeasureDt(timestamp);const beforePreTickRet=this.Step_BeforePreTick();if(this.IsDebugging())await beforePreTickRet;const pretickRet=this._dispatcher.dispatchEventAndWait_AsyncOptional(this._eventObjects["pretick"]);
if(pretickRet instanceof Promise)await pretickRet;const afterPreTickRet=this.Step_AfterPreTick();if(this.IsDebugging())await afterPreTickRet;if(this._NeedsHandleSaveOrLoad())await this._HandleSaveOrLoad();if(this.GetLayoutManager().IsPendingChangeMainLayout())await this._MaybeChangeLayout();const runEventsRet=this.Step_RunEventsEtc();if(this.IsDebugging())await runEventsRet;if(shouldRender)this.Render();if(!this.IsSuspended()&&!isBackgroundWake)this._RequestAnimationFrame();this._tickCount++;this._tickCountNoSave++;
this._execCount++;this._isInTick=false;this._mainThreadTimeCounter+=performance.now()-startTime}async Step_BeforePreTick(){const eventSheetManager=this._eventSheetManager;const isDebug=this.IsDebug();this.FlushPendingInstances();eventSheetManager.BlockFlushingInstances(true);this.PushCurrentLayout(this.GetMainRunningLayout());if(isDebug)C3Debugger.StartMeasuringTime();if(this.IsDebugging())await eventSheetManager.DebugRunScheduledWaits();else eventSheetManager.RunScheduledWaits();if(isDebug)C3Debugger.AddEventsTime();
this.PopCurrentLayout();eventSheetManager.BlockFlushingInstances(false);this.FlushPendingInstances();eventSheetManager.BlockFlushingInstances(true)}async Step_AfterPreTick(){const isDebug=this.IsDebug();const isDebugging=this.IsDebugging();const dispatcher=this._dispatcher;const eventObjects=this._eventObjects;const userScriptEventObjects=this._userScriptEventObjects;if(isDebug)C3Debugger.StartMeasuringTime();if(isDebugging)await this.DebugIterateAndBreak(this._DebugBehaviorTick());else this._BehaviorTick();
if(isDebugging)await this.DebugIterateAndBreak(this._DebugBehaviorPostTick());else this._BehaviorPostTick();if(isDebug)C3Debugger.AddBehaviorTickTime();if(isDebug)C3Debugger.StartMeasuringTime();if(isDebugging)await this.DebugFireGeneratorEventAndBreak(eventObjects["tick"]);else dispatcher.dispatchEvent(eventObjects["tick"]);if(isDebug)C3Debugger.AddPluginTickTime();this._eventSheetManager.BlockFlushingInstances(false);this.DispatchUserScriptEvent(userScriptEventObjects["tick"])}async Step_RunEventsEtc(){const eventSheetManager=
this._eventSheetManager;const dispatcher=this._dispatcher;const eventObjects=this._eventObjects;const isDebug=this.IsDebug();const isDebugging=this.IsDebugging();if(isDebug)C3Debugger.StartMeasuringTime();if(isDebugging)await eventSheetManager.DebugRunEvents(this._layoutManager);else eventSheetManager.RunEvents(this._layoutManager);if(isDebug)C3Debugger.AddEventsTime();this._collisionEngine.ClearRegisteredCollisions();this._ReleaseInstancesAtEndOfTick();this._isLayoutFirstTick=false;eventSheetManager.BlockFlushingInstances(true);
if(isDebug)C3Debugger.StartMeasuringTime();if(isDebugging)await this.DebugIterateAndBreak(this._DebugBehaviorTick2());else this._BehaviorTick2();if(isDebug)C3Debugger.AddBehaviorTickTime();if(isDebug)C3Debugger.StartMeasuringTime();if(isDebugging)await this.DebugFireGeneratorEventAndBreak(eventObjects["tick2"]);else dispatcher.dispatchEvent(eventObjects["tick2"]);if(isDebug)C3Debugger.AddPluginTickTime();eventSheetManager.BlockFlushingInstances(false);if(isDebugging)await eventSheetManager.RunQueuedDebugTriggersAsync()}_ReleaseInstancesAtEndOfTick(){if(this._instancesToReleaseAtEndOfTick.size===
0)return;const dispatcher=this._dispatcher;dispatcher.SetDelayRemoveEventsEnabled(true);for(const objectClass of this._instancesToReleaseAffectedObjectClasses)objectClass.GetSolStack().RemoveInstances(this._instancesToReleaseAtEndOfTick);this._instancesToReleaseAffectedObjectClasses.clear();this._eventSheetManager.RemoveInstancesFromScheduledWaits(this._instancesToReleaseAtEndOfTick);for(const inst of this._instancesToReleaseAtEndOfTick)inst.Release();this._instancesToReleaseAtEndOfTick.clear();dispatcher.SetDelayRemoveEventsEnabled(false)}async _MaybeChangeLayout(){const layoutManager=
this.GetLayoutManager();let i=0;while(layoutManager.IsPendingChangeMainLayout()&&i++<10)await this._DoChangeLayout(layoutManager.GetPendingChangeMainLayout())}_MeasureDt(timestamp){if(this._lastTickTime!==0){const msDiff=Math.max(timestamp-this._lastTickTime,0);this._dt1=msDiff/1E3;const maxDt1=1/this._minimumFramerate;if(this._dt1>.5)this._dt1=0;else if(this._dt1>maxDt1)this._dt1=maxDt1}this._lastTickTime=timestamp;this._dt=this._dt1*this._timeScale;this._gameTime.Add(this._dt);this._wallTime.Add(this._dt1);
if(this._canvasManager)this._canvasManager._UpdateTick();if(timestamp-this._fpsLastTime>=1E3){this._fpsLastTime+=1E3;if(timestamp-this._fpsLastTime>=1E3)this._fpsLastTime=timestamp;this._fps=this._fpsFrameCount;this._fpsFrameCount=0;this._mainThreadTime=Math.min(this._mainThreadTimeCounter/1E3,1);this._mainThreadTimeCounter=0;if(this._canvasManager)this._canvasManager._Update1sFrameRange();this._collisionEngine._Update1sStats();if(this.IsDebug())C3Debugger.Update1sPerfStats()}this._fpsFrameCount++}async _DoChangeLayout(changeToLayout){const dispatcher=
this._dispatcher;const layoutManager=this.GetLayoutManager();const prevLayout=layoutManager.GetMainRunningLayout();await prevLayout._StopRunning();prevLayout._Unload(changeToLayout,this.GetWebGLRenderer());if(prevLayout===changeToLayout)this._eventSheetManager.ClearAllScheduledWaits();this._collisionEngine.ClearRegisteredCollisions();this._ReleaseInstancesAtEndOfTick();dispatcher.dispatchEvent(this._eventObjects["beforelayoutchange"]);C3.Asyncify.SetHighThroughputMode(true);await changeToLayout._Load(prevLayout,
this.GetWebGLRenderer());C3.Asyncify.SetHighThroughputMode(false);await changeToLayout._StartRunning(false);dispatcher.dispatchEvent(this._eventObjects["layoutchange"]);this.UpdateRender();this._isLayoutFirstTick=true;this.FlushPendingInstances()}UpdateRender(){this._needRender=true}GetWebGLRenderer(){if(!this._canvasManager)return null;return this._canvasManager.GetWebGLRenderer()}GetRenderer(){return this.GetWebGLRenderer()}Render(){const canvasManager=this._canvasManager;if(!canvasManager||canvasManager.IsWebGLContextLost())return;
const renderer=this.GetWebGLRenderer();renderer.Start();renderer.CheckForQueryResults();if(!this._needRender){renderer.IncrementFrameNumber();return}const isDebug=this.IsDebug();if(isDebug)C3Debugger.StartMeasuringTime();this._needRender=false;let frameQuery=null;if(renderer.SupportsGPUProfiling()){frameQuery=this._canvasManager.GetGPUFrameTimingsBuffer().AddTimeElapsedQuery();renderer.StartQuery(frameQuery)}if(this.Uses3DFeatures()&&canvasManager.GetCurrentFullscreenScalingQuality()==="low")renderer.SetFixedSizeDepthBuffer(canvasManager.GetDrawWidth(),
canvasManager.GetDrawHeight());else renderer.SetAutoSizeDepthBuffer();renderer.SetTextureFillMode();renderer.SetAlphaBlend();renderer.SetColorRgba(1,1,1,1);renderer.SetRenderTarget(null);renderer.SetTexture(null);renderer.SetDepthEnabled(this.Uses3DFeatures());const layout=this._layoutManager.GetMainRunningLayout();layout.Draw(renderer);if(frameQuery)renderer.EndQuery(frameQuery);renderer.Finish();if(isDebug){C3Debugger.AddDrawCallsTime();C3Debugger.UpdateInspectHighlight()}if(canvasManager)canvasManager._MaybeTakeSnapshot()}Trigger(method,
inst,behaviorType){if(!this._hasStarted)return false;const isTopLevel=!this._isInTick&&!this._eventSheetManager.IsInTrigger();let startTime=0;if(isTopLevel)startTime=performance.now();const isDebug=this.IsDebug();if(isDebug)this.SetDebuggingEnabled(false);const ret=this._eventSheetManager._Trigger(this._layoutManager,method,inst,behaviorType);if(isTopLevel){const triggerTime=performance.now()-startTime;this._mainThreadTimeCounter+=triggerTime;if(isDebug)C3Debugger.AddTriggersTime(triggerTime)}if(isDebug)this.SetDebuggingEnabled(true);
return ret}DebugTrigger(method,inst,behaviorType){if(!this.IsDebug())return this.Trigger(method,inst,behaviorType);if(this.HitBreakpoint())throw new Error("called DebugTrigger() while stopped on breakpoint");if(!this._isInTick&&!this._eventSheetManager.IsInTrigger())throw new Error("called DebugTrigger() outside of event code - use TriggerAsync() instead");return this._eventSheetManager._DebugTrigger(this._layoutManager,method,inst,behaviorType)}async TriggerAsync(method,inst,behaviorType){if(!this.IsDebugging())return this.Trigger(method,
inst,behaviorType);if(!this._hasStarted)return false;if(this.HitBreakpoint())return this._eventSheetManager.QueueDebugTrigger(method,inst,behaviorType);if(!this.GetMainRunningLayout())return this._eventSheetManager.QueueTrigger(method,inst,behaviorType);const startTime=performance.now();const iter=this._eventSheetManager._DebugTrigger(this._layoutManager,method,inst,behaviorType);let result=iter.next();while(!result.done){await this.DebugBreak(result.value);result=iter.next()}if(!this.IsSuspended()&&
!this._eventSheetManager.IsInTrigger()){await this._eventSheetManager.RunQueuedDebugTriggersAsync();if(this._hasStartedTicking&&!this._isInTick)this._RequestAnimationFrame()}this._mainThreadTimeCounter+=performance.now()-startTime;return result.value}FastTrigger(method,inst,value){const isDebug=this.IsDebug();if(isDebug)this.SetDebuggingEnabled(false);const ret=this._eventSheetManager._FastTrigger(this._layoutManager,method,inst,value);if(isDebug)this.SetDebuggingEnabled(true);return ret}DebugFastTrigger(method,
inst,value){return this._eventSheetManager._DebugFastTrigger(this._layoutManager,method,inst,value)}ScheduleTriggers(f){return this._scheduleTriggersThrottle.Add(f)}PushCurrentLayout(layout){this._currentLayoutStack.push(layout)}PopCurrentLayout(){if(!this._currentLayoutStack.length)throw new Error("layout stack empty");this._currentLayoutStack.pop()}GetCurrentLayout(){if(!this._currentLayoutStack.length)return this.GetMainRunningLayout();return this._currentLayoutStack[this._currentLayoutStack.length-
1]}GetDt(inst){if(!inst||inst.GetTimeScale()===-1)return this._dt;return this._dt1*inst.GetTimeScale()}_GetDtFast(){return this._dt}GetDt1(){return this._dt1}GetTimeScale(){return this._timeScale}SetTimeScale(ts){if(isNaN(ts)||ts<0)ts=0;this._timeScale=ts}SetMinimumFramerate(fps){this._minimumFramerate=C3.clamp(fps,1,120)}GetMinimumFramerate(){return this._minimumFramerate}GetFPS(){return this._fps}GetMainThreadTime(){return this._mainThreadTime}GetStartTime(){return this._startTime}GetGameTime(){return this._gameTime.Get()}GetWallTime(){return this._wallTime.Get()}GetTickCount(){return this._tickCount}GetTickCountNoSave(){return this._tickCountNoSave}IncrementExecCount(){++this._execCount}GetExecCount(){return this._execCount}GetObjectCount(){return this._objectCount}GetProjectName(){return this._projectName}GetProjectVersion(){return this._projectVersion}GetProjectUniqueId(){return this._projectUniqueId}GetAppId(){return this._appId}GetInstanceByUID(uid){if(this._isLoadingState)throw new Error("cannot call while loading state - wait until afterload event");
return this._instancesByUid.get(uid)||null}_RefreshUidMap(){this._instancesByUid.clear();for(const objectClass of this._allObjectClasses){if(objectClass.IsFamily())continue;for(const inst of objectClass.GetInstances())this._instancesByUid.set(inst.GetUID(),inst)}}IsPreview(){return this._exportType==="preview"}IsDebug(){return this._isDebug}GetExportType(){return this._exportType}IsCordova(){return this._exportType==="cordova"}IsAndroidWebView(){return C3.Platform.OS==="Android"&&(this._exportType===
"cordova"||this._exportType==="playable-ad"||this._exportType==="instant-games")}IsiOSCordova(){return this._isiOSCordova}IsiOSWebView(){return this._isiOSWebView}GetCollisionEngine(){return this._collisionEngine}GetSolidBehavior(){return this._pluginManager.GetSolidBehavior()}GetJumpthruBehavior(){return this._pluginManager.GetJumpthruBehavior()}Uses3DFeatures(){return this._uses3dFeatures}IsLayoutFirstTick(){return this._isLayoutFirstTick}SetPixelRoundingEnabled(e){e=!!e;if(this._isPixelRoundingEnabled===
e)return;this._isPixelRoundingEnabled=e;this.UpdateRender()}IsPixelRoundingEnabled(){return this._isPixelRoundingEnabled}SaveToSlot(slotName){this._saveToSlotName=slotName}LoadFromSlot(slotName){this._loadFromSlotName=slotName}LoadFromJsonString(str){this._loadFromJson=str}GetLastSaveJsonString(){return this._lastSaveJson}_NeedsHandleSaveOrLoad(){return!!(this._saveToSlotName||this._loadFromSlotName||this._loadFromJson!==null)}async _HandleSaveOrLoad(){if(this._saveToSlotName){this.FlushPendingInstances();
await this._DoSaveToSlot(this._saveToSlotName);this._ClearSaveOrLoad()}if(this._loadFromSlotName){await this._DoLoadFromSlot(this._loadFromSlotName);this._ClearSaveOrLoad();if(this.IsDebug())C3Debugger.StepIfPausedInDebugger()}if(this._loadFromJson!==null){this.FlushPendingInstances();try{await this._DoLoadFromJsonString(this._loadFromJson);this._lastSaveJson=this._loadFromJson;await this.TriggerAsync(C3.Plugins.System.Cnds.OnLoadComplete,null);this._lastSaveJson=""}catch(err){console.error("[Construct 3] Failed to load state from JSON string: ",
err);await this.TriggerAsync(C3.Plugins.System.Cnds.OnLoadFailed,null)}this._ClearSaveOrLoad()}}_ClearSaveOrLoad(){this._saveToSlotName="";this._loadFromSlotName="";this._loadFromJson=null}_GetProjectStorage(){if(!this._projectStorage)this._projectStorage=localforage.createInstance({name:"c3-localstorage-"+this.GetProjectUniqueId(),description:this.GetProjectName()});return this._projectStorage}_GetSavegamesStorage(){if(!this._savegamesStorage)this._savegamesStorage=localforage.createInstance({name:"c3-savegames-"+
this.GetProjectUniqueId(),description:this.GetProjectName()});return this._savegamesStorage}async _DoSaveToSlot(slotName){const saveJson=await this._SaveToJsonString();try{await this._GetSavegamesStorage().setItem(slotName,saveJson);console.log("[Construct 3] Saved state to storage ("+saveJson.length+" chars)");this._lastSaveJson=saveJson;await this.TriggerAsync(C3.Plugins.System.Cnds.OnSaveComplete,null);this._lastSaveJson=""}catch(err){console.error("[Construct 3] Failed to save state to storage: ",
err);await this.TriggerAsync(C3.Plugins.System.Cnds.OnSaveFailed,null)}}async _DoLoadFromSlot(slotName){try{const loadJson=await this._GetSavegamesStorage().getItem(slotName);if(!loadJson)throw new Error("empty slot");console.log("[Construct 3] Loaded state from storage ("+loadJson.length+" chars)");await this._DoLoadFromJsonString(loadJson);this._lastSaveJson=loadJson;await this.TriggerAsync(C3.Plugins.System.Cnds.OnLoadComplete,null);this._lastSaveJson=""}catch(err){console.error("[Construct 3] Failed to load state from storage: ",
err);await this.TriggerAsync(C3.Plugins.System.Cnds.OnLoadFailed,null)}}async _SaveToJsonString(){const o={"c3save":true,"version":1,"rt":{"time":this.GetGameTime(),"walltime":this.GetWallTime(),"timescale":this.GetTimeScale(),"tickcount":this.GetTickCount(),"execcount":this.GetExecCount(),"next_uid":this._nextUid,"running_layout":this.GetMainRunningLayout().GetSID(),"start_time_offset":Date.now()-this._startTime},"types":{},"layouts":{},"events":this._eventSheetManager._SaveToJson(),"timelines":this._timelineManager._SaveToJson(),
"user_script_data":null};for(const objectClass of this._allObjectClasses){if(objectClass.IsFamily()||objectClass.HasNoSaveBehavior())continue;o["types"][objectClass.GetSID().toString()]=objectClass._SaveToJson()}for(const layout of this._layoutManager.GetAllLayouts())o["layouts"][layout.GetSID().toString()]=layout._SaveToJson();const saveEvent=this._CreateUserScriptEvent("save");saveEvent.saveData=null;await this.DispatchUserScriptEventAsyncWait(saveEvent);o["user_script_data"]=saveEvent.saveData;
return JSON.stringify(o)}IsLoadingState(){return this._isLoadingState}async _DoLoadFromJsonString(jsonStr){const o=JSON.parse(jsonStr);if(o["c2save"])throw new Error("C2 saves are incompatible with C3 runtime");if(!o["c3save"])throw new Error("not valid C3 save data");if(o["version"]>1)throw new Error("C3 save data from future version");this._dispatcher.dispatchEvent(C3.New(C3.Event,"beforeload"));for(const inst of this.allInstances())inst._OnBeforeLoad();this._isLoadingState=true;const rt=o["rt"];
this._gameTime.Set(rt["time"]);this._wallTime.Set(rt["walltime"]);this._timeScale=rt["timescale"];this._tickCount=rt["tickcount"];this._execCount=rt["execcount"];this._startTime=Date.now()-rt["start_time_offset"];const layoutSid=rt["running_layout"];if(layoutSid!==this.GetMainRunningLayout().GetSID()){const changeToLayout=this._layoutManager.GetLayoutBySID(layoutSid);if(changeToLayout)await this._DoChangeLayout(changeToLayout);else return}for(const [sidStr,data]of Object.entries(o["types"])){const sid=
parseInt(sidStr,10);const objectClass=this.GetObjectClassBySID(sid);if(!objectClass||objectClass.IsFamily()||objectClass.HasNoSaveBehavior())continue;objectClass._LoadFromJson(data)}this.FlushPendingInstances();this._RefreshUidMap();this._isLoadingState=false;this._nextUid=rt["next_uid"];for(const [sidStr,data]of Object.entries(o["layouts"])){const sid=parseInt(sidStr,10);const layout=this._layoutManager.GetLayoutBySID(sid);if(!layout)continue;layout._LoadFromJson(data)}this._eventSheetManager._LoadFromJson(o["events"]);
for(const objectClass of this._allObjectClasses){if(objectClass.IsFamily()||!objectClass.IsInContainer())continue;for(const inst of objectClass.GetInstances()){const iid=inst.GetIID();for(const otherType of objectClass.GetContainer().objectTypes()){if(otherType===objectClass)continue;const otherInstances=otherType.GetInstances();if(iid<0||iid>=otherInstances.length)throw new Error("missing sibling instance");inst._AddSibling(otherInstances[iid])}}}this._timelineManager._LoadFromJson(o["timelines"]);
this._dispatcher.dispatchEvent(C3.New(C3.Event,"afterload"));const loadEvent=this._CreateUserScriptEvent("load");loadEvent.saveData=o["user_script_data"];await this.DispatchUserScriptEventAsyncWait(loadEvent);this.UpdateRender()}async AddJobWorkerScripts(scripts){const blobs=await Promise.all(scripts.map(url=>this._assetManager.FetchBlob(url)));const blobUrls=blobs.map(b=>URL.createObjectURL(b));this._jobScheduler.ImportScriptsToJobWorkers(blobUrls)}AddJobWorkerBlob(blob,id){this._jobScheduler.SendBlobToJobWorkers(blob,
id)}AddJobWorkerBuffer(buffer,id){this._jobScheduler.SendBufferToJobWorkers(buffer,id)}AddJob(type,params,transferables){return this._jobScheduler.AddJob(type,params,transferables)}BroadcastJob(type,params,transferables){return this._jobScheduler.BroadcastJob(type,params,transferables)}InvokeDownload(url,filename){this.PostComponentMessageToDOM("runtime","invoke-download",{"url":url,"filename":filename})}async RasterSvgImage(blob,imageWidth,imageHeight,surfaceWidth,surfaceHeight,imageBitmapOpts){surfaceWidth=
surfaceWidth||imageWidth;surfaceHeight=surfaceHeight||imageHeight;if(this.IsInWorker()){const result=await this.PostComponentMessageToDOMAsync("runtime","raster-svg-image",{"blob":blob,"imageWidth":imageWidth,"imageHeight":imageHeight,"surfaceWidth":surfaceWidth,"surfaceHeight":surfaceHeight,"imageBitmapOpts":imageBitmapOpts});return result["imageBitmap"]}else{const canvas=await self["C3_RasterSvgImageBlob"](blob,imageWidth,imageHeight,surfaceWidth,surfaceHeight);if(imageBitmapOpts)return await self.createImageBitmap(canvas,
imageBitmapOpts);else return canvas}}async GetSvgImageSize(blob){if(this.IsInWorker())return await this.PostComponentMessageToDOMAsync("runtime","get-svg-image-size",{"blob":blob});else return await self["C3_GetSvgImageSize"](blob)}RequestDeviceOrientationEvent(){if(this._didRequestDeviceOrientationEvent)return;this._didRequestDeviceOrientationEvent=true;this.PostComponentMessageToDOM("runtime","enable-device-orientation")}RequestDeviceMotionEvent(){if(this._didRequestDeviceMotionEvent)return;this._didRequestDeviceMotionEvent=
true;this.PostComponentMessageToDOM("runtime","enable-device-motion")}Random(){return this._randomNumberCallback()}SetRandomNumberGeneratorCallback(f){this._randomNumberCallback=f}_GetRemotePreviewStatusInfo(){return{"fps":this.GetFPS(),"cpu":this.GetMainThreadTime(),"gpu":this.GetGPUUtilisation(),"layout":this.GetMainRunningLayout()?this.GetMainRunningLayout().GetName():"","renderer":this.GetWebGLRenderer().GetUnmaskedRenderer()}}HitBreakpoint(){if(!this.IsDebug())return false;return C3Debugger.HitBreakpoint()}DebugBreak(eventObject){if(!this.IsDebugging())return Promise.resolve();
return C3Debugger.DebugBreak(eventObject)}DebugBreakNext(){if(!this.IsDebugging())return false;return C3Debugger.BreakNext()}SetDebugBreakpointsEnabled(e){this._breakpointsEnabled=!!e;this._UpdateDebuggingFlag()}AreDebugBreakpointsEnabled(){return this._breakpointsEnabled}IsDebugging(){return this._isDebugging}SetDebuggingEnabled(d){if(d)this._debuggingDisabled--;else this._debuggingDisabled++;this._UpdateDebuggingFlag()}_UpdateDebuggingFlag(){this._isDebugging=this.IsDebug()&&this._breakpointsEnabled&&
this._debuggingDisabled===0}IsCPUProfiling(){return this.IsDebug()&&C3Debugger.IsCPUProfiling()}IsGPUProfiling(){return this.IsDebug()&&this.GetWebGLRenderer().SupportsGPUProfiling()&&C3Debugger.IsGPUProfiling()}async DebugIterateAndBreak(iter){if(!iter)return;for(const breakEventObject of iter)await this.DebugBreak(breakEventObject)}DebugFireGeneratorEventAndBreak(event){return this.DebugIterateAndBreak(this._dispatcher.dispatchGeneratorEvent(event))}_InvokeFunctionFromJS(e){return this._eventSheetManager._InvokeFunctionFromJS(e["name"],
e["params"])}GetIRuntime(){return this._iRuntime}_CreateUserScriptEvent(name){const e=C3.New(C3.Event,name,false);e.runtime=this._iRuntime;return e}_InitScriptInterfaces(){const objectDescriptors={};for(const objectClass of this._allObjectClasses)objectDescriptors[objectClass.GetJsPropName()]={value:objectClass.GetIObjectClass(),enumerable:true,writable:false};const objects=Object.create(Object.prototype,objectDescriptors);this._iRuntime=new self.IRuntime(this,objects);this._userScriptEventObjects=
{"tick":this._CreateUserScriptEvent("tick")}}_InitGlobalVariableScriptInterface(){const globalVarDescriptors={};for(const globalVar of this.GetEventSheetManager().GetAllGlobalVariables())globalVarDescriptors[globalVar.GetJsPropName()]=globalVar._GetScriptInterfaceDescriptor();this._iRuntime._InitGlobalVars(globalVarDescriptors)}_GetCommonScriptInterfaces(){return this._commonScriptInterfaces}_MapScriptInterface(interface_,class_){this._interfaceMap.set(interface_,class_)}_UnwrapScriptInterface(interface_){return this._interfaceMap.get(interface_)}_UnwrapIObjectClass(iObjectClass){if(!(iObjectClass instanceof
self.IObjectClass))throw new TypeError("expected IObjectClass");const objectClass=this._UnwrapScriptInterface(iObjectClass);if(!objectClass||!(objectClass instanceof C3.ObjectClass))throw new Error("invalid IObjectClass");return objectClass}_UnwrapIWorldInstance(iinst){if(!(iinst instanceof self.IWorldInstance))throw new TypeError("expected IWorldInstance");const inst=this._UnwrapScriptInterface(iinst);if(!inst||!(inst instanceof C3.Instance))throw new Error("invalid IInstance");return inst}};self["C3_CreateRuntime"]=
C3.Runtime.Create;self["C3_InitRuntime"]=(runtime,opts)=>runtime.Init(opts)};


// c3/workers/jobSchedulerRuntime.js
'use strict';{const C3=self.C3;C3.JobSchedulerRuntime=class JobSchedulerRuntime extends C3.DefendedBase{constructor(runtime,data){super();this._runtime=runtime;this._jobPromises=new Map;this._nextJobId=0;this._inputPort=data["inputPort"];data["outputPort"].onmessage=e=>this._OnJobWorkerMessage(e);this._maxNumWorkers=data["maxNumWorkers"];this._jobWorkerCount=1;this._isCreatingWorker=false;this._hadErrorCreatingWorker=false}async Init(){}ImportScriptsToJobWorkers(scripts){this._inputPort.postMessage({"type":"_import_scripts",
"scripts":scripts})}SendBlobToJobWorkers(blob,id){this._inputPort.postMessage({"type":"_send_blob","blob":blob,"id":id})}SendBufferToJobWorkers(buffer,id){this._inputPort.postMessage({"type":"_send_buffer","buffer":buffer,"id":id},[buffer])}AddJob(type,params,transferables,progressHandler,abortDisposable){if(!transferables)transferables=[];const jobId=this._nextJobId++;const job={"type":type,"isBroadcast":false,"jobId":jobId,"params":params,"transferables":transferables};const promise=new Promise((resolve,
reject)=>{this._jobPromises.set(jobId,{resolve:resolve,progress:progressHandle